from _typeshed import Incomplete
from fwhunt_scan.uefi_protocols import GUID_FROM_BYTES as GUID_FROM_BYTES
from fwhunt_scan.uefi_tables import BS_PROTOCOLS_INFO_64_BIT as BS_PROTOCOLS_INFO_64_BIT, EFI_BOOT_SERVICES_64_BIT as EFI_BOOT_SERVICES_64_BIT, EFI_PEI_SERVICES_32_BIT as EFI_PEI_SERVICES_32_BIT, EFI_RUNTIME_SERVICES_64_BIT as EFI_RUNTIME_SERVICES_64_BIT, OFFSET_TO_SERVICE as OFFSET_TO_SERVICE
from fwhunt_scan.uefi_te import TerseExecutableError as TerseExecutableError, TerseExecutableParser as TerseExecutableParser
from fwhunt_scan.uefi_types import ChildSwSmiHandler as ChildSwSmiHandler, NvramVariable as NvramVariable, SmiHandler as SmiHandler, UefiGuid as UefiGuid, UefiProtocol as UefiProtocol, UefiProtocolGuid as UefiProtocolGuid, UefiService as UefiService
from fwhunt_scan.uefi_utils import get_current_insn_index as get_current_insn_index, get_int as get_int
from types import TracebackType
from typing import Any

class UefiAnalyzerError(Exception):
    value: Incomplete
    def __init__(self, value: str) -> None: ...

class UefiAnalyzer:
    def __init__(self, image_path: str | None = None, blob: bytes | None = None, rizinhome: str | None = None) -> None: ...
    def __enter__(self): ...
    @property
    def info(self) -> dict[Any, Any]: ...
    @property
    def strings(self) -> list[Any]: ...
    @property
    def sections(self) -> list[Any]: ...
    @property
    def functions(self) -> list[Any]: ...
    @property
    def insns(self) -> list[Any]: ...
    @property
    def g_bs(self) -> list[int]: ...
    @property
    def g_rt(self) -> list[int]: ...
    @property
    def boot_services(self) -> list[UefiService]: ...
    @property
    def boot_services_protocols(self) -> list[Any]: ...
    @property
    def runtime_services(self) -> list[UefiService]: ...
    @property
    def protocols(self) -> list[UefiProtocol]: ...
    @property
    def protocol_guids(self) -> list[UefiProtocolGuid]: ...
    def r2_get_nvram_vars_64bit(self) -> list[NvramVariable]: ...
    @property
    def nvram_vars(self) -> list[NvramVariable]: ...
    @property
    def pei_services(self) -> list[UefiService]: ...
    @property
    def ppi_list(self) -> list[UefiProtocol]: ...
    @property
    def smi_handlers(self) -> list[SmiHandler]: ...
    @property
    def child_swsmi_handlers(self) -> list[ChildSwSmiHandler]: ...
    @property
    def smst_list(self) -> list[int]: ...
    def get_summary(self) -> dict[str, Any]: ...
    def get_protocols_info(self) -> dict[str, Any]: ...
    def close(self) -> None: ...
    def __exit__(self, exc_type: type[BaseException] | None, exc_value: BaseException | None, traceback: TracebackType | None) -> None: ...
