import datetime as DT
import math

NOTCH_50 = [-0.0013025993442826542, -0.0007464190894611029, -1.4811534204409865e-05, 0.0008323010813866444, 0.0017124669697669466, 0.0025279081728558, 0.003175509444220244, 0.003558649294481106, 0.003599599963526827, 0.003251023073233176, 0.002505054400292441, 0.001398623215505874, 1.39856609713523e-05, -0.0015260587648640897, -0.0030682013283670423, -0.004443202682018534, -0.0054837026310160285, -0.006043449728389918, -0.0060158195835338674, -0.005349401161509518, -0.004058598608791784, -0.002227620612671196, -6.8773185119146195e-06, 0.0023983852944900385, 0.004746497001016689, 0.006783240447463196, 0.00826887544899355, 0.009005474629045818, 0.008861511635387408, 0.0077907586058512945, 0.005843010006619162, 0.003164922110119665, -9.730248981025037e-06, -0.0033799286103971095, -0.0066058045589402845, -0.00934289698785237, -0.01127882045081509, -0.01216844256585141, -0.011863634734570808, -0.010334066145623152, -0.007676330620220433, -0.004109855552373363, 4.057358198874877e-05, 0.004374376769379371, 0.00845415373891889, 0.011850250385784985, 0.01418633384364936, 0.015181103614759616, 0.014681502451533754, 0.012683544767953123, 0.009338086469511413, 0.004940399820266073, -9.586902470558149e-05, -0.005278077492081403, -0.01008350928539674, -0.014012913669619563, -0.01664309762803105, -0.01767295879531828, -0.016957905573672282, -0.014528729902925485, -0.010592568610108048, -0.005515449854988499, 0.00021212460013432174, 0.0060232734266459885, 0.011331699935070154, 0.01559169136510647, 0.018354898282233433, 0.019317883284149795, 0.018355319767659584, 0.015535172842633232, 0.011114055895736837, 0.0055130316932442205, -0.0007238051989174044, -0.006983790278913424, -0.012647613161286042, -0.01715229843833682, -0.020048691196411172, 0.9789525559647446, -0.020048691196411172, -0.01715229843833682, -0.012647613161286042, -0.006983790278913424, -0.0007238051989174044, 0.0055130316932442205, 0.011114055895736837, 0.015535172842633232, 0.018355319767659584, 0.019317883284149795, 0.018354898282233433, 0.01559169136510647, 0.011331699935070154, 0.0060232734266459885, 0.00021212460013432174, -0.005515449854988499, -0.010592568610108048, -0.014528729902925485, -0.016957905573672282, -0.01767295879531828, -0.01664309762803105, -0.014012913669619563, -0.01008350928539674, -0.005278077492081403, -9.586902470558149e-05, 0.004940399820266073, 0.009338086469511413, 0.012683544767953123, 0.014681502451533754, 0.015181103614759616, 0.01418633384364936, 0.011850250385784985, 0.00845415373891889, 0.004374376769379371, 4.057358198874877e-05, -0.004109855552373363, -0.007676330620220433, -0.010334066145623152, -0.011863634734570808, -0.01216844256585141, -0.01127882045081509, -0.00934289698785237, -0.0066058045589402845, -0.0033799286103971095, -9.730248981025037e-06, 0.003164922110119665, 0.005843010006619162, 0.0077907586058512945, 0.008861511635387408, 0.009005474629045818, 0.00826887544899355, 0.006783240447463196, 0.004746497001016689, 0.0023983852944900385, -6.8773185119146195e-06, -0.002227620612671196, -0.004058598608791784, -0.005349401161509518, -0.0060158195835338674, -0.006043449728389918, -0.0054837026310160285, -0.004443202682018534, -0.0030682013283670423, -0.0015260587648640897, 1.39856609713523e-05, 0.001398623215505874, 0.002505054400292441, 0.003251023073233176, 0.003599599963526827, 0.003558649294481106, 0.003175509444220244, 0.0025279081728558, 0.0017124669697669466, 0.0008323010813866444, -1.4811534204409865e-05, -0.0007464190894611029, -0.0013025993442826542]
NOTCH_60 = [0.0016098617268686518, 0.0022215955134661717, 0.0025760233459984523, 0.0025751725111365286, 0.002166282367866585, 0.001356959379346898, 0.00022192011225071221, -0.0011008500348874645, -0.002425099514464997, -0.003541189822775057, -0.004247736519471336, -0.004385420670779691, -0.003867543745153618, -0.002701907011675865, -0.0009995227365272934, 0.0010325674711901293, 0.0031147083097666567, 0.004931971957824379, 0.0061806228118847185, 0.0066169955262321565, 0.006101116824359696, 0.004627624013407976, 0.0023379905034902316, -0.0004893868379665014, -0.0034713897986758126, -0.0061712630537425015, -0.008161910520115357, -0.00909231661416781, -0.00874688045395537, -0.00708788389815919, -0.00427333364504261, -0.0006457974986087795, 0.0033078633299899584, 0.007021410518518542, 0.009930222034196263, 0.01155679032178281, 0.011587803457448406, 0.009930490068155929, 0.006738469274902607, 0.002401560610836234, -0.002500705190716607, -0.007276553032950604, -0.01122007058232174, -0.013715975892246357, -0.014335424242219445, -0.01290793240102856, -0.009557526298718134, -0.004696197085185127, 0.0010260151101057734, 0.006808417814005007, 0.01181274291747025, 0.01528579272055873, 0.016673549302277713, 0.015709342702637068, 0.012462048090485093, 0.0073358928107453755, 0.0010205063712934188, -0.005602698488921157, -0.01158499547738178, -0.016047887097616256, -0.018313550478476496, -0.018008618386265822, -0.015125294337205166, -0.010029854228085154, -0.0034162572031783828, 0.0037892569823142694, 0.010559294388178892, 0.015913330518462183, 0.019061008732760707, 0.01951949719996119, 0.017187276880691417, 0.012363001385439144, 0.005706102539264353, -0.0018555786074157393, -0.009257965941573507, -0.015453575874828485, -0.019562682229531184, 0.9789993539889272, -0.019562682229531184, -0.015453575874828485, -0.009257965941573507, -0.0018555786074157393, 0.005706102539264353, 0.012363001385439144, 0.017187276880691417, 0.01951949719996119, 0.019061008732760707, 0.015913330518462183, 0.010559294388178892, 0.0037892569823142694, -0.0034162572031783828, -0.010029854228085154, -0.015125294337205166, -0.018008618386265822, -0.018313550478476496, -0.016047887097616256, -0.01158499547738178, -0.005602698488921157, 0.0010205063712934188, 0.0073358928107453755, 0.012462048090485093, 0.015709342702637068, 0.016673549302277713, 0.01528579272055873, 0.01181274291747025, 0.006808417814005007, 0.0010260151101057734, -0.004696197085185127, -0.009557526298718134, -0.01290793240102856, -0.014335424242219445, -0.013715975892246357, -0.01122007058232174, -0.007276553032950604, -0.002500705190716607, 0.002401560610836234, 0.006738469274902607, 0.009930490068155929, 0.011587803457448406, 0.01155679032178281, 0.009930222034196263, 0.007021410518518542, 0.0033078633299899584, -0.0006457974986087795, -0.00427333364504261, -0.00708788389815919, -0.00874688045395537, -0.00909231661416781, -0.008161910520115357, -0.0061712630537425015, -0.0034713897986758126, -0.0004893868379665014, 0.0023379905034902316, 0.004627624013407976, 0.006101116824359696, 0.0066169955262321565, 0.0061806228118847185, 0.004931971957824379, 0.0031147083097666567, 0.0010325674711901293, -0.0009995227365272934, -0.002701907011675865, -0.003867543745153618, -0.004385420670779691, -0.004247736519471336, -0.003541189822775057, -0.002425099514464997, -0.0011008500348874645, 0.00022192011225071221, 0.001356959379346898, 0.002166282367866585, 0.0025751725111365286, 0.0025760233459984523, 0.0022215955134661717, 0.0016098617268686518]

prevMicros = 0
prevValue = math.inf  # By making this infinite we avoid a false positive on the first run through.

def micros() -> int:
    """Gets a microsecond timestamp in the range of [0, 6 * 10^8)."""

    time = DT.datetime.now()
    timestr = time.strftime('%S:%f')
    sec,micro = timestr.split(':')
    return int(sec) * 1e6 + int(micro)
    
def flex_check(value: int, thresholdMult: float = 1.5, cooldown: int = 400000) -> bool:
    """Determine if a flex has occurred.

    Uses a variable threshold and cooldown to both check if a flex appeared and to debounce the result.
    You will likely want to calibrate it for a specific application, but the default values are a good starting point.
    """

    global prevMicros, prevValue
    currMicros = micros()
    if currMicros < prevMicros:
        # We rolled over, micro stamp only goes up to 6 * 10^8 - 1
        delta = currMicros + (1e8 * 6) - prevMicros
    else:
        delta = currMicros - prevMicros
    
    # Check if it has been long enough for another threshold check
    if delta >= cooldown:
        # Only calculate the threshold when we know we need to check it
        threshold = thresholdMult * prevValue
        if value >= threshold: # Rising edge detection
            prevValue = value
            prevMicros = currMicros
            return True
    prevValue = value
    return False