docstring-gen
================

<!-- WARNING: THIS FILE WAS AUTOGENERATED! DO NOT EDIT! -->

<b>Instantly improve the documentation of your Python code with
Codex.</b>

------------------------------------------------------------------------

![PyPI](https://img.shields.io/pypi/v/docstring-gen.png) ![PyPI -
Downloads](https://img.shields.io/pypi/dm/docstring-gen.png) ![PyPI -
Python
Version](https://img.shields.io/pypi/pyversions/docstring-gen.png)

![GitHub Workflow
Status](https://img.shields.io/github/actions/workflow/status/airtai/docstring-gen/test.yaml)
![CodeQL](https://github.com/airtai/docstring-gen//actions/workflows/codeql.yml/badge.svg)
![Dependency
Review](https://github.com/airtai/docstring-gen//actions/workflows/dependency-review.yml/badge.svg)

![GitHub](https://img.shields.io/github/license/airtai/docstring-gen.png)

------------------------------------------------------------------------

**docstring-gen** is an easy-to-use Python library that uses
<a href = "https://beta.openai.com/docs/models/codex" target="_blank">OpenAI’s
Codex model</a> to automatically generate
<a href="https://google.github.io/styleguide/pyguide.html" target = "_blank">Google-style
docstrings</a> for Python codebase. The library is capable of reading
both Jupyter notebooks and Python files, and seamlessly adds meaningful
docstrings to classes and functions that lack documentation. By using
**docstring-gen**, developers can automatically generate docstrings for
their codebase, resulting in time savings and improved documentation
quality.

## Install

**docstring-gen** can be installed by running the command below. This
package requires Python 3.7 or higher to work.

``` shell
pip install docstring-gen
```

If the installation was successful, you should now have
**docstring-gen** installed on your system. To see a full list of
settings, run `docstring_gen --help`

If you’re excited to try the latest version, you can install it directly
from GitHub by using the command:
`pip install git+https://github.com/airtai/docstring-gen`

## How to use

The **docstring-gen** library uses OpenAI’s Codex model to generate
docstrings for your Python classes and functions. In order to use the
library, you’ll need to
<a href="https://beta.openai.com/account/api-keys" target="_blank">create
an API key for OpenAI</a>.

Once you have your API key, store it in the **OPENAI_API_KEY**
environment variable. This is a necessary step for the library to work.

To get started right away with sensible defaults, run:

``` shell
docstring_gen {source_file_or_directory}
```

This will automatically add meaningful, Google-style docstrings to the
Python classes and functions in the {source_file_or_directory} that do
not already have one.

For example, a function like below without the docstring:

``` python
def concatenate_strings(s1: str, s2: str) -> str:
    if not isinstance(s1, str) or not isinstance(s2, str):
        raise TypeError("Both arguments should be strings.")
    return s1 + s2
```

will become similar to:

``` python
def concatenate_strings(s1: str, s2: str) -> str:
    """Concatenate two strings.

    Args:
        s1: First string
        s2: Second string

    Returns:
        The concatenated string

    Raises:
        TypeError: If s1 or s2 is not a string

    !!! note

        The above docstring is autogenerated by docstring-gen library (https://docstring-gen.airt.ai)
    """
    if not isinstance(s1, str) or not isinstance(s2, str):
        raise TypeError("Both arguments should be strings.")
    return s1 + s2
```

If you wish to regenerate the docstrings, you can re-run the command
with the `-f` flag, which will remove the previous auto-generated
docstrings and replace them with new ones.

``` shell
docstring_gen {source_file_or_directory} -f
```

**Note**: The default behavior of the library is to add docstrings only
to functions and classes that are missing them. So, if you do not
provide the `-f` flag when re-running the command, the library will not
replace previously auto-generated docstrings, assuming that the
functions already have them.

If you prefer not to include the text **“autogenerated by docstring-gen
library”** in the generated docstrings, you can use the
`--no-include-auto-gen-txt` flag when running the command.

``` shell
docstring_gen {source_file_or_directory} -f --no-include-auto-gen-txt
```

Now the docstring for the above function will look similar to:

``` python
def concatenate_strings(s1: str, s2: str) -> str:
    """Concatenate two strings.

    Args:
        s1: First string
        s2: Second string

    Returns:
        The concatenated string

    Raises:
        TypeError: If s1 or s2 is not a string
    """
    if not isinstance(s1, str) or not isinstance(s2, str):
        raise TypeError("Both arguments should be strings.")
    return s1 + s2
```

**Important**: The library uses the text **“autogenerated by
docstring-gen library”** to identify which docstrings were generated by
the library. When the `--no-include-auto-gen-txt` flag is used, this
text will not be included in the generated docstrings. As a result, when
re-running the command with the `-f` flag, these docstrings will not be
replaced.”

Alternatively, you can manually delete the **“autogenerated by
docstring-gen library”** (starting from the !!! note until the end) text
from the classes and functions for which you think the auto-generated
docstring is appropriate, and then re-run the command using the `-f`
flag to update the remaining auto-generated docstrings.

In addition to the `-f` and `--no-include-auto-gen-txt` flags, you can
also customize the behavior by adjusting other parameters such as
`--model`, `--temperature`, etc., For more information on these options
and how to use them, please refer to the
<a href="https://beta.openai.com/docs/api-reference/completions/create" target="_blank">OpenAI’s
documentation</a>.

### Jupyter notebook extension

We have created a user-friendly notebook extension for the docstring-gen
library. This extension provides a convenient way to document your code
cell-by-cell, rather than having to document the entire notebook all at
once. To install the extension, simply run the following commands in
your terminal:

**Note**: Please ensure
<a href="https://jupyter-contrib-nbextensions.readthedocs.io/en/latest/install.html" target="_blank">jupyter-contrib-nbextensions</a>.
is installed before installing the docstring-gen library extension

``` shell
jupyter nbextension install https://github.com/airtai/jupyter-docstring-gen/archive/main.zip --user
jupyter nbextension enable jupyter-docstring-gen-main/jupyter-docstring-gen
```

After successful installation, you will see a new button on your jupyter
notebook toolbar. This button allows you to easily generate docstrings
for your Python code and improve your documentation.

![](https://raw.githubusercontent.com/airtai/docstring-gen/main/nbs/images/docstring-gen-extension-btn.png)

For more detailed information, please refer to this
<a href="https://github.com/airtai/jupyter-docstring-gen" target="_blank">link</a>.

## Copyright

Copyright © 2023 onwards airt technologies ltd, Inc.

## License

This project is licensed under the terms of the
<a href="https://github.com/airtai/docstring-gen/blob/main/LICENSE" target="_blank">Apache
License 2.0</a>
