import codecs

digit='0123456789abcdef'
nums={
    '0':0,'1':1,'2':2,'3':3,
    '4':4,'5':5,'6':6,'7':7,
    '8':8,'9':9,'a':10,'b':11,
    'c':12,'d':13,'e':14,'f':15
}

# standard.txt sha256: 1f7e2f657413a5486580a6ce008cf1edc36215af69581c07f9e8e1f921cee04f
# 以下5行的sha256 (前面没有换行符, 最后有一个换行符): d62fd05a5d8de0d961ea0a0afb503df6d5d747d53a1fb71ab5b95dd7a4f261de
multi512='f374d86d15749d3c334e0999ad27309ddb575d86a1f20b914c50993733e1224f9af69ca136230331683ebb06a59740c3fb3d57ee2b27d3df67d35ccdd83117908305f4e7f78ec0cb1304594ae118094bca1141cad5e3b17343f8e635292a22d1'
pre512='b90a4c8b2a9a42c74e2544f84568eac7b476697fb1fdc7be1fc5244b4f2fff9334207cf47e50b950dbb56bb5967b31f4657339107593c423d746f9f266c5c555'
multi256=['80e4bd68d60f0e26183c54b50543738b52fdb6aa674a56e2595a0aa66f6b9350a7016653b3532a0841f8a2f3be548af66f8dfa17cedd6c16d11ce70e463a6449', '1c5fc39a71b96caac09750518cbeaf7884271e89bcf7cebf13e18462590c79cff166d3b42fd9f9741a6dd072afb59b4b849ec1841a30739cc72f863c34005051', 'a6b9b24aeddf9f300b1c7f4f2c1697d5c71d342e40d45742ca04af0e06187d74beb9548b1c360cf24b5bc667d82d67c5afcb81818574355e66f5123807dcae4d', '5ac416b71e3439db588aa72da024c2b808cc294b2ced69092e27db9dc7da150ff4338a81b88a70d5662e327e3fb0ac5d6c8657c03085681c81ae4485840abebf', '18bb539bbe74275fcecf4e01344af184453e61490c54e016c9ca1820bef8b0b6f7491b92604919325602edb2db36101a743fe769bc9bc0a9ff5af90ead8e85c9', 'd988fd157be6815cd44b37deb4332e552d4e1334506ce8b6ad4c979013b2e5d8275eac34dca6e27b31462b0512902e671815e0635cc6751b78b8bc415970b4a1', 'd24c3e5c7cc6a6524baf0e48e45d2cd6c87eb667dd5c1976594db5b1af0cbf395d8f87c8b926949676b55a324f0129e011a7175fc175ad0522fc4ae3d8e85c1d', '2f1b337c9b6d32808e9c8ab0f101886d748bcfaa5e314d7d9bba07226417cba3b7fb6d7a9fdc64433fe2ab3f7c5fe83817f5bc22b0943a2c7ca3fde5aa945e6b', 'c291c661fb4a864dc346d84bf0ebd1476bae80485bc0d57b9bedca55e607bfcf293dcc9e81446e3bb6685dcd5ad6dc9625b0f92ce053d4e31ce2968f1957e31b', '885bd764f0406667c4d2e3b156648ee65addb2b03db06c95f0edff0d4a90d12a5ad268ad1b01bd12969511d34607145784f07367900aa5f292fb7a5abfd6c76f', '5e4de0bc3d786c16072f814c4989eae9817f891026291673504f1592dd1e9b593d3db4385c4ea63050682ba5fd3446dc1f290f4375380cd0ea4ea8cb4d68493b', 'ca532cdd0ec78128ec05e1893e303e9961083ce8b6a808c81d22333e30ed7f25ff80b9bc189e1726d30b9e733fe1e9f9efa2dc3340fc40915621232c9afd6b85', 'd63a443388c5b4cf2ef773e0edd945cd4ff90663816aade0e27d671f8178e3a7b16159368f99556f4efce543f28cbb847a95a9bcc50343fd627606a575087205', '6964fe9dcd5557ba4f969de99c489b6d67bfea2f663403ef9ac90b28f9cad7fc54508bf86ec1d80c314140e4a86327c83fd57b8ddf282ee6d7e171ef1903c827', 'bd90f4ac3bb35e6ae2cbeb433057540969fe330a4eeece1d470c0208a3e2400b54dec59cb5172c16d6be9a199ff2339758a61d6a3ff2534e353381fee3005305', 'fab56a6459ccedf6c8bd198bcfa92594c7f3e8febe131c8e6e5b424f4a63dc61897b58e5f3d32351f5eec61ad13af31d3751fa6b1db3a5aa475d3282ee1bfb41', 'c4d294e761bad6e59403b83ebdab28ceecc905dd61978e9c0946c7c9fb7e59cb2cd93527dff1a28b797494a8233ed00a5642e5c9254eaca9692cb2792f1eb991', '761bb26e2b091d0ff122edcd144a0890c3fa7404866a09ee67b7c7e8cd8834aed2b4d9b1fba6646be0317f0e0b2d2eab74a13737b28847b0b508267a5e6ee23f', 'f7736031a6d71fefe817ef3a5b5763df263dd8da5a20bd427fb9118059d2fd5e41da240305c473ee6bd8abf56f1c94a20ea84b42eb2cf711fd850987b649c803', '1021d3ff49d4abfcffb7fb0145e64b1e7641720c65a962df5524525a19a75731770a629d9d52cf65081d6026e2f7cffcd08f9496b7643819f47187c170feb7d3']
pre256=['da21a74137e68e895b86608dcb863d0a28a11b332a100616c92775bbafee07e3', '4cdba6434440b6cbef1f0582f86c74ca1c3af43f89ab2b0808281fb3afec3999', 'd331adfbcd856b426bf1777911c0a6d987c234fd515810c08917df6d392a17e5', 'b9de6a6b5a972a8509fbd8d459ef61c8004cead6d8c9d8300a546a09453abeef', '0e0c9f63be7a1cf4759fa905eec4b95a623eb300d7a3d519785495444a5f8a36', 'fdbc8e542c1495be0bacebb3857125165f0501e83cf8e8bf8ae78e3f5f16667e', 'c63876c4fc3a7b670093bf26e5263389cd5d7180acc85947af6469440d2e159d', '729040b3a50da0061ed20ae745adb4bcf73427c3b16b5442497d44c1833eb680', 'd04a2c1d74d52223bf2c1582e8cd5fb2f495a109e6ca69161187208ac676bb08', '3e178e197090f24b18ca84f8f11b9b2172a305da0b2f2542a62954286f011c5a', '02a01f8a24ee1a201a4c2acff12e5033fdd7a60be48b61fd42a22021b55ca4a0', '7026d75cf7cf077c14f4cb99e4cc36a98e07bc06ee2a9581962f67ce6e7f7fff', 'a9bee059df0e129442436c8d4a6b9699f33d7383e5c10db3cab43abbc84725a0', 'de7939effaf4e73644708fd1176892dedee9fb8735a5f0f40f532c0e2fc82bd7', 'f954f2fa789e7f0eadde5d191b538b52d3c102a13fb899bd2c6ab4293eba3cf3', '6d56daf490da8996a74580d8b003400c210076336aad82e8c0ad5b6a174d08b7', '09c4b8e6856b6afada72624ca22dc42c2aa7926689b1e3ded118622d22b604bd', '0f75455865761856e75ca880ba325b8749470f655306b3f2ce147e8a96636fb6', 'ea1603f49c1081608d42b57eca32114c042c42648d5b81b2cf6bc13f8909930b', '82250c9af4ad754e6d11b82a556452462732b43017b52a9e806db944ff15dfc8']
orders=[[1, 29, 47, 56, 40, 52, 61, 17, 33, 58, 4, 7, 5, 53, 45, 37, 27, 59, 30, 39, 44, 51, 25, 31, 50, 10, 62, 13, 63, 8, 24, 20, 21, 54, 35, 55, 43, 19, 42, 9, 28, 14, 16, 41, 2, 15, 6, 48, 36, 18, 12, 26, 57, 46, 11, 32, 60, 38, 49, 23, 3, 34, 22, 0], [19, 2, 40, 57, 63, 24, 55, 28, 44, 15, 10, 29, 39, 33, 41, 59, 35, 23, 46, 9, 12, 13, 5, 0, 54, 62, 17, 43, 4, 16, 52, 11, 21, 20, 34, 56, 14, 60, 49, 18, 25, 27, 22, 32, 8, 42, 36, 61, 50, 51, 58, 38, 45, 47, 6, 31, 30, 3, 37, 7, 1, 53, 48, 26], [42, 56, 20, 23, 30, 2, 39, 12, 51, 34, 28, 38, 27, 11, 40, 45, 58, 25, 41, 1, 26, 52, 6, 61, 22, 60, 13, 43, 10, 14, 59, 21, 54, 31, 5, 8, 36, 3, 4, 7, 49, 16, 48, 47, 29, 35, 18, 53, 37, 0, 44, 19, 46, 55, 32, 17, 62, 57, 24, 33, 9, 63, 50, 15], [52, 1, 43, 10, 59, 21, 12, 33, 56, 61, 6, 30, 27, 44, 29, 48, 23, 7, 11, 40, 15, 34, 50, 2, 14, 62, 4, 57, 36, 32, 28, 60, 42, 58, 31, 24, 53, 16, 3, 19, 13, 5, 8, 46, 63, 39, 20, 9, 47, 45, 51, 38, 18, 17, 0, 37, 22, 35, 41, 25, 49, 54, 55, 26], [60, 49, 22, 39, 4, 7, 47, 15, 16, 50, 1, 26, 54, 36, 11, 13, 32, 40, 31, 10, 63, 18, 34, 19, 3, 43, 57, 59, 52, 48, 21, 27, 8, 44, 46, 55, 38, 51, 45, 30, 6, 61, 33, 17, 0, 35, 25, 20, 23, 2, 5, 56, 37, 42, 24, 58, 9, 29, 53, 12, 28, 14, 41, 62], [2, 14, 40, 26, 23, 15, 17, 48, 46, 3, 30, 24, 61, 44, 43, 10, 57, 59, 62, 6, 28, 1, 32, 53, 20, 52, 55, 38, 35, 54, 9, 19, 63, 27, 34, 31, 41, 11, 45, 60, 51, 50, 49, 8, 29, 12, 22, 18, 33, 37, 7, 42, 47, 4, 5, 25, 21, 58, 0, 56, 39, 36, 13, 16], [62, 4, 19, 33, 8, 51, 16, 56, 52, 12, 59, 48, 10, 39, 63, 32, 0, 6, 23, 5, 17, 36, 2, 3, 11, 60, 15, 38, 29, 57, 43, 1, 44, 40, 42, 7, 14, 55, 9, 50, 25, 58, 47, 30, 13, 54, 31, 49, 46, 37, 34, 22, 27, 28, 45, 20, 61, 53, 26, 18, 24, 41, 21, 35], [15, 25, 29, 5, 57, 39, 7, 60, 36, 18, 43, 21, 61, 23, 46, 10, 41, 42, 31, 34, 30, 2, 52, 16, 19, 33, 50, 32, 26, 17, 11, 55, 20, 8, 38, 47, 37, 48, 1, 13, 45, 51, 27, 63, 24, 0, 6, 62, 40, 54, 3, 35, 58, 49, 22, 9, 59, 14, 44, 12, 56, 4, 28, 53], [12, 16, 49, 6, 20, 7, 30, 26, 41, 50, 5, 27, 59, 47, 24, 25, 42, 13, 44, 11, 32, 36, 23, 37, 4, 29, 14, 62, 56, 28, 48, 19, 52, 45, 34, 10, 38, 55, 43, 46, 22, 51, 40, 39, 54, 15, 1, 31, 9, 3, 63, 21, 2, 33, 61, 58, 8, 60, 0, 53, 17, 57, 35, 18], [30, 51, 50, 47, 55, 43, 21, 29, 15, 18, 13, 36, 46, 39, 1, 33, 7, 0, 20, 11, 42, 12, 41, 8, 38, 3, 60, 16, 28, 63, 40, 14, 35, 6, 49, 54, 10, 26, 44, 4, 48, 57, 53, 58, 9, 5, 19, 34, 56, 27, 2, 22, 25, 52, 17, 61, 37, 59, 32, 45, 62, 31, 23, 24], [7, 5, 61, 51, 0, 50, 16, 2, 39, 44, 18, 1, 23, 43, 58, 6, 34, 47, 32, 8, 57, 15, 26, 30, 31, 14, 12, 19, 11, 60, 49, 62, 3, 56, 54, 55, 48, 36, 53, 9, 38, 41, 27, 20, 21, 42, 40, 25, 29, 52, 59, 33, 63, 35, 17, 22, 46, 45, 4, 37, 28, 13, 10, 24], [10, 60, 41, 19, 33, 59, 3, 44, 36, 47, 45, 50, 35, 34, 12, 17, 53, 26, 7, 4, 14, 40, 56, 20, 55, 28, 22, 46, 15, 51, 0, 30, 6, 49, 42, 63, 62, 54, 2, 31, 61, 24, 38, 39, 8, 27, 58, 23, 52, 16, 25, 11, 48, 1, 5, 18, 57, 43, 32, 21, 13, 29, 9, 37], [5, 9, 24, 34, 7, 51, 1, 29, 2, 14, 42, 33, 62, 40, 37, 58, 57, 39, 36, 55, 46, 20, 50, 16, 3, 59, 48, 27, 4, 32, 38, 18, 30, 8, 53, 35, 41, 17, 43, 60, 54, 56, 11, 13, 31, 61, 12, 28, 0, 25, 23, 49, 47, 19, 26, 6, 44, 22, 52, 45, 15, 21, 63, 10], [58, 56, 31, 35, 29, 55, 3, 20, 18, 14, 52, 38, 53, 62, 30, 10, 47, 28, 36, 16, 5, 15, 37, 42, 41, 26, 46, 32, 51, 27, 63, 7, 8, 0, 24, 49, 1, 39, 4, 59, 22, 57, 43, 19, 11, 6, 48, 9, 61, 34, 60, 23, 50, 44, 33, 45, 12, 25, 40, 2, 17, 54, 21, 13], [10, 0, 36, 60, 23, 3, 59, 4, 2, 17, 28, 47, 58, 49, 29, 39, 38, 33, 44, 18, 7, 1, 6, 48, 40, 5, 12, 55, 11, 53, 57, 63, 37, 45, 21, 54, 35, 32, 9, 62, 26, 52, 46, 19, 24, 61, 31, 16, 43, 42, 30, 20, 56, 25, 27, 15, 22, 51, 14, 8, 41, 13, 34, 50], [6, 63, 62, 10, 56, 50, 22, 41, 58, 19, 52, 36, 23, 51, 44, 48, 38, 60, 46, 34, 40, 32, 20, 4, 28, 37, 14, 3, 24, 54, 59, 21, 18, 45, 33, 53, 57, 13, 16, 17, 25, 27, 11, 42, 43, 7, 55, 31, 0, 39, 29, 9, 61, 35, 2, 30, 15, 47, 8, 49, 12, 5, 26, 1], [28, 45, 59, 56, 60, 54, 38, 14, 3, 63, 49, 20, 6, 53, 9, 48, 35, 27, 33, 19, 12, 34, 5, 36, 40, 47, 58, 50, 22, 8, 7, 31, 11, 15, 43, 2, 10, 18, 29, 17, 55, 16, 0, 23, 4, 44, 42, 30, 41, 26, 37, 62, 51, 25, 13, 52, 61, 21, 24, 32, 1, 39, 46, 57], [9, 59, 10, 52, 60, 56, 1, 0, 2, 33, 50, 51, 48, 24, 25, 41, 29, 53, 12, 62, 49, 19, 44, 13, 47, 5, 17, 40, 35, 32, 63, 4, 43, 45, 15, 37, 36, 57, 31, 42, 3, 55, 26, 28, 22, 61, 27, 16, 23, 34, 30, 14, 6, 54, 7, 21, 58, 39, 11, 18, 8, 46, 20, 38], [56, 58, 41, 15, 38, 42, 18, 33, 27, 40, 51, 12, 37, 6, 55, 60, 31, 17, 14, 35, 0, 62, 13, 16, 45, 48, 5, 2, 24, 7, 53, 49, 47, 29, 36, 23, 30, 28, 10, 39, 20, 3, 43, 1, 4, 46, 32, 57, 25, 61, 34, 19, 63, 44, 52, 54, 26, 8, 50, 11, 59, 9, 21, 22], [19, 59, 0, 57, 42, 29, 41, 31, 51, 52, 45, 37, 12, 40, 30, 16, 13, 5, 3, 36, 27, 24, 28, 38, 50, 49, 53, 55, 1, 46, 32, 8, 2, 35, 44, 61, 4, 33, 9, 23, 56, 54, 21, 20, 63, 7, 18, 48, 15, 22, 11, 10, 47, 60, 62, 34, 58, 43, 25, 26, 39, 6, 14, 17]]


def toHex(text:str):
    text=text.encode('utf-8')
    return codecs.encode(text,'hex').decode('utf-8')


def getSum(s1:str,s2:str):
    global nums,digit
    s3=''
    for i in range(0,len(s1)):
        s3=s3+digit[(nums[s1[i]]+nums[s2[i]])%16]
    return s3


def times(n1:str,n2:str):
    l=len(n1)+len(n2)
    n1=int('0x'+n1,16)
    n2=int('0x'+n2,16)
    n=n1*n2
    n=hex(n)[2:]
    if(len(n)<l):
        n='0'*(l-len(n))+n
    return n



def hash256(text:str): # 从256位生成256位
    global pre256,multi256,orders
    sum='0'*64
    for i in range(0,20):
        t2=getSum(text,pre256[i])
        t3=''
        for j in range(0,64):
            t3=t3+t2[orders[i][j]]
        t4=times(t3,multi256[i])[64:128]
        t5=''
        for j in range(0,64):
            t5=t5+t4[orders[i][j]]
        sum=getSum(sum,t5)
    return sum


def from512to256(text:str):
    global pre512,multi512
    return times(multi512,getSum(pre512,text))[128:192]



def to256(text:str):
    l=len(text)%128
    if(l>0):
        text='0'*(128-l)+text
    while(len(text)>=128):
        if(len(text)%128==64):
            text='0'*64+text
        n=len(text)//128
        text2=''
        for i in range(0,n):
            text2=text2+from512to256(text[128*i:128*(i+1)])
        text=text2
    return text



def getHash(text:str):
    text=toHex(text)
    text=text+str(len(text))
    text2=to256(text)
    return hash256(text2)



# 1234: 712c89e362afe587a41bbfc1847f4ca68f23b1811d2bc881fd24eb73ca12e6cc
# 12345678: 83c64e14735e791027dec9c17435fe66924f236ebe37ba305fd27e532a185ff3



