"""
    SatNOGS Network

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 0.0.0
    Contact: dev@satnogs.org
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from satnogsnetworkapiclient.api_client import ApiClient, Endpoint as _Endpoint
from satnogsnetworkapiclient.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from satnogsnetworkapiclient.model.new_observation import NewObservation
from satnogsnetworkapiclient.model.observation import Observation
from satnogsnetworkapiclient.model.paginated_observation_list import PaginatedObservationList
from satnogsnetworkapiclient.model.patched_observation import PatchedObservation
from satnogsnetworkapiclient.model.update_observation import UpdateObservation


class ObservationsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.observations_create_endpoint = _Endpoint(
            settings={
                'response_type': (NewObservation,),
                'auth': [
                    'tokenAuth'
                ],
                'endpoint_path': '/api/observations/',
                'operation_id': 'observations_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'new_observation',
                ],
                'required': [
                    'new_observation',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'new_observation':
                        (NewObservation,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'new_observation': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json',
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.observations_list_endpoint = _Endpoint(
            settings={
                'response_type': (PaginatedObservationList,),
                'auth': [
                    'tokenAuth'
                ],
                'endpoint_path': '/api/observations/',
                'operation_id': 'observations_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'end',
                    'ground_station',
                    'id',
                    'observation_id',
                    'observer',
                    'page',
                    'satellite__norad_cat_id',
                    'start',
                    'status',
                    'transmitter_mode',
                    'transmitter_type',
                    'transmitter_uuid',
                    'vetted_status',
                    'vetted_user',
                    'waterfall_status',
                ],
                'required': [],
                'nullable': [
                    'waterfall_status',
                ],
                'enum': [
                    'status',
                    'transmitter_type',
                    'vetted_status',
                    'waterfall_status',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('status',): {

                        "NULL": null,
                        "NULL": null,
                        "NULL": null,
                        "NULL": null,
                        "NULL": null
                    },
                    ('transmitter_type',): {

                        "TRANSCEIVER": "Transceiver",
                        "TRANSMITTER": "Transmitter",
                        "TRANSPONDER": "Transponder"
                    },
                    ('vetted_status',): {

                        "NULL": null,
                        "NULL": null,
                        "NULL": null,
                        "NULL": null
                    },
                    ('waterfall_status',): {
                        'None': None,
                        "FALSE": "false",
                        "FALSE": "false"
                    },
                },
                'openapi_types': {
                    'end':
                        (datetime,),
                    'ground_station':
                        (int,),
                    'id':
                        (int,),
                    'observation_id':
                        ([int],),
                    'observer':
                        (int,),
                    'page':
                        (int,),
                    'satellite__norad_cat_id':
                        (int,),
                    'start':
                        (datetime,),
                    'status':
                        (int,),
                    'transmitter_mode':
                        (str,),
                    'transmitter_type':
                        (str,),
                    'transmitter_uuid':
                        (str,),
                    'vetted_status':
                        (int,),
                    'vetted_user':
                        (int,),
                    'waterfall_status':
                        (bool, none_type,),
                },
                'attribute_map': {
                    'end': 'end',
                    'ground_station': 'ground_station',
                    'id': 'id',
                    'observation_id': 'observation_id',
                    'observer': 'observer',
                    'page': 'page',
                    'satellite__norad_cat_id': 'satellite__norad_cat_id',
                    'start': 'start',
                    'status': 'status',
                    'transmitter_mode': 'transmitter_mode',
                    'transmitter_type': 'transmitter_type',
                    'transmitter_uuid': 'transmitter_uuid',
                    'vetted_status': 'vetted_status',
                    'vetted_user': 'vetted_user',
                    'waterfall_status': 'waterfall_status',
                },
                'location_map': {
                    'end': 'query',
                    'ground_station': 'query',
                    'id': 'query',
                    'observation_id': 'query',
                    'observer': 'query',
                    'page': 'query',
                    'satellite__norad_cat_id': 'query',
                    'start': 'query',
                    'status': 'query',
                    'transmitter_mode': 'query',
                    'transmitter_type': 'query',
                    'transmitter_uuid': 'query',
                    'vetted_status': 'query',
                    'vetted_user': 'query',
                    'waterfall_status': 'query',
                },
                'collection_format_map': {
                    'observation_id': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.observations_partial_update_endpoint = _Endpoint(
            settings={
                'response_type': (Observation,),
                'auth': [
                    'tokenAuth'
                ],
                'endpoint_path': '/api/observations/{id}/',
                'operation_id': 'observations_partial_update',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'patched_observation',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                    'patched_observation':
                        (PatchedObservation,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                    'patched_observation': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json',
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.observations_retrieve_endpoint = _Endpoint(
            settings={
                'response_type': (Observation,),
                'auth': [
                    'tokenAuth'
                ],
                'endpoint_path': '/api/observations/{id}/',
                'operation_id': 'observations_retrieve',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.observations_update_endpoint = _Endpoint(
            settings={
                'response_type': (UpdateObservation,),
                'auth': [
                    'tokenAuth'
                ],
                'endpoint_path': '/api/observations/{id}/',
                'operation_id': 'observations_update',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'update_observation',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                    'update_observation':
                        (UpdateObservation,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                    'update_observation': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json',
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )

    def observations_create(
        self,
        new_observation,
        **kwargs
    ):
        """observations_create  # noqa: E501

        Creates observations from a list of observation data  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.observations_create(new_observation, async_req=True)
        >>> result = thread.get()

        Args:
            new_observation (NewObservation):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            NewObservation
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['new_observation'] = \
            new_observation
        return self.observations_create_endpoint.call_with_http_info(**kwargs)

    def observations_list(
        self,
        **kwargs
    ):
        """observations_list  # noqa: E501

        SatNOGS Network Observation API view class  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.observations_list(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            end (datetime): [optional]
            ground_station (int): [optional]
            id (int): [optional]
            observation_id ([int]): Multiple values may be separated by commas.. [optional]
            observer (int): observer. [optional]
            page (int): A page number within the paginated result set.. [optional]
            satellite__norad_cat_id (int): [optional]
            start (datetime): [optional]
            status (int): [optional]
            transmitter_mode (str): [optional]
            transmitter_type (str): [optional]
            transmitter_uuid (str): [optional]
            vetted_status (int): Vetted status (deprecated: please use Status). [optional]
            vetted_user (int): Vetted user (deprecated: will be removed in next version). [optional]
            waterfall_status (bool, none_type): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            PaginatedObservationList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.observations_list_endpoint.call_with_http_info(**kwargs)

    def observations_partial_update(
        self,
        id,
        **kwargs
    ):
        """observations_partial_update  # noqa: E501

        SatNOGS Network Observation API view class  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.observations_partial_update(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (int): A unique integer value identifying this observation.

        Keyword Args:
            patched_observation (PatchedObservation): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Observation
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['id'] = \
            id
        return self.observations_partial_update_endpoint.call_with_http_info(**kwargs)

    def observations_retrieve(
        self,
        id,
        **kwargs
    ):
        """observations_retrieve  # noqa: E501

        SatNOGS Network Observation API view class  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.observations_retrieve(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (int): A unique integer value identifying this observation.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Observation
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['id'] = \
            id
        return self.observations_retrieve_endpoint.call_with_http_info(**kwargs)

    def observations_update(
        self,
        id,
        **kwargs
    ):
        """observations_update  # noqa: E501

        Updates observation with audio, waterfall or demoded data  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.observations_update(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (int): A unique integer value identifying this observation.

        Keyword Args:
            update_observation (UpdateObservation): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            UpdateObservation
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['id'] = \
            id
        return self.observations_update_endpoint.call_with_http_info(**kwargs)

