#  -*- coding: utf-8 -*-


from typing import Tuple

####################
# CORE             #
####################

# SECURITY WARNING: don't run with debug turned on in production!
DEBUG: bool = False

# Email address that error messages come from.
SERVER_EMAIL: str = "root@localhost"

# List of strings representing installed apps.
INSTALLED_APPS: Tuple[str, ...] = ()

#########
# CACHE #
#########

# The cache backends to use.
CACHES = {
    "default": {
        "BACKEND": "RoundBox.core.cache.backends.locmem.LocMemCache",
    }
}
CACHE_MIDDLEWARE_KEY_PREFIX = ""
CACHE_MIDDLEWARE_SECONDS = 600
CACHE_MIDDLEWARE_ALIAS = "default"

###########
# LOGGING #
###########

# The callable to use to configure logging
LOGGING_CONFIG = "logging.config.dictConfig"

# Custom logging configuration.
LOGGING = {}

#################
# SYSTEM CHECKS #
#################

# List of all issues generated by system checks that should be silenced. Light
# issues like warnings, infos or debugs will not generate a message. Silencing
# serious issues like errors and critical does not result in hiding the
# message, but RoundBox will not stop you from e.g. running server.
SILENCED_SYSTEM_CHECKS = []
