"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.app = void 0;
const ec2 = require("@aws-cdk/aws-ec2");
const ecr = require("@aws-cdk/aws-ecr");
const ecs = require("@aws-cdk/aws-ecs");
const cdk = require("@aws-cdk/core");
const batch = require("../lib/");
exports.app = new cdk.App();
const stack = new cdk.Stack(exports.app, 'batch-stack');
const vpc = new ec2.Vpc(stack, 'vpc');
const launchTemplate = new ec2.CfnLaunchTemplate(stack, 'ec2-launch-template', {
    launchTemplateName: 'EC2LaunchTemplate',
    launchTemplateData: {
        blockDeviceMappings: [
            {
                deviceName: '/dev/xvdcz',
                ebs: {
                    encrypted: true,
                    volumeSize: 100,
                    volumeType: 'gp2',
                },
            },
        ],
    },
});
new batch.JobQueue(stack, 'batch-job-queue', {
    computeEnvironments: [
        {
            computeEnvironment: new batch.ComputeEnvironment(stack, 'batch-unmanaged-compute-env', {
                managed: false,
            }),
            order: 1,
        },
        {
            computeEnvironment: new batch.ComputeEnvironment(stack, 'batch-demand-compute-env-launch-template', {
                managed: true,
                computeResources: {
                    type: batch.ComputeResourceType.ON_DEMAND,
                    vpc,
                    launchTemplate: {
                        launchTemplateName: launchTemplate.launchTemplateName,
                    },
                },
            }),
            order: 2,
        },
        {
            computeEnvironment: new batch.ComputeEnvironment(stack, 'batch-spot-compute-env', {
                managed: true,
                computeResources: {
                    type: batch.ComputeResourceType.SPOT,
                    vpc,
                    bidPercentage: 80,
                },
            }),
            order: 3,
        },
    ],
});
const repo = new ecr.Repository(stack, 'batch-job-repo');
new batch.JobDefinition(stack, 'batch-job-def-from-ecr', {
    container: {
        image: new ecs.EcrImage(repo, 'latest'),
    },
});
new batch.JobDefinition(stack, 'batch-job-def-from-', {
    container: {
        image: ecs.ContainerImage.fromRegistry('docker/whalesay'),
    },
});
//# sourceMappingURL=data:application/json;base64,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