"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.pruneAndTransformRecord = void 0;
/**
 * Removes keys from the given record that are undefined and transforms the defined values with the given function.
 * @param record String map to prune and transform
 * @param transform Method for transforming defined values
 * @returns A pruned and transformed version of the given record
 */
function pruneAndTransformRecord(record, transform) {
    const result = {};
    for (const key of Object.keys(record)) {
        const value = record[key];
        if (value === undefined) {
            continue;
        }
        result[key] = transform(value);
    }
    return result;
}
exports.pruneAndTransformRecord = pruneAndTransformRecord;
;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicHJ1bmUtYW5kLXRyYW5zZm9ybS1yZWNvcmQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvdXRpbHMvcHJ1bmUtYW5kLXRyYW5zZm9ybS1yZWNvcmQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBRUE7Ozs7O0dBS0c7QUFDSCxTQUFnQix1QkFBdUIsQ0FBSSxNQUFvRCxFQUFFLFNBQ25FO0lBQzVCLE1BQU0sTUFBTSxHQUFzQixFQUFFLENBQUM7SUFDckMsS0FBSyxNQUFNLEdBQUcsSUFBSSxNQUFNLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxFQUFFO1FBQ3JDLE1BQU0sS0FBSyxHQUFHLE1BQU0sQ0FBQyxHQUFHLENBQUMsQ0FBQztRQUMxQixJQUFJLEtBQUssS0FBSyxTQUFTLEVBQUU7WUFBRSxTQUFTO1NBQUU7UUFDdEMsTUFBTSxDQUFDLEdBQUcsQ0FBQyxHQUFHLFNBQVMsQ0FBQyxLQUFLLENBQUMsQ0FBQztLQUNoQztJQUNELE9BQU8sTUFBTSxDQUFDO0FBQ2hCLENBQUM7QUFURCwwREFTQztBQUFBLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBJR2VuZXJpY1ZhcmlhYmxlIH0gZnJvbSAnLi4vaW50ZXJmYWNlL3ZhcmlhYmxlcy92YXJpYWJsZSc7XG5cbi8qKlxuICogUmVtb3ZlcyBrZXlzIGZyb20gdGhlIGdpdmVuIHJlY29yZCB0aGF0IGFyZSB1bmRlZmluZWQgYW5kIHRyYW5zZm9ybXMgdGhlIGRlZmluZWQgdmFsdWVzIHdpdGggdGhlIGdpdmVuIGZ1bmN0aW9uLlxuICogQHBhcmFtIHJlY29yZCBTdHJpbmcgbWFwIHRvIHBydW5lIGFuZCB0cmFuc2Zvcm1cbiAqIEBwYXJhbSB0cmFuc2Zvcm0gTWV0aG9kIGZvciB0cmFuc2Zvcm1pbmcgZGVmaW5lZCB2YWx1ZXNcbiAqIEByZXR1cm5zIEEgcHJ1bmVkIGFuZCB0cmFuc2Zvcm1lZCB2ZXJzaW9uIG9mIHRoZSBnaXZlbiByZWNvcmRcbiAqL1xuZXhwb3J0IGZ1bmN0aW9uIHBydW5lQW5kVHJhbnNmb3JtUmVjb3JkPFQ+KHJlY29yZDogUmVjb3JkPHN0cmluZywgSUdlbmVyaWNWYXJpYWJsZSB8IHVuZGVmaW5lZD4sIHRyYW5zZm9ybTpcbihpbnB1dDogSUdlbmVyaWNWYXJpYWJsZSkgPT4gVCk6IFJlY29yZDxzdHJpbmcsIFQ+IHtcbiAgY29uc3QgcmVzdWx0OiBSZWNvcmQ8c3RyaW5nLCBUPiA9IHt9O1xuICBmb3IgKGNvbnN0IGtleSBvZiBPYmplY3Qua2V5cyhyZWNvcmQpKSB7XG4gICAgY29uc3QgdmFsdWUgPSByZWNvcmRba2V5XTtcbiAgICBpZiAodmFsdWUgPT09IHVuZGVmaW5lZCkgeyBjb250aW51ZTsgfVxuICAgIHJlc3VsdFtrZXldID0gdHJhbnNmb3JtKHZhbHVlKTtcbiAgfVxuICByZXR1cm4gcmVzdWx0O1xufTsiXX0=