"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PsModuleSimulation = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const command_simulation_base_1 = require("./command-simulation-base");
class PsModuleSimulation extends command_simulation_base_1.CommandSimulationBase {
    constructor(step, props) {
        super();
        this.step = step;
        this.props = props;
    }
    /**
     * Installs the module specified by source then runs the specified commands
     */
    executeStep(inputs) {
        // TODO what should we enclose the string with if it contains both ' and "
        const resolvedSource = this.step.source.resolve(inputs);
        const quote = resolvedSource.includes("\'") ? '\"' : '\'';
        let commands = this.buildCommands(resolvedSource, inputs);
        this.props.environment.run(`pwsh -c ${quote}${commands}${quote}`);
    }
    buildCommands(resolvedSource, inputs) {
        let commands = `Expand-Archive -Path ${resolvedSource} -DestinationPath (Join-Path -Path (Get-Item ${resolvedSource}).DirectoryName -ChildPath (Get-Item ${resolvedSource}).BaseName) -Force ; \
        Set-Location -Path (Join-Path -Path (Get-Item ${resolvedSource}).DirectoryName -ChildPath (Get-Item ${resolvedSource}).BaseName) ; \
        Remove-Item -Path package -Recurse -Force ; \
        Remove-Item -Path _rels -Recurse -Force ; \
        Remove-Item -LiteralPath [Content_Types].xml -Force ; \
        Remove-Item -Path (-Join ((Split-Path -Path ${resolvedSource} -LeafBase),".nuspec")) -Force ; \
        $paths = ($env:PSModulePath -split ":") ; \
        foreach ($path in $paths) \
        {Copy-Item -Path ((Join-Path -Path (Get-Item ${resolvedSource}).DirectoryName -ChildPath (Get-Item ${resolvedSource}).BaseName)) -Destination $path -Recurse -Force} ; \
        Import-Module (Split-Path -Path ${resolvedSource} -LeafBase)`;
        if (this.step.runCommand != undefined) {
            this.step.runCommand.forEach(cmd => {
                const command = cmd.resolve(inputs);
                commands += ` ; ${command}`;
            });
        }
        return commands;
    }
}
exports.PsModuleSimulation = PsModuleSimulation;
_a = JSII_RTTI_SYMBOL_1;
PsModuleSimulation[_a] = { fqn: "@cdklabs/cdk-ssm-documents.PsModuleSimulation", version: "0.0.16" };
//# sourceMappingURL=data:application/json;base64,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