"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsApiSimulation = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_invoker_1 = require("../../interface/aws-invoker");
const automation_simulation_base_1 = require("./automation-simulation-base");
/**
 * AutomationStep implementation of aws:executeAwsApi
 */
class AwsApiSimulation extends automation_simulation_base_1.AutomationSimulationBase {
    constructor(step, props) {
        super(step);
        this.action = 'aws:executeAwsApi';
        this.awsApiStep = step;
        this.awsInvoker = props.awsInvoker ?? new aws_invoker_1.ReflectiveAwsInvoker();
    }
    /**
       * Invokes the specified service (param) with the specified api (param) with the specified apiParams (param).
       * This call will be invoked synchronously.
       * The input variables in apiParams (param) specified using "{{ INPUT }}" syntax will be replaced with the inputs.
       * @returns the AWS api response. The Output selection will take place outside of this function.
       */
    executeStep(inputs) {
        return this.awsInvoker.invoke({
            service: this.awsApiStep.service,
            awsApi: this.awsApiStep.javaScriptApi,
            awsParams: this.awsApiStep.apiParams.resolveToDict(inputs),
        });
    }
}
exports.AwsApiSimulation = AwsApiSimulation;
_a = JSII_RTTI_SYMBOL_1;
AwsApiSimulation[_a] = { fqn: "@cdklabs/cdk-ssm-documents.AwsApiSimulation", version: "0.0.16" };
//# sourceMappingURL=data:application/json;base64,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