import { Construct } from 'constructs';
import { AutomationDocumentBuilder } from '../../document/document-builder';
import { CompositeAutomationStep } from './composite-step';
/**
 * StringStep allows for including a step from an existing automation document verbatim.
 * This is useful in that it allows developers to integrate with existing document steps.
 * This step can be used just as you would use any other Step including simulation and deployment.
 */
export declare class StringStep extends CompositeAutomationStep {
    /**
       * Builds a step object from a yaml declaration.
       * You may cast the step afterword to the associated Step for this action
       * if you wish to gain access to action specific functionality,
       * @returns Step associated with the provided activity.
       */
    static fromYaml(scope: Construct, inputYaml: string): StringStep;
    /**
       * Builds a step object from a json declaration.
       * You may cast the step afterword to the associated Step for this action
       * if you wish to gain access to action specific functionality,
       * @returns Step associated with the provided activity.
       */
    static fromJson(scope: Construct, json: string): StringStep;
    /**
       * Builds a step object from an object.
       * You may cast the step afterword to the associated Step for this action
       * if you wish to gain access to action specific functionality,
       * @returns Step associated with the provided activity.
       */
    static fromObject(scope: Construct, props: {
        [name: string]: any;
    }): StringStep;
    private automationStep;
    private constructor();
    addToDocument(doc: AutomationDocumentBuilder): void;
    private toOutputs;
    private toOutput;
    private toChoices;
    private toChoice;
    private toVariable;
    private parseDurationToSeconds;
}
