"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RunPowerShellScriptStep = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const platform_1 = require("../../domain/platform");
const command_step_1 = require("../command-step");
/**
 * AutomationStep implementation for aws:runPowerShellScript
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/ssm-plugins.html#aws-runPowerShellScript
 */
class RunPowerShellScriptStep extends command_step_1.CommandStep {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.platforms = [platform_1.Platform.WINDOWS];
        this.action = 'aws:runPowerShellScript';
        this.runCommand = props.runCommand;
        this.timeoutSeconds = props.timeoutSeconds;
        this.workingDirectory = props.workingDirectory;
    }
    /**
       * Inputs required for this command includes both the runCommand variables and workingDirectory if provided.
       */
    listInputs() {
        return [
            ...this.runCommand.flatMap(v => v.requiredInputs()),
            ...this.workingDirectory?.requiredInputs() ?? [],
        ];
    }
    toSsmEntry() {
        const inputs = { runCommand: this.runCommand };
        if (this.workingDirectory != undefined) {
            inputs.workingDirectory = this.workingDirectory;
        }
        if (this.timeoutSeconds != undefined) {
            inputs.timeoutSeconds = this.timeoutSeconds;
        }
        return super.prepareSsmEntry(inputs);
    }
}
exports.RunPowerShellScriptStep = RunPowerShellScriptStep;
_a = JSII_RTTI_SYMBOL_1;
RunPowerShellScriptStep[_a] = { fqn: "@cdklabs/cdk-ssm-documents.RunPowerShellScriptStep", version: "0.0.16" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicnVuLXBvd2Vyc2hlbGwtc2NyaXB0LXN0ZXAuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi9zcmMvcGFyZW50LXN0ZXBzL2NvbW1hbmQvcnVuLXBvd2Vyc2hlbGwtc2NyaXB0LXN0ZXAudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFDQSxvREFBaUQ7QUFFakQsa0RBQWdFO0FBeUJoRTs7O0dBR0c7QUFDSCxNQUFhLHVCQUF3QixTQUFRLDBCQUFXO0lBU3RELFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBbUM7UUFDM0UsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUUsS0FBSyxDQUFDLENBQUM7UUFKakIsY0FBUyxHQUFHLENBQUMsbUJBQVEsQ0FBQyxPQUFPLENBQUMsQ0FBQztRQUMvQixXQUFNLEdBQUcseUJBQXlCLENBQUM7UUFJMUMsSUFBSSxDQUFDLFVBQVUsR0FBRyxLQUFLLENBQUMsVUFBVSxDQUFDO1FBQ25DLElBQUksQ0FBQyxjQUFjLEdBQUcsS0FBSyxDQUFDLGNBQWMsQ0FBQztRQUMzQyxJQUFJLENBQUMsZ0JBQWdCLEdBQUcsS0FBSyxDQUFDLGdCQUFnQixDQUFDO0lBQ2pELENBQUM7SUFFRDs7U0FFSztJQUNFLFVBQVU7UUFDZixPQUFPO1lBQ0wsR0FBRyxJQUFJLENBQUMsVUFBVSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxjQUFjLEVBQUUsQ0FBQztZQUNuRCxHQUFHLElBQUksQ0FBQyxnQkFBZ0IsRUFBRSxjQUFjLEVBQUUsSUFBSSxFQUFFO1NBQ2pELENBQUM7SUFDSixDQUFDO0lBRU0sVUFBVTtRQUNmLE1BQU0sTUFBTSxHQUE0QixFQUFFLFVBQVUsRUFBRSxJQUFJLENBQUMsVUFBVSxFQUFFLENBQUM7UUFDeEUsSUFBSSxJQUFJLENBQUMsZ0JBQWdCLElBQUksU0FBUyxFQUFFO1lBQ3RDLE1BQU0sQ0FBQyxnQkFBZ0IsR0FBRyxJQUFJLENBQUMsZ0JBQWdCLENBQUM7U0FDakQ7UUFDRCxJQUFJLElBQUksQ0FBQyxjQUFjLElBQUksU0FBUyxFQUFFO1lBQ3BDLE1BQU0sQ0FBQyxjQUFjLEdBQUcsSUFBSSxDQUFDLGNBQWMsQ0FBQztTQUM3QztRQUNELE9BQU8sS0FBSyxDQUFDLGVBQWUsQ0FBQyxNQUFNLENBQUMsQ0FBQztJQUN2QyxDQUFDOztBQW5DSCwwREFxQ0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcbmltcG9ydCB7IFBsYXRmb3JtIH0gZnJvbSAnLi4vLi4vZG9tYWluL3BsYXRmb3JtJztcbmltcG9ydCB7IElTdHJpbmdWYXJpYWJsZSB9IGZyb20gJy4uLy4uL2ludGVyZmFjZS92YXJpYWJsZXMvc3RyaW5nLXZhcmlhYmxlJztcbmltcG9ydCB7IENvbW1hbmRTdGVwLCBDb21tYW5kU3RlcFByb3BzIH0gZnJvbSAnLi4vY29tbWFuZC1zdGVwJztcblxuLyoqXG4gKiBQcm9wZXJ0aWVzIGZvciBydW5Qb3dlclNoZWxsU2NyaXB0IHN0ZXAuXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgUnVuUG93ZXJTaGVsbFNjcmlwdFN0ZXBQcm9wcyBleHRlbmRzIENvbW1hbmRTdGVwUHJvcHMge1xuXG4gIC8qKlxuICAgICAqIFNwZWNpZnkgdGhlIGNvbW1hbmRzIHRvIHJ1biBvciB0aGUgcGF0aCB0byBhbiBleGlzdGluZyBzY3JpcHQgb24gdGhlIGluc3RhbmNlLlxuICAgICAqL1xuICByZWFkb25seSBydW5Db21tYW5kOiBJU3RyaW5nVmFyaWFibGVbXTtcblxuICAvKipcbiAgICAgKiAoT3B0aW9uYWwpIFRoZSB0aW1lIGluIHNlY29uZHMgZm9yIGEgY29tbWFuZCB0byBiZSBjb21wbGV0ZWQgYmVmb3JlIGl0J3MgY29uc2lkZXJlZCB0byBoYXZlIGZhaWxlZC5cbiAgICAgKiBXaGVuIHRoZSB0aW1lb3V0IGlzIHJlYWNoZWQsIFN5c3RlbXMgTWFuYWdlciBzdG9wcyB0aGUgY29tbWFuZCBleGVjdXRpb24uXG4gICAgICovXG4gIHJlYWRvbmx5IHRpbWVvdXRTZWNvbmRzPzogbnVtYmVyO1xuXG4gIC8qKlxuICAgICAqIChPcHRpb25hbCkgVGhlIHBhdGggdG8gdGhlIHdvcmtpbmcgZGlyZWN0b3J5IG9uIHlvdXIgaW5zdGFuY2UuXG4gICAgICovXG4gIHJlYWRvbmx5IHdvcmtpbmdEaXJlY3Rvcnk/OiBJU3RyaW5nVmFyaWFibGU7XG5cbn1cblxuLyoqXG4gKiBBdXRvbWF0aW9uU3RlcCBpbXBsZW1lbnRhdGlvbiBmb3IgYXdzOnJ1blBvd2VyU2hlbGxTY3JpcHRcbiAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9zeXN0ZW1zLW1hbmFnZXIvbGF0ZXN0L3VzZXJndWlkZS9zc20tcGx1Z2lucy5odG1sI2F3cy1ydW5Qb3dlclNoZWxsU2NyaXB0XG4gKi9cbmV4cG9ydCBjbGFzcyBSdW5Qb3dlclNoZWxsU2NyaXB0U3RlcCBleHRlbmRzIENvbW1hbmRTdGVwIHtcblxuICByZWFkb25seSBydW5Db21tYW5kOiBJU3RyaW5nVmFyaWFibGVbXTtcbiAgcmVhZG9ubHkgdGltZW91dFNlY29uZHM/OiBudW1iZXI7XG4gIHJlYWRvbmx5IHdvcmtpbmdEaXJlY3Rvcnk/OiBJU3RyaW5nVmFyaWFibGU7XG5cbiAgcmVhZG9ubHkgcGxhdGZvcm1zID0gW1BsYXRmb3JtLldJTkRPV1NdO1xuICByZWFkb25seSBhY3Rpb24gPSAnYXdzOnJ1blBvd2VyU2hlbGxTY3JpcHQnO1xuXG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBSdW5Qb3dlclNoZWxsU2NyaXB0U3RlcFByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCBwcm9wcyk7XG4gICAgdGhpcy5ydW5Db21tYW5kID0gcHJvcHMucnVuQ29tbWFuZDtcbiAgICB0aGlzLnRpbWVvdXRTZWNvbmRzID0gcHJvcHMudGltZW91dFNlY29uZHM7XG4gICAgdGhpcy53b3JraW5nRGlyZWN0b3J5ID0gcHJvcHMud29ya2luZ0RpcmVjdG9yeTtcbiAgfVxuXG4gIC8qKlxuICAgICAqIElucHV0cyByZXF1aXJlZCBmb3IgdGhpcyBjb21tYW5kIGluY2x1ZGVzIGJvdGggdGhlIHJ1bkNvbW1hbmQgdmFyaWFibGVzIGFuZCB3b3JraW5nRGlyZWN0b3J5IGlmIHByb3ZpZGVkLlxuICAgICAqL1xuICBwdWJsaWMgbGlzdElucHV0cygpOiBzdHJpbmdbXSB7XG4gICAgcmV0dXJuIFtcbiAgICAgIC4uLnRoaXMucnVuQ29tbWFuZC5mbGF0TWFwKHYgPT4gdi5yZXF1aXJlZElucHV0cygpKSxcbiAgICAgIC4uLnRoaXMud29ya2luZ0RpcmVjdG9yeT8ucmVxdWlyZWRJbnB1dHMoKSA/PyBbXSxcbiAgICBdO1xuICB9XG5cbiAgcHVibGljIHRvU3NtRW50cnkoKTogeyBbbmFtZTogc3RyaW5nXTogYW55IH0ge1xuICAgIGNvbnN0IGlucHV0czogeyBbbmFtZTogc3RyaW5nXTogYW55IH0gPSB7IHJ1bkNvbW1hbmQ6IHRoaXMucnVuQ29tbWFuZCB9O1xuICAgIGlmICh0aGlzLndvcmtpbmdEaXJlY3RvcnkgIT0gdW5kZWZpbmVkKSB7XG4gICAgICBpbnB1dHMud29ya2luZ0RpcmVjdG9yeSA9IHRoaXMud29ya2luZ0RpcmVjdG9yeTtcbiAgICB9XG4gICAgaWYgKHRoaXMudGltZW91dFNlY29uZHMgIT0gdW5kZWZpbmVkKSB7XG4gICAgICBpbnB1dHMudGltZW91dFNlY29uZHMgPSB0aGlzLnRpbWVvdXRTZWNvbmRzO1xuICAgIH1cbiAgICByZXR1cm4gc3VwZXIucHJlcGFyZVNzbUVudHJ5KGlucHV0cyk7XG4gIH1cblxufVxuIl19