import { Construct } from 'constructs';
import { Output } from '../../domain/output';
import { IStringVariable } from '../../interface/variables/string-variable';
import { AutomationStep, AutomationStepProps } from '../automation-step';
/**
 * Properties for DeleteImageStep
 */
export interface DeleteImageStepProps extends AutomationStepProps {
    /**
     * The ID of the image to be deleted.
     */
    readonly imageId: IStringVariable;
}
/**
 * AutomationStep implementation for aws:deleteImage
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-delete.html
 */
export declare class DeleteImageStep extends AutomationStep {
    readonly action: string;
    readonly imageId: IStringVariable;
    constructor(scope: Construct, id: string, props: DeleteImageStepProps);
    /**
       * This step has no outputs.
       */
    listOutputs(): Output[];
    listInputs(): string[];
    toSsmEntry(): Record<string, any>;
}
