"use strict";
var _a, _b, _c, _d;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SsmSecureVariable = exports.NonSecureVariable = exports.HardCodedSecureVariable = exports.SecureVariable = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * A secure string variable. Only supported by Command documents (only supported in downloadContent plugin).
 */
class SecureVariable {
    static ofSecureToken(secureToken) {
        return new SsmSecureVariable(secureToken);
    }
    static ofParameter(reference) {
        return new NonSecureVariable(reference);
    }
    static ofValue(value) {
        return new HardCodedSecureVariable(value);
    }
    toJSON() {
        return this.print();
    }
}
exports.SecureVariable = SecureVariable;
_a = JSII_RTTI_SYMBOL_1;
SecureVariable[_a] = { fqn: "@cdklabs/cdk-ssm-documents.SecureVariable", version: "0.0.16" };
/**
 * A hard-coded string variable.
 * Used when not dependent on step inputs.
 */
class HardCodedSecureVariable extends SecureVariable {
    constructor(val) {
        super();
        this.val = val;
    }
    print() {
        return this.val;
    }
    requiredInputs() {
        return [];
    }
    resolve(_inputs) {
        return this.val;
    }
}
exports.HardCodedSecureVariable = HardCodedSecureVariable;
_b = JSII_RTTI_SYMBOL_1;
HardCodedSecureVariable[_b] = { fqn: "@cdklabs/cdk-ssm-documents.HardCodedSecureVariable", version: "0.0.16" };
/**
 * A string variable reference.
 * Used to resolve the value from step inputs.
 */
class NonSecureVariable extends SecureVariable {
    constructor(reference) {
        super();
        this.reference = reference;
    }
    resolve(inputs) {
        const result = inputs[this.reference];
        if (result === undefined) {
            return result;
        }
        return result;
    }
    print() {
        return `{{ ${this.reference} }}`;
    }
    requiredInputs() {
        return [this.reference];
    }
}
exports.NonSecureVariable = NonSecureVariable;
_c = JSII_RTTI_SYMBOL_1;
NonSecureVariable[_c] = { fqn: "@cdklabs/cdk-ssm-documents.NonSecureVariable", version: "0.0.16" };
class SsmSecureVariable extends SecureVariable {
    constructor(secureToken) {
        super();
        this.secureToken = secureToken;
    }
    resolve(_inputs) {
        throw new Error('Not yet supported');
    }
    print() {
        return `{{ ssm-secure:${this.secureToken} }}`;
    }
    requiredInputs() {
        return [];
    }
}
exports.SsmSecureVariable = SsmSecureVariable;
_d = JSII_RTTI_SYMBOL_1;
SsmSecureVariable[_d] = { fqn: "@cdklabs/cdk-ssm-documents.SsmSecureVariable", version: "0.0.16" };
//# sourceMappingURL=data:application/json;base64,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