"use strict";
const assert_1 = require("@aws-cdk/assert");
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
module.exports = {
    'test alarm rule expression builder'(test) {
        const stack = new core_1.Stack();
        const testMetric = new lib_1.Metric({
            namespace: 'CDK/Test',
            metricName: 'Metric',
        });
        const alarm1 = new lib_1.Alarm(stack, 'Alarm1', {
            metric: testMetric,
            threshold: 100,
            evaluationPeriods: 3,
        });
        const alarm2 = new lib_1.Alarm(stack, 'Alarm2', {
            metric: testMetric,
            threshold: 1000,
            evaluationPeriods: 3,
        });
        const alarm3 = new lib_1.Alarm(stack, 'Alarm3', {
            metric: testMetric,
            threshold: 10000,
            evaluationPeriods: 3,
        });
        const alarm4 = new lib_1.Alarm(stack, 'Alarm4', {
            metric: testMetric,
            threshold: 100000,
            evaluationPeriods: 3,
        });
        const alarmRule = lib_1.AlarmRule.anyOf(lib_1.AlarmRule.allOf(lib_1.AlarmRule.anyOf(alarm1, lib_1.AlarmRule.fromAlarm(alarm2, lib_1.AlarmState.OK), alarm3), lib_1.AlarmRule.not(lib_1.AlarmRule.fromAlarm(alarm4, lib_1.AlarmState.INSUFFICIENT_DATA))), lib_1.AlarmRule.fromBoolean(false));
        new lib_1.CompositeAlarm(stack, 'CompositeAlarm', {
            alarmRule,
        });
        assert_1.expect(stack).to(assert_1.haveResource('AWS::CloudWatch::CompositeAlarm', {
            AlarmName: 'CompositeAlarm',
            AlarmRule: {
                'Fn::Join': [
                    '',
                    [
                        '(((ALARM(',
                        {
                            'Fn::GetAtt': [
                                'Alarm1F9009D71',
                                'Arn',
                            ],
                        },
                        ') OR OK(',
                        {
                            'Fn::GetAtt': [
                                'Alarm2A7122E13',
                                'Arn',
                            ],
                        },
                        ') OR ALARM(',
                        {
                            'Fn::GetAtt': [
                                'Alarm32341D8D9',
                                'Arn',
                            ],
                        },
                        ')) AND (NOT (INSUFFICIENT_DATA(',
                        {
                            'Fn::GetAtt': [
                                'Alarm4671832C8',
                                'Arn',
                            ],
                        },
                        ')))) OR FALSE)',
                    ],
                ],
            },
        }));
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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