"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Unit = exports.Statistic = void 0;
/**
 * Statistic to use over the aggregation period
 */
var Statistic;
(function (Statistic) {
    /**
     * The count (number) of data points used for the statistical calculation.
     */
    Statistic["SAMPLE_COUNT"] = "SampleCount";
    /**
     * The value of Sum / SampleCount during the specified period.
     */
    Statistic["AVERAGE"] = "Average";
    /**
     * All values submitted for the matching metric added together.
     * This statistic can be useful for determining the total volume of a metric.
     */
    Statistic["SUM"] = "Sum";
    /**
     * The lowest value observed during the specified period.
     * You can use this value to determine low volumes of activity for your application.
     */
    Statistic["MINIMUM"] = "Minimum";
    /**
     * The highest value observed during the specified period.
     * You can use this value to determine high volumes of activity for your application.
     */
    Statistic["MAXIMUM"] = "Maximum";
})(Statistic = exports.Statistic || (exports.Statistic = {}));
/**
 * Unit for metric
 */
var Unit;
(function (Unit) {
    /**
     * Seconds
     */
    Unit["SECONDS"] = "Seconds";
    /**
     * Microseconds
     */
    Unit["MICROSECONDS"] = "Microseconds";
    /**
     * Milliseconds
     */
    Unit["MILLISECONDS"] = "Milliseconds";
    /**
     * Bytes
     */
    Unit["BYTES"] = "Bytes";
    /**
     * Kilobytes
     */
    Unit["KILOBYTES"] = "Kilobytes";
    /**
     * Megabytes
     */
    Unit["MEGABYTES"] = "Megabytes";
    /**
     * Gigabytes
     */
    Unit["GIGABYTES"] = "Gigabytes";
    /**
     * Terabytes
     */
    Unit["TERABYTES"] = "Terabytes";
    /**
     * Bits
     */
    Unit["BITS"] = "Bits";
    /**
     * Kilobits
     */
    Unit["KILOBITS"] = "Kilobits";
    /**
     * Megabits
     */
    Unit["MEGABITS"] = "Megabits";
    /**
     * Gigabits
     */
    Unit["GIGABITS"] = "Gigabits";
    /**
     * Terabits
     */
    Unit["TERABITS"] = "Terabits";
    /**
     * Percent
     */
    Unit["PERCENT"] = "Percent";
    /**
     * Count
     */
    Unit["COUNT"] = "Count";
    /**
     * Bytes/second (B/s)
     */
    Unit["BYTES_PER_SECOND"] = "Bytes/Second";
    /**
     * Kilobytes/second (kB/s)
     */
    Unit["KILOBYTES_PER_SECOND"] = "Kilobytes/Second";
    /**
     * Megabytes/second (MB/s)
     */
    Unit["MEGABYTES_PER_SECOND"] = "Megabytes/Second";
    /**
     * Gigabytes/second (GB/s)
     */
    Unit["GIGABYTES_PER_SECOND"] = "Gigabytes/Second";
    /**
     * Terabytes/second (TB/s)
     */
    Unit["TERABYTES_PER_SECOND"] = "Terabytes/Second";
    /**
     * Bits/second (b/s)
     */
    Unit["BITS_PER_SECOND"] = "Bits/Second";
    /**
     * Kilobits/second (kb/s)
     */
    Unit["KILOBITS_PER_SECOND"] = "Kilobits/Second";
    /**
     * Megabits/second (Mb/s)
     */
    Unit["MEGABITS_PER_SECOND"] = "Megabits/Second";
    /**
     * Gigabits/second (Gb/s)
     */
    Unit["GIGABITS_PER_SECOND"] = "Gigabits/Second";
    /**
     * Terabits/second (Tb/s)
     */
    Unit["TERABITS_PER_SECOND"] = "Terabits/Second";
    /**
     * Count/second
     */
    Unit["COUNT_PER_SECOND"] = "Count/Second";
    /**
     * No unit
     */
    Unit["NONE"] = "None";
})(Unit = exports.Unit || (exports.Unit = {}));
//# sourceMappingURL=data:application/json;base64,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