Quick-Start Guide
=================

Installing (or not!)
--------------------

Have you [installed](https://tabatkins.github.io/bikeshed/#installing) Bikeshed yet?
If not, do so.

Or, are you using Bikeshed infrequently?
Are you okay with a network roundtrip when invoking it,
in return for it always being up-to-date?
If so, then you might want to just use the Bikeshed API: <https://api.csswg.org/bikeshed/>.
The linked page contains several `curl` recipes,
suitable to put into a shell alias/function for easy use.

Starting the Spec
-----------------

Put the following into an empty document:

```
<pre class='metadata'>
Title: Your Spec Title
Shortname: your-spec
Level: 1
Status: ED
Group: WGNAMEORWHATEVER
URL: http://example.com/url-this-spec-will-live-at
Editor: Your Name, Your Company http://example.com/your-company, your-email@example.com, http://example.com/your-personal-website
Abstract: A short description of your spec, one or two sentences.
</pre>

Introduction {#intro}
=====================

Introduction here.
```

(Or, if you're running Bikeshed locally, run `bikeshed template > mydoc.bs`.)

Fill in the metadata appropriately, then write the rest of your spec!

The processor expects that your headings are all `<h2>` or higher (`<h1>` is reserved for the spec title).
You probably want to add explicit id attributes to your headings;
the processor will add them for you if you don't,
but they're autogenerated from the text of the heading,
and often quite bad.

You don't need to use `<p>` tags in most cases -
plain paragraphs are automatically inferred by linebreaks,
and starting one with "Note:" or "Issue:" makes it add `class="note"` or `class="issue"`.
In fact, you can use most Markdown block-level syntax:
paragraphs, headings, lists.

Linking
-------

When you first download the processor, it'll come with the necessary crossref data needed to do cross-spec linking,
but there's no telling how recent it is.
You probably want to start by running `bikeshed update`, which'll fetch the latest data.

To use autolinks, just define things with `<dfn>`,
then link to them with `<a>` (no `href` attribute).
It matches up the contained text by default,
which can be overridden by using `title` on either the `<dfn>` or `<a>`.
Definitions and autolinks have a few extra attributes that you can specify;
check out the details in the [Autolinking](https://tabatkins.github.io/bikeshed/#autolinking) documentation.

There are a few textual shortcuts to use as well:
* `[[foo]]` is an autolink to a bibliography entry named "foo", and auto-generates an informative reference in the biblio section.
    Add a leading exclamation point to the value, like `[[!foo]]` for a normative reference.
* A number of autolink types have corresponding textual shorthands: for example, `'foo'` is an autolink to the "foo" CSS property; `{{Foo}}` is an autolink to the WebIDL "Foo" interface.

When you first preprocess, there's a good chance you'll get several errors.
While the preprocessor is forgiving about most things and will gladly do automatic fixup,
there are some things that it needs to be strict about to ensure it can generate correct documents.
In particular, all of your "value" type definitions *must* have a `for=''` attribute naming what they're a value for:
the name of the property they're a value of, the name of the type they're defined as a part of, etc.
(Alternately, put a `dfn-for=''` attribute on a container to have it apply to all the definitions without an explicit `for`.)
Similarly, some of your autolinks may throw errors or warnings because they can't tell which thing you're referring to.
Just add `for=''` and/or `spec=''` attributes to the link.

Defining Properties and Descriptors
-----------------------------------

If defining a property/descriptor, rather than writing out the table markup explicitly, just add a propdef or descdef block, like so:

~~~~html
<pre class='propdef'> (or 'descdef')
Name: var-*
Value: <<value>> | <<CDO>> | <<CDC>>
Initial: (nothing, see prose)
Applies to: all elements
Inherited: yes
Media: all
Computed value: specified value with variables substituted (but see prose for "invalid variables")
Percentage: n/a
</pre>
~~~~

Common practice is to define all of the values for the property in a `<dl>` underneath the propdef table.
If you do so, and you're only defining the values in there
(no other `<dfn>`s show up),
go ahead and put `dfn-type=value` and `dfn-for=property-name` attributes on the `<dl>`,
where "property-name" is the name of the property.
This'll automatically set up the correct types and references for the value definitions,
so the processor won't balk at you as much.

You can do similarly for element definitions.
