"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Channel = exports.ChannelType = exports.LatencyMode = void 0;
const core = require("@aws-cdk/core");
const ivs_generated_1 = require("./ivs.generated");
const stream_key_1 = require("./stream-key");
/**
 * Reference to a new or existing IVS Channel
 */
class ChannelBase extends core.Resource {
    /**
     * (experimental) Adds a stream key for this IVS Channel.
     *
     * @experimental
     */
    addStreamKey(id) {
        return new stream_key_1.StreamKey(this, id, {
            channel: this,
        });
    }
}
/**
 * (experimental) Channel latency mode.
 *
 * @experimental
 */
var LatencyMode;
(function (LatencyMode) {
    LatencyMode["LOW"] = "LOW";
    LatencyMode["NORMAL"] = "NORMAL";
})(LatencyMode = exports.LatencyMode || (exports.LatencyMode = {}));
/**
 * (experimental) The channel type, which determines the allowable resolution and bitrate.
 *
 * If you exceed the allowable resolution or bitrate, the stream probably will disconnect immediately.
 *
 * @experimental
 */
var ChannelType;
(function (ChannelType) {
    ChannelType["STANDARD"] = "STANDARD";
    ChannelType["BASIC"] = "BASIC";
})(ChannelType = exports.ChannelType || (exports.ChannelType = {}));
/**
 * (experimental) A new IVS channel.
 *
 * @experimental
 */
class Channel extends ChannelBase {
    /**
     * @experimental
     */
    constructor(scope, id, props = {}) {
        super(scope, id, {
            physicalName: props.name,
        });
        if (props.name && !core.Token.isUnresolved(props.name) && !/^[a-zA-Z0-9-_]*$/.test(props.name)) {
            throw new Error(`name must contain only numbers, letters, hyphens and underscores, got: '${props.name}'`);
        }
        const resource = new ivs_generated_1.CfnChannel(this, 'Resource', {
            authorized: props.authorized,
            latencyMode: props.latencyMode,
            name: props.name,
            type: props.type,
        });
        this.channelArn = resource.attrArn;
        this.channelIngestEndpoint = resource.attrIngestEndpoint;
        this.channelPlaybackUrl = resource.attrPlaybackUrl;
    }
    /**
     * (experimental) Import an existing channel.
     *
     * @experimental
     */
    static fromChannelArn(scope, id, channelArn) {
        // This will throw an error if the arn cannot be parsed
        let arnComponents = core.Arn.parse(channelArn);
        if (!core.Token.isUnresolved(arnComponents.service) && arnComponents.service !== 'ivs') {
            throw new Error(`Invalid service, expected 'ivs', got '${arnComponents.service}'`);
        }
        if (!core.Token.isUnresolved(arnComponents.resource) && arnComponents.resource !== 'channel') {
            throw new Error(`Invalid resource, expected 'channel', got '${arnComponents.resource}'`);
        }
        class Import extends ChannelBase {
            constructor() {
                super(...arguments);
                this.channelArn = channelArn;
            }
        }
        return new Import(scope, id);
    }
}
exports.Channel = Channel;
//# sourceMappingURL=data:application/json;base64,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