# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum

class ActionsRequired(str, Enum):
    """Any action that is required beyond basic workflow (approve/ reject/ disconnect)
    """

    none = "None"
    recreate = "Recreate"

class ConnectionStatus(str, Enum):
    """The private link service connection status.
    """

    pending = "Pending"
    approved = "Approved"
    rejected = "Rejected"
    disconnected = "Disconnected"

class IdentityType(str, Enum):
    """The type of managed identity used. The type 'SystemAssigned, UserAssigned' includes both an
    implicitly created identity and a set of user-assigned identities. The type 'None' will remove
    any identities.
    """

    none = "None"
    system_assigned = "SystemAssigned"
    user_assigned = "UserAssigned"
    system_assigned_user_assigned = "SystemAssigned, UserAssigned"

class ProvisioningState(str, Enum):
    """The provisioning state of the configuration store.
    """

    creating = "Creating"
    updating = "Updating"
    deleting = "Deleting"
    succeeded = "Succeeded"
    failed = "Failed"
    canceled = "Canceled"

class PublicNetworkAccess(str, Enum):
    """Control permission for data plane traffic coming from public networks while private endpoint is
    enabled.
    """

    enabled = "Enabled"
    disabled = "Disabled"
