"""
Related tag data from StackOverflow
CC-BY-SA
ref: https://api.stackexchange.com/docs/related-tags
"""
from typing import Dict, List

RELATED_TAGS: Dict[str, List[str]] = {'batchfile': [],
                                      'c#': ['c#', '.net', 'asp.net', 'wpf',
                                             'asp.net-mvc', 'winforms', 'linq',
                                             'entity-framework', 'xaml', 'sql-server',
                                             'visual-studio', 'unity3d', 'sql', 'xml',
                                             'asp.net-core', 'javascript', 'json',
                                             'wcf', 'multithreading', 'jquery',
                                             'xamarin', 'regex', '.net-core',
                                             'asp.net-web-api', 'arrays',
                                             'asp.net-mvc-4', 'windows', 'generics',
                                             'mvvm', 'string', 'html', 'datagridview',
                                             'list', 'visual-studio-2010', 'vb.net',
                                             'azure', 'excel', 'razor', 'mysql',
                                             'web-services', 'unit-testing', 'uwp',
                                             'database', 'gridview', 'android',
                                             'reflection', 'c++', 'xamarin.forms',
                                             'asynchronous', 'datetime'],
                                      'c++': ['c++', 'c++11', 'qt', 'c', 'templates',
                                              'arrays', 'boost', 'pointers', 'windows',
                                              'vector', 'opencv', 'winapi',
                                              'multithreading', 'linux', 'visual-c++',
                                              'string', 'class', 'stl', 'opengl',
                                              'visual-studio', 'gcc', 'algorithm', 'c#',
                                              'inheritance', 'python', 'function',
                                              'cmake', 'java', 'dll', 'mfc', 'g++',
                                              'c++14', 'c++17', 'visual-studio-2010',
                                              'constructor', 'struct', 'oop',
                                              'operator-overloading', 'android',
                                              'sockets', 'memory', 'linker',
                                              'memory-management', 'iterator',
                                              'performance', 'macos', 'compiler-errors',
                                              'file', 'language-lawyer', 'reference'],
                                      'jupyter notebook': [],
                                      'objective-C': ['objective-c', 'ios', 'iphone',
                                                      'xcode', 'uitableview', 'cocoa',
                                                      'cocoa-touch', 'swift', 'macos',
                                                      'ipad', 'core-data', 'uiview',
                                                      'uiviewcontroller', 'ios7',
                                                      'nsstring', 'uiscrollview',
                                                      'json', 'ios5', 'ios4',
                                                      'uiimageview', 'uibutton',
                                                      'nsarray', 'nsmutablearray',
                                                      'uiwebview', 'memory-management',
                                                      'uinavigationcontroller',
                                                      'cocos2d-iphone', 'uiimage',
                                                      'uicollectionview', 'arrays', 'c',
                                                      'storyboard', 'autolayout',
                                                      'uitextfield', 'ios6',
                                                      'nsdictionary', 'ios8', 'sqlite',
                                                      'automatic-ref-counting',
                                                      'sprite-kit', 'nsdate', 'c++',
                                                      'facebook', 'uilabel',
                                                      'animation', 'objective-c-blocks',
                                                      'delegates', 'parse-platform',
                                                      'uikit', 'multithreading'],
                                      'r': ['r', 'ggplot2', 'dataframe', 'dplyr',
                                            'shiny', 'plot', 'data.table', 'matrix',
                                            'loops', 'function', 'for-loop', 'regex',
                                            'list', 'r-markdown', 'rstudio',
                                            'time-series', 'tidyverse', 'statistics',
                                            'python', 'subset', 'date', 'knitr',
                                            'string', 'csv', 'regression', 'vector',
                                            'if-statement', 'lapply', 'merge', 'apply',
                                            'plotly', 'tidyr', 'package',
                                            'web-scraping', 'igraph',
                                            'machine-learning', 'plyr', 'bar-chart',
                                            'excel', 'na', 'rcpp', 'purrr', 'aggregate',
                                            'graph', 'linear-regression', 'html',
                                            'raster', 'rvest', 'parallel-processing',
                                            'xts'],
                                      'shell': ['shell', 'bash', 'linux', 'unix', 'awk',
                                                'python', 'sed', 'scripting', 'sh',
                                                'command-line', 'grep', 'macos', 'php',
                                                'terminal', 'java', 'regex', 'c',
                                                'ubuntu', 'ssh', 'windows', 'perl',
                                                'ksh', 'android', 'cron', 'command',
                                                'git', 'zsh', 'mysql', 'jenkins',
                                                'curl', 'docker', 'arrays', 'find',
                                                'pipe', 'node.js', 'batch-file', 'c++',
                                                'variables', 'csv', 'ruby', 'string',
                                                'json', 'file', 'makefile',
                                                'powershell', 'adb', 'subprocess',
                                                'loops', 'if-statement',
                                                'environment-variables'],
                                      'abap': ['abap', 'opensql', 'sap-erp', 'alv',
                                               'sap-basis', 'dynpro', 'internal-tables',
                                               'saprfc', 'bapi', 'sapui5',
                                               'function-module', 'cds',
                                               'sap-data-dictionary', 'odata',
                                               'webdynpro', 'sap-selection-screens',
                                               'sql', 'dynamic', 'oop', 'select',
                                               'sap-gateway', 'xml', 'badi', 'hana',
                                               'sap-smart-forms', 'regex', 'json',
                                               'sap-fiori', 'netweaver', 'javascript',
                                               'java', 'excel', 'eclipse',
                                               'web-services', 'sap-gui', 'debugging',
                                               'c#', 'sap-hr', 'string', 'parameters',
                                               'report', 'pyrfc', 'loops', 'jco',
                                               'sap-crm', 'exception',
                                               'sap-dotnet-connector', 'sap-query',
                                               'rtts', 'database'],
                                      'apl': ['apl', 'dyalog', 'matrix', 'arrays', 'j',
                                              'vector', 'gnu-apl', 'k', 'string',
                                              'function', 'multidimensional-array',
                                              'functional-programming',
                                              'tacit-programming', 'algorithm',
                                              'sorting', 'c++', 'indexing',
                                              'error-handling', 'gnu',
                                              'language-design', 'scala', 'performance',
                                              'haskell', 'unicode', 'syntax', 'split',
                                              'scope', 'nested', 'keyboard', 'numbers',
                                              'arguments', 'mapping',
                                              'parameter-passing', 'keyboard-shortcuts',
                                              'open-source', 'variable-assignment',
                                              'reshape', 'lookup', 'interpreter',
                                              'fibonacci', 'theory', 'history',
                                              'counting', 'map-function', 'in-place',
                                              'c#', 'php', 'python', 'sql', 'r'],
                                      'abnf': ['abnf', 'parsing', 'grammar', 'regex',
                                               'http', 'c++', 'perl', 'http-headers',
                                               'boost-spirit', 'rfc', 'bnf', 'node.js',
                                               'json', 'validation', 'email',
                                               'serialization', 'data-structures',
                                               'boost', 'unicode', 'macros', 'tags',
                                               'antlr4', 'sip', 'specifications',
                                               'rtmp', 'context-free-grammar', 'cpan',
                                               'expand', 'spf', 'amf', 'ebnf', 'rfc822',
                                               'http-protocols', 'metalanguage',
                                               'parse-recdescent'], 'actionscript3': [],
                                      'actionscript': ['actionscript', 'flash',
                                                       'actionscript-3', 'apache-flex',
                                                       'actionscript-2', 'air',
                                                       'javascript', 'flex4', 'adobe',
                                                       'flex3', 'flash-cs5',
                                                       'flash-builder', 'xml', 'php',
                                                       'mxml', 'arrays', 'java',
                                                       'movieclip', 'html', 'events',
                                                       'flash-cs4', 'android',
                                                       'flash-cs6', 'class',
                                                       'animation', 'video', 'audio',
                                                       'flex4.5', 'ios', 'button',
                                                       'image', 'datagrid', 'function',
                                                       'variables', 'flashdevelop',
                                                       'regex', 'oop', 'timer',
                                                       'flexbuilder',
                                                       'externalinterface', 'facebook',
                                                       'c#', 'sockets', 'object',
                                                       'jquery', 'json', 'loops',
                                                       'mobile', 'flash-cs3',
                                                       'security'],
                                      'ada': ['ada', 'gnat', 'arrays', 'c', 'gnat-gps',
                                              'generics', 'string', 'c++', 'task',
                                              'gcc', 'types', 'linux', 'record',
                                              'package', 'spark-ada', 'ada2012', 'oop',
                                              'pointers', 'gtk', 'windows',
                                              'compilation', 'java', 'exception',
                                              'concurrency', 'dll', 'sockets',
                                              'function', 'compiler-construction',
                                              'macos', 'file', 'gprbuild',
                                              'compiler-errors', 'embedded',
                                              'procedure', 'multithreading', 'enums',
                                              'linker', 'gdb', 'type-conversion',
                                              'subtype', 'spark-2014', 'eclipse',
                                              'random', 'ide', 'range', 'constants',
                                              'algorithm', 'loops', 'file-io',
                                              'floating-point'],
                                      'adl': ['argument-dependent-lookup', 'c++',
                                              'templates', 'c++11', 'namespaces',
                                              'name-lookup', 'language-lawyer',
                                              'operator-overloading', 'gcc', 'boost',
                                              'stl', 'swap', 'friend-function',
                                              'friend', 'overload-resolution',
                                              'visual-c++', 'std', 'clang',
                                              'function-templates', 'c++14',
                                              'overloading', 'c++17',
                                              'using-directives', 'using-declaration',
                                              'lambda', 'scope', 'air', 'lookup',
                                              'template-meta-programming', 'decltype',
                                              'c++20', 'non-member-functions',
                                              'function', 'apache-flex', 'iterator',
                                              'constexpr', 'using', 'boost-range',
                                              'dependent-name', 'c#', 'linux',
                                              'visual-studio-2010', 'inheritance',
                                              'visual-studio-2012', 'enums',
                                              'containers', 'function-pointers',
                                              'azure-data-lake', 'generic-programming',
                                              'initializer-list'],
                                      'agda': ['agda', 'dependent-type', 'haskell',
                                               'functional-programming', 'types',
                                               'idris', 'coq', 'proof',
                                               'theorem-proving', 'type-theory',
                                               'cubical-type-theory',
                                               'pattern-matching',
                                               'homotopy-type-theory', 'equality',
                                               'agda-mode', 'termination', 'emacs',
                                               'list', 'recursion', 'logic',
                                               'coinduction', 'standard-library',
                                               'induction', 'module', 'category-theory',
                                               'syntax', 'record', 'isabelle', 'plfa',
                                               'programming-languages', 'monads',
                                               'substitution', 'lambda-calculus',
                                               'algebraic-data-types', 'gadt',
                                               'parametric-polymorphism', 'decidable',
                                               'agda-stdlib', 'function', 'parsing',
                                               'unicode', 'io', 'compilation', 'cabal',
                                               'functor', 'generic-programming',
                                               'typechecking', 'unification', 'lean',
                                               'curry-howard'], 'aheui': [],
                                      'alloy': ['alloy', 'java', 'formal-methods',
                                                'logic', 'modeling', 'predicate',
                                                'formal-verification', 'model-checking',
                                                'function', 'api', 'model', 'recursion',
                                                'analyzer', 'first-order-logic',
                                                'declarative-programming', 'graph',
                                                'signature', 'specifications',
                                                'relation', 'formal-languages',
                                                'python', 'scope', 'integer', 'set',
                                                'closures', 'instance', 'solver',
                                                'assertion', 'requirements',
                                                'model-driven-development', 'macos',
                                                'list', 'testing', 'join', 'types',
                                                'tree', 'subset', 'transformation',
                                                'verification', 'relational-algebra',
                                                'relational', 'declarative', 'sat',
                                                'javascript', 'c++', 'xml', 'string',
                                                'windows', 'performance', 'http'],
                                      'ambienttalk': [],
                                      'ampl': ['ampl', 'optimization',
                                               'linear-programming', 'glpk', 'cplex',
                                               'mathprog', 'mathematical-optimization',
                                               'python', 'constraints', 'pyomo', 'set',
                                               'modeling', 'solver', 'gurobi', 'syntax',
                                               'matlab', 'neos-server', 'c++',
                                               'operations-research', 'indexing',
                                               'ipopt', 'math', 'gams-math',
                                               'parameters', 'java', 'linux',
                                               'variables', 'sum', 'syntax-error',
                                               'nonlinear-optimization', 'scip', 'r',
                                               'graph', 'conditional-statements',
                                               'sparse-matrix', 'integer-programming',
                                               'julia-jump', 'c#', 'eclipse',
                                               'python-2.7', 'file', 'parsing',
                                               'if-statement', 'matrix', 'vector',
                                               'visual-studio-2015', 'binary',
                                               'windows-7', 'jupyter-notebook',
                                               'iteration'], 'angular2html': [],
                                      'antlractionscript': [], 'antlrcsharp': [],
                                      'antlrcpp': [], 'antlrjava': [],
                                      'antlrobjectivec': [], 'antlrperl': [],
                                      'antlrpython': [], 'antlrruby': [],
                                      'apacheconf': [],
                                      'applescript': ['applescript', 'macos',
                                                      'automator', 'shell', 'cocoa',
                                                      'objective-c', 'javascript',
                                                      'xcode', 'bash', 'terminal',
                                                      'excel', 'finder', 'itunes',
                                                      'automation', 'safari', 'python',
                                                      'applescript-objc', 'email',
                                                      'scripting', 'osascript',
                                                      'outlook',
                                                      'javascript-automation', 'swift',
                                                      'google-chrome', 'directory',
                                                      'file', 'ios', 'variables',
                                                      'text', 'osx-yosemite', 'html',
                                                      'ms-word', 'list',
                                                      'osx-mavericks', 'java', 'vba',
                                                      'pdf', 'osx-mountain-lion',
                                                      'adobe-indesign', 'photoshop',
                                                      'apple-mail', 'imessage',
                                                      'string', 'powerpoint',
                                                      'quicktime', 'dialog', 'osx-lion',
                                                      'scripting-bridge', 'keynote',
                                                      'appleevents'],
                                      'arduino': ['arduino', 'c++', 'c', 'serial-port',
                                                  'python', 'arduino-uno', 'android',
                                                  'esp8266', 'bluetooth', 'arduino-ide',
                                                  'java', 'c#', 'arrays',
                                                  'raspberry-pi', 'esp32',
                                                  'arduino-esp8266', 'pyserial',
                                                  'processing', 'avr', 'string', 'php',
                                                  'bluetooth-lowenergy', 'sensors',
                                                  'usb', 'microcontroller', 'i2c',
                                                  'nodemcu', 'embedded', 'arduino-c++',
                                                  'led', 'javascript', 'node.js',
                                                  'wifi', 'gsm', 'iot',
                                                  'serial-communication', 'atmega',
                                                  'ethernet', 'xbee', 'http', 'linux',
                                                  'interrupt', 'matlab', 'at-command',
                                                  'json', 'lcd', 'mqtt', 'gps', 'rfid',
                                                  'html'], 'arrow': [],
                                      'aspectj': ['aspectj', 'java', 'spring', 'aop',
                                                  'spring-aop', 'maven', 'spring-boot',
                                                  'pointcut', 'eclipse',
                                                  'aspectj-maven-plugin', 'annotations',
                                                  'aspect', 'android',
                                                  'load-time-weaving', 'spring-mvc',
                                                  'gradle', 'spring-roo',
                                                  'intellij-idea', 'logging',
                                                  'hibernate', 'compile-time-weaving',
                                                  'scala', 'ajdt', 'junit',
                                                  'transactions', 'tomcat',
                                                  'spring-aspects', 'java-8',
                                                  'reflection', 'jpa', 'ant',
                                                  'dependency-injection', 'maven-2',
                                                  'jakarta-ee', 'exception',
                                                  'spring-security', 'multithreading',
                                                  'jar', 'spring-transactions',
                                                  'spring-annotations',
                                                  'spring-data-jpa', 'osgi', 'kotlin',
                                                  'sbt', 'javaagents', 'log4j',
                                                  'android-studio', 'spring-data',
                                                  'generics', 'lombok'],
                                      'asymptote': ['asymptote', 'r', 'latex', 'python',
                                                    'algorithm', 'function', 'big-o',
                                                    'nls', 'javascript', 'matlab',
                                                    'loops', 'dataframe', 'matplotlib',
                                                    'math', 'plot', 'graph', 'model',
                                                    'runtime', 'glsl', 'regression',
                                                    'gnuplot', 'complexity-theory',
                                                    'atom-editor', 'axis', 'analysis',
                                                    'lm', 'curve', 'logarithm',
                                                    'dummy-variable',
                                                    'nonlinear-functions', 'sigmoid'],
                                      'augeas': ['augeas', 'puppet', 'xml',
                                                 'puppet-enterprise', 'linux', 'bash',
                                                 'regex', 'ruby', 'ubuntu',
                                                 'configuration', 'jboss7.x', 'centos',
                                                 'vagrant', 'properties-file',
                                                 'jboss-eap-6', 'hiera', 'python',
                                                 'mysql', 'mongodb', 'macos',
                                                 'python-2.7', 'apache', 'file', 'perl',
                                                 'sorting', 'templates', 'tomcat',
                                                 'nginx', 'heroku', 'xpath',
                                                 'amazon-ec2', 'sed', 'command-line',
                                                 'lua', 'properties', 'binding',
                                                 'automation', 'jboss', 'xml-parsing',
                                                 'rubygems', 'set', 'debian',
                                                 'escaping', 'match',
                                                 'conditional-statements', 'memcached',
                                                 'whitespace', 'dependency-properties',
                                                 'configuration-files', 'directive'],
                                      'autoit': ['autoit', 'windows', 'automation',
                                                 'selenium', 'java', 'python',
                                                 'selenium-webdriver', 'user-interface',
                                                 'internet-explorer', 'robotframework',
                                                 'arrays', 'scripting', 'javascript',
                                                 'string', 'regex', 'excel',
                                                 'batch-file', 'c#', 'html',
                                                 'ui-automation', 'google-chrome',
                                                 'winapi', 'firefox', 'ruby',
                                                 'webdriver', 'automated-tests',
                                                 'vb.net', 'variables', 'watir',
                                                 'eclipse', 'testing', 'windows-7',
                                                 'powershell', 'file-upload', 'cmd',
                                                 'loops', 'jenkins', 'vbscript',
                                                 'windows-10', 'window', 'bots', 'php',
                                                 'c++', 'dll', 'vba', 'python-2.7',
                                                 'browser', 'autohotkey', 'pcre',
                                                 'image'],
                                      'autohotkey': ['autohotkey', 'windows',
                                                     'automation', 'regex', 'scripting',
                                                     'keyboard-shortcuts', 'loops',
                                                     'hotkeys', 'keyboard',
                                                     'user-interface', 'macros',
                                                     'javascript', 'windows-10',
                                                     'google-chrome', 'excel', 'python',
                                                     'com', 'variables', 'arrays',
                                                     'batch-file', 'c#', 'html',
                                                     'clipboard', 'string',
                                                     'internet-explorer', 'vba',
                                                     'winapi', 'remap', 'if-statement',
                                                     'function', 'cmd', 'window',
                                                     'mouse', 'powershell', 'c++',
                                                     'dll', 'replace', 'notepad++',
                                                     'firefox', 'text', 'windows-7',
                                                     'key', 'java', 'vim', 'syntax',
                                                     'dom', 'shortcut', 'browser',
                                                     'vbscript', 'timer'],
                                      'awk': ['awk', 'bash', 'sed', 'shell', 'linux',
                                              'unix', 'grep', 'regex', 'perl', 'csv',
                                              'python', 'scripting', 'cut', 'sorting',
                                              'arrays', 'string', 'replace', 'sh',
                                              'text', 'parsing', 'text-processing',
                                              'file', 'command-line', 'split', 'xml',
                                              'variables', 'ksh', 'macos',
                                              'pattern-matching', 'for-loop',
                                              'if-statement', 'loops', 'join', 'date',
                                              'find', 'printf', 'ubuntu', 'terminal',
                                              'tr', 'json', 'cat', 'r', 'gsub', 'pipe',
                                              'merge', 'uniq', 'multiple-columns',
                                              'solaris', 'windows', 'printing'],
                                      'bbcbasic': [],
                                      'bc': ['bc', 'bash', 'shell', 'linux', 'unix',
                                             'awk', 'math', 'sed', 'c', 'php', 'pipe',
                                             'sh', 'if-statement', 'floating-point',
                                             'scripting', 'java', 'macos', 'perl',
                                             'printf', 'comparison', 'python', 'csv',
                                             'date', 'grep', 'numbers', 'hex', 'cygwin',
                                             'fork', 'echo', 'precision', 'gnu',
                                             'division', 'arithmetic-expressions',
                                             'bcmath', 'dc', 'mysql', 'arrays',
                                             'string', 'windows', 'list', 'performance',
                                             'variables', 'curl', 'vim', 'command-line',
                                             'syntax', 'binary', 'cryptography',
                                             'compare', 'conditional-statements'],
                                      'bst': ['binary-search-tree', 'java', 'c++',
                                              'algorithm', 'data-structures',
                                              'binary-tree', 'c', 'tree', 'recursion',
                                              'python', 'pointers', 'avl-tree', 'nodes',
                                              'search', 'c#', 'arrays', 'javascript',
                                              'python-3.x', 'linked-list',
                                              'red-black-tree', 'insert',
                                              'time-complexity', 'inorder', 'sorting',
                                              'tree-traversal', 'binary-search',
                                              'struct', 'segmentation-fault',
                                              'traversal', 'string', 'haskell',
                                              'generics', 'templates', 'big-o', 'class',
                                              'preorder', 'dictionary', 'iterator',
                                              'performance', 'c++11', 'scheme',
                                              'function', 'breadth-first-search',
                                              'binary', 'vector', 'iteration',
                                              'hashtable', 'treenode', 'list',
                                              'complexity-theory'],
                                      'bare': ['bare', 'git', 'react-native', 'expo',
                                               'java', 'string', 'github', 'mips',
                                               'c++', 'arrays', 'repository', 'push',
                                               'workflow', 'clone', 'init',
                                               'ibm-cloud-infrastructure', 'spim',
                                               'javascript', 'php', 'ios', 'json',
                                               'linux', 'reactjs', 'windows', 'scala',
                                               'web-services', 'date', 'assembly',
                                               'logging', 'methods', 'cmd',
                                               'kubernetes', 'build', 'server',
                                               'parameters', 'directory', 'path', 'arm',
                                               'sbt', 'mercurial', 'key', 'load',
                                               'bitbucket', 'ibm-cloud',
                                               'integration-testing', 'cpu',
                                               'system-calls', 'status',
                                               'windows-subsystem-for-linux',
                                               'git-push'],
                                      'bash': ['bash', 'shell', 'linux', 'awk', 'sed',
                                               'unix', 'python', 'grep', 'regex',
                                               'macos', 'scripting', 'sh', 'terminal',
                                               'git', 'ubuntu', 'ssh', 'arrays', 'php',
                                               'command-line', 'perl', 'variables',
                                               'curl', 'find', 'docker', 'cron',
                                               'string', 'java', 'loops', 'mysql',
                                               'json', 'csv', 'if-statement', 'pipe',
                                               'for-loop', 'file', 'node.js', 'windows',
                                               'c', 'jq', 'zsh',
                                               'environment-variables', 'ruby',
                                               'sorting', 'while-loop', 'cygwin',
                                               'makefile', 'echo', 'command',
                                               'function', 'expect'], 'bashsession': [],
                                      'batch': ['batch-file', 'windows', 'cmd',
                                                'powershell', 'command-line', 'java',
                                                'for-loop', 'vbscript', 'file',
                                                'python', 'batch-processing',
                                                'scripting', 'variables', 'dos', 'c#',
                                                'directory', 'command-prompt',
                                                'if-statement', 'command', 'shell',
                                                'windows-7', 'string', 'copy', 'loops',
                                                'csv', 'php', 'scheduled-tasks',
                                                'registry', 'xcopy', 'findstr',
                                                'rename', 'ftp', 'jenkins', 'text',
                                                'batch-rename', 'sql-server', 'sql',
                                                'bash', 'mysql', 'echo', 'replace',
                                                'excel', 'xml', 'automation',
                                                'javascript', 'environment-variables',
                                                'date', 'robocopy', 'ffmpeg',
                                                'windows-10'],
                                      'befunge': ['befunge', 'esoteric-languages',
                                                  'python', 'random', 'python-3.x',
                                                  'string', 'list', 'compilation',
                                                  'stack', 'global-variables',
                                                  'python-import',
                                                  'interpreted-language'],
                                      'bibtex': ['bibtex', 'latex', 'r', 'bibliography',
                                                 'r-markdown', 'python', 'citations',
                                                 'biblatex', 'pandoc', 'regex',
                                                 'parsing', 'markdown', 'knitr',
                                                 'pdflatex', 'csl', 'html', 'java',
                                                 'bookdown', 'php', 'emacs', 'tex',
                                                 'bash', 'sed', 'reference', 'rstudio',
                                                 'pandoc-citeproc', 'javascript',
                                                 'ruby', 'url', 'ms-word', 'package',
                                                 'sweave', 'beamer',
                                                 'latex-environment', 'google-scholar',
                                                 'doi', 'c#', 'linux', 'perl', 'pdf',
                                                 'awk', 'visual-studio-code', 'export',
                                                 'bison', 'org-mode', 'flex-lexer',
                                                 'lyx', 'miktex', 'mendeley',
                                                 'texmaker'], 'blitzbasic': [],
                                      'blitzmax': ['blitzmax', 'c++', 'string',
                                                   'multithreading', 'io',
                                                   'floating-point', 'binary', 'linker',
                                                   'thread-safety',
                                                   'nullreferenceexception', 'fstream',
                                                   'porting', 'basic', 'lld',
                                                   'blitz3d'],
                                      'bnf': ['bnf', 'grammar', 'parsing', 'ebnf',
                                              'context-free-grammar', 'python',
                                              'compiler-construction', 'regex', 'java',
                                              'syntax', 'c', 'yacc', 'bison', 'antlr',
                                              'c++', 'javascript', 'intellij-idea',
                                              'grammar-kit', 'abstract-syntax-tree',
                                              'intellij-plugin', 'recursion', 'lex',
                                              'parser-generator', 'formal-languages',
                                              'c#', 'javacc', 'bnfc', 'pyparsing',
                                              'recursive-descent', 'associativity',
                                              'xml', 'antlr4', 'flex-lexer', 'ply',
                                              'jison', 'parsekit', 'gold-parser',
                                              'objective-c', 'algorithm', 'prolog',
                                              'expression', 'racket',
                                              'programming-languages',
                                              'computer-science', 'regular-language',
                                              'll', 'ambiguous-grammar', 'sql',
                                              'python-3.x', 'scala'],
                                      'boa': ['boa', 'c', 'linux', 'cgi', 'windows',
                                              'python-2.7', 'apache', 'shell', 'perl',
                                              'user-interface', 'indexing',
                                              'segmentation-fault', 'ide', 'webserver',
                                              'wxpython', 'glibc', 'watchdog',
                                              'directoryindex', 'boa-constructor'],
                                      'boo': ['boo', '.net', 'c#', 'unity3d', 'python',
                                              'dsl', 'macros', 'ironpython',
                                              'unityscript', 'mono', 'syntax', 'list',
                                              'linq', 'dynamic', 'lambda',
                                              'metaprogramming', 'clr', 'nant',
                                              'nemerle', 'rhino-dsl', 'asp.net',
                                              'arrays', 'excel', 'asp.net-mvc',
                                              'string', 'twitter-bootstrap',
                                              'visual-studio', 'import',
                                              'compiler-construction',
                                              'garbage-collection', 'embed', 'binsor',
                                              'javascript', 'java', 'android', 'jquery',
                                              'html', 'css', 'ajax', 'spring',
                                              'multithreading', 'algorithm',
                                              'performance', 'unit-testing', 'class',
                                              'jsp', 'templates', 'variables',
                                              'if-statement', 'haskell'],
                                      'boogie': ['boogie', 'dafny', 'logic', 'z3',
                                                 'verification', 'smt',
                                                 'formal-verification', 'quantifiers'],
                                      'brainfuck': ['brainfuck', 'interpreter', 'c',
                                                    'esoteric-languages', 'python',
                                                    'c++', 'algorithm', 'loops',
                                                    'javascript', 'java',
                                                    'compiler-construction', 'assembly',
                                                    'parsing', 'input', 'regex',
                                                    'python-3.x', 'if-statement',
                                                    'haskell', 'optimization',
                                                    'turing-machines',
                                                    'turing-complete', 'node.js',
                                                    'for-loop', 'recursion', 'math',
                                                    'printing', 'while-loop', 'grep',
                                                    'ascii', 'x86-64', 'jit',
                                                    'halting-problem', 'c#', 'html',
                                                    'string', 'bash', 'python-2.7',
                                                    'scala', 'list', 'performance',
                                                    'shell', 'perl', 'http', 'oop',
                                                    'security', 'debugging', 'testing',
                                                    'matrix', 'encryption', 'memory'],
                                      'bugs': [], 'camkes': [],
                                      'c': ['c', 'c++', 'linux', 'arrays', 'pointers',
                                            'gcc', 'string', 'struct', 'sockets',
                                            'windows', 'function', 'malloc',
                                            'multithreading', 'file', 'scanf',
                                            'segmentation-fault', 'linked-list',
                                            'assembly', 'algorithm', 'python', 'printf',
                                            'unix', 'memory', 'winapi', 'pthreads',
                                            'char', 'memory-management', 'linux-kernel',
                                            'java', 'embedded', 'makefile', 'fork',
                                            'loops', 'data-structures', 'macros',
                                            'macos', 'objective-c', 'c-preprocessor',
                                            'posix', 'multidimensional-array',
                                            'recursion', 'linker', 'gdb', 'integer',
                                            'file-io', 'sorting', 'for-loop',
                                            'performance', 'pipe', 'debugging'],
                                      'cmake': ['cmake', 'c++', 'makefile', 'c',
                                                'opencv', 'linux', 'qt',
                                                'visual-studio', 'boost', 'clion',
                                                'build', 'windows', 'android', 'macos',
                                                'gcc', 'linker', 'python',
                                                'android-ndk', 'shared-libraries',
                                                'clang', 'ubuntu', 'mingw',
                                                'compilation', 'cross-compiling',
                                                'visual-c++', 'c++11', 'xcode',
                                                'googletest', 'static-libraries',
                                                'cpack', 'qt5', 'cuda', 'qt-creator',
                                                'g++', 'ctest', 'visual-studio-2010',
                                                'installation', 'visual-studio-2017',
                                                'ros', 'android-studio', 'cmake-gui',
                                                'dll', 'llvm', 'dependencies', 'ninja',
                                                'opengl', 'compiler-errors', 'eclipse',
                                                'git', 'linker-errors'], 'cobjdump': [],
                                      'cpsa': [], 'csharpaspx': [],
                                      'csharp': ['c#', '.net', 'asp.net', 'wpf',
                                                 'asp.net-mvc', 'winforms', 'linq',
                                                 'entity-framework', 'xaml',
                                                 'sql-server', 'visual-studio',
                                                 'unity3d', 'sql', 'xml',
                                                 'asp.net-core', 'javascript', 'json',
                                                 'wcf', 'multithreading', 'jquery',
                                                 'xamarin', 'regex', '.net-core',
                                                 'asp.net-web-api', 'arrays',
                                                 'asp.net-mvc-4', 'windows', 'generics',
                                                 'mvvm', 'string', 'html',
                                                 'datagridview', 'list',
                                                 'visual-studio-2010', 'vb.net',
                                                 'azure', 'excel', 'razor', 'mysql',
                                                 'web-services', 'unit-testing', 'uwp',
                                                 'database', 'gridview', 'android',
                                                 'reflection', 'c++', 'xamarin.forms',
                                                 'asynchronous', 'datetime'],
                                      'ca65': ['ca65', 'assembly', '6502', 'c64',
                                               'commodore', 'c', 'stdio', '8-bit',
                                               'apple-ii'], 'cadl': [], 'capdl': [],
                                      'capnproto': ['capnproto', 'c++',
                                                    'protocol-buffers', 'python',
                                                    'serialization', 'rpc', 'rust',
                                                    'flatbuffers', 'java', 'linux',
                                                    'c++11', 'cmake', 'zeromq',
                                                    'javascript', 'c', 'json',
                                                    'homebrew', 'grpc', 'thrift',
                                                    'snappy', 'c#', 'android', 'arrays',
                                                    'node.js', 'python-3.x', 'windows',
                                                    'list', 'typescript', 'azure', 'qt',
                                                    'sockets', 'go', 'generics',
                                                    'asynchronous', 'networking',
                                                    'boost', 'struct', 'types', 'tcp',
                                                    'websocket', 'redis', 'pyspark',
                                                    'promise', 'compiler-errors',
                                                    'apache-kafka', 'pip',
                                                    'apache-spark-sql', 'crash', 'g++',
                                                    'mpi'], 'cbmbasicv2': [],
                                      'ceylon': ['ceylon', 'java', 'eclipse', 'scala',
                                                 'maven', 'generics', 'metaprogramming',
                                                 'android', 'gradle', 'module', 'jvm',
                                                 'interop', 'typechecking',
                                                 'jvm-languages', 'arrays', 'string',
                                                 'performance', 'swing', 'rest',
                                                 'spring-boot', 'unit-testing',
                                                 'if-statement', 'servlets', 'kotlin',
                                                 'multidimensional-array',
                                                 'serialization', 'browser', 'plugins',
                                                 'reflection', 'collections',
                                                 'web-applications', 'import', 'enums',
                                                 'jar', 'interface', 'proxy',
                                                 'properties', 'functional-programming',
                                                 'static', 'jackson', 'cryptography',
                                                 'compiler-construction', 'format',
                                                 'copy', 'sbt', 'tuples', 'classpath',
                                                 'sequence', 'programming-languages',
                                                 'javabeans'], 'cfengine3': [],
                                      'chaiscript': ['chaiscript', 'c++', 'c++11',
                                                     'templates', 'dll',
                                                     'compiler-errors', 'compilation',
                                                     'c++14', 'qt4', 'wstring',
                                                     'javascript', 'node.js', 'string',
                                                     'windows', 'macos',
                                                     'visual-studio', 'performance',
                                                     'qt', 'debugging',
                                                     'visual-studio-2012',
                                                     'visual-studio-2015', 'vbscript',
                                                     'constructor', 'cmake', 'lua',
                                                     'scripting', 'stl', 'android-ndk',
                                                     'visual-studio-2017', 'linker',
                                                     'clang', 'character',
                                                     'overloading',
                                                     'performance-testing', 'swig',
                                                     'sfml', 'ram', 'large-data',
                                                     'stdmap', 'evaluation',
                                                     'game-development', 'pragma',
                                                     'std-function', 'qtscript',
                                                     'msvc12', 'sgx', 'biicode',
                                                     'stdinitializerlist'],
                                      'chapel': ['chapel', 'arrays',
                                                 'parallel-processing', 'sparse-matrix',
                                                 'hpc', 'parallelism-amdahl', 'gasnet',
                                                 'python', 'function', 'file', 'tuples',
                                                 'slice', 'json', 'postgresql',
                                                 'matrix', 'multidimensional-array',
                                                 'list-comprehension',
                                                 'distributed-computing',
                                                 'multithreading', 'performance',
                                                 'graph', 'types', 'installation',
                                                 'formatting', 'environment-variables',
                                                 'zeromq', 'distributed', 'bigint',
                                                 'object-lifetime', 'low-latency',
                                                 'forall', 'c++', 'regex', 'database',
                                                 'string', 'bash', 'loops', 'numpy',
                                                 'sorting', 'oop', 'dictionary',
                                                 'for-loop', 'templates', 'generics',
                                                 'recursion', 'logging', 'random',
                                                 'memory-management', 'command-line',
                                                 'makefile'], 'charmci': [],
                                      'cheetah': ['cheetah', 'python', 'templates',
                                                  'cherrypy', 'javascript', 'jquery',
                                                  'django', 'jinja2', 'template-engine',
                                                  'gnuradio', 'html', 'python-3.x',
                                                  'bash', 'python-2.7', 'dictionary',
                                                  'google-app-engine', 'inheritance',
                                                  'flask', 'syntax', 'php', 'css',
                                                  'mysql', 'sql-server', 'xml',
                                                  'windows', 'eclipse', 'list',
                                                  'validation', 'web', 'caching',
                                                  'stored-procedures', 'iframe',
                                                  'filter', 'web-applications',
                                                  'import', 'emacs', 'orm',
                                                  'architecture', 'installation', 'pip',
                                                  'compiler-construction', 'format',
                                                  'include', 'latex', 'webserver',
                                                  'comments', 'version', 'antlr',
                                                  'tornado', 'updates'], 'cirru': [],
                                      'clay': ['clay', 'c#', 'dynamic', 'liferay',
                                               'orchardcms', 'liferay-7',
                                               'orchardcms-1.8', 'twitter-bootstrap',
                                               'c#-4.0', 'camera',
                                               'console-application', 'textures',
                                               'automapper', 'intellisense', 'lwjgl',
                                               'trigonometry', 'frame-rate',
                                               'liferay-theme', 'pebble-sdk',
                                               'dynamic-proxy', 'cloudpebble', 'povray',
                                               'pebble-js', 'impromptu', 'lexicon',
                                               'liferay-7.1', 'impromptu-interface',
                                               'linfu', 'liferay-7.2'], 'clean': [],
                                      'clojure': ['clojure', 'java', 'leiningen',
                                                  'clojurescript',
                                                  'functional-programming', 'macros',
                                                  'compojure', 'lisp', 'ring', 'emacs',
                                                  'clojure-java-interop', 'datomic',
                                                  'read-eval-print-loop', 'dictionary',
                                                  'core.async', 'recursion', 'vector',
                                                  'jvm', 'clojure.spec', 'cider',
                                                  'concurrency', 'scala',
                                                  'lazy-evaluation', 'jdbc',
                                                  'namespaces', 'maven', 'performance',
                                                  'lazy-sequences', 'function',
                                                  'string', 'multithreading',
                                                  'unit-testing', 'javascript',
                                                  'clojure-contrib', 'postgresql',
                                                  'list', 'json', 'regex', 'python',
                                                  'intellij-idea', 'hashmap', 'scheme',
                                                  'eclipse', 'clojure-core.logic',
                                                  'haskell', 'data-structures',
                                                  'testing', 'reagent', 'xml',
                                                  'heroku'],
                                      'clojurescript': ['clojurescript', 'clojure',
                                                        'reagent', 'javascript', 'om',
                                                        'reactjs', 're-frame',
                                                        'leiningen', 'figwheel',
                                                        'core.async', 'node.js',
                                                        'clojurescript-javascript-interop',
                                                        'read-eval-print-loop',
                                                        'functional-programming',
                                                        'macros',
                                                        'google-closure-compiler',
                                                        'cljsbuild', 'shadow-cljs',
                                                        'react-native', 'ajax', 'emacs',
                                                        'lisp', 'html', 'java',
                                                        'hiccup', 'boot-clj',
                                                        'asynchronous', 'lighttable',
                                                        'jquery', 'cider', 'edn',
                                                        'hoplon', 'namespaces',
                                                        'interop', 'clojure.spec',
                                                        'css', 'google-closure', 'ring',
                                                        'compojure',
                                                        'google-closure-library',
                                                        'compilation', 'luminus',
                                                        'om-next', 'json', 'dom',
                                                        'heroku', 'reagent-forms',
                                                        're-natal', 'testing',
                                                        'datascript'],
                                      'cobolfreeformat': [],
                                      'cobol': ['cobol', 'mainframe', 'gnucobol', 'db2',
                                                'java', 'cics', 'jcl', 'microfocus',
                                                'zos', 'sql', 'ibm-midrange', 'c#',
                                                'file', 'cobol85', 'copybook', 'c',
                                                'arrays', '.net', 'xml', 'if-statement',
                                                'comp-3', 'string', 'windows',
                                                'parsing', 'ebcdic', 'vsam', 'oracle',
                                                'netcobol', 'linux', 'database',
                                                'eclipse', 'stored-procedures',
                                                'cobol.net', 'python', 'sql-server',
                                                'unix', 'input', 'file-io', 'db2-zos',
                                                'c++', 'sorting',
                                                'compiler-construction', 'jrecord',
                                                'procobol', 'regex', 'loops',
                                                'web-services', 'date', 'debugging',
                                                'dll'],
                                      'coffeescript': ['coffeescript', 'javascript',
                                                       'ruby-on-rails', 'jquery',
                                                       'node.js', 'backbone.js',
                                                       'angularjs', 'ajax', 'ruby',
                                                       'meteor', 'html',
                                                       'ruby-on-rails-3', 'ember.js',
                                                       'ruby-on-rails-4', 'express',
                                                       'json', 'jasmine', 'mongodb',
                                                       'reactjs', 'gruntjs', 'arrays',
                                                       'mocha.js', 'css', 'hubot',
                                                       'marionette', 'underscore.js',
                                                       'mongoose', 'promise', 'haml',
                                                       'd3.js', 'asset-pipeline',
                                                       'unit-testing', 'gulp', 'class',
                                                       'npm', 'requirejs',
                                                       'ruby-on-rails-3.1',
                                                       'twitter-bootstrap',
                                                       'asynchronous', 'atom-editor',
                                                       'function', 'regex', 'pug',
                                                       'sass', 'scope', 'inheritance',
                                                       'forms', 'knockout.js',
                                                       'framerjs', 'browserify'],
                                      'coldfusioncfc': [], 'coldfusionhtml': [],
                                      'commonlisp': [], 'componentpascal': [],
                                      'coq': ['coq', 'coq-tactic', 'proof',
                                              'dependent-type', 'theorem-proving',
                                              'coqide', 'ltac', 'logic', 'ssreflect',
                                              'induction', 'types',
                                              'functional-programming', 'agda',
                                              'logical-foundations', 'ocaml',
                                              'recursion', 'typeclass', 'idris',
                                              'formal-verification', 'equality',
                                              'proof-general', 'haskell',
                                              'coq-extraction', 'totality', 'math',
                                              'isabelle', 'notation',
                                              'pattern-matching', 'emacs',
                                              'termination', 'type-theory', 'list',
                                              'set', 'opam', 'coinduction',
                                              'definition', 'real-number', 'syntax',
                                              'module', 'verifiable-c', 'coq-plugin',
                                              'function', 'convoy-pattern',
                                              'lambda-calculus', 'coercion',
                                              'predicate', 'subtype', 'record',
                                              'quantifiers', 'compcert'],
                                      'cpp': ['c++', 'c++11', 'qt', 'c', 'templates',
                                              'arrays', 'boost', 'pointers', 'windows',
                                              'vector', 'opencv', 'winapi',
                                              'multithreading', 'linux', 'visual-c++',
                                              'string', 'class', 'stl', 'opengl',
                                              'visual-studio', 'gcc', 'algorithm', 'c#',
                                              'inheritance', 'python', 'function',
                                              'cmake', 'java', 'dll', 'mfc', 'g++',
                                              'c++14', 'c++17', 'visual-studio-2010',
                                              'constructor', 'struct', 'oop',
                                              'operator-overloading', 'android',
                                              'sockets', 'memory', 'linker',
                                              'memory-management', 'iterator',
                                              'performance', 'macos', 'compiler-errors',
                                              'file', 'language-lawyer', 'reference'],
                                      'cppobjdump': [], 'crmsh': [], 'croc': [],
                                      'cryptol': ['cryptol', 'cryptography', 'list',
                                                  'encryption',
                                                  'functional-programming', 'dsl',
                                                  'public-key-encryption', 'pycrypto'],
                                      'crystal': ['crystal-reports', 'c#', 'asp.net',
                                                  'vb.net', 'report',
                                                  'crystal-reports-2008', 'sql', '.net',
                                                  'sql-server', 'crystal-reports-xi',
                                                  'crystal-reports-2010',
                                                  'visual-studio-2010', 'visual-studio',
                                                  'winforms', 'mysql',
                                                  'visual-studio-2008', 'formula',
                                                  'reporting-services', 'subreport',
                                                  'sap', 'printing', 'vb6', 'reporting',
                                                  'asp.net-mvc', 'oracle',
                                                  'visual-studio-2012', 'pdf', 'wpf',
                                                  'parameters', 'crosstab',
                                                  'crystal-reports-8.5', 'java',
                                                  'stored-procedures', 'dataset',
                                                  'database', 'sql-server-2008',
                                                  'c#-4.0', 'business-objects',
                                                  'ms-access', 'date',
                                                  'visual-studio-2005', 'excel', 'odbc',
                                                  'crystal-reports-server', 'grouping',
                                                  'windows', 'visual-studio-2015',
                                                  'iis', 'visual-studio-2013', 'image'],
                                      'csounddocument': [], 'csoundorchestra': [],
                                      'csoundscore': [],
                                      'css': ['css', 'html', 'javascript', 'jquery',
                                              'twitter-bootstrap', 'php', 'wordpress',
                                              'flexbox', 'reactjs', 'bootstrap-4',
                                              'image', 'sass', 'responsive-design',
                                              'google-chrome', 'twitter-bootstrap-3',
                                              'svg', 'internet-explorer', 'angular',
                                              'angularjs', 'css-selectors', 'asp.net',
                                              'firefox', 'animation', 'html-table',
                                              'media-queries', 'hover', 'fonts',
                                              'css-float', 'css-animations', 'layout',
                                              'css-position', 'css-transitions', 'web',
                                              'safari', 'drop-down-menu', 'jquery-ui',
                                              'ruby-on-rails', 'mobile', 'menu', 'less',
                                              'forms', 'scroll', 'ios', 'iframe',
                                              'background-image', 'css-grid', 'android',
                                              'background', 'alignment', 'position'],
                                      'cuda': ['cuda', 'c++', 'gpu', 'nvidia', 'c',
                                               'gpgpu', 'thrust', 'nvcc',
                                               'parallel-processing', 'python',
                                               'memory', 'opencv', 'gpu-programming',
                                               'opencl', 'arrays', 'cublas', 'nsight',
                                               'cmake', 'pycuda', 'linux',
                                               'visual-studio-2010', 'matrix',
                                               'tensorflow', 'opengl', 'visual-studio',
                                               'performance', 'matlab',
                                               'memory-management', 'numba',
                                               'optimization', 'ubuntu',
                                               'shared-memory', 'ptx', 'textures',
                                               'makefile', 'profiling', 'cufft',
                                               'pointers', 'image-processing', 'gcc',
                                               'windows', 'algorithm', 'fft',
                                               'reduction', 'c++11', 'linker',
                                               'sorting', 'atomic', 'c#', 'templates'],
                                      'cypher': ['cypher', 'neo4j', 'graph-databases',
                                                 'graph', 'java', 'spring-data-neo4j',
                                                 'neo4j-apoc', 'python', 'database',
                                                 'csv', 'py2neo', 'neo4jclient',
                                                 'performance', 'relationship',
                                                 'node.js', 'c#', 'nosql', 'rest',
                                                 'indexing', 'nodes', 'javascript',
                                                 'neo4j-ogm', 'load-csv', 'json',
                                                 'regex', 'gremlin', 'shortest-path',
                                                 'spring', 'lucene', 'php',
                                                 'cypher-3.1', 'path', 'spring-data',
                                                 'match', 'import',
                                                 'query-optimization', 'neo4j-spatial',
                                                 'neo4jphp', 'redisgraph', 'merge',
                                                 'tree', 'graphql', 'node-neo4j',
                                                 'arrays', 'optimization', 'sql',
                                                 'scala', 'ruby-on-rails',
                                                 'collections', 'foreach'],
                                      'cython': ['cython', 'python', 'numpy', 'c++',
                                                 'c', 'python-3.x', 'cythonize',
                                                 'arrays', 'performance', 'python-2.7',
                                                 'gcc', 'distutils', 'scipy', 'windows',
                                                 'optimization', 'pandas',
                                                 'compilation', 'memoryview',
                                                 'parallel-processing', 'setuptools',
                                                 'pointers', 'openmp', 'numba',
                                                 'anaconda', 'setup.py',
                                                 'multithreading', 'struct', 'macos',
                                                 'pip', 'wrapper', 'ctypes',
                                                 'jupyter-notebook', 'kivy', 'cpython',
                                                 'mingw', 'linux', 'list',
                                                 'scikit-learn', 'compiler-errors',
                                                 'class', 'dll', 'opencv', 'string',
                                                 'pycharm', 'installation', 'gil',
                                                 'typed-memory-views', 'types',
                                                 'ipython', 'pyinstaller'],
                                      'd': ['d', 'dmd', 'c++', 'arrays', 'templates',
                                            'phobos', 'c', 'vibed', 'string', 'windows',
                                            'struct', 'multithreading', 'gdc', 'linux',
                                            'dub', 'class', 'opengl', 'linker',
                                            'constants', 'immutability', 'gtkd',
                                            'range', 'performance',
                                            'garbage-collection', 'tango', 'oop',
                                            'pointers', 'sockets', 'casting',
                                            'operator-overloading', 'associative-array',
                                            'memory-management', 'metaprogramming',
                                            'function', 'concurrency',
                                            'compiler-construction', 'c#', 'macos',
                                            'user-interface', 'sdl', 'exception', 'dll',
                                            'derelict3', 'python', 'gcc', 'types',
                                            'compiler-errors', 'java', 'winapi',
                                            'enums'], 'dobjdump': [], 'darcspatch': [],
                                      'dart': ['dart', 'flutter', 'android', 'firebase',
                                               'flutter-layout',
                                               'google-cloud-firestore', 'ios',
                                               'angular-dart', 'json', 'dart-polymer',
                                               'flutter-dependencies', 'android-studio',
                                               'dart-pub', 'firebase-authentication',
                                               'listview', 'list', 'javascript',
                                               'flutter-web', 'http', 'mobile', 'bloc',
                                               'dart-html', 'asynchronous', 'polymer',
                                               'widget', 'flutter-animation', 'angular',
                                               'visual-studio-code', 'future', 'api',
                                               'google-maps',
                                               'firebase-realtime-database', 'stream',
                                               'html', 'java', 'flutter-provider',
                                               'flutter-test', 'image', 'dart-webui',
                                               'async-await', 'user-interface',
                                               'dart-async', 'sqflite', 'sqlite',
                                               'provider', 'dart-editor',
                                               'unit-testing', 'dart2js',
                                               'sharedpreferences', 'regex'],
                                      'dasm16': [], 'debiancontrol': [],
                                      'delphi': ['delphi', 'firemonkey', 'delphi-7',
                                                 'delphi-xe2', 'indy', 'delphi-2010',
                                                 'android', 'delphi-xe', 'winapi',
                                                 'multithreading', 'windows', 'vcl',
                                                 'delphi-2009', 'delphi-xe7', 'dll',
                                                 'delphi-2007', 'delphi-xe5', 'c#',
                                                 'delphi-xe3', 'firedac', 'pascal',
                                                 'indy10', 'c++', 'delphi-10-seattle',
                                                 'c++builder', 'sql', 'delphi-xe4',
                                                 'delphi-10.1-berlin', 'ios', 'arrays',
                                                 'ado', 'components', 'delphi-xe6',
                                                 'delphi-10.2-tokyo', 'generics', 'xml',
                                                 'database', 'string', 'mysql',
                                                 'delphi-xe8', 'datasnap', 'sql-server',
                                                 'com', 'twebbrowser',
                                                 'delphi-10.3-rio', 'forms', 'rtti',
                                                 'firebird', 'json', 'lazarus'],
                                      'devicetree': [], 'dg': [],
                                      'diff': ['diff', 'git', 'patch', 'linux', 'svn',
                                               'python', 'bash', 'merge', 'git-diff',
                                               'php', 'unix', 'compare', 'shell',
                                               'java', 'version-control', 'r',
                                               'javascript', 'algorithm', 'mercurial',
                                               'c#', 'xml', 'vim', 'windows', 'github',
                                               'comparison', 'file', 'html', 'arrays',
                                               'regex', 'mysql', 'branch',
                                               'command-line', 'tortoisesvn',
                                               'perforce', 'macos', 'visual-studio',
                                               'perl', 'string', 'awk', 'sed', 'pandas',
                                               'datetime', 'grep', 'sql', 'eclipse',
                                               'date', 'c++', 'json', 'vimdiff',
                                               'dataframe'],
                                      'docker': ['docker', 'docker-compose',
                                                 'dockerfile', 'python', 'kubernetes',
                                                 'nginx', 'node.js', 'linux',
                                                 'containers', 'java', 'mysql',
                                                 'jenkins', 'amazon-web-services',
                                                 'php', 'docker-swarm', 'postgresql',
                                                 'ubuntu', 'django', 'bash', 'windows',
                                                 'spring-boot', 'mongodb', 'networking',
                                                 'docker-machine', 'gitlab', 'azure',
                                                 'macos', 'asp.net-core', '.net-core',
                                                 'docker-registry', 'go', 'amazon-ecs',
                                                 'ruby-on-rails', 'gitlab-ci',
                                                 'amazon-ec2', 'flask', 'c#',
                                                 'docker-volume', 'boot2docker',
                                                 'alpine', 'elasticsearch',
                                                 'google-cloud-platform', 'apache',
                                                 'git', 'maven', 'docker-for-windows',
                                                 'laravel', 'shell', 'python-3.x',
                                                 'docker-container'],
                                      'dtd': ['dtd', 'xml', 'java', 'xsd', 'validation',
                                              'c#', 'html', 'xslt', 'xml-parsing',
                                              'python', 'xml-validation', 'xhtml',
                                              'doctype', 'schema', 'php', 'dtd-parsing',
                                              'eclipse', '.net', 'dom', 'parsing',
                                              'lxml', 'javascript', 'jaxb', 'entity',
                                              'w3c', 'sax', 'css', 'sgml', 'xpath',
                                              'libxml2', 'xsd-validation', 'hibernate',
                                              'spring', 'xmlreader', 'database',
                                              'cdata', 'xerces', 'pcdata', 'android',
                                              'external', 'saxparser', 'dita', 'svg',
                                              'saxon', 'stax', 'ant', 'struts2',
                                              'xmllint', 'relaxng', 'c++'], 'duel': [],
                                      'dylanconsole': [],
                                      'dylan': ['dylan', 'c++', 'clojure', 'julia',
                                                'common-lisp', 'python', 'arrays',
                                                'linux', 'scala', 'performance',
                                                'function', 'exception', 'encryption',
                                                'syntax', 'raspberry-pi', 'arm', 'lisp',
                                                'raspbian', 'language-design',
                                                'stability', 'multimethod',
                                                'multiple-dispatch'], 'dylanlid': [],
                                      'ecl': ['ecl', 'common-lisp', 'lisp', 'asdf', 'c',
                                              'c++', 'compiler-errors', 'slime',
                                              'windows', 'quicklisp', 'macos', 'sbcl',
                                              'ios', 'iphone', 'multithreading',
                                              'image', 'api', 'exception',
                                              'machine-learning', 'gcc', 'visual-c++',
                                              'checkbox', 'lambda', 'error-handling',
                                              'emacs', 'cmake', 'visual-studio-2008',
                                              'compilation', 'segmentation-fault',
                                              'dependencies', 'closures', 'scheme',
                                              'conditional-statements',
                                              'classification', 'sfml', 'd', 'osx-lion',
                                              'menuitem', 'assert', 'windows-7-x64',
                                              'ros', 'dump', 'ffi', 'symbolic-math',
                                              'sage', 'maxima', 'nmake', 'clisp',
                                              'terminal-emulator', 'ccl'], 'ec': [],
                                      'earlgrey': ['earlgrey', 'ios', 'swift',
                                                   'testing', 'xcode-ui-testing',
                                                   'xcode', 'ui-testing', 'xctest',
                                                   'objective-c', 'automated-tests',
                                                   'ui-automation',
                                                   'functional-testing',
                                                   'ios-ui-automation', 'detox',
                                                   'cocoapods', 'xcuitest',
                                                   'react-native', 'automation',
                                                   'integration-testing', 'e2e-testing',
                                                   'iphone', 'unit-testing',
                                                   'uitableview', 'cocoa-touch',
                                                   'audio', 'swift3', 'installation',
                                                   'slider', 'appium', 'alamofire',
                                                   'screenshot', 'updates',
                                                   'node-modules', 'bdd',
                                                   'hybrid-mobile-app',
                                                   'react-native-ios', 'touch-id',
                                                   'podspec', 'uitest', 'kif',
                                                   'earlgrey-2'],
                                      'easytrieve': ['easytrieve', 'mainframe', 'jcl',
                                                     'dfsort', 'syncsort', 'cobol',
                                                     'zos'],
                                      'ebnf': ['ebnf', 'bnf', 'parsing', 'grammar',
                                               'python', 'antlr',
                                               'context-free-grammar', 'regex', 'java',
                                               'syntax', 'grako', 'c#',
                                               'compiler-construction', 'antlr4',
                                               'bison', 'javascript', 'xml',
                                               'python-3.x', 'clojure',
                                               'computer-science', 'c', 'scala',
                                               'recursion', 'language-agnostic', 'lex',
                                               'peg', 'lark-parser',
                                               'ebnf-syntactic-exception', 'php',
                                               'prolog', 'programming-languages',
                                               'yacc', 'w3c', 'lexer',
                                               'context-free-language', 'c++', 'sql',
                                               'expression', 'dsl',
                                               'operator-precedence', 'xtext',
                                               'pyparsing', 'javacc', 'dcg',
                                               'parser-combinators', 'll',
                                               'recursive-descent', 'jison', 'cocor',
                                               'instaparse'],
                                      'eiffel': ['eiffel', 'design-by-contract',
                                                 'polymorphism', 'void-safety',
                                                 'algorithm', 'inheritance',
                                                 'eiffel-studio-18', 'arrays', 'agent',
                                                 'post-conditions', 'c++', 'oop',
                                                 'exception', 'compiler-errors',
                                                 'eiffel-studio-19.12', 'generics',
                                                 'syntax', 'multiple-inheritance',
                                                 'generic-programming', 'createprocess',
                                                 'c#', 'database', 'loops', 'math',
                                                 'linked-list', 'iterator',
                                                 'type-conversion', 'odbc',
                                                 'trigonometry', 'void', 'iterable',
                                                 'invariants', 'eiffel-scoop',
                                                 'eiffel-web-framework',
                                                 'eiffel-studio-20.05', 'java', 'c',
                                                 '.net', 'apache', 'function', 'class',
                                                 'sockets', 'datetime', 'variables',
                                                 'file-io', 'error-handling',
                                                 'concurrency', 'null', 'ide',
                                                 'integer'],
                                      'elixir': ['elixir', 'phoenix-framework', 'ecto',
                                                 'erlang', 'mix', 'postgresql', 'otp',
                                                 'phoenix', 'gen-server',
                                                 'functional-programming', 'ex-unit',
                                                 'iex', 'testing', 'macros',
                                                 'pattern-matching', 'json',
                                                 'javascript', 'phoenix-channels',
                                                 'plug', 'metaprogramming', 'docker',
                                                 'elixir-poison', 'erlang-supervisor',
                                                 'list', 'absinthe', 'heroku',
                                                 'httpoison', 'websocket', 'distillery',
                                                 'regex', 'cowboy', 'string', 'graphql',
                                                 'dialyzer', 'datetime', 'dictionary',
                                                 'sql', 'exrm', 'unit-testing',
                                                 'recursion', 'enums', 'mnesia', 'ets',
                                                 'html', 'mongodb', 'sockets',
                                                 'authentication', 'mysql', 'http',
                                                 'guardian'],
                                      'elm': ['elm', 'functional-programming', 'json',
                                              'javascript', 'html', 'haskell', 'list',
                                              'types', 'http', 'decode', 'frp',
                                              'signals', 'elm-architecture', 'record',
                                              'svg', 'random', 'css', 'maybe',
                                              'elm-signal', 'dictionary', 'dom',
                                              'webpack', 'pattern-matching', 'events',
                                              'node.js', 'forms', 'parsing',
                                              'union-types', 'arrays', 'time',
                                              'phoenix-framework', 'decoder',
                                              'elm-port', 'date', 'recursion', 'npm',
                                              'syntax', 'read-eval-print-loop',
                                              'algebraic-data-types', 'elm-test',
                                              'elm-ui', 'function', 'websocket',
                                              'frontend', 'elm-make', 'ruby-on-rails',
                                              'reactjs', 'web', 'visual-studio-code',
                                              'port'], 'emacslisp': [],
                                      'email': ['email', 'php', 'html', 'smtp', 'c#',
                                                'python', 'java', 'outlook', 'gmail',
                                                'android', 'forms', 'javascript',
                                                'phpmailer', 'asp.net', 'css',
                                                'laravel', 'html-email',
                                                'ruby-on-rails', 'vba', 'imap',
                                                'jakarta-mail', 'codeigniter', 'django',
                                                'mysql', 'attachment', 'wordpress',
                                                'sendmail', 'ios', '.net', 'excel',
                                                'validation', 'email-attachments',
                                                'regex', 'ruby', 'node.js', 'jquery',
                                                'sendgrid', 'postfix-mta', 'linux',
                                                'iphone', 'exchange-server',
                                                'laravel-5', 'amazon-web-services',
                                                'powershell', 'swiftmailer', 'vb.net',
                                                'mime', 'image', 'google-apps-script',
                                                'dns'],
                                      'erlang': ['erlang', 'elixir', 'otp', 'ejabberd',
                                                 'mnesia', 'rabbitmq', 'erlang-shell',
                                                 'list', 'rebar', 'cowboy',
                                                 'gen-server', 'functional-programming',
                                                 'xmpp', 'concurrency', 'yaws',
                                                 'erlang-supervisor', 'riak', 'erl',
                                                 'sockets', 'ets', 'couchdb', 'c',
                                                 'linux', 'ssl', 'pattern-matching',
                                                 'tcp', 'java', 'json', 'process',
                                                 'phoenix-framework', 'string',
                                                 'recursion', 'http', 'eunit',
                                                 'distributed', 'windows', 'nitrogen',
                                                 'rebar3', 'python', 'chicagoboss',
                                                 'gen-tcp', 'binary', 'tuples',
                                                 'record', 'performance', 'mysql',
                                                 'websocket', 'mochiweb', 'dialyzer',
                                                 'multithreading'], 'erlangshell': [],
                                      'evoquehtml': [], 'evoque': [], 'evoquexml': [],
                                      'execline': ['execline', 'linux', 'docker',
                                                   'scripting', 'alpine', 's6'],
                                      'ezhil': [], 'fsharp': ['f#', '.net', 'c#',
                                                              'functional-programming',
                                                              'type-providers', 'list',
                                                              'f#-interactive',
                                                              'f#-data', 'c#-to-f#',
                                                              'asynchronous',
                                                              'generics', 'recursion',
                                                              'pattern-matching',
                                                              'types', 'visual-studio',
                                                              'f#-3.0',
                                                              'discriminated-union',
                                                              'mono', 'arrays',
                                                              '.net-core', 'fparsec',
                                                              'deedle', 'wpf',
                                                              'f#-fake', 'haskell',
                                                              'sequence',
                                                              'tail-recursion',
                                                              'type-inference',
                                                              'websharper', 'function',
                                                              'parsing', 'performance',
                                                              'linq', 'ocaml', 'json',
                                                              'reflection',
                                                              'dictionary',
                                                              'computation-expression',
                                                              'tuples', 'inline',
                                                              'record', 'fscheck',
                                                              'xamarin', 'algorithm',
                                                              'visual-studio-code',
                                                              'string',
                                                              'visual-studio-2010',
                                                              'monads',
                                                              'parallel-processing',
                                                              'syntax'],
                                      'fstar': ['fstar', 'functional-programming',
                                                'formal-verification', 'fstar-mode',
                                                'exception', 'types', 'emacs', 'f#',
                                                'mono', 'gdb', 'verification',
                                                'dependent-type', 'applicative',
                                                'formal-languages', 'dafny', 'lean',
                                                'linear-types'], 'factor': [],
                                      'fancy': [],
                                      'fantom': ['fantom', 'afbedsheet', 'java',
                                                 'mongodb', 'rest', 'fancordion',
                                                 'javascript', 'macos', 'cmd', 'ide',
                                                 'inversion-of-control', 'ios', 'mysql',
                                                 'sql', 'xml', 'eclipse', 'typescript',
                                                 'performance', 'pdf', 'heroku',
                                                 'cookies', 'dll', 'highcharts',
                                                 'google-sheets', 'types',
                                                 'command-line', 'dart', 'jar',
                                                 'casting', 'oauth-2.0', 'crash', 'jvm',
                                                 'coffeescript', 'resources',
                                                 'phantomjs', 'runtime-error', 'swt',
                                                 'google-calendar-api', 'uri',
                                                 'project', 'jsx', 'webclient',
                                                 'bytecode', 'outputstream',
                                                 'language-design', 'hmac', 'ibatis',
                                                 'mlab', 'robo3t', 'buildpack'],
                                      'felix': [], 'fennel': [], 'fishshell': [],
                                      'floscript': [],
                                      'forth': ['forth', 'gforth', 'stack', 'assembly',
                                                'macos', 'c', 'gcc', 'arrays', 'string',
                                                'interpreter', 'memory-management',
                                                'compilation', 'programming-languages',
                                                'algorithm', 'arm', 'x86-64',
                                                'gnu-assembler', 'loops', 'variables',
                                                'arduino', 'compiler-construction',
                                                'gdb', 'lisp', 'biginteger',
                                                'language-design', 'factor-lang',
                                                'stack-based', 'concatenative-language',
                                                'java', 'android', 'c++', 'performance',
                                                'sorting', 'sockets', 'oop',
                                                'user-interface', 'testing', 'winapi',
                                                'math', 'networking', 'time', 'io',
                                                'callback', 'x86', 'embedded', 'gtk',
                                                'operators', 'sequence',
                                                'metaprogramming', 'atmega'],
                                      'fortranfixed': [],
                                      'fortran': ['fortran', 'gfortran', 'fortran90',
                                                  'arrays', 'intel-fortran', 'python',
                                                  'mpi', 'c', 'c++', 'fortran77',
                                                  'openmp', 'fortran95', 'f2py',
                                                  'pointers', 'parallel-processing',
                                                  'fortran-iso-c-binding', 'subroutine',
                                                  'function', 'module', 'makefile',
                                                  'matlab', 'gcc', 'linux', 'matrix',
                                                  'lapack', 'r', 'io', 'compilation',
                                                  'performance', 'dll', 'macos',
                                                  'fortran2003', 'compiler-errors',
                                                  'segmentation-fault', 'oop', 'linker',
                                                  'visual-studio', 'numpy', 'string',
                                                  'derived-types', 'windows', 'loops',
                                                  'precision', 'file-io', 'cmake',
                                                  'optimization', 'debugging',
                                                  'memory-management', 'intel', 'c#'],
                                      'foxpro': ['foxpro', 'visual-foxpro', 'sql', 'c#',
                                                 'dbf', 'database', 'sql-server',
                                                 'oledb', '.net', 'php', 'dbase',
                                                 'odbc', 'java', 'mysql', 'vb.net',
                                                 'python', 'com', 'asp.net',
                                                 'sql-server-2008', 'vb6', 'windows',
                                                 'tsql', 'excel', 'dll', 'ssis',
                                                 'linked-server', 'date', 'jdbc',
                                                 'arrays', 'delphi', 'ms-access',
                                                 'cursor', 'export', 'oledbconnection',
                                                 'xbase', 'linux', 'sqlite', 'join',
                                                 'select', 'printing', 'vbscript',
                                                 '64-bit', 'adodb', 'ole', 'clipper',
                                                 'html', 'xml', 'visual-studio',
                                                 'entity-framework', 'csv'],
                                      'freefem': [],
                                      'gap': ['gap-system', 'sage', 'math', 'package',
                                              'python', 'bash', 'wolfram-mathematica',
                                              'singular', 'c', 'linux', 'macos',
                                              'algorithm', 'matlab', 'performance',
                                              'shell', 'ubuntu', 'haskell', 'recursion',
                                              'syntax', 'interface', 'installation',
                                              'subprocess', 'export',
                                              'bit-manipulation', 'ipc', 'return-value',
                                              'graph-theory', 'bitwise-operators',
                                              'child-process', 'symbolic-math',
                                              'algebra', 'side-effects',
                                              'non-interactive', 'clique', 'pari-gp',
                                              'clique-problem', 'magma',
                                              'abstract-algebra', 'integer-partition',
                                              'groebner-basis'],
                                      'gdscript': ['gdscript', 'godot', 'game-engine',
                                                   'game-physics', 'nodes',
                                                   'game-development', 'animation',
                                                   'signals', 'json', 'input', '3d',
                                                   'arrays', 'networking', '2d',
                                                   'sprite', 'collision', 'multiplayer',
                                                   'scene', 'python', 'android', 'math',
                                                   'save', 'mouse', 'database',
                                                   'function', 'firebase', 'class',
                                                   'dictionary', 'for-loop', 'random',
                                                   'colors', 'camera', 'rotation',
                                                   'position', 'export', 'instance',
                                                   'parent-child',
                                                   'collision-detection', 'loading',
                                                   'viewport', 'path-finding', 'a-star',
                                                   'procedural-generation', 'neovim',
                                                   'javascript', 'c#', 'python-3.x',
                                                   'xcode', 'multithreading', 'pandas'],
                                      'glshader': [], 'gas': [],
                                      'genshi': ['genshi', 'python', 'trac',
                                                 'templates', 'turbogears2', 'html',
                                                 'pylons', 'javascript', 'cherrypy',
                                                 'xml', 'xhtml', 'mako', 'forms',
                                                 'xpath', 'syntax-error',
                                                 'template-engine', 'turbogears',
                                                 'java', 'css', 'angularjs', 'django',
                                                 'linux', 'image', 'python-2.7', 'csv',
                                                 'dictionary', 'memory', 'svn',
                                                 'plugins', 'parameters', 'pagination',
                                                 'sqlalchemy', 'get', 'stream',
                                                 'localization', 'nested',
                                                 'internationalization', 'escaping',
                                                 'handlebars.js', 'pdf-generation',
                                                 'match', 'textarea', 'jinja2',
                                                 'profiling', 'generator', 'newline',
                                                 'codeblocks', 'python-2.x', 'pyramid',
                                                 'wsgi'], 'gettext': ['gettext', 'php',
                                                                      'internationalization',
                                                                      'python',
                                                                      'localization',
                                                                      'translation',
                                                                      'django', 'java',
                                                                      'android',
                                                                      'poedit', 'po',
                                                                      'wordpress',
                                                                      'javascript',
                                                                      'php-gettext',
                                                                      'xgettext', 'c++',
                                                                      'locale',
                                                                      'selenium',
                                                                      'swing',
                                                                      'windows',
                                                                      'android-edittext',
                                                                      'linux', 'html',
                                                                      'multilingual',
                                                                      'settext', 'c',
                                                                      'string',
                                                                      'woocommerce',
                                                                      'angularjs',
                                                                      'apache',
                                                                      'jtextfield',
                                                                      'c#',
                                                                      'zend-framework',
                                                                      'mo', 'textview',
                                                                      'ruby-on-rails',
                                                                      'python-3.x',
                                                                      'selenium-webdriver',
                                                                      'macos', 'smarty',
                                                                      'django-i18n',
                                                                      'twig',
                                                                      'zend-translate',
                                                                      'setlocale',
                                                                      'regex', 'arrays',
                                                                      'codeigniter',
                                                                      'tostring',
                                                                      'angular-gettext',
                                                                      'python-babel'],
                                      'gherkin': ['gherkin', 'cucumber', 'bdd',
                                                  'specflow', 'java', 'selenium', 'c#',
                                                  'cucumber-jvm', 'ruby',
                                                  'cucumber-java', 'behat', 'testing',
                                                  'automated-tests', 'automation',
                                                  'cucumberjs', 'javascript',
                                                  'python-behave', 'php', 'python',
                                                  'selenium-webdriver', 'intellij-idea',
                                                  'scenarios', '.net',
                                                  'acceptance-testing', 'karate',
                                                  'feature-file', 'regex', 'maven',
                                                  'junit', 'protractor',
                                                  'cucumber-junit', 'ruby-on-rails',
                                                  'robotframework', 'node.js', 'mink',
                                                  'eclipse', 'unit-testing', 'tdd',
                                                  'android', 'webdriver', 'watir',
                                                  'codeception', 'cypress', 'calabash',
                                                  'jbehave', 'testcafe', 'qaf', 'json',
                                                  'visual-studio', 'parsing'],
                                      'gnuplot': ['gnuplot', 'plot', 'histogram',
                                                  'graph', 'python', 'bash', 'linux',
                                                  'c++', 'octave', 'colors', '3d',
                                                  'label', 'heatmap', 'c', 'latex',
                                                  'csv', 'awk', 'shell', 'time',
                                                  'macos', 'matlab', 'matplotlib',
                                                  'curve-fitting', 'pipe', 'contour',
                                                  'matrix', 'bar-chart', 'legend', 'r',
                                                  'data-fitting', 'windows', 'loops',
                                                  'axis', 'perl', 'for-loop',
                                                  'terminal', 'palette', 'animation',
                                                  'charts', 'variables',
                                                  'data-visualization', 'java',
                                                  'ubuntu', 'statistics', 'eps',
                                                  'format', 'boxplot', 'function',
                                                  'visualization', 'gnuplot-iostream'],
                                      'go': ['go', 'json', 'struct', 'http',
                                             'goroutine', 'mongodb',
                                             'google-app-engine', 'slice', 'docker',
                                             'concurrency', 'go-gorm', 'arrays',
                                             'postgresql', 'pointers', 'interface',
                                             'channel', 'string', 'mysql', 'mgo', 'cgo',
                                             'reflection', 'unit-testing',
                                             'amazon-web-services', 'regex', 'testing',
                                             'xml', 'dictionary', 'linux', 'sql',
                                             'gorilla', 'grpc', 'kubernetes', 'python',
                                             'html', 'windows', 'unmarshalling',
                                             'go-gin', 'types', 'c', 'go-templates',
                                             'javascript', 'protocol-buffers', 'tcp',
                                             'go-modules', 'time', 'websocket',
                                             'database', 'templates', 'rest',
                                             'google-cloud-platform'], 'golo': [],
                                      'gooddatacl': [],
                                      'gosu': ['gosu', 'guidewire', 'java', 'ruby',
                                               'intellij-idea', 'xml', 'parsing', 'sql',
                                               'reflection', 'pcf', 'codenarc', 'regex',
                                               'spring', 'oracle', 'macos', 'scala',
                                               'csv', 'docker', 'oop', 'variables',
                                               'tomcat', 'generics', 'search', 'jdbc',
                                               'svn', 'lambda', 'file-io',
                                               'error-handling', 'java-8', 'enums',
                                               'hyperlink', 'xsd', 'sdk', 'jvm',
                                               'rubygems', 'switch-statement', 'set',
                                               'syntax-error', 'overriding',
                                               'spring-batch', 'tortoisesvn',
                                               'warnings', 'batch-processing',
                                               'private', 'static-methods',
                                               'development-environment',
                                               'compiler-warnings', 'final', 'jacoco',
                                               'java-11'], 'gosutemplate': [],
                                      'groff': ['groff', 'troff', 'manpage', 'linux',
                                                'unix', 'formatting', 'pdf', 'bash',
                                                'java', 'c', 'image', 'shell', 'math',
                                                'text', 'vim', 'makefile', 'printing',
                                                'syntax', 'terminal', 'scripting',
                                                'imagemagick', 'escaping',
                                                'pdf-generation', 'ascii', 'markdown',
                                                'command-line-arguments', 'travis-ci',
                                                'export-to-csv', 'distribution',
                                                'bison', 'environment', 'pandoc', 'eof',
                                                'text-processing', 'preview',
                                                'equation', 'cat', 'postscript',
                                                'file-type', 'units-of-measurement',
                                                'rfc', 'bsd', 'chroot', 'ansi-escape',
                                                'ascii-art', 'lalr', 'jison',
                                                'formatted-text', 'tbl'],
                                      'groovy': ['groovy', 'grails', 'java', 'jenkins',
                                                 'gradle', 'jenkins-pipeline', 'soapui',
                                                 'spock', 'json', 'xml', 'spring',
                                                 'jenkins-groovy', 'gorm',
                                                 'unit-testing', 'intellij-idea',
                                                 'maven', 'regex', 'eclipse', 'jmeter',
                                                 'closures', 'geb', 'jenkins-plugins',
                                                 'android', 'hibernate', 'rest',
                                                 'spring-boot', 'sql', 'testing',
                                                 'string', 'build.gradle',
                                                 'elasticsearch', 'list', 'xmlslurper',
                                                 'arrays', 'gsp', 'javascript', 'soap',
                                                 'junit', 'groovyshell', 'shell',
                                                 'mocking', 'jenkins-job-dsl', 'git',
                                                 'ant', 'dsl', 'dictionary',
                                                 'metaprogramming', 'httpbuilder',
                                                 'jira', 'mysql'], 'hlslshader': [],
                                      'haml': ['haml', 'ruby-on-rails', 'ruby', 'html',
                                               'javascript', 'ruby-on-rails-3', 'css',
                                               'jquery', 'sinatra', 'ruby-on-rails-4',
                                               'sass', 'erb', 'twitter-bootstrap',
                                               'forms', 'coffeescript', 'simple-form',
                                               'angularjs', 'middleman', 'ajax',
                                               'devise', 'ruby-on-rails-3.2', 'php',
                                               'backbone.js', 'view', 'markdown',
                                               'rubygems', 'ruby-on-rails-3.1',
                                               'slim-lang', 'compass-sass', 'templates',
                                               'helper', 'json', 'partials', 'pug',
                                               'if-statement', 'routes', 'heroku',
                                               'padrino', 'arrays', 'checkbox',
                                               'link-to', 'yaml', 'asset-pipeline',
                                               'partial-views', 'syntax', 'form-for',
                                               'python', 'vim', 'drop-down-menu',
                                               'hyperlink'], 'handlebarshtml': [],
                                      'haskell': ['haskell', 'functional-programming',
                                                  'monads', 'ghc', 'types', 'list',
                                                  'cabal', 'typeclass', 'yesod',
                                                  'recursion', 'haskell-stack', 'ghci',
                                                  'parsing', 'io', 'lazy-evaluation',
                                                  'function', 'pattern-matching',
                                                  'monad-transformers', 'parsec',
                                                  'performance', 'string', 'fold',
                                                  'applicative', 'functor', 'tuples',
                                                  'list-comprehension', 'haskell-lens',
                                                  'tree', 'syntax', 'algorithm',
                                                  'aeson', 'quickcheck',
                                                  'template-haskell', 'scala', 'ffi',
                                                  'type-families', 'polymorphism',
                                                  'state-monad', 'json',
                                                  'category-theory', 'gadt',
                                                  'cabal-install', 'optimization',
                                                  'haskell-platform', 'type-inference',
                                                  'random', 'data-structures',
                                                  'algebraic-data-types', 'conduit',
                                                  'exception'],
                                      'haxe': ['haxe', 'openfl', 'flash', 'haxeflixel',
                                               'actionscript-3', 'javascript',
                                               'flashdevelop', 'android', 'macros',
                                               'nme', 'haxelib', 'c++', 'neko', 'hxcpp',
                                               'html', 'ios', 'arrays', 'generics',
                                               'intellij-idea', 'types', 'php', 'java',
                                               'actionscript', 'lime', 'xml', 'windows',
                                               'macos', 'createjs', 'fdt', 'class',
                                               'enums', 'compilation', 'haxepunk',
                                               'regex', 'sockets', 'compiler-errors',
                                               'flambe', 'debugging', 'reflection',
                                               'haxeui', 'json', 'linux', 'string',
                                               'bitmap', 'sprite', 'python', 'oop',
                                               'inheritance', 'exception', 'interface'],
                                      'hsail': [],
                                      'html': ['html', 'css', 'javascript', 'jquery',
                                               'php', 'twitter-bootstrap', 'forms',
                                               'angularjs', 'ajax', 'python', 'mysql',
                                               'image', 'angular', 'asp.net', 'java',
                                               'c#', 'wordpress', 'canvas', 'dom',
                                               'google-chrome', 'bootstrap-4', 'iframe',
                                               'html-table', 'flexbox', 'json',
                                               'android', 'web', 'reactjs', 'svg',
                                               'internet-explorer', 'django',
                                               'twitter-bootstrap-3',
                                               'responsive-design', 'node.js',
                                               'firefox', 'ios', 'xml', 'asp.net-mvc',
                                               'arrays', 'regex', 'video', 'jsp',
                                               'input', 'typescript', 'email',
                                               'ruby-on-rails', 'button',
                                               'drop-down-menu', 'checkbox',
                                               'jquery-ui'], 'htmlphp': [],
                                      'hxml': ['haxe', 'hxml', 'command-line',
                                               'compiler-errors', 'sublimetext',
                                               'actionscript-2', 'haxepunk',
                                               'swf-compiler'],
                                      'hy': ['hy', 'python', 'lisp', 'python-3.x',
                                             'pandas', 'macros', 'dataframe', 'eval',
                                             'arrays', 'django', 'string', 'bash', 'qt',
                                             'numpy', 'parsing', 'recursion', 'replace',
                                             'import', 'visual-studio-code', 'emacs',
                                             'beautifulsoup', 'functional-programming',
                                             'compiler-construction', 'multiprocessing',
                                             'anaconda', 'jupyter', 'pytest', 'apply',
                                             'python-import', 'pyinstaller', 'pyside',
                                             'python-multiprocessing',
                                             'abstract-syntax-tree', 'substitution',
                                             'read-eval-print-loop', 'typing',
                                             'destructuring', 'emacs24', 'jupyter-lab',
                                             'shebang', 'vscode-debugger',
                                             'the-little-schemer', 'zipapp'],
                                      'hybris': ['hybris', 'java', 'spring',
                                                 'backoffice', 'impex', 'solr',
                                                 'e-commerce', 'sap',
                                                 'spartacus-storefront', 'spring-mvc',
                                                 'tomcat', 'ant', 'mysql',
                                                 'sap-commerce-cloud',
                                                 'flexible-search', 'hybris-data-hub',
                                                 'spring-security', 'commerce', 'cron',
                                                 'promotions', 'jsp', 'web-services',
                                                 'sql', 'rest', 'intellij-idea',
                                                 'content-management-system', 'xml',
                                                 'storefront', 'authentication',
                                                 'orbeon', 'angular', 'import',
                                                 'add-on', 'smartedit', 'javascript',
                                                 'database', 'eclipse', 'email',
                                                 'logging', 'groovy', 'customization',
                                                 'b2b', 'forms', 'junit', 'sonarqube',
                                                 'facet', 'jakarta-ee', 'redirect',
                                                 'aem', 'faceted-search'],
                                      'idl': ['idl', 'c++', 'com', 'corba', 'java',
                                              'midl', 'c#', 'atl', 'rpc', 'visual-c++',
                                              'typelib', 'python', 'arrays', 'windows',
                                              'thrift', 'com-interop',
                                              'idl-programming-language',
                                              'visual-studio', 'avro', 'tao', '.net',
                                              'winapi', 'interop', 'protocol-buffers',
                                              'javascript', 'vb6', 'omniorb', 'c',
                                              'delphi', 'interface',
                                              'data-distribution-service', 'jacorb',
                                              'linux', 'visual-studio-2010',
                                              'windows-runtime', 'json', 'struct',
                                              'enums', 'ace', 'string', 'api', 'c++11',
                                              'mfc', 'html', 'eclipse', 'makefile',
                                              'uwp', 'cmake', 'visual-studio-2008',
                                              'compiler-errors'],
                                      'icon': ['icons', 'android', 'css', 'java',
                                               'html', 'c#', 'ios', 'swing', 'windows',
                                               'javascript', 'image', 'iphone',
                                               'font-awesome', 'wpf', 'c++', 'svg',
                                               'xcode', 'button', 'python', 'fonts',
                                               'macos', 'jquery', '.net', 'reactjs',
                                               'winforms', 'qt', 'winapi',
                                               'twitter-bootstrap', 'user-interface',
                                               'menu', 'react-native', 'notifications',
                                               'android-actionbar', 'eclipse',
                                               'flutter', 'delphi', 'android-studio',
                                               'visual-studio', 'resources', 'favicon',
                                               'cordova', 'objective-c', 'toolbar',
                                               'vb.net', 'jbutton', 'angular',
                                               'wordpress', 'material-design',
                                               'shortcut', 'taskbar'],
                                      'idris': ['idris', 'dependent-type', 'haskell',
                                                'agda', 'functional-programming',
                                                'proof', 'theorem-proving', 'coq',
                                                'types', 'pattern-matching', 'cabal',
                                                'totality', 'monads', 'equality',
                                                'typeclass', 'proof-of-correctness',
                                                'recursion', 'scala', 'vector',
                                                'syntax', 'typechecking',
                                                'type-level-computation',
                                                'type-inference', 'unification',
                                                'type-theory', 'interface',
                                                'lazy-evaluation', 'ffi', 'list', 'ghc',
                                                'read-eval-print-loop', 'parsing',
                                                'import', 'emacs', 'record',
                                                'formal-verification', 'javascript',
                                                'regex', 'string', 'function', 'module',
                                                'installation', 'polymorphism',
                                                'red-black-tree', 'type-systems',
                                                'algebraic-data-types',
                                                'parser-combinators', 'gadt',
                                                'cabal-install', 'lightyear'],
                                      'igor': ['igor', 'matlab', 'c', 'r', 'string',
                                               'ggplot2', 'plot', 'import', 'export',
                                               'refactoring', 'gnuplot', 'physics',
                                               'curve-fitting', 'hdf5', 'netcdf',
                                               'exponential', 'originlab'],
                                      'inform6': [], 'inform6template': [],
                                      'inform7': ['inform7', 'javascript', 'object',
                                                  'if-statement', 'random',
                                                  'reflection', 'internationalization',
                                                  'command', 'runtime-error',
                                                  'containers', 'action', 'centering',
                                                  'creation', 'parchment'],
                                      'ini': ['ini', 'php', 'python', 'c#', 'c++',
                                              'configuration', 'config', 'parsing',
                                              'java', 'delphi', 'file', 'configparser',
                                              'powershell', 'windows', 'batch-file',
                                              'apache', 'vb.net', 'qt', 'arrays',
                                              'perl', 'configuration-files', 'winapi',
                                              'c', '.net', 'zend-framework',
                                              'qsettings', 'regex', 'xml', 'mysql',
                                              'bash', 'settings', 'javascript',
                                              'string', 'python-3.x', 'eclipse', 'json',
                                              '.htaccess', 'installation', 'linux',
                                              'inno-setup', 'html', 'session', 'boost',
                                              'vbscript', 'ini4j', 'winforms', 'path',
                                              'omnet++', 'android', 'vba'],
                                      'io': ['io', 'java', 'file', 'python', 'c', 'c++',
                                             'c#', 'haskell', 'linux', 'file-io',
                                             'android', 'multithreading', 'string',
                                             'arrays', '.net', 'performance', 'stream',
                                             'sockets', 'python-3.x', 'input', 'ruby',
                                             'windows', 'nio', 'csv', 'exception',
                                             'asynchronous', 'inputstream', 'go',
                                             'bufferedreader', 'fortran', 'node.js',
                                             'monads', 'buffer', 'javascript',
                                             'python-2.7', 'scala', 'binary', 'text',
                                             'perl', 'filesystems', 'unix', 'php',
                                             'bash', 'java.util.scanner', 'list',
                                             'process', 'directory', 'loops', 'output',
                                             'parsing'],
                                      'ioke': ['ioke', 'java', 'ruby', 'windows',
                                               'rspec', 'clojure', 'jvm',
                                               'programming-languages', 'rdoc',
                                               'embedded-language'], 'irclogs': [],
                                      'isabelle': ['isabelle', 'theorem-proving',
                                                   'isar', 'proof', 'logic', 'coq',
                                                   'types', 'set', 'hol', 'jedit',
                                                   'formal-verification', 'induction',
                                                   'code-generation', 'ml',
                                                   'termination', 'matrix', 'syntax',
                                                   'recursion', 'latex', 'scala',
                                                   'function', 'functional-programming',
                                                   'typeclass', 'definition', 'agda',
                                                   'quantifiers', 'binary-tree',
                                                   'locale', 'formal-methods', 'math',
                                                   'z3', 'sml', 'solver',
                                                   'polynomial-math', 'theorem',
                                                   'coinduction', 'list', 'performance',
                                                   'haskell', 'lambda', 'symbols',
                                                   'transformation', 'equality',
                                                   'predicate',
                                                   'higher-order-functions', 'smt',
                                                   'formal-languages', 'simplification',
                                                   'first-order-logic',
                                                   'proof-general'],
                                      'j': ['j', 'tacit-programming', 'arrays', 'apl',
                                            'functional-programming', 'list',
                                            'function', 'matrix', 'math', 'python',
                                            'linux', 'haskell', 'vector', 'refactoring',
                                            'k', 'c', 'recursion', 'optimization',
                                            'input', 'while-loop', 'emacs',
                                            'installation', 'type-conversion',
                                            'numbers', 'macos', 'file', 'loops',
                                            'numpy', 'sorting', 'search',
                                            'multidimensional-array', 'random', 'plot',
                                            'syntax', 'io', 'syntax-error', 'operators',
                                            'shared-libraries', 'racket', 'stdin',
                                            'grammar', 'primes', 'interpreter',
                                            'org-mode', 'readline', 'theory', 'modulo',
                                            'rank', 'argv', 'c++'],
                                      'jags': ['jags', 'r', 'bayesian', 'rjags',
                                               'r2jags', 'winbugs', 'runjags', 'mcmc',
                                               'hierarchical-bayesian', 'stan',
                                               'statistics', 'mixture-model',
                                               'r2winbugs', 'if-statement',
                                               'parallel-processing', 'model',
                                               'regression', 'distribution', 'openbugs',
                                               'python', 'logistic-regression', 'glm',
                                               'dirichlet', 'arrays', 'linux',
                                               'for-loop', 'matrix', 'compiler-errors',
                                               'constraints', 'missing-data',
                                               'survival-analysis',
                                               'hidden-markov-models', 'poisson',
                                               'multinomial', 'winbugs14',
                                               'jags.parallel', 'list', 'loops', 'plot',
                                               'foreach', 'parameters', 'installation',
                                               'runtime-error', 'homebrew',
                                               'linear-regression', 'simulation',
                                               'prediction', 'hierarchical-data',
                                               'modeling', 'anova'],
                                      'jasmin': ['jasmin', 'java', 'jvm', 'bytecode',
                                                 'java-bytecode-asm',
                                                 'compiler-construction',
                                                 'jvm-bytecode', 'android', 'assembly',
                                                 'antlr', 'dalvik', 'classpath',
                                                 'arrays', 'angular', 'string',
                                                 'eclipse', 'algorithm', 'function',
                                                 'if-statement', 'gradle', 'exception',
                                                 'kotlin', 'jar', 'ant', 'format',
                                                 'stack', 'try-catch', 'field',
                                                 'classloader', 'constants', 'grammar',
                                                 'long-integer', 'space', 'final',
                                                 'disassembly', 'pool', 'freepascal',
                                                 'subroutine', 'decompiling', 'dex',
                                                 'instructions',
                                                 'bytecode-manipulation',
                                                 'angular-test', '.class-file', 'smali',
                                                 'verifyerror', 'recompile',
                                                 'jvm-languages', 'yourkit', 'soot'],
                                      'java': ['java', 'android', 'spring', 'swing',
                                               'eclipse', 'hibernate', 'spring-boot',
                                               'arrays', 'maven', 'multithreading',
                                               'json', 'xml', 'string', 'spring-mvc',
                                               'mysql', 'jpa', 'jsp', 'arraylist',
                                               'servlets', 'tomcat', 'regex', 'javafx',
                                               'jdbc', 'javascript', 'selenium',
                                               'android-studio', 'rest', 'sql',
                                               'jakarta-ee', 'junit', 'generics',
                                               'java-8', 'exception', 'html',
                                               'intellij-idea', 'netbeans',
                                               'web-services', 'sockets', 'algorithm',
                                               'jar', 'file', 'database',
                                               'user-interface', 'selenium-webdriver',
                                               'gradle', 'class', 'methods',
                                               'performance', 'jackson', 'collections'],
                                      'javascript': ['javascript', 'jquery', 'html',
                                                     'css', 'node.js', 'php', 'reactjs',
                                                     'angularjs', 'ajax', 'arrays',
                                                     'json', 'angular', 'typescript',
                                                     'regex', 'asp.net', 'vue.js', 'c#',
                                                     'forms', 'twitter-bootstrap',
                                                     'express', 'google-chrome',
                                                     'd3.js', 'dom', 'react-native',
                                                     'ecmascript-6', 'object', 'java',
                                                     'google-maps', 'canvas',
                                                     'function', 'mongodb', 'firebase',
                                                     'android', 'mysql', 'asp.net-mvc',
                                                     'ruby-on-rails', 'iframe', 'svg',
                                                     'jquery-ui', 'wordpress', 'python',
                                                     'google-chrome-extension',
                                                     'promise', 'cordova', 'webpack',
                                                     'highcharts', 'internet-explorer',
                                                     'google-maps-api-3', 'firefox',
                                                     'asynchronous'],
                                      'jcl': ['jcl', 'mainframe', 'zos', 'cobol',
                                              'dfsort', 'sorting', 'db2', 'syncsort',
                                              'rexx', 'vsam', 'java', 'ftp', 'dataset',
                                              'mvs', 'ispf', 'tso', 'cics', 'sql',
                                              'unix', 'sas', 'utilities', 'csv',
                                              'batch-processing', 'gnucobol', 'ims-db',
                                              'c#', 'regex', 'excel', 'xml', 'shell',
                                              'file', 'perl', 'email', 'security',
                                              'parsing', 'assembly', 'parameters',
                                              'automation', 'duplicates', 'smtp',
                                              'parameter-passing', 'job-scheduling',
                                              'spool', 'control-m', 'db2-zos',
                                              'return-code', 'easytrieve', 'sdsf',
                                              'python', 'html'], 'jsgf': [],
                                      'jsonld': [],
                                      'json': ['json', 'javascript', 'php', 'jquery',
                                               'java', 'android', 'python', 'c#',
                                               'arrays', 'ajax', 'html', 'node.js',
                                               'angularjs', 'ios', 'rest', 'api',
                                               'mysql', 'jackson', 'parsing', 'swift',
                                               'json.net', 'serialization', 'gson',
                                               'ruby-on-rails', 'asp.net', 'xml',
                                               'asp.net-mvc', 'spring', 'angular',
                                               'object', 'objective-c', 'python-3.x',
                                               'reactjs', 'sql', 'mongodb',
                                               'dictionary', 'django', 'ruby',
                                               'web-services', '.net', 'postgresql',
                                               'post', 'scala', 'jq', 'deserialization',
                                               'curl', 'http', 'csv', 'pandas',
                                               'laravel'],
                                      'jsp': ['jsp', 'java', 'servlets', 'javascript',
                                              'html', 'spring', 'spring-mvc', 'jquery',
                                              'jstl', 'struts2', 'tomcat', 'ajax',
                                              'mysql', 'jakarta-ee', 'eclipse', 'css',
                                              'el', 'struts', 'jsp-tags', 'hibernate',
                                              'json', 'forms', 'session', 'jdbc', 'jsf',
                                              'spring-boot', 'sql', 'xml',
                                              'model-view-controller', 'javabeans',
                                              'maven', 'web-applications', 'database',
                                              'netbeans', 'web', 'struts-1', 'liferay',
                                              'ognl', 'taglib', 'google-app-engine',
                                              'validation', 'file-upload', 'image',
                                              'oracle', 'arraylist', 'spring-security',
                                              'apache', 'angularjs', 'php',
                                              'displaytag'],
                                      'julia': ['julia', 'arrays', 'dataframe',
                                                'python', 'parallel-processing',
                                                'julia-jump', 'types', 'plot', 'matrix',
                                                'performance', 'matplotlib',
                                                'ijulia-notebook', 'function',
                                                'plots.jl', 'optimization', 'r',
                                                'jupyter-notebook', 'metaprogramming',
                                                'string', 'package', 'macros', 'gadfly',
                                                'multidimensional-array', 'dictionary',
                                                'for-loop', 'struct', 'multithreading',
                                                'matlab', 'module', 'linear-algebra',
                                                'juno-ide', 'atom-editor',
                                                'differentialequations.jl', 'jupyter',
                                                'c', 'csv', 'differential-equations',
                                                'type-conversion', 'vector', 'random',
                                                'indexing', 'machine-learning',
                                                'sparse-matrix', 'c++', 'io', 'windows',
                                                'tuples', 'ode', 'graph', 'file'],
                                      'juttle': ['juttle', 'specifications'],
                                      'kal': ['kal', 'ios', 'iphone', 'xcode',
                                              'objective-c', 'calendar', 'ios8', 'ios6',
                                              'storyboard', 'swift', 'api',
                                              'uitableview', 'date', 'cocoa-touch',
                                              'ipad', 'uiviewcontroller', 'ios7', 'dns',
                                              'ios5', 'crash', 'xcode6', 'titanium',
                                              'nsdate', 'hide', 'static-libraries',
                                              'open-source', 'automatic-ref-counting',
                                              'uitabbar', 'titanium-mobile',
                                              'uisegmentedcontrol', 'xcode4.5',
                                              'uinavigationitem', 'ios-universal-app',
                                              'dig', 'tapku'],
                                      'kconfig': ['kconfig', 'u-boot',
                                                  'beagleboneblack', 'kde', 'esp32',
                                                  'kbuild', 'c++', 'c', 'qt',
                                                  'visual-studio-code', 'build',
                                                  'cmake', 'configuration',
                                                  'linux-kernel', 'kernel', 'settings',
                                                  'linux-device-driver', 'yocto',
                                                  'kernel-module', 'i2c', 'openwrt',
                                                  'can-bus', 'beagleboard',
                                                  'debian-buster', 'kde-plasma',
                                                  'esp-idf', 'zephyr-rtos', 'kdelibs'],
                                      'kernellog': [], 'koka': [],
                                      'kotlin': ['kotlin', 'android', 'java',
                                                 'android-studio',
                                                 'android-recyclerview',
                                                 'kotlin-coroutines', 'gradle',
                                                 'firebase', 'spring-boot',
                                                 'android-fragments', 'android-room',
                                                 'spring', 'generics', 'intellij-idea',
                                                 'json', 'retrofit2', 'retrofit',
                                                 'rx-java2', 'android-layout',
                                                 'dagger-2', 'android-livedata',
                                                 'unit-testing', 'rx-java', 'mvvm',
                                                 'google-cloud-firestore', 'xml',
                                                 'firebase-realtime-database',
                                                 'kotlin-android-extensions', 'mockito',
                                                 'gson', 'android-databinding',
                                                 'arrays', 'android-intent',
                                                 'android-activity', 'coroutine',
                                                 'lambda', 'gradle-kotlin-dsl', 'junit',
                                                 'android-jetpack',
                                                 'kotlin-multiplatform', 'ktor',
                                                 'reflection', 'dependency-injection',
                                                 'android-viewmodel', 'sqlite',
                                                 'jackson', 'fragment',
                                                 'kotlin-extension', 'hibernate',
                                                 'tornadofx'],
                                      'lsl': ['linden-scripting-language', 'php',
                                              'javascript', 'c#', 'json', 'algorithm',
                                              'math', 'java', 'python', 'jquery',
                                              'html', 'c++', 'mysql', 'sql', 'arrays',
                                              'regex', 'ajax', 'string', 'eclipse',
                                              'matlab', 'entity-framework', 'rest',
                                              'parsing', 'object', 'google-app-engine',
                                              'networking', 'random', 'parse-platform',
                                              'tcp', 'concurrency', 'syntax',
                                              'version-control', 'scripting',
                                              'permissions', 'eclipse-plugin',
                                              'rotation', 'mono', 'synchronization',
                                              'stack', 'base64', 'syntax-error',
                                              'video-streaming', 'bit-manipulation',
                                              'jquery-animate', '2d', 'webgl',
                                              'mouseevent', 'c-preprocessor', 'chat',
                                              'virtual'], 'lasso': [],
                                      'lean': ['lean', 'theorem-proving',
                                               'dependent-type', 'formal-verification',
                                               'proof', 'type-theory', 'coq', 'agda',
                                               'functional-programming', 'typeclass',
                                               'visual-studio-code', 'logic', 'idris',
                                               'python', 'algorithm', 'visual-studio',
                                               'docker', 'ubuntu', 'recursion', 'math',
                                               'types', 'syntax', 'terminal',
                                               'automation', 'attributes', 'set',
                                               'boolean', 'elisp', 'command-prompt',
                                               'computer-science', 'z3', 'mergesort',
                                               'quotes', 'isabelle', 'smt', 'choice',
                                               'recursive-datastructures', 'dafny',
                                               'induction', 'negation', 'set-theory',
                                               'formal-methods', 'mutual-recursion',
                                               'decidable', 'curry-howard',
                                               'homotopy-type-theory', 'fstar',
                                               'propositional-calculus',
                                               'macos-big-sur'],
                                      'lesscss': ['less', 'css', 'twitter-bootstrap',
                                                  'html', 'javascript', 'sass',
                                                  'node.js', 'webpack',
                                                  'twitter-bootstrap-3', 'mixins',
                                                  'gruntjs', 'reactjs', 'jquery',
                                                  'less-mixins', 'php', 'gulp',
                                                  'css-selectors', 'ruby-on-rails',
                                                  'web-essentials', 'angular',
                                                  'asp.net-mvc', 'variables',
                                                  'media-queries', 'dotless',
                                                  'css-preprocessor', 'angularjs',
                                                  'visual-studio', 'symfony',
                                                  'wordpress', 'import', 'npm',
                                                  'meteor', 'compilation',
                                                  'visual-studio-2012',
                                                  'visual-studio-2013',
                                                  'responsive-design', 'asp.net',
                                                  'loops', 'c#', 'django', 'phpstorm',
                                                  'antd', 'source-maps', 'assetic',
                                                  'express', 'lessphp', 'google-chrome',
                                                  'colors', 'less.js', 'gulp-less'],
                                      'limbo': [],
                                      'liquid': ['liquid', 'shopify', 'jekyll', 'html',
                                                 'javascript', 'ruby', 'css', 'jquery',
                                                 'ruby-on-rails', 'github-pages',
                                                 'shopify-template', 'yaml', 'json',
                                                 'markdown', 'liquid-layout', 'arrays',
                                                 'for-loop', 'jekyll-extensions',
                                                 'templates', 'if-statement', 'loops',
                                                 'php', 'e-commerce', 'shopify-app',
                                                 'dotliquid', 'ajax', 'github', 'tags',
                                                 'sorting', 'sass', 'ruby-on-rails-3',
                                                 'azure-logic-apps',
                                                 'business-catalyst',
                                                 'yaml-front-matter', 'variables',
                                                 'filter', 'template-engine',
                                                 'templating', 'ruby-on-rails-4',
                                                 'collections', 'pagination', 'product',
                                                 'octopress', 'locomotivecms',
                                                 'jekyll-theme', 'image', 'layout',
                                                 'blogs', 'static-site', 'date'],
                                      'literateagda': [], 'literatecryptol': [],
                                      'literatehaskell': [], 'literateidris': [],
                                      'livescript': ['livescript', 'javascript',
                                                     'node.js', 'coffeescript',
                                                     'angularjs', 'prelude.ls', 'html',
                                                     'browserify', 'meteor',
                                                     'functional-programming', 'monads',
                                                     'source-maps',
                                                     'partial-application', 'jquery',
                                                     'css', 'typescript', 'loops',
                                                     'debugging', 'recursion',
                                                     'intellij-idea', 'canvas',
                                                     'optimization', 'npm', 'emacs',
                                                     'promise', 'callback', 'gulp',
                                                     'rxjs', 'angular-ui-router',
                                                     'gruntjs', 'package', 'closures',
                                                     'openshift', 'pug', 'webstorm',
                                                     'chromium', 'yeoman', 'bluebird',
                                                     'fs', 'void', 'translate',
                                                     'context-free-grammar', 'sections',
                                                     'writefile', 'javascript-debugger',
                                                     'ebnf', 'maybe', 'mithril.js',
                                                     'audiocontext', 'api-doc'],
                                      'llvm': ['llvm', 'clang', 'c++', 'llvm-ir', 'c',
                                               'compiler-construction', 'xcode',
                                               'llvm-c++-api', 'gcc', 'ios',
                                               'objective-c', 'macos', 'cmake',
                                               'assembly', 'linker', 'jit', 'clang++',
                                               'optimization', 'llvm-gcc', 'linux',
                                               'compiler-optimization', 'compilation',
                                               'c++11', 'python', 'haskell', 'lldb',
                                               'windows', 'swift', 'iphone', 'makefile',
                                               'debugging', 'arm', 'rust', 'emscripten',
                                               'static-analysis', 'llvm-3.0',
                                               'visual-studio', 'build', 'ubuntu',
                                               'code-generation',
                                               'abstract-syntax-tree',
                                               'compiler-errors', 'java', 'ocaml',
                                               'x86', 'libc++', 'llc', 'android',
                                               'cross-compiling', 'openmp'],
                                      'llvmmir': [],
                                      'logos': ['logos', 'ios', 'theos', 'jailbreak',
                                                'objective-c', 'cydia-substrate',
                                                'tweak', 'iphone', 'cydia', 'php',
                                                'api', 'syntax', 'uiimage', 'themes',
                                                'hook', 'iphone-privateapi', 'c#',
                                                'asp.net', 'c', 'django', 'wordpress',
                                                'list', 'function', 'xaml',
                                                'dictionary', 'url', 'uiview', 'ios7',
                                                'uiscrollview', 'header', 'linker',
                                                'uibutton', 'integer', 'ios6', 'icons',
                                                'xna', 'wordpress-theming', 'nsstring',
                                                'opencart', 'e-commerce',
                                                'nsdictionary', 'categories',
                                                'customization', 'reverse-engineering',
                                                'grammar', 'uialertview',
                                                'nsurlsession', 'sandbox',
                                                'implementation', 'display'],
                                      'logtalk': ['logtalk', 'prolog', 'swi-prolog',
                                                  'object', 'variables', 'database',
                                                  'list', 'http', 'optimization',
                                                  'serialization', 'numbers', 'integer',
                                                  'save', 'gzip', 'protocols',
                                                  'loading', 'identifier', 'dcg',
                                                  'late-binding', 'meta-predicate',
                                                  'xpce'],
                                      'lua': ['lua', 'coronasdk', 'c++', 'lua-table',
                                              'c', 'roblox', 'string', 'torch', 'nginx',
                                              'love2d', 'redis', 'function', 'android',
                                              'luajit', 'lua-patterns', 'nodemcu',
                                              'python', 'arrays', 'c#', 'openresty',
                                              'esp8266', 'scripting', 'java', 'ios',
                                              'windows', 'luasocket', 'variables',
                                              'luarocks', 'lua-api', 'oop', 'luabind',
                                              'metatable', 'regex', 'linux', 'loops',
                                              'json', 'math', 'sockets', 'random',
                                              'garrys-mod', 'wireshark', 'mysql', 'sdk',
                                              'world-of-warcraft', 'javascript',
                                              'awesome-wm', 'computercraft', 'sorting',
                                              'for-loop', 'http'], 'moocode': [],
                                      'makefile': ['makefile', 'c++', 'c', 'gnu-make',
                                                   'linux', 'gcc', 'cmake', 'bash',
                                                   'compilation', 'build', 'shell',
                                                   'android', 'g++', 'macos', 'windows',
                                                   'linker', 'ubuntu', 'python', 'gnu',
                                                   'qt', 'eclipse', 'unix', 'java',
                                                   'cygwin', 'autotools', 'automake',
                                                   'mingw', 'linux-kernel',
                                                   'android-ndk', 'configure',
                                                   'compiler-errors', 'dependencies',
                                                   'installation', 'opencv', 'fortran',
                                                   'shared-libraries', 'autoconf',
                                                   'qmake', 'cross-compiling', 'c++11',
                                                   'git', 'xcode', 'docker',
                                                   'eclipse-cdt', 'nmake', 'kernel',
                                                   'perl', 'include', 'boost',
                                                   'static-libraries'],
                                      'mako': ['mako', 'python', 'pyramid', 'templates',
                                               'pylons', 'cherrypy', 'django', 'html',
                                               'javascript', 'template-engine',
                                               'jinja2', 'python-3.x',
                                               'django-templates', 'jquery',
                                               'python-2.7', 'odoo', 'bottle',
                                               'unicode', 'css', 'json', 'flask',
                                               'forms', 'function', 'sqlalchemy',
                                               'internationalization', 'turbogears',
                                               'ajax', 'linux', 'google-app-engine',
                                               'escaping', 'odoo-8', 'xml',
                                               'inheritance', 'include', 'openerp-7',
                                               'templating', 'turbogears2', 'genshi',
                                               'php', 'string', 'twitter-bootstrap',
                                               'unit-testing', 'validation',
                                               'dictionary', 'variables', 'debugging',
                                               'caching', 'vim', 'knockout.js',
                                               'module'],
                                      'maql': ['maql', 'gooddata', 'customer',
                                               'cloud-connect'],
                                      'markdown': ['markdown', 'r', 'html', 'pandoc',
                                                   'github', 'javascript', 'r-markdown',
                                                   'python', 'jekyll', 'knitr', 'latex',
                                                   'github-flavored-markdown', 'css',
                                                   'php', 'regex', 'jupyter-notebook',
                                                   'ruby', 'reactjs', 'github-pages',
                                                   'pdf', 'django', 'ruby-on-rails',
                                                   'rstudio', 'visual-studio-code',
                                                   'node.js', 'vim', 'gatsby',
                                                   'doxygen', 'jquery', 'image',
                                                   'kramdown', 'syntax-highlighting',
                                                   'c#', 'redcarpet', 'hugo', 'wiki',
                                                   'java', 'mathjax', 'parsing',
                                                   'documentation', 'liquid', 'git',
                                                   'yaml', 'jupyter', 'shiny', 'gitlab',
                                                   'readme', 'markup', 'emacs',
                                                   'pagedown'],
                                      'mask': ['mask', 'python', 'css', 'ios', 'jquery',
                                               'javascript', 'numpy', 'svg', 'opencv',
                                               'html', 'image', 'android', 'swift',
                                               'image-processing', 'arrays', 'c#',
                                               'objective-c', 'matlab', 'java', 'c++',
                                               'masking', 'input', 'pandas', 'calayer',
                                               'actionscript-3', 'uiimage', 'iphone',
                                               'regex', 'flash', 'tensorflow', 'uiview',
                                               'uiimageview', 'c', 'python-3.x',
                                               'animation', 'clip', 'php', 'unity3d',
                                               'canvas', 'wpf', 'filter', 'r',
                                               'firefox', 'layer', 'indexing',
                                               'gradient', '.htaccess', 'dataframe',
                                               'core-graphics', 'clipping'],
                                      'mason': ['mason', 'perl', 'javascript', 'apache',
                                                'html', 'json', 'redirect', 'mod-perl',
                                                'jquery', 'mod-perl2', 'ajax', 'cgi',
                                                'moose', 'arrays', 'regex', 'rest',
                                                'http', 'web-applications',
                                                'frameworks', 'internationalization',
                                                'apache2', 'plack', 'rt', 'psgi',
                                                'rose-db-object', 'joose', 'poet',
                                                'java', 'node.js', 'excel', 'windows',
                                                'image', 'facebook', 'unit-testing',
                                                'validation', 'email', 'datetime',
                                                'oop', 'dictionary', 'security', 'unix',
                                                'authentication', 'ssl', 'url', 'post',
                                                'caching', 'intellij-idea',
                                                'optimization', 'cookies', 'vim'],
                                      'mathematica': ['wolfram-mathematica', 'plot',
                                                      'math', 'mathematica-8', 'python',
                                                      'matlab', 'list', 'function',
                                                      'matrix', 'mathematica-frontend',
                                                      'differential-equations',
                                                      'graphics', 'wolframalpha',
                                                      'mathematical-optimization',
                                                      'algorithm', 'wolfram-language',
                                                      'optimization', 'graph', '3d',
                                                      'arrays', 'java', 'symbolic-math',
                                                      'r', 'image-processing',
                                                      'recursion', 'import',
                                                      'performance', 'mathlink', 'c++',
                                                      'functional-programming', 'loops',
                                                      'export', 'equation-solving',
                                                      'image', 'variables',
                                                      'integration', 'equation', 'c#',
                                                      'dynamic', 'for-loop', 'geometry',
                                                      'mathematical-expressions',
                                                      'string', 'physics', 'maple',
                                                      'python-3.x', 'numpy', 'select',
                                                      'parallel-processing',
                                                      'statistics'],
                                      'matlab': ['matlab', 'matrix', 'image-processing',
                                                 'plot', 'arrays', 'python',
                                                 'matlab-figure', 'image', 'simulink',
                                                 'c++', 'octave', 'function',
                                                 'for-loop', 'vector',
                                                 'signal-processing', 'vectorization',
                                                 'user-interface', 'matlab-guide',
                                                 'mex', 'computer-vision', 'loops',
                                                 'optimization', 'performance', 'java',
                                                 'fft', 'string', 'machine-learning',
                                                 'algorithm', 'math', 'neural-network',
                                                 'cell-array', 'c', 'numpy', 'opencv',
                                                 'indexing', 'cell', '3d', 'excel',
                                                 'random', 'r', 'parallel-processing',
                                                 'graph', 'symbolic-math',
                                                 'interpolation', 'c#', 'statistics',
                                                 'matlab-cvst', 'file-io',
                                                 'multidimensional-array', 'histogram'],
                                      'miniscript': [],
                                      'modelica': ['modelica', 'dymola', 'openmodelica',
                                                   'jmodelica', 'python', 'fmi',
                                                   'systemmodeler', 'simulation',
                                                   'modeling', 'arrays', 'c',
                                                   'function', 'matlab', 'annotations',
                                                   'pyfmi', 'fluid-dynamics', 'events',
                                                   'parameters', 'c++', 'algorithm',
                                                   'inheritance', 'initialization',
                                                   'if-statement', 'time', 'dll',
                                                   'iteration',
                                                   'conditional-statements',
                                                   'interpolation', 'equation', 'fluid',
                                                   'solver', 'connector', 'derivative',
                                                   'python-2.7', 'debugging',
                                                   'optimization', 'import',
                                                   'compiler-errors', 'stream',
                                                   'external', 'physics', 'ode', 'pde',
                                                   'user-interface', 'ubuntu',
                                                   'variables', 'vector', 'plot',
                                                   'attributes', 'boolean'],
                                      'modula2': [],
                                      'monkey': ['monkey', 'android', 'testing',
                                                 'monkeyrunner', 'adb', 'java',
                                                 'android-emulator', 'python',
                                                 'android-monkey', 'stress-testing',
                                                 'shell', 'jenkins', 'automated-tests',
                                                 'ios', 'android-activity', 'package',
                                                 'command-line', 'android-testing',
                                                 'javascript', 'c', 'iphone', 'regex',
                                                 'ruby', 'xml', 'database', 'windows',
                                                 'multithreading', 'eclipse', 'bash',
                                                 'powershell', 'unit-testing',
                                                 'android-studio', 'android-layout',
                                                 'security', 'batch-file', 'delphi',
                                                 'gradle', 'exception', 'networking',
                                                 'android-intent', 'serialization',
                                                 'random', 'sed', 'replace',
                                                 'cassandra', 'process', 'count', 'ant',
                                                 'arduino', 'stream'], 'monte': [],
                                      'moonscript': ['moonscript', 'lua', 'love2d',
                                                     'luarocks', 'image', 'function',
                                                     'nginx', 'recursion', 'module',
                                                     'osx-elcapitan', 'awesome-wm',
                                                     'openresty', 'luasocket', 'lpeg',
                                                     'lua-loadfile', 'lapis'],
                                      'mosel': ['mosel', 'linear-programming',
                                                'optimization', 'java', 'sql-server',
                                                'svg', 'memory', 'import', 'callback',
                                                'sql-insert',
                                                'mathematical-optimization',
                                                'temporary-files',
                                                'integer-programming',
                                                'mixed-integer-programming',
                                                'macos-catalina', 'xpressive',
                                                'xpress-optimizer'],
                                      'mozpreproccss': [], 'mozpreprocjavascript': [],
                                      'mozpreprocxul': [],
                                      'mql': ['mql', 'freebase', 'mql4', 'json', 'mql5',
                                              'metatrader4', 'google-api', 'java',
                                              'javascript', 'php', 'api',
                                              'semantic-web', 'python', 'metatrader5',
                                              'sparql', 'mt4', 'powershell', 'rdf',
                                              'c#', 'android', 'database', 'mongodb',
                                              'indicator', 'forex', 'freebase-acre',
                                              'mqlwrite', 'sql', 'arrays', 'sockets',
                                              'curl', 'join', 'search', 'charts', 'gwt',
                                              'visual-studio-code', 'paging',
                                              'wikipedia', 'google-api-client',
                                              'openrefine', 'relevance', 'c++', 'r',
                                              'angularjs', 'ruby', 'django', 'string',
                                              'windows', 'vb.net', 'python-2.7',
                                              'facebook'],
                                      'mscgen': ['mscgen', 'doxygen', 'c++', 'uml',
                                                 'sequence-diagram', 'doxywizard'],
                                      'mupad': ['mupad', 'matlab', 'symbolic-math',
                                                'math', 'plot', 'linear-algebra',
                                                'arrays', 'function', 'matrix',
                                                'substitution', 'maple', 'simplify',
                                                'piecewise', 'mathematical-expressions',
                                                'string', 'oop', 'recursion', 'vector',
                                                '3d', 'cryptography', 'statistics',
                                                'export', 'expression', 'size',
                                                'matlab-figure', 'series', 'symlink',
                                                'anonymous-function', 'convolution',
                                                'numerical-methods', 'equation', 'ode',
                                                'surface', 'algebra', 'polynomial-math',
                                                'polynomials', 'derivative',
                                                'eigenvector', 'nonlinear-functions',
                                                'simplex', 'rubiks-cube', 'dsolve'],
                                      'mxml': ['mxml', 'apache-flex', 'actionscript-3',
                                               'flash', 'actionscript', 'flex4',
                                               'flash-builder', 'flex3', 'adobe', 'air',
                                               'flex4.5', 'mxmlc', 'xml', 'datagrid',
                                               'flex-spark', 'data-binding',
                                               'itemrenderer', 'mobile', 'components',
                                               'flexbuilder', 'php', 'css', 'events',
                                               'html', 'java', 'layout', 'javascript',
                                               'binding', 'custom-component',
                                               'combobox', 'skinning', 'list', 'ant',
                                               'event-handling', 'state',
                                               'advanceddatagrid', 'arrays', 'image',
                                               'xaml', 'button', 'video', 'textarea',
                                               'flashdevelop', 'httpservice', 'json',
                                               'class', 'web-services',
                                               'user-interface', 'intellij-idea',
                                               'audio'], 'myghty': [],
                                      'ncl': ['ncl', 'python', 'netcdf', 'plot',
                                              'netcdf4', 'nco', 'r', 'python-3.x',
                                              'loops', 'numpy', 'anaconda', 'conda',
                                              'cdo-climate', 'arrays', 'linux', 'svg',
                                              'ggplot2', 'graphics', 'directory',
                                              'type-conversion', 'command', 'maps',
                                              'shared-libraries', 'coordinates',
                                              'ubuntu-14.04', 'data-visualization',
                                              'interpolation', 'mask', 'hdf5',
                                              'contour', 'windows-subsystem-for-linux',
                                              'bezier', 'indices', 'segment', 'binning',
                                              'p-value', 'resource-files', 't-test',
                                              'grib', 'cdo'],
                                      'nsis': ['nsis', 'installation', 'windows',
                                               'uninstallation', 'windows-installer',
                                               'registry', 'java', 'c#',
                                               'electron-builder', 'electron',
                                               'batch-file', 'modern-ui', 'nsdialogs',
                                               '.net', 'uac', 'silent-installer', 'c++',
                                               'cpack', 'cmake', 'windows-7', 'python',
                                               'winapi', 'dll', 'wix', 'inno-setup',
                                               'powershell', 'exe', 'plugins',
                                               'directory', 'shortcut', 'file',
                                               'unicode', 'scripting',
                                               'windows-services', 'mysql',
                                               'user-interface', 'cmd', 'process',
                                               'windows-10', 'xml', 'visual-studio',
                                               'dialog', 'environment-variables',
                                               'command-line', 'deployment',
                                               'permissions', '64-bit',
                                               'command-line-arguments', 'silent',
                                               'postgresql'],
                                      'nasm': ['nasm', 'assembly', 'x86', 'linux',
                                               'x86-64', 'c', 'bootloader', 'x86-16',
                                               'gcc', 'macos', 'windows', '64-bit',
                                               'osdev', 'segmentation-fault',
                                               'system-calls', 'gdb', 'ld', 'arrays',
                                               'dos', 'operating-system', 'masm',
                                               'bios', 'c++', 'string', 'printf',
                                               'winapi', 'shellcode', 'linker',
                                               'cpu-registers', 'intel', 'ubuntu',
                                               'stack', 'kernel', 'yasm', '32-bit',
                                               'calling-convention', 'real-mode', 'elf',
                                               'gnu-assembler', 'qemu', 'debugging',
                                               'boot', '16-bit', 'pointers', 'dosbox',
                                               'memory', 'floating-point', 'macros',
                                               'loops', 'scanf'], 'nasmobjdump': [],
                                      'nemerle': ['nemerle', '.net', 'c#', 'f#',
                                                  'metaprogramming', 'asp.net',
                                                  'macros', 'mono', 'boo',
                                                  'visual-studio', 'linq',
                                                  'visual-studio-2012', 'linq-to-sql',
                                                  'msbuild', 'programming-languages',
                                                  'monodevelop', 'quotations', 'arrays',
                                                  'regex', 'linux', 'wpf',
                                                  'unit-testing', 'object', 'variables',
                                                  'debugging', 'haskell', 'generics',
                                                  'winapi', 'silverlight', 'vim',
                                                  'dynamic', 'deployment',
                                                  'functional-programming', 'scripting',
                                                  'installation', 'console',
                                                  'attributes', 'numbers', '.net-4.0',
                                                  'web-config', 'windows-phone',
                                                  'operators', 'nunit', 'activex',
                                                  'antlr', 'offset',
                                                  'abstract-syntax-tree', 'roslyn',
                                                  'actor', 'dry'],
                                      'nesc': ['nesc', 'tinyos', 'c', 'wireless',
                                               'sensors', 'networking', 'arrays',
                                               'struct', 'java', 'serial-port', 'gps',
                                               'printf', 'python', 'ubuntu', 'pointers',
                                               'events', 'gcc', 'memory', 'vector',
                                               'timer', 'compiler-errors', 'callback',
                                               'macros', 'gdb', 'cygwin', 'clang',
                                               'sublimetext3', 'aes', 'port',
                                               'protocols', 'string-formatting',
                                               'function-pointers', 'simulation',
                                               'syntax-highlighting', 'communication',
                                               'importerror', 'rpm', 'radio', 'packet',
                                               'uart', 'deep-copy', 'instrumentation',
                                               'gmp', 'rbac', 'avr-gcc', 'contiki',
                                               'xacml', 'receiver', 'xserver',
                                               'floating-point-conversion'],
                                      'newlisp': ['newlisp', 'lisp', 'string',
                                                  'javascript', 'mysql', 'windows',
                                                  'macos', 'recursion', 'memory',
                                                  'memory-management', 'scripting',
                                                  'garbage-collection', 'executable',
                                                  'text-processing', 'utf-16',
                                                  'lambda-calculus', 'kernel32',
                                                  'file-attributes', 'ecl',
                                                  'single-file'],
                                      'newspeak': ['newspeak', 'smalltalk', 'pharo',
                                                   'squeak', 'object',
                                                   'programming-languages', 'mixins',
                                                   'vm-implementation'],
                                      'nginxconf': [],
                                      'nimrod': ['nimrod', 'nim-lang', 'macros',
                                                 'compile-time', 'javascript', 'c',
                                                 'linux', 'string', 'bash', 'parsing',
                                                 'ubuntu', 'generics', 'inheritance',
                                                 'math', 'heroku', 'matrix', 'memory',
                                                 'casting', 'compiler-errors', 'safari',
                                                 'range', 'qt5', 'sequence',
                                                 'metaprogramming', 'd', 'contains',
                                                 'bitwise-operators', 'interpreter',
                                                 'ada', 'httpserver',
                                                 'string-interpolation', 'qtgui',
                                                 'brainfuck', 'language-implementation',
                                                 'nimrod-babel'], 'nit': [],
                                      'nix': ['nix', 'nixos', 'haskell', 'nixpkgs',
                                              'haskell-stack', 'python', 'cabal',
                                              'linux', 'docker', 'macos', 'nix-shell',
                                              'nixops', 'vim', 'rust', 'bash', 'git',
                                              'shell', 'installation', 'package', 'ghc',
                                              'cabal-install', 'ruby', 'build', 'emacs',
                                              'functional-programming',
                                              'package-managers', 'c++', 'c', 'gcc',
                                              'development-environment', 'ghcjs',
                                              'python-3.x', 'github', 'ssh', 'makefile',
                                              'cmake', 'erlang', 'elixir', 'overlay',
                                              'travis-ci', 'devops', 'ffi', 'r',
                                              'scala', 'maven', 'opencv', 'ubuntu',
                                              'testing', 'configuration',
                                              'compilation'],
                                      'nusmv': ['nusmv', 'model-checking', 'logic',
                                                'ctl', 'formal-verification', 'nuxmv',
                                                'macos', 'model', 'installation',
                                                'verification', 'fsm', 'java', 'python',
                                                'mutual-exclusion', 'temporal',
                                                'formal-methods',
                                                'binary-decision-diagram', 'nuseen',
                                                'windows', 'eclipse', 'bash',
                                                'algorithm', 'performance', 'file',
                                                'validation', 'ubuntu', 'batch-file',
                                                'encryption', 'random', 'boost', 'time',
                                                'command-line', 'terminal', 'cmake',
                                                'properties', 'download',
                                                'compiler-construction', 'syntax-error',
                                                'notepad++', 'system', 'deadlock',
                                                'hardware', 'tar', 'boolean-logic',
                                                'uart', 'bpel', 'smt', 'automata',
                                                'induction', 'sat'],
                                      'objdump': ['objdump', 'c', 'assembly',
                                                  'disassembly', 'linux', 'elf', 'gcc',
                                                  'c++', 'gdb', 'x86', 'readelf', 'arm',
                                                  'shared-libraries', 'x86-64',
                                                  'debugging', 'reverse-engineering',
                                                  'nm', 'linker', 'dwarf',
                                                  'compilation', 'binary', 'binutils',
                                                  'windows', 'macos', 'executable',
                                                  'gnu', 'debug-symbols', 'bash',
                                                  'object-files', 'objcopy', 'python',
                                                  'parsing', 'nasm', 'unix', 'memory',
                                                  'linux-kernel', 'att',
                                                  'segmentation-fault',
                                                  'global-variables', 'llvm', 'mips',
                                                  'ld', 'glibc', 'arm64', 'riscv',
                                                  'thumb', 'otool', 'android', 'shell',
                                                  'memory-management'],
                                      'objectivec': [], 'objectivecpp': [],
                                      'objectivej': [],
                                      'ocaml': ['ocaml', 'functional-programming',
                                                'list', 'types', 'recursion', 'module',
                                                'pattern-matching', 'opam',
                                                'ocamlbuild', 'f#', 'haskell',
                                                'function', 'reason', 'parsing',
                                                'string', 'syntax', 'ml', 'utop',
                                                'functor', 'polymorphism', 'algorithm',
                                                'ocamllex', 'c',
                                                'compiler-construction', 'ocamlfind',
                                                'arrays', 'emacs', 'ocamlyacc',
                                                'record', 'camlp4', 'compilation',
                                                'bucklescript', 'menhir', 'js-of-ocaml',
                                                'compiler-errors', 'tree', 'makefile',
                                                'syntax-error', 'type-inference',
                                                'tail-recursion', 'ocaml-core', 'regex',
                                                'ocaml-lwt', 'exception', 'dictionary',
                                                'debugging', 'ocaml-dune', 'coq',
                                                'gadt', 'tuples'],
                                      'octave': ['octave', 'matlab', 'matrix', 'plot',
                                                 'python', 'machine-learning', 'c++',
                                                 'arrays', 'vectorization', 'gnuplot',
                                                 'image-processing', 'function', 'math',
                                                 'vector', 'signal-processing', 'image',
                                                 'macos', 'fft', 'linux', 'for-loop',
                                                 'gradient-descent', 'java', 'csv',
                                                 'windows', 'numpy', 'package',
                                                 'ubuntu', 'neural-network',
                                                 'linear-algebra', 'algorithm',
                                                 'symbolic-math', 'oct2py', 'r',
                                                 'string', 'matlab-figure', 'gnu',
                                                 'installation', 'homebrew', 'c',
                                                 'indexing', 'cell-array', 'loops',
                                                 'multidimensional-array', 'file',
                                                 'user-interface', 'linear-regression',
                                                 'graph', 'optimization', 'emacs',
                                                 'audio'], 'odin': [], 'ooc': [],
                                      'opa': ['opa', 'rego', 'open-policy-agent',
                                              'database', 'mongodb', 'node.js',
                                              'kubernetes', 'twitter-bootstrap',
                                              'javascript', 'deployment',
                                              'compiler-errors', 'html', 'css',
                                              'string', 'forms', 'apache',
                                              'amazon-web-services', 'function', 'file',
                                              'email', 'parsing', 'recursion',
                                              'download', 'compilation', 'xml-parsing',
                                              'arguments', 'ocaml', 'couchdb',
                                              'amazon-eks', 'kubernetes-apiserver',
                                              'java', 'android', 'ios', 'sql', 'json',
                                              'iphone', 'xml', 'windows',
                                              'multithreading', 'list', 'web-services',
                                              'dictionary', 'security', 'ubuntu',
                                              'debugging', 'authentication', 'web',
                                              'asynchronous', 'post', 'dom'],
                                      'openedge': ['openedge', 'progress-4gl',
                                                   'progress-db', 'sql', 'odbc',
                                                   'database', 'c#', '4gl', 'java',
                                                   'sql-server', 'webspeed', '.net',
                                                   'eclipse', 'excel', 'php', 'rest',
                                                   'jdbc', 'xml', 'linux', 'string',
                                                   'csv', 'web-services', 'json',
                                                   'soap', 'python', 'node.js',
                                                   'oracle', 'ssis', 'dataset',
                                                   'temp-tables', 'postgresql',
                                                   'sockets', 'linked-server',
                                                   'appserver', 'javascript', 'mysql',
                                                   'sql-server-2008', 'user-interface',
                                                   'unix', 'kendo-ui', 'transactions',
                                                   'crystal-reports', 'runtime-error',
                                                   'database-connection', 'case-when',
                                                   'epicorerp', 'spring', 'windows',
                                                   'vb.net', 'multithreading'],
                                      'pacmanconf': [],
                                      'pan': ['pan', 'zoom', 'javascript', 'android',
                                              'd3.js', 'ios', 'c#', 'jquery', 'gesture',
                                              'svg', 'image', 'uigesturerecognizer',
                                              'html', 'swift', 'drag', 'canvas',
                                              'rotation', 'java', 'wpf', 'hammer.js',
                                              'google-maps', 'scroll', 'pinch', 'css',
                                              'iphone', 'objective-c', 'xcode',
                                              'camera', 'openlayers', 'swipe',
                                              'winforms', 'three.js', 'imageview',
                                              'python', 'actionscript-3', 'mouse',
                                              'scale', 'image-zoom', 'matlab',
                                              'react-native', 'flash', 'plot',
                                              'google-maps-api-3', 'charts', 'libgdx',
                                              'achartengine', 'uipangesturerecognizer',
                                              'flutter', 'graphics', 'uiimageview'],
                                      'parasail': [],
                                      'pawn': ['pawn', 'sa-mp', 'php', 'mysql', 'c++',
                                               'c', 'arrays', 'regex', 'string',
                                               'algorithm', 'hash',
                                               'string-concatenation', 'c#', 'sql',
                                               'linux', 'eclipse', 'file', 'for-loop',
                                               'if-statement', 'math', 'encryption',
                                               'plugins', 'merge', 'visual-studio-code',
                                               'build', 'colors', 'scripting',
                                               'permissions', 'character-encoding',
                                               'crash', 'geometry', 'ide', 'connection',
                                               'escaping', 'output', 'interpolation',
                                               'gradient', 'sublimetext', 'reverse',
                                               'vscode-settings', 'maze',
                                               'non-ascii-characters', 'stock',
                                               'bitmask', 'converters', 'phpbb',
                                               'mysql-real-escape-string', 'utf8mb4',
                                               'economics', 'bitflags'],
                                      'peg': ['peg', 'parsing', 'javascript', 'pegjs',
                                              'python', 'grammar', 'regex', 'ruby',
                                              'treetop', 'node.js', 'parsimonious',
                                              'c++', 'grako', 'parser-generator',
                                              'rust', 'compiler-construction',
                                              'context-free-grammar', 'ebnf',
                                              'recursive-descent', 'lpeg', 'parslet',
                                              'algorithm', 'syntax', 'lua',
                                              'language-agnostic', 'bnf',
                                              'parser-combinators', 'left-recursion',
                                              'textx', 'c', 'python-3.x', 'scala',
                                              'expression', 'antlr',
                                              'abstract-syntax-tree', 'dsl',
                                              'boost-spirit', 'bbcode', 'll',
                                              'parboiled', 'tatsu', 'pypeg', 'arpeggio',
                                              'performance', 'recursion',
                                              'error-handling', 'clojure', 'ocaml',
                                              'uri', 'syntax-highlighting'],
                                      'perl6': ['raku', 'rakudo', 'regex', 'grammar',
                                                'perl', 'nativecall', 'arrays',
                                                'module', 'cro', 'match', 'oop',
                                                'signature', 'rakudo-star', 'nqp',
                                                'parsing', 'hash', 'syntax', 'zef',
                                                'types', 'io', 'list', 'class',
                                                'testing', 'commaide', 'exception',
                                                'string', 'unicode', 'concurrency',
                                                'operators', 'metaprogramming',
                                                'promise', 'asynchronous', 'windows',
                                                'python', 'performance', 'function',
                                                'variables', 'functional-programming',
                                                'lazy-evaluation', 'introspection', 'c',
                                                'multithreading', 'object', 'hashmap',
                                                'set', 'sequence', 'mixins', 'moarvm',
                                                'sockets', 'for-loop'],
                                      'perl': ['perl', 'regex', 'arrays', 'hash',
                                               'linux', 'bash', 'cgi', 'awk', 'xml',
                                               'python', 'perl-module', 'sed', 'shell',
                                               'html', 'mysql', 'cpan', 'unix',
                                               'windows', 'dbi', 'string', 'file',
                                               'php', 'parsing', 'apache', 'javascript',
                                               'json', 'csv', 'grep', 'module', 'moose',
                                               'mojolicious', 'multithreading', 'java',
                                               'sorting', 'utf-8', 'catalyst', 'sql',
                                               'subroutine', 'excel', 'reference',
                                               'unicode', 'ssh', 'split', 'replace',
                                               'oop', 'perl-data-structures', 'loops',
                                               'variables', 'email', 'sockets'],
                                      'php': ['php', 'mysql', 'javascript', 'html',
                                              'jquery', 'laravel', 'wordpress',
                                              'arrays', 'ajax', 'codeigniter', 'sql',
                                              'json', 'laravel-5', 'symfony', 'forms',
                                              'regex', 'apache', 'database', 'mysqli',
                                              '.htaccess', 'css', 'pdo', 'curl',
                                              'session', 'xml', 'email', 'woocommerce',
                                              'cakephp', 'magento', 'zend-framework',
                                              'api', 'post', 'android', 'eloquent',
                                              'facebook', 'string', 'yii', 'oop',
                                              'authentication', 'image', 'foreach',
                                              'multidimensional-array', 'date',
                                              'function', 'mod-rewrite', 'redirect',
                                              'laravel-4', 'doctrine-orm', 'variables',
                                              'file-upload'],
                                      'pig': ['apache-pig', 'hadoop', 'hive',
                                              'mapreduce', 'java', 'bigdata', 'hdfs',
                                              'user-defined-functions', 'hbase',
                                              'python', 'json', 'regex', 'cloudera',
                                              'cassandra', 'amazon-emr', 'hadoop2',
                                              'oozie', 'join', 'hcatalog', 'csv',
                                              'amazon-web-services', 'avro', 'xml',
                                              'hue', 'shell',
                                              'hortonworks-data-platform',
                                              'elephantbird', 'sql', 'apache-spark',
                                              'jython', 'apache', 'amazon-s3', 'tuples',
                                              'mongodb', 'hadoop-streaming',
                                              'cloudera-cdh', 'latin', 'filter',
                                              'group-by', 'hiveql', 'sqoop',
                                              'azure-hdinsight', 'datetime', 'yarn',
                                              'parquet', 'bash', 'foreach', 'count',
                                              'flatten', 'dictionary'],
                                      'pike': ['pike', 'file', 'cross-platform',
                                               'autoconf', 'apache2-module', 'php',
                                               'html', 'linux', 'apache',
                                               'user-interface', 'web-applications',
                                               'path', 'garbage-collection',
                                               'shared-libraries',
                                               'programming-languages', 'external',
                                               'sizeof', 'factorial', 'gmp', 'rpmbuild',
                                               'bignum'], 'pkgconfig': [],
                                      'pointless': [],
                                      'pony': ['pony', 'ruby', 'sinatra', 'email',
                                               'ruby-on-rails', 'python', 'ponyorm',
                                               'orm', 'heroku', 'forms', 'python-3.x',
                                               'ruby-on-rails-3', 'rspec', 'rubygems',
                                               'haml', 'actionmailer', 'inheritance',
                                               'gmail', 'html-email',
                                               'email-attachments', 'mailer', 'jquery',
                                               'html', 'django', 'ajax', 'windows',
                                               'oracle', 'csv', 'unix',
                                               'authentication', 'devise', 'openssl',
                                               'smtp', 'ckeditor', 'ruby-on-rails-5',
                                               'gtk', 'sms', 'pyqt5', 'sql-order-by',
                                               'bundler', 'attachment', 'd', 'erb',
                                               'sendgrid', 'redmine', 'eof', 'ffi',
                                               'cx-oracle', 'sequel', 'middleman'],
                                      'postscript': ['postscript', 'ghostscript', 'pdf',
                                                     'printing', 'eps', 'c#', 'fonts',
                                                     'pdf-generation', 'java', 'python',
                                                     'r', 'linux', 'image', 'gnuplot',
                                                     'latex', 'adobe', '.net',
                                                     'windows', 'graphics',
                                                     'imagemagick',
                                                     'printer-control-language',
                                                     'driver', 'true-type-fonts',
                                                     'cups', 'php', 'unicode', 'matlab',
                                                     'plot', 'jpeg', 'printers', 'cmyk',
                                                     'html', 'c++', 'macos', 'shell',
                                                     'tkinter', 'text', 'file',
                                                     'matplotlib', 'svg', 'c', 'string',
                                                     'bash', 'canvas', 'command-line',
                                                     'character-encoding', 'stack',
                                                     'interpreter', 'tiff', 'acrobat'],
                                      'povray': ['povray', 'python', 'raytracing', '3d',
                                                 'graphics', 'rendering', 'textures',
                                                 'python-3.x', 'image', 'render',
                                                 'blender', 'loops', 'batch-file',
                                                 'image-processing', 'rotation', 'mesh',
                                                 'imagemap', 'poisson', 'r', 'linux',
                                                 'windows', 'bash', 'matlab',
                                                 'performance', 'shell', 'file',
                                                 'object', 'for-loop', 'recursion',
                                                 'vector', 'plot', 'tkinter', 'boost',
                                                 'command-line', 'merge', 'colors',
                                                 'parallel-processing', 'reference',
                                                 'installation', 'floating-point',
                                                 'geometry', 'export', 'mapping', '2d',
                                                 'processing', 'cluster-computing',
                                                 'wolfram-mathematica',
                                                 'command-line-arguments', 'gradient',
                                                 'transparency'],
                                      'powershell': ['powershell', 'windows', 'azure',
                                                     'c#', 'powershell-2.0',
                                                     'active-directory', 'csv',
                                                     'powershell-3.0', 'batch-file',
                                                     'regex', '.net', 'xml', 'arrays',
                                                     'scripting', 'cmd', 'sql-server',
                                                     'powershell-4.0', 'excel',
                                                     'python', 'json', 'sharepoint',
                                                     'exchange-server',
                                                     'powershell-remoting', 'string',
                                                     'azure-powershell', 'sql',
                                                     'azure-devops', 'powershell-5.0',
                                                     'wmi', 'iis', 'foreach',
                                                     'variables', 'automation',
                                                     'office365', 'function', 'tfs',
                                                     'shell', 'html', 'command-line',
                                                     'replace', 'file', 'windows-10',
                                                     'git', 'scheduled-tasks', 'email',
                                                     'visual-studio', 'parameters',
                                                     'registry',
                                                     'azure-active-directory',
                                                     'outlook'],
                                      'praat': ['praat', 'audio', 'python', 'pitch',
                                                'scripting', 'voice', 'r', 'wav', 'c++',
                                                'nlp', 'report', 'speech-recognition',
                                                'speech', 'javascript', 'php', 'linux',
                                                'python-3.x', 'windows', 'time',
                                                'concatenation', 'sox',
                                                'audio-processing', 'linguistics',
                                                'phonetics', 'audio-analysis',
                                                'pitch-detection', 'asp.net',
                                                'database', 'macos', 'list', 'function',
                                                'loops', 'parsing', 'object', 'ubuntu',
                                                'for-loop', 'machine-learning', 'gcc',
                                                'data-structures', 'ssh', 'plugins',
                                                'command-line', 'server', 'split',
                                                'cmake', 'compilation', 'nested',
                                                'timestamp', 'subprocess', 'arguments'],
                                      'prolog': ['prolog', 'list', 'swi-prolog',
                                                 'recursion', 'dcg', 'clpfd', 'logic',
                                                 'predicate', 'iso-prolog',
                                                 'prolog-toplevel', 'java',
                                                 'failure-slice', 'logic-programming',
                                                 'prolog-dif', 'sicstus-prolog',
                                                 'algorithm', 'graph-theory',
                                                 'successor-arithmetics',
                                                 'artificial-intelligence',
                                                 'unification', 'transitive-closure',
                                                 'backtracking', 'zebra-puzzle', 'tree',
                                                 'constraint-programming', 'sorting',
                                                 'prolog-cut', 'parsing', 'gnu-prolog',
                                                 'string', 'instantiation-error',
                                                 'eclipse-clp', 'prolog-setof',
                                                 'append', 'matrix', 'prolog-findall',
                                                 'rules', 'jpl', 'meta-predicate',
                                                 'permutation', 'grammar', 'python',
                                                 'database', 'logical-purity',
                                                 'variables', 'operators',
                                                 'binary-tree', 'constraints',
                                                 'shortest-path', 'visual-prolog'],
                                      'promql': ['promql', 'prometheus', 'grafana',
                                                 'kubernetes',
                                                 'prometheus-alertmanager',
                                                 'prometheus-operator', 'monitoring',
                                                 'metrics', 'victoriametrics',
                                                 'prometheus-node-exporter',
                                                 'kube-state-metrics', 'metricsql',
                                                 'spring-micrometer',
                                                 'grafana-variable', 'alert',
                                                 'grafana-templating', 'grafana-alerts',
                                                 'spring', 'variables', 'operators',
                                                 'histogram', 'slack', 'influxdb',
                                                 'rules', 'alerts', 'micrometer',
                                                 'cadvisor',
                                                 'prometheus-blackbox-exporter', 'java',
                                                 '.net', 'regex', 'amazon-web-services',
                                                 'function', 'azure', 'rest', 'loops',
                                                 'spring-boot', 'docker', 'go',
                                                 'elasticsearch', 'iis', 'networking',
                                                 'filter', 'service', 'ansible',
                                                 'timestamp', 'time-series', 'label',
                                                 'yaml', 'spring-integration'],
                                      'properties': ['properties', 'c#', 'java',
                                                     'javascript', 'objective-c',
                                                     'object', 'python', 'spring',
                                                     'class', 'ios', '.net', 'php',
                                                     'wpf', 'arrays', 'vb.net', 'oop',
                                                     'reflection', 'spring-boot',
                                                     'swift', 'inheritance', 'methods',
                                                     'maven', 'iphone', 'attributes',
                                                     'asp.net', 'configuration', 'list',
                                                     'jquery', 'css', 'c++',
                                                     'variables', 'winforms', 'file',
                                                     'setter', 'xml', 'javafx', 'html',
                                                     'binding', 'dynamic', 'json',
                                                     'android', 'python-3.x', 'delphi',
                                                     'function', 'getter-setter', 'ant',
                                                     'xcode', 'user-controls', 'string',
                                                     'constructor'],
                                      'protobuf': ['protocol-buffers', 'c++', 'java',
                                                   'python', 'grpc', 'c#',
                                                   'protobuf-net', 'go',
                                                   'serialization', 'proto',
                                                   'tensorflow', 'android', 'json',
                                                   'protoc', '.net', 'javascript',
                                                   'node.js', 'protobuf-java', 'cmake',
                                                   'scala', 'c', 'proto3', 'protobuf-c',
                                                   'python-3.x', 'gradle', 'grpc-java',
                                                   'maven', 'sockets',
                                                   'google-protocol-buffer', 'ios',
                                                   'linux', 'caffe', 'thrift', 'rpc',
                                                   'protobuf.js', 'enums', 'hadoop',
                                                   'protocols', 'bazel', 'zeromq',
                                                   'objective-c', 'rest', 'php',
                                                   'apache-spark', 'netty', 'scalapb',
                                                   'xcode', 'qt', 'apache-kafka',
                                                   'deserialization'],
                                      'pug': ['pug', 'node.js', 'javascript', 'express',
                                              'html', 'angularjs', 'css', 'mongodb',
                                              'jquery', 'json', 'twitter-bootstrap',
                                              'gulp', 'mongoose', 'templates',
                                              'template-engine', 'vue.js', 'gruntjs',
                                              'backbone.js', 'coffeescript', 'ejs',
                                              'ajax', 'forms', 'webpack', 'arrays',
                                              'mysql', 'meteor', 'sass', 'stylus',
                                              'angular', 'reactjs', 'php', 'mixins',
                                              'socket.io', 'handlebars.js',
                                              'templating', 'mean-stack', 'jade4j',
                                              'npm', 'variables', 'twitter-bootstrap-3',
                                              'sails.js', 'passport.js', 'webstorm',
                                              'keystonejs', 'vuejs2', 'include',
                                              'angularjs-ng-repeat', 'web',
                                              'bootstrap-4', 'underscore.js'],
                                      'puppet': ['puppet', 'vagrant', 'ruby', 'hiera',
                                                 'puppet-enterprise', 'linux', 'facter',
                                                 'windows', 'ubuntu', 'erb',
                                                 'puppetlabs-apache', 'rspec',
                                                 'chef-infra', 'git', 'apache',
                                                 'augeas', 'amazon-web-services',
                                                 'mysql', 'module', 'bash', 'devops',
                                                 'docker', 'theforeman', 'powershell',
                                                 'centos', 'puphpet', 'java', 'ssl',
                                                 'yaml', 'rspec-puppet', 'nginx', 'php',
                                                 'automation', 'jenkins', 'virtualbox',
                                                 'python', 'rubygems', 'manifest',
                                                 'provisioning', 'postgresql', 'arrays',
                                                 'amazon-ec2', 'node.js', 'templates',
                                                 'configuration-management',
                                                 'deployment', 'configuration', 'hash',
                                                 'ssh', 'vagrantfile'], 'pypylog': [],
                                      'python2traceback': [],
                                      'python': ['python', 'python-3.x', 'pandas',
                                                 'django', 'numpy', 'python-2.7',
                                                 'list', 'dataframe', 'matplotlib',
                                                 'tensorflow', 'dictionary', 'flask',
                                                 'tkinter', 'regex', 'arrays', 'csv',
                                                 'string', 'selenium', 'json', 'html',
                                                 'beautifulsoup', 'keras',
                                                 'machine-learning', 'opencv',
                                                 'web-scraping', 'scikit-learn',
                                                 'scipy', 'mysql', 'sqlalchemy',
                                                 'javascript', 'loops', 'function',
                                                 'pip', 'pygame', 'django-models',
                                                 'linux', 'multithreading', 'windows',
                                                 'python-requests', 'datetime', 'pyqt',
                                                 'scrapy', 'class', 'google-app-engine',
                                                 'for-loop', 'jupyter-notebook',
                                                 'algorithm', 'excel', 'file', 'xml'],
                                      'pythontraceback': [],
                                      'qbasic': ['qbasic', 'basic', 'qb64',
                                                 'quickbasic', 'gw-basic', 'arrays',
                                                 'c#', 'python', 'serial-port', 'dos',
                                                 'freebasic', 'c++', 'string', 'vb.net',
                                                 'console', 'simulation',
                                                 'reverse-engineering', 'php',
                                                 'algorithm', 'function', 'loops',
                                                 'file', 'parsing', 'if-statement',
                                                 'encryption', 'input', 'time',
                                                 'syntax', 'directory', 'menu', 'vb6',
                                                 'ide', 'output', 'editor', 'scrollbar',
                                                 'formula', 'antlr', 'physics',
                                                 'number-formatting', 'pascal',
                                                 'subroutine', 'goto', 'javascript',
                                                 'java', 'sql', 'c', '.net', 'ruby',
                                                 'python-3.x', 'windows'], 'qvto': [],
                                      'qml': ['qml', 'qt', 'c++', 'qtquick2', 'qt5',
                                              'qt-quick', 'javascript', 'python',
                                              'listview', 'android', 'blackberry-10',
                                              'qtquickcontrols2', 'qtquickcontrols',
                                              'pyqt5', 'qt-creator',
                                              'blackberry-cascades', 'pyqt', 'pyside2',
                                              'opengl', 'qqmlcomponent', 'qt4', 'ios',
                                              'user-interface', 'image', 'qt3d',
                                              'animation', 'blackberry', 'tableview',
                                              'canvas', 'model', 'signals-slots',
                                              'qabstractlistmodel', 'gridview', 'linux',
                                              'webview', 'qquickitem', 'signals',
                                              'layout', 'properties', 'treeview',
                                              'qqmlapplicationengine', 'qt5.5',
                                              'combobox', 'fonts', 'qtlocation',
                                              'windows', 'cmake', 'text', 'html',
                                              'xml'], 'rconsole': [], 'rnccompact': [],
                                      'rpmspec': [],
                                      'racket': ['racket', 'scheme', 'lisp', 'list',
                                                 'functional-programming', 'recursion',
                                                 'macros', 'lambda', 'typed-racket',
                                                 'sicp', 'r5rs', 'function',
                                                 'user-interface', 'string', 'syntax',
                                                 'pattern-matching', 'htdp', 'struct',
                                                 'fold', 'algorithm', 'tree',
                                                 'scribble', 'emacs', 'continuations',
                                                 'eval', 'stream',
                                                 'racket-student-languages',
                                                 'tail-recursion', 'sorting', 'parsing',
                                                 'module', 'contract', 'loops',
                                                 'conditional-statements', 'types',
                                                 'let', 'regex', 'common-lisp',
                                                 'vector', 'higher-order-functions',
                                                 'performance', 'random',
                                                 'binary-search-tree', 'python',
                                                 'unit-testing', 'binary-tree', 'cons',
                                                 'raco', 'if-statement', 'ffi'],
                                      'ragelc': [], 'ragelcpp': [], 'rageld': [],
                                      'ragelembedded': [], 'rageljava': [],
                                      'ragelobjectivec': [], 'ragelruby': [],
                                      'rd': ['rd', 'r', 'roxygen2', 'documentation',
                                             'package', 'devtools', 'java', 'cmd',
                                             'rstudio', 'r-package', 'roxygen', 'html',
                                             'ios', 'css', 'asp.net', 'iphone',
                                             'windows', 'function', 'file', 'parsing',
                                             'for-loop', 'batch-file', 'unix', 'web',
                                             'github', 'text', 'jar', 'macros',
                                             'statistics', 'web-crawler', 'escaping',
                                             'latex', '64-bit', 'ascii', 'editor',
                                             'inputstream', 'visualization',
                                             'travis-ci', 'installshield', 'packaging',
                                             'windows-server-2003',
                                             'documentation-generation', 'tex', 'cran',
                                             'rscript', 'hyphen', 'rundeck',
                                             'square-bracket', 'uidevice',
                                             'reference-class'],
                                      'reason': ['reason', 'bucklescript', 'ocaml',
                                                 'reason-react', 'ffi', 'types',
                                                 'reactjs', 'javascript', 'rescript',
                                                 'graphql', 'module', 'json', 'promise',
                                                 'bs-webapi', 'oop', 'dom',
                                                 'compiler-errors', 'pattern-matching',
                                                 'syntax', 'record', 'dictionary',
                                                 'webpack', 'functional-programming',
                                                 'polymorphism', 'bs-json', 'string',
                                                 'list', 'unicode', 'apollo',
                                                 'value-restriction', 'css', 'arrays',
                                                 'node.js', 'typescript', 'exception',
                                                 'npm', 'visual-studio-code', 'interop',
                                                 'variant', 'ppx',
                                                 'polymorphic-variants', 'python',
                                                 'django', 'windows', 'function',
                                                 'react-native', 'recursion', 'binding',
                                                 'async-await', 'html5-canvas'],
                                      'rebol': ['rebol', 'rebol3', 'red', 'rebol2',
                                                'parsing', 'user-interface', 'r3-gui',
                                                'object', 'string', 'http', 'scope',
                                                'cgi', 'list', 'unicode', 'reflection',
                                                'linux', 'function',
                                                'functional-programming', 'webserver',
                                                'dialect', 'cheyenne', 'html',
                                                'windows', 'dll', 'error-handling',
                                                'module', 'bind', 'block',
                                                'variable-assignment', 'dsl', 'scoping',
                                                'javascript', 'android', 'regex',
                                                'file', 'exception',
                                                'memory-management', 'types', 'view',
                                                'constructor', 'console',
                                                'event-handling', 'http-headers', 'ide',
                                                'filenames', 'series', 'python', 'json',
                                                'xml', 'performance'],
                                      'red': ['red', 'rebol', 'rebol3', 'parsing',
                                              'user-interface', 'red-system', 'rebol2',
                                              'list', 'string', 'object',
                                              'variable-assignment', 'linux',
                                              'compilation', 'series', 'file',
                                              'pointers', 'variables', 'curl', 'post',
                                              'scope', 'console', 'type-conversion',
                                              'window', 'dsl', 'android', 'arrays',
                                              'node.js', 'regex', 'windows', 'sqlite',
                                              'function', 'rest', 'shell', 'powershell',
                                              'loops', 'sorting', 'date', 'ubuntu',
                                              'debugging', 'pdf', 'go', 'exception',
                                              'recursion', 'memory-management',
                                              'dynamic', 'reflection', 'encoding',
                                              'cmd', 'types', 'utf-8'],
                                      'redcode': ['corewars', 'redcode', 'assembly',
                                                  'memory', 'automation', 'scripting',
                                                  'simulation'],
                                      'regedit': ['regedit', 'registry', 'windows',
                                                  'c#', 'batch-file', 'powershell',
                                                  'cmd', '.net', 'contextmenu',
                                                  'vb.net', 'java', 'c++', 'windows-10',
                                                  'python', 'windows-7', 'registrykey',
                                                  'internet-explorer', 'regex', 'excel',
                                                  'winforms', 'shell', 'c',
                                                  'sql-server', 'wpf', 'vbscript',
                                                  'exe', 'javascript', 'visual-studio',
                                                  'file', 'installation',
                                                  'windows-installer', 'key',
                                                  'inno-setup', 'windows-ce', 'startup',
                                                  'node.js', 'vba', 'google-chrome',
                                                  'winapi', 'service', 'command-line',
                                                  'windows-8', 'boot', 'explorer',
                                                  'php', 'python-3.x',
                                                  'visual-studio-2010', 'proxy',
                                                  'process', 'path'],
                                      'rexx': ['rexx', 'mainframe', 'zos', 'jcl', 'tso',
                                               'ispf', 'db2', 'clist', 'windows',
                                               'parsing', 'panel', 'cobol', 'db2-zos',
                                               'oorexx', '.net', 'batch-file',
                                               'batch-processing', 'java', 'python',
                                               'html', 'regex', 'xml', 'csv', 'file-io',
                                               'tcp', 'automation', 'command',
                                               'dataset', 'luhn', 'uss', 'racf', 'sdsf',
                                               'css', 'sql', 'c', 'arrays', 'linux',
                                               'string', 'macos', 'algorithm',
                                               'function', 'loops', 'sorting',
                                               'sockets', 'debugging', 'unix',
                                               'stored-procedures', 'encryption',
                                               'random', 'awk'],
                                      'rhtml': ['rhtml', 'ruby-on-rails', 'ruby', 'erb',
                                                'html', 'javascript', 'r',
                                                'ruby-on-rails-3', 'view', 'knitr',
                                                'webrick', 'variables', 'debugging',
                                                'tomcat', 'internet-explorer',
                                                'model-view-controller', 'web-scraping',
                                                'drop-down-menu', 'emacs', 'model',
                                                'timestamp', 'cgi', 'rake', 'render',
                                                'handler', 'jruby', 'partials', 'rcurl',
                                                'document.write', 'mongrel',
                                                'networkd3', 'formattable', 'rapache'],
                                      'ride': ['ride', 'wavesplatform',
                                               'smartcontracts', 'blockchain', 'python',
                                               'python-3.x', 'robotframework',
                                               'javascript', 'wave', 'node.js', 'excel',
                                               'database', 'oracle', 'rest', 'selenium',
                                               'google-chrome', 'transactions',
                                               'type-conversion',
                                               'selenium-chromedriver', 'ethereum',
                                               'keyword', 'truffle', 'ganache'],
                                      'roboconfgraph': [], 'roboconfinstances': [],
                                      'robotframework': ['robotframework', 'python',
                                                         'selenium',
                                                         'selenium-webdriver',
                                                         'automated-tests',
                                                         'python-2.7',
                                                         'selenium2library',
                                                         'automation', 'testing',
                                                         'python-3.x', 'xpath',
                                                         'appium', 'jenkins', 'java',
                                                         'robotframework-ide',
                                                         'selenium-chromedriver',
                                                         'json', 'javascript',
                                                         'pycharm', 'android',
                                                         'eclipse', 'google-chrome',
                                                         'html', 'firefox', 'keyword',
                                                         'autoit', 'appium-android',
                                                         'webdriver', 'ui-automation',
                                                         'jython', 'sikuli', 'macos',
                                                         'xml', 'database',
                                                         'dictionary', 'ssh', 'regex',
                                                         'api', 'maven', 'docker',
                                                         'frameworks', 'variables',
                                                         'list', 'windows', 'for-loop',
                                                         'python-requests', 'excel',
                                                         'if-statement', 'logging',
                                                         'wxpython'], 'rql': [],
                                      'rsl': ['rsl', 'apache-flex', 'flash',
                                              'actionscript-3', 'swc', 'caching',
                                              'fonts', 'adobe', 'flex4', 'maven', 'ant',
                                              'actionscript', 'air', 'runtime',
                                              'shared-libraries', 'flex3', 'flash-cs5',
                                              'flex4.5', 'flash-cs4',
                                              'applicationdomain', 'windows', 'pdf',
                                              'url', 'inheritance', 'intellij-idea',
                                              'charts', 'hash', 'module', 'interface',
                                              'stack', 'components', 'load',
                                              'data-visualization', 'share',
                                              'flash-builder', 'external', 'symbols',
                                              'versioning', 'cdn', 'trace', 'flash-cs6',
                                              'policy', 'signed', 'flashdevelop',
                                              'monkeypatching', 'flex-spark',
                                              'datastage', 'group-policy', 'mxmlc',
                                              'flash-cc'],
                                      'rst': ['restructuredtext', 'python-sphinx',
                                              'python', 'docutils', 'html', 'markdown',
                                              'latex', 'read-the-docs', 'toctree',
                                              'substitution', 'css', 'github',
                                              'documentation', 'docstring', 'autodoc',
                                              'pandoc', 'image', 'markup', 'sections',
                                              'rst2pdf', 'python-3.x', 'hyperlink',
                                              'django', 'pycharm', 'pypi', 'vim',
                                              'cross-reference', 'kivy', 'pelican',
                                              'tableofcontents', 'emacs', 'glossary',
                                              'pdf', 'jinja2', 'pdflatex', 'regex',
                                              'python-2.7', 'versioning',
                                              'documentation-generation', 'javascript',
                                              'sidebar', 'rst2html.py', 'php',
                                              'parsing', 'syntax-highlighting',
                                              'highlight', 'eclipse', 'csv', 'math',
                                              'ipython'], 'rts': [],
                                      'ruby': ['ruby', 'ruby-on-rails',
                                               'ruby-on-rails-3', 'ruby-on-rails-4',
                                               'rubygems', 'activerecord', 'rspec',
                                               'arrays', 'regex', 'javascript',
                                               'sinatra', 'hash', 'devise', 'heroku',
                                               'json', 'postgresql', 'nokogiri',
                                               'mysql', 'ruby-on-rails-5', 'string',
                                               'rvm', 'html', 'watir', 'jquery', 'rake',
                                               'bundler', 'macos', 'cucumber',
                                               'ruby-on-rails-3.2', 'chef-infra', 'sql',
                                               'capybara', 'mongodb', 'routes', 'ajax',
                                               'csv', 'testing', 'python', 'database',
                                               'xml', 'selenium', 'forms', 'windows',
                                               'methods', 'mongoid',
                                               'rails-activerecord', 'api', 'linux',
                                               'ruby-on-rails-3.1', 'css'],
                                      'rust': ['rust', 'lifetime', 'traits',
                                               'rust-cargo', 'borrow-checker',
                                               'generics', 'iterator', 'serde',
                                               'rust-tokio', 'ffi', 'string',
                                               'multithreading', 'macros', 'reference',
                                               'closures', 'vector', 'struct',
                                               'borrowing', 'arrays', 'types', 'enums',
                                               'ownership', 'c', 'future', 'json',
                                               'webassembly', 'pattern-matching',
                                               'async-await', 'windows',
                                               'error-handling', 'rust-macros',
                                               'hashmap', 'asynchronous', 'pointers',
                                               'hyper', 'actix-web', 'rust-diesel',
                                               'rust-actix', 'rust-crates', 'syntax',
                                               'module', 'slice', 'linux', 'python',
                                               'c++', 'mutable', 'compiler-errors',
                                               'wasm-bindgen', 'rust-rocket',
                                               'performance'],
                                      'sas': ['sas', 'sql', 'sas-macro', 'proc-sql',
                                              'macros', 'r', 'date', 'enterprise-guide',
                                              'proc', 'loops', 'excel', 'arrays',
                                              'python', 'datastep', 'import', 'dataset',
                                              'merge', 'statistics', 'format', 'csv',
                                              'sql-server', 'regex', 'if-statement',
                                              'oracle', 'variables', 'transpose',
                                              'regression', 'teradata', 'string',
                                              'do-loops', 'join', 'sas-iml', 'sas-ods',
                                              'sas-studio', 'pandas', 'database',
                                              'datetime', 'vba', 'sorting', 'graph',
                                              'logistic-regression', 'odbc', 'mysql',
                                              'unix', 'count', 'export', 'ods',
                                              'retain', 'duplicates', 'proc-report'],
                                      's': ['s', 'r', 'statistics', 's-plus',
                                            'for-loop', 'glm', 'javascript', 'java',
                                            'python', 'arrays', 'linux', 'laravel',
                                            'multithreading', 'visual-studio',
                                            'function', 'selenium', 'loops', 'csv',
                                            'date', 'asynchronous',
                                            'selenium-webdriver', 'search', 'matrix',
                                            'ggplot2', 'vector', 'random', 'plot',
                                            'reporting-services', 'ffmpeg', 'emacs',
                                            'shiny', 'scope', 'binary', 'ide',
                                            'streaming', 'webrtc',
                                            'programming-languages', 'customization',
                                            'nested-loops', 'sympy', 'contains',
                                            'logistic-regression', 'xts', 'spss',
                                            'visual-studio-2019', 'lag', 'lm',
                                            'language-design', 'rtp', 'splunk'],
                                      'sml': ['sml', 'smlnj', 'ml',
                                              'functional-programming', 'list',
                                              'recursion', 'types', 'function',
                                              'pattern-matching', 'polyml', 'ocaml',
                                              'tree', 'algorithm', 'fold', 'currying',
                                              'haskell', 'string', 'exception', 'emacs',
                                              'mosml', 'tuples', 'mlton',
                                              'polymorphism', 'programming-languages',
                                              'functor', 'python', 'binary-tree',
                                              'standards', 'parsing', 'syntax',
                                              'module', 'type-inference', 'signature',
                                              'sorting', 'higher-order-functions',
                                              'dictionary', 'integer', 'arrays', 'io',
                                              'f#', 'compiler-construction',
                                              'iteration', 'record', 'tail-recursion',
                                              'abstract-data-type', 'macos',
                                              'reference', 'type-conversion',
                                              'syntax-error', 'structure'], 'sarl': [],
                                      'sass': ['sass', 'css', 'html', 'javascript',
                                               'angular', 'webpack', 'compass-sass',
                                               'reactjs', 'ruby-on-rails', 'gulp',
                                               'twitter-bootstrap', 'ruby', 'node.js',
                                               'bootstrap-4', 'vue.js',
                                               'zurb-foundation', 'less', 'gruntjs',
                                               'mixins', 'npm', 'ionic-framework',
                                               'jquery', 'compass', 'scss-mixins',
                                               'node-sass', 'typescript', 'flexbox',
                                               'gulp-sass', 'css-selectors',
                                               'media-queries', 'rubygems',
                                               'asset-pipeline', 'angular-material',
                                               'bourbon', 'laravel', 'variables',
                                               'responsive-design', 'php', 'angularjs',
                                               'haml', 'ionic2', 'ionic3',
                                               'ruby-on-rails-4', 'angular-cli',
                                               'susy-compass', 'wordpress',
                                               'sass-loader', 'import', 'fonts',
                                               'visual-studio-code'],
                                      'scala': ['scala', 'apache-spark', 'java',
                                                'playframework', 'sbt',
                                                'apache-spark-sql', 'akka', 'json',
                                                'playframework-2.0',
                                                'functional-programming',
                                                'intellij-idea', 'slick', 'dataframe',
                                                'generics', 'scala-collections',
                                                'types', 'rdd', 'implicit', 'scalatest',
                                                'hadoop', 'pattern-matching', 'list',
                                                'spark-streaming', 'future', 'actor',
                                                'apache-kafka', 'akka-stream', 'maven',
                                                'mongodb', 'scalaz', 'reflection',
                                                'akka-http', 'shapeless', 'lift',
                                                'regex', 'arrays', 'eclipse',
                                                'collections', 'traits', 'spray',
                                                'dictionary', 'scala-cats',
                                                'apache-spark-mllib', 'gatling',
                                                'case-class', 'scala-macros', 'xml',
                                                'unit-testing', 'python',
                                                'concurrency'],
                                      'scaml': ['scala', 'scaml', 'pug', 'scalate',
                                                'playframework-2.0', 'haml',
                                                'scalatra'], 'scdoc': [],
                                      'scheme': ['scheme', 'racket', 'lisp', 'list',
                                                 'functional-programming', 'recursion',
                                                 'sicp', 'lambda', 'macros', 'r5rs',
                                                 'mit-scheme', 'guile', 'function',
                                                 'chicken-scheme', 'common-lisp',
                                                 'continuations', 'clojure',
                                                 'algorithm', 'tail-recursion', 'let',
                                                 'syntax', 'chez-scheme', 'emacs',
                                                 'string', 'sorting', 'interpreter',
                                                 'tree', 'fold', 'haskell', 'callcc',
                                                 'gimp', 'python', 'the-little-schemer',
                                                 'r6rs', 'stream', 'cons', 'vector',
                                                 'procedure', 'evaluation', 'eval',
                                                 'script-fu', 'c', 'if-statement',
                                                 'dictionary', 'loops', 'math',
                                                 'conditional-statements', 'javascript',
                                                 'binary-tree', 'binary-search-tree'],
                                      'scilab': ['scilab', 'matlab', 'plot', 'matrix',
                                                 'xcos', 'function', 'c++', 'octave',
                                                 'image-processing', 'python', 'math',
                                                 'graph', 'ode', 'c', 'user-interface',
                                                 'java', 'algorithm', 'linux', 'loops',
                                                 'opencv', 'variables', 'csv', 'ubuntu',
                                                 'optimization', 'colors',
                                                 'polynomials', 'r', 'arrays', 'vector',
                                                 'real-time', 'differential-equations',
                                                 'arduino', '3d', 'serial-port', 'tcl',
                                                 'signal-processing', 'fft',
                                                 'interpolation', 'precision',
                                                 'equation', 'curve', 'string', 'macos',
                                                 'file', 'for-loop', 'parameters',
                                                 'parallel-processing', 'integration',
                                                 'average', 'simulation'],
                                      'scss': ['sass', 'css', 'html', 'javascript',
                                               'angular', 'webpack', 'compass-sass',
                                               'reactjs', 'ruby-on-rails', 'gulp',
                                               'twitter-bootstrap', 'ruby', 'node.js',
                                               'bootstrap-4', 'vue.js',
                                               'zurb-foundation', 'less', 'gruntjs',
                                               'mixins', 'npm', 'ionic-framework',
                                               'jquery', 'compass', 'scss-mixins',
                                               'node-sass', 'typescript', 'flexbox',
                                               'gulp-sass', 'css-selectors',
                                               'media-queries', 'rubygems',
                                               'asset-pipeline', 'angular-material',
                                               'bourbon', 'laravel', 'variables',
                                               'responsive-design', 'php', 'angularjs',
                                               'haml', 'ionic2', 'ionic3',
                                               'ruby-on-rails-4', 'angular-cli',
                                               'susy-compass', 'wordpress',
                                               'sass-loader', 'import', 'fonts',
                                               'visual-studio-code'], 'shexc': [],
                                      'shen': ['shen', 'types', 'lisp', 'currying',
                                               'dependent-type'],
                                      'sieve': ['sieve', 'primes', 'python',
                                                'sieve-of-eratosthenes', 'algorithm',
                                                'c++', 'java', 'c', 'haskell', 'math',
                                                'arrays', 'performance', 'python-3.x',
                                                'numbers', 'number-theory',
                                                'sieve-of-atkin', 'list', 'loops',
                                                'optimization', 'factorization',
                                                'for-loop', 'memory', 'pascal',
                                                'dovecot', 'wheel-factorization',
                                                'javascript', 'ruby', 'function',
                                                'email', 'go', 'recursion',
                                                'functional-programming',
                                                'segmentation-fault', 'scheme',
                                                'time-complexity', 'list-comprehension',
                                                'long-integer', 'gdal',
                                                'higher-order-functions',
                                                'space-complexity', 'quadratic',
                                                'lazy-sequences', 'primality-test',
                                                'c#', 'jquery', 'r', 'multithreading',
                                                'scala', 'python-2.7',
                                                'entity-framework'], 'silver': [],
                                      'singularity': [],
                                      'slash': ['slash', 'php', '.htaccess', 'url',
                                                'regex', 'backslash', 'trailing',
                                                'mod-rewrite', 'string', 'javascript',
                                                'escaping', 'python', 'redirect',
                                                'java', 'c#', 'apache', 'replace',
                                                'bash', 'url-rewriting', 'path', 'html',
                                                'windows', 'directory', 'json',
                                                'wordpress', 'forward', 'jquery',
                                                'mysql', 'ruby-on-rails', 'command',
                                                'ruby', 'powershell', 'nginx', 'slack',
                                                'c', 'r', 'linux', 'rest', 'variables',
                                                'routes', 'seo', 'filenames', 'file',
                                                'perl', 'sed', 'filepath', 'c++', 'sql',
                                                'xml', 'macos'],
                                      'slim': ['slim', 'php', 'rest', 'slim-3', 'twig',
                                               '.htaccess', 'api', 'json', 'angularjs',
                                               'mysql', 'apache', 'routes',
                                               'javascript', 'eloquent', 'frameworks',
                                               'ajax', 'jquery', 'android', 'html',
                                               'middleware', 'pdo', 'composer-php',
                                               'mod-rewrite', 'laravel',
                                               'authentication', 'nginx', 'post',
                                               'http', 'backbone.js', 'redirect',
                                               'angular', 'curl', 'jwt', 'session',
                                               'phpunit', 'slim-4', 'url-rewriting',
                                               'cors', 'web-services', 'arrays',
                                               'dependency-injection', 'sql', 'get',
                                               'xampp', 'css', 'url-routing', 'oop',
                                               'file-upload', 'postman', 'autoload'],
                                      'slurmbash': [],
                                      'smali': ['smali', 'android', 'java', 'dalvik',
                                                'reverse-engineering', 'apk', 'apktool',
                                                'dex', 'android-studio', 'decompiling',
                                                'bytecode', 'debugging', 'decompiler',
                                                'eclipse', 'intellij-idea', 'boolean',
                                                'antlr4', 'code-injection', 'dex2jar',
                                                'json', 'xml', 'parsing', 'logging',
                                                'android-source', 'logcat',
                                                'disassembly', 'instrumentation',
                                                'recompile', 'reversing', 'python', 'c',
                                                'arrays', 'python-3.x', 'string',
                                                'shell', 'file', 'class',
                                                'react-native', 'android-layout',
                                                'security', 'if-statement', 'url',
                                                'post', 'assembly', 'encryption',
                                                'optimization', 'kotlin',
                                                'android-intent', 'mobile', 'layout'],
                                      'smalltalk': ['smalltalk', 'pharo', 'squeak',
                                                    'seaside', 'visualworks',
                                                    'gnu-smalltalk', 'oop', 'morphic',
                                                    'string', 'monticello', 'java',
                                                    'user-interface', 'ruby', 'pharo-5',
                                                    'python', 'amber-smalltalk',
                                                    'programming-languages', 'arrays',
                                                    'collections', 'gemstone', 'jquery',
                                                    'methods', 'javascript',
                                                    'version-control', 'ffi',
                                                    'objective-c', 'petitparser',
                                                    'ajax', 'class', 'inheritance',
                                                    'design-patterns', 'reflection',
                                                    'metaprogramming',
                                                    'dolphin-smalltalk', 'parsing',
                                                    'object', 'debugging', 'ide',
                                                    'metacello', 'roassal', 'matrix',
                                                    'error-handling', 'block', 'traits',
                                                    'vm-implementation', 'html',
                                                    'loops', 'moose-technology',
                                                    'unit-testing', 'dictionary'],
                                      'smartgameformat': [],
                                      'smarty': ['smarty', 'php', 'prestashop',
                                                 'javascript', 'html', 'jquery',
                                                 'smarty3', 'arrays', 'mysql',
                                                 'templates', 'prestashop-1.6',
                                                 'foreach', 'codeigniter', 'css',
                                                 'smarty2', 'ajax', 'variables',
                                                 'prestashop-1.7', 'template-engine',
                                                 'regex', 'caching', 'cs-cart', 'whmcs',
                                                 'zend-framework', 'loops',
                                                 'multidimensional-array',
                                                 'if-statement', 'json', 'forms',
                                                 'function', 'shopware', 'sql',
                                                 'module', 'include', 'string',
                                                 'model-view-controller', 'date',
                                                 'session', 'prestashop-1.5',
                                                 'database', 'twig',
                                                 'twitter-bootstrap', 'apache',
                                                 'plugins', 'templating',
                                                 'content-management-system',
                                                 'e-commerce', 'sugarcrm',
                                                 'cmsmadesimple', 'facebook'],
                                      'snobol': ['snobol', '.net', 'regex', 'parsing',
                                                 'pattern-matching', 'eval',
                                                 'programming-languages',
                                                 'metaprogramming', 'rexx',
                                                 'multistage'],
                                      'snowball': ['snowball', 'stemming', 'r', 'nlp',
                                                   'java', 'python', 'elasticsearch',
                                                   'lucene', 'tm', 'nltk',
                                                   'porter-stemmer', 'weka',
                                                   'full-text-search', 'solr',
                                                   'lucene.net', 'sentiment-analysis',
                                                   'search', 'arabic', 'rjava',
                                                   'stop-words', 'linguistics',
                                                   'snowballanalyzer', 'php',
                                                   'ruby-on-rails', '.net', 'linux',
                                                   'windows', 'mongodb', 'postgresql',
                                                   'python-2.7', 'go',
                                                   'machine-learning', 'amazon-s3',
                                                   'indexing', 'netbeans', 'config',
                                                   'apply', 'query-string', 'pydev',
                                                   'sphinx', 'nest', 'text-mining',
                                                   'spell-checking', 'solr4',
                                                   'analyzer', 'word-cloud', 'synonym',
                                                   'turkish', 'arabic-support',
                                                   'solr-query-syntax'],
                                      'solidity': ['solidity', 'ethereum',
                                                   'smartcontracts', 'blockchain',
                                                   'truffle', 'web3', 'javascript',
                                                   'web3js', 'remix', 'node.js',
                                                   'reactjs', 'erc20', 'contract',
                                                   'metamask', 'go-ethereum', 'python',
                                                   'ether', 'geth', 'npm',
                                                   'open-zeppelin', 'arrays', 'tron',
                                                   'ganache', 'mocha.js', 'mapping',
                                                   'quorum', 'html', 'token', 'evm',
                                                   'testing', 'unit-testing', 'struct',
                                                   'consensys-truffle', 'transactions',
                                                   'java', 'events', 'abi',
                                                   'cryptocurrency', 'go', 'etherscan',
                                                   'string', 'json', 'python-3.x',
                                                   'function', 'ico', 'transfer',
                                                   'ipfs', 'tronweb', 'azure',
                                                   'inheritance'], 'sourcepawn': [],
                                      'sourceslist': [],
                                      'sparql': ['sparql', 'rdf', 'dbpedia', 'jena',
                                                 'semantic-web', 'wikidata', 'java',
                                                 'owl', 'ontology', 'virtuoso',
                                                 'python', 'fuseki', 'protege',
                                                 'linked-data', 'rdflib', 'graphdb',
                                                 'rdfs', 'sparqlwrapper', 'triplestore',
                                                 'sesame', 'wikipedia', 'php',
                                                 'turtle-rdf', 'marklogic', 'dotnetrdf',
                                                 'regex', 'blazegraph', 'semantics',
                                                 'arq', 'javascript', 'rdf4j',
                                                 'database', 'named-graphs',
                                                 'federated-queries', 'tdb',
                                                 'blank-nodes', 'endpoint', 'triples',
                                                 'json', 'filter', 'c#', 'r', 'stardog',
                                                 'xml', 'allegrograph', 'sql',
                                                 'topbraid-composer', 'eclipse',
                                                 'geosparql', 'freebase'],
                                      'sql': ['sql', 'sql-server', 'mysql', 'oracle',
                                              'php', 'database', 'postgresql', 'tsql',
                                              'c#', 'sql-server-2008', 'join', 'java',
                                              'ms-access', 'select', 'sqlite',
                                              'stored-procedures', 'asp.net', 'python',
                                              'group-by', 'plsql', 'sql-server-2005',
                                              'sql-server-2012', 'oracle11g', 'date',
                                              'linq', 'count', 'performance', 'vb.net',
                                              'database-design', 'sql-update',
                                              'datetime', 'subquery', 'triggers', 'vba',
                                              '.net', 'html', 'sql-server-2008-r2',
                                              'pivot', 'ruby-on-rails', 'db2',
                                              'entity-framework', 'xml', 'excel',
                                              'hibernate', 'jdbc', 'android',
                                              'google-bigquery', 'where-clause',
                                              'javascript', 'json'],
                                      'sqliteconsole': [], 'squidconf': [],
                                      'ssp': ['ssp', 'sharepoint', 'bluetooth',
                                              'javascript', 'c++', 'mysql', 'scala',
                                              'netsuite', 'scalate', 'php', 'android',
                                              'c', 'sql-server', 'windows', 'search',
                                              'datatables', 'sharepoint-2007', 'jquery',
                                              'node.js', 'powershell', 'gcc',
                                              'embedded', 'suitescript', 'bluez', 'dma',
                                              'scalatra', 'suitecommerce', 'mysite',
                                              'c#', 'sql', 'json', 'linux', 'database',
                                              'macos', 'jsp', 'authentication', 'xslt',
                                              'dll', 'filter', 'compiler-errors',
                                              'scripting', 'raspberry-pi', 'sbt', 'g++',
                                              'migration', 'mariadb', 'sql-order-by',
                                              'codeigniter-3', 'e-commerce', 'union'],
                                      'stan': ['stan', 'r', 'rstan', 'bayesian',
                                               'python', 'pystan', 'mcmc', 'rstanarm',
                                               'statistics', 'jags', 'c++', 'pymc3',
                                               'winbugs', 'hierarchical-bayesian',
                                               'plot', 'regression', 'r-markdown',
                                               'mixed-models', 'mixture-model', 'linux',
                                               'ggplot2', 'rcpp', 'arrays', 'macos',
                                               'dataframe', 'ubuntu', 'vector',
                                               'installation', 'anaconda', 'rstudio',
                                               'logistic-regression', 'sampling',
                                               'pymc', 'multilevel-analysis', 'mixture',
                                               'python-3.x', 'performance', 'facebook',
                                               'unix', 'matrix', 'model', 'histogram',
                                               'cluster-computing', 'vectorization',
                                               'integration', 'simulation',
                                               'data-modeling', 'distribution',
                                               'missing-data', 'hierarchical-data'],
                                      'stata': ['stata', 'r', 'loops', 'stata-macros',
                                                'regression', 'python', 'graph',
                                                'statistics', 'string', 'variables',
                                                'foreach', 'matrix', 'date',
                                                'panel-data', 'pandas', 'latex',
                                                'for-loop', 'panel', 'excel', 'label',
                                                'plot', 'sas', 'merge', 'reshape',
                                                'regex', 'if-statement', 'import',
                                                'time-series', 'logistic-regression',
                                                'data-manipulation', 'csv', 'local',
                                                'dataset', 'sorting',
                                                'linear-regression', 'missing-data',
                                                'survey', 'output', 'dataframe',
                                                'random', 'count', 'format',
                                                'dummy-variable', 'matlab', 'time',
                                                'coefplot', 'replace', 'export', 'plm',
                                                'data-management'],
                                      'supercollider': ['supercollider', 'audio',
                                                        'python', 'osc', 'clojure',
                                                        'jack', 'overtone', 'java',
                                                        'c++', 'arrays', 'linux',
                                                        'haskell', 'sound-synthesis',
                                                        'javascript', 'android',
                                                        'macos', 'qt', 'ubuntu', 'pip',
                                                        'processing', 'fft',
                                                        'scheduling', 'alsa',
                                                        'web-audio-api',
                                                        'opensoundcontrol', 'json',
                                                        'python-3.x', 'windows',
                                                        'scala', 'apache', 'function',
                                                        'user-interface', 'debugging',
                                                        'events',
                                                        'multidimensional-array',
                                                        'design-patterns',
                                                        'serialization', 'types',
                                                        'command-line', 'redis',
                                                        'cmake', 'arduino',
                                                        'android-ndk', 'raspberry-pi',
                                                        'nested', 'ide', 'arguments',
                                                        'iteration', 'yaml',
                                                        'constraints'],
                                      'swift': ['swift', 'ios', 'xcode', 'uitableview',
                                                'objective-c', 'firebase', 'iphone',
                                                'arrays', 'swift3', 'swiftui', 'json',
                                                'sprite-kit', 'uicollectionview',
                                                'macos', 'core-data', 'swift2',
                                                'alamofire', 'uiview',
                                                'firebase-realtime-database',
                                                'uiviewcontroller', 'parse-platform',
                                                'cocoa', 'autolayout', 'uibutton',
                                                'swift4', 'realm', 'generics', 'uikit',
                                                'tableview', 'uinavigationcontroller',
                                                'segue', 'uiscrollview', 'string',
                                                'dictionary', 'cocoapods',
                                                'uitextfield', 'ios8', 'uiimageview',
                                                'xcode6', 'storyboard', 'uiimage',
                                                'uicollectionviewcell', 'animation',
                                                'avfoundation', 'uilabel', 'scenekit',
                                                'mapkit', 'protocols',
                                                'uinavigationbar',
                                                'uitabbarcontroller'],
                                      'swig': ['swig', 'c++', 'python', 'c', 'java',
                                               'c#', 'java-native-interface', 'lua',
                                               'numpy', 'cmake', 'arrays', 'php',
                                               'python-3.x', 'ruby', 'perl', 'wrapper',
                                               'android', 'go', 'pointers', 'dll',
                                               'python-2.7', 'tcl', 'macos', 'ctypes',
                                               'node.js', 'windows', 'c++11', 'struct',
                                               'templates', 'vector', 'gcc', 'typemaps',
                                               'distutils', 'linux', 'boost',
                                               'shared-libraries', 'javascript',
                                               'opencv', 'callback', 'android-ndk',
                                               'g++', 'string', 'binding', 'cython',
                                               'exception', 'linker', 'boost-python',
                                               'visual-studio', 'visual-studio-2010',
                                               'makefile'], 'systemverilog': [],
                                      'tap': ['tap', 'ios', 'android', 'iphone',
                                              'javascript', 'jquery', 'swift', 'touch',
                                              'perl', 'events', 'gesture',
                                              'jquery-mobile', 'linux', 'c#', 'testing',
                                              'click', 'objective-c', 'node.js',
                                              'double', 'tun', 'unit-testing',
                                              'networking', 'mobile',
                                              'uigesturerecognizer', 'python', 'image',
                                              'uitapgesturerecognizer', 'angular',
                                              'windows', 'jenkins', 'uiview', 'swipe',
                                              'java', 'xcode', 'asynchronous', 'button',
                                              'uiscrollview', 'uiimageview',
                                              'uitextview', 'html', 'css',
                                              'sencha-touch-2', 'swiftui', 'c++',
                                              'ruby', 'google-maps', 'uitableview',
                                              'sockets', 'unity3d', 'flutter'],
                                      'tnt': [],
                                      'toml': ['toml', 'rust', 'hugo', 'python', 'go',
                                               'serde', 'blogdown', 'r',
                                               'configuration', 'r-markdown', 'netlify',
                                               'java', 'html', 'json', 'python-2.7',
                                               'yaml', 'rust-cargo', 'css', 'docker',
                                               'dependencies', 'julia', 'markdown',
                                               'telegraf', 'node.js', 'python-3.x',
                                               'parsing', 'awk', 'jwt',
                                               'command-line-interface',
                                               'deserialization', 'config', 'gitlab-ci',
                                               'traits', 'gitlab-ci-runner', 'traefik',
                                               'cpython', 'javascript', 'arrays',
                                               'angularjs', 'swift', 'ruby', 'spring',
                                               'windows', 'bash', 'macos', 'typescript',
                                               'matlab', 'maven', 'numpy', 'csv'],
                                      'tads3': [],
                                      'tasm': ['tasm', 'assembly', 'x86-16', 'x86',
                                               'dos', 'dosbox', 'masm', 'emu8086',
                                               'arrays', '16-bit', 'string', 'bios',
                                               'windows', 'loops', 'c', 'graphics',
                                               'macros', 'file', 'memory', 'nasm',
                                               'interrupt', 'debugging', 'real-mode',
                                               'mouse', 'variables', 'video',
                                               'keyboard', 'buffer', 'sorting',
                                               'random', 'printing', 'colors', 'ascii',
                                               'division', 'inline-assembly',
                                               'cpu-registers', 'pointers', 'time',
                                               'file-io', 'compilation',
                                               'character-encoding', 'floating-point',
                                               'local', 'nested-loops', 'offset',
                                               'procedure', '32-bit', 'masm32', 'x87',
                                               'tsr'],
                                      'tcl': ['tcl', 'tk', 'expect', 'regex', 'python',
                                              'linux', 'list', 'ns2', 'tkinter', 'bash',
                                              'c++', 'shell', 'string', 'c', 'arrays',
                                              'perl', 'user-interface', 'windows',
                                              'variables', 'scripting', 'r',
                                              'multithreading', 'file', 'unix', 'exec',
                                              'tclsh', 'dictionary', 'ssh', 'proc',
                                              'itcl', 'foreach', 'namespaces', 'swig',
                                              'macos', 'modelsim', 'eggdrop', 'sqlite',
                                              'split', 'java', 'awk', 'telnet',
                                              'sorting', 'package', 'procedure', 'sed',
                                              'cisco', 'loops', 'networking', 'xml',
                                              'http'],
                                      'tcsh': ['tcsh', 'shell', 'csh', 'linux', 'bash',
                                               'unix', 'python', 'scripting', 'alias',
                                               'perl', 'awk', 'sed', 'makefile', 'grep',
                                               'terminal', 'environment-variables',
                                               'foreach', 'variables', 'if-statement',
                                               'redirect', 'zsh', 'solaris', 'vim',
                                               'command-line', 'autocomplete', 'sh',
                                               'prompt', 'regex', 'windows', 'ssh',
                                               'subprocess', 'xargs', 'tab-completion',
                                               'complete', 'setenv', 'c', 'string',
                                               'file', 'while-loop', 'path', 'find',
                                               'pipe', 'cygwin', 'echo', 'stderr',
                                               'xterm', 'openbsd', 'arrays',
                                               'python-3.x', 'macos'],
                                      'teatemplate': [],
                                      'teraterm': ['teraterm', 'serial-port', 'macros',
                                                   'terminal', 'ttl', 'python', 'c',
                                                   'batch-file', 'scripting', 'linux',
                                                   'shell', 'logging', 'c#', 'c++',
                                                   'windows', 'ssh', 'command',
                                                   'printf', 'putty', 'mbed', 'xmodem',
                                                   'javascript', 'android', 'mysql',
                                                   'mongodb', 'python-2.7', 'qt',
                                                   'android-studio', 'datetime',
                                                   'winapi', 'cmd', 'command-line',
                                                   'utf-8', 'build', 'timer', 'arduino',
                                                   'bluetooth', 'character-encoding',
                                                   'subprocess', 'usb', 'byte',
                                                   'virtual-machine', 'port', 'screen',
                                                   'command-prompt', 'stm32', 'telnet',
                                                   'paramiko', 'esp8266', 'pyserial'],
                                      'termcap': ['termcap', 'c', 'terminal',
                                                  'terminfo', 'unix', 'tty', 'ncurses',
                                                  'linux', 'perl', 'bash', 'shell',
                                                  'gnu-screen', 'macos', 'xterm',
                                                  'termios', 'python', 'vim', 'colors',
                                                  'console', 'environment-variables',
                                                  'c++14', 'informix', 'curses',
                                                  'ansi-escape', 'debugging', 'ssh',
                                                  'emacs', 'character-encoding',
                                                  'installation', 'binary', 'debian',
                                                  'ascii', 'mingw', 'posix', 'dos',
                                                  'jobs', 'keycode', 'margins', 'keyup',
                                                  'iterm2', 'ioctl', 'cursor-position',
                                                  'backticks', 'ctrl',
                                                  'terminal-emulator', 'raku', '4gl',
                                                  'tui', 'netbsd', 'vt100'],
                                      'terminfo': ['terminfo', 'terminal', 'ncurses',
                                                   'termcap', 'linux', 'c', 'curses',
                                                   'xterm', 'tmux', 'tty', 'c++',
                                                   'unix', 'gnu-screen', 'tput',
                                                   'python', 'colors', 'emacs', 'bash',
                                                   'shell', 'perl', 'vim', 'console',
                                                   'keyboard', 'c++14', 'zsh', 'ruby',
                                                   'macos', 'c++11', 'haskell',
                                                   'search', 'utf-8', 'path',
                                                   'scripting', 'centos', 'pycharm',
                                                   'sbt', 'debian', 'ipython', 'posix',
                                                   'locale', 'sequence', 'autohotkey',
                                                   'macos-sierra', 'text-processing',
                                                   'csh', 'spacing', 'color-scheme',
                                                   'slurm', 'monad-transformers',
                                                   'pypy'],
                                      'terraform': ['terraform', 'amazon-web-services',
                                                    'terraform-provider-aws', 'azure',
                                                    'terraform-provider-azure',
                                                    'google-cloud-platform',
                                                    'amazon-ec2',
                                                    'terraform-provider-gcp',
                                                    'kubernetes', 'amazon-s3',
                                                    'terraform0.12+', 'aws-lambda',
                                                    'devops', 'amazon-iam',
                                                    'amazon-ecs', 'docker',
                                                    'terraform-template-file',
                                                    'aws-api-gateway',
                                                    'amazon-cloudwatch', 'azure-devops',
                                                    'amazon-rds', 'amazon-eks',
                                                    'terragrunt',
                                                    'amazon-cloudformation', 'hcl',
                                                    'google-kubernetes-engine',
                                                    'infrastructure-as-code', 'ansible',
                                                    'amazon-route53', 'jenkins',
                                                    'amazon-vpc', 'json', 'bash',
                                                    'google-compute-engine', 'azure-rm',
                                                    'powershell', 'go', 'vsphere',
                                                    'azure-aks', 'autoscaling',
                                                    'kubernetes-helm', 'ssh', 'python',
                                                    'amazon-elastic-beanstalk', 'git',
                                                    'gitlab', 'openstack',
                                                    'aws-security-group',
                                                    'jenkins-pipeline', 'linux'],
                                      'tex': ['tex', 'latex', 'python', 'r',
                                              'matplotlib', 'mathjax', 'pdflatex',
                                              'vim', 'knitr', 'pdf', 'r-markdown',
                                              'javascript', 'matlab', 'emacs', 'pandoc',
                                              'regex', 'html', 'tikz', 'image', 'macos',
                                              'php', 'math', 'markdown', 'sweave',
                                              'xelatex', 'java', 'linux', 'fonts',
                                              'katex', 'c#', 'python-3.x', 'plot',
                                              'rstudio', 'lyx', 'miktex',
                                              'latex-environment', 'typesetting',
                                              'documentation', 'doxygen', 'ubuntu',
                                              'unicode', 'jupyter-notebook', 'bibtex',
                                              'android', 'parsing', 'replace',
                                              'equation', 'tabular', 'maxima',
                                              'xtable'],
                                      'text': ['text', 'python', 'html', 'java', 'file',
                                               'javascript', 'css', 'c#', 'android',
                                               'string', 'php', 'jquery', 'r', 'regex',
                                               'image', 'parsing', 'c++', 'replace',
                                               'excel', 'python-3.x', 'arrays', 'input',
                                               'ios', 'c', 'csv', 'bash', 'search',
                                               'button', 'nlp', 'colors', 'mysql',
                                               'batch-file', 'pdf', 'list', 'vb.net',
                                               'vba', 'fonts', 'xml', 'linux',
                                               'tkinter', 'alignment', 'matlab',
                                               'split', 'sed', 'formatting', 'pandas',
                                               'awk', 'label', 'windows', 'extract'],
                                      'thrift': ['thrift', 'java', 'python', 'c++',
                                                 'cassandra', 'hbase',
                                                 'thrift-protocol', 'php', 'hadoop',
                                                 'hive', 'c#', 'rpc',
                                                 'protocol-buffers', 'node.js', 'scala',
                                                 'serialization', 'javascript',
                                                 'apache-spark', 'ruby', 'json',
                                                 'sockets', 'go', 'maven', 'apache',
                                                 'happybase', 'multithreading', 'c',
                                                 'asynchronous', 'erlang', 'nosql',
                                                 'ssl', 'cql', 'scrooge', 'finagle',
                                                 'android', '.net', 'linux', 'ubuntu',
                                                 'exception', 'windows', 'makefile',
                                                 'avro', 'idl', 'python-2.7', 'qt',
                                                 'boost', 'hector', 'eclipse', 'macos',
                                                 'rest'],
                                      'tiddlywiki5': ['tiddlywiki5', 'tiddlywiki',
                                                      'javascript', 'wiki', 'node.js',
                                                      'sorting', 'php', 'css', 'arrays',
                                                      'list', 'azure', 'svg', 'heroku',
                                                      'search', 'filter', 'syntax',
                                                      'fonts', 'macros', 'electron',
                                                      'themes', 'session-cookies',
                                                      'highlight', 'sidebar',
                                                      'transclusion', 'highlight.js',
                                                      'wikitext'], 'todotxt': [],
                                      'transactsql': [],
                                      'treetop': ['treetop', 'ruby', 'parsing', 'peg',
                                                  'grammar', 'ruby-on-rails', 'regex',
                                                  'abstract-syntax-tree', 'dsl',
                                                  'bbcode', 'left-recursion',
                                                  'ruby-on-rails-3', 'email',
                                                  'recursion', 'vim', 'deployment',
                                                  'syntax', 'rspec',
                                                  'visual-studio-code', 'null', 'nlp',
                                                  'rubygems', 'debian', 'lisp', 'rvm',
                                                  'capistrano', 'stanford-nlp',
                                                  'indentation', 'erb',
                                                  'regex-negation', 'delayed-job',
                                                  'language-design', 'configparser',
                                                  'bnf', 'mt940'], 'turtle': [],
                                      'twightml': [],
                                      'typescript': ['typescript', 'angular',
                                                     'javascript', 'reactjs', 'node.js',
                                                     'html', 'rxjs', 'ionic-framework',
                                                     'angularjs', 'webpack',
                                                     'typescript-typings', 'arrays',
                                                     'ionic2', 'json', 'firebase',
                                                     'visual-studio-code',
                                                     'angular-material', 'ionic3',
                                                     'css', 'types', 'angular6',
                                                     'vue.js', 'ecmascript-6', 'jestjs',
                                                     'npm', 'observable', 'generics',
                                                     'react-native', 'unit-testing',
                                                     'jquery', 'express', 'angular5',
                                                     'redux', 'typescript-generics',
                                                     'nestjs', 'angular8', 'angular7',
                                                     'jasmine', 'promise',
                                                     'typescript2.0', 'interface',
                                                     'google-cloud-firestore',
                                                     'visual-studio', 'angular-cli',
                                                     'protractor', 'typeorm', 'ionic4',
                                                     'c#', 'angular2-routing',
                                                     'object'],
                                      'typoscript': ['typoscript', 'typo3',
                                                     'typo3-7.6.x', 'fluid',
                                                     'typo3-6.2.x', 'typo3-9.x', 'php',
                                                     'typo3-8.x', 'extbase', 'html',
                                                     'menu', 'tx-news', 'typo3-6.1.x',
                                                     'tt-news', 'typo3-extensions',
                                                     'templavoila', 'typo3-10.x',
                                                     'templates',
                                                     'content-management-system', 'rte',
                                                     'conditional-statements', 'css',
                                                     'realurl', 'image',
                                                     'fluid-styled-content',
                                                     'javascript', 'forms', 'select',
                                                     'tsconfig', 'typo3-8.7.x',
                                                     'powermail', 'typolink',
                                                     'typo3-7.x', 'multilingual',
                                                     'typo3-4.5', 'twitter-bootstrap',
                                                     'caching', 'ckeditor',
                                                     'tx-gridelements', 'database',
                                                     'yaml', 'categories', 'constants',
                                                     'mysql', 'if-statement', 'plugins',
                                                     'solr', 'backend', 'neoscms',
                                                     'sql'], 'ucode': [], 'unicon': [],
                                      'urbiscript': [],
                                      'usd': ['usd', 'usdz', 'ios', 'linux', 'macos',
                                              'docker', 'dynamics-crm',
                                              'azure-functions', 'executable', 'arkit',
                                              'arquicklook'],
                                      'vbscript': ['vbscript', 'asp-classic', 'excel',
                                                   'vba', 'batch-file', 'windows',
                                                   'javascript', 'html', 'qtp', 'c#',
                                                   'hta', 'wsh', 'xml', 'powershell',
                                                   'sql', 'regex', 'hp-uft', 'cmd',
                                                   'wmi', 'scripting', 'sql-server',
                                                   'vb.net', 'arrays', 'outlook',
                                                   'internet-explorer', 'ms-access',
                                                   'asp.net', 'csv', 'com',
                                                   'automation', 'adodb', 'ado',
                                                   'ms-word', 'string', 'registry',
                                                   'active-directory', '.net', 'email',
                                                   'file', 'loops', 'vb6', 'java',
                                                   'scheduled-tasks', 'iis',
                                                   'windows-7', 'command-line', 'php',
                                                   'variables', 'filesystemobject',
                                                   'jquery'],
                                      'vcl': ['vcl', 'delphi', 'c++builder', 'c++',
                                              'components', 'windows', 'delphi-xe2',
                                              'delphi-7', 'firemonkey', 'winapi',
                                              'multithreading', 'devexpress',
                                              'vcl-styles', 'teechart', 'forms',
                                              'delphi-2010', 'user-interface',
                                              'delphi-10.2-tokyo', 'delphi-2007',
                                              'delphi-xe3', 'delphi-10-seattle',
                                              'varnish', 'delphi-10.1-berlin',
                                              'controls', 'delphi-10.3-rio', 'dll',
                                              'delphi-2009', 'delphi-xe',
                                              'c++builder-6', 'delphi-xe7',
                                              'delphi-xe4', 'fastreport', 'tstringgrid',
                                              'c++builder-xe5', 'tlistview', 'bitmap',
                                              'ado', 'delphi-xe6', 'delphi-xe8',
                                              'tform', 'listview', 'drag-and-drop',
                                              'ide', 'styles', 'delphi-xe5', 'tcxgrid',
                                              'c++builder-xe2', 'c++builder-xe', '.net',
                                              'database'],
                                      'vgl': ['vgl', '.net', 'c#', 'c++', 'opengl',
                                              'windows-10', 'coding-style',
                                              'naming-conventions'],
                                      'vala': ['vala', 'gtk', 'gtk3', 'glib', 'genie',
                                               'c', 'linux', 'gnome', 'vapi', 'gobject',
                                               'ubuntu', 'clutter', 'multithreading',
                                               'webkit', 'gstreamer', 'python', 'dbus',
                                               'windows', 'cmake', 'gio',
                                               'asynchronous', 'cairo', 'meson-build',
                                               'elementary', 'c++', 'gcc', 'arrays',
                                               'regex', 'glade', 'user-interface',
                                               'pointers', 'generics',
                                               'memory-management', 'gee',
                                               'gnome-builder', 'c#', 'css', 'json',
                                               'compiler-errors', 'window', 'sdl',
                                               'x11', 'libxml2', 'msys2', 'gdk', 'java',
                                               'string', 'sqlite', 'function', 'oop'],
                                      'vbnetaspx': [], 'vbnet': [],
                                      'velocity': ['velocity', 'java', 'spring',
                                                   'javascript', 'spring-mvc',
                                                   'liferay', 'templates', 'apache',
                                                   'html', 'jquery', 'template-engine',
                                                   'jira', 'vtl', 'freemarker', 'maven',
                                                   'jsp', 'liferay-velocity',
                                                   'spring-boot', 'tomcat', 'liferay-6',
                                                   'c#', 'email', 'jira-plugin',
                                                   'arrays', 'unity3d', 'xml',
                                                   'intellij-idea', 'css', 'meteor',
                                                   'apache-velocity', 'confluence',
                                                   'json', 'eclipse', 'foreach',
                                                   'liferay-theme', 'xwiki', 'regex',
                                                   'string', 'servlets', 'android',
                                                   'struts2', 'solr', 'aws-api-gateway',
                                                   'xdocreport', 'physics', 'c++',
                                                   'nvelocity',
                                                   'velocity-template-language',
                                                   'jakarta-mail', 'python'],
                                      'verilog': ['verilog', 'system-verilog', 'fpga',
                                                  'hdl', 'xilinx', 'modelsim', 'vhdl',
                                                  'synthesis', 'quartus', 'vivado',
                                                  'iverilog', 'arrays',
                                                  'register-transfer-level', 'hardware',
                                                  'simulation', 'intel-fpga',
                                                  'test-bench', 'xilinx-ise', 'module',
                                                  'uvm', 'vlsi', 'counter', 'fsm',
                                                  'for-loop', 'clock', 'icarus',
                                                  'verification', 'flip-flop', 'syntax',
                                                  'asic', 'digital-logic', 'alu',
                                                  'yosys', 'system-verilog-assertions',
                                                  'logic', 'parameters', 'c',
                                                  'if-statement', 'memory', 'mips',
                                                  'cpu-architecture', 'emacs',
                                                  'floating-point', 'digital-design',
                                                  'syntax-error', 'delay', 'circuit',
                                                  'mux', 'digital', 'algorithm'],
                                      'vhdl': ['vhdl', 'fpga', 'xilinx', 'modelsim',
                                               'quartus', 'vivado', 'verilog',
                                               'intel-fpga', 'hdl', 'xilinx-ise',
                                               'synthesis', 'arrays', 'simulation',
                                               'clock', 'counter', 'ghdl', 'fsm',
                                               'hardware', 'test-bench', 'if-statement',
                                               'spartan', 'syntax', 'generics', 'alu',
                                               'signals', 'system-verilog',
                                               'state-machine', 'process', 'ram',
                                               'vector', 'compiler-errors', 'logic',
                                               'flip-flop', 'integer', 'for-loop',
                                               'loops', 'type-conversion', 'c',
                                               'multiplication', 'digital-logic',
                                               'floating-point', 'types', 'binary',
                                               'register-transfer-level', 'fixed-point',
                                               'function', 'testing', 'package', 'mux',
                                               'variables'],
                                      'vim': ['vim', 'regex', 'vi', 'python',
                                              'vim-plugin', 'linux', 'macvim', 'bash',
                                              'macos', 'c++', 'editor', 'neovim', 'git',
                                              'windows', 'ctags', 'syntax-highlighting',
                                              'terminal', 'plugins', 'nerdtree',
                                              'vim-syntax-highlighting', 'indentation',
                                              'autocomplete', 'replace', 'shell',
                                              'ruby', 'search', 'c', 'ubuntu', 'tmux',
                                              'javascript', 'unix', 'emacs', 'php',
                                              'syntastic', 'keyboard-shortcuts',
                                              'color-scheme', 'html', 'latex', 'sed',
                                              'text-editor', 'folding', 'syntax',
                                              'ruby-on-rails', 'youcompleteme',
                                              'highlight', 'java', 'ide', 'tabs',
                                              'cscope', 'buffer'], 'wdiff': [],
                                      'webidl': ['webidl', 'javascript', 'emscripten',
                                                 'idl', 'c++', 'firefox', 'c#', 'api',
                                                 'firefox-os', 'gecko', 'b2g', 'python',
                                                 'node.js', 'templates', 'npm',
                                                 'data-structures', 'interface',
                                                 'callback', 'floating-point',
                                                 'xmlhttprequest', 'cross-browser',
                                                 'c++-cli', 'webgl',
                                                 'speech-recognition', 'ipc',
                                                 'indexeddb', 'specifications',
                                                 'porting', 'ieee-754',
                                                 'prototypal-inheritance',
                                                 'webassembly', 'geckofx',
                                                 'floating-point-conversion', 'ecma',
                                                 'window-object', 'webgl-extensions',
                                                 'cssom'], 'whiley': [],
                                      'x10': ['x10', 'android', 'c#', 'java', 'php',
                                              'c++', 'arduino', 'serial-port', 'adb',
                                              'home-automation', 'x10-language', '.net',
                                              'linux', 'azure', 'api', 'security',
                                              'debugging', 'video', 'gwt', 'automation',
                                              'bluetooth', 'raspberry-pi',
                                              'continuous-integration', 'google-play',
                                              'hex', 'usb', 'cloud', 'apk', 'java-me',
                                              'wifi', 'screen', 'reverse-engineering',
                                              'vlc', 'build-automation', 'managed',
                                              'sony', 'atmega', 'screen-size', 'nas',
                                              'windowsiot', 'midlet', 'atmelstudio',
                                              'sony-xperia', 'milestone'],
                                      'xquery': ['xquery', 'xml', 'xpath', 'marklogic',
                                                 'sql-server', 'tsql', 'sql', 'basex',
                                                 'exist-db', 'xslt', 'java', 'saxon',
                                                 'xquery-sql', 'sql-server-2008',
                                                 'xquery-3.0', 'marklogic-8', 'html',
                                                 'flwor', 'osb', 'oracle',
                                                 'xml-parsing', 'xquery-update',
                                                 'sql-server-2005', 'javascript',
                                                 'json', 'marklogic-9', 'c#',
                                                 'database', 'regex', 'sql-server-2012',
                                                 'xsd', 'php', 'namespaces', 'soapui',
                                                 'zorba', 'sql-server-2008-r2',
                                                 'sqlxml', 'xpath-2.0', 'string',
                                                 'xml-namespaces', 'xmltable',
                                                 'function', 'soap', 'xslt-2.0',
                                                 'oracle11g', 'db2', 'performance',
                                                 'for-loop', 'attributes', 'rest'],
                                      'xml': ['xml', 'java', 'android', 'c#', 'xslt',
                                              'php', 'xpath', 'python', 'xsd',
                                              'javascript', 'xml-parsing', 'html',
                                              'parsing', '.net', 'sql-server',
                                              'android-layout', 'jaxb', 'json', 'sql',
                                              'jquery', 'soap', 'linq', 'dom',
                                              'asp.net', 'xslt-1.0', 'web-services',
                                              'serialization', 'linq-to-xml', 'spring',
                                              'android-studio', 'vb.net', 'simplexml',
                                              'xquery', 'xslt-2.0', 'layout', 'regex',
                                              'mysql', 'eclipse', 'xml-serialization',
                                              'ajax', 'excel', 'powershell',
                                              'elementtree', 'c++', 'rss', 'arrays',
                                              'r', 'tsql', 'perl', 'ruby'],
                                      'xorg': ['xorg', 'linux', 'x11', 'xlib', 'c',
                                               'c++', 'xserver', 'python', 'ubuntu',
                                               'qt', 'bash', 'java', 'nvidia', 'xcb',
                                               'keyboard', 'archlinux', 'centos',
                                               'window', 'window-managers', 'opengl',
                                               'debian', 'gtk', 'gnome', 'framebuffer',
                                               'ssh', 'shell', 'raspberry-pi', 'driver',
                                               'mouse', 'xvfb', 'xfce', 'mesa',
                                               'wayland', 'user-interface', 'graphics',
                                               'linux-kernel', 'multiple-monitors',
                                               'i3', 'macos', 'unix', 'video', 'fonts',
                                               'terminal', 'emacs', 'gpu', 'clipboard',
                                               'intel', 'gtk3', 'tty', 'xrandr'],
                                      'xslt': ['xslt', 'xml', 'xslt-1.0', 'xpath',
                                               'xslt-2.0', 'html', 'java', 'c#',
                                               'javascript', 'xsl-fo', 'saxon', 'php',
                                               'xsd', '.net', 'apache-fop',
                                               'xml-parsing', 'transformation',
                                               'xslt-grouping', 'sorting', 'css',
                                               'namespaces', 'transform', 'asp.net',
                                               'csv', 'xalan', 'json', 'xml-namespaces',
                                               'regex', 'foreach', 'xhtml', 'jquery',
                                               'xslt-3.0', 'umbraco', 'pdf', 'xquery',
                                               'sharepoint', 'templates', 'grouping',
                                               'variables', 'python', 'excel', 'soap',
                                               'string', 'muenchian-grouping',
                                               'biztalk', 'attributes', 'xpath-2.0',
                                               'docbook', 'exslt', 'date'],
                                      'xtend': ['xtend', 'xtext', 'java', 'eclipse',
                                                'dsl', 'code-generation', 'eclipse-emf',
                                                'xbase', 'eclipse-plugin', 'maven',
                                                'xpand', 'validation', 'templates',
                                                'gradle', 'annotations', 'android',
                                                'jvm', 'intellij-idea', 'eclipse-rcp',
                                                'antlr', 'guice', 'grammar',
                                                'eclipse-jdt', 'mwe', 'arrays',
                                                'for-loop', 'gwt', 'syntax',
                                                'compilation', 'generator', 'ecore',
                                                'string', 'scala', 'selenium',
                                                'unit-testing', 'loops', 'sorting',
                                                'generics', 'arraylist', 'lambda',
                                                'plugins', 'junit', 'collections',
                                                'interface', 'scope',
                                                'compiler-construction', 'formatting',
                                                'sonarqube', 'ide', 'integer'],
                                      'xtlang': [], 'yamljinja': [],
                                      'yaml': ['yaml', 'python', 'java', 'ruby',
                                               'ansible', 'ruby-on-rails', 'symfony',
                                               'php', 'spring-boot', 'azure-devops',
                                               'kubernetes', 'pyyaml', 'json',
                                               'amazon-web-services', 'azure-pipelines',
                                               'spring', 'docker',
                                               'amazon-cloudformation', 'swagger',
                                               'python-3.x', 'google-app-engine', 'go',
                                               'snakeyaml', 'parsing', 'jekyll',
                                               'javascript', 'r', 'ruamel.yaml',
                                               'docker-compose', 'configuration',
                                               'azure', 'continuous-integration',
                                               'node.js', 'serialization', 'r-markdown',
                                               'jinja2', 'gitlab-ci', 'gitlab', 'bash',
                                               'xml', 'c++', 'dictionary', 'c#',
                                               'kubernetes-helm', 'jackson', 'yaml-cpp',
                                               'doctrine', 'regex', 'doctrine-orm',
                                               'perl'],
                                      'yang': ['yang', 'ietf-netmod-yang',
                                               'ietf-netconf', 'netconf',
                                               'opendaylight', 'python', 'json', 'xml',
                                               'validation', 'model', 'routes',
                                               'command-line-interface', 'schema',
                                               'xpath-1.0', 'jncryptor', 'ietf'],
                                      'zeek': ['zeek', 'bro', 'logging', 'bash',
                                               'networking', 'java', 'linux', 'file',
                                               'unix', 'elasticsearch', 'ssh', 'proxy',
                                               'dns', 'network-programming', 'rabbitmq',
                                               'kibana', 'openstack', 'signature',
                                               'rtp', 'squid', 'logfile',
                                               'network-analysis',
                                               'intrusion-detection',
                                               'traffic-measurement', 'ids'],
                                      'zephir': ['zephir', 'php', 'windows',
                                                 'php-extension', 'c', 'package',
                                                 'phalcon', 'c++', 'mysql', 'function',
                                                 'class', 'visual-studio-2010',
                                                 'ubuntu', 'nginx', 'curl', 'gcc',
                                                 'bluetooth', 'compilation',
                                                 'installation', 'ubuntu-16.04', 'hook',
                                                 'private', 'php-7', 'hhvm', 'hci',
                                                 'ampps', 'php-cpp'],
                                      'zig': ['zig', 'c', 'compiler-errors', 'arrays',
                                              'string', 'windows', 'templates', 'unix',
                                              'opengl', 'assembly', 'arraylist',
                                              'multidimensional-array', 'struct',
                                              'unicode', 'types', 'build',
                                              'memory-leaks', 'terminal', 'opengl-es',
                                              'linker', 'segmentation-fault', 'erlang',
                                              'clang', 'bit-manipulation',
                                              'programming-languages', 'x11', 'bit',
                                              'utf-16', 'libc', 'debug-symbols',
                                              'osdev', 'allocator', 'affinity',
                                              'vertex-array-object', 'lld',
                                              'compiler-development', 'comptime']}

