"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CodePipelineAnchoreInlineScanAction = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_codebuild_1 = require("@aws-cdk/aws-codebuild");
const aws_codepipeline_1 = require("@aws-cdk/aws-codepipeline");
const aws_codepipeline_actions_1 = require("@aws-cdk/aws-codepipeline-actions");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
class CodePipelineAnchoreInlineScanAction extends aws_codepipeline_actions_1.Action {
    constructor(props) {
        super({
            ...props,
            category: aws_codepipeline_1.ActionCategory.TEST,
            provider: 'CodeBuild',
            artifactBounds: {
                minInputs: 1,
                maxInputs: 1,
                minOutputs: 0,
                maxOutputs: 0,
            },
            inputs: [props.input],
        });
        this.props = props;
    }
    /**
     * This is a renamed version of the {@link IAction.bind} method.
     */
    bound(scope, _stage, options) {
        var _b, _c, _d;
        const { account, region } = core_1.Stack.of(scope);
        const buildImage = aws_codebuild_1.LinuxBuildImage.STANDARD_4_0;
        const version = (_b = this.props.version) !== null && _b !== void 0 ? _b : 'v0.8.2';
        const timeout = (_c = this.props.timeout) !== null && _c !== void 0 ? _c : 300;
        const policyBundlePath = (_d = this.props.policyBundlePath) !== null && _d !== void 0 ? _d : './policy_bundle.json';
        const url = `https://ci-tools.anchore.io/inline_scan-${version}`;
        const project = new aws_codebuild_1.PipelineProject(scope, 'VulnScanProject', {
            cache: aws_codebuild_1.Cache.local(aws_codebuild_1.LocalCacheMode.DOCKER_LAYER),
            role: this.props.projectRole,
            environment: {
                buildImage,
                computeType: this.props.computeType || buildImage.defaultComputeType,
                privileged: true,
            },
            environmentVariables: this.props.customAnchoreImage
                ? {
                    ANCHORE_CI_IMAGE: {
                        value: this.props.customAnchoreImage,
                    },
                }
                : undefined,
            buildSpec: aws_codebuild_1.BuildSpec.fromObject({
                version: '0.2',
                phases: {
                    pre_build: {
                        commands: [
                            'echo Build started on `date`',
                            'docker build -t image2scan:ci .',
                            'echo Build completed on `date`',
                            this.props.ecrLogin &&
                                `aws ecr get-login-password | docker login --username AWS --password-stdin ${account}.dkr.ecr.${region}.amazonaws.com`,
                        ],
                    },
                    build: {
                        commands: [
                            'echo Scan started on `date`',
                            `curl -s ${url} | if [ -f "${policyBundlePath}" ]; then bash -s -- -f -t ${timeout} -b ${policyBundlePath} image2scan:ci; else bash -s -- -f -t ${timeout} image2scan:ci; fi`,
                            'echo Scan completed on `date`',
                        ],
                    },
                },
            }),
        });
        // grant the Pipeline role the required permissions to this Project
        options.role.addToPrincipalPolicy(new aws_iam_1.PolicyStatement({
            resources: [project.projectArn],
            actions: ['codebuild:BatchGetBuilds', 'codebuild:StartBuild', 'codebuild:StopBuild'],
        }));
        // allow the Project access to the Pipeline's artifact Bucket
        // but only if the project is not imported
        // (ie., has a role) - otherwise, the IAM library throws an error
        if (project.role) {
            options.bucket.grantRead(project);
        }
        return {
            configuration: {
                ProjectName: project.projectName,
            },
        };
    }
}
exports.CodePipelineAnchoreInlineScanAction = CodePipelineAnchoreInlineScanAction;
_a = JSII_RTTI_SYMBOL_1;
CodePipelineAnchoreInlineScanAction[_a] = { fqn: "@cloudcomponents/cdk-codepipeline-anchore-inline-scan-action.CodePipelineAnchoreInlineScanAction", version: "1.39.0" };
//# sourceMappingURL=data:application/json;base64,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