/*!
 * Convenient Formsets 1.2.1 (https://github.com/tiesjan/django-convenient-formsets/)
 * Copyright 2021-present Ties Jan Hefting
 * Licensed under BSD 3-Clause License
 */
'use strict';const ConvenientFormset=function(options){const availableOptions={formsetPrefix:{defaultValue:undefined,requiredIf:'always'},formsContainerSelector:{defaultValue:undefined,requiredIf:'always'},formSelector:{defaultValue:undefined,requiredIf:'always'},canAddForms:{defaultValue:true,requiredIf:'never'},addFormButtonSelector:{defaultValue:undefined,requiredIf:'canAddForms'},emptyFormSelector:{defaultValue:undefined,requiredIf:'canAddForms'},hideAddFormButtonOnMaxForms:{defaultValue:true,requiredIf:'never'},canDeleteForms:{defaultValue:false,requiredIf:'never'},deleteFormButtonSelector:{defaultValue:undefined,requiredIf:'canDeleteForms'},canOrderForms:{defaultValue:false,requiredIf:'never'},moveFormDownButtonSelector:{defaultValue:undefined,requiredIf:'canOrderForms'},moveFormUpButtonSelector:{defaultValue:undefined,requiredIf:'canOrderForms'}};const formsetOptions={};const formsetElements={};const managementFormElements={};function updateAddFormButtonVisibility(){const visibleForms=formsetElements.formsContainer.querySelectorAll(formsetOptions.formSelector+':not([hidden])');const maxNumForms=parseInt(managementFormElements.maxNumFormsInput.value,10);formsetElements.addFormButton.hidden=!(visibleForms.length<maxNumForms)}function updateFormIndexes(){const prefix=formsetOptions.formsetPrefix;const idRegex=new RegExp(prefix+'-(\\d+|__prefix__)');let forms=formsetElements.formsContainer.querySelectorAll(formsetOptions.formSelector);if(formsetOptions.canOrderForms){const compareForms=function(leftForm,rightForm){const selector='input[name$="ORDER"]';const leftFormOrderElement=leftForm.querySelector(selector);const rightFormOrderElement=rightForm.querySelector(selector);const leftFormId=parseInt(leftFormOrderElement.name.match(idRegex)[1],10);const rightFormId=parseInt(rightFormOrderElement.name.match(idRegex)[1],10);if(isNaN(rightFormId)||leftFormId<rightFormId){return-1}else if(isNaN(leftFormId)||leftFormId>rightFormId){return 1}};forms=Array.prototype.slice.call(forms).sort(compareForms)}for(let i=0;i<forms.length;i++){const form=forms[i];const idReplacement=prefix+'-'+i;const labelElements=form.querySelectorAll('label');for(let j=0;j<labelElements.length;j++){const labelElement=labelElements[j];if(labelElement.htmlFor){let attrValue=labelElement.htmlFor;attrValue=attrValue.replace(idRegex,idReplacement);labelElement.htmlFor=attrValue}}const inputElements=form.querySelectorAll('input, select, textarea');for(let j=0;j<inputElements.length;j++){const inputElement=inputElements[j];if(inputElement.id){let attrValue=inputElement.id;attrValue=attrValue.replace(idRegex,idReplacement);inputElement.id=attrValue}if(inputElement.name){let attrValue=inputElement.name;attrValue=attrValue.replace(idRegex,idReplacement);inputElement.name=attrValue}}}}function updateManagementForm(){const allForms=formsetElements.formsContainer.querySelectorAll(formsetOptions.formSelector);managementFormElements.totalFormsInput.value=allForms.length}function addFormButtonClicked(){const visibleForms=formsetElements.formsContainer.querySelectorAll(formsetOptions.formSelector+':not([hidden])');const maxNumForms=parseInt(managementFormElements.maxNumFormsInput.value,10);if(visibleForms.length>=maxNumForms){return}const newForm=formsetElements.emptyForm.cloneNode(true);if(formsetOptions.canDeleteForms){const deleteFormButton=newForm.querySelector(formsetOptions.deleteFormButtonSelector);deleteFormButton.addEventListener('click',deleteFormButtonClicked.bind(this,newForm))}if(formsetOptions.canOrderForms){const moveFormDownButton=newForm.querySelector(formsetOptions.moveFormDownButtonSelector);moveFormDownButton.addEventListener('click',moveFormDownButtonClicked.bind(this,newForm));const moveFormUpButton=newForm.querySelector(formsetOptions.moveFormUpButtonSelector);moveFormUpButton.addEventListener('click',moveFormUpButtonClicked.bind(this,newForm));const selector='input[name$="ORDER"]';let newFormOrderValue;if(visibleForms.length){const lastForm=visibleForms[visibleForms.length-1];const lastFormOrderValue=parseInt(lastForm.querySelector(selector).value,10);newFormOrderValue=lastFormOrderValue+1}else{newFormOrderValue=1}const newFormOrderElement=newForm.querySelector(selector);newFormOrderElement.value=newFormOrderValue}formsetElements.formsContainer.appendChild(newForm);if(formsetOptions.canAddForms&&formsetOptions.hideAddFormButtonOnMaxForms){updateAddFormButtonVisibility()}updateFormIndexes();updateManagementForm()}function deleteFormButtonClicked(form){const deleteElement=form.querySelector('input[name$="DELETE"]');if(deleteElement!==null){deleteElement.value='on';form.hidden=true}else{formsetElements.formsContainer.removeChild(form)}if(formsetOptions.canAddForms&&formsetOptions.hideAddFormButtonOnMaxForms){updateAddFormButtonVisibility()}updateFormIndexes();updateManagementForm()}function moveFormDownButtonClicked(form){let visibleForms=formsetElements.formsContainer.querySelectorAll(formsetOptions.formSelector+':not([hidden])');visibleForms=Array.prototype.slice.call(visibleForms);const formIndex=visibleForms.indexOf(form);if(formIndex<visibleForms.length-1){const nextForm=visibleForms[formIndex+1];formsetElements.formsContainer.insertBefore(nextForm,form);const selector='input[name$="ORDER"]';const formOrderElement=form.querySelector(selector);const nextFormOrderElement=nextForm.querySelector(selector);const formOrderValue=formOrderElement.value;const nextFormOrderValue=nextFormOrderElement.value;formOrderElement.value=nextFormOrderValue;nextFormOrderElement.value=formOrderValue}}function moveFormUpButtonClicked(form){let visibleForms=formsetElements.formsContainer.querySelectorAll(formsetOptions.formSelector+':not([hidden])');visibleForms=Array.prototype.slice.call(visibleForms);const formIndex=visibleForms.indexOf(form);if(formIndex>0){const previousForm=visibleForms[formIndex-1];formsetElements.formsContainer.insertBefore(form,previousForm);const selector='input[name$="ORDER"]';const formOrderElement=form.querySelector(selector);const previousFormOrderElement=previousForm.querySelector(selector);const formOrderValue=formOrderElement.value;const previousFormOrderValue=previousFormOrderElement.value;formOrderElement.value=previousFormOrderValue;previousFormOrderElement.value=formOrderValue}}function initializeFormsetOptions(customOptions){const missingOptions=[];for(let optionKey in availableOptions){let optionValue;if(Object.prototype.hasOwnProperty.call(customOptions,optionKey)){optionValue=customOptions[optionKey]}else{optionValue=availableOptions[optionKey].defaultValue}const requiredIf=availableOptions[optionKey].requiredIf;const optionRequired=requiredIf==='always'||requiredIf==='canAddForms'&&formsetOptions.canAddForms||requiredIf==='canDeleteForms'&&formsetOptions.canDeleteForms||requiredIf==='canOrderForms'&&formsetOptions.canOrderForms;if(optionRequired&&typeof optionValue==='undefined'){missingOptions.push(optionKey);continue}formsetOptions[optionKey]=optionValue}if(missingOptions.length){const formattedMissingOptions=missingOptions.map((function(item){return'`'+item+'`'})).join(', ');const message='Missing required options: '+formattedMissingOptions;throw new Error(message)}}function checkEmptyFormElements(){const missingElements=[];let element;let selector;if(formsetOptions.canDeleteForms){selector=formsetOptions.deleteFormButtonSelector;element=formsetElements.emptyForm.querySelector(selector);if(element===null){missingElements.push(selector)}}if(formsetOptions.canOrderForms){selector=formsetOptions.moveFormDownButtonSelector;element=formsetElements.emptyForm.querySelector(selector);if(element===null){missingElements.push(selector)}selector=formsetOptions.moveFormUpButtonSelector;element=formsetElements.emptyForm.querySelector(selector);if(element===null){missingElements.push(selector)}selector='input[name$="ORDER"]';element=formsetElements.emptyForm.querySelector(selector);if(element===null){missingElements.push(selector)}}if(missingElements.length){const formattedMissingElements=missingElements.map((function(item){return'`'+item+'`'})).join(', ');const message='Unable to find DOM elements in empty form with selectors: '+formattedMissingElements;throw new Error(message)}}function checkVisibleFormsElements(){const missingElements=[];let element;let selector;const forms=formsetElements.formsContainer.querySelectorAll(formsetOptions.formSelector+':not([hidden])');for(let i=0;i<forms.length;i++){const form=forms[i];if(formsetOptions.canDeleteForms){selector=formsetOptions.deleteFormButtonSelector;element=form.querySelector(selector);if(element===null&&missingElements.indexOf(selector)===-1){missingElements.push(selector)}}if(formsetOptions.canOrderForms){selector=formsetOptions.moveFormDownButtonSelector;element=form.querySelector(selector);if(element===null&&missingElements.indexOf(selector)===-1){missingElements.push(selector)}selector=formsetOptions.moveFormUpButtonSelector;element=form.querySelector(selector);if(element===null&&missingElements.indexOf(selector)===-1){missingElements.push(selector)}selector='input[name$="ORDER"]';element=form.querySelector(selector);if(element===null&&missingElements.indexOf(selector)===-1){missingElements.push(selector)}}}if(missingElements.length){const formattedMissingElements=missingElements.map((function(item){return'`'+item+'`'})).join(', ');const message='Unable to find DOM elements in one or more visible forms '+'with selectors: '+formattedMissingElements;throw new Error(message)}}function selectFormsetElements(){const missingElements=[];let selector;selector=formsetOptions.formsContainerSelector;formsetElements.formsContainer=document.querySelector(selector);if(formsetElements.formsContainer===null){missingElements.push(selector)}if(formsetOptions.canAddForms){selector=formsetOptions.emptyFormSelector;formsetElements.emptyForm=document.querySelector(selector);if(formsetElements.emptyForm===null){missingElements.push(selector)}selector=formsetOptions.addFormButtonSelector;formsetElements.addFormButton=document.querySelector(selector);if(formsetElements.addFormButton===null){missingElements.push(selector)}}if(missingElements.length){const formattedMissingElements=missingElements.map((function(item){return'`'+item+'`'})).join(', ');const message='Unable to find DOM elements with selectors: '+formattedMissingElements;throw new Error(message)}}function selectManagementFormElements(){let configurationError=false;let selector;selector='input[name="'+formsetOptions.formsetPrefix+'-TOTAL_FORMS"]';managementFormElements.totalFormsInput=document.querySelector(selector);if(managementFormElements.totalFormsInput===null){configurationError=true}selector='input[name="'+formsetOptions.formsetPrefix+'-INITIAL_FORMS"]';managementFormElements.initialFormsInput=document.querySelector(selector);if(managementFormElements.initialFormsInput===null){configurationError=true}selector='input[name="'+formsetOptions.formsetPrefix+'-MIN_NUM_FORMS"]';managementFormElements.minNumFormsInput=document.querySelector(selector);if(managementFormElements.minNumFormsInput===null){configurationError=true}selector='input[name="'+formsetOptions.formsetPrefix+'-MAX_NUM_FORMS"]';managementFormElements.maxNumFormsInput=document.querySelector(selector);if(managementFormElements.maxNumFormsInput===null){configurationError=true}if(configurationError){const message='Management form for formset with prefix `'+formsetOptions.formsetPrefix+'` missing or has been tampered with.';throw new Error(message)}}function hideFormsMarkedForDeletion(){const forms=formsetElements.formsContainer.querySelectorAll(formsetOptions.formSelector);for(let i=0;i<forms.length;i++){const form=forms[i];const deleteElement=form.querySelector('input[name$="DELETE"]');if(deleteElement!==null&&deleteElement.value==='on'){form.hidden=true}}}function initializeEventListeners(){if(formsetOptions.canAddForms){formsetElements.addFormButton.addEventListener('click',addFormButtonClicked)}const forms=formsetElements.formsContainer.querySelectorAll(formsetOptions.formSelector+':not([hidden])');for(let i=0;i<forms.length;i++){const form=forms[i];if(formsetOptions.canDeleteForms){const deleteFormButton=form.querySelector(formsetOptions.deleteFormButtonSelector);deleteFormButton.addEventListener('click',deleteFormButtonClicked.bind(this,form))}if(formsetOptions.canOrderForms){const moveFormDownButton=form.querySelector(formsetOptions.moveFormDownButtonSelector);moveFormDownButton.addEventListener('click',moveFormDownButtonClicked.bind(this,form));const moveFormUpButton=form.querySelector(formsetOptions.moveFormUpButtonSelector);moveFormUpButton.addEventListener('click',moveFormUpButtonClicked.bind(this,form))}}}(function(customOptions){try{initializeFormsetOptions(customOptions)}catch(error){throw Error('[ConvenientFormset] '+error.message)}try{selectFormsetElements()}catch(error){throw Error('[ConvenientFormset] '+error.message)}try{selectManagementFormElements()}catch(error){throw Error('[ConvenientFormset] '+error.message)}if(formsetOptions.canAddForms){try{checkEmptyFormElements()}catch(error){throw Error('[ConvenientFormset] '+error.message)}}try{checkVisibleFormsElements()}catch(error){throw Error('[ConvenientFormset] '+error.message)}if(formsetOptions.canDeleteForms){hideFormsMarkedForDeletion()}if(formsetOptions.canAddForms&&formsetOptions.hideAddFormButtonOnMaxForms){updateAddFormButtonVisibility()}initializeEventListeners()})(options||{})};