# AUTOGENERATED! DO NOT EDIT! File to edit: s3.ipynb (unless otherwise specified).

__all__ = ['DatabaseS3']

# Cell
import os, logging
from s3bz.s3bz import S3

# Cell
try:
  INVENTORY_BUCKET_NAME = os.environ['INVENTORY_BUCKET_NAME']
except Exception as e:
  print(f'missing environment variable {e} in Database s3 NB')
  INVENTORY_BUCKET_NAME = None

# Cell
class DatabaseS3:
  @classmethod
  def loadFromS3(cls, bucketName= INVENTORY_BUCKET_NAME, key = 'allData', **kwargs):
    logging.info(f'loading from {bucketName}')
    logging.info(f'user is {kwargs.get("user")}')
    return S3.load(key=key, bucket = bucketName,  **kwargs)

  @classmethod
  def dumpToS3(cls, bucketName= INVENTORY_BUCKET_NAME, key = 'allData', limit= 1000, rebase = False, **kwargs):
    ''' upload changes to s3'''
    if rebase:
      changeList = list(cls.needUpdateIndex.scan())
    else:
      changeList = list(cls.needUpdateIndex.query(cls.TRUE, limit=limit))
    # check for changes otherwise, skip
    if not changeList: return f'no changes to database'

    # get original data
    allData = cls.loadFromS3(bucketName = bucketName, key = key, **kwargs)
    logging.debug(f'all data is {len(allData)}')
    logging.debug(f'{len(changeList)} changes to update')
    with cls.batch_write() as batch:
      changes = {
                  item.ib_prcode:(
                    item.inventory,
                    item.setNoUpdate(batch=batch)
                  )[0]
                  for item in changeList
                }
    logging.debug(f'change filtration has completed')
    logging.debug(f'all data is {len(allData)}\n changes are {len(changes)}')
    if changes:
      logging.debug(f'updating')
      allData.update(changes)
      logging.debug(S3.save(key = 'allData',
                  objectToSave = allData,
                  bucket = bucketName, **kwargs)
      )
    else:
      logging.debug('no changes to update')

    numberOfChanges = len(list(changes.items()))
    if numberOfChanges == limit: logging.warning('more changes to load')
    return f"saved {len(list(allData.keys()))} products,\
            updated {numberOfChanges}"
