"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnRule = exports.toJson_WebhookConfig = exports.WebhookTrigger = exports.EmailTrigger = exports.toJson_PagerDutyConfig = exports.PagerDutyTrigger = exports.SlackTrigger = exports.toJson_WebhookRule = exports.toJson_EmailRule = exports.toJson_PagerDutyRule = exports.toJson_SlackRule = exports.toJson_CfnRuleProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnRuleProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnRuleProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'ProjectAccessToken': obj.projectAccessToken,
        'Slack': toJson_SlackRule(obj.slack),
        'PagerDuty': toJson_PagerDutyRule(obj.pagerDuty),
        'Email': toJson_EmailRule(obj.email),
        'Webhook': toJson_WebhookRule(obj.webhook),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnRuleProps = toJson_CfnRuleProps;
/**
 * Converts an object of type 'SlackRule' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_SlackRule(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Trigger': obj.trigger,
        'Filters': obj.filters?.map(y => y),
        'Action': obj.action,
        'Config': obj.config,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_SlackRule = toJson_SlackRule;
/**
 * Converts an object of type 'PagerDutyRule' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_PagerDutyRule(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Trigger': obj.trigger,
        'Filters': obj.filters?.map(y => y),
        'Action': obj.action,
        'Config': toJson_PagerDutyConfig(obj.config),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_PagerDutyRule = toJson_PagerDutyRule;
/**
 * Converts an object of type 'EmailRule' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_EmailRule(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Trigger': obj.trigger,
        'Filters': obj.filters?.map(y => y),
        'Action': obj.action,
        'Config': obj.config,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_EmailRule = toJson_EmailRule;
/**
 * Converts an object of type 'WebhookRule' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_WebhookRule(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Trigger': obj.trigger,
        'Filters': obj.filters?.map(y => y),
        'Action': obj.action,
        'Config': toJson_WebhookConfig(obj.config),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_WebhookRule = toJson_WebhookRule;
/* eslint-enable max-len, quote-props */
/**
 * An error/ message is seen for the first time.
 *
 * @schema SlackTrigger
 */
var SlackTrigger;
(function (SlackTrigger) {
    /** new_item */
    SlackTrigger["NEW_ITEM"] = "new_item";
    /** occurrence */
    SlackTrigger["OCCURRENCE"] = "occurrence";
    /** deploy */
    SlackTrigger["DEPLOY"] = "deploy";
    /** reactivated_item */
    SlackTrigger["REACTIVATED_ITEM"] = "reactivated_item";
    /** resolved_item */
    SlackTrigger["RESOLVED_ITEM"] = "resolved_item";
    /** new_version */
    SlackTrigger["NEW_VERSION"] = "new_version";
    /** reopened_item */
    SlackTrigger["REOPENED_ITEM"] = "reopened_item";
    /** occurrence_rate */
    SlackTrigger["OCCURRENCE_RATE"] = "occurrence_rate";
    /** exp_repeat_item */
    SlackTrigger["EXP_REPEAT_ITEM"] = "exp_repeat_item";
})(SlackTrigger = exports.SlackTrigger || (exports.SlackTrigger = {}));
/**
 * An error/ message is seen for the first time.
 *
 * @schema PagerDutyTrigger
 */
var PagerDutyTrigger;
(function (PagerDutyTrigger) {
    /** new_item */
    PagerDutyTrigger["NEW_ITEM"] = "new_item";
    /** reactivated_item */
    PagerDutyTrigger["REACTIVATED_ITEM"] = "reactivated_item";
    /** resolved_item */
    PagerDutyTrigger["RESOLVED_ITEM"] = "resolved_item";
    /** occurrence_rate */
    PagerDutyTrigger["OCCURRENCE_RATE"] = "occurrence_rate";
    /** exp_repeat_item */
    PagerDutyTrigger["EXP_REPEAT_ITEM"] = "exp_repeat_item";
})(PagerDutyTrigger = exports.PagerDutyTrigger || (exports.PagerDutyTrigger = {}));
/**
 * Converts an object of type 'PagerDutyConfig' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_PagerDutyConfig(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'ServiceKey': obj.serviceKey,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_PagerDutyConfig = toJson_PagerDutyConfig;
/* eslint-enable max-len, quote-props */
/**
 * An error/ message is seen for the first time.
 *
 * @schema EmailTrigger
 */
var EmailTrigger;
(function (EmailTrigger) {
    /** new_item */
    EmailTrigger["NEW_ITEM"] = "new_item";
    /** occurrence */
    EmailTrigger["OCCURRENCE"] = "occurrence";
    /** deploy */
    EmailTrigger["DEPLOY"] = "deploy";
    /** reactivated_item */
    EmailTrigger["REACTIVATED_ITEM"] = "reactivated_item";
    /** resolved_item */
    EmailTrigger["RESOLVED_ITEM"] = "resolved_item";
    /** new_version */
    EmailTrigger["NEW_VERSION"] = "new_version";
    /** reopened_item */
    EmailTrigger["REOPENED_ITEM"] = "reopened_item";
    /** occurrence_rate */
    EmailTrigger["OCCURRENCE_RATE"] = "occurrence_rate";
    /** exp_repeat_item */
    EmailTrigger["EXP_REPEAT_ITEM"] = "exp_repeat_item";
    /** daily_summary */
    EmailTrigger["DAILY_SUMMARY"] = "daily_summary";
})(EmailTrigger = exports.EmailTrigger || (exports.EmailTrigger = {}));
/**
 * An error/ message is seen for the first time.
 *
 * @schema WebhookTrigger
 */
var WebhookTrigger;
(function (WebhookTrigger) {
    /** new_item */
    WebhookTrigger["NEW_ITEM"] = "new_item";
    /** occurrence */
    WebhookTrigger["OCCURRENCE"] = "occurrence";
    /** deploy */
    WebhookTrigger["DEPLOY"] = "deploy";
    /** reactivated_item */
    WebhookTrigger["REACTIVATED_ITEM"] = "reactivated_item";
    /** resolved_item */
    WebhookTrigger["RESOLVED_ITEM"] = "resolved_item";
    /** exp_repeat_item */
    WebhookTrigger["EXP_REPEAT_ITEM"] = "exp_repeat_item";
    /** reopened_item */
    WebhookTrigger["REOPENED_ITEM"] = "reopened_item";
    /** occurrence_rate */
    WebhookTrigger["OCCURRENCE_RATE"] = "occurrence_rate";
})(WebhookTrigger = exports.WebhookTrigger || (exports.WebhookTrigger = {}));
/**
 * Converts an object of type 'WebhookConfig' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_WebhookConfig(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Url': obj.url,
        'Format': obj.format,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_WebhookConfig = toJson_WebhookConfig;
/* eslint-enable max-len, quote-props */
/**
 * A CloudFormation `Rollbar::Notifications::Rule`
 *
 * @cloudformationResource Rollbar::Notifications::Rule
 * @stability external
 * @link https://github.com/aws-ia/cloudformation-rollbar-resource-providers.git
 */
class CfnRule extends cdk.CfnResource {
    /**
     * Create a new `Rollbar::Notifications::Rule`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnRule.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnRuleProps(props) });
        this.props = props;
        this.attrId = cdk.Token.asNumber(this.getAtt('Id'));
        this.attrTrigger = cdk.Token.asString(this.getAtt('Trigger'));
        this.attrAction = cdk.Token.asString(this.getAtt('Action'));
        this.attrRuleType = cdk.Token.asString(this.getAtt('RuleType'));
    }
}
exports.CfnRule = CfnRule;
_a = JSII_RTTI_SYMBOL_1;
CfnRule[_a] = { fqn: "@cdk-cloudformation/rollbar-notifications-rule.CfnRule", version: "1.0.0-alpha.6" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnRule.CFN_RESOURCE_TYPE_NAME = "Rollbar::Notifications::Rule";
//# sourceMappingURL=data:application/json;base64,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