/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.decoder;

import brut.androlib.AndrolibException;
import brut.androlib.res.data.ResConfigFlags;
import brut.androlib.res.data.ResID;
import brut.androlib.res.data.ResPackage;
import brut.androlib.res.data.ResResSpec;
import brut.androlib.res.data.ResResource;
import brut.androlib.res.data.ResTable;
import brut.androlib.res.data.ResType;
import brut.androlib.res.data.ResTypeSpec;
import brut.androlib.res.data.value.ResBagValue;
import brut.androlib.res.data.value.ResFileValue;
import brut.androlib.res.data.value.ResIntBasedValue;
import brut.androlib.res.data.value.ResReferenceValue;
import brut.androlib.res.data.value.ResScalarValue;
import brut.androlib.res.data.value.ResStringValue;
import brut.androlib.res.data.value.ResValue;
import brut.androlib.res.data.value.ResValueFactory;
import brut.androlib.res.decoder.StringBlock;
import brut.util.Duo;
import brut.util.ExtDataInput;
import com.google.common.io.LittleEndianDataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.io.input.CountingInputStream;

public class ARSCDecoder {
    private final ExtDataInput mIn;
    private final ResTable mResTable;
    private final CountingInputStream mCountIn;
    private final List<FlagsOffset> mFlagsOffsets;
    private final boolean mKeepBroken;
    private Header mHeader;
    private StringBlock mTableStrings;
    private StringBlock mTypeNames;
    private StringBlock mSpecNames;
    private ResPackage mPkg;
    private ResTypeSpec mTypeSpec;
    private ResType mType;
    private int mResId;
    private int mTypeIdOffset = 0;
    private boolean[] mMissingResSpecs;
    private final HashMap<Integer, ResTypeSpec> mResTypeSpecs = new HashMap();
    private static final Logger LOGGER = Logger.getLogger(ARSCDecoder.class.getName());

    public static ARSCData decode(InputStream arscStream, boolean findFlagsOffsets, boolean keepBroken) throws AndrolibException {
        return ARSCDecoder.decode(arscStream, findFlagsOffsets, keepBroken, new ResTable());
    }

    public static ARSCData decode(InputStream arscStream, boolean findFlagsOffsets, boolean keepBroken, ResTable resTable) throws AndrolibException {
        try {
            ARSCDecoder decoder = new ARSCDecoder(arscStream, resTable, findFlagsOffsets, keepBroken);
            ResPackage[] pkgs = decoder.readTableHeader();
            return new ARSCData(pkgs, decoder.mFlagsOffsets == null ? null : decoder.mFlagsOffsets.toArray(new FlagsOffset[0]), resTable);
        }
        catch (IOException ex) {
            throw new AndrolibException("Could not decode arsc file", ex);
        }
    }

    private ARSCDecoder(InputStream arscStream, ResTable resTable, boolean storeFlagsOffsets, boolean keepBroken) {
        this.mCountIn = new CountingInputStream(arscStream);
        arscStream = this.mCountIn;
        this.mFlagsOffsets = storeFlagsOffsets ? new ArrayList<FlagsOffset>() : null;
        this.mIn = new ExtDataInput(new LittleEndianDataInputStream(arscStream));
        this.mResTable = resTable;
        this.mKeepBroken = keepBroken;
    }

    private ResPackage[] readTableHeader() throws IOException, AndrolibException {
        this.nextChunkCheckType(2);
        int packageCount = this.mIn.readInt();
        this.mTableStrings = StringBlock.read(this.mIn);
        ResPackage[] packages = new ResPackage[packageCount];
        this.nextChunk();
        for (int i = 0; i < packageCount; ++i) {
            this.mTypeIdOffset = 0;
            packages[i] = this.readTablePackage();
        }
        return packages;
    }

    private ResPackage readTablePackage() throws IOException, AndrolibException {
        this.checkChunkType(512);
        int id = this.mIn.readInt();
        if (id == 0) {
            id = 2;
            if (this.mResTable.getPackageOriginal() == null && this.mResTable.getPackageRenamed() == null) {
                this.mResTable.setSharedLibrary(true);
            }
        }
        String name = this.mIn.readNullEndedString(128, true);
        this.mIn.skipInt();
        this.mIn.skipInt();
        this.mIn.skipInt();
        this.mIn.skipInt();
        int splitHeaderSize = 288;
        if (this.mHeader.headerSize == splitHeaderSize) {
            this.mTypeIdOffset = this.mIn.readInt();
        }
        if (this.mTypeIdOffset > 0) {
            LOGGER.warning("Please report this application to Apktool for a fix: https://github.com/iBotPeaches/Apktool/issues/1728");
        }
        this.mTypeNames = StringBlock.read(this.mIn);
        this.mSpecNames = StringBlock.read(this.mIn);
        this.mResId = id << 24;
        this.mPkg = new ResPackage(this.mResTable, id, name);
        this.nextChunk();
        boolean flag = true;
        block6: while (flag) {
            switch (this.mHeader.type) {
                case 514: {
                    this.readTableTypeSpec();
                    continue block6;
                }
                case 515: {
                    this.readLibraryType();
                    continue block6;
                }
                case 516: {
                    this.readOverlaySpec();
                    continue block6;
                }
                case 518: {
                    this.readStagedAliasSpec();
                    continue block6;
                }
            }
            flag = false;
        }
        return this.mPkg;
    }

    private void readLibraryType() throws AndrolibException, IOException {
        this.checkChunkType(515);
        int libraryCount = this.mIn.readInt();
        for (int i = 0; i < libraryCount; ++i) {
            int packageId = this.mIn.readInt();
            String packageName = this.mIn.readNullEndedString(128, true);
            LOGGER.info(String.format("Decoding Shared Library (%s), pkgId: %d", packageName, packageId));
        }
        while (this.nextChunk().type == 513) {
            this.readTableTypeSpec();
        }
    }

    private void readStagedAliasSpec() throws IOException {
        int count = this.mIn.readInt();
        for (int i = 0; i < count; ++i) {
            LOGGER.info(String.format("Skipping staged alias stagedId (%h) finalId: %h", this.mIn.readInt(), this.mIn.readInt()));
        }
        this.nextChunk();
    }

    private void readOverlaySpec() throws IOException {
        this.mIn.skipInt();
        int count = this.mIn.readInt();
        for (int i = 0; i < count; ++i) {
            LOGGER.info(String.format("Skipping overlay (%h)", this.mIn.readInt()));
        }
        this.nextChunk();
    }

    private void readTableTypeSpec() throws AndrolibException, IOException {
        this.mTypeSpec = this.readSingleTableTypeSpec();
        this.addTypeSpec(this.mTypeSpec);
        short type = this.nextChunk().type;
        while (type == 514) {
            ResTypeSpec resTypeSpec = this.readSingleTableTypeSpec();
            this.addTypeSpec(resTypeSpec);
            type = this.nextChunk().type;
            if (this.mResTable.getSparseResources()) continue;
            this.mResTable.setSparseResources(true);
        }
        while (type == 513) {
            this.readTableType();
            if (this.mCountIn.getCount() < this.mHeader.endPosition) {
                LOGGER.warning("Unknown data detected. Skipping: " + (this.mHeader.endPosition - this.mCountIn.getCount()) + " byte(s)");
                this.mCountIn.skip(this.mHeader.endPosition - this.mCountIn.getCount());
            }
            type = this.nextChunk().type;
            this.addMissingResSpecs();
        }
    }

    private ResTypeSpec readSingleTableTypeSpec() throws AndrolibException, IOException {
        this.checkChunkType(514);
        int id = this.mIn.readUnsignedByte();
        this.mIn.skipBytes(3);
        int entryCount = this.mIn.readInt();
        if (this.mFlagsOffsets != null) {
            this.mFlagsOffsets.add(new FlagsOffset(this.mCountIn.getCount(), entryCount));
        }
        this.mIn.skipBytes(entryCount * 4);
        this.mTypeSpec = new ResTypeSpec(this.mTypeNames.getString(id - 1), this.mResTable, this.mPkg, id, entryCount);
        this.mPkg.addType(this.mTypeSpec);
        return this.mTypeSpec;
    }

    private ResType readTableType() throws IOException, AndrolibException {
        this.checkChunkType(513);
        int typeId = this.mIn.readUnsignedByte() - this.mTypeIdOffset;
        if (this.mResTypeSpecs.containsKey(typeId)) {
            this.mResId = 0xFF000000 & this.mResId | this.mResTypeSpecs.get(typeId).getId() << 16;
            this.mTypeSpec = this.mResTypeSpecs.get(typeId);
        }
        byte typeFlags = this.mIn.readByte();
        this.mIn.skipBytes(2);
        int entryCount = this.mIn.readInt();
        int entriesStart = this.mIn.readInt();
        this.mMissingResSpecs = new boolean[entryCount];
        Arrays.fill(this.mMissingResSpecs, true);
        ResConfigFlags flags = this.readConfigFlags();
        int position = this.mHeader.startPosition + entriesStart - entryCount * 4;
        if (position != this.mCountIn.getCount()) {
            LOGGER.warning("Invalid data detected. Skipping: " + (position - this.mCountIn.getCount()) + " byte(s)");
            this.mIn.skipBytes(position - this.mCountIn.getCount());
        }
        if (typeFlags == 1) {
            LOGGER.info("Sparse type flags detected: " + this.mTypeSpec.getName());
        }
        int[] entryOffsets = this.mIn.readIntArray(entryCount);
        if (flags.isInvalid) {
            String resName = this.mTypeSpec.getName() + flags.getQualifiers();
            if (this.mKeepBroken) {
                LOGGER.warning("Invalid config flags detected: " + resName);
            } else {
                LOGGER.warning("Invalid config flags detected. Dropping resources: " + resName);
            }
        }
        this.mType = flags.isInvalid && !this.mKeepBroken ? null : this.mPkg.getOrCreateConfig(flags);
        HashMap<Integer, EntryData> offsetsToEntryData = new HashMap<Integer, EntryData>();
        for (int offset : entryOffsets) {
            if (offset == -1 || offsetsToEntryData.containsKey(offset)) continue;
            offsetsToEntryData.put(offset, this.readEntryData());
        }
        for (int i = 0; i < entryOffsets.length; ++i) {
            if (entryOffsets[i] == -1) continue;
            this.mMissingResSpecs[i] = false;
            this.mResId = this.mResId & 0xFFFF0000 | i;
            EntryData entryData = (EntryData)offsetsToEntryData.get(entryOffsets[i]);
            this.readEntry(entryData);
        }
        return this.mType;
    }

    private EntryData readEntryData() throws IOException, AndrolibException {
        short size = this.mIn.readShort();
        if (size < 0) {
            throw new AndrolibException("Entry size is under 0 bytes.");
        }
        short flags = this.mIn.readShort();
        int specNamesId = this.mIn.readInt();
        ResValue value = (flags & 1) == 0 ? this.readValue() : this.readComplexEntry();
        EntryData entryData = new EntryData();
        entryData.mFlags = flags;
        entryData.mSpecNamesId = specNamesId;
        entryData.mValue = value;
        return entryData;
    }

    private void readEntry(EntryData entryData) throws AndrolibException {
        ResResSpec spec;
        int specNamesId = entryData.mSpecNamesId;
        ResValue value = entryData.mValue;
        if (this.mTypeSpec.isString() && value instanceof ResFileValue) {
            value = new ResStringValue(value.toString(), ((ResFileValue)value).getRawIntValue());
        }
        if (this.mType == null) {
            return;
        }
        ResID resId = new ResID(this.mResId);
        if (this.mPkg.hasResSpec(resId)) {
            spec = this.mPkg.getResSpec(resId);
            if (spec.isDummyResSpec()) {
                this.removeResSpec(spec);
                spec = new ResResSpec(resId, this.mSpecNames.getString(specNamesId), this.mPkg, this.mTypeSpec);
                this.mPkg.addResSpec(spec);
                this.mTypeSpec.addResSpec(spec);
            }
        } else {
            spec = new ResResSpec(resId, this.mSpecNames.getString(specNamesId), this.mPkg, this.mTypeSpec);
            this.mPkg.addResSpec(spec);
            this.mTypeSpec.addResSpec(spec);
        }
        ResResource res = new ResResource(this.mType, spec, value);
        try {
            this.mType.addResource(res);
            spec.addResource(res);
        }
        catch (AndrolibException ex) {
            if (this.mKeepBroken) {
                this.mType.addResource(res, true);
                spec.addResource(res, true);
                LOGGER.warning(String.format("Duplicate Resource Detected. Ignoring duplicate: %s", res));
            }
            throw ex;
        }
    }

    private ResBagValue readComplexEntry() throws IOException, AndrolibException {
        int parent = this.mIn.readInt();
        int count = this.mIn.readInt();
        ResValueFactory factory = this.mPkg.getValueFactory();
        Duo[] items = new Duo[count];
        for (int i = 0; i < count; ++i) {
            int resId = this.mIn.readInt();
            ResIntBasedValue resValue = this.readValue();
            if (!(resValue instanceof ResScalarValue)) {
                resValue = new ResStringValue(resValue.toString(), resValue.getRawIntValue());
            }
            items[i] = new Duo<Integer, ResScalarValue>(resId, (ResScalarValue)resValue);
        }
        return factory.bagFactory(parent, items, this.mTypeSpec);
    }

    private ResIntBasedValue readValue() throws IOException, AndrolibException {
        this.mIn.skipCheckShort((short)8);
        this.mIn.skipCheckByte((byte)0);
        byte type = this.mIn.readByte();
        int data = this.mIn.readInt();
        return type == 3 ? this.mPkg.getValueFactory().factory(this.mTableStrings.getHTML(data), data) : this.mPkg.getValueFactory().factory(type, data, null);
    }

    private ResConfigFlags readConfigFlags() throws IOException, AndrolibException {
        int remainingSize;
        int exceedingSize;
        int size = this.mIn.readInt();
        int read = 28;
        if (size < 28) {
            throw new AndrolibException("Config size < 28");
        }
        boolean isInvalid = false;
        short mcc = this.mIn.readShort();
        short mnc = this.mIn.readShort();
        char[] language = this.unpackLanguageOrRegion(this.mIn.readByte(), this.mIn.readByte(), 'a');
        char[] country = this.unpackLanguageOrRegion(this.mIn.readByte(), this.mIn.readByte(), '0');
        byte orientation = this.mIn.readByte();
        byte touchscreen = this.mIn.readByte();
        int density = this.mIn.readUnsignedShort();
        byte keyboard = this.mIn.readByte();
        byte navigation = this.mIn.readByte();
        byte inputFlags = this.mIn.readByte();
        this.mIn.skipBytes(1);
        short screenWidth = this.mIn.readShort();
        short screenHeight = this.mIn.readShort();
        short sdkVersion = this.mIn.readShort();
        this.mIn.skipBytes(2);
        byte screenLayout = 0;
        byte uiMode = 0;
        short smallestScreenWidthDp = 0;
        if (size >= 32) {
            screenLayout = this.mIn.readByte();
            uiMode = this.mIn.readByte();
            smallestScreenWidthDp = this.mIn.readShort();
            read = 32;
        }
        short screenWidthDp = 0;
        short screenHeightDp = 0;
        if (size >= 36) {
            screenWidthDp = this.mIn.readShort();
            screenHeightDp = this.mIn.readShort();
            read = 36;
        }
        char[] localeScript = null;
        char[] localeVariant = null;
        if (size >= 48) {
            localeScript = this.readScriptOrVariantChar(4).toCharArray();
            localeVariant = this.readScriptOrVariantChar(8).toCharArray();
            read = 48;
        }
        byte screenLayout2 = 0;
        byte colorMode = 0;
        if (size >= 52) {
            screenLayout2 = this.mIn.readByte();
            colorMode = this.mIn.readByte();
            this.mIn.skipBytes(2);
            read = 52;
        }
        if (size >= 56) {
            this.mIn.skipBytes(4);
            read = 56;
        }
        if ((exceedingSize = size - 56) > 0) {
            byte[] buf = new byte[exceedingSize];
            read += exceedingSize;
            this.mIn.readFully(buf);
            BigInteger exceedingBI = new BigInteger(1, buf);
            if (exceedingBI.equals(BigInteger.ZERO)) {
                LOGGER.fine(String.format("Config flags size > %d, but exceeding bytes are all zero, so it should be ok.", 56));
            } else {
                LOGGER.warning(String.format("Config flags size > %d. Size = %d. Exceeding bytes: 0x%X.", 56, size, exceedingBI));
                isInvalid = true;
            }
        }
        if ((remainingSize = size - read) > 0) {
            this.mIn.skipBytes(remainingSize);
        }
        return new ResConfigFlags(mcc, mnc, language, country, orientation, touchscreen, density, keyboard, navigation, inputFlags, screenWidth, screenHeight, sdkVersion, screenLayout, uiMode, smallestScreenWidthDp, screenWidthDp, screenHeightDp, localeScript, localeVariant, screenLayout2, colorMode, isInvalid, size);
    }

    private char[] unpackLanguageOrRegion(byte in0, byte in1, char base) {
        if ((in0 >> 7 & 1) == 1) {
            int first = in1 & 0x1F;
            int second = ((in1 & 0xE0) >> 5) + ((in0 & 3) << 3);
            int third = (in0 & 0x7C) >> 2;
            return new char[]{(char)(first + base), (char)(second + base), (char)(third + base)};
        }
        return new char[]{(char)in0, (char)in1};
    }

    private String readScriptOrVariantChar(int length) throws IOException {
        short ch;
        StringBuilder string = new StringBuilder(16);
        while (length-- != 0 && (ch = (short)this.mIn.readByte()) != 0) {
            string.append((char)ch);
        }
        this.mIn.skipBytes(length);
        return string.toString();
    }

    private void addTypeSpec(ResTypeSpec resTypeSpec) {
        this.mResTypeSpecs.put(resTypeSpec.getId(), resTypeSpec);
    }

    private void addMissingResSpecs() throws AndrolibException {
        int resId = this.mResId & 0xFFFF0000;
        for (int i = 0; i < this.mMissingResSpecs.length; ++i) {
            if (!this.mMissingResSpecs[i]) continue;
            ResResSpec spec = new ResResSpec(new ResID(resId | i), "APKTOOL_DUMMY_" + Integer.toHexString(i), this.mPkg, this.mTypeSpec);
            if (this.mPkg.hasResSpec(new ResID(resId | i))) continue;
            this.mPkg.addResSpec(spec);
            this.mTypeSpec.addResSpec(spec);
            if (this.mType == null) {
                this.mType = this.mPkg.getOrCreateConfig(new ResConfigFlags());
            }
            ResReferenceValue value = new ResReferenceValue(this.mPkg, 0, "");
            ResResource res = new ResResource(this.mType, spec, value);
            this.mType.addResource(res);
            spec.addResource(res);
        }
    }

    private void removeResSpec(ResResSpec spec) throws AndrolibException {
        if (this.mPkg.hasResSpec(spec.getId())) {
            this.mPkg.removeResSpec(spec);
            this.mTypeSpec.removeResSpec(spec);
        }
    }

    private Header nextChunk() throws IOException {
        this.mHeader = Header.read(this.mIn, this.mCountIn);
        return this.mHeader;
    }

    private void checkChunkType(int expectedType) throws AndrolibException {
        if (this.mHeader.type != expectedType) {
            throw new AndrolibException(String.format("Invalid chunk type: expected=0x%08x, got=0x%08x", expectedType, this.mHeader.type));
        }
    }

    private void nextChunkCheckType(int expectedType) throws IOException, AndrolibException {
        this.nextChunk();
        this.checkChunkType(expectedType);
    }

    public static class ARSCData {
        private final ResPackage[] mPackages;
        private final FlagsOffset[] mFlagsOffsets;
        private final ResTable mResTable;

        public ARSCData(ResPackage[] packages, FlagsOffset[] flagsOffsets, ResTable resTable) {
            this.mPackages = packages;
            this.mFlagsOffsets = flagsOffsets;
            this.mResTable = resTable;
        }

        public FlagsOffset[] getFlagsOffsets() {
            return this.mFlagsOffsets;
        }

        public ResPackage[] getPackages() {
            return this.mPackages;
        }

        public ResPackage getOnePackage() throws AndrolibException {
            if (this.mPackages.length <= 0) {
                throw new AndrolibException("Arsc file contains zero packages");
            }
            if (this.mPackages.length != 1) {
                int id = this.findPackageWithMostResSpecs();
                LOGGER.info("Arsc file contains multiple packages. Using package " + this.mPackages[id].getName() + " as default.");
                return this.mPackages[id];
            }
            return this.mPackages[0];
        }

        public int findPackageWithMostResSpecs() {
            int count = this.mPackages[0].getResSpecCount();
            int id = 0;
            for (int i = 0; i < this.mPackages.length; ++i) {
                if (this.mPackages[i].getResSpecCount() < count) continue;
                count = this.mPackages[i].getResSpecCount();
                id = i;
            }
            return id;
        }
    }

    private class EntryData {
        public short mFlags;
        public int mSpecNamesId;
        public ResValue mValue;

        private EntryData() {
        }
    }

    public static class FlagsOffset {
        public final int offset;
        public final int count;

        public FlagsOffset(int offset, int count) {
            this.offset = offset;
            this.count = count;
        }
    }

    public static class Header {
        public final short type;
        public final int headerSize;
        public final int chunkSize;
        public final int startPosition;
        public final int endPosition;

        public Header(short type, int headerSize, int chunkSize, int headerStart) {
            this.type = type;
            this.headerSize = headerSize;
            this.chunkSize = chunkSize;
            this.startPosition = headerStart;
            this.endPosition = headerStart + chunkSize;
        }

        public static Header read(ExtDataInput in, CountingInputStream countIn) throws IOException {
            short type;
            int start = countIn.getCount();
            try {
                type = in.readShort();
            }
            catch (EOFException ex) {
                return new Header(-1, 0, 0, countIn.getCount());
            }
            return new Header(type, in.readShort(), in.readInt(), start);
        }
    }
}

