# pulp_gem-client
Fetch, Upload, Organize, and Distribute Software Packages

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: v3
- Package version: 0.5.1
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://pulpproject.org](https://pulpproject.org)

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import pulpcore.client.pulp_gem
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import pulpcore.client.pulp_gem
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function

import time
import pulpcore.client.pulp_gem
from pulpcore.client.pulp_gem.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://pulp
# See configuration.py for a list of all supported configuration parameters.
configuration = pulpcore.client.pulp_gem.Configuration(
    host = "http://pulp"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure HTTP basic authorization: basicAuth
configuration = pulpcore.client.pulp_gem.Configuration(
    username = 'YOUR_USERNAME',
    password = 'YOUR_PASSWORD'
)

# Configure API key authorization: cookieAuth
configuration = pulpcore.client.pulp_gem.Configuration(
    host = "http://pulp",
    api_key = {
        'sessionid': 'YOUR_API_KEY'
    }
)
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['sessionid'] = 'Bearer'


# Enter a context with an instance of the API client
with pulpcore.client.pulp_gem.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = pulpcore.client.pulp_gem.ContentGemApi(api_client)
    repository = 'repository_example' # str | A URI of a repository the new content unit should be associated with. (optional)
artifact = 'artifact_example' # str | Artifact file representing the physical content (optional)
file = '/path/to/file' # file | An uploaded file that should be turned into the artifact of the content unit. (optional)

    try:
        # Create a gem content
        api_response = api_instance.create(repository=repository, artifact=artifact, file=file)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling ContentGemApi->create: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *http://pulp*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ContentGemApi* | [**create**](docs/ContentGemApi.md#create) | **POST** /pulp/api/v3/content/gem/gem/ | Create a gem content
*ContentGemApi* | [**list**](docs/ContentGemApi.md#list) | **GET** /pulp/api/v3/content/gem/gem/ | List gem contents
*ContentGemApi* | [**read**](docs/ContentGemApi.md#read) | **GET** {gem_gem_content_href} | Inspect a gem content
*DistributionsGemApi* | [**add_role**](docs/DistributionsGemApi.md#add_role) | **POST** {gem_gem_distribution_href}add_role/ | Add a role
*DistributionsGemApi* | [**create**](docs/DistributionsGemApi.md#create) | **POST** /pulp/api/v3/distributions/gem/gem/ | Create a gem distribution
*DistributionsGemApi* | [**delete**](docs/DistributionsGemApi.md#delete) | **DELETE** {gem_gem_distribution_href} | Delete a gem distribution
*DistributionsGemApi* | [**list**](docs/DistributionsGemApi.md#list) | **GET** /pulp/api/v3/distributions/gem/gem/ | List gem distributions
*DistributionsGemApi* | [**list_roles**](docs/DistributionsGemApi.md#list_roles) | **GET** {gem_gem_distribution_href}list_roles/ | List roles
*DistributionsGemApi* | [**my_permissions**](docs/DistributionsGemApi.md#my_permissions) | **GET** {gem_gem_distribution_href}my_permissions/ | List user permissions
*DistributionsGemApi* | [**partial_update**](docs/DistributionsGemApi.md#partial_update) | **PATCH** {gem_gem_distribution_href} | Update a gem distribution
*DistributionsGemApi* | [**read**](docs/DistributionsGemApi.md#read) | **GET** {gem_gem_distribution_href} | Inspect a gem distribution
*DistributionsGemApi* | [**remove_role**](docs/DistributionsGemApi.md#remove_role) | **POST** {gem_gem_distribution_href}remove_role/ | Remove a role
*DistributionsGemApi* | [**set_label**](docs/DistributionsGemApi.md#set_label) | **POST** {gem_gem_distribution_href}set_label/ | Set a label
*DistributionsGemApi* | [**unset_label**](docs/DistributionsGemApi.md#unset_label) | **POST** {gem_gem_distribution_href}unset_label/ | Unset a label
*DistributionsGemApi* | [**update**](docs/DistributionsGemApi.md#update) | **PUT** {gem_gem_distribution_href} | Update a gem distribution
*PublicationsGemApi* | [**add_role**](docs/PublicationsGemApi.md#add_role) | **POST** {gem_gem_publication_href}add_role/ | Add a role
*PublicationsGemApi* | [**create**](docs/PublicationsGemApi.md#create) | **POST** /pulp/api/v3/publications/gem/gem/ | Create a gem publication
*PublicationsGemApi* | [**delete**](docs/PublicationsGemApi.md#delete) | **DELETE** {gem_gem_publication_href} | Delete a gem publication
*PublicationsGemApi* | [**list**](docs/PublicationsGemApi.md#list) | **GET** /pulp/api/v3/publications/gem/gem/ | List gem publications
*PublicationsGemApi* | [**list_roles**](docs/PublicationsGemApi.md#list_roles) | **GET** {gem_gem_publication_href}list_roles/ | List roles
*PublicationsGemApi* | [**my_permissions**](docs/PublicationsGemApi.md#my_permissions) | **GET** {gem_gem_publication_href}my_permissions/ | List user permissions
*PublicationsGemApi* | [**read**](docs/PublicationsGemApi.md#read) | **GET** {gem_gem_publication_href} | Inspect a gem publication
*PublicationsGemApi* | [**remove_role**](docs/PublicationsGemApi.md#remove_role) | **POST** {gem_gem_publication_href}remove_role/ | Remove a role
*RemotesGemApi* | [**add_role**](docs/RemotesGemApi.md#add_role) | **POST** {gem_gem_remote_href}add_role/ | Add a role
*RemotesGemApi* | [**create**](docs/RemotesGemApi.md#create) | **POST** /pulp/api/v3/remotes/gem/gem/ | Create a gem remote
*RemotesGemApi* | [**delete**](docs/RemotesGemApi.md#delete) | **DELETE** {gem_gem_remote_href} | Delete a gem remote
*RemotesGemApi* | [**list**](docs/RemotesGemApi.md#list) | **GET** /pulp/api/v3/remotes/gem/gem/ | List gem remotes
*RemotesGemApi* | [**list_roles**](docs/RemotesGemApi.md#list_roles) | **GET** {gem_gem_remote_href}list_roles/ | List roles
*RemotesGemApi* | [**my_permissions**](docs/RemotesGemApi.md#my_permissions) | **GET** {gem_gem_remote_href}my_permissions/ | List user permissions
*RemotesGemApi* | [**partial_update**](docs/RemotesGemApi.md#partial_update) | **PATCH** {gem_gem_remote_href} | Update a gem remote
*RemotesGemApi* | [**read**](docs/RemotesGemApi.md#read) | **GET** {gem_gem_remote_href} | Inspect a gem remote
*RemotesGemApi* | [**remove_role**](docs/RemotesGemApi.md#remove_role) | **POST** {gem_gem_remote_href}remove_role/ | Remove a role
*RemotesGemApi* | [**set_label**](docs/RemotesGemApi.md#set_label) | **POST** {gem_gem_remote_href}set_label/ | Set a label
*RemotesGemApi* | [**unset_label**](docs/RemotesGemApi.md#unset_label) | **POST** {gem_gem_remote_href}unset_label/ | Unset a label
*RemotesGemApi* | [**update**](docs/RemotesGemApi.md#update) | **PUT** {gem_gem_remote_href} | Update a gem remote
*RepositoriesGemApi* | [**add_role**](docs/RepositoriesGemApi.md#add_role) | **POST** {gem_gem_repository_href}add_role/ | Add a role
*RepositoriesGemApi* | [**create**](docs/RepositoriesGemApi.md#create) | **POST** /pulp/api/v3/repositories/gem/gem/ | Create a gem repository
*RepositoriesGemApi* | [**delete**](docs/RepositoriesGemApi.md#delete) | **DELETE** {gem_gem_repository_href} | Delete a gem repository
*RepositoriesGemApi* | [**list**](docs/RepositoriesGemApi.md#list) | **GET** /pulp/api/v3/repositories/gem/gem/ | List gem repositorys
*RepositoriesGemApi* | [**list_roles**](docs/RepositoriesGemApi.md#list_roles) | **GET** {gem_gem_repository_href}list_roles/ | List roles
*RepositoriesGemApi* | [**modify**](docs/RepositoriesGemApi.md#modify) | **POST** {gem_gem_repository_href}modify/ | Modify Repository Content
*RepositoriesGemApi* | [**my_permissions**](docs/RepositoriesGemApi.md#my_permissions) | **GET** {gem_gem_repository_href}my_permissions/ | List user permissions
*RepositoriesGemApi* | [**partial_update**](docs/RepositoriesGemApi.md#partial_update) | **PATCH** {gem_gem_repository_href} | Update a gem repository
*RepositoriesGemApi* | [**read**](docs/RepositoriesGemApi.md#read) | **GET** {gem_gem_repository_href} | Inspect a gem repository
*RepositoriesGemApi* | [**remove_role**](docs/RepositoriesGemApi.md#remove_role) | **POST** {gem_gem_repository_href}remove_role/ | Remove a role
*RepositoriesGemApi* | [**set_label**](docs/RepositoriesGemApi.md#set_label) | **POST** {gem_gem_repository_href}set_label/ | Set a label
*RepositoriesGemApi* | [**sync**](docs/RepositoriesGemApi.md#sync) | **POST** {gem_gem_repository_href}sync/ | Sync from a remote
*RepositoriesGemApi* | [**unset_label**](docs/RepositoriesGemApi.md#unset_label) | **POST** {gem_gem_repository_href}unset_label/ | Unset a label
*RepositoriesGemApi* | [**update**](docs/RepositoriesGemApi.md#update) | **PUT** {gem_gem_repository_href} | Update a gem repository
*RepositoriesGemVersionsApi* | [**delete**](docs/RepositoriesGemVersionsApi.md#delete) | **DELETE** {gem_gem_repository_version_href} | Delete a repository version
*RepositoriesGemVersionsApi* | [**list**](docs/RepositoriesGemVersionsApi.md#list) | **GET** {gem_gem_repository_href}versions/ | List repository versions
*RepositoriesGemVersionsApi* | [**read**](docs/RepositoriesGemVersionsApi.md#read) | **GET** {gem_gem_repository_version_href} | Inspect a repository version
*RepositoriesGemVersionsApi* | [**repair**](docs/RepositoriesGemVersionsApi.md#repair) | **POST** {gem_gem_repository_version_href}repair/ | 


## Documentation For Models

 - [AsyncOperationResponse](docs/AsyncOperationResponse.md)
 - [ContentSummaryResponse](docs/ContentSummaryResponse.md)
 - [GemGemContent](docs/GemGemContent.md)
 - [GemGemContentResponse](docs/GemGemContentResponse.md)
 - [GemGemDistribution](docs/GemGemDistribution.md)
 - [GemGemDistributionResponse](docs/GemGemDistributionResponse.md)
 - [GemGemPublication](docs/GemGemPublication.md)
 - [GemGemPublicationResponse](docs/GemGemPublicationResponse.md)
 - [GemGemRemote](docs/GemGemRemote.md)
 - [GemGemRemoteResponse](docs/GemGemRemoteResponse.md)
 - [GemGemRemoteResponseHiddenFields](docs/GemGemRemoteResponseHiddenFields.md)
 - [GemGemRepository](docs/GemGemRepository.md)
 - [GemGemRepositoryResponse](docs/GemGemRepositoryResponse.md)
 - [MyPermissionsResponse](docs/MyPermissionsResponse.md)
 - [NestedRole](docs/NestedRole.md)
 - [NestedRoleResponse](docs/NestedRoleResponse.md)
 - [ObjectRolesResponse](docs/ObjectRolesResponse.md)
 - [PaginatedRepositoryVersionResponseList](docs/PaginatedRepositoryVersionResponseList.md)
 - [PaginatedgemGemContentResponseList](docs/PaginatedgemGemContentResponseList.md)
 - [PaginatedgemGemDistributionResponseList](docs/PaginatedgemGemDistributionResponseList.md)
 - [PaginatedgemGemPublicationResponseList](docs/PaginatedgemGemPublicationResponseList.md)
 - [PaginatedgemGemRemoteResponseList](docs/PaginatedgemGemRemoteResponseList.md)
 - [PaginatedgemGemRepositoryResponseList](docs/PaginatedgemGemRepositoryResponseList.md)
 - [PatchedgemGemDistribution](docs/PatchedgemGemDistribution.md)
 - [PatchedgemGemRemote](docs/PatchedgemGemRemote.md)
 - [PatchedgemGemRepository](docs/PatchedgemGemRepository.md)
 - [PolicyEnum](docs/PolicyEnum.md)
 - [Repair](docs/Repair.md)
 - [RepositoryAddRemoveContent](docs/RepositoryAddRemoveContent.md)
 - [RepositorySyncURL](docs/RepositorySyncURL.md)
 - [RepositoryVersionResponse](docs/RepositoryVersionResponse.md)
 - [SetLabel](docs/SetLabel.md)
 - [SetLabelResponse](docs/SetLabelResponse.md)
 - [UnsetLabel](docs/UnsetLabel.md)
 - [UnsetLabelResponse](docs/UnsetLabelResponse.md)


## Documentation For Authorization


## basicAuth

- **Type**: HTTP basic authentication


## cookieAuth

- **Type**: API key
- **API key parameter name**: sessionid
- **Location**: 


## Author

pulp-list@redhat.com


