# coding: utf-8

"""
    DocuSign REST API

    The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.

    OpenAPI spec version: v2
    Contact: devcenter@docusign.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class SignHashSessionInfoResponse(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, documents=None, envelope_id=None, language=None, redirection_url=None, remaining_signature_requests=None, seal=None, user=None):
        """
        SignHashSessionInfoResponse - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'documents': 'list[SignHashDocument]',
            'envelope_id': 'str',
            'language': 'str',
            'redirection_url': 'str',
            'remaining_signature_requests': 'str',
            'seal': 'Seal',
            'user': 'User'
        }

        self.attribute_map = {
            'documents': 'documents',
            'envelope_id': 'envelopeId',
            'language': 'language',
            'redirection_url': 'redirectionUrl',
            'remaining_signature_requests': 'remainingSignatureRequests',
            'seal': 'seal',
            'user': 'user'
        }

        self._documents = documents
        self._envelope_id = envelope_id
        self._language = language
        self._redirection_url = redirection_url
        self._remaining_signature_requests = remaining_signature_requests
        self._seal = seal
        self._user = user

    @property
    def documents(self):
        """
        Gets the documents of this SignHashSessionInfoResponse.
        Complex element contains the details on the documents in the envelope.

        :return: The documents of this SignHashSessionInfoResponse.
        :rtype: list[SignHashDocument]
        """
        return self._documents

    @documents.setter
    def documents(self, documents):
        """
        Sets the documents of this SignHashSessionInfoResponse.
        Complex element contains the details on the documents in the envelope.

        :param documents: The documents of this SignHashSessionInfoResponse.
        :type: list[SignHashDocument]
        """

        self._documents = documents

    @property
    def envelope_id(self):
        """
        Gets the envelope_id of this SignHashSessionInfoResponse.
        The envelope ID of the envelope status that failed to post.

        :return: The envelope_id of this SignHashSessionInfoResponse.
        :rtype: str
        """
        return self._envelope_id

    @envelope_id.setter
    def envelope_id(self, envelope_id):
        """
        Sets the envelope_id of this SignHashSessionInfoResponse.
        The envelope ID of the envelope status that failed to post.

        :param envelope_id: The envelope_id of this SignHashSessionInfoResponse.
        :type: str
        """

        self._envelope_id = envelope_id

    @property
    def language(self):
        """
        Gets the language of this SignHashSessionInfoResponse.
        

        :return: The language of this SignHashSessionInfoResponse.
        :rtype: str
        """
        return self._language

    @language.setter
    def language(self, language):
        """
        Sets the language of this SignHashSessionInfoResponse.
        

        :param language: The language of this SignHashSessionInfoResponse.
        :type: str
        """

        self._language = language

    @property
    def redirection_url(self):
        """
        Gets the redirection_url of this SignHashSessionInfoResponse.
        

        :return: The redirection_url of this SignHashSessionInfoResponse.
        :rtype: str
        """
        return self._redirection_url

    @redirection_url.setter
    def redirection_url(self, redirection_url):
        """
        Sets the redirection_url of this SignHashSessionInfoResponse.
        

        :param redirection_url: The redirection_url of this SignHashSessionInfoResponse.
        :type: str
        """

        self._redirection_url = redirection_url

    @property
    def remaining_signature_requests(self):
        """
        Gets the remaining_signature_requests of this SignHashSessionInfoResponse.
        

        :return: The remaining_signature_requests of this SignHashSessionInfoResponse.
        :rtype: str
        """
        return self._remaining_signature_requests

    @remaining_signature_requests.setter
    def remaining_signature_requests(self, remaining_signature_requests):
        """
        Sets the remaining_signature_requests of this SignHashSessionInfoResponse.
        

        :param remaining_signature_requests: The remaining_signature_requests of this SignHashSessionInfoResponse.
        :type: str
        """

        self._remaining_signature_requests = remaining_signature_requests

    @property
    def seal(self):
        """
        Gets the seal of this SignHashSessionInfoResponse.

        :return: The seal of this SignHashSessionInfoResponse.
        :rtype: Seal
        """
        return self._seal

    @seal.setter
    def seal(self, seal):
        """
        Sets the seal of this SignHashSessionInfoResponse.

        :param seal: The seal of this SignHashSessionInfoResponse.
        :type: Seal
        """

        self._seal = seal

    @property
    def user(self):
        """
        Gets the user of this SignHashSessionInfoResponse.

        :return: The user of this SignHashSessionInfoResponse.
        :rtype: User
        """
        return self._user

    @user.setter
    def user(self, user):
        """
        Sets the user of this SignHashSessionInfoResponse.

        :param user: The user of this SignHashSessionInfoResponse.
        :type: User
        """

        self._user = user

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
