"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LifecycleLabel = exports.renderBottlerocketUserData = exports.renderAmazonLinuxUserData = void 0;
const core_1 = require("@aws-cdk/core");
// eslint-disable-next-line max-len
function renderAmazonLinuxUserData(cluster, autoScalingGroup, options = {}) {
    var _a;
    const stack = core_1.Stack.of(autoScalingGroup);
    // determine logical id of ASG so we can signal cloudformation
    const cfn = autoScalingGroup.node.defaultChild;
    const asgLogicalId = cfn.logicalId;
    const extraArgs = new Array();
    extraArgs.push(`--apiserver-endpoint '${cluster.clusterEndpoint}'`);
    extraArgs.push(`--b64-cluster-ca '${cluster.clusterCertificateAuthorityData}'`);
    extraArgs.push(`--use-max-pods ${(_a = options.useMaxPods) !== null && _a !== void 0 ? _a : true}`);
    if (options.awsApiRetryAttempts) {
        extraArgs.push(`--aws-api-retry-attempts ${options.awsApiRetryAttempts}`);
    }
    if (options.enableDockerBridge) {
        extraArgs.push('--enable-docker-bridge true');
    }
    if (options.dockerConfigJson) {
        extraArgs.push(`--docker-config-json '${options.dockerConfigJson}'`);
    }
    if (options.dnsClusterIp) {
        extraArgs.push(`--dns-cluster-ip ${options.dnsClusterIp}`);
    }
    if (options.additionalArgs) {
        extraArgs.push(options.additionalArgs);
    }
    const commandLineSuffix = extraArgs.join(' ');
    const kubeletExtraArgsSuffix = options.kubeletExtraArgs || '';
    // determine lifecycle label based on whether the ASG has a spot price.
    const lifecycleLabel = autoScalingGroup.spotPrice ? LifecycleLabel.SPOT : LifecycleLabel.ON_DEMAND;
    const withTaints = autoScalingGroup.spotPrice ? '--register-with-taints=spotInstance=true:PreferNoSchedule' : '';
    const kubeletExtraArgs = `--node-labels lifecycle=${lifecycleLabel} ${withTaints} ${kubeletExtraArgsSuffix}`.trim();
    return [
        'set -o xtrace',
        `/etc/eks/bootstrap.sh ${cluster.clusterName} --kubelet-extra-args "${kubeletExtraArgs}" ${commandLineSuffix}`.trim(),
        `/opt/aws/bin/cfn-signal --exit-code $? --stack ${stack.stackName} --resource ${asgLogicalId} --region ${stack.region}`,
    ];
}
exports.renderAmazonLinuxUserData = renderAmazonLinuxUserData;
function renderBottlerocketUserData(cluster) {
    return [
        '[settings.kubernetes]',
        `api-server="${cluster.clusterEndpoint}"`,
        `cluster-certificate="${cluster.clusterCertificateAuthorityData}"`,
        `cluster-name="${cluster.clusterName}"`,
    ];
}
exports.renderBottlerocketUserData = renderBottlerocketUserData;
/**
 * The lifecycle label for node selector
 */
var LifecycleLabel;
(function (LifecycleLabel) {
    /**
     * on-demand instances
     */
    LifecycleLabel["ON_DEMAND"] = "OnDemand";
    /**
     * spot instances
     */
    LifecycleLabel["SPOT"] = "Ec2Spot";
})(LifecycleLabel = exports.LifecycleLabel || (exports.LifecycleLabel = {}));
//# sourceMappingURL=data:application/json;base64,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