"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SwapUsageMomiton = void 0;
const cdk = require("@aws-cdk/core");
const cloudwatch = require("@aws-cdk/aws-cloudwatch");
// Reference: https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheMetrics.WhichShouldIMonitor.html#metrics-swap-usage
class SwapUsageMomiton {
    static setup(scope, cacheClusterId) {
        return new cloudwatch.Alarm(scope, 'alarm-elastc-cache-' + cacheClusterId + '-SwapUsage', {
            alarmName: 'elasticCache-swapUsage-alarm[' + cacheClusterId + ']',
            metric: new cloudwatch.Metric({
                namespace: 'AWS/ElastiCache',
                metricName: 'SwapUsage',
                dimensions: { CacheClusterId: cacheClusterId },
                statistic: 'max',
            }),
            threshold: 52430000,
            period: cdk.Duration.minutes(1),
            evaluationPeriods: 1,
            alarmDescription: 'The maximum value of the swapUsage within one minute is higher than 50MB',
            comparisonOperator: cloudwatch.ComparisonOperator.GREATER_THAN_OR_EQUAL_TO_THRESHOLD,
            treatMissingData: cloudwatch.TreatMissingData.BREACHING,
        });
    }
}
exports.SwapUsageMomiton = SwapUsageMomiton;
//# sourceMappingURL=data:application/json;base64,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