"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FreeableMemoryMomiton = void 0;
const cdk = require("@aws-cdk/core");
const cloudwatch = require("@aws-cdk/aws-cloudwatch");
// According to business needs
class FreeableMemoryMomiton {
    static setup(scope, cacheClusterId, nodeType) {
        const threshold = Math.round(nodeType.memory * 0.1);
        return new cloudwatch.Alarm(scope, 'alarm-elastc-cache-' + cacheClusterId + '-FreeableMemory', {
            alarmName: 'elasticCache-freeableMemory-alarm[' + cacheClusterId + ']',
            metric: new cloudwatch.Metric({
                namespace: 'AWS/ElastiCache',
                metricName: 'FreeableMemory',
                dimensions: { CacheClusterId: cacheClusterId },
                statistic: 'min',
            }),
            threshold,
            period: cdk.Duration.minutes(1),
            evaluationPeriods: 1,
            alarmDescription: 'The FreeableMemory value is less than ' + (threshold / (1024 * 1024 * 1024)).toFixed(2) + 'Gb in one minute',
            comparisonOperator: cloudwatch.ComparisonOperator.LESS_THAN_THRESHOLD,
            treatMissingData: cloudwatch.TreatMissingData.BREACHING,
        });
    }
}
exports.FreeableMemoryMomiton = FreeableMemoryMomiton;
//# sourceMappingURL=data:application/json;base64,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