"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EvictionsMomiton = void 0;
const cdk = require("@aws-cdk/core");
const cloudwatch = require("@aws-cdk/aws-cloudwatch");
// Reference: https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheMetrics.WhichShouldIMonitor.html#metrics-evictions
class EvictionsMomiton {
    static setup(scope, cacheClusterId) {
        return new cloudwatch.Alarm(scope, 'alarm-elastc-cache-' + cacheClusterId + '-Evictions', {
            alarmName: 'elasticCache-evictions-alarm[' + cacheClusterId + ']',
            metric: new cloudwatch.Metric({
                namespace: 'AWS/ElastiCache',
                metricName: 'Evictions',
                dimensions: { CacheClusterId: cacheClusterId },
                statistic: 'max',
            }),
            threshold: 1,
            period: cdk.Duration.minutes(1),
            evaluationPeriods: 1,
            alarmDescription: 'Data evicted within one minute(We recommend that you determine your own alarm threshold for this metric based on your application needs)',
            comparisonOperator: cloudwatch.ComparisonOperator.GREATER_THAN_OR_EQUAL_TO_THRESHOLD,
            treatMissingData: cloudwatch.TreatMissingData.BREACHING,
        });
    }
}
exports.EvictionsMomiton = EvictionsMomiton;
//# sourceMappingURL=data:application/json;base64,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