"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CurrConnectionsMomiton = void 0;
const cloudwatch = require("@aws-cdk/aws-cloudwatch");
// Reference: https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheMetrics.WhichShouldIMonitor.html#metrics-curr-connections
class CurrConnectionsMomiton {
    static setup(scope, cacheClusterId, period, threshold) {
        return new cloudwatch.Alarm(scope, 'alarm-elastc-cache-' + cacheClusterId + '-CurrConnections', {
            alarmName: 'elasticCache-currConnections-alarm[' + cacheClusterId + ']',
            metric: new cloudwatch.Metric({
                namespace: 'AWS/ElastiCache',
                metricName: 'CurrConnections',
                dimensions: { CacheClusterId: cacheClusterId },
                statistic: 'avg',
            }),
            threshold,
            period,
            evaluationPeriods: 1,
            alarmDescription: 'The connection constant in ' + period.toMinutes + 'minute(s) is greater than' + threshold,
            comparisonOperator: cloudwatch.ComparisonOperator.GREATER_THAN_OR_EQUAL_TO_THRESHOLD,
            treatMissingData: cloudwatch.TreatMissingData.BREACHING,
        });
    }
}
exports.CurrConnectionsMomiton = CurrConnectionsMomiton;
//# sourceMappingURL=data:application/json;base64,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