# RoboSystems Python Client

[![PyPI version](https://badge.fury.io/py/robosystems-client.svg)](https://pypi.org/project/robosystems-client/)
[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](https://opensource.org/licenses/MIT)

Official Python Client for the RoboSystems Financial Knowledge Graph API. Access comprehensive financial data including accounting transactions, financial reports, and advanced graph analytics through a type-safe, async-ready Python interface.

## Features

- **Type-safe API client** with full type hints and Pydantic models
- **Async/await support** for high-performance applications
- **Table ingestion** with simplified Parquet file uploads
- **Streaming support** for memory-efficient processing of large result sets
- **Financial AI Agent** integration for natural language queries
- **Comprehensive error handling** with typed exceptions

## Installation

```bash
# Basic installation
pip install robosystems-client

# With table ingestion support (for uploading Parquet files)
pip install robosystems-client[tables]

# All optional features
pip install robosystems-client[all]
```

## API Reference

- [API reference](https://api.robosystems.ai)
- [API documentation](https://api.robosystems.ai/docs)
- [OpenAPI specification](https://api.robosystems.ai/openapi.json)

## Support

- [Issues](https://github.com/RoboFinSystems/robosystems-python-client/issues)
- [Discussions](https://github.com/RoboFinSystems/robosystems/discussions)
- [Projects](https://github.com/RoboFinSystems/robosystems/projects)
- [Wiki](https://github.com/RoboFinSystems/robosystems/wiki)

## License

This project is licensed under the MIT License - see the [LICENSE](LICENSE) file for details.

MIT © 2025 RFS LLC
