"""

.. Important:: The Graphics module was introduced in version 1.1.0.

The Graphics module contains the following classes:

.. autosummary::
   :toctree: .

    Models
    Blocks
    BoxDrawings
    GeometricShapes

The Graphics module hold many variables that aims at simplifying the use of
unicode characters in the game development process.

This module also import colorama. All styling features are accessible through:

 * Graphics.Fore for Foreground colors.
 * Graphics.Back for Background colors.
 * Graphics.Style for styling options.

For convenience, the different entities are scattered in grouping classes:

 * All emojis are in the Models class.
 * The UI/box drawings are grouped into the BoxDrawings class.
 * The block glyphs are in the Blocks class.
 * The geometric shapes are in the GeometricShapes class.

This modules defines a couple of colored squares and rectangles that should displays
correctly in all terminals.

These are kept for legacy purpose (I personally have a lot of kids that are still using
it), but for anyone starting fresh, it is better to use the <color>_rect() and
<color>_square() static methods of the :class:`~pygamelib.gfx.core.Sprixel` class.
Particularly if you are going to use them as background for your Board.

Colored rectangles:

 * WHITE_RECT
 * BLUE_RECT
 * RED_RECT
 * MAGENTA_RECT
 * GREEN_RECT
 * YELLOW_RECT
 * BLACK_RECT
 * CYAN_RECT

Then colored squares:

 * WHITE_SQUARE
 * MAGENTA_SQUARE
 * GREEN_SQUARE
 * RED_SQUARE
 * BLUE_SQUARE
 * YELLOW_SQUARE
 * BLACK_SQUARE
 * CYAN_SQUARE

And finally an example of composition of rectangles to make different colored squares:

 * RED_BLUE_SQUARE = RED_RECT+BLUE_RECT
 * YELLOW_CYAN_SQUARE = YELLOW_RECT+CYAN_RECT

"""

from colorama import Fore, Back, Style, init  # noqa: F401

# import colorama.ansi
# import subprocess

init()

# Color blocks (they are here for legacy reasons)
WHITE_RECT = Back.WHITE + " " + Style.RESET_ALL
BLUE_RECT = Back.BLUE + " " + Style.RESET_ALL
RED_RECT = Back.RED + " " + Style.RESET_ALL
MAGENTA_RECT = Back.MAGENTA + " " + Style.RESET_ALL
GREEN_RECT = Back.GREEN + " " + Style.RESET_ALL
YELLOW_RECT = Back.YELLOW + " " + Style.RESET_ALL
BLACK_RECT = Back.BLACK + " " + Style.RESET_ALL
CYAN_RECT = Back.CYAN + " " + Style.RESET_ALL

WHITE_SQUARE = Back.WHITE + "  " + Style.RESET_ALL
MAGENTA_SQUARE = Back.MAGENTA + "  " + Style.RESET_ALL
GREEN_SQUARE = Back.GREEN + "  " + Style.RESET_ALL
RED_SQUARE = Back.RED + "  " + Style.RESET_ALL
BLUE_SQUARE = Back.BLUE + "  " + Style.RESET_ALL
YELLOW_SQUARE = Back.YELLOW + "  " + Style.RESET_ALL
BLACK_SQUARE = Back.BLACK + "  " + Style.RESET_ALL
CYAN_SQUARE = Back.CYAN + "  " + Style.RESET_ALL

RED_BLUE_SQUARE = Back.RED + " " + Back.BLUE + " " + Style.RESET_ALL
YELLOW_CYAN_SQUARE = Back.YELLOW + " " + Back.CYAN + " " + Style.RESET_ALL

# UI elements
# Box drawings


class BoxDrawings:

    """Box drawing elements (unicode)

    Here is the list of supported glyphs:

     * LIGHT_HORIZONTAL = \U00002500
     * HEAVY_HORIZONTAL = \U00002501
     * LIGHT_VERTICAL = \U00002502
     * HEAVY_VERTICAL = \U00002503
     * LIGHT_TRIPLE_DASH_HORIZONTAL = \U00002504
     * HEAVY_TRIPLE_DASH_HORIZONTAL = \U00002505
     * LIGHT_TRIPLE_DASH_VERTICAL = \U00002506
     * HEAVY_TRIPLE_DASH_VERTICAL = \U00002507
     * LIGHT_QUADRUPLE_DASH_HORIZONTAL = \U00002508
     * HEAVY_QUADRUPLE_DASH_HORIZONTAL = \U00002509
     * LIGHT_QUADRUPLE_DASH_VERTICAL = \U0000250A
     * HEAVY_QUADRUPLE_DASH_VERTICAL = \U0000250B
     * LIGHT_DOWN_AND_RIGHT = \U0000250C
     * DOWN_LIGHT_AND_RIGHT_HEAVY = \U0000250D
     * DOWN_HEAVY_AND_RIGHT_LIGHT = \U0000250E
     * HEAVY_DOWN_AND_RIGHT = \U0000250F
     * LIGHT_DOWN_AND_LEFT = \U00002510
     * DOWN_LIGHT_AND_LEFT_HEAVY = \U00002511
     * DOWN_HEAVY_AND_LEFT_LIGHT = \U00002512
     * HEAVY_DOWN_AND_LEFT = \U00002513
     * LIGHT_UP_AND_RIGHT = \U00002514
     * UP_LIGHT_AND_RIGHT_HEAVY = \U00002515
     * UP_HEAVY_AND_RIGHT_LIGHT = \U00002516
     * HEAVY_UP_AND_RIGHT = \U00002517
     * LIGHT_UP_AND_LEFT = \U00002518
     * UP_LIGHT_AND_LEFT_HEAVY = \U00002519
     * UP_HEAVY_AND_LEFT_LIGHT = \U0000251A
     * HEAVY_UP_AND_LEFT = \U0000251B
     * LIGHT_VERTICAL_AND_RIGHT = \U0000251C
     * VERTICAL_LIGHT_AND_RIGHT_HEAVY = \U0000251D
     * UP_HEAVY_AND_RIGHT_DOWN_LIGHT = \U0000251E
     * DOWN_HEAVY_AND_RIGHT_UP_LIGHT = \U0000251F
     * VERTICAL_HEAVY_AND_RIGHT_LIGHT = \U00002520
     * DOWN_LIGHT_AND_RIGHT_UP_HEAVY = \U00002521
     * UP_LIGHT_AND_RIGHT_DOWN_HEAVY = \U00002522
     * HEAVY_VERTICAL_AND_RIGHT = \U00002523
     * LIGHT_VERTICAL_AND_LEFT = \U00002524
     * VERTICAL_LIGHT_AND_LEFT_HEAVY = \U00002525
     * UP_HEAVY_AND_LEFT_DOWN_LIGHT = \U00002526
     * DOWN_HEAVY_AND_LEFT_UP_LIGHT = \U00002527
     * VERTICAL_HEAVY_AND_LEFT_LIGHT = \U00002528
     * DOWN_LIGHT_AND_LEFT_UP_HEAVY = \U00002529
     * UP_LIGHT_AND_LEFT_DOWN_HEAVY = \U0000252A
     * HEAVY_VERTICAL_AND_LEFT = \U0000252B
     * LIGHT_DOWN_AND_HORIZONTAL = \U0000252C
     * LEFT_HEAVY_AND_RIGHT_DOWN_LIGHT = \U0000252D
     * RIGHT_HEAVY_AND_LEFT_DOWN_LIGHT = \U0000252E
     * DOWN_LIGHT_AND_HORIZONTAL_HEAVY = \U0000252F
     * DOWN_HEAVY_AND_HORIZONTAL_LIGHT = \U00002530
     * RIGHT_LIGHT_AND_LEFT_DOWN_HEAVY = \U00002531
     * LEFT_LIGHT_AND_RIGHT_DOWN_HEAVY = \U00002532
     * HEAVY_DOWN_AND_HORIZONTAL = \U00002533
     * LIGHT_UP_AND_HORIZONTAL = \U00002534
     * LEFT_HEAVY_AND_RIGHT_UP_LIGHT = \U00002535
     * RIGHT_HEAVY_AND_LEFT_UP_LIGHT = \U00002536
     * UP_LIGHT_AND_HORIZONTAL_HEAVY = \U00002537
     * UP_HEAVY_AND_HORIZONTAL_LIGHT = \U00002538
     * RIGHT_LIGHT_AND_LEFT_UP_HEAVY = \U00002539
     * LEFT_LIGHT_AND_RIGHT_UP_HEAVY = \U0000253A
     * HEAVY_UP_AND_HORIZONTAL = \U0000253B
     * LIGHT_VERTICAL_AND_HORIZONTAL = \U0000253C
     * LEFT_HEAVY_AND_RIGHT_VERTICAL_LIGHT = \U0000253D
     * RIGHT_HEAVY_AND_LEFT_VERTICAL_LIGHT = \U0000253E
     * VERTICAL_LIGHT_AND_HORIZONTAL_HEAVY = \U0000253F
     * UP_HEAVY_AND_DOWN_HORIZONTAL_LIGHT = \U00002540
     * DOWN_HEAVY_AND_UP_HORIZONTAL_LIGHT = \U00002541
     * VERTICAL_HEAVY_AND_HORIZONTAL_LIGHT = \U00002542
     * LEFT_UP_HEAVY_AND_RIGHT_DOWN_LIGHT = \U00002543
     * RIGHT_UP_HEAVY_AND_LEFT_DOWN_LIGHT = \U00002544
     * LEFT_DOWN_HEAVY_AND_RIGHT_UP_LIGHT = \U00002545
     * RIGHT_DOWN_HEAVY_AND_LEFT_UP_LIGHT = \U00002546
     * DOWN_LIGHT_AND_UP_HORIZONTAL_HEAVY = \U00002547
     * UP_LIGHT_AND_DOWN_HORIZONTAL_HEAVY = \U00002548
     * RIGHT_LIGHT_AND_LEFT_VERTICAL_HEAVY = \U00002549
     * LEFT_LIGHT_AND_RIGHT_VERTICAL_HEAVY = \U0000254A
     * HEAVY_VERTICAL_AND_HORIZONTAL = \U0000254B
     * LIGHT_DOUBLE_DASH_HORIZONTAL = \U0000254C
     * HEAVY_DOUBLE_DASH_HORIZONTAL = \U0000254D
     * LIGHT_DOUBLE_DASH_VERTICAL = \U0000254E
     * HEAVY_DOUBLE_DASH_VERTICAL = \U0000254F
     * DOUBLE_HORIZONTAL = \U00002550
     * DOUBLE_VERTICAL = \U00002551
     * DOWN_SINGLE_AND_RIGHT_DOUBLE = \U00002552
     * DOWN_DOUBLE_AND_RIGHT_SINGLE = \U00002553
     * DOUBLE_DOWN_AND_RIGHT = \U00002554
     * DOWN_SINGLE_AND_LEFT_DOUBLE = \U00002555
     * DOWN_DOUBLE_AND_LEFT_SINGLE = \U00002556
     * DOUBLE_DOWN_AND_LEFT = \U00002557
     * UP_SINGLE_AND_RIGHT_DOUBLE = \U00002558
     * UP_DOUBLE_AND_RIGHT_SINGLE = \U00002559
     * DOUBLE_UP_AND_RIGHT = \U0000255A
     * UP_SINGLE_AND_LEFT_DOUBLE = \U0000255B
     * UP_DOUBLE_AND_LEFT_SINGLE = \U0000255C
     * DOUBLE_UP_AND_LEFT = \U0000255D
     * VERTICAL_SINGLE_AND_RIGHT_DOUBLE = \U0000255E
     * VERTICAL_DOUBLE_AND_RIGHT_SINGLE = \U0000255F
     * DOUBLE_VERTICAL_AND_RIGHT = \U00002560
     * VERTICAL_SINGLE_AND_LEFT_DOUBLE = \U00002561
     * VERTICAL_DOUBLE_AND_LEFT_SINGLE = \U00002562
     * DOUBLE_VERTICAL_AND_LEFT = \U00002563
     * DOWN_SINGLE_AND_HORIZONTAL_DOUBLE = \U00002564
     * DOWN_DOUBLE_AND_HORIZONTAL_SINGLE = \U00002565
     * DOUBLE_DOWN_AND_HORIZONTAL = \U00002566
     * UP_SINGLE_AND_HORIZONTAL_DOUBLE = \U00002567
     * UP_DOUBLE_AND_HORIZONTAL_SINGLE = \U00002568
     * DOUBLE_UP_AND_HORIZONTAL = \U00002569
     * VERTICAL_SINGLE_AND_HORIZONTAL_DOUBLE = \U0000256A
     * VERTICAL_DOUBLE_AND_HORIZONTAL_SINGLE = \U0000256B
     * DOUBLE_VERTICAL_AND_HORIZONTAL = \U0000256C
     * LIGHT_ARC_DOWN_AND_RIGHT = \U0000256D
     * LIGHT_ARC_DOWN_AND_LEFT = \U0000256E
     * LIGHT_ARC_UP_AND_LEFT = \U0000256F
     * LIGHT_ARC_UP_AND_RIGHT = \U00002570
     * LIGHT_DIAGONAL_UPPER_RIGHT_TO_LOWER_LEFT = \U00002571
     * LIGHT_DIAGONAL_UPPER_LEFT_TO_LOWER_RIGHT = \U00002572
     * LIGHT_DIAGONAL_CROSS = \U00002573
     * LIGHT_LEFT = \U00002574
     * LIGHT_UP = \U00002575
     * LIGHT_RIGHT = \U00002576
     * LIGHT_DOWN = \U00002577
     * HEAVY_LEFT = \U00002578
     * HEAVY_UP = \U00002579
     * HEAVY_RIGHT = \U0000257A
     * HEAVY_DOWN = \U0000257B
     * LIGHT_LEFT_AND_HEAVY_RIGHT = \U0000257C
     * LIGHT_UP_AND_HEAVY_DOWN = \U0000257D
     * HEAVY_LEFT_AND_LIGHT_RIGHT = \U0000257E
     * HEAVY_UP_AND_LIGHT_DOWN = \U0000257F
    """

    LIGHT_HORIZONTAL = "\U00002500"
    HEAVY_HORIZONTAL = "\U00002501"
    LIGHT_VERTICAL = "\U00002502"
    HEAVY_VERTICAL = "\U00002503"
    LIGHT_TRIPLE_DASH_HORIZONTAL = "\U00002504"
    HEAVY_TRIPLE_DASH_HORIZONTAL = "\U00002505"
    LIGHT_TRIPLE_DASH_VERTICAL = "\U00002506"
    HEAVY_TRIPLE_DASH_VERTICAL = "\U00002507"
    LIGHT_QUADRUPLE_DASH_HORIZONTAL = "\U00002508"
    HEAVY_QUADRUPLE_DASH_HORIZONTAL = "\U00002509"
    LIGHT_QUADRUPLE_DASH_VERTICAL = "\U0000250A"
    HEAVY_QUADRUPLE_DASH_VERTICAL = "\U0000250B"
    LIGHT_DOWN_AND_RIGHT = "\U0000250C"
    DOWN_LIGHT_AND_RIGHT_HEAVY = "\U0000250D"
    DOWN_HEAVY_AND_RIGHT_LIGHT = "\U0000250E"
    HEAVY_DOWN_AND_RIGHT = "\U0000250F"
    LIGHT_DOWN_AND_LEFT = "\U00002510"
    DOWN_LIGHT_AND_LEFT_HEAVY = "\U00002511"
    DOWN_HEAVY_AND_LEFT_LIGHT = "\U00002512"
    HEAVY_DOWN_AND_LEFT = "\U00002513"
    LIGHT_UP_AND_RIGHT = "\U00002514"
    UP_LIGHT_AND_RIGHT_HEAVY = "\U00002515"
    UP_HEAVY_AND_RIGHT_LIGHT = "\U00002516"
    HEAVY_UP_AND_RIGHT = "\U00002517"
    LIGHT_UP_AND_LEFT = "\U00002518"
    UP_LIGHT_AND_LEFT_HEAVY = "\U00002519"
    UP_HEAVY_AND_LEFT_LIGHT = "\U0000251A"
    HEAVY_UP_AND_LEFT = "\U0000251B"
    LIGHT_VERTICAL_AND_RIGHT = "\U0000251C"
    VERTICAL_LIGHT_AND_RIGHT_HEAVY = "\U0000251D"
    UP_HEAVY_AND_RIGHT_DOWN_LIGHT = "\U0000251E"
    DOWN_HEAVY_AND_RIGHT_UP_LIGHT = "\U0000251F"
    VERTICAL_HEAVY_AND_RIGHT_LIGHT = "\U00002520"
    DOWN_LIGHT_AND_RIGHT_UP_HEAVY = "\U00002521"
    UP_LIGHT_AND_RIGHT_DOWN_HEAVY = "\U00002522"
    HEAVY_VERTICAL_AND_RIGHT = "\U00002523"
    LIGHT_VERTICAL_AND_LEFT = "\U00002524"
    VERTICAL_LIGHT_AND_LEFT_HEAVY = "\U00002525"
    UP_HEAVY_AND_LEFT_DOWN_LIGHT = "\U00002526"
    DOWN_HEAVY_AND_LEFT_UP_LIGHT = "\U00002527"
    VERTICAL_HEAVY_AND_LEFT_LIGHT = "\U00002528"
    DOWN_LIGHT_AND_LEFT_UP_HEAVY = "\U00002529"
    UP_LIGHT_AND_LEFT_DOWN_HEAVY = "\U0000252A"
    HEAVY_VERTICAL_AND_LEFT = "\U0000252B"
    LIGHT_DOWN_AND_HORIZONTAL = "\U0000252C"
    LEFT_HEAVY_AND_RIGHT_DOWN_LIGHT = "\U0000252D"
    RIGHT_HEAVY_AND_LEFT_DOWN_LIGHT = "\U0000252E"
    DOWN_LIGHT_AND_HORIZONTAL_HEAVY = "\U0000252F"
    DOWN_HEAVY_AND_HORIZONTAL_LIGHT = "\U00002530"
    RIGHT_LIGHT_AND_LEFT_DOWN_HEAVY = "\U00002531"
    LEFT_LIGHT_AND_RIGHT_DOWN_HEAVY = "\U00002532"
    HEAVY_DOWN_AND_HORIZONTAL = "\U00002533"
    LIGHT_UP_AND_HORIZONTAL = "\U00002534"
    LEFT_HEAVY_AND_RIGHT_UP_LIGHT = "\U00002535"
    RIGHT_HEAVY_AND_LEFT_UP_LIGHT = "\U00002536"
    UP_LIGHT_AND_HORIZONTAL_HEAVY = "\U00002537"
    UP_HEAVY_AND_HORIZONTAL_LIGHT = "\U00002538"
    RIGHT_LIGHT_AND_LEFT_UP_HEAVY = "\U00002539"
    LEFT_LIGHT_AND_RIGHT_UP_HEAVY = "\U0000253A"
    HEAVY_UP_AND_HORIZONTAL = "\U0000253B"
    LIGHT_VERTICAL_AND_HORIZONTAL = "\U0000253C"
    LEFT_HEAVY_AND_RIGHT_VERTICAL_LIGHT = "\U0000253D"
    RIGHT_HEAVY_AND_LEFT_VERTICAL_LIGHT = "\U0000253E"
    VERTICAL_LIGHT_AND_HORIZONTAL_HEAVY = "\U0000253F"
    UP_HEAVY_AND_DOWN_HORIZONTAL_LIGHT = "\U00002540"
    DOWN_HEAVY_AND_UP_HORIZONTAL_LIGHT = "\U00002541"
    VERTICAL_HEAVY_AND_HORIZONTAL_LIGHT = "\U00002542"
    LEFT_UP_HEAVY_AND_RIGHT_DOWN_LIGHT = "\U00002543"
    RIGHT_UP_HEAVY_AND_LEFT_DOWN_LIGHT = "\U00002544"
    LEFT_DOWN_HEAVY_AND_RIGHT_UP_LIGHT = "\U00002545"
    RIGHT_DOWN_HEAVY_AND_LEFT_UP_LIGHT = "\U00002546"
    DOWN_LIGHT_AND_UP_HORIZONTAL_HEAVY = "\U00002547"
    UP_LIGHT_AND_DOWN_HORIZONTAL_HEAVY = "\U00002548"
    RIGHT_LIGHT_AND_LEFT_VERTICAL_HEAVY = "\U00002549"
    LEFT_LIGHT_AND_RIGHT_VERTICAL_HEAVY = "\U0000254A"
    HEAVY_VERTICAL_AND_HORIZONTAL = "\U0000254B"
    LIGHT_DOUBLE_DASH_HORIZONTAL = "\U0000254C"
    HEAVY_DOUBLE_DASH_HORIZONTAL = "\U0000254D"
    LIGHT_DOUBLE_DASH_VERTICAL = "\U0000254E"
    HEAVY_DOUBLE_DASH_VERTICAL = "\U0000254F"
    DOUBLE_HORIZONTAL = "\U00002550"
    DOUBLE_VERTICAL = "\U00002551"
    DOWN_SINGLE_AND_RIGHT_DOUBLE = "\U00002552"
    DOWN_DOUBLE_AND_RIGHT_SINGLE = "\U00002553"
    DOUBLE_DOWN_AND_RIGHT = "\U00002554"
    DOWN_SINGLE_AND_LEFT_DOUBLE = "\U00002555"
    DOWN_DOUBLE_AND_LEFT_SINGLE = "\U00002556"
    DOUBLE_DOWN_AND_LEFT = "\U00002557"
    UP_SINGLE_AND_RIGHT_DOUBLE = "\U00002558"
    UP_DOUBLE_AND_RIGHT_SINGLE = "\U00002559"
    DOUBLE_UP_AND_RIGHT = "\U0000255A"
    UP_SINGLE_AND_LEFT_DOUBLE = "\U0000255B"
    UP_DOUBLE_AND_LEFT_SINGLE = "\U0000255C"
    DOUBLE_UP_AND_LEFT = "\U0000255D"
    VERTICAL_SINGLE_AND_RIGHT_DOUBLE = "\U0000255E"
    VERTICAL_DOUBLE_AND_RIGHT_SINGLE = "\U0000255F"
    DOUBLE_VERTICAL_AND_RIGHT = "\U00002560"
    VERTICAL_SINGLE_AND_LEFT_DOUBLE = "\U00002561"
    VERTICAL_DOUBLE_AND_LEFT_SINGLE = "\U00002562"
    DOUBLE_VERTICAL_AND_LEFT = "\U00002563"
    DOWN_SINGLE_AND_HORIZONTAL_DOUBLE = "\U00002564"
    DOWN_DOUBLE_AND_HORIZONTAL_SINGLE = "\U00002565"
    DOUBLE_DOWN_AND_HORIZONTAL = "\U00002566"
    UP_SINGLE_AND_HORIZONTAL_DOUBLE = "\U00002567"
    UP_DOUBLE_AND_HORIZONTAL_SINGLE = "\U00002568"
    DOUBLE_UP_AND_HORIZONTAL = "\U00002569"
    VERTICAL_SINGLE_AND_HORIZONTAL_DOUBLE = "\U0000256A"
    VERTICAL_DOUBLE_AND_HORIZONTAL_SINGLE = "\U0000256B"
    DOUBLE_VERTICAL_AND_HORIZONTAL = "\U0000256C"
    LIGHT_ARC_DOWN_AND_RIGHT = "\U0000256D"
    LIGHT_ARC_DOWN_AND_LEFT = "\U0000256E"
    LIGHT_ARC_UP_AND_LEFT = "\U0000256F"
    LIGHT_ARC_UP_AND_RIGHT = "\U00002570"
    LIGHT_DIAGONAL_UPPER_RIGHT_TO_LOWER_LEFT = "\U00002571"
    LIGHT_DIAGONAL_UPPER_LEFT_TO_LOWER_RIGHT = "\U00002572"
    LIGHT_DIAGONAL_CROSS = "\U00002573"
    LIGHT_LEFT = "\U00002574"
    LIGHT_UP = "\U00002575"
    LIGHT_RIGHT = "\U00002576"
    LIGHT_DOWN = "\U00002577"
    HEAVY_LEFT = "\U00002578"
    HEAVY_UP = "\U00002579"
    HEAVY_RIGHT = "\U0000257A"
    HEAVY_DOWN = "\U0000257B"
    LIGHT_LEFT_AND_HEAVY_RIGHT = "\U0000257C"
    LIGHT_UP_AND_HEAVY_DOWN = "\U0000257D"
    HEAVY_LEFT_AND_LIGHT_RIGHT = "\U0000257E"
    HEAVY_UP_AND_LIGHT_DOWN = "\U0000257F"


class Blocks:
    # Block elements
    """Block elements (unicode)

    Here is the list of supported glyphs:

     * UPPER_HALF_BLOCK = \U00002580
     * LOWER_ONE_EIGHTH_BLOCK = \U00002581
     * LOWER_ONE_QUARTER_BLOCK = \U00002582
     * LOWER_THREE_EIGHTHS_BLOCK = \U00002583
     * LOWER_HALF_BLOCK = \U00002584
     * LOWER_FIVE_EIGHTHS_BLOCK = \U00002585
     * LOWER_THREE_QUARTERS_BLOCK = \U00002586
     * LOWER_SEVEN_EIGHTHS_BLOCK = \U00002587
     * FULL_BLOCK = \U00002588
     * LEFT_SEVEN_EIGHTHS_BLOCK = \U00002589
     * LEFT_THREE_QUARTERS_BLOCK = \U0000258A
     * LEFT_FIVE_EIGHTHS_BLOCK = \U0000258B
     * LEFT_HALF_BLOCK = \U0000258C
     * LEFT_THREE_EIGHTHS_BLOCK = \U0000258D
     * LEFT_ONE_QUARTER_BLOCK = \U0000258E
     * LEFT_ONE_EIGHTH_BLOCK = \U0000258F
     * RIGHT_HALF_BLOCK = \U00002590
     * LIGHT_SHADE = \U00002591
     * MEDIUM_SHADE = \U00002592
     * DARK_SHADE = \U00002593
     * UPPER_ONE_EIGHTH_BLOCK = \U00002594
     * RIGHT_ONE_EIGHTH_BLOCK = \U00002595
     * QUADRANT_LOWER_LEFT = \U00002596
     * QUADRANT_LOWER_RIGHT = \U00002597
     * QUADRANT_UPPER_LEFT = \U00002598
     * QUADRANT_UPPER_LEFT_AND_LOWER_LEFT_AND_LOWER_RIGHT = \U00002599
     * QUADRANT_UPPER_LEFT_AND_LOWER_RIGHT = \U0000259A
     * QUADRANT_UPPER_LEFT_AND_UPPER_RIGHT_AND_LOWER_LEFT = \U0000259B
     * QUADRANT_UPPER_LEFT_AND_UPPER_RIGHT_AND_LOWER_RIGHT = \U0000259C
     * QUADRANT_UPPER_RIGHT = \U0000259D
     * QUADRANT_UPPER_RIGHT_AND_LOWER_LEFT = \U0000259E
     * QUADRANT_UPPER_RIGHT_AND_LOWER_LEFT_AND_LOWER_RIGHT = \U0000259F
    """
    UPPER_HALF_BLOCK = "\U00002580"
    LOWER_ONE_EIGHTH_BLOCK = "\U00002581"
    LOWER_ONE_QUARTER_BLOCK = "\U00002582"
    LOWER_THREE_EIGHTHS_BLOCK = "\U00002583"
    LOWER_HALF_BLOCK = "\U00002584"
    LOWER_FIVE_EIGHTHS_BLOCK = "\U00002585"
    LOWER_THREE_QUARTERS_BLOCK = "\U00002586"
    LOWER_SEVEN_EIGHTHS_BLOCK = "\U00002587"
    FULL_BLOCK = "\U00002588"
    LEFT_SEVEN_EIGHTHS_BLOCK = "\U00002589"
    LEFT_THREE_QUARTERS_BLOCK = "\U0000258A"
    LEFT_FIVE_EIGHTHS_BLOCK = "\U0000258B"
    LEFT_HALF_BLOCK = "\U0000258C"
    LEFT_THREE_EIGHTHS_BLOCK = "\U0000258D"
    LEFT_ONE_QUARTER_BLOCK = "\U0000258E"
    LEFT_ONE_EIGHTH_BLOCK = "\U0000258F"
    RIGHT_HALF_BLOCK = "\U00002590"
    LIGHT_SHADE = "\U00002591"
    MEDIUM_SHADE = "\U00002592"
    DARK_SHADE = "\U00002593"
    UPPER_ONE_EIGHTH_BLOCK = "\U00002594"
    RIGHT_ONE_EIGHTH_BLOCK = "\U00002595"
    QUADRANT_LOWER_LEFT = "\U00002596"
    QUADRANT_LOWER_RIGHT = "\U00002597"
    QUADRANT_UPPER_LEFT = "\U00002598"
    QUADRANT_UPPER_LEFT_AND_LOWER_LEFT_AND_LOWER_RIGHT = "\U00002599"
    QUADRANT_UPPER_LEFT_AND_LOWER_RIGHT = "\U0000259A"
    QUADRANT_UPPER_LEFT_AND_UPPER_RIGHT_AND_LOWER_LEFT = "\U0000259B"
    QUADRANT_UPPER_LEFT_AND_UPPER_RIGHT_AND_LOWER_RIGHT = "\U0000259C"
    QUADRANT_UPPER_RIGHT = "\U0000259D"
    QUADRANT_UPPER_RIGHT_AND_LOWER_LEFT = "\U0000259E"
    QUADRANT_UPPER_RIGHT_AND_LOWER_LEFT_AND_LOWER_RIGHT = "\U0000259F"


class GeometricShapes:
    """Geometric shapes elements (unicode)

    Here is the list of supported glyphs:

     * BLACK_SQUARE = \U000025A0
     * BLACK_LARGE_SQUARE = \U00002B1B
     * WHITE_SQUARE = \U000025A1
     * WHITE_SQUARE_WITH_ROUNDED_CORNERS = \U000025A2
     * WHITE_SQUARE_CONTAINING_BLACK_SMALL_SQUARE = \U000025A3
     * SQUARE_WITH_HORIZONTAL_FILL = \U000025A4
     * SQUARE_WITH_VERTICAL_FILL = \U000025A5
     * SQUARE_WITH_ORTHOGONAL_CROSSHATCH_FILL = \U000025A6
     * SQUARE_WITH_UPPER_LEFT_TO_LOWER_RIGHT_FILL = \U000025A7
     * SQUARE_WITH_UPPER_RIGHT_TO_LOWER_LEFT_FILL = \U000025A8
     * SQUARE_WITH_DIAGONAL_CROSSHATCH_FILL = \U000025A9
     * BLACK_SMALL_SQUARE = \U000025AA
     * WHITE_SMALL_SQUARE = \U000025AB
     * BLACK_RECTANGLE = \U000025AC
     * WHITE_RECTANGLE = \U000025AD
     * BLACK_VERTICAL_RECTANGLE = \U000025AE
     * WHITE_VERTICAL_RECTANGLE = \U000025AF
     * BLACK_PARALLELOGRAM = \U000025B0
     * WHITE_PARALLELOGRAM = \U000025B1
     * BLACK_UP_POINTING_TRIANGLE = \U000025B2
     * WHITE_UP_POINTING_TRIANGLE = \U000025B3
     * BLACK_UP_POINTING_SMALL_TRIANGLE = \U000025B4
     * WHITE_UP_POINTING_SMALL_TRIANGLE = \U000025B5
     * BLACK_RIGHT_POINTING_TRIANGLE = \U000025B6
     * WHITE_RIGHT_POINTING_TRIANGLE = \U000025B7
     * BLACK_RIGHT_POINTING_SMALL_TRIANGLE = \U000025B8
     * WHITE_RIGHT_POINTING_SMALL_TRIANGLE = \U000025B9
     * BLACK_RIGHT_POINTING_POINTER = \U000025BA
     * WHITE_RIGHT_POINTING_POINTER = \U000025BB
     * BLACK_DOWN_POINTING_TRIANGLE = \U000025BC
     * WHITE_DOWN_POINTING_TRIANGLE = \U000025BD
     * BLACK_DOWN_POINTING_SMALL_TRIANGLE = \U000025BE
     * WHITE_DOWN_POINTING_SMALL_TRIANGLE = \U000025BF
     * BLACK_LEFT_POINTING_TRIANGLE = \U000025C0
     * WHITE_LEFT_POINTING_TRIANGLE = \U000025C1
     * BLACK_LEFT_POINTING_SMALL_TRIANGLE = \U000025C2
     * WHITE_LEFT_POINTING_SMALL_TRIANGLE = \U000025C3
     * BLACK_LEFT_POINTING_POINTER = \U000025C4
     * WHITE_LEFT_POINTING_POINTER = \U000025C5
     * BLACK_DIAMOND = \U000025C6
     * WHITE_DIAMOND = \U000025C7
     * WHITE_DIAMOND_CONTAINING_BLACK_SMALL_DIAMOND = \U000025C8
     * FISHEYE = \U000025C9
     * LOZENGE = \U000025CA
     * WHITE_CIRCLE = \U000025CB
     * DOTTED_CIRCLE = \U000025CC
     * CIRCLE_WITH_VERTICAL_FILL = \U000025CD
     * BULLSEYE = \U000025CE
     * BLACK_CIRCLE = \U000025CF
     * CIRCLE_WITH_LEFT_HALF_BLACK = \U000025D0
     * CIRCLE_WITH_RIGHT_HALF_BLACK = \U000025D1
     * CIRCLE_WITH_LOWER_HALF_BLACK = \U000025D2
     * CIRCLE_WITH_UPPER_HALF_BLACK = \U000025D3
     * CIRCLE_WITH_UPPER_RIGHT_QUADRANT_BLACK = \U000025D4
     * CIRCLE_WITH_ALL_BUT_UPPER_LEFT_QUADRANT_BLACK = \U000025D5
     * LEFT_HALF_BLACK_CIRCLE = \U000025D6
     * RIGHT_HALF_BLACK_CIRCLE = \U000025D7
     * INVERSE_BULLET = \U000025D8
     * INVERSE_WHITE_CIRCLE = \U000025D9
     * UPPER_HALF_INVERSE_WHITE_CIRCLE = \U000025DA
     * LOWER_HALF_INVERSE_WHITE_CIRCLE = \U000025DB
     * UPPER_LEFT_QUADRANT_CIRCULAR_ARC = \U000025DC
     * UPPER_RIGHT_QUADRANT_CIRCULAR_ARC = \U000025DD
     * LOWER_RIGHT_QUADRANT_CIRCULAR_ARC = \U000025DE
     * LOWER_LEFT_QUADRANT_CIRCULAR_ARC = \U000025DF
     * UPPER_HALF_CIRCLE = \U000025E0
     * LOWER_HALF_CIRCLE = \U000025E1
     * BLACK_LOWER_RIGHT_TRIANGLE = \U000025E2
     * BLACK_LOWER_LEFT_TRIANGLE = \U000025E3
     * BLACK_UPPER_LEFT_TRIANGLE = \U000025E4
     * BLACK_UPPER_RIGHT_TRIANGLE = \U000025E5
     * WHITE_BULLET = \U000025E6
     * BULLET = \U00002022
     * RING_OPERATOR = \U00002218
     * SQUARE_WITH_LEFT_HALF_BLACK = \U000025E7
     * SQUARE_WITH_RIGHT_HALF_BLACK = \U000025E8
     * SQUARE_WITH_UPPER_LEFT_DIAGONAL_HALF_BLACK = \U000025E9
     * SQUARE_WITH_LOWER_RIGHT_DIAGONAL_HALF_BLACK = \U000025EA
     * WHITE_SQUARE_WITH_VERTICAL_BISECTING_LINE = \U000025EB
     * WHITE_UP_POINTING_TRIANGLE_WITH_DOT = \U000025EC
     * UP_POINTING_TRIANGLE_WITH_LEFT_HALF_BLACK = \U000025ED
     * UP_POINTING_TRIANGLE_WITH_RIGHT_HALF_BLACK = \U000025EE
     * LARGE_CIRCLE = \U000025EF
     * WHITE_SQUARE_WITH_UPPER_LEFT_QUADRANT = \U000025F0
     * WHITE_SQUARE_WITH_LOWER_LEFT_QUADRANT = \U000025F1
     * WHITE_SQUARE_WITH_LOWER_RIGHT_QUADRANT = \U000025F2
     * WHITE_SQUARE_WITH_UPPER_RIGHT_QUADRANT = \U000025F3
     * WHITE_CIRCLE_WITH_UPPER_LEFT_QUADRANT = \U000025F4
     * WHITE_CIRCLE_WITH_LOWER_LEFT_QUADRANT = \U000025F5
     * WHITE_CIRCLE_WITH_LOWER_RIGHT_QUADRANT = \U000025F6
     * WHITE_CIRCLE_WITH_UPPER_RIGHT_QUADRANT = \U000025F7
     * UPPER_LEFT_TRIANGLE = \U000025F8
     * UPPER_RIGHT_TRIANGLE = \U000025F9
     * LOWER_LEFT_TRIANGLE = \U000025FA
     * WHITE_MEDIUM_SQUARE = \U000025FB
     * BLACK_MEDIUM_SQUARE = \U000025FC
     * WHITE_MEDIUM_SMALL_SQUARE = \U000025FD
     * BLACK_MEDIUM_SMALL_SQUARE = \U000025FE
     * LOWER_RIGHT_TRIANGLE = \U000025FF
    """

    BLACK_SQUARE = "\U000025A0"
    BLACK_LARGE_SQUARE = "\U00002B1B"
    WHITE_SQUARE = "\U000025A1"
    WHITE_SQUARE_WITH_ROUNDED_CORNERS = "\U000025A2"
    WHITE_SQUARE_CONTAINING_BLACK_SMALL_SQUARE = "\U000025A3"
    SQUARE_WITH_HORIZONTAL_FILL = "\U000025A4"
    SQUARE_WITH_VERTICAL_FILL = "\U000025A5"
    SQUARE_WITH_ORTHOGONAL_CROSSHATCH_FILL = "\U000025A6"
    SQUARE_WITH_UPPER_LEFT_TO_LOWER_RIGHT_FILL = "\U000025A7"
    SQUARE_WITH_UPPER_RIGHT_TO_LOWER_LEFT_FILL = "\U000025A8"
    SQUARE_WITH_DIAGONAL_CROSSHATCH_FILL = "\U000025A9"
    BLACK_SMALL_SQUARE = "\U000025AA"
    WHITE_SMALL_SQUARE = "\U000025AB"
    BLACK_RECTANGLE = "\U000025AC"
    WHITE_RECTANGLE = "\U000025AD"
    BLACK_VERTICAL_RECTANGLE = "\U000025AE"
    WHITE_VERTICAL_RECTANGLE = "\U000025AF"
    BLACK_PARALLELOGRAM = "\U000025B0"
    WHITE_PARALLELOGRAM = "\U000025B1"
    BLACK_UP_POINTING_TRIANGLE = "\U000025B2"
    WHITE_UP_POINTING_TRIANGLE = "\U000025B3"
    BLACK_UP_POINTING_SMALL_TRIANGLE = "\U000025B4"
    WHITE_UP_POINTING_SMALL_TRIANGLE = "\U000025B5"
    BLACK_RIGHT_POINTING_TRIANGLE = "\U000025B6"
    WHITE_RIGHT_POINTING_TRIANGLE = "\U000025B7"
    BLACK_RIGHT_POINTING_SMALL_TRIANGLE = "\U000025B8"
    WHITE_RIGHT_POINTING_SMALL_TRIANGLE = "\U000025B9"
    BLACK_RIGHT_POINTING_POINTER = "\U000025BA"
    WHITE_RIGHT_POINTING_POINTER = "\U000025BB"
    BLACK_DOWN_POINTING_TRIANGLE = "\U000025BC"
    WHITE_DOWN_POINTING_TRIANGLE = "\U000025BD"
    BLACK_DOWN_POINTING_SMALL_TRIANGLE = "\U000025BE"
    WHITE_DOWN_POINTING_SMALL_TRIANGLE = "\U000025BF"
    BLACK_LEFT_POINTING_TRIANGLE = "\U000025C0"
    WHITE_LEFT_POINTING_TRIANGLE = "\U000025C1"
    BLACK_LEFT_POINTING_SMALL_TRIANGLE = "\U000025C2"
    WHITE_LEFT_POINTING_SMALL_TRIANGLE = "\U000025C3"
    BLACK_LEFT_POINTING_POINTER = "\U000025C4"
    WHITE_LEFT_POINTING_POINTER = "\U000025C5"
    BLACK_DIAMOND = "\U000025C6"
    WHITE_DIAMOND = "\U000025C7"
    WHITE_DIAMOND_CONTAINING_BLACK_SMALL_DIAMOND = "\U000025C8"
    FISHEYE = "\U000025C9"
    LOZENGE = "\U000025CA"
    WHITE_CIRCLE = "\U000025CB"
    DOTTED_CIRCLE = "\U000025CC"
    CIRCLE_WITH_VERTICAL_FILL = "\U000025CD"
    BULLSEYE = "\U000025CE"
    BLACK_CIRCLE = "\U000025CF"
    CIRCLE_WITH_LEFT_HALF_BLACK = "\U000025D0"
    CIRCLE_WITH_RIGHT_HALF_BLACK = "\U000025D1"
    CIRCLE_WITH_LOWER_HALF_BLACK = "\U000025D2"
    CIRCLE_WITH_UPPER_HALF_BLACK = "\U000025D3"
    CIRCLE_WITH_UPPER_RIGHT_QUADRANT_BLACK = "\U000025D4"
    CIRCLE_WITH_ALL_BUT_UPPER_LEFT_QUADRANT_BLACK = "\U000025D5"
    LEFT_HALF_BLACK_CIRCLE = "\U000025D6"
    RIGHT_HALF_BLACK_CIRCLE = "\U000025D7"
    INVERSE_BULLET = "\U000025D8"
    INVERSE_WHITE_CIRCLE = "\U000025D9"
    UPPER_HALF_INVERSE_WHITE_CIRCLE = "\U000025DA"
    LOWER_HALF_INVERSE_WHITE_CIRCLE = "\U000025DB"
    UPPER_LEFT_QUADRANT_CIRCULAR_ARC = "\U000025DC"
    UPPER_RIGHT_QUADRANT_CIRCULAR_ARC = "\U000025DD"
    LOWER_RIGHT_QUADRANT_CIRCULAR_ARC = "\U000025DE"
    LOWER_LEFT_QUADRANT_CIRCULAR_ARC = "\U000025DF"
    UPPER_HALF_CIRCLE = "\U000025E0"
    LOWER_HALF_CIRCLE = "\U000025E1"
    BLACK_LOWER_RIGHT_TRIANGLE = "\U000025E2"
    BLACK_LOWER_LEFT_TRIANGLE = "\U000025E3"
    BLACK_UPPER_LEFT_TRIANGLE = "\U000025E4"
    BLACK_UPPER_RIGHT_TRIANGLE = "\U000025E5"
    WHITE_BULLET = "\U000025E6"
    BULLET = "\U00002022"
    RING_OPERATOR = "\U00002218"
    SQUARE_WITH_LEFT_HALF_BLACK = "\U000025E7"
    SQUARE_WITH_RIGHT_HALF_BLACK = "\U000025E8"
    SQUARE_WITH_UPPER_LEFT_DIAGONAL_HALF_BLACK = "\U000025E9"
    SQUARE_WITH_LOWER_RIGHT_DIAGONAL_HALF_BLACK = "\U000025EA"
    WHITE_SQUARE_WITH_VERTICAL_BISECTING_LINE = "\U000025EB"
    WHITE_UP_POINTING_TRIANGLE_WITH_DOT = "\U000025EC"
    UP_POINTING_TRIANGLE_WITH_LEFT_HALF_BLACK = "\U000025ED"
    UP_POINTING_TRIANGLE_WITH_RIGHT_HALF_BLACK = "\U000025EE"
    LARGE_CIRCLE = "\U000025EF"
    WHITE_SQUARE_WITH_UPPER_LEFT_QUADRANT = "\U000025F0"
    WHITE_SQUARE_WITH_LOWER_LEFT_QUADRANT = "\U000025F1"
    WHITE_SQUARE_WITH_LOWER_RIGHT_QUADRANT = "\U000025F2"
    WHITE_SQUARE_WITH_UPPER_RIGHT_QUADRANT = "\U000025F3"
    WHITE_CIRCLE_WITH_UPPER_LEFT_QUADRANT = "\U000025F4"
    WHITE_CIRCLE_WITH_LOWER_LEFT_QUADRANT = "\U000025F5"
    WHITE_CIRCLE_WITH_LOWER_RIGHT_QUADRANT = "\U000025F6"
    WHITE_CIRCLE_WITH_UPPER_RIGHT_QUADRANT = "\U000025F7"
    UPPER_LEFT_TRIANGLE = "\U000025F8"
    UPPER_RIGHT_TRIANGLE = "\U000025F9"
    LOWER_LEFT_TRIANGLE = "\U000025FA"
    WHITE_MEDIUM_SQUARE = "\U000025FB"
    BLACK_MEDIUM_SQUARE = "\U000025FC"
    WHITE_MEDIUM_SMALL_SQUARE = "\U000025FD"
    BLACK_MEDIUM_SMALL_SQUARE = "\U000025FE"
    LOWER_RIGHT_TRIANGLE = "\U000025FF"


class Models:

    """List of models (emojis by unicode denomination)

    Models are filtered emojis. This class  does not map the entire specification.

    Models replaces the previous Sprites class. Renaming that class is necessary with
    the introduction of a real Sprite class in the GFX module.

    This class contains 1328 emojis (this is not the full list).
    All emoji codes come from: https://unicode.org/emoji/charts/full-emoji-list.html
    Additional emojis can be added by codes.

    The complete list of aliased emojis is:

        * GRINNING_FACE = \U0001F600
        * GRINNING_FACE_WITH_BIG_EYES = \U0001F603
        * GRINNING_FACE_WITH_SMILING_EYES = \U0001F604
        * BEAMING_FACE_WITH_SMILING_EYES = \U0001F601
        * GRINNING_SQUINTING_FACE = \U0001F606
        * GRINNING_FACE_WITH_SWEAT = \U0001F605
        * ROLLING_ON_THE_FLOOR_LAUGHING = \U0001F923
        * FACE_WITH_TEARS_OF_JOY = \U0001F602
        * SLIGHTLY_SMILING_FACE = \U0001F642
        * UPSIDE_DOWN_FACE = \U0001F643
        * WINKING_FACE = \U0001F609
        * SMILING_FACE_WITH_SMILING_EYES = \U0001F60A
        * SMILING_FACE_WITH_HALO = \U0001F607
        * SMILING_FACE_WITH_HEARTS = \U0001F970
        * SMILING_FACE_WITH_HEART_EYES = \U0001F60D
        * STAR_STRUCK = \U0001F929
        * FACE_BLOWING_A_KISS = \U0001F618
        * KISSING_FACE = \U0001F617
        * SMILING_FACE = \U0000263A
        * KISSING_FACE_WITH_CLOSED_EYES = \U0001F61A
        * KISSING_FACE_WITH_SMILING_EYES = \U0001F619
        * SMILING_FACE_WITH_TEAR = \U0001F972
        * FACE_SAVORING_FOOD = \U0001F60B
        * FACE_WITH_TONGUE = \U0001F61B
        * WINKING_FACE_WITH_TONGUE = \U0001F61C
        * ZANY_FACE = \U0001F92A
        * SQUINTING_FACE_WITH_TONGUE = \U0001F61D
        * MONEY_MOUTH_FACE = \U0001F911
        * HUGGING_FACE = \U0001F917
        * FACE_WITH_HAND_OVER_MOUTH = \U0001F92D
        * SHUSHING_FACE = \U0001F92B
        * THINKING_FACE = \U0001F914
        * ZIPPER_MOUTH_FACE = \U0001F910
        * FACE_WITH_RAISED_EYEBROW = \U0001F928
        * NEUTRAL_FACE = \U0001F610
        * EXPRESSIONLESS_FACE = \U0001F611
        * FACE_WITHOUT_MOUTH = \U0001F636
        * SMIRKING_FACE = \U0001F60F
        * UNAMUSED_FACE = \U0001F612
        * FACE_WITH_ROLLING_EYES = \U0001F644
        * GRIMACING_FACE = \U0001F62C
        * LYING_FACE = \U0001F925
        * RELIEVED_FACE = \U0001F60C
        * PENSIVE_FACE = \U0001F614
        * SLEEPY_FACE = \U0001F62A
        * DROOLING_FACE = \U0001F924
        * SLEEPING_FACE = \U0001F634
        * FACE_WITH_MEDICAL_MASK = \U0001F637
        * FACE_WITH_THERMOMETER = \U0001F912
        * FACE_WITH_HEAD_BANDAGE = \U0001F915
        * NAUSEATED_FACE = \U0001F922
        * FACE_VOMITING = \U0001F92E
        * SNEEZING_FACE = \U0001F927
        * HOT_FACE = \U0001F975
        * COLD_FACE = \U0001F976
        * WOOZY_FACE = \U0001F974
        * DIZZY_FACE = \U0001F635
        * EXPLODING_HEAD = \U0001F92F
        * COWBOY_HAT_FACE = \U0001F920
        * PARTYING_FACE = \U0001F973
        * DISGUISED_FACE = \U0001F978
        * SMILING_FACE_WITH_SUNGLASSES = \U0001F60E
        * NERD_FACE = \U0001F913
        * FACE_WITH_MONOCLE = \U0001F9D0
        * CONFUSED_FACE = \U0001F615
        * WORRIED_FACE = \U0001F61F
        * SLIGHTLY_FROWNING_FACE = \U0001F641
        * FROWNING_FACE = \U00002639
        * FACE_WITH_OPEN_MOUTH = \U0001F62E
        * HUSHED_FACE = \U0001F62F
        * ASTONISHED_FACE = \U0001F632
        * FLUSHED_FACE = \U0001F633
        * PLEADING_FACE = \U0001F97A
        * FROWNING_FACE_WITH_OPEN_MOUTH = \U0001F626
        * ANGUISHED_FACE = \U0001F627
        * FEARFUL_FACE = \U0001F628
        * ANXIOUS_FACE_WITH_SWEAT = \U0001F630
        * SAD_BUT_RELIEVED_FACE = \U0001F625
        * CRYING_FACE = \U0001F622
        * LOUDLY_CRYING_FACE = \U0001F62D
        * FACE_SCREAMING_IN_FEAR = \U0001F631
        * CONFOUNDED_FACE = \U0001F616
        * PERSEVERING_FACE = \U0001F623
        * DISAPPOINTED_FACE = \U0001F61E
        * DOWNCAST_FACE_WITH_SWEAT = \U0001F613
        * WEARY_FACE = \U0001F629
        * TIRED_FACE = \U0001F62B
        * YAWNING_FACE = \U0001F971
        * FACE_WITH_STEAM_FROM_NOSE = \U0001F624
        * POUTING_FACE = \U0001F621
        * ANGRY_FACE = \U0001F620
        * FACE_WITH_SYMBOLS_ON_MOUTH = \U0001F92C
        * SMILING_FACE_WITH_HORNS = \U0001F608
        * ANGRY_FACE_WITH_HORNS = \U0001F47F
        * SKULL = \U0001F480
        * SKULL_AND_CROSSBONES = \U00002620
        * PILE_OF_POO = \U0001F4A9
        * CLOWN_FACE = \U0001F921
        * OGRE = \U0001F479
        * GOBLIN = \U0001F47A
        * GHOST = \U0001F47B
        * ALIEN = \U0001F47D
        * ALIEN_MONSTER = \U0001F47E
        * ROBOT = \U0001F916
        * GRINNING_CAT = \U0001F63A
        * GRINNING_CAT_WITH_SMILING_EYES = \U0001F638
        * CAT_WITH_TEARS_OF_JOY = \U0001F639
        * SMILING_CAT_WITH_HEART_EYES = \U0001F63B
        * CAT_WITH_WRY_SMILE = \U0001F63C
        * KISSING_CAT = \U0001F63D
        * WEARY_CAT = \U0001F640
        * CRYING_CAT = \U0001F63F
        * POUTING_CAT = \U0001F63E
        * SEE_NO_EVIL_MONKEY = \U0001F648
        * HEAR_NO_EVIL_MONKEY = \U0001F649
        * SPEAK_NO_EVIL_MONKEY = \U0001F64A
        * KISS_MARK = \U0001F48B
        * LOVE_LETTER = \U0001F48C
        * HEART_WITH_ARROW = \U0001F498
        * HEART_WITH_RIBBON = \U0001F49D
        * SPARKLING_HEART = \U0001F496
        * GROWING_HEART = \U0001F497
        * BEATING_HEART = \U0001F493
        * REVOLVING_HEARTS = \U0001F49E
        * TWO_HEARTS = \U0001F495
        * HEART_DECORATION = \U0001F49F
        * HEART_EXCLAMATION = \U00002763
        * BROKEN_HEART = \U0001F494
        * RED_HEART = \U00002764
        * ORANGE_HEART = \U0001F9E1
        * YELLOW_HEART = \U0001F49B
        * GREEN_HEART = \U0001F49A
        * BLUE_HEART = \U0001F499
        * PURPLE_HEART = \U0001F49C
        * BROWN_HEART = \U0001F90E
        * BLACK_HEART = \U0001F5A4
        * WHITE_HEART = \U0001F90D
        * HUNDRED_POINTS = \U0001F4AF
        * ANGER_SYMBOL = \U0001F4A2
        * COLLISION = \U0001F4A5
        * DIZZY = \U0001F4AB
        * SWEAT_DROPLETS = \U0001F4A6
        * DASHING_AWAY = \U0001F4A8
        * HOLE = \U0001F573
        * BOMB = \U0001F4A3
        * SPEECH_BALLOON = \U0001F4AC
        * LEFT_SPEECH_BUBBLE = \U0001F5E8
        * RIGHT_ANGER_BUBBLE = \U0001F5EF
        * THOUGHT_BALLOON = \U0001F4AD
        * ZZZ = \U0001F4A4
        * WAVING_HAND = \U0001F44B
        * RAISED_BACK_OF_HAND = \U0001F91A
        * HAND_WITH_FINGERS_SPLAYED = \U0001F590
        * RAISED_HAND = \U0000270B
        * VULCAN_SALUTE = \U0001F596
        * OK_HAND = \U0001F44C
        * PINCHED_FINGERS = \U0001F90C
        * PINCHING_HAND = \U0001F90F
        * VICTORY_HAND = \U0000270C
        * CROSSED_FINGERS = \U0001F91E
        * LOVE_YOU_GESTURE = \U0001F91F
        * SIGN_OF_THE_HORNS = \U0001F918
        * CALL_ME_HAND = \U0001F919
        * BACKHAND_INDEX_POINTING_LEFT = \U0001F448
        * BACKHAND_INDEX_POINTING_RIGHT = \U0001F449
        * BACKHAND_INDEX_POINTING_UP = \U0001F446
        * MIDDLE_FINGER = \U0001F595
        * BACKHAND_INDEX_POINTING_DOWN = \U0001F447
        * INDEX_POINTING_UP = \U0000261D
        * THUMBS_UP = \U0001F44D
        * THUMBS_DOWN = \U0001F44E
        * RAISED_FIST = \U0000270A
        * ONCOMING_FIST = \U0001F44A
        * LEFT_FACING_FIST = \U0001F91B
        * RIGHT_FACING_FIST = \U0001F91C
        * CLAPPING_HANDS = \U0001F44F
        * RAISING_HANDS = \U0001F64C
        * OPEN_HANDS = \U0001F450
        * PALMS_UP_TOGETHER = \U0001F932
        * HANDSHAKE = \U0001F91D
        * FOLDED_HANDS = \U0001F64F
        * WRITING_HAND = \U0000270D
        * NAIL_POLISH = \U0001F485
        * SELFIE = \U0001F933
        * FLEXED_BICEPS = \U0001F4AA
        * MECHANICAL_ARM = \U0001F9BE
        * MECHANICAL_LEG = \U0001F9BF
        * LEG = \U0001F9B5
        * FOOT = \U0001F9B6
        * EAR = \U0001F442
        * EAR_WITH_HEARING_AID = \U0001F9BB
        * NOSE = \U0001F443
        * BRAIN = \U0001F9E0
        * ANATOMICAL_HEART = \U0001FAC0
        * LUNGS = \U0001FAC1
        * TOOTH = \U0001F9B7
        * BONE = \U0001F9B4
        * EYES = \U0001F440
        * EYE = \U0001F441
        * TONGUE = \U0001F445
        * MOUTH = \U0001F444
        * BABY = \U0001F476
        * CHILD = \U0001F9D2
        * BOY = \U0001F466
        * GIRL = \U0001F467
        * PERSON = \U0001F9D1
        * PERSON_BLOND_HAIR = \U0001F471
        * MAN = \U0001F468
        * MAN_BEARD = \U0001F9D4
        * WOMAN = \U0001F469
        * OLDER_PERSON = \U0001F9D3
        * OLD_MAN = \U0001F474
        * OLD_WOMAN = \U0001F475
        * PERSON_FROWNING = \U0001F64D
        * PERSON_POUTING = \U0001F64E
        * PERSON_GESTURING_NO = \U0001F645
        * PERSON_GESTURING_OK = \U0001F646
        * PERSON_TIPPING_HAND = \U0001F481
        * PERSON_RAISING_HAND = \U0001F64B
        * DEAF_PERSON = \U0001F9CF
        * PERSON_BOWING = \U0001F647
        * PERSON_FACEPALMING = \U0001F926
        * PERSON_SHRUGGING = \U0001F937
        * POLICE_OFFICER = \U0001F46E
        * DETECTIVE = \U0001F575
        * GUARD = \U0001F482
        * NINJA = \U0001F977
        * CONSTRUCTION_WORKER = \U0001F477
        * PRINCE = \U0001F934
        * PRINCESS = \U0001F478
        * PERSON_WEARING_TURBAN = \U0001F473
        * PERSON_WITH_SKULLCAP = \U0001F472
        * WOMAN_WITH_HEADSCARF = \U0001F9D5
        * PERSON_IN_TUXEDO = \U0001F935
        * PERSON_WITH_VEIL = \U0001F470
        * PREGNANT_WOMAN = \U0001F930
        * BREAST_FEEDING = \U0001F931
        * BABY_ANGEL = \U0001F47C
        * SANTA_CLAUS = \U0001F385
        * MRS_CLAUS = \U0001F936
        * SUPERHERO = \U0001F9B8
        * SUPERVILLAIN = \U0001F9B9
        * MAGE = \U0001F9D9
        * FAIRY = \U0001F9DA
        * VAMPIRE = \U0001F9DB
        * MERPERSON = \U0001F9DC
        * ELF = \U0001F9DD
        * GENIE = \U0001F9DE
        * ZOMBIE = \U0001F9DF
        * PERSON_GETTING_MASSAGE = \U0001F486
        * PERSON_GETTING_HAIRCUT = \U0001F487
        * PERSON_WALKING = \U0001F6B6
        * PERSON_STANDING = \U0001F9CD
        * PERSON_KNEELING = \U0001F9CE
        * PERSON_RUNNING = \U0001F3C3
        * WOMAN_DANCING = \U0001F483
        * MAN_DANCING = \U0001F57A
        * PERSON_IN_SUIT_LEVITATING = \U0001F574
        * PEOPLE_WITH_BUNNY_EARS = \U0001F46F
        * PERSON_IN_STEAMY_ROOM = \U0001F9D6
        * PERSON_CLIMBING = \U0001F9D7
        * PERSON_FENCING = \U0001F93A
        * HORSE_RACING = \U0001F3C7
        * SKIER = \U000026F7
        * SNOWBOARDER = \U0001F3C2
        * PERSON_GOLFING = \U0001F3CC
        * PERSON_SURFING = \U0001F3C4
        * PERSON_ROWING_BOAT = \U0001F6A3
        * PERSON_SWIMMING = \U0001F3CA
        * PERSON_BOUNCING_BALL = \U000026F9
        * PERSON_LIFTING_WEIGHTS = \U0001F3CB
        * PERSON_BIKING = \U0001F6B4
        * PERSON_MOUNTAIN_BIKING = \U0001F6B5
        * PERSON_CARTWHEELING = \U0001F938
        * PEOPLE_WRESTLING = \U0001F93C
        * PERSON_PLAYING_WATER_POLO = \U0001F93D
        * PERSON_PLAYING_HANDBALL = \U0001F93E
        * PERSON_JUGGLING = \U0001F939
        * PERSON_IN_LOTUS_POSITION = \U0001F9D8
        * PERSON_TAKING_BATH = \U0001F6C0
        * PERSON_IN_BED = \U0001F6CC
        * WOMEN_HOLDING_HANDS = \U0001F46D
        * WOMAN_AND_MAN_HOLDING_HANDS = \U0001F46B
        * MEN_HOLDING_HANDS = \U0001F46C
        * KISS = \U0001F48F
        * COUPLE_WITH_HEART = \U0001F491
        * FAMILY = \U0001F46A
        * SPEAKING_HEAD = \U0001F5E3
        * BUST_IN_SILHOUETTE = \U0001F464
        * BUSTS_IN_SILHOUETTE = \U0001F465
        * PEOPLE_HUGGING = \U0001FAC2
        * FOOTPRINTS = \U0001F463
        * LIGHT_SKIN_TONE = \U0001F3FB
        * MEDIUM_LIGHT_SKIN_TONE = \U0001F3FC
        * MEDIUM_SKIN_TONE = \U0001F3FD
        * MEDIUM_DARK_SKIN_TONE = \U0001F3FE
        * DARK_SKIN_TONE = \U0001F3FF
        * RED_HAIR = \U0001F9B0
        * CURLY_HAIR = \U0001F9B1
        * WHITE_HAIR = \U0001F9B3
        * BALD = \U0001F9B2
        * MONKEY_FACE = \U0001F435
        * MONKEY = \U0001F412
        * GORILLA = \U0001F98D
        * ORANGUTAN = \U0001F9A7
        * DOG_FACE = \U0001F436
        * DOG = \U0001F415
        * GUIDE_DOG = \U0001F9AE
        * POODLE = \U0001F429
        * WOLF = \U0001F43A
        * FOX = \U0001F98A
        * RACCOON = \U0001F99D
        * CAT_FACE = \U0001F431
        * CAT = \U0001F408
        * LION = \U0001F981
        * TIGER_FACE = \U0001F42F
        * TIGER = \U0001F405
        * LEOPARD = \U0001F406
        * HORSE_FACE = \U0001F434
        * HORSE = \U0001F40E
        * UNICORN = \U0001F984
        * ZEBRA = \U0001F993
        * DEER = \U0001F98C
        * BISON = \U0001F9AC
        * COW_FACE = \U0001F42E
        * OX = \U0001F402
        * WATER_BUFFALO = \U0001F403
        * COW = \U0001F404
        * PIG_FACE = \U0001F437
        * PIG = \U0001F416
        * BOAR = \U0001F417
        * PIG_NOSE = \U0001F43D
        * RAM = \U0001F40F
        * EWE = \U0001F411
        * GOAT = \U0001F410
        * CAMEL = \U0001F42A
        * TWO_HUMP_CAMEL = \U0001F42B
        * LLAMA = \U0001F999
        * GIRAFFE = \U0001F992
        * ELEPHANT = \U0001F418
        * MAMMOTH = \U0001F9A3
        * RHINOCEROS = \U0001F98F
        * HIPPOPOTAMUS = \U0001F99B
        * MOUSE_FACE = \U0001F42D
        * MOUSE = \U0001F401
        * RAT = \U0001F400
        * HAMSTER = \U0001F439
        * RABBIT_FACE = \U0001F430
        * RABBIT = \U0001F407
        * CHIPMUNK = \U0001F43F
        * BEAVER = \U0001F9AB
        * HEDGEHOG = \U0001F994
        * BAT = \U0001F987
        * BEAR = \U0001F43B
        * KOALA = \U0001F428
        * PANDA = \U0001F43C
        * SLOTH = \U0001F9A5
        * OTTER = \U0001F9A6
        * SKUNK = \U0001F9A8
        * KANGAROO = \U0001F998
        * BADGER = \U0001F9A1
        * PAW_PRINTS = \U0001F43E
        * TURKEY = \U0001F983
        * CHICKEN = \U0001F414
        * ROOSTER = \U0001F413
        * HATCHING_CHICK = \U0001F423
        * BABY_CHICK = \U0001F424
        * FRONT_FACING_BABY_CHICK = \U0001F425
        * BIRD = \U0001F426
        * PENGUIN = \U0001F427
        * DOVE = \U0001F54A
        * EAGLE = \U0001F985
        * DUCK = \U0001F986
        * SWAN = \U0001F9A2
        * OWL = \U0001F989
        * DODO = \U0001F9A4
        * FEATHER = \U0001FAB6
        * FLAMINGO = \U0001F9A9
        * PEACOCK = \U0001F99A
        * PARROT = \U0001F99C
        * FROG = \U0001F438
        * CROCODILE = \U0001F40A
        * TURTLE = \U0001F422
        * LIZARD = \U0001F98E
        * SNAKE = \U0001F40D
        * DRAGON_FACE = \U0001F432
        * DRAGON = \U0001F409
        * SAUROPOD = \U0001F995
        * T_REX = \U0001F996
        * SPOUTING_WHALE = \U0001F433
        * WHALE = \U0001F40B
        * DOLPHIN = \U0001F42C
        * SEAL = \U0001F9AD
        * FISH = \U0001F41F
        * TROPICAL_FISH = \U0001F420
        * BLOWFISH = \U0001F421
        * SHARK = \U0001F988
        * OCTOPUS = \U0001F419
        * SPIRAL_SHELL = \U0001F41A
        * SNAIL = \U0001F40C
        * BUTTERFLY = \U0001F98B
        * BUG = \U0001F41B
        * ANT = \U0001F41C
        * HONEYBEE = \U0001F41D
        * BEETLE = \U0001FAB2
        * LADY_BEETLE = \U0001F41E
        * CRICKET = \U0001F997
        * COCKROACH = \U0001FAB3
        * SPIDER = \U0001F577
        * SPIDER_WEB = \U0001F578
        * SCORPION = \U0001F982
        * MOSQUITO = \U0001F99F
        * FLY = \U0001FAB0
        * WORM = \U0001FAB1
        * MICROBE = \U0001F9A0
        * BOUQUET = \U0001F490
        * CHERRY_BLOSSOM = \U0001F338
        * WHITE_FLOWER = \U0001F4AE
        * ROSETTE = \U0001F3F5
        * ROSE = \U0001F339
        * WILTED_FLOWER = \U0001F940
        * HIBISCUS = \U0001F33A
        * SUNFLOWER = \U0001F33B
        * BLOSSOM = \U0001F33C
        * TULIP = \U0001F337
        * SEEDLING = \U0001F331
        * POTTED_PLANT = \U0001FAB4
        * EVERGREEN_TREE = \U0001F332
        * DECIDUOUS_TREE = \U0001F333
        * PALM_TREE = \U0001F334
        * CACTUS = \U0001F335
        * SHEAF_OF_RICE = \U0001F33E
        * HERB = \U0001F33F
        * SHAMROCK = \U00002618
        * FOUR_LEAF_CLOVER = \U0001F340
        * MAPLE_LEAF = \U0001F341
        * FALLEN_LEAF = \U0001F342
        * LEAF_FLUTTERING_IN_WIND = \U0001F343
        * GRAPES = \U0001F347
        * MELON = \U0001F348
        * WATERMELON = \U0001F349
        * TANGERINE = \U0001F34A
        * LEMON = \U0001F34B
        * BANANA = \U0001F34C
        * PINEAPPLE = \U0001F34D
        * MANGO = \U0001F96D
        * RED_APPLE = \U0001F34E
        * GREEN_APPLE = \U0001F34F
        * PEAR = \U0001F350
        * PEACH = \U0001F351
        * CHERRIES = \U0001F352
        * STRAWBERRY = \U0001F353
        * BLUEBERRIES = \U0001FAD0
        * KIWI_FRUIT = \U0001F95D
        * TOMATO = \U0001F345
        * OLIVE = \U0001FAD2
        * COCONUT = \U0001F965
        * AVOCADO = \U0001F951
        * EGGPLANT = \U0001F346
        * POTATO = \U0001F954
        * CARROT = \U0001F955
        * EAR_OF_CORN = \U0001F33D
        * HOT_PEPPER = \U0001F336
        * BELL_PEPPER = \U0001FAD1
        * CUCUMBER = \U0001F952
        * LEAFY_GREEN = \U0001F96C
        * BROCCOLI = \U0001F966
        * GARLIC = \U0001F9C4
        * ONION = \U0001F9C5
        * MUSHROOM = \U0001F344
        * PEANUTS = \U0001F95C
        * CHESTNUT = \U0001F330
        * BREAD = \U0001F35E
        * CROISSANT = \U0001F950
        * BAGUETTE_BREAD = \U0001F956
        * FLATBREAD = \U0001FAD3
        * PRETZEL = \U0001F968
        * BAGEL = \U0001F96F
        * PANCAKES = \U0001F95E
        * WAFFLE = \U0001F9C7
        * CHEESE_WEDGE = \U0001F9C0
        * MEAT_ON_BONE = \U0001F356
        * POULTRY_LEG = \U0001F357
        * CUT_OF_MEAT = \U0001F969
        * BACON = \U0001F953
        * HAMBURGER = \U0001F354
        * FRENCH_FRIES = \U0001F35F
        * PIZZA = \U0001F355
        * HOT_DOG = \U0001F32D
        * SANDWICH = \U0001F96A
        * TACO = \U0001F32E
        * BURRITO = \U0001F32F
        * TAMALE = \U0001FAD4
        * STUFFED_FLATBREAD = \U0001F959
        * FALAFEL = \U0001F9C6
        * EGG = \U0001F95A
        * COOKING = \U0001F373
        * SHALLOW_PAN_OF_FOOD = \U0001F958
        * POT_OF_FOOD = \U0001F372
        * FONDUE = \U0001FAD5
        * BOWL_WITH_SPOON = \U0001F963
        * GREEN_SALAD = \U0001F957
        * POPCORN = \U0001F37F
        * BUTTER = \U0001F9C8
        * SALT = \U0001F9C2
        * CANNED_FOOD = \U0001F96B
        * BENTO_BOX = \U0001F371
        * RICE_CRACKER = \U0001F358
        * RICE_BALL = \U0001F359
        * COOKED_RICE = \U0001F35A
        * CURRY_RICE = \U0001F35B
        * STEAMING_BOWL = \U0001F35C
        * SPAGHETTI = \U0001F35D
        * ROASTED_SWEET_POTATO = \U0001F360
        * ODEN = \U0001F362
        * SUSHI = \U0001F363
        * FRIED_SHRIMP = \U0001F364
        * FISH_CAKE_WITH_SWIRL = \U0001F365
        * MOON_CAKE = \U0001F96E
        * DANGO = \U0001F361
        * DUMPLING = \U0001F95F
        * FORTUNE_COOKIE = \U0001F960
        * TAKEOUT_BOX = \U0001F961
        * CRAB = \U0001F980
        * LOBSTER = \U0001F99E
        * SHRIMP = \U0001F990
        * SQUID = \U0001F991
        * OYSTER = \U0001F9AA
        * SOFT_ICE_CREAM = \U0001F366
        * SHAVED_ICE = \U0001F367
        * ICE_CREAM = \U0001F368
        * DOUGHNUT = \U0001F369
        * COOKIE = \U0001F36A
        * BIRTHDAY_CAKE = \U0001F382
        * SHORTCAKE = \U0001F370
        * CUPCAKE = \U0001F9C1
        * PIE = \U0001F967
        * CHOCOLATE_BAR = \U0001F36B
        * CANDY = \U0001F36C
        * LOLLIPOP = \U0001F36D
        * CUSTARD = \U0001F36E
        * HONEY_POT = \U0001F36F
        * BABY_BOTTLE = \U0001F37C
        * GLASS_OF_MILK = \U0001F95B
        * HOT_BEVERAGE = \U00002615
        * TEAPOT = \U0001FAD6
        * TEACUP_WITHOUT_HANDLE = \U0001F375
        * SAKE = \U0001F376
        * BOTTLE_WITH_POPPING_CORK = \U0001F37E
        * WINE_GLASS = \U0001F377
        * COCKTAIL_GLASS = \U0001F378
        * TROPICAL_DRINK = \U0001F379
        * BEER_MUG = \U0001F37A
        * CLINKING_BEER_MUGS = \U0001F37B
        * CLINKING_GLASSES = \U0001F942
        * TUMBLER_GLASS = \U0001F943
        * CUP_WITH_STRAW = \U0001F964
        * BUBBLE_TEA = \U0001F9CB
        * BEVERAGE_BOX = \U0001F9C3
        * MATE = \U0001F9C9
        * ICE = \U0001F9CA
        * CHOPSTICKS = \U0001F962
        * FORK_AND_KNIFE_WITH_PLATE = \U0001F37D
        * FORK_AND_KNIFE = \U0001F374
        * SPOON = \U0001F944
        * KITCHEN_KNIFE = \U0001F52A
        * AMPHORA = \U0001F3FA
        * GLOBE_SHOWING_EUROPE_AFRICA = \U0001F30D
        * GLOBE_SHOWING_AMERICAS = \U0001F30E
        * GLOBE_SHOWING_ASIA_AUSTRALIA = \U0001F30F
        * GLOBE_WITH_MERIDIANS = \U0001F310
        * WORLD_MAP = \U0001F5FA
        * MAP_OF_JAPAN = \U0001F5FE
        * COMPASS = \U0001F9ED
        * SNOW_CAPPED_MOUNTAIN = \U0001F3D4
        * MOUNTAIN = \U000026F0
        * VOLCANO = \U0001F30B
        * MOUNT_FUJI = \U0001F5FB
        * CAMPING = \U0001F3D5
        * BEACH_WITH_UMBRELLA = \U0001F3D6
        * DESERT = \U0001F3DC
        * DESERT_ISLAND = \U0001F3DD
        * NATIONAL_PARK = \U0001F3DE
        * STADIUM = \U0001F3DF
        * CLASSICAL_BUILDING = \U0001F3DB
        * BUILDING_CONSTRUCTION = \U0001F3D7
        * BRICK = \U0001F9F1
        * ROCK = \U0001FAA8
        * WOOD = \U0001FAB5
        * HUT = \U0001F6D6
        * HOUSES = \U0001F3D8
        * DERELICT_HOUSE = \U0001F3DA
        * HOUSE = \U0001F3E0
        * HOUSE_WITH_GARDEN = \U0001F3E1
        * OFFICE_BUILDING = \U0001F3E2
        * JAPANESE_POST_OFFICE = \U0001F3E3
        * POST_OFFICE = \U0001F3E4
        * HOSPITAL = \U0001F3E5
        * BANK = \U0001F3E6
        * HOTEL = \U0001F3E8
        * LOVE_HOTEL = \U0001F3E9
        * CONVENIENCE_STORE = \U0001F3EA
        * SCHOOL = \U0001F3EB
        * DEPARTMENT_STORE = \U0001F3EC
        * FACTORY = \U0001F3ED
        * JAPANESE_CASTLE = \U0001F3EF
        * CASTLE = \U0001F3F0
        * WEDDING = \U0001F492
        * TOKYO_TOWER = \U0001F5FC
        * STATUE_OF_LIBERTY = \U0001F5FD
        * CHURCH = \U000026EA
        * MOSQUE = \U0001F54C
        * HINDU_TEMPLE = \U0001F6D5
        * SYNAGOGUE = \U0001F54D
        * SHINTO_SHRINE = \U000026E9
        * KAABA = \U0001F54B
        * FOUNTAIN = \U000026F2
        * TENT = \U000026FA
        * FOGGY = \U0001F301
        * NIGHT_WITH_STARS = \U0001F303
        * CITYSCAPE = \U0001F3D9
        * SUNRISE_OVER_MOUNTAINS = \U0001F304
        * SUNRISE = \U0001F305
        * CITYSCAPE_AT_DUSK = \U0001F306
        * SUNSET = \U0001F307
        * BRIDGE_AT_NIGHT = \U0001F309
        * HOT_SPRINGS = \U00002668
        * CAROUSEL_HORSE = \U0001F3A0
        * FERRIS_WHEEL = \U0001F3A1
        * ROLLER_COASTER = \U0001F3A2
        * BARBER_POLE = \U0001F488
        * CIRCUS_TENT = \U0001F3AA
        * LOCOMOTIVE = \U0001F682
        * RAILWAY_CAR = \U0001F683
        * HIGH_SPEED_TRAIN = \U0001F684
        * BULLET_TRAIN = \U0001F685
        * TRAIN = \U0001F686
        * METRO = \U0001F687
        * LIGHT_RAIL = \U0001F688
        * STATION = \U0001F689
        * TRAM = \U0001F68A
        * MONORAIL = \U0001F69D
        * MOUNTAIN_RAILWAY = \U0001F69E
        * TRAM_CAR = \U0001F68B
        * BUS = \U0001F68C
        * ONCOMING_BUS = \U0001F68D
        * TROLLEYBUS = \U0001F68E
        * MINIBUS = \U0001F690
        * AMBULANCE = \U0001F691
        * FIRE_ENGINE = \U0001F692
        * POLICE_CAR = \U0001F693
        * ONCOMING_POLICE_CAR = \U0001F694
        * TAXI = \U0001F695
        * ONCOMING_TAXI = \U0001F696
        * AUTOMOBILE = \U0001F697
        * ONCOMING_AUTOMOBILE = \U0001F698
        * SPORT_UTILITY_VEHICLE = \U0001F699
        * PICKUP_TRUCK = \U0001F6FB
        * DELIVERY_TRUCK = \U0001F69A
        * ARTICULATED_LORRY = \U0001F69B
        * TRACTOR = \U0001F69C
        * RACING_CAR = \U0001F3CE
        * MOTORCYCLE = \U0001F3CD
        * MOTOR_SCOOTER = \U0001F6F5
        * MANUAL_WHEELCHAIR = \U0001F9BD
        * MOTORIZED_WHEELCHAIR = \U0001F9BC
        * AUTO_RICKSHAW = \U0001F6FA
        * BICYCLE = \U0001F6B2
        * KICK_SCOOTER = \U0001F6F4
        * SKATEBOARD = \U0001F6F9
        * ROLLER_SKATE = \U0001F6FC
        * BUS_STOP = \U0001F68F
        * MOTORWAY = \U0001F6E3
        * RAILWAY_TRACK = \U0001F6E4
        * OIL_DRUM = \U0001F6E2
        * FUEL_PUMP = \U000026FD
        * POLICE_CAR_LIGHT = \U0001F6A8
        * HORIZONTAL_TRAFFIC_LIGHT = \U0001F6A5
        * VERTICAL_TRAFFIC_LIGHT = \U0001F6A6
        * STOP_SIGN = \U0001F6D1
        * CONSTRUCTION = \U0001F6A7
        * ANCHOR = \U00002693
        * SAILBOAT = \U000026F5
        * CANOE = \U0001F6F6
        * SPEEDBOAT = \U0001F6A4
        * PASSENGER_SHIP = \U0001F6F3
        * FERRY = \U000026F4
        * MOTOR_BOAT = \U0001F6E5
        * SHIP = \U0001F6A2
        * AIRPLANE = \U00002708
        * SMALL_AIRPLANE = \U0001F6E9
        * AIRPLANE_DEPARTURE = \U0001F6EB
        * AIRPLANE_ARRIVAL = \U0001F6EC
        * PARACHUTE = \U0001FA82
        * SEAT = \U0001F4BA
        * HELICOPTER = \U0001F681
        * SUSPENSION_RAILWAY = \U0001F69F
        * MOUNTAIN_CABLEWAY = \U0001F6A0
        * AERIAL_TRAMWAY = \U0001F6A1
        * SATELLITE = \U0001F6F0
        * ROCKET = \U0001F680
        * FLYING_SAUCER = \U0001F6F8
        * BELLHOP_BELL = \U0001F6CE
        * LUGGAGE = \U0001F9F3
        * HOURGLASS_DONE = \U0000231B
        * HOURGLASS_NOT_DONE = \U000023F3
        * WATCH = \U0000231A
        * ALARM_CLOCK = \U000023F0
        * STOPWATCH = \U000023F1
        * TIMER_CLOCK = \U000023F2
        * MANTELPIECE_CLOCK = \U0001F570
        * TWELVE_OCLOCK = \U0001F55B
        * TWELVE_THIRTY = \U0001F567
        * ONE_OCLOCK = \U0001F550
        * ONE_THIRTY = \U0001F55C
        * TWO_OCLOCK = \U0001F551
        * TWO_THIRTY = \U0001F55D
        * THREE_OCLOCK = \U0001F552
        * THREE_THIRTY = \U0001F55E
        * FOUR_OCLOCK = \U0001F553
        * FOUR_THIRTY = \U0001F55F
        * FIVE_OCLOCK = \U0001F554
        * FIVE_THIRTY = \U0001F560
        * SIX_OCLOCK = \U0001F555
        * SIX_THIRTY = \U0001F561
        * SEVEN_OCLOCK = \U0001F556
        * SEVEN_THIRTY = \U0001F562
        * EIGHT_OCLOCK = \U0001F557
        * EIGHT_THIRTY = \U0001F563
        * NINE_OCLOCK = \U0001F558
        * NINE_THIRTY = \U0001F564
        * TEN_OCLOCK = \U0001F559
        * TEN_THIRTY = \U0001F565
        * ELEVEN_OCLOCK = \U0001F55A
        * ELEVEN_THIRTY = \U0001F566
        * NEW_MOON = \U0001F311
        * WAXING_CRESCENT_MOON = \U0001F312
        * FIRST_QUARTER_MOON = \U0001F313
        * WAXING_GIBBOUS_MOON = \U0001F314
        * FULL_MOON = \U0001F315
        * WANING_GIBBOUS_MOON = \U0001F316
        * LAST_QUARTER_MOON = \U0001F317
        * WANING_CRESCENT_MOON = \U0001F318
        * CRESCENT_MOON = \U0001F319
        * NEW_MOON_FACE = \U0001F31A
        * FIRST_QUARTER_MOON_FACE = \U0001F31B
        * LAST_QUARTER_MOON_FACE = \U0001F31C
        * THERMOMETER = \U0001F321
        * SUN = \U00002600
        * FULL_MOON_FACE = \U0001F31D
        * SUN_WITH_FACE = \U0001F31E
        * RINGED_PLANET = \U0001FA90
        * STAR = \U00002B50
        * GLOWING_STAR = \U0001F31F
        * SHOOTING_STAR = \U0001F320
        * MILKY_WAY = \U0001F30C
        * CLOUD = \U00002601
        * SUN_BEHIND_CLOUD = \U000026C5
        * CLOUD_WITH_LIGHTNING_AND_RAIN = \U000026C8
        * SUN_BEHIND_SMALL_CLOUD = \U0001F324
        * SUN_BEHIND_LARGE_CLOUD = \U0001F325
        * SUN_BEHIND_RAIN_CLOUD = \U0001F326
        * CLOUD_WITH_RAIN = \U0001F327
        * CLOUD_WITH_SNOW = \U0001F328
        * CLOUD_WITH_LIGHTNING = \U0001F329
        * TORNADO = \U0001F32A
        * FOG = \U0001F32B
        * WIND_FACE = \U0001F32C
        * CYCLONE = \U0001F300
        * RAINBOW = \U0001F308
        * CLOSED_UMBRELLA = \U0001F302
        * UMBRELLA = \U00002602
        * UMBRELLA_WITH_RAIN_DROPS = \U00002614
        * UMBRELLA_ON_GROUND = \U000026F1
        * HIGH_VOLTAGE = \U000026A1
        * SNOWFLAKE = \U00002744
        * SNOWMAN = \U00002603
        * SNOWMAN_WITHOUT_SNOW = \U000026C4
        * COMET = \U00002604
        * FIRE = \U0001F525
        * DROPLET = \U0001F4A7
        * WATER_WAVE = \U0001F30A
        * JACK_O_LANTERN = \U0001F383
        * CHRISTMAS_TREE = \U0001F384
        * FIREWORKS = \U0001F386
        * SPARKLER = \U0001F387
        * FIRECRACKER = \U0001F9E8
        * SPARKLES = \U00002728
        * BALLOON = \U0001F388
        * PARTY_POPPER = \U0001F389
        * CONFETTI_BALL = \U0001F38A
        * TANABATA_TREE = \U0001F38B
        * PINE_DECORATION = \U0001F38D
        * JAPANESE_DOLLS = \U0001F38E
        * CARP_STREAMER = \U0001F38F
        * WIND_CHIME = \U0001F390
        * MOON_VIEWING_CEREMONY = \U0001F391
        * RED_ENVELOPE = \U0001F9E7
        * RIBBON = \U0001F380
        * WRAPPED_GIFT = \U0001F381
        * REMINDER_RIBBON = \U0001F397
        * ADMISSION_TICKETS = \U0001F39F
        * TICKET = \U0001F3AB
        * MILITARY_MEDAL = \U0001F396
        * TROPHY = \U0001F3C6
        * SPORTS_MEDAL = \U0001F3C5
        * FIRST_PLACE_MEDAL = \U0001F947
        * SECOND_PLACE_MEDAL = \U0001F948
        * THIRD_PLACE_MEDAL = \U0001F949
        * SOCCER_BALL = \U000026BD
        * BASEBALL = \U000026BE
        * SOFTBALL = \U0001F94E
        * BASKETBALL = \U0001F3C0
        * VOLLEYBALL = \U0001F3D0
        * AMERICAN_FOOTBALL = \U0001F3C8
        * RUGBY_FOOTBALL = \U0001F3C9
        * TENNIS = \U0001F3BE
        * FLYING_DISC = \U0001F94F
        * BOWLING = \U0001F3B3
        * CRICKET_GAME = \U0001F3CF
        * FIELD_HOCKEY = \U0001F3D1
        * ICE_HOCKEY = \U0001F3D2
        * LACROSSE = \U0001F94D
        * PING_PONG = \U0001F3D3
        * BADMINTON = \U0001F3F8
        * BOXING_GLOVE = \U0001F94A
        * MARTIAL_ARTS_UNIFORM = \U0001F94B
        * GOAL_NET = \U0001F945
        * FLAG_IN_HOLE = \U000026F3
        * ICE_SKATE = \U000026F8
        * FISHING_POLE = \U0001F3A3
        * DIVING_MASK = \U0001F93F
        * RUNNING_SHIRT = \U0001F3BD
        * SKIS = \U0001F3BF
        * SLED = \U0001F6F7
        * CURLING_STONE = \U0001F94C
        * DIRECT_HIT = \U0001F3AF
        * YO_YO = \U0001FA80
        * KITE = \U0001FA81
        * BALL = \U0001F3B1
        * CRYSTAL_BALL = \U0001F52E
        * MAGIC_WAND = \U0001FA84
        * NAZAR_AMULET = \U0001F9FF
        * VIDEO_GAME = \U0001F3AE
        * JOYSTICK = \U0001F579
        * SLOT_MACHINE = \U0001F3B0
        * GAME_DIE = \U0001F3B2
        * PUZZLE_PIECE = \U0001F9E9
        * TEDDY_BEAR = \U0001F9F8
        * PIñATA = \U0001FA85
        * NESTING_DOLLS = \U0001FA86
        * SPADE_SUIT = \U00002660
        * HEART_SUIT = \U00002665
        * DIAMOND_SUIT = \U00002666
        * CLUB_SUIT = \U00002663
        * CHESS_PAWN = \U0000265F
        * JOKER = \U0001F0CF
        * MAHJONG_RED_DRAGON = \U0001F004
        * FLOWER_PLAYING_CARDS = \U0001F3B4
        * PERFORMING_ARTS = \U0001F3AD
        * FRAMED_PICTURE = \U0001F5BC
        * ARTIST_PALETTE = \U0001F3A8
        * THREAD = \U0001F9F5
        * SEWING_NEEDLE = \U0001FAA1
        * YARN = \U0001F9F6
        * KNOT = \U0001FAA2
        * GLASSES = \U0001F453
        * SUNGLASSES = \U0001F576
        * GOGGLES = \U0001F97D
        * LAB_COAT = \U0001F97C
        * SAFETY_VEST = \U0001F9BA
        * NECKTIE = \U0001F454
        * T_SHIRT = \U0001F455
        * JEANS = \U0001F456
        * SCARF = \U0001F9E3
        * GLOVES = \U0001F9E4
        * COAT = \U0001F9E5
        * SOCKS = \U0001F9E6
        * DRESS = \U0001F457
        * KIMONO = \U0001F458
        * SARI = \U0001F97B
        * ONE_PIECE_SWIMSUIT = \U0001FA71
        * BRIEFS = \U0001FA72
        * SHORTS = \U0001FA73
        * BIKINI = \U0001F459
        * WOMANS_CLOTHES = \U0001F45A
        * PURSE = \U0001F45B
        * HANDBAG = \U0001F45C
        * CLUTCH_BAG = \U0001F45D
        * SHOPPING_BAGS = \U0001F6CD
        * BACKPACK = \U0001F392
        * THONG_SANDAL = \U0001FA74
        * MANS_SHOE = \U0001F45E
        * RUNNING_SHOE = \U0001F45F
        * HIKING_BOOT = \U0001F97E
        * FLAT_SHOE = \U0001F97F
        * HIGH_HEELED_SHOE = \U0001F460
        * WOMANS_SANDAL = \U0001F461
        * BALLET_SHOES = \U0001FA70
        * WOMANS_BOOT = \U0001F462
        * CROWN = \U0001F451
        * WOMANS_HAT = \U0001F452
        * TOP_HAT = \U0001F3A9
        * GRADUATION_CAP = \U0001F393
        * BILLED_CAP = \U0001F9E2
        * MILITARY_HELMET = \U0001FA96
        * RESCUE_WORKERS_HELMET = \U000026D1
        * PRAYER_BEADS = \U0001F4FF
        * LIPSTICK = \U0001F484
        * RING = \U0001F48D
        * GEM_STONE = \U0001F48E
        * MUTED_SPEAKER = \U0001F507
        * SPEAKER_LOW_VOLUME = \U0001F508
        * SPEAKER_MEDIUM_VOLUME = \U0001F509
        * SPEAKER_HIGH_VOLUME = \U0001F50A
        * LOUDSPEAKER = \U0001F4E2
        * MEGAPHONE = \U0001F4E3
        * POSTAL_HORN = \U0001F4EF
        * BELL = \U0001F514
        * BELL_WITH_SLASH = \U0001F515
        * MUSICAL_SCORE = \U0001F3BC
        * MUSICAL_NOTE = \U0001F3B5
        * MUSICAL_NOTES = \U0001F3B6
        * STUDIO_MICROPHONE = \U0001F399
        * LEVEL_SLIDER = \U0001F39A
        * CONTROL_KNOBS = \U0001F39B
        * MICROPHONE = \U0001F3A4
        * HEADPHONE = \U0001F3A7
        * RADIO = \U0001F4FB
        * SAXOPHONE = \U0001F3B7
        * ACCORDION = \U0001FA97
        * GUITAR = \U0001F3B8
        * MUSICAL_KEYBOARD = \U0001F3B9
        * TRUMPET = \U0001F3BA
        * VIOLIN = \U0001F3BB
        * BANJO = \U0001FA95
        * DRUM = \U0001F941
        * LONG_DRUM = \U0001FA98
        * MOBILE_PHONE = \U0001F4F1
        * MOBILE_PHONE_WITH_ARROW = \U0001F4F2
        * TELEPHONE = \U0000260E
        * TELEPHONE_RECEIVER = \U0001F4DE
        * PAGER = \U0001F4DF
        * FAX_MACHINE = \U0001F4E0
        * BATTERY = \U0001F50B
        * ELECTRIC_PLUG = \U0001F50C
        * LAPTOP = \U0001F4BB
        * DESKTOP_COMPUTER = \U0001F5A5
        * PRINTER = \U0001F5A8
        * KEYBOARD = \U00002328
        * COMPUTER_MOUSE = \U0001F5B1
        * TRACKBALL = \U0001F5B2
        * COMPUTER_DISK = \U0001F4BD
        * FLOPPY_DISK = \U0001F4BE
        * OPTICAL_DISK = \U0001F4BF
        * DVD = \U0001F4C0
        * ABACUS = \U0001F9EE
        * MOVIE_CAMERA = \U0001F3A5
        * FILM_FRAMES = \U0001F39E
        * FILM_PROJECTOR = \U0001F4FD
        * CLAPPER_BOARD = \U0001F3AC
        * TELEVISION = \U0001F4FA
        * CAMERA = \U0001F4F7
        * CAMERA_WITH_FLASH = \U0001F4F8
        * VIDEO_CAMERA = \U0001F4F9
        * VIDEOCASSETTE = \U0001F4FC
        * MAGNIFYING_GLASS_TILTED_LEFT = \U0001F50D
        * MAGNIFYING_GLASS_TILTED_RIGHT = \U0001F50E
        * CANDLE = \U0001F56F
        * LIGHT_BULB = \U0001F4A1
        * FLASHLIGHT = \U0001F526
        * RED_PAPER_LANTERN = \U0001F3EE
        * DIYA_LAMP = \U0001FA94
        * NOTEBOOK_WITH_DECORATIVE_COVER = \U0001F4D4
        * CLOSED_BOOK = \U0001F4D5
        * OPEN_BOOK = \U0001F4D6
        * GREEN_BOOK = \U0001F4D7
        * BLUE_BOOK = \U0001F4D8
        * ORANGE_BOOK = \U0001F4D9
        * BOOKS = \U0001F4DA
        * NOTEBOOK = \U0001F4D3
        * LEDGER = \U0001F4D2
        * PAGE_WITH_CURL = \U0001F4C3
        * SCROLL = \U0001F4DC
        * PAGE_FACING_UP = \U0001F4C4
        * NEWSPAPER = \U0001F4F0
        * ROLLED_UP_NEWSPAPER = \U0001F5DE
        * BOOKMARK_TABS = \U0001F4D1
        * BOOKMARK = \U0001F516
        * LABEL = \U0001F3F7
        * MONEY_BAG = \U0001F4B0
        * COIN = \U0001FA99
        * YEN_BANKNOTE = \U0001F4B4
        * DOLLAR_BANKNOTE = \U0001F4B5
        * EURO_BANKNOTE = \U0001F4B6
        * POUND_BANKNOTE = \U0001F4B7
        * MONEY_WITH_WINGS = \U0001F4B8
        * CREDIT_CARD = \U0001F4B3
        * RECEIPT = \U0001F9FE
        * CHART_INCREASING_WITH_YEN = \U0001F4B9
        * ENVELOPE = \U00002709
        * E_MAIL = \U0001F4E7
        * INCOMING_ENVELOPE = \U0001F4E8
        * ENVELOPE_WITH_ARROW = \U0001F4E9
        * OUTBOX_TRAY = \U0001F4E4
        * INBOX_TRAY = \U0001F4E5
        * PACKAGE = \U0001F4E6
        * CLOSED_MAILBOX_WITH_RAISED_FLAG = \U0001F4EB
        * CLOSED_MAILBOX_WITH_LOWERED_FLAG = \U0001F4EA
        * OPEN_MAILBOX_WITH_RAISED_FLAG = \U0001F4EC
        * OPEN_MAILBOX_WITH_LOWERED_FLAG = \U0001F4ED
        * POSTBOX = \U0001F4EE
        * BALLOT_BOX_WITH_BALLOT = \U0001F5F3
        * PENCIL = \U0000270F
        * BLACK_NIB = \U00002712
        * FOUNTAIN_PEN = \U0001F58B
        * PEN = \U0001F58A
        * PAINTBRUSH = \U0001F58C
        * CRAYON = \U0001F58D
        * MEMO = \U0001F4DD
        * BRIEFCASE = \U0001F4BC
        * FILE_FOLDER = \U0001F4C1
        * OPEN_FILE_FOLDER = \U0001F4C2
        * CARD_INDEX_DIVIDERS = \U0001F5C2
        * CALENDAR = \U0001F4C5
        * TEAR_OFF_CALENDAR = \U0001F4C6
        * SPIRAL_NOTEPAD = \U0001F5D2
        * SPIRAL_CALENDAR = \U0001F5D3
        * CARD_INDEX = \U0001F4C7
        * CHART_INCREASING = \U0001F4C8
        * CHART_DECREASING = \U0001F4C9
        * BAR_CHART = \U0001F4CA
        * CLIPBOARD = \U0001F4CB
        * PUSHPIN = \U0001F4CC
        * ROUND_PUSHPIN = \U0001F4CD
        * PAPERCLIP = \U0001F4CE
        * LINKED_PAPERCLIPS = \U0001F587
        * STRAIGHT_RULER = \U0001F4CF
        * TRIANGULAR_RULER = \U0001F4D0
        * SCISSORS = \U00002702
        * CARD_FILE_BOX = \U0001F5C3
        * FILE_CABINET = \U0001F5C4
        * WASTEBASKET = \U0001F5D1
        * LOCKED = \U0001F512
        * UNLOCKED = \U0001F513
        * LOCKED_WITH_PEN = \U0001F50F
        * LOCKED_WITH_KEY = \U0001F510
        * KEY = \U0001F511
        * OLD_KEY = \U0001F5DD
        * HAMMER = \U0001F528
        * AXE = \U0001FA93
        * PICK = \U000026CF
        * HAMMER_AND_PICK = \U00002692
        * HAMMER_AND_WRENCH = \U0001F6E0
        * DAGGER = \U0001F5E1
        * CROSSED_SWORDS = \U00002694
        * PISTOL = \U0001F52B
        * BOOMERANG = \U0001FA83
        * BOW_AND_ARROW = \U0001F3F9
        * SHIELD = \U0001F6E1
        * CARPENTRY_SAW = \U0001FA9A
        * WRENCH = \U0001F527
        * SCREWDRIVER = \U0001FA9B
        * NUT_AND_BOLT = \U0001F529
        * GEAR = \U00002699
        * CLAMP = \U0001F5DC
        * BALANCE_SCALE = \U00002696
        * WHITE_CANE = \U0001F9AF
        * LINK = \U0001F517
        * CHAINS = \U000026D3
        * HOOK = \U0001FA9D
        * TOOLBOX = \U0001F9F0
        * MAGNET = \U0001F9F2
        * LADDER = \U0001FA9C
        * ALEMBIC = \U00002697
        * TEST_TUBE = \U0001F9EA
        * PETRI_DISH = \U0001F9EB
        * DNA = \U0001F9EC
        * MICROSCOPE = \U0001F52C
        * TELESCOPE = \U0001F52D
        * SATELLITE_ANTENNA = \U0001F4E1
        * SYRINGE = \U0001F489
        * DROP_OF_BLOOD = \U0001FA78
        * PILL = \U0001F48A
        * ADHESIVE_BANDAGE = \U0001FA79
        * STETHOSCOPE = \U0001FA7A
        * DOOR = \U0001F6AA
        * ELEVATOR = \U0001F6D7
        * MIRROR = \U0001FA9E
        * WINDOW = \U0001FA9F
        * BED = \U0001F6CF
        * COUCH_AND_LAMP = \U0001F6CB
        * CHAIR = \U0001FA91
        * TOILET = \U0001F6BD
        * PLUNGER = \U0001FAA0
        * SHOWER = \U0001F6BF
        * BATHTUB = \U0001F6C1
        * MOUSE_TRAP = \U0001FAA4
        * RAZOR = \U0001FA92
        * LOTION_BOTTLE = \U0001F9F4
        * SAFETY_PIN = \U0001F9F7
        * BROOM = \U0001F9F9
        * BASKET = \U0001F9FA
        * ROLL_OF_PAPER = \U0001F9FB
        * BUCKET = \U0001FAA3
        * SOAP = \U0001F9FC
        * TOOTHBRUSH = \U0001FAA5
        * SPONGE = \U0001F9FD
        * FIRE_EXTINGUISHER = \U0001F9EF
        * SHOPPING_CART = \U0001F6D2
        * CIGARETTE = \U0001F6AC
        * COFFIN = \U000026B0
        * HEADSTONE = \U0001FAA6
        * FUNERAL_URN = \U000026B1
        * MOAI = \U0001F5FF
        * PLACARD = \U0001FAA7
        * ATM_SIGN = \U0001F3E7
        * LITTER_IN_BIN_SIGN = \U0001F6AE
        * POTABLE_WATER = \U0001F6B0
        * WHEELCHAIR_SYMBOL = \U0000267F
        * MENS_ROOM = \U0001F6B9
        * WOMENS_ROOM = \U0001F6BA
        * RESTROOM = \U0001F6BB
        * BABY_SYMBOL = \U0001F6BC
        * WATER_CLOSET = \U0001F6BE
        * PASSPORT_CONTROL = \U0001F6C2
        * CUSTOMS = \U0001F6C3
        * BAGGAGE_CLAIM = \U0001F6C4
        * LEFT_LUGGAGE = \U0001F6C5
        * WARNING = \U000026A0
        * CHILDREN_CROSSING = \U0001F6B8
        * NO_ENTRY = \U000026D4
        * PROHIBITED = \U0001F6AB
        * NO_BICYCLES = \U0001F6B3
        * NO_SMOKING = \U0001F6AD
        * NO_LITTERING = \U0001F6AF
        * NON_POTABLE_WATER = \U0001F6B1
        * NO_PEDESTRIANS = \U0001F6B7
        * NO_MOBILE_PHONES = \U0001F4F5
        * NO_ONE_UNDER_EIGHTEEN = \U0001F51E
        * RADIOACTIVE = \U00002622
        * BIOHAZARD = \U00002623
        * UP_ARROW = \U00002B06
        * UP_RIGHT_ARROW = \U00002197
        * RIGHT_ARROW = \U000027A1
        * DOWN_RIGHT_ARROW = \U00002198
        * DOWN_ARROW = \U00002B07
        * DOWN_LEFT_ARROW = \U00002199
        * LEFT_ARROW = \U00002B05
        * UP_LEFT_ARROW = \U00002196
        * UP_DOWN_ARROW = \U00002195
        * LEFT_RIGHT_ARROW = \U00002194
        * RIGHT_ARROW_CURVING_LEFT = \U000021A9
        * LEFT_ARROW_CURVING_RIGHT = \U000021AA
        * RIGHT_ARROW_CURVING_UP = \U00002934
        * RIGHT_ARROW_CURVING_DOWN = \U00002935
        * CLOCKWISE_VERTICAL_ARROWS = \U0001F503
        * COUNTERCLOCKWISE_ARROWS_BUTTON = \U0001F504
        * BACK_ARROW = \U0001F519
        * END_ARROW = \U0001F51A
        * ON_ARROW = \U0001F51B
        * SOON_ARROW = \U0001F51C
        * TOP_ARROW = \U0001F51D
        * PLACE_OF_WORSHIP = \U0001F6D0
        * ATOM_SYMBOL = \U0000269B
        * OM = \U0001F549
        * STAR_OF_DAVID = \U00002721
        * WHEEL_OF_DHARMA = \U00002638
        * YIN_YANG = \U0000262F
        * LATIN_CROSS = \U0000271D
        * ORTHODOX_CROSS = \U00002626
        * STAR_AND_CRESCENT = \U0000262A
        * PEACE_SYMBOL = \U0000262E
        * MENORAH = \U0001F54E
        * DOTTED_SIX_POINTED_STAR = \U0001F52F
        * ARIES = \U00002648
        * TAURUS = \U00002649
        * GEMINI = \U0000264A
        * CANCER = \U0000264B
        * LEO = \U0000264C
        * VIRGO = \U0000264D
        * LIBRA = \U0000264E
        * SCORPIO = \U0000264F
        * SAGITTARIUS = \U00002650
        * CAPRICORN = \U00002651
        * AQUARIUS = \U00002652
        * PISCES = \U00002653
        * OPHIUCHUS = \U000026CE
        * SHUFFLE_TRACKS_BUTTON = \U0001F500
        * REPEAT_BUTTON = \U0001F501
        * REPEAT_SINGLE_BUTTON = \U0001F502
        * PLAY_BUTTON = \U000025B6
        * FAST_FORWARD_BUTTON = \U000023E9
        * NEXT_TRACK_BUTTON = \U000023ED
        * PLAY_OR_PAUSE_BUTTON = \U000023EF
        * REVERSE_BUTTON = \U000025C0
        * FAST_REVERSE_BUTTON = \U000023EA
        * LAST_TRACK_BUTTON = \U000023EE
        * UPWARDS_BUTTON = \U0001F53C
        * FAST_UP_BUTTON = \U000023EB
        * DOWNWARDS_BUTTON = \U0001F53D
        * FAST_DOWN_BUTTON = \U000023EC
        * PAUSE_BUTTON = \U000023F8
        * STOP_BUTTON = \U000023F9
        * RECORD_BUTTON = \U000023FA
        * EJECT_BUTTON = \U000023CF
        * CINEMA = \U0001F3A6
        * DIM_BUTTON = \U0001F505
        * BRIGHT_BUTTON = \U0001F506
        * ANTENNA_BARS = \U0001F4F6
        * VIBRATION_MODE = \U0001F4F3
        * MOBILE_PHONE_OFF = \U0001F4F4
        * FEMALE_SIGN = \U00002640
        * MALE_SIGN = \U00002642
        * TRANSGENDER_SYMBOL = \U000026A7
        * MULTIPLY = \U00002716
        * PLUS = \U00002795
        * MINUS = \U00002796
        * DIVIDE = \U00002797
        * INFINITY = \U0000267E
        * DOUBLE_EXCLAMATION_MARK = \U0000203C
        * EXCLAMATION_QUESTION_MARK = \U00002049
        * QUESTION_MARK = \U00002753
        * WHITE_QUESTION_MARK = \U00002754
        * WHITE_EXCLAMATION_MARK = \U00002755
        * EXCLAMATION_MARK = \U00002757
        * WAVY_DASH = \U00003030
        * CURRENCY_EXCHANGE = \U0001F4B1
        * HEAVY_DOLLAR_SIGN = \U0001F4B2
        * MEDICAL_SYMBOL = \U00002695
        * RECYCLING_SYMBOL = \U0000267B
        * FLEUR_DE_LIS = \U0000269C
        * TRIDENT_EMBLEM = \U0001F531
        * NAME_BADGE = \U0001F4DB
        * JAPANESE_SYMBOL_FOR_BEGINNER = \U0001F530
        * HOLLOW_RED_CIRCLE = \U00002B55
        * CHECK_MARK_BUTTON = \U00002705
        * CHECK_BOX_WITH_CHECK = \U00002611
        * CHECK_MARK = \U00002714
        * CROSS_MARK = \U0000274C
        * CROSS_MARK_BUTTON = \U0000274E
        * CURLY_LOOP = \U000027B0
        * DOUBLE_CURLY_LOOP = \U000027BF
        * PART_ALTERNATION_MARK = \U0000303D
        * EIGHT_SPOKED_ASTERISK = \U00002733
        * EIGHT_POINTED_STAR = \U00002734
        * SPARKLE = \U00002747
        * COPYRIGHT = \U000000A9
        * REGISTERED = \U000000AE
        * TRADE_MARK = \U00002122
        * INPUT_LATIN_UPPERCASE = \U0001F520
        * INPUT_LATIN_LOWERCASE = \U0001F521
        * INPUT_NUMBERS = \U0001F522
        * INPUT_SYMBOLS = \U0001F523
        * INPUT_LATIN_LETTERS = \U0001F524
        * A_BUTTON_BLOOD_TYPE = \U0001F170
        * AB_BUTTON_BLOOD_TYPE = \U0001F18E
        * B_BUTTON_BLOOD_TYPE = \U0001F171
        * CL_BUTTON = \U0001F191
        * COOL_BUTTON = \U0001F192
        * FREE_BUTTON = \U0001F193
        * INFORMATION = \U00002139
        * ID_BUTTON = \U0001F194
        * CIRCLED_M = \U000024C2
        * NEW_BUTTON = \U0001F195
        * NG_BUTTON = \U0001F196
        * O_BUTTON_BLOOD_TYPE = \U0001F17E
        * OK_BUTTON = \U0001F197
        * P_BUTTON = \U0001F17F
        * SOS_BUTTON = \U0001F198
        * UP_BUTTON = \U0001F199
        * VS_BUTTON = \U0001F19A
        * JAPANESE_HERE_BUTTON = \U0001F201
        * JAPANESE_SERVICE_CHARGE_BUTTON = \U0001F202
        * JAPANESE_MONTHLY_AMOUNT_BUTTON = \U0001F237
        * JAPANESE_NOT_FREE_OF_CHARGE_BUTTON = \U0001F236
        * JAPANESE_RESERVED_BUTTON = \U0001F22F
        * JAPANESE_BARGAIN_BUTTON = \U0001F250
        * JAPANESE_DISCOUNT_BUTTON = \U0001F239
        * JAPANESE_FREE_OF_CHARGE_BUTTON = \U0001F21A
        * JAPANESE_PROHIBITED_BUTTON = \U0001F232
        * JAPANESE_ACCEPTABLE_BUTTON = \U0001F251
        * JAPANESE_APPLICATION_BUTTON = \U0001F238
        * JAPANESE_PASSING_GRADE_BUTTON = \U0001F234
        * JAPANESE_VACANCY_BUTTON = \U0001F233
        * JAPANESE_CONGRATULATIONS_BUTTON = \U00003297
        * JAPANESE_SECRET_BUTTON = \U00003299
        * JAPANESE_OPEN_FOR_BUSINESS_BUTTON = \U0001F23A
        * JAPANESE_NO_VACANCY_BUTTON = \U0001F235
        * RED_CIRCLE = \U0001F534
        * ORANGE_CIRCLE = \U0001F7E0
        * YELLOW_CIRCLE = \U0001F7E1
        * GREEN_CIRCLE = \U0001F7E2
        * BLUE_CIRCLE = \U0001F535
        * PURPLE_CIRCLE = \U0001F7E3
        * BROWN_CIRCLE = \U0001F7E4
        * BLACK_CIRCLE = \U000026AB
        * WHITE_CIRCLE = \U000026AA
        * RED_SQUARE = \U0001F7E5
        * ORANGE_SQUARE = \U0001F7E7
        * YELLOW_SQUARE = \U0001F7E8
        * GREEN_SQUARE = \U0001F7E9
        * BLUE_SQUARE = \U0001F7E6
        * PURPLE_SQUARE = \U0001F7EA
        * BROWN_SQUARE = \U0001F7EB
        * BLACK_LARGE_SQUARE = \U00002B1B
        * WHITE_LARGE_SQUARE = \U00002B1C
        * BLACK_MEDIUM_SQUARE = \U000025FC
        * WHITE_MEDIUM_SQUARE = \U000025FB
        * BLACK_MEDIUM_SMALL_SQUARE = \U000025FE
        * WHITE_MEDIUM_SMALL_SQUARE = \U000025FD
        * BLACK_SMALL_SQUARE = \U000025AA
        * WHITE_SMALL_SQUARE = \U000025AB
        * LARGE_ORANGE_DIAMOND = \U0001F536
        * LARGE_BLUE_DIAMOND = \U0001F537
        * SMALL_ORANGE_DIAMOND = \U0001F538
        * SMALL_BLUE_DIAMOND = \U0001F539
        * RED_TRIANGLE_POINTED_UP = \U0001F53A
        * RED_TRIANGLE_POINTED_DOWN = \U0001F53B
        * DIAMOND_WITH_A_DOT = \U0001F4A0
        * RADIO_BUTTON = \U0001F518
        * WHITE_SQUARE_BUTTON = \U0001F533
        * BLACK_SQUARE_BUTTON = \U0001F532
        * CHEQUERED_FLAG = \U0001F3C1
        * TRIANGULAR_FLAG = \U0001F6A9
        * CROSSED_FLAGS = \U0001F38C
        * BLACK_FLAG = \U0001F3F4
        * WHITE_FLAG = \U0001F3F3
    """

    GRINNING_FACE = "\U0001F600"
    GRINNING_FACE_WITH_BIG_EYES = "\U0001F603"
    GRINNING_FACE_WITH_SMILING_EYES = "\U0001F604"
    BEAMING_FACE_WITH_SMILING_EYES = "\U0001F601"
    GRINNING_SQUINTING_FACE = "\U0001F606"
    GRINNING_FACE_WITH_SWEAT = "\U0001F605"
    ROLLING_ON_THE_FLOOR_LAUGHING = "\U0001F923"
    FACE_WITH_TEARS_OF_JOY = "\U0001F602"
    SLIGHTLY_SMILING_FACE = "\U0001F642"
    UPSIDE_DOWN_FACE = "\U0001F643"
    WINKING_FACE = "\U0001F609"
    SMILING_FACE_WITH_SMILING_EYES = "\U0001F60A"
    SMILING_FACE_WITH_HALO = "\U0001F607"
    SMILING_FACE_WITH_HEARTS = "\U0001F970"
    SMILING_FACE_WITH_HEART_EYES = "\U0001F60D"
    STAR_STRUCK = "\U0001F929"
    FACE_BLOWING_A_KISS = "\U0001F618"
    KISSING_FACE = "\U0001F617"
    SMILING_FACE = "\U0000263A"
    KISSING_FACE_WITH_CLOSED_EYES = "\U0001F61A"
    KISSING_FACE_WITH_SMILING_EYES = "\U0001F619"
    SMILING_FACE_WITH_TEAR = "\U0001F972"
    FACE_SAVORING_FOOD = "\U0001F60B"
    FACE_WITH_TONGUE = "\U0001F61B"
    WINKING_FACE_WITH_TONGUE = "\U0001F61C"
    ZANY_FACE = "\U0001F92A"
    SQUINTING_FACE_WITH_TONGUE = "\U0001F61D"
    MONEY_MOUTH_FACE = "\U0001F911"
    HUGGING_FACE = "\U0001F917"
    FACE_WITH_HAND_OVER_MOUTH = "\U0001F92D"
    SHUSHING_FACE = "\U0001F92B"
    THINKING_FACE = "\U0001F914"
    ZIPPER_MOUTH_FACE = "\U0001F910"
    FACE_WITH_RAISED_EYEBROW = "\U0001F928"
    NEUTRAL_FACE = "\U0001F610"
    EXPRESSIONLESS_FACE = "\U0001F611"
    FACE_WITHOUT_MOUTH = "\U0001F636"
    SMIRKING_FACE = "\U0001F60F"
    UNAMUSED_FACE = "\U0001F612"
    FACE_WITH_ROLLING_EYES = "\U0001F644"
    GRIMACING_FACE = "\U0001F62C"
    LYING_FACE = "\U0001F925"
    RELIEVED_FACE = "\U0001F60C"
    PENSIVE_FACE = "\U0001F614"
    SLEEPY_FACE = "\U0001F62A"
    DROOLING_FACE = "\U0001F924"
    SLEEPING_FACE = "\U0001F634"
    FACE_WITH_MEDICAL_MASK = "\U0001F637"
    FACE_WITH_THERMOMETER = "\U0001F912"
    FACE_WITH_HEAD_BANDAGE = "\U0001F915"
    NAUSEATED_FACE = "\U0001F922"
    FACE_VOMITING = "\U0001F92E"
    SNEEZING_FACE = "\U0001F927"
    HOT_FACE = "\U0001F975"
    COLD_FACE = "\U0001F976"
    WOOZY_FACE = "\U0001F974"
    DIZZY_FACE = "\U0001F635"
    EXPLODING_HEAD = "\U0001F92F"
    COWBOY_HAT_FACE = "\U0001F920"
    PARTYING_FACE = "\U0001F973"
    DISGUISED_FACE = "\U0001F978"
    SMILING_FACE_WITH_SUNGLASSES = "\U0001F60E"
    NERD_FACE = "\U0001F913"
    FACE_WITH_MONOCLE = "\U0001F9D0"
    CONFUSED_FACE = "\U0001F615"
    WORRIED_FACE = "\U0001F61F"
    SLIGHTLY_FROWNING_FACE = "\U0001F641"
    FROWNING_FACE = "\U00002639"
    FACE_WITH_OPEN_MOUTH = "\U0001F62E"
    HUSHED_FACE = "\U0001F62F"
    ASTONISHED_FACE = "\U0001F632"
    FLUSHED_FACE = "\U0001F633"
    PLEADING_FACE = "\U0001F97A"
    FROWNING_FACE_WITH_OPEN_MOUTH = "\U0001F626"
    ANGUISHED_FACE = "\U0001F627"
    FEARFUL_FACE = "\U0001F628"
    ANXIOUS_FACE_WITH_SWEAT = "\U0001F630"
    SAD_BUT_RELIEVED_FACE = "\U0001F625"
    CRYING_FACE = "\U0001F622"
    LOUDLY_CRYING_FACE = "\U0001F62D"
    FACE_SCREAMING_IN_FEAR = "\U0001F631"
    CONFOUNDED_FACE = "\U0001F616"
    PERSEVERING_FACE = "\U0001F623"
    DISAPPOINTED_FACE = "\U0001F61E"
    DOWNCAST_FACE_WITH_SWEAT = "\U0001F613"
    WEARY_FACE = "\U0001F629"
    TIRED_FACE = "\U0001F62B"
    YAWNING_FACE = "\U0001F971"
    FACE_WITH_STEAM_FROM_NOSE = "\U0001F624"
    POUTING_FACE = "\U0001F621"
    ANGRY_FACE = "\U0001F620"
    FACE_WITH_SYMBOLS_ON_MOUTH = "\U0001F92C"
    SMILING_FACE_WITH_HORNS = "\U0001F608"
    ANGRY_FACE_WITH_HORNS = "\U0001F47F"
    SKULL = "\U0001F480"
    SKULL_AND_CROSSBONES = "\U00002620"
    PILE_OF_POO = "\U0001F4A9"
    CLOWN_FACE = "\U0001F921"
    OGRE = "\U0001F479"
    GOBLIN = "\U0001F47A"
    GHOST = "\U0001F47B"
    ALIEN = "\U0001F47D"
    ALIEN_MONSTER = "\U0001F47E"
    ROBOT = "\U0001F916"
    GRINNING_CAT = "\U0001F63A"
    GRINNING_CAT_WITH_SMILING_EYES = "\U0001F638"
    CAT_WITH_TEARS_OF_JOY = "\U0001F639"
    SMILING_CAT_WITH_HEART_EYES = "\U0001F63B"
    CAT_WITH_WRY_SMILE = "\U0001F63C"
    KISSING_CAT = "\U0001F63D"
    WEARY_CAT = "\U0001F640"
    CRYING_CAT = "\U0001F63F"
    POUTING_CAT = "\U0001F63E"
    SEE_NO_EVIL_MONKEY = "\U0001F648"
    HEAR_NO_EVIL_MONKEY = "\U0001F649"
    SPEAK_NO_EVIL_MONKEY = "\U0001F64A"
    KISS_MARK = "\U0001F48B"
    LOVE_LETTER = "\U0001F48C"
    HEART_WITH_ARROW = "\U0001F498"
    HEART_WITH_RIBBON = "\U0001F49D"
    SPARKLING_HEART = "\U0001F496"
    GROWING_HEART = "\U0001F497"
    BEATING_HEART = "\U0001F493"
    REVOLVING_HEARTS = "\U0001F49E"
    TWO_HEARTS = "\U0001F495"
    HEART_DECORATION = "\U0001F49F"
    HEART_EXCLAMATION = "\U00002763"
    BROKEN_HEART = "\U0001F494"
    RED_HEART = "\U00002764"
    ORANGE_HEART = "\U0001F9E1"
    YELLOW_HEART = "\U0001F49B"
    GREEN_HEART = "\U0001F49A"
    BLUE_HEART = "\U0001F499"
    PURPLE_HEART = "\U0001F49C"
    BROWN_HEART = "\U0001F90E"
    BLACK_HEART = "\U0001F5A4"
    WHITE_HEART = "\U0001F90D"
    HUNDRED_POINTS = "\U0001F4AF"
    ANGER_SYMBOL = "\U0001F4A2"
    COLLISION = "\U0001F4A5"
    DIZZY = "\U0001F4AB"
    SWEAT_DROPLETS = "\U0001F4A6"
    DASHING_AWAY = "\U0001F4A8"
    HOLE = "\U0001F573"
    BOMB = "\U0001F4A3"
    SPEECH_BALLOON = "\U0001F4AC"
    LEFT_SPEECH_BUBBLE = "\U0001F5E8"
    RIGHT_ANGER_BUBBLE = "\U0001F5EF"
    THOUGHT_BALLOON = "\U0001F4AD"
    ZZZ = "\U0001F4A4"
    WAVING_HAND = "\U0001F44B"
    RAISED_BACK_OF_HAND = "\U0001F91A"
    HAND_WITH_FINGERS_SPLAYED = "\U0001F590"
    RAISED_HAND = "\U0000270B"
    VULCAN_SALUTE = "\U0001F596"
    OK_HAND = "\U0001F44C"
    PINCHED_FINGERS = "\U0001F90C"
    PINCHING_HAND = "\U0001F90F"
    VICTORY_HAND = "\U0000270C"
    CROSSED_FINGERS = "\U0001F91E"
    LOVE_YOU_GESTURE = "\U0001F91F"
    SIGN_OF_THE_HORNS = "\U0001F918"
    CALL_ME_HAND = "\U0001F919"
    BACKHAND_INDEX_POINTING_LEFT = "\U0001F448"
    BACKHAND_INDEX_POINTING_RIGHT = "\U0001F449"
    BACKHAND_INDEX_POINTING_UP = "\U0001F446"
    MIDDLE_FINGER = "\U0001F595"
    BACKHAND_INDEX_POINTING_DOWN = "\U0001F447"
    INDEX_POINTING_UP = "\U0000261D"
    THUMBS_UP = "\U0001F44D"
    THUMBS_DOWN = "\U0001F44E"
    RAISED_FIST = "\U0000270A"
    ONCOMING_FIST = "\U0001F44A"
    LEFT_FACING_FIST = "\U0001F91B"
    RIGHT_FACING_FIST = "\U0001F91C"
    CLAPPING_HANDS = "\U0001F44F"
    RAISING_HANDS = "\U0001F64C"
    OPEN_HANDS = "\U0001F450"
    PALMS_UP_TOGETHER = "\U0001F932"
    HANDSHAKE = "\U0001F91D"
    FOLDED_HANDS = "\U0001F64F"
    WRITING_HAND = "\U0000270D"
    NAIL_POLISH = "\U0001F485"
    SELFIE = "\U0001F933"
    FLEXED_BICEPS = "\U0001F4AA"
    MECHANICAL_ARM = "\U0001F9BE"
    MECHANICAL_LEG = "\U0001F9BF"
    LEG = "\U0001F9B5"
    FOOT = "\U0001F9B6"
    EAR = "\U0001F442"
    EAR_WITH_HEARING_AID = "\U0001F9BB"
    NOSE = "\U0001F443"
    BRAIN = "\U0001F9E0"
    ANATOMICAL_HEART = "\U0001FAC0"
    LUNGS = "\U0001FAC1"
    TOOTH = "\U0001F9B7"
    BONE = "\U0001F9B4"
    EYES = "\U0001F440"
    EYE = "\U0001F441"
    TONGUE = "\U0001F445"
    MOUTH = "\U0001F444"
    BABY = "\U0001F476"
    CHILD = "\U0001F9D2"
    BOY = "\U0001F466"
    GIRL = "\U0001F467"
    PERSON = "\U0001F9D1"
    PERSON_BLOND_HAIR = "\U0001F471"
    MAN = "\U0001F468"
    MAN_BEARD = "\U0001F9D4"
    WOMAN = "\U0001F469"
    OLDER_PERSON = "\U0001F9D3"
    OLD_MAN = "\U0001F474"
    OLD_WOMAN = "\U0001F475"
    PERSON_FROWNING = "\U0001F64D"
    PERSON_POUTING = "\U0001F64E"
    PERSON_GESTURING_NO = "\U0001F645"
    PERSON_GESTURING_OK = "\U0001F646"
    PERSON_TIPPING_HAND = "\U0001F481"
    PERSON_RAISING_HAND = "\U0001F64B"
    DEAF_PERSON = "\U0001F9CF"
    PERSON_BOWING = "\U0001F647"
    PERSON_FACEPALMING = "\U0001F926"
    PERSON_SHRUGGING = "\U0001F937"
    POLICE_OFFICER = "\U0001F46E"
    DETECTIVE = "\U0001F575"
    GUARD = "\U0001F482"
    NINJA = "\U0001F977"
    CONSTRUCTION_WORKER = "\U0001F477"
    PRINCE = "\U0001F934"
    PRINCESS = "\U0001F478"
    PERSON_WEARING_TURBAN = "\U0001F473"
    PERSON_WITH_SKULLCAP = "\U0001F472"
    WOMAN_WITH_HEADSCARF = "\U0001F9D5"
    PERSON_IN_TUXEDO = "\U0001F935"
    PERSON_WITH_VEIL = "\U0001F470"
    PREGNANT_WOMAN = "\U0001F930"
    BREAST_FEEDING = "\U0001F931"
    BABY_ANGEL = "\U0001F47C"
    SANTA_CLAUS = "\U0001F385"
    MRS_CLAUS = "\U0001F936"
    SUPERHERO = "\U0001F9B8"
    SUPERVILLAIN = "\U0001F9B9"
    MAGE = "\U0001F9D9"
    FAIRY = "\U0001F9DA"
    VAMPIRE = "\U0001F9DB"
    MERPERSON = "\U0001F9DC"
    ELF = "\U0001F9DD"
    GENIE = "\U0001F9DE"
    ZOMBIE = "\U0001F9DF"
    PERSON_GETTING_MASSAGE = "\U0001F486"
    PERSON_GETTING_HAIRCUT = "\U0001F487"
    PERSON_WALKING = "\U0001F6B6"
    PERSON_STANDING = "\U0001F9CD"
    PERSON_KNEELING = "\U0001F9CE"
    PERSON_RUNNING = "\U0001F3C3"
    WOMAN_DANCING = "\U0001F483"
    MAN_DANCING = "\U0001F57A"
    PERSON_IN_SUIT_LEVITATING = "\U0001F574"
    PEOPLE_WITH_BUNNY_EARS = "\U0001F46F"
    PERSON_IN_STEAMY_ROOM = "\U0001F9D6"
    PERSON_CLIMBING = "\U0001F9D7"
    PERSON_FENCING = "\U0001F93A"
    HORSE_RACING = "\U0001F3C7"
    SKIER = "\U000026F7"
    SNOWBOARDER = "\U0001F3C2"
    PERSON_GOLFING = "\U0001F3CC"
    PERSON_SURFING = "\U0001F3C4"
    PERSON_ROWING_BOAT = "\U0001F6A3"
    PERSON_SWIMMING = "\U0001F3CA"
    PERSON_BOUNCING_BALL = "\U000026F9"
    PERSON_LIFTING_WEIGHTS = "\U0001F3CB"
    PERSON_BIKING = "\U0001F6B4"
    PERSON_MOUNTAIN_BIKING = "\U0001F6B5"
    PERSON_CARTWHEELING = "\U0001F938"
    PEOPLE_WRESTLING = "\U0001F93C"
    PERSON_PLAYING_WATER_POLO = "\U0001F93D"
    PERSON_PLAYING_HANDBALL = "\U0001F93E"
    PERSON_JUGGLING = "\U0001F939"
    PERSON_IN_LOTUS_POSITION = "\U0001F9D8"
    PERSON_TAKING_BATH = "\U0001F6C0"
    PERSON_IN_BED = "\U0001F6CC"
    WOMEN_HOLDING_HANDS = "\U0001F46D"
    WOMAN_AND_MAN_HOLDING_HANDS = "\U0001F46B"
    MEN_HOLDING_HANDS = "\U0001F46C"
    KISS = "\U0001F48F"
    COUPLE_WITH_HEART = "\U0001F491"
    FAMILY = "\U0001F46A"
    SPEAKING_HEAD = "\U0001F5E3"
    BUST_IN_SILHOUETTE = "\U0001F464"
    BUSTS_IN_SILHOUETTE = "\U0001F465"
    PEOPLE_HUGGING = "\U0001FAC2"
    FOOTPRINTS = "\U0001F463"
    LIGHT_SKIN_TONE = "\U0001F3FB"
    MEDIUM_LIGHT_SKIN_TONE = "\U0001F3FC"
    MEDIUM_SKIN_TONE = "\U0001F3FD"
    MEDIUM_DARK_SKIN_TONE = "\U0001F3FE"
    DARK_SKIN_TONE = "\U0001F3FF"
    RED_HAIR = "\U0001F9B0"
    CURLY_HAIR = "\U0001F9B1"
    WHITE_HAIR = "\U0001F9B3"
    BALD = "\U0001F9B2"
    MONKEY_FACE = "\U0001F435"
    MONKEY = "\U0001F412"
    GORILLA = "\U0001F98D"
    ORANGUTAN = "\U0001F9A7"
    DOG_FACE = "\U0001F436"
    DOG = "\U0001F415"
    GUIDE_DOG = "\U0001F9AE"
    POODLE = "\U0001F429"
    WOLF = "\U0001F43A"
    FOX = "\U0001F98A"
    RACCOON = "\U0001F99D"
    CAT_FACE = "\U0001F431"
    CAT = "\U0001F408"
    LION = "\U0001F981"
    TIGER_FACE = "\U0001F42F"
    TIGER = "\U0001F405"
    LEOPARD = "\U0001F406"
    HORSE_FACE = "\U0001F434"
    HORSE = "\U0001F40E"
    UNICORN = "\U0001F984"
    ZEBRA = "\U0001F993"
    DEER = "\U0001F98C"
    BISON = "\U0001F9AC"
    COW_FACE = "\U0001F42E"
    OX = "\U0001F402"
    WATER_BUFFALO = "\U0001F403"
    COW = "\U0001F404"
    PIG_FACE = "\U0001F437"
    PIG = "\U0001F416"
    BOAR = "\U0001F417"
    PIG_NOSE = "\U0001F43D"
    RAM = "\U0001F40F"
    EWE = "\U0001F411"
    GOAT = "\U0001F410"
    CAMEL = "\U0001F42A"
    TWO_HUMP_CAMEL = "\U0001F42B"
    LLAMA = "\U0001F999"
    GIRAFFE = "\U0001F992"
    ELEPHANT = "\U0001F418"
    MAMMOTH = "\U0001F9A3"
    RHINOCEROS = "\U0001F98F"
    HIPPOPOTAMUS = "\U0001F99B"
    MOUSE_FACE = "\U0001F42D"
    MOUSE = "\U0001F401"
    RAT = "\U0001F400"
    HAMSTER = "\U0001F439"
    RABBIT_FACE = "\U0001F430"
    RABBIT = "\U0001F407"
    CHIPMUNK = "\U0001F43F"
    BEAVER = "\U0001F9AB"
    HEDGEHOG = "\U0001F994"
    BAT = "\U0001F987"
    BEAR = "\U0001F43B"
    KOALA = "\U0001F428"
    PANDA = "\U0001F43C"
    SLOTH = "\U0001F9A5"
    OTTER = "\U0001F9A6"
    SKUNK = "\U0001F9A8"
    KANGAROO = "\U0001F998"
    BADGER = "\U0001F9A1"
    PAW_PRINTS = "\U0001F43E"
    TURKEY = "\U0001F983"
    CHICKEN = "\U0001F414"
    ROOSTER = "\U0001F413"
    HATCHING_CHICK = "\U0001F423"
    BABY_CHICK = "\U0001F424"
    FRONT_FACING_BABY_CHICK = "\U0001F425"
    BIRD = "\U0001F426"
    PENGUIN = "\U0001F427"
    DOVE = "\U0001F54A"
    EAGLE = "\U0001F985"
    DUCK = "\U0001F986"
    SWAN = "\U0001F9A2"
    OWL = "\U0001F989"
    DODO = "\U0001F9A4"
    FEATHER = "\U0001FAB6"
    FLAMINGO = "\U0001F9A9"
    PEACOCK = "\U0001F99A"
    PARROT = "\U0001F99C"
    FROG = "\U0001F438"
    CROCODILE = "\U0001F40A"
    TURTLE = "\U0001F422"
    LIZARD = "\U0001F98E"
    SNAKE = "\U0001F40D"
    DRAGON_FACE = "\U0001F432"
    DRAGON = "\U0001F409"
    SAUROPOD = "\U0001F995"
    T_REX = "\U0001F996"
    SPOUTING_WHALE = "\U0001F433"
    WHALE = "\U0001F40B"
    DOLPHIN = "\U0001F42C"
    SEAL = "\U0001F9AD"
    FISH = "\U0001F41F"
    TROPICAL_FISH = "\U0001F420"
    BLOWFISH = "\U0001F421"
    SHARK = "\U0001F988"
    OCTOPUS = "\U0001F419"
    SPIRAL_SHELL = "\U0001F41A"
    SNAIL = "\U0001F40C"
    BUTTERFLY = "\U0001F98B"
    BUG = "\U0001F41B"
    ANT = "\U0001F41C"
    HONEYBEE = "\U0001F41D"
    BEETLE = "\U0001FAB2"
    LADY_BEETLE = "\U0001F41E"
    CRICKET = "\U0001F997"
    COCKROACH = "\U0001FAB3"
    SPIDER = "\U0001F577"
    SPIDER_WEB = "\U0001F578"
    SCORPION = "\U0001F982"
    MOSQUITO = "\U0001F99F"
    FLY = "\U0001FAB0"
    WORM = "\U0001FAB1"
    MICROBE = "\U0001F9A0"
    BOUQUET = "\U0001F490"
    CHERRY_BLOSSOM = "\U0001F338"
    WHITE_FLOWER = "\U0001F4AE"
    ROSETTE = "\U0001F3F5"
    ROSE = "\U0001F339"
    WILTED_FLOWER = "\U0001F940"
    HIBISCUS = "\U0001F33A"
    SUNFLOWER = "\U0001F33B"
    BLOSSOM = "\U0001F33C"
    TULIP = "\U0001F337"
    SEEDLING = "\U0001F331"
    POTTED_PLANT = "\U0001FAB4"
    EVERGREEN_TREE = "\U0001F332"
    DECIDUOUS_TREE = "\U0001F333"
    PALM_TREE = "\U0001F334"
    CACTUS = "\U0001F335"
    SHEAF_OF_RICE = "\U0001F33E"
    HERB = "\U0001F33F"
    SHAMROCK = "\U00002618"
    FOUR_LEAF_CLOVER = "\U0001F340"
    MAPLE_LEAF = "\U0001F341"
    FALLEN_LEAF = "\U0001F342"
    LEAF_FLUTTERING_IN_WIND = "\U0001F343"
    GRAPES = "\U0001F347"
    MELON = "\U0001F348"
    WATERMELON = "\U0001F349"
    TANGERINE = "\U0001F34A"
    LEMON = "\U0001F34B"
    BANANA = "\U0001F34C"
    PINEAPPLE = "\U0001F34D"
    MANGO = "\U0001F96D"
    RED_APPLE = "\U0001F34E"
    GREEN_APPLE = "\U0001F34F"
    PEAR = "\U0001F350"
    PEACH = "\U0001F351"
    CHERRIES = "\U0001F352"
    STRAWBERRY = "\U0001F353"
    BLUEBERRIES = "\U0001FAD0"
    KIWI_FRUIT = "\U0001F95D"
    TOMATO = "\U0001F345"
    OLIVE = "\U0001FAD2"
    COCONUT = "\U0001F965"
    AVOCADO = "\U0001F951"
    EGGPLANT = "\U0001F346"
    POTATO = "\U0001F954"
    CARROT = "\U0001F955"
    EAR_OF_CORN = "\U0001F33D"
    HOT_PEPPER = "\U0001F336"
    BELL_PEPPER = "\U0001FAD1"
    CUCUMBER = "\U0001F952"
    LEAFY_GREEN = "\U0001F96C"
    BROCCOLI = "\U0001F966"
    GARLIC = "\U0001F9C4"
    ONION = "\U0001F9C5"
    MUSHROOM = "\U0001F344"
    PEANUTS = "\U0001F95C"
    CHESTNUT = "\U0001F330"
    BREAD = "\U0001F35E"
    CROISSANT = "\U0001F950"
    BAGUETTE_BREAD = "\U0001F956"
    FLATBREAD = "\U0001FAD3"
    PRETZEL = "\U0001F968"
    BAGEL = "\U0001F96F"
    PANCAKES = "\U0001F95E"
    WAFFLE = "\U0001F9C7"
    CHEESE_WEDGE = "\U0001F9C0"
    MEAT_ON_BONE = "\U0001F356"
    POULTRY_LEG = "\U0001F357"
    CUT_OF_MEAT = "\U0001F969"
    BACON = "\U0001F953"
    HAMBURGER = "\U0001F354"
    FRENCH_FRIES = "\U0001F35F"
    PIZZA = "\U0001F355"
    HOT_DOG = "\U0001F32D"
    SANDWICH = "\U0001F96A"
    TACO = "\U0001F32E"
    BURRITO = "\U0001F32F"
    TAMALE = "\U0001FAD4"
    STUFFED_FLATBREAD = "\U0001F959"
    FALAFEL = "\U0001F9C6"
    EGG = "\U0001F95A"
    COOKING = "\U0001F373"
    SHALLOW_PAN_OF_FOOD = "\U0001F958"
    POT_OF_FOOD = "\U0001F372"
    FONDUE = "\U0001FAD5"
    BOWL_WITH_SPOON = "\U0001F963"
    GREEN_SALAD = "\U0001F957"
    POPCORN = "\U0001F37F"
    BUTTER = "\U0001F9C8"
    SALT = "\U0001F9C2"
    CANNED_FOOD = "\U0001F96B"
    BENTO_BOX = "\U0001F371"
    RICE_CRACKER = "\U0001F358"
    RICE_BALL = "\U0001F359"
    COOKED_RICE = "\U0001F35A"
    CURRY_RICE = "\U0001F35B"
    STEAMING_BOWL = "\U0001F35C"
    SPAGHETTI = "\U0001F35D"
    ROASTED_SWEET_POTATO = "\U0001F360"
    ODEN = "\U0001F362"
    SUSHI = "\U0001F363"
    FRIED_SHRIMP = "\U0001F364"
    FISH_CAKE_WITH_SWIRL = "\U0001F365"
    MOON_CAKE = "\U0001F96E"
    DANGO = "\U0001F361"
    DUMPLING = "\U0001F95F"
    FORTUNE_COOKIE = "\U0001F960"
    TAKEOUT_BOX = "\U0001F961"
    CRAB = "\U0001F980"
    LOBSTER = "\U0001F99E"
    SHRIMP = "\U0001F990"
    SQUID = "\U0001F991"
    OYSTER = "\U0001F9AA"
    SOFT_ICE_CREAM = "\U0001F366"
    SHAVED_ICE = "\U0001F367"
    ICE_CREAM = "\U0001F368"
    DOUGHNUT = "\U0001F369"
    COOKIE = "\U0001F36A"
    BIRTHDAY_CAKE = "\U0001F382"
    SHORTCAKE = "\U0001F370"
    CUPCAKE = "\U0001F9C1"
    PIE = "\U0001F967"
    CHOCOLATE_BAR = "\U0001F36B"
    CANDY = "\U0001F36C"
    LOLLIPOP = "\U0001F36D"
    CUSTARD = "\U0001F36E"
    HONEY_POT = "\U0001F36F"
    BABY_BOTTLE = "\U0001F37C"
    GLASS_OF_MILK = "\U0001F95B"
    HOT_BEVERAGE = "\U00002615"
    TEAPOT = "\U0001FAD6"
    TEACUP_WITHOUT_HANDLE = "\U0001F375"
    SAKE = "\U0001F376"
    BOTTLE_WITH_POPPING_CORK = "\U0001F37E"
    WINE_GLASS = "\U0001F377"
    COCKTAIL_GLASS = "\U0001F378"
    TROPICAL_DRINK = "\U0001F379"
    BEER_MUG = "\U0001F37A"
    CLINKING_BEER_MUGS = "\U0001F37B"
    CLINKING_GLASSES = "\U0001F942"
    TUMBLER_GLASS = "\U0001F943"
    CUP_WITH_STRAW = "\U0001F964"
    BUBBLE_TEA = "\U0001F9CB"
    BEVERAGE_BOX = "\U0001F9C3"
    MATE = "\U0001F9C9"
    ICE = "\U0001F9CA"
    CHOPSTICKS = "\U0001F962"
    FORK_AND_KNIFE_WITH_PLATE = "\U0001F37D"
    FORK_AND_KNIFE = "\U0001F374"
    SPOON = "\U0001F944"
    KITCHEN_KNIFE = "\U0001F52A"
    AMPHORA = "\U0001F3FA"
    GLOBE_SHOWING_EUROPE_AFRICA = "\U0001F30D"
    GLOBE_SHOWING_AMERICAS = "\U0001F30E"
    GLOBE_SHOWING_ASIA_AUSTRALIA = "\U0001F30F"
    GLOBE_WITH_MERIDIANS = "\U0001F310"
    WORLD_MAP = "\U0001F5FA"
    MAP_OF_JAPAN = "\U0001F5FE"
    COMPASS = "\U0001F9ED"
    SNOW_CAPPED_MOUNTAIN = "\U0001F3D4"
    MOUNTAIN = "\U000026F0"
    VOLCANO = "\U0001F30B"
    MOUNT_FUJI = "\U0001F5FB"
    CAMPING = "\U0001F3D5"
    BEACH_WITH_UMBRELLA = "\U0001F3D6"
    DESERT = "\U0001F3DC"
    DESERT_ISLAND = "\U0001F3DD"
    NATIONAL_PARK = "\U0001F3DE"
    STADIUM = "\U0001F3DF"
    CLASSICAL_BUILDING = "\U0001F3DB"
    BUILDING_CONSTRUCTION = "\U0001F3D7"
    BRICK = "\U0001F9F1"
    ROCK = "\U0001FAA8"
    WOOD = "\U0001FAB5"
    HUT = "\U0001F6D6"
    HOUSES = "\U0001F3D8"
    DERELICT_HOUSE = "\U0001F3DA"
    HOUSE = "\U0001F3E0"
    HOUSE_WITH_GARDEN = "\U0001F3E1"
    OFFICE_BUILDING = "\U0001F3E2"
    JAPANESE_POST_OFFICE = "\U0001F3E3"
    POST_OFFICE = "\U0001F3E4"
    HOSPITAL = "\U0001F3E5"
    BANK = "\U0001F3E6"
    HOTEL = "\U0001F3E8"
    LOVE_HOTEL = "\U0001F3E9"
    CONVENIENCE_STORE = "\U0001F3EA"
    SCHOOL = "\U0001F3EB"
    DEPARTMENT_STORE = "\U0001F3EC"
    FACTORY = "\U0001F3ED"
    JAPANESE_CASTLE = "\U0001F3EF"
    CASTLE = "\U0001F3F0"
    WEDDING = "\U0001F492"
    TOKYO_TOWER = "\U0001F5FC"
    STATUE_OF_LIBERTY = "\U0001F5FD"
    CHURCH = "\U000026EA"
    MOSQUE = "\U0001F54C"
    HINDU_TEMPLE = "\U0001F6D5"
    SYNAGOGUE = "\U0001F54D"
    SHINTO_SHRINE = "\U000026E9"
    KAABA = "\U0001F54B"
    FOUNTAIN = "\U000026F2"
    TENT = "\U000026FA"
    FOGGY = "\U0001F301"
    NIGHT_WITH_STARS = "\U0001F303"
    CITYSCAPE = "\U0001F3D9"
    SUNRISE_OVER_MOUNTAINS = "\U0001F304"
    SUNRISE = "\U0001F305"
    CITYSCAPE_AT_DUSK = "\U0001F306"
    SUNSET = "\U0001F307"
    BRIDGE_AT_NIGHT = "\U0001F309"
    HOT_SPRINGS = "\U00002668"
    CAROUSEL_HORSE = "\U0001F3A0"
    FERRIS_WHEEL = "\U0001F3A1"
    ROLLER_COASTER = "\U0001F3A2"
    BARBER_POLE = "\U0001F488"
    CIRCUS_TENT = "\U0001F3AA"
    LOCOMOTIVE = "\U0001F682"
    RAILWAY_CAR = "\U0001F683"
    HIGH_SPEED_TRAIN = "\U0001F684"
    BULLET_TRAIN = "\U0001F685"
    TRAIN = "\U0001F686"
    METRO = "\U0001F687"
    LIGHT_RAIL = "\U0001F688"
    STATION = "\U0001F689"
    TRAM = "\U0001F68A"
    MONORAIL = "\U0001F69D"
    MOUNTAIN_RAILWAY = "\U0001F69E"
    TRAM_CAR = "\U0001F68B"
    BUS = "\U0001F68C"
    ONCOMING_BUS = "\U0001F68D"
    TROLLEYBUS = "\U0001F68E"
    MINIBUS = "\U0001F690"
    AMBULANCE = "\U0001F691"
    FIRE_ENGINE = "\U0001F692"
    POLICE_CAR = "\U0001F693"
    ONCOMING_POLICE_CAR = "\U0001F694"
    TAXI = "\U0001F695"
    ONCOMING_TAXI = "\U0001F696"
    AUTOMOBILE = "\U0001F697"
    ONCOMING_AUTOMOBILE = "\U0001F698"
    SPORT_UTILITY_VEHICLE = "\U0001F699"
    PICKUP_TRUCK = "\U0001F6FB"
    DELIVERY_TRUCK = "\U0001F69A"
    ARTICULATED_LORRY = "\U0001F69B"
    TRACTOR = "\U0001F69C"
    RACING_CAR = "\U0001F3CE"
    MOTORCYCLE = "\U0001F3CD"
    MOTOR_SCOOTER = "\U0001F6F5"
    MANUAL_WHEELCHAIR = "\U0001F9BD"
    MOTORIZED_WHEELCHAIR = "\U0001F9BC"
    AUTO_RICKSHAW = "\U0001F6FA"
    BICYCLE = "\U0001F6B2"
    KICK_SCOOTER = "\U0001F6F4"
    SKATEBOARD = "\U0001F6F9"
    ROLLER_SKATE = "\U0001F6FC"
    BUS_STOP = "\U0001F68F"
    MOTORWAY = "\U0001F6E3"
    RAILWAY_TRACK = "\U0001F6E4"
    OIL_DRUM = "\U0001F6E2"
    FUEL_PUMP = "\U000026FD"
    POLICE_CAR_LIGHT = "\U0001F6A8"
    HORIZONTAL_TRAFFIC_LIGHT = "\U0001F6A5"
    VERTICAL_TRAFFIC_LIGHT = "\U0001F6A6"
    STOP_SIGN = "\U0001F6D1"
    CONSTRUCTION = "\U0001F6A7"
    ANCHOR = "\U00002693"
    SAILBOAT = "\U000026F5"
    CANOE = "\U0001F6F6"
    SPEEDBOAT = "\U0001F6A4"
    PASSENGER_SHIP = "\U0001F6F3"
    FERRY = "\U000026F4"
    MOTOR_BOAT = "\U0001F6E5"
    SHIP = "\U0001F6A2"
    AIRPLANE = "\U00002708"
    SMALL_AIRPLANE = "\U0001F6E9"
    AIRPLANE_DEPARTURE = "\U0001F6EB"
    AIRPLANE_ARRIVAL = "\U0001F6EC"
    PARACHUTE = "\U0001FA82"
    SEAT = "\U0001F4BA"
    HELICOPTER = "\U0001F681"
    SUSPENSION_RAILWAY = "\U0001F69F"
    MOUNTAIN_CABLEWAY = "\U0001F6A0"
    AERIAL_TRAMWAY = "\U0001F6A1"
    SATELLITE = "\U0001F6F0"
    ROCKET = "\U0001F680"
    FLYING_SAUCER = "\U0001F6F8"
    BELLHOP_BELL = "\U0001F6CE"
    LUGGAGE = "\U0001F9F3"
    HOURGLASS_DONE = "\U0000231B"
    HOURGLASS_NOT_DONE = "\U000023F3"
    WATCH = "\U0000231A"
    ALARM_CLOCK = "\U000023F0"
    STOPWATCH = "\U000023F1"
    TIMER_CLOCK = "\U000023F2"
    MANTELPIECE_CLOCK = "\U0001F570"
    TWELVE_OCLOCK = "\U0001F55B"
    TWELVE_THIRTY = "\U0001F567"
    ONE_OCLOCK = "\U0001F550"
    ONE_THIRTY = "\U0001F55C"
    TWO_OCLOCK = "\U0001F551"
    TWO_THIRTY = "\U0001F55D"
    THREE_OCLOCK = "\U0001F552"
    THREE_THIRTY = "\U0001F55E"
    FOUR_OCLOCK = "\U0001F553"
    FOUR_THIRTY = "\U0001F55F"
    FIVE_OCLOCK = "\U0001F554"
    FIVE_THIRTY = "\U0001F560"
    SIX_OCLOCK = "\U0001F555"
    SIX_THIRTY = "\U0001F561"
    SEVEN_OCLOCK = "\U0001F556"
    SEVEN_THIRTY = "\U0001F562"
    EIGHT_OCLOCK = "\U0001F557"
    EIGHT_THIRTY = "\U0001F563"
    NINE_OCLOCK = "\U0001F558"
    NINE_THIRTY = "\U0001F564"
    TEN_OCLOCK = "\U0001F559"
    TEN_THIRTY = "\U0001F565"
    ELEVEN_OCLOCK = "\U0001F55A"
    ELEVEN_THIRTY = "\U0001F566"
    NEW_MOON = "\U0001F311"
    WAXING_CRESCENT_MOON = "\U0001F312"
    FIRST_QUARTER_MOON = "\U0001F313"
    WAXING_GIBBOUS_MOON = "\U0001F314"
    FULL_MOON = "\U0001F315"
    WANING_GIBBOUS_MOON = "\U0001F316"
    LAST_QUARTER_MOON = "\U0001F317"
    WANING_CRESCENT_MOON = "\U0001F318"
    CRESCENT_MOON = "\U0001F319"
    NEW_MOON_FACE = "\U0001F31A"
    FIRST_QUARTER_MOON_FACE = "\U0001F31B"
    LAST_QUARTER_MOON_FACE = "\U0001F31C"
    THERMOMETER = "\U0001F321"
    SUN = "\U00002600"
    FULL_MOON_FACE = "\U0001F31D"
    SUN_WITH_FACE = "\U0001F31E"
    RINGED_PLANET = "\U0001FA90"
    STAR = "\U00002B50"
    GLOWING_STAR = "\U0001F31F"
    SHOOTING_STAR = "\U0001F320"
    MILKY_WAY = "\U0001F30C"
    CLOUD = "\U00002601"
    SUN_BEHIND_CLOUD = "\U000026C5"
    CLOUD_WITH_LIGHTNING_AND_RAIN = "\U000026C8"
    SUN_BEHIND_SMALL_CLOUD = "\U0001F324"
    SUN_BEHIND_LARGE_CLOUD = "\U0001F325"
    SUN_BEHIND_RAIN_CLOUD = "\U0001F326"
    CLOUD_WITH_RAIN = "\U0001F327"
    CLOUD_WITH_SNOW = "\U0001F328"
    CLOUD_WITH_LIGHTNING = "\U0001F329"
    TORNADO = "\U0001F32A"
    FOG = "\U0001F32B"
    WIND_FACE = "\U0001F32C"
    CYCLONE = "\U0001F300"
    RAINBOW = "\U0001F308"
    CLOSED_UMBRELLA = "\U0001F302"
    UMBRELLA = "\U00002602"
    UMBRELLA_WITH_RAIN_DROPS = "\U00002614"
    UMBRELLA_ON_GROUND = "\U000026F1"
    HIGH_VOLTAGE = "\U000026A1"
    SNOWFLAKE = "\U00002744"
    SNOWMAN = "\U00002603"
    SNOWMAN_WITHOUT_SNOW = "\U000026C4"
    COMET = "\U00002604"
    FIRE = "\U0001F525"
    DROPLET = "\U0001F4A7"
    WATER_WAVE = "\U0001F30A"
    JACK_O_LANTERN = "\U0001F383"
    CHRISTMAS_TREE = "\U0001F384"
    FIREWORKS = "\U0001F386"
    SPARKLER = "\U0001F387"
    FIRECRACKER = "\U0001F9E8"
    SPARKLES = "\U00002728"
    BALLOON = "\U0001F388"
    PARTY_POPPER = "\U0001F389"
    CONFETTI_BALL = "\U0001F38A"
    TANABATA_TREE = "\U0001F38B"
    PINE_DECORATION = "\U0001F38D"
    JAPANESE_DOLLS = "\U0001F38E"
    CARP_STREAMER = "\U0001F38F"
    WIND_CHIME = "\U0001F390"
    MOON_VIEWING_CEREMONY = "\U0001F391"
    RED_ENVELOPE = "\U0001F9E7"
    RIBBON = "\U0001F380"
    WRAPPED_GIFT = "\U0001F381"
    REMINDER_RIBBON = "\U0001F397"
    ADMISSION_TICKETS = "\U0001F39F"
    TICKET = "\U0001F3AB"
    MILITARY_MEDAL = "\U0001F396"
    TROPHY = "\U0001F3C6"
    SPORTS_MEDAL = "\U0001F3C5"
    FIRST_PLACE_MEDAL = "\U0001F947"
    SECOND_PLACE_MEDAL = "\U0001F948"
    THIRD_PLACE_MEDAL = "\U0001F949"
    SOCCER_BALL = "\U000026BD"
    BASEBALL = "\U000026BE"
    SOFTBALL = "\U0001F94E"
    BASKETBALL = "\U0001F3C0"
    VOLLEYBALL = "\U0001F3D0"
    AMERICAN_FOOTBALL = "\U0001F3C8"
    RUGBY_FOOTBALL = "\U0001F3C9"
    TENNIS = "\U0001F3BE"
    FLYING_DISC = "\U0001F94F"
    BOWLING = "\U0001F3B3"
    CRICKET_GAME = "\U0001F3CF"
    FIELD_HOCKEY = "\U0001F3D1"
    ICE_HOCKEY = "\U0001F3D2"
    LACROSSE = "\U0001F94D"
    PING_PONG = "\U0001F3D3"
    BADMINTON = "\U0001F3F8"
    BOXING_GLOVE = "\U0001F94A"
    MARTIAL_ARTS_UNIFORM = "\U0001F94B"
    GOAL_NET = "\U0001F945"
    FLAG_IN_HOLE = "\U000026F3"
    ICE_SKATE = "\U000026F8"
    FISHING_POLE = "\U0001F3A3"
    DIVING_MASK = "\U0001F93F"
    RUNNING_SHIRT = "\U0001F3BD"
    SKIS = "\U0001F3BF"
    SLED = "\U0001F6F7"
    CURLING_STONE = "\U0001F94C"
    DIRECT_HIT = "\U0001F3AF"
    YO_YO = "\U0001FA80"
    KITE = "\U0001FA81"
    BALL = "\U0001F3B1"
    CRYSTAL_BALL = "\U0001F52E"
    MAGIC_WAND = "\U0001FA84"
    NAZAR_AMULET = "\U0001F9FF"
    VIDEO_GAME = "\U0001F3AE"
    JOYSTICK = "\U0001F579"
    SLOT_MACHINE = "\U0001F3B0"
    GAME_DIE = "\U0001F3B2"
    PUZZLE_PIECE = "\U0001F9E9"
    TEDDY_BEAR = "\U0001F9F8"
    PIñATA = "\U0001FA85"
    NESTING_DOLLS = "\U0001FA86"
    SPADE_SUIT = "\U00002660"
    HEART_SUIT = "\U00002665"
    DIAMOND_SUIT = "\U00002666"
    CLUB_SUIT = "\U00002663"
    CHESS_PAWN = "\U0000265F"
    JOKER = "\U0001F0CF"
    MAHJONG_RED_DRAGON = "\U0001F004"
    FLOWER_PLAYING_CARDS = "\U0001F3B4"
    PERFORMING_ARTS = "\U0001F3AD"
    FRAMED_PICTURE = "\U0001F5BC"
    ARTIST_PALETTE = "\U0001F3A8"
    THREAD = "\U0001F9F5"
    SEWING_NEEDLE = "\U0001FAA1"
    YARN = "\U0001F9F6"
    KNOT = "\U0001FAA2"
    GLASSES = "\U0001F453"
    SUNGLASSES = "\U0001F576"
    GOGGLES = "\U0001F97D"
    LAB_COAT = "\U0001F97C"
    SAFETY_VEST = "\U0001F9BA"
    NECKTIE = "\U0001F454"
    T_SHIRT = "\U0001F455"
    JEANS = "\U0001F456"
    SCARF = "\U0001F9E3"
    GLOVES = "\U0001F9E4"
    COAT = "\U0001F9E5"
    SOCKS = "\U0001F9E6"
    DRESS = "\U0001F457"
    KIMONO = "\U0001F458"
    SARI = "\U0001F97B"
    ONE_PIECE_SWIMSUIT = "\U0001FA71"
    BRIEFS = "\U0001FA72"
    SHORTS = "\U0001FA73"
    BIKINI = "\U0001F459"
    WOMANS_CLOTHES = "\U0001F45A"
    PURSE = "\U0001F45B"
    HANDBAG = "\U0001F45C"
    CLUTCH_BAG = "\U0001F45D"
    SHOPPING_BAGS = "\U0001F6CD"
    BACKPACK = "\U0001F392"
    THONG_SANDAL = "\U0001FA74"
    MANS_SHOE = "\U0001F45E"
    RUNNING_SHOE = "\U0001F45F"
    HIKING_BOOT = "\U0001F97E"
    FLAT_SHOE = "\U0001F97F"
    HIGH_HEELED_SHOE = "\U0001F460"
    WOMANS_SANDAL = "\U0001F461"
    BALLET_SHOES = "\U0001FA70"
    WOMANS_BOOT = "\U0001F462"
    CROWN = "\U0001F451"
    WOMANS_HAT = "\U0001F452"
    TOP_HAT = "\U0001F3A9"
    GRADUATION_CAP = "\U0001F393"
    BILLED_CAP = "\U0001F9E2"
    MILITARY_HELMET = "\U0001FA96"
    RESCUE_WORKERS_HELMET = "\U000026D1"
    PRAYER_BEADS = "\U0001F4FF"
    LIPSTICK = "\U0001F484"
    RING = "\U0001F48D"
    GEM_STONE = "\U0001F48E"
    MUTED_SPEAKER = "\U0001F507"
    SPEAKER_LOW_VOLUME = "\U0001F508"
    SPEAKER_MEDIUM_VOLUME = "\U0001F509"
    SPEAKER_HIGH_VOLUME = "\U0001F50A"
    LOUDSPEAKER = "\U0001F4E2"
    MEGAPHONE = "\U0001F4E3"
    POSTAL_HORN = "\U0001F4EF"
    BELL = "\U0001F514"
    BELL_WITH_SLASH = "\U0001F515"
    MUSICAL_SCORE = "\U0001F3BC"
    MUSICAL_NOTE = "\U0001F3B5"
    MUSICAL_NOTES = "\U0001F3B6"
    STUDIO_MICROPHONE = "\U0001F399"
    LEVEL_SLIDER = "\U0001F39A"
    CONTROL_KNOBS = "\U0001F39B"
    MICROPHONE = "\U0001F3A4"
    HEADPHONE = "\U0001F3A7"
    RADIO = "\U0001F4FB"
    SAXOPHONE = "\U0001F3B7"
    ACCORDION = "\U0001FA97"
    GUITAR = "\U0001F3B8"
    MUSICAL_KEYBOARD = "\U0001F3B9"
    TRUMPET = "\U0001F3BA"
    VIOLIN = "\U0001F3BB"
    BANJO = "\U0001FA95"
    DRUM = "\U0001F941"
    LONG_DRUM = "\U0001FA98"
    MOBILE_PHONE = "\U0001F4F1"
    MOBILE_PHONE_WITH_ARROW = "\U0001F4F2"
    TELEPHONE = "\U0000260E"
    TELEPHONE_RECEIVER = "\U0001F4DE"
    PAGER = "\U0001F4DF"
    FAX_MACHINE = "\U0001F4E0"
    BATTERY = "\U0001F50B"
    ELECTRIC_PLUG = "\U0001F50C"
    LAPTOP = "\U0001F4BB"
    DESKTOP_COMPUTER = "\U0001F5A5"
    PRINTER = "\U0001F5A8"
    KEYBOARD = "\U00002328"
    COMPUTER_MOUSE = "\U0001F5B1"
    TRACKBALL = "\U0001F5B2"
    COMPUTER_DISK = "\U0001F4BD"
    FLOPPY_DISK = "\U0001F4BE"
    OPTICAL_DISK = "\U0001F4BF"
    DVD = "\U0001F4C0"
    ABACUS = "\U0001F9EE"
    MOVIE_CAMERA = "\U0001F3A5"
    FILM_FRAMES = "\U0001F39E"
    FILM_PROJECTOR = "\U0001F4FD"
    CLAPPER_BOARD = "\U0001F3AC"
    TELEVISION = "\U0001F4FA"
    CAMERA = "\U0001F4F7"
    CAMERA_WITH_FLASH = "\U0001F4F8"
    VIDEO_CAMERA = "\U0001F4F9"
    VIDEOCASSETTE = "\U0001F4FC"
    MAGNIFYING_GLASS_TILTED_LEFT = "\U0001F50D"
    MAGNIFYING_GLASS_TILTED_RIGHT = "\U0001F50E"
    CANDLE = "\U0001F56F"
    LIGHT_BULB = "\U0001F4A1"
    FLASHLIGHT = "\U0001F526"
    RED_PAPER_LANTERN = "\U0001F3EE"
    DIYA_LAMP = "\U0001FA94"
    NOTEBOOK_WITH_DECORATIVE_COVER = "\U0001F4D4"
    CLOSED_BOOK = "\U0001F4D5"
    OPEN_BOOK = "\U0001F4D6"
    GREEN_BOOK = "\U0001F4D7"
    BLUE_BOOK = "\U0001F4D8"
    ORANGE_BOOK = "\U0001F4D9"
    BOOKS = "\U0001F4DA"
    NOTEBOOK = "\U0001F4D3"
    LEDGER = "\U0001F4D2"
    PAGE_WITH_CURL = "\U0001F4C3"
    SCROLL = "\U0001F4DC"
    PAGE_FACING_UP = "\U0001F4C4"
    NEWSPAPER = "\U0001F4F0"
    ROLLED_UP_NEWSPAPER = "\U0001F5DE"
    BOOKMARK_TABS = "\U0001F4D1"
    BOOKMARK = "\U0001F516"
    LABEL = "\U0001F3F7"
    MONEY_BAG = "\U0001F4B0"
    COIN = "\U0001FA99"
    YEN_BANKNOTE = "\U0001F4B4"
    DOLLAR_BANKNOTE = "\U0001F4B5"
    EURO_BANKNOTE = "\U0001F4B6"
    POUND_BANKNOTE = "\U0001F4B7"
    MONEY_WITH_WINGS = "\U0001F4B8"
    CREDIT_CARD = "\U0001F4B3"
    RECEIPT = "\U0001F9FE"
    CHART_INCREASING_WITH_YEN = "\U0001F4B9"
    ENVELOPE = "\U00002709"
    E_MAIL = "\U0001F4E7"
    INCOMING_ENVELOPE = "\U0001F4E8"
    ENVELOPE_WITH_ARROW = "\U0001F4E9"
    OUTBOX_TRAY = "\U0001F4E4"
    INBOX_TRAY = "\U0001F4E5"
    PACKAGE = "\U0001F4E6"
    CLOSED_MAILBOX_WITH_RAISED_FLAG = "\U0001F4EB"
    CLOSED_MAILBOX_WITH_LOWERED_FLAG = "\U0001F4EA"
    OPEN_MAILBOX_WITH_RAISED_FLAG = "\U0001F4EC"
    OPEN_MAILBOX_WITH_LOWERED_FLAG = "\U0001F4ED"
    POSTBOX = "\U0001F4EE"
    BALLOT_BOX_WITH_BALLOT = "\U0001F5F3"
    PENCIL = "\U0000270F"
    BLACK_NIB = "\U00002712"
    FOUNTAIN_PEN = "\U0001F58B"
    PEN = "\U0001F58A"
    PAINTBRUSH = "\U0001F58C"
    CRAYON = "\U0001F58D"
    MEMO = "\U0001F4DD"
    BRIEFCASE = "\U0001F4BC"
    FILE_FOLDER = "\U0001F4C1"
    OPEN_FILE_FOLDER = "\U0001F4C2"
    CARD_INDEX_DIVIDERS = "\U0001F5C2"
    CALENDAR = "\U0001F4C5"
    TEAR_OFF_CALENDAR = "\U0001F4C6"
    SPIRAL_NOTEPAD = "\U0001F5D2"
    SPIRAL_CALENDAR = "\U0001F5D3"
    CARD_INDEX = "\U0001F4C7"
    CHART_INCREASING = "\U0001F4C8"
    CHART_DECREASING = "\U0001F4C9"
    BAR_CHART = "\U0001F4CA"
    CLIPBOARD = "\U0001F4CB"
    PUSHPIN = "\U0001F4CC"
    ROUND_PUSHPIN = "\U0001F4CD"
    PAPERCLIP = "\U0001F4CE"
    LINKED_PAPERCLIPS = "\U0001F587"
    STRAIGHT_RULER = "\U0001F4CF"
    TRIANGULAR_RULER = "\U0001F4D0"
    SCISSORS = "\U00002702"
    CARD_FILE_BOX = "\U0001F5C3"
    FILE_CABINET = "\U0001F5C4"
    WASTEBASKET = "\U0001F5D1"
    LOCKED = "\U0001F512"
    UNLOCKED = "\U0001F513"
    LOCKED_WITH_PEN = "\U0001F50F"
    LOCKED_WITH_KEY = "\U0001F510"
    KEY = "\U0001F511"
    OLD_KEY = "\U0001F5DD"
    HAMMER = "\U0001F528"
    AXE = "\U0001FA93"
    PICK = "\U000026CF"
    HAMMER_AND_PICK = "\U00002692"
    HAMMER_AND_WRENCH = "\U0001F6E0"
    DAGGER = "\U0001F5E1"
    CROSSED_SWORDS = "\U00002694"
    PISTOL = "\U0001F52B"
    BOOMERANG = "\U0001FA83"
    BOW_AND_ARROW = "\U0001F3F9"
    SHIELD = "\U0001F6E1"
    CARPENTRY_SAW = "\U0001FA9A"
    WRENCH = "\U0001F527"
    SCREWDRIVER = "\U0001FA9B"
    NUT_AND_BOLT = "\U0001F529"
    GEAR = "\U00002699"
    CLAMP = "\U0001F5DC"
    BALANCE_SCALE = "\U00002696"
    WHITE_CANE = "\U0001F9AF"
    LINK = "\U0001F517"
    CHAINS = "\U000026D3"
    HOOK = "\U0001FA9D"
    TOOLBOX = "\U0001F9F0"
    MAGNET = "\U0001F9F2"
    LADDER = "\U0001FA9C"
    ALEMBIC = "\U00002697"
    TEST_TUBE = "\U0001F9EA"
    PETRI_DISH = "\U0001F9EB"
    DNA = "\U0001F9EC"
    MICROSCOPE = "\U0001F52C"
    TELESCOPE = "\U0001F52D"
    SATELLITE_ANTENNA = "\U0001F4E1"
    SYRINGE = "\U0001F489"
    DROP_OF_BLOOD = "\U0001FA78"
    PILL = "\U0001F48A"
    ADHESIVE_BANDAGE = "\U0001FA79"
    STETHOSCOPE = "\U0001FA7A"
    DOOR = "\U0001F6AA"
    ELEVATOR = "\U0001F6D7"
    MIRROR = "\U0001FA9E"
    WINDOW = "\U0001FA9F"
    BED = "\U0001F6CF"
    COUCH_AND_LAMP = "\U0001F6CB"
    CHAIR = "\U0001FA91"
    TOILET = "\U0001F6BD"
    PLUNGER = "\U0001FAA0"
    SHOWER = "\U0001F6BF"
    BATHTUB = "\U0001F6C1"
    MOUSE_TRAP = "\U0001FAA4"
    RAZOR = "\U0001FA92"
    LOTION_BOTTLE = "\U0001F9F4"
    SAFETY_PIN = "\U0001F9F7"
    BROOM = "\U0001F9F9"
    BASKET = "\U0001F9FA"
    ROLL_OF_PAPER = "\U0001F9FB"
    BUCKET = "\U0001FAA3"
    SOAP = "\U0001F9FC"
    TOOTHBRUSH = "\U0001FAA5"
    SPONGE = "\U0001F9FD"
    FIRE_EXTINGUISHER = "\U0001F9EF"
    SHOPPING_CART = "\U0001F6D2"
    CIGARETTE = "\U0001F6AC"
    COFFIN = "\U000026B0"
    HEADSTONE = "\U0001FAA6"
    FUNERAL_URN = "\U000026B1"
    MOAI = "\U0001F5FF"
    PLACARD = "\U0001FAA7"
    ATM_SIGN = "\U0001F3E7"
    LITTER_IN_BIN_SIGN = "\U0001F6AE"
    POTABLE_WATER = "\U0001F6B0"
    WHEELCHAIR_SYMBOL = "\U0000267F"
    MENS_ROOM = "\U0001F6B9"
    WOMENS_ROOM = "\U0001F6BA"
    RESTROOM = "\U0001F6BB"
    BABY_SYMBOL = "\U0001F6BC"
    WATER_CLOSET = "\U0001F6BE"
    PASSPORT_CONTROL = "\U0001F6C2"
    CUSTOMS = "\U0001F6C3"
    BAGGAGE_CLAIM = "\U0001F6C4"
    LEFT_LUGGAGE = "\U0001F6C5"
    WARNING = "\U000026A0"
    CHILDREN_CROSSING = "\U0001F6B8"
    NO_ENTRY = "\U000026D4"
    PROHIBITED = "\U0001F6AB"
    NO_BICYCLES = "\U0001F6B3"
    NO_SMOKING = "\U0001F6AD"
    NO_LITTERING = "\U0001F6AF"
    NON_POTABLE_WATER = "\U0001F6B1"
    NO_PEDESTRIANS = "\U0001F6B7"
    NO_MOBILE_PHONES = "\U0001F4F5"
    NO_ONE_UNDER_EIGHTEEN = "\U0001F51E"
    RADIOACTIVE = "\U00002622"
    BIOHAZARD = "\U00002623"
    UP_ARROW = "\U00002B06"
    UP_RIGHT_ARROW = "\U00002197"
    RIGHT_ARROW = "\U000027A1"
    DOWN_RIGHT_ARROW = "\U00002198"
    DOWN_ARROW = "\U00002B07"
    DOWN_LEFT_ARROW = "\U00002199"
    LEFT_ARROW = "\U00002B05"
    UP_LEFT_ARROW = "\U00002196"
    UP_DOWN_ARROW = "\U00002195"
    LEFT_RIGHT_ARROW = "\U00002194"
    RIGHT_ARROW_CURVING_LEFT = "\U000021A9"
    LEFT_ARROW_CURVING_RIGHT = "\U000021AA"
    RIGHT_ARROW_CURVING_UP = "\U00002934"
    RIGHT_ARROW_CURVING_DOWN = "\U00002935"
    CLOCKWISE_VERTICAL_ARROWS = "\U0001F503"
    COUNTERCLOCKWISE_ARROWS_BUTTON = "\U0001F504"
    BACK_ARROW = "\U0001F519"
    END_ARROW = "\U0001F51A"
    ON_ARROW = "\U0001F51B"
    SOON_ARROW = "\U0001F51C"
    TOP_ARROW = "\U0001F51D"
    PLACE_OF_WORSHIP = "\U0001F6D0"
    ATOM_SYMBOL = "\U0000269B"
    OM = "\U0001F549"
    STAR_OF_DAVID = "\U00002721"
    WHEEL_OF_DHARMA = "\U00002638"
    YIN_YANG = "\U0000262F"
    LATIN_CROSS = "\U0000271D"
    ORTHODOX_CROSS = "\U00002626"
    STAR_AND_CRESCENT = "\U0000262A"
    PEACE_SYMBOL = "\U0000262E"
    MENORAH = "\U0001F54E"
    DOTTED_SIX_POINTED_STAR = "\U0001F52F"
    ARIES = "\U00002648"
    TAURUS = "\U00002649"
    GEMINI = "\U0000264A"
    CANCER = "\U0000264B"
    LEO = "\U0000264C"
    VIRGO = "\U0000264D"
    LIBRA = "\U0000264E"
    SCORPIO = "\U0000264F"
    SAGITTARIUS = "\U00002650"
    CAPRICORN = "\U00002651"
    AQUARIUS = "\U00002652"
    PISCES = "\U00002653"
    OPHIUCHUS = "\U000026CE"
    SHUFFLE_TRACKS_BUTTON = "\U0001F500"
    REPEAT_BUTTON = "\U0001F501"
    REPEAT_SINGLE_BUTTON = "\U0001F502"
    PLAY_BUTTON = "\U000025B6"
    FAST_FORWARD_BUTTON = "\U000023E9"
    NEXT_TRACK_BUTTON = "\U000023ED"
    PLAY_OR_PAUSE_BUTTON = "\U000023EF"
    REVERSE_BUTTON = "\U000025C0"
    FAST_REVERSE_BUTTON = "\U000023EA"
    LAST_TRACK_BUTTON = "\U000023EE"
    UPWARDS_BUTTON = "\U0001F53C"
    FAST_UP_BUTTON = "\U000023EB"
    DOWNWARDS_BUTTON = "\U0001F53D"
    FAST_DOWN_BUTTON = "\U000023EC"
    PAUSE_BUTTON = "\U000023F8"
    STOP_BUTTON = "\U000023F9"
    RECORD_BUTTON = "\U000023FA"
    EJECT_BUTTON = "\U000023CF"
    CINEMA = "\U0001F3A6"
    DIM_BUTTON = "\U0001F505"
    BRIGHT_BUTTON = "\U0001F506"
    ANTENNA_BARS = "\U0001F4F6"
    VIBRATION_MODE = "\U0001F4F3"
    MOBILE_PHONE_OFF = "\U0001F4F4"
    FEMALE_SIGN = "\U00002640"
    MALE_SIGN = "\U00002642"
    TRANSGENDER_SYMBOL = "\U000026A7"
    MULTIPLY = "\U00002716"
    PLUS = "\U00002795"
    MINUS = "\U00002796"
    DIVIDE = "\U00002797"
    INFINITY = "\U0000267E"
    DOUBLE_EXCLAMATION_MARK = "\U0000203C"
    EXCLAMATION_QUESTION_MARK = "\U00002049"
    QUESTION_MARK = "\U00002753"
    WHITE_QUESTION_MARK = "\U00002754"
    WHITE_EXCLAMATION_MARK = "\U00002755"
    EXCLAMATION_MARK = "\U00002757"
    WAVY_DASH = "\U00003030"
    CURRENCY_EXCHANGE = "\U0001F4B1"
    HEAVY_DOLLAR_SIGN = "\U0001F4B2"
    MEDICAL_SYMBOL = "\U00002695"
    RECYCLING_SYMBOL = "\U0000267B"
    FLEUR_DE_LIS = "\U0000269C"
    TRIDENT_EMBLEM = "\U0001F531"
    NAME_BADGE = "\U0001F4DB"
    JAPANESE_SYMBOL_FOR_BEGINNER = "\U0001F530"
    HOLLOW_RED_CIRCLE = "\U00002B55"
    CHECK_MARK_BUTTON = "\U00002705"
    CHECK_BOX_WITH_CHECK = "\U00002611"
    CHECK_MARK = "\U00002714"
    CROSS_MARK = "\U0000274C"
    CROSS_MARK_BUTTON = "\U0000274E"
    CURLY_LOOP = "\U000027B0"
    DOUBLE_CURLY_LOOP = "\U000027BF"
    PART_ALTERNATION_MARK = "\U0000303D"
    EIGHT_SPOKED_ASTERISK = "\U00002733"
    EIGHT_POINTED_STAR = "\U00002734"
    SPARKLE = "\U00002747"
    COPYRIGHT = "\U000000A9"
    REGISTERED = "\U000000AE"
    TRADE_MARK = "\U00002122"
    INPUT_LATIN_UPPERCASE = "\U0001F520"
    INPUT_LATIN_LOWERCASE = "\U0001F521"
    INPUT_NUMBERS = "\U0001F522"
    INPUT_SYMBOLS = "\U0001F523"
    INPUT_LATIN_LETTERS = "\U0001F524"
    A_BUTTON_BLOOD_TYPE = "\U0001F170"
    AB_BUTTON_BLOOD_TYPE = "\U0001F18E"
    B_BUTTON_BLOOD_TYPE = "\U0001F171"
    CL_BUTTON = "\U0001F191"
    COOL_BUTTON = "\U0001F192"
    FREE_BUTTON = "\U0001F193"
    INFORMATION = "\U00002139"
    ID_BUTTON = "\U0001F194"
    CIRCLED_M = "\U000024C2"
    NEW_BUTTON = "\U0001F195"
    NG_BUTTON = "\U0001F196"
    O_BUTTON_BLOOD_TYPE = "\U0001F17E"
    OK_BUTTON = "\U0001F197"
    P_BUTTON = "\U0001F17F"
    SOS_BUTTON = "\U0001F198"
    UP_BUTTON = "\U0001F199"
    VS_BUTTON = "\U0001F19A"
    JAPANESE_HERE_BUTTON = "\U0001F201"
    JAPANESE_SERVICE_CHARGE_BUTTON = "\U0001F202"
    JAPANESE_MONTHLY_AMOUNT_BUTTON = "\U0001F237"
    JAPANESE_NOT_FREE_OF_CHARGE_BUTTON = "\U0001F236"
    JAPANESE_RESERVED_BUTTON = "\U0001F22F"
    JAPANESE_BARGAIN_BUTTON = "\U0001F250"
    JAPANESE_DISCOUNT_BUTTON = "\U0001F239"
    JAPANESE_FREE_OF_CHARGE_BUTTON = "\U0001F21A"
    JAPANESE_PROHIBITED_BUTTON = "\U0001F232"
    JAPANESE_ACCEPTABLE_BUTTON = "\U0001F251"
    JAPANESE_APPLICATION_BUTTON = "\U0001F238"
    JAPANESE_PASSING_GRADE_BUTTON = "\U0001F234"
    JAPANESE_VACANCY_BUTTON = "\U0001F233"
    JAPANESE_CONGRATULATIONS_BUTTON = "\U00003297"
    JAPANESE_SECRET_BUTTON = "\U00003299"
    JAPANESE_OPEN_FOR_BUSINESS_BUTTON = "\U0001F23A"
    JAPANESE_NO_VACANCY_BUTTON = "\U0001F235"
    RED_CIRCLE = "\U0001F534"
    ORANGE_CIRCLE = "\U0001F7E0"
    YELLOW_CIRCLE = "\U0001F7E1"
    GREEN_CIRCLE = "\U0001F7E2"
    BLUE_CIRCLE = "\U0001F535"
    PURPLE_CIRCLE = "\U0001F7E3"
    BROWN_CIRCLE = "\U0001F7E4"
    BLACK_CIRCLE = "\U000026AB"
    WHITE_CIRCLE = "\U000026AA"
    RED_SQUARE = "\U0001F7E5"
    ORANGE_SQUARE = "\U0001F7E7"
    YELLOW_SQUARE = "\U0001F7E8"
    GREEN_SQUARE = "\U0001F7E9"
    BLUE_SQUARE = "\U0001F7E6"
    PURPLE_SQUARE = "\U0001F7EA"
    BROWN_SQUARE = "\U0001F7EB"
    BLACK_LARGE_SQUARE = "\U00002B1B"
    WHITE_LARGE_SQUARE = "\U00002B1C"
    BLACK_MEDIUM_SQUARE = "\U000025FC"
    WHITE_MEDIUM_SQUARE = "\U000025FB"
    BLACK_MEDIUM_SMALL_SQUARE = "\U000025FE"
    WHITE_MEDIUM_SMALL_SQUARE = "\U000025FD"
    BLACK_SMALL_SQUARE = "\U000025AA"
    WHITE_SMALL_SQUARE = "\U000025AB"
    LARGE_ORANGE_DIAMOND = "\U0001F536"
    LARGE_BLUE_DIAMOND = "\U0001F537"
    SMALL_ORANGE_DIAMOND = "\U0001F538"
    SMALL_BLUE_DIAMOND = "\U0001F539"
    RED_TRIANGLE_POINTED_UP = "\U0001F53A"
    RED_TRIANGLE_POINTED_DOWN = "\U0001F53B"
    DIAMOND_WITH_A_DOT = "\U0001F4A0"
    RADIO_BUTTON = "\U0001F518"
    WHITE_SQUARE_BUTTON = "\U0001F533"
    BLACK_SQUARE_BUTTON = "\U0001F532"
    CHEQUERED_FLAG = "\U0001F3C1"
    TRIANGULAR_FLAG = "\U0001F6A9"
    CROSSED_FLAGS = "\U0001F38C"
    BLACK_FLAG = "\U0001F3F4"
    WHITE_FLAG = "\U0001F3F3"
