"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.YamlFile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs_1 = require("fs");
const YAML = require("yaml");
const json_patch_1 = require("./json-patch");
/**
 * Represents a Yaml File.
 */
class YamlFile {
    constructor(filePath, options = {}) {
        this.filePath = filePath;
        this.obj = options.obj ?? {};
        this.patchOperations = [];
        // default value for commentAtTop
        this.commentAtTop = `AUTOMATICALLY GENERATED FILE, DO NOT EDIT MANUALLY.
Generated by AWS CDK and [cdk-pipelines-github](https://github.com/cdklabs/cdk-pipelines-github)`;
    }
    /**
     * Update the output object.
     */
    update(obj) {
        this.obj = obj;
    }
    /**
     * Applies an RFC 6902 JSON-patch to the synthesized object file.
     * See https://datatracker.ietf.org/doc/html/rfc6902 for more information.
     *
     * For example, with the following yaml file
     * ```yaml
     * name: deploy
     * on:
     *   push:
     *     branches:
     *       - main
     *   workflow_dispatch: {}
     * ...
     * ```
     *
     * modified in the following way:
     *
     * ```ts
     * pipeline.workflowFile.patch(JsonPatch.add("/on/workflow_call", "{}"));
     * pipeline.workflowFile.patch(JsonPatch.remove("/on/workflow_dispatch"));
     * ```
     *
     * would result in the following yaml file:
     *
     * ```yaml
     * name: deploy
     * on:
     *   push:
     *     branches:
     *       - main
     *   workflow_call: {}
     * ...
     * ```
     *
     * @param patches - The patch operations to apply
     */
    patch(...patches) {
        this.patchOperations.push(...patches);
    }
    /**
     * Returns the patched yaml file.
     */
    toYaml() {
        const patched = json_patch_1.JsonPatch.apply(this.obj, ...this.patchOperations);
        const yamlDoc = new YAML.Document(patched);
        yamlDoc.commentBefore = this.commentAtTop ?? null;
        return yamlDoc.toString({
            commentString: (comment) => comment.split('\n').map((x) => x == '' ? '' : `# ${x}`).join('\n'),
            indent: 2,
        });
    }
    /**
     * Write the patched yaml file to the specified location.
     */
    writeFile() {
        fs_1.writeFileSync(this.filePath, this.toYaml());
    }
}
exports.YamlFile = YamlFile;
_a = JSII_RTTI_SYMBOL_1;
YamlFile[_a] = { fqn: "cdk-pipelines-github.YamlFile", version: "0.3.3" };
//# sourceMappingURL=data:application/json;base64,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