"""
(System)Verilog language keyword lists
"""

IEEE1364_1995_KEYWORDS = [
    "always",
    "and",
    "assign",
    "begin",
    "buf",
    "bufif0",
    "bufif1",
    "case",
    "casex",
    "casez",
    "cmos",
    "deassign",
    "default",
    "defparam",
    "disable",
    "edge",
    "else",
    "end",
    "endcase",
    "endfunction",
    "endmodule",
    "endprimitive",
    "endspecify",
    "endtable",
    "endtask",
    "event",
    "for",
    "force",
    "forever",
    "fork",
    "function",
    "highz0",
    "highz1",
    "if",
    "ifnone",
    "rpmos",
    "initial",
    "rtran",
    "inout",
    "rtranif0",
    "input",
    "rtranif1",
    "integer",
    "scalared",
    "join",
    "small",
    "large",
    "specify",
    "macromodule",
    "specparam",
    "medium",
    "strong0",
    "module",
    "strong1",
    "nand",
    "supply0",
    "negedge",
    "supply1",
    "nmos",
    "table",
    "nor",
    "task",
    "not",
    "time",
    "notif0",
    "tran",
    "notif1",
    "tranif0",
    "or",
    "tranif1",
    "output",
    "tri",
    "parameter",
    "tri0",
    "pmos",
    "tri1",
    "posedge",
    "triand",
    "primitive",
    "trior",
    "pull0",
    "trireg",
    "pull1",
    "vectored",
    "pulldown",
    "wait",
    "pullup",
    "wand",
    "rcmos",
    "weak0",
    "real",
    "weak1",
    "realtime",
    "while",
    "reg",
    "wire",
    "release",
    "wor",
    "repeat",
    "xnor",
    "rnmos",
    "xor",
]

IEEE1364_2001_KEYWORDS = IEEE1364_1995_KEYWORDS + [
    "automatic",
    "cell",
    "config",
    "incdir",
    "include",
    "instance",
    "liblist",
    "library",
    "localparam",
    "noshowcancelled",
    "pulsestyle_ondetect",
    "design",
    "endconfig",
    "endgenerate",
    "generate",
    "genvar",
    "pulsestyle_onevent",
    "showcancelled",
    "signed",
    "unsigned",
    "use",
]

IEEE1364_2001_NOCONFIG_KEYWORDS = [
    kw for kw in IEEE1364_2001_KEYWORDS if kw not in {
        "cell",
        "config",
        "design",
        "endconfig",
        "incdir",
        "include",
        "instance",
        "liblist",
        "library",
        "use",
    }
]

IEEE1364_2005_KEYWORDS = IEEE1364_2001_KEYWORDS + ["uwire"]

IEEE1800_2005_KEYWORDS = IEEE1364_2005_KEYWORDS + [
    "alias",
    "endsequence",
    "pure",
    "always_comb",
    "enum",
    "rand",
    "always_ff",
    "expect",
    "randc",
    "always_latch",
    "export",
    "randcase",
    "assert",
    "extends",
    "randsequence",
    "assume",
    "extern",
    "ref",
    "before",
    "final",
    "return",
    "bind",
    "first_match",
    "sequence",
    "bins",
    "foreach",
    "shortint",
    "binsof",
    "forkjoin",
    "shortreal",
    "bit",
    "iff",
    "solve",
    "break",
    "ignore_bins",
    "static",
    "byte",
    "illegal_bins",
    "string",
    "chandle",
    "import",
    "struct",
    "class",
    "inside",
    "super",
    "clocking",
    "int",
    "tagged",
    "const",
    "interface",
    "this",
    "constraint",
    "intersect",
    "throughout",
    "context",
    "join_any",
    "timeprecision",
    "continue",
    "join_none",
    "timeunit",
    "cover",
    "local",
    "type",
    "covergroup",
    "logic",
    "typedef",
    "coverpoint",
    "longint",
    "union",
    "cross",
    "matches",
    "unique",
    "dist",
    "modport",
    "var",
    "do",
    "new",
    "virtual",
    "endclass",
    "null",
    "void",
    "endclocking",
    "package",
    "wait_order",
    "endgroup",
    "packed",
    "wildcard",
    "endinterface",
    "priority",
    "with",
    "endpackage",
    "program",
    "within",
    "endprogram",
    "property",
    "endproperty",
    "protected",
]

IEEE1800_2009_KEYWORDS = IEEE1800_2005_KEYWORDS + [
    "accept_on",
    "checker",
    "endchecker",
    "eventually",
    "global",
    "implies",
    "let",
    "nexttime",
    "reject_on",
    "restrict",
    "s_always",
    "s_eventually",
    "s_nexttime",
    "s_until",
    "s_until_with",
    "strong",
    "sync_accept_on",
    "sync_reject_on",
    "unique0",
    "until",
    "until_with",
    "untyped",
    "weak",
]

IEEE1800_2012_KEYWORDS = IEEE1800_2009_KEYWORDS + [
    "implements",
    "nettype",
    "interconnect",
    "soft",
]

IEEE1800_2017_KEYWORDS = IEEE1800_2012_KEYWORDS + [
]

IEEE1800_2017_DOLAR_SYMBOLS = [
    #Simulation control tasks (20.2) 
    '$finish',
    '$stop',
    '$exit',
    # Simulation time functions (20.3)
    '$realtime',
    '$stime',
    '$time',
    # Timescale tasks (20.4)',
    '$printtimescale',
    '$timeformat',
    # Conversion functions (20.5)',
    '$bitstoreal',
    '$realtobits',
    '$bitstoshortreal',
    '$shortrealtobits',
    '$itor',
    '$rtoi',
    '$signed',
    '$unsigned',
    '$cast',
    # Data query functions (20.6)
    '$bits',
    '$isunbounded',
    '$typename',
    # Array query functions (20.7)
    '$unpacked_dimensions',
    '$dimensions',
    '$left',
    '$right',
    '$low',
    '$high',
    '$increment'
    '$size',
    # Math functions (20.8)
    '$clog2',
    '$asin',
    '$ln',
    '$acos',
    '$log10',
    '$atan',
    '$exp',
    '$atan2',
    '$sqrt',
    '$hypot',
    '$pow',
    '$sinh',
    '$floor',
    '$cosh',
    '$ceil',
    '$tanh',
    '$sin',
    '$asinh',
    '$cos',
    '$acosh',
    '$tan',
    '$atanh',
    # Bit vector system functions (20.9)
    '$countbits',
    '$countones',
    '$onehot',
    '$onehot0',
    '$isunknown',
    # Severity tasks (20.10)
    # Elaboration tasks (20.11)
    '$fatal',
    '$error',
    '$warning',
    '$info',
    # Assertion control tasks (20.12)
    '$asserton',
    '$assertoff',
    '$assertkill',
    '$assertcontrol',
    '$assertpasson',
    '$assertpassoff',
    '$assertfailon',
    '$assertfailoff',
    '$assertnonvacuouson',
    '$assertvacuousoff',
    # Sampled value system functions (20.13)
    '$sampled',
    '$rose',
    '$fell',
    '$stable',
    '$changed',
    '$past',
    '$past_gclk',
    '$rose_gclk',
    '$fell_gclk',
    '$stable_gclk',
    '$changed_gclk',
    '$future_gclk',
    '$rising_gclk',
    '$falling_gclk',
    '$steady_gclk',
    '$changing_gclk',
    # Coverage control functions (20.14)
    '$coverage_control',
    '$coverage_get_max',
    '$coverage_get',
    '$coverage_merge',
    '$coverage_save',
    '$get_coverage',
    '$set_coverage_db_name',
    '$load_coverage_db',
    # Probabilistic distribution functions (20.15)
    '$random',
    '$dist_chi_square',
    '$dist_erlang',
    '$dist_exponential',
    '$dist_normal',
    '$dist_poisson',
    '$dist_t',
    '$dist_uniform',
    # Stochastic analysis tasks and functions (20.16)
    '$q_initialize',
    '$q_add',
    '$q_remove',
    '$q_full',
    '$q_exam',
    # PLA modeling tasks (20.17)
    '$async$and$array',
    '$async$and$plane',
    '$async$nand$array',
    '$async$nand$plane',
    '$async$or$array',
    '$async$or$plane',
    '$async$nor$array',
    '$async$nor$plane',
    '$sync$and$array',
    '$sync$and$plane',
    '$sync$nand$array',
    '$sync$nand$plane',
    '$sync$or$array',
    '$sync$or$plane',
    '$sync$nor$array',
    '$sync$nor$plane',
    # Miscellaneous tasks and functions (20.18)
    '$system',
    #Display tasks (21.2)
    '$display',
    '$write',
    '$displayb',
    '$writeb',
    '$displayh',
    '$writeh ',
    '$displayo',
    '$writeo',
    '$strobe',
    '$monitor ',
    '$strobeb',
    '$monitorb',
    '$strobeh',
    '$monitorh',
    '$strobeo',
    '$monitoro',
    '$monitoroff',
    '$monitoron',
    # File I/O tasks and functions (21.3)
    '$fclose',
    '$fopen',
    '$fdisplay',
    '$fwrite',
    '$fdisplayb',
    '$fwriteb',
    '$fdisplayh',
    '$fwriteh ',
    '$fdisplayo',
    '$fwriteo',
    '$fstrobe',
    '$fmonitor ',
    '$fstrobeb',
    '$fmonitorb',
    '$fstrobeh',
    '$fmonitorh',
    '$fstrobeo',
    '$fmonitoro',
    '$swrite',
    '$sformat',
    '$swriteb',
    '$sformatf ',
    '$swriteh',
    '$fgetc',
    '$swriteo',
    '$ungetc',
    '$fscanf',
    '$fgets',
    '$fread',
    '$sscanf',
    '$fseek',
    '$rewind',
    '$fflush',
    '$ftell',
    '$feof ',
    '$ferror',
    # Memory load tasks (21.4)
    '$readmemb',
    '$readmemh',
    # Memory dump tasks (21.5)
    '$writememb',
    '$writememh',
    # Command line input (21.6)
    '$test',
    '$value',
    '$plusargs',
    # VCD tasks (21.7)
    '$dumpfile',
    '$dumpvars',
    '$dumpoff',
    '$dumpon',
    '$dumpall',
    '$dumplimit',
    '$dumpflush',
    '$dumpports',
    '$dumpportsoff',
    '$dumpportson',
    '$dumpportsall',
    '$dumpportslimit',
    '$dumpportsflush',
    
]