(self["webpackChunkglobus_jupyterlab"] = self["webpackChunkglobus_jupyterlab"] || []).push([["lib_index_js-node_modules_moment_locale_sync_recursive_"],{

/***/ "./lib/components/Endpoint.js":
/*!************************************!*\
  !*** ./lib/components/Endpoint.js ***!
  \************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
const react_router_dom_1 = __webpack_require__(/*! react-router-dom */ "webpack/sharing/consume/default/react-router-dom/react-router-dom");
const react_1 = __importStar(__webpack_require__(/*! react */ "webpack/sharing/consume/default/react"));
const react_router_dom_2 = __webpack_require__(/*! react-router-dom */ "webpack/sharing/consume/default/react-router-dom/react-router-dom");
const recoil_1 = __webpack_require__(/*! recoil */ "webpack/sharing/consume/default/recoil/recoil");
const GlobusObjects_1 = __webpack_require__(/*! ./GlobusObjects */ "./lib/components/GlobusObjects.js");
const Endpoint = (props) => {
    // Local State
    const [apiError, setAPIError] = react_1.useState(null);
    const [endpointList, setEndpointList] = react_1.useState({ DATA: [] });
    const [endpoint, setEndpoint] = react_1.useState(null);
    const [loading, setLoading] = react_1.useState(false);
    const [selectedEndpointItems, setSelectedEndpointItems] = react_1.useState([]);
    const [transferDirection, setTransferDirection] = react_1.useState(null);
    // Recoil (global) State
    const config = recoil_1.useRecoilValue(GlobusObjects_1.ConfigAtom);
    // React Router history and params
    let history = react_router_dom_2.useHistory();
    let params = react_router_dom_2.useParams();
    let endpointID = params.endpointID;
    let path = params.path;
    // ComponentDidMount Functions
    react_1.useEffect(() => {
        getEndpoint(endpointID);
    }, [endpointID]);
    react_1.useEffect(() => {
        listEndpointItems(endpointID, path);
    }, [endpointID, path]);
    const getEndpoint = (endpointID) => __awaiter(void 0, void 0, void 0, function* () {
        try {
            let response = yield fetch(`/globus-jupyterlab/endpoint_detail?endpoint=${endpointID}`, {
                headers: {
                    Accept: 'application/json',
                    'Content-Type': 'application/json',
                },
            });
            let endpoint = yield response.json();
            if ('error' in endpoint) {
                throw endpoint;
            }
            setEndpoint(endpoint);
        }
        catch (error) {
            setAPIError(error);
        }
    });
    const listEndpointItems = (endpointID, path = null) => __awaiter(void 0, void 0, void 0, function* () {
        setAPIError(null);
        setEndpointList({ DATA: [] });
        setLoading(true);
        try {
            let url = `/globus-jupyterlab/operation_ls?endpoint=${endpointID}`;
            if (path) {
                url = `${url}&path=${path}`;
            }
            const response = yield fetch(url, {
                headers: {
                    Accept: 'application/json',
                    'Content-Type': 'application/json',
                },
            });
            const listItems = yield response.json();
            if ('error' in listItems) {
                throw listItems;
            }
            setEndpointList(listItems);
        }
        catch (error) {
            /* Note: This probably isn't a great UX to simply pop up a login page, but it
            does demonstrate the base functionality for picking endpoints */
            if ('login_url' in error) {
                window.open(error.login_url, 'Globus Login', 'height=600,width=800').focus();
            }
            setAPIError(error);
        }
        setLoading(false);
    });
    // Event Handlers
    const handleEndpointItemSelect = (event) => {
        if (event.target.checked) {
            setSelectedEndpointItems((selectedEndpointItems) => {
                return [JSON.parse(event.target.value), ...selectedEndpointItems];
            });
        }
        else {
            const removeItem = JSON.parse(event.target.value);
            const index = selectedEndpointItems
                .map((item) => {
                return item.name;
            })
                .indexOf(removeItem.name);
            if (index > -1) {
                selectedEndpointItems.splice(index, 1);
                setSelectedEndpointItems(selectedEndpointItems);
            }
        }
    };
    const handleTransferDirection = (event) => {
        setTransferDirection(event.currentTarget.value);
    };
    const handleTransferRequest = (event) => {
        event.preventDefault();
        var transferItems = [];
        var sourceEndpoint = transferDirection == 'transfer-to-endpoint' ? config.collection_id : endpoint.id;
        var destinationEndpoint = transferDirection == 'transfer-to-endpoint' ? endpoint.id : config.collection_id;
        console.log(props);
        if (transferDirection == 'transfer-to-endpoint') {
            // Loop through selectedJupyterItems from props
            if (props.selectedJupyterItems.directories.length) {
                for (let directory of props.selectedJupyterItems.directories) {
                    transferItems.push({
                        source_path: `${config.collection_base_path}/${directory.path}`,
                        destination_path: directory.path,
                        recursive: true
                    });
                }
                ;
            }
            if (props.selectedJupyterItems.files.length) {
                for (let file of props.selectedJupyterItems.files) {
                    transferItems.push({
                        source_path: `${config.collection_base_path}/${file.path}`,
                        destination_path: file.path,
                        recursive: false
                    });
                }
            }
        }
        else {
            // Loop through selectedEndpointItems from state
            for (let selectedEndpointItem of selectedEndpointItems) {
                transferItems.push({
                    source_path: selectedEndpointItem.name,
                    destination_path: `${config.collection_base_path}/${selectedEndpointItem.name}`,
                    recursive: selectedEndpointItem.type == 'dir' ? true : false,
                });
            }
            ;
        }
        let transferRequest = {
            sourceEndpoint: sourceEndpoint,
            destinationEndpoint: destinationEndpoint,
            transfer_items: transferItems,
        };
        console.log(transferRequest);
    };
    if (apiError) {
        return (react_1.default.createElement(react_1.default.Fragment, null,
            react_1.default.createElement("button", { className: 'btn btn-sm btn-primary mb-4 mt-5', onClick: () => history.goBack() }, "Back"),
            react_1.default.createElement("p", { className: 'fw-bold mt-3 text-danger' },
                "Error: ",
                apiError['error'],
                ". Please try again.")));
    }
    if (loading) {
        return react_1.default.createElement("h5", { className: 'mt-5' }, "Loading");
    }
    return (react_1.default.createElement(react_1.default.Fragment, null, endpointList['DATA'].length > 0 ? (react_1.default.createElement("div", { className: 'mt-5' },
        react_1.default.createElement("h5", null,
            "Browsing Collection ",
            endpoint ? endpoint.display_name : endpointID),
        react_1.default.createElement("button", { className: 'btn btn-sm btn-primary mb-4 mt-2', onClick: () => history.goBack() }, "Back"),
        react_1.default.createElement("br", null),
        endpointList['DATA'].map((listItem) => {
            return (react_1.default.createElement("div", { className: 'form-check' }, listItem['type'] == 'dir' ? (react_1.default.createElement(react_1.default.Fragment, null,
                react_1.default.createElement("input", { onChange: handleEndpointItemSelect, className: 'form-check-input', type: 'checkbox', value: JSON.stringify(listItem), "data-list-item-name": listItem['name'] }),
                react_1.default.createElement("label", null,
                    react_1.default.createElement(react_router_dom_1.Link, { to: `/endpoints/${endpointID}/items/${listItem['name']}` },
                        react_1.default.createElement("i", { className: 'fa-solid fa-folder-open' }),
                        " ",
                        listItem['name'])))) : (react_1.default.createElement(react_1.default.Fragment, null,
                react_1.default.createElement("input", { onChange: handleEndpointItemSelect, className: 'form-check-input', type: 'checkbox', value: JSON.stringify(listItem), "data-list-item-name": listItem['name'] }),
                react_1.default.createElement("label", null,
                    react_1.default.createElement("i", { className: 'fa-solid fa-file' }),
                    " ",
                    listItem['name'])))));
        }),
        selectedEndpointItems.length > 0 && (react_1.default.createElement(react_1.default.Fragment, null,
            react_1.default.createElement("div", { className: 'form-check form-check-inline mt-4' },
                react_1.default.createElement("input", { className: 'form-check-input', onChange: handleTransferDirection, type: 'radio', name: 'transfer-direction', id: 'transfer-to-endpoint', value: 'transfer-to-endpoint' }),
                react_1.default.createElement("label", { className: 'form-check-label', htmlFor: 'transfer-to-endpoint' }, "Transfer to Collection")),
            react_1.default.createElement("div", { className: 'form-check form-check-inline' },
                react_1.default.createElement("input", { className: 'form-check-input', onChange: handleTransferDirection, type: 'radio', name: 'transfer-direction', id: 'transfer-from-endpoint', value: 'transfer-from-endpoint' }),
                react_1.default.createElement("label", { className: 'form-check-label', htmlFor: 'transfer-from-endpoint' }, "Transfer from Collection")),
            react_1.default.createElement("div", { className: 'form-check form-check-inline pl-0' },
                react_1.default.createElement("button", { className: 'btn btn-sm btn-primary', onClick: handleTransferRequest, type: 'button' }, "Submit Transfer Request")))))) : (react_1.default.createElement("div", null,
        react_1.default.createElement("button", { className: 'btn btn-sm btn-primary mb-2 mt-3', onClick: () => history.goBack() }, "Back"),
        react_1.default.createElement("p", null, "No files or folders found")))));
};
exports["default"] = Endpoint;


/***/ }),

/***/ "./lib/components/EndpointSearch.js":
/*!******************************************!*\
  !*** ./lib/components/EndpointSearch.js ***!
  \******************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
const react_1 = __importStar(__webpack_require__(/*! react */ "webpack/sharing/consume/default/react"));
const react_router_dom_1 = __webpack_require__(/*! react-router-dom */ "webpack/sharing/consume/default/react-router-dom/react-router-dom");
const Endpoint_1 = __importDefault(__webpack_require__(/*! ./Endpoint */ "./lib/components/Endpoint.js"));
const Endpoints_1 = __importDefault(__webpack_require__(/*! ./Endpoints */ "./lib/components/Endpoints.js"));
const EndpointSearch = (props) => {
    const [apiError, setAPIError] = react_1.useState(null);
    const [endpoints, setEndpoints] = react_1.useState({ DATA: [] });
    const [endpointValue, setEndpointValue] = react_1.useState('');
    const [loading, setLoading] = react_1.useState(false);
    const history = react_router_dom_1.useHistory();
    // Event Handlers
    const handleEndpointValueChange = (event) => {
        setEndpointValue(event.target.value);
    };
    const handleSearchEndpointClick = (event) => __awaiter(void 0, void 0, void 0, function* () {
        setAPIError(null);
        setEndpoints({ DATA: [] });
        setLoading(true);
        try {
            let response = yield fetch(`/globus-jupyterlab/endpoint_search?filter_fulltext=${endpointValue}`, {
                headers: {
                    Allow: 'application/json',
                    'Content-Type': 'application/json',
                },
            });
            let endpoints = yield response.json();
            if ('error' in endpoints) {
                throw endpoints;
            }
            setEndpoints(endpoints);
            setLoading(false);
            history.push('/endpoints');
        }
        catch (error) {
            setLoading(false);
            setAPIError(error);
        }
    });
    if (apiError) {
        return react_1.default.createElement("p", { className: 'fw-bold text-danger' },
            "Error: ",
            apiError['error'],
            ". Please try again.");
    }
    if (loading) {
        return react_1.default.createElement("h5", null, "Loading");
    }
    return (react_1.default.createElement("div", { id: 'endpoint-search', className: 'mb-4' },
        react_1.default.createElement("h5", null, "Search Collections for Transferring"),
        react_1.default.createElement("div", { className: 'row' },
            react_1.default.createElement("div", { className: 'col-8' },
                react_1.default.createElement("input", { id: 'endpoint-input', className: 'form-control', type: 'text', value: endpointValue, onChange: handleEndpointValueChange })),
            react_1.default.createElement("div", { className: 'col' },
                react_1.default.createElement("button", { className: 'btn btn-primary', onClick: handleSearchEndpointClick }, "Search Collections"))),
        react_1.default.createElement(react_router_dom_1.Route, { exact: true, path: '/endpoints', render: (props) => {
                return react_1.default.createElement(Endpoints_1.default, Object.assign({}, props, { endpoints: endpoints }));
            } }),
        react_1.default.createElement(react_router_dom_1.Route, { exact: true, path: '/endpoints/:endpointID' },
            react_1.default.createElement(Endpoint_1.default, { selectedJupyterItems: props.selectedJupyterItems })),
        react_1.default.createElement(react_router_dom_1.Route, { path: '/endpoints/:endpointID/items/:path' },
            react_1.default.createElement(Endpoint_1.default, { selectedJupyterItems: props.selectedJupyterItems }))));
};
exports["default"] = EndpointSearch;


/***/ }),

/***/ "./lib/components/Endpoints.js":
/*!*************************************!*\
  !*** ./lib/components/Endpoints.js ***!
  \*************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
const react_router_dom_1 = __webpack_require__(/*! react-router-dom */ "webpack/sharing/consume/default/react-router-dom/react-router-dom");
const react_1 = __importDefault(__webpack_require__(/*! react */ "webpack/sharing/consume/default/react"));
const Endpoints = (props) => {
    return (react_1.default.createElement("div", { className: 'row' }, props.endpoints['DATA'].length > 0 && (react_1.default.createElement("div", { className: 'col-8' },
        react_1.default.createElement("div", { className: 'list-group' }, props.endpoints['DATA'].map((endpoint) => {
            return (react_1.default.createElement(react_router_dom_1.Link, { to: `/endpoints/${endpoint.id}`, className: 'list-group-item list-group-item-action flex-column align-items-start' },
                react_1.default.createElement("h5", { className: 'mb-1' },
                    react_1.default.createElement("i", { className: 'fa-solid fa-layer-group' }),
                    "\u00A0",
                    endpoint.display_name),
                react_1.default.createElement("p", { className: 'mb-0 mt-2 fw-bold' }, "Owner:"),
                react_1.default.createElement("p", { className: 'mb-1' }, endpoint.owner_string),
                endpoint.description && (react_1.default.createElement(react_1.default.Fragment, null,
                    react_1.default.createElement("p", { className: 'mb-0 mt-2 fw-bold' }, "Description:"),
                    react_1.default.createElement("p", { className: 'mb-1' }, endpoint.description)))));
        }))))));
};
exports["default"] = Endpoints;


/***/ }),

/***/ "./lib/components/GlobusObjects.js":
/*!*****************************************!*\
  !*** ./lib/components/GlobusObjects.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TransferSelector = exports.TransferAtom = exports.ConfigAtom = void 0;
const recoil_1 = __webpack_require__(/*! recoil */ "webpack/sharing/consume/default/recoil/recoil");
exports.ConfigAtom = recoil_1.atom({
    key: 'ConfigAtom',
    default: {
        collection_id: '',
        collection_base_path: '',
        is_gcp: false,
        is_logged_in: false,
        collection_id_owner: ''
    },
});
exports.TransferAtom = recoil_1.atom({
    key: 'TransferAtom',
    default: {
        source_endpoint: '',
        destination_endpoint: '',
        transfer_items: [{
                source_path: '',
                destination_path: '',
                recursive: false
            }],
    },
});
exports.TransferSelector = recoil_1.selector({
    key: 'TransferSelector',
    get: ({ get }) => {
        return get(exports.TransferAtom);
    },
    set: ({ get, set }, newTransferObject) => {
        let oldTransferObject = get(exports.TransferAtom);
        let updatedTransferObject = Object.assign(Object.assign({}, oldTransferObject), newTransferObject);
        set(exports.TransferAtom, updatedTransferObject);
    },
});


/***/ }),

/***/ "./lib/globus/api/client.js":
/*!**********************************!*\
  !*** ./lib/globus/api/client.js ***!
  \**********************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Private = exports.makeGlobusRequest = exports.signOut = exports.exchangeOAuth2Token = exports.getTokens = exports.initializeGlobusClient = exports.globusAuthorized = exports.ERROR_CODES = void 0;
const coreutils_1 = __webpack_require__(/*! @lumino/coreutils */ "webpack/sharing/consume/default/@lumino/coreutils");
const utils_1 = __webpack_require__(/*! ../../utils */ "./lib/utils.js");
const CLIENT_ID = '64d2d5b3-b77e-4e04-86d9-e3f143f563f7';
const REDIRECT_URI = 'https://auth.globus.org/v2/web/auth-code';
const GLOBUS_TOKEN_URL = 'https://auth.globus.org/v2/oauth2/token';
// TODO Symlink support
// TODO Share support
// TODO Create interface for errors
exports.ERROR_CODES = {
    'ClientError.NotFound': 'Directory Not Found',
    'EndpointPermissionDenied': 'Endpoint Permission Denied',
    'ClientError.ActivationRequired': 'Endpoint Activation Required',
    'ExternalError.DirListingFailed.NotDirectory': 'Not a Directory',
    'ServiceUnavailable': 'Server Under Maintenance',
    'ExternalError.DirListingFailed.GCDisconnected': 'Globus Connect Not Running',
    'ExternalError.DirListingFailed': 'Directory Listing Failed',
    'ExternalError.DirListingFailed.PermissionDenied': 'Permission Denied',
    'ExternalError.DirListingFailed.ConnectFailed': 'Connection Failed'
};
exports.globusAuthorized = new coreutils_1.PromiseDelegate();
/**
 * Initializes the Globus client
 * @param {any} data
 */
function initializeGlobusClient(data) {
    Private.tokens.data = data;
}
exports.initializeGlobusClient = initializeGlobusClient;
/**
 * Gets the access tokens by using the provided authorization code
 * @param {string} authCode
 * @param {string} verifier
 * @returns {Promise}
 */
function getTokens(authCode, verifier) {
    return __awaiter(this, void 0, void 0, function* () {
        // Globus's OAuth 2.0 endpoint for requesting an access token
        let oauth2Endpoint = GLOBUS_TOKEN_URL;
        // Create <form> element to submit parameters to OAuth 2.0 endpoint.
        let form = document.createElement('form');
        form.method = 'GET'; // Send as a GET request.
        form.action = oauth2Endpoint;
        form.target = window.location.href;
        return new Promise((resolve, reject) => {
            exchangeOAuth2Token(authCode, verifier.toString())
                .then(data => {
                exports.globusAuthorized.resolve(data);
                resolve(data);
            })
                .catch(e => {
                console.log(e);
                reject();
            });
        });
    });
}
exports.getTokens = getTokens;
/**
 * Exchanges a 0Auth2Token for Globus access tokens
 * @param {string} token
 * @param {string} verifier
 */
function exchangeOAuth2Token(token, verifier) {
    return __awaiter(this, void 0, void 0, function* () {
        // Globus's OAuth 2.0 endpoint for requesting an access token
        let oauth2Endpoint = GLOBUS_TOKEN_URL;
        // Parameters to pass to OAuth 2.0 endpoint.
        let params = {
            'client_id': CLIENT_ID,
            'redirect_uri': REDIRECT_URI,
            'grant_type': 'authorization_code',
            'code': token,
            'code_verifier': verifier
        };
        let formData = utils_1.queryParams(params);
        let fetchAccessToken = new Promise((resolve, reject) => fetch(oauth2Endpoint, {
            method: 'POST',
            body: formData,
            headers: {
                "Content-Type": "application/x-www-form-urlencoded"
            }
        }).then(function (response) {
            if (response.status >= 400) {
                reject(response.statusText);
            }
            return response.json();
        }).then(function (data) {
            resolve(data);
        }));
        // Wait for fetch to be done and then return token(s)
        return yield fetchAccessToken;
    });
}
exports.exchangeOAuth2Token = exchangeOAuth2Token;
/**
 * Invalidates the globusAuthorized promise and sets up a new one.
 */
function signOut() {
    sessionStorage.removeItem('data');
    exports.globusAuthorized = new coreutils_1.PromiseDelegate();
}
exports.signOut = signOut;
/**
 * Makes a basic Globus Request and returns the response as a json
 * @param {string} url
 * @param options
 * @returns {Promise<GlobusResponse>}
 */
function makeGlobusRequest(url, options) {
    return new Promise((resolve, reject) => {
        fetch(url, options).then((response) => __awaiter(this, void 0, void 0, function* () {
            if (response.status >= 400) {
                reject(yield response.json());
            }
            else {
                resolve(yield response.json());
            }
        }));
    });
}
exports.makeGlobusRequest = makeGlobusRequest;
/**
 * Contains the tokens required by the extension.
 */
var Private;
(function (Private) {
    Private.tokens = new class {
        set data(data) {
            this._data = data;
            this.searchToken = data.other_tokens[0].access_token;
            this.transferToken = data.other_tokens[1].access_token;
        }
    };
})(Private = exports.Private || (exports.Private = {}));


/***/ }),

/***/ "./lib/globus/api/search.js":
/*!**********************************!*\
  !*** ./lib/globus/api/search.js ***!
  \**********************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.searchQueryParams = exports.searchIndexAdvanced = exports.searchIndex = void 0;
const client_1 = __webpack_require__(/*! ./client */ "./lib/globus/api/client.js");
const client_2 = __webpack_require__(/*! ./client */ "./lib/globus/api/client.js");
var tokens = client_2.Private.tokens;
const GLOBUS_SEARCH_API_URL = 'https://search.api.globus.org/';
/**
 * Simple search
 * @param {string} index
 * @param {string} query
 * @returns {Promise<GlobusSearchResult>}
 */
function searchIndex(index, query) {
    return makeSearchRequest(`${GLOBUS_SEARCH_API_URL}/v1/index/${index}/search?q=${query}`);
}
exports.searchIndex = searchIndex;
/**
 * Advanced search with advanced queries. Recommended in order to do filtering.
 * @param {string} index
 * @param {string} query
 * @returns {Promise<GlobusSearchResult>}
 */
function searchIndexAdvanced(index, query) {
    return makeSearchRequest(`${GLOBUS_SEARCH_API_URL}/v1/index/${index}/search?q=${query}&advanced=true`);
}
exports.searchIndexAdvanced = searchIndexAdvanced;
/**
 * Calls makeGlobusRequest() with the appropriate url and options to use the Globus Search API
 * @param {string} url
 * @param options
 * @returns {Promise<any>}
 */
function makeSearchRequest(url, options) {
    options = Object.assign({ method: 'GET' }, options);
    options.headers = Object.assign({ 'Authorization': `Bearer ${tokens.searchToken}` }, options.headers);
    return client_1.makeGlobusRequest(url, options);
}
/**
 * Takes in an object and encodes it in the form 'key1:value1 AND key2: value2'. Required for searchIndexAdvances()
 * @param params
 * @returns {string}
 */
function searchQueryParams(params) {
    return Object.keys(params)
        .map(k => k + ':' + params[k])
        .join(' AND ');
}
exports.searchQueryParams = searchQueryParams;


/***/ }),

/***/ "./lib/globus/api/transfer.js":
/*!************************************!*\
  !*** ./lib/globus/api/transfer.js ***!
  \************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.requestSubmissionId = exports.submitOperation = exports.sharedEndpiontRequest = exports.submitTask = exports.endpointSearchById = exports.endpointSearch = exports.listDirectoryContents = exports.taskSearch = exports.activateEndpoint = void 0;
const client_1 = __webpack_require__(/*! ./client */ "./lib/globus/api/client.js");
var tokens = client_1.Private.tokens;
const GLOBUS_TRANSFER_API_URL = 'https://transfer.api.globusonline.org/v0.10';
/**
 * Autoactivates an endpoint by making an empty POST request
 * @param {string} endpointId
 * @returns {Promise<any>}
 */
function activateEndpoint(endpointId) {
    return makeTransferRequest(`${GLOBUS_TRANSFER_API_URL}/endpoint/${endpointId}/autoactivate`, {
        method: 'POST',
        body: ''
    });
}
exports.activateEndpoint = activateEndpoint;
/**
 * Returns the latest 1000 tasks requested by the signed in user
 * @returns {Promise<GlobusTaskList>}
 */
function taskSearch() {
    return makeTransferRequest(`${GLOBUS_TRANSFER_API_URL}/task_list?limit=1000&filter=type:TRANSFER,DELETE`);
}
exports.taskSearch = taskSearch;
/**
 * Returns the contents of a endpoint's folder
 * @param {string} endpointId
 * @param {string} dirPath
 * @returns {Promise<GlobusFileList>}
 */
function listDirectoryContents(endpointId, dirPath = '/~/') {
    return makeTransferRequest(`${GLOBUS_TRANSFER_API_URL}/operation/endpoint/${endpointId}/ls?path=${dirPath}`);
}
exports.listDirectoryContents = listDirectoryContents;
/**
 * Returns a list of endpoints based on the query
 * @param {string} query
 * @returns {Promise<GlobusEndpointList>}
 */
function endpointSearch(query) {
    // check is needed so that filter_fulltext always gets a value
    if (query.length <= 0) {
        let no_query = null;
        return makeTransferRequest(`${GLOBUS_TRANSFER_API_URL}/endpoint_search?filter_fulltext=${no_query}`);
    }
    return makeTransferRequest(`${GLOBUS_TRANSFER_API_URL}/endpoint_search?filter_fulltext=${query}`);
}
exports.endpointSearch = endpointSearch;
/**
 * Returns a specific endpoint based on endpointId
 * @param {string} endpointId
 * @returns {Promise<GlobusEndpointItem>}
 */
function endpointSearchById(endpointId) {
    return makeTransferRequest(`${GLOBUS_TRANSFER_API_URL}/endpoint/${endpointId}`);
}
exports.endpointSearchById = endpointSearchById;
/**
 * Takes in a task (transfer or delete) and returns the appropriate response
 * @param {GlobusTransferTask | GlobusDeleteTask} task
 * @returns {Promise<GlobusTaskResponse>}
 */
function submitTask(task) {
    return makeTransferRequest(`${GLOBUS_TRANSFER_API_URL}/${task.DATA_TYPE}`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json'
        },
        body: JSON.stringify(task)
    });
}
exports.submitTask = submitTask;
/**
 * Takes in a share "task" and returns the appropriate response
 * @param {any} task
 * @returns {Promise<GlobusTaskResponse}
 */
function sharedEndpiontRequest(task) {
    let url = `${GLOBUS_TRANSFER_API_URL}/` + 'shared_endpoint';
    return makeTransferRequest(url, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json'
        },
        body: JSON.stringify(task)
    });
}
exports.sharedEndpiontRequest = sharedEndpiontRequest;
/**
 * Takes in an operation (rename or newDir) and returns the appropriate response
 * @param {string} endpointId
 * @param {GlobusRenameOperation | GlobusNewDirectoryOperation} operation
 * @returns {Promise<GlobusOperationResponse>}
 */
function submitOperation(endpointId, operation) {
    return makeTransferRequest(`${GLOBUS_TRANSFER_API_URL}/operation/endpoint/${endpointId}/${operation.DATA_TYPE}`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json'
        },
        body: JSON.stringify(operation)
    });
}
exports.submitOperation = submitOperation;
/**
 * Requests and returns a submission id required for GlobusTask
 * @returns {Promise<GlobusSubmissionId>}
 */
function requestSubmissionId() {
    return makeTransferRequest(`${GLOBUS_TRANSFER_API_URL}/submission_id`);
}
exports.requestSubmissionId = requestSubmissionId;
/**
 * Calls makeGlobusRequest() with the appropriate url and options to use the Globus Transfer API
 * @param {string} url
 * @param options
 * @returns {Promise<GlobusResponse>}
 */
function makeTransferRequest(url, options) {
    options = Object.assign({ method: 'GET' }, options);
    options.headers = Object.assign({ 'Authorization': `Bearer ${tokens.transferToken}` }, options.headers);
    return client_1.makeGlobusRequest(url, options);
}


/***/ }),

/***/ "./lib/globus/home.js":
/*!****************************!*\
  !*** ./lib/globus/home.js ***!
  \****************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.GlobusLogin = exports.GlobusHome = exports.SIGN_OUT = void 0;
const widgets_1 = __webpack_require__(/*! @lumino/widgets */ "webpack/sharing/consume/default/@lumino/widgets");
const CryptoJS = __webpack_require__(/*! crypto-js */ "webpack/sharing/consume/default/crypto-js/crypto-js");
const client_1 = __webpack_require__(/*! ./api/client */ "./lib/globus/api/client.js");
const utils_1 = __webpack_require__(/*! ../utils */ "./lib/utils.js");
/**
 * CSS classes
 */
const GLOBUS_HOME = 'jp-Globus-home';
const GLOBUS_TAB_LOGO = 'jp-Globus-tablogo';
const GLOBUS_LOGIN_SCREEN = 'jp-Globus-loginScreen';
const GLOBUS_LOGO = 'jp-Globus-logo';
const CLIENT_ID = '64d2d5b3-b77e-4e04-86d9-e3f143f563f7';
const REDIRECT_URI = 'https://auth.globus.org/v2/web/auth-code';
const SCOPES = 'openid email profile urn:globus:auth:scope:transfer.api.globus.org:all urn:globus:auth:scope:search.api.globus.org:all';
exports.SIGN_OUT = 'globus-signOut';
/**
 * Widget for hosting the Globus Home.
 */
class GlobusHome extends widgets_1.Widget {
    constructor(widgetManager) {
        super();
        this.id = 'globus-home';
        this.addClass(GLOBUS_HOME);
        this.layout = new widgets_1.PanelLayout();
        this.globusLogin = new GlobusLogin();
        this.widgetManager = widgetManager;
        this.title.iconClass = GLOBUS_TAB_LOGO;
        this.title.closable = true;
        this.showLoginScreen();
        this.globusLogin.attemptSignIn();
    }
    /**
     * Displays login screen and waits for authorization
     */
    showLoginScreen() {
        this.layout.addWidget(this.globusLogin);
        // After globus authorization, show the widget manager.
        client_1.globusAuthorized.promise.then((data) => {
            // Store login data in the session
            sessionStorage.setItem('data', JSON.stringify(data));
            client_1.initializeGlobusClient(data);
            // Hide login screen
            this.globusLogin.parent = null;
            // Initialize widgetManager and add it to layout
            this.widgetManager.update();
            this.layout.addWidget(this.widgetManager);
        });
    }
}
exports.GlobusHome = GlobusHome;
/**
 * Widget for hosting the Globus Login.
 */
class GlobusLogin extends widgets_1.Widget {
    constructor() {
        super();
        this.addClass(GLOBUS_LOGIN_SCREEN);
        // Create the logo
        const logo = document.createElement('div');
        logo.className = GLOBUS_LOGO;
        // Create the text for explaining the auth code
        let authText = document.createElement('p');
        authText.textContent = 'Please use the new tab to get an authorization code and paste it in the box below';
        authText.style.textAlign = 'center';
        authText.style.display = 'none';
        // Create the login button (<a> HTML tag with button appearance).
        let signInButton = document.createElement('a');
        signInButton.setAttribute('href', this.getAuthUrl());
        signInButton.setAttribute('target', '_blank');
        signInButton.setAttribute('appearance', 'button');
        signInButton.title = 'Log into your Globus account';
        signInButton.textContent = 'SIGN IN';
        signInButton.className = `${utils_1.GLOBUS_BUTTON}`;
        // Create the auth-code input and submit button
        let authCodeInput = document.createElement('input');
        authCodeInput.type = 'text';
        authCodeInput.className = `${utils_1.GLOBUS_INPUT} ${utils_1.GLOBUS_BORDER}`;
        authCodeInput.placeholder = 'Paste your auth code here';
        authCodeInput.style.display = 'none';
        let submitAuthCodeButton = document.createElement('button');
        submitAuthCodeButton.textContent = 'SUBMIT TOKEN';
        submitAuthCodeButton.className = `${utils_1.GLOBUS_BUTTON}`;
        submitAuthCodeButton.style.display = 'none';
        // Create the cancel button (returns user to main login)
        let cancelButton = document.createElement('button');
        cancelButton.textContent = 'CANCEL';
        cancelButton.className = `${utils_1.GLOBUS_BUTTON}`;
        cancelButton.style.background = '#340d0d';
        cancelButton.style.display = 'none';
        // Create error message to display if login fails
        let errorMessage = document.createElement('p');
        errorMessage.textContent = 'An error occurred, please try again or click the Cancel button to get a new authorization code.';
        errorMessage.style.color = 'red';
        errorMessage.style.textAlign = 'center';
        errorMessage.style.display = 'none';
        // Add Event Listeners
        signInButton.addEventListener('click', () => {
            signInButton.style.display = 'none';
            authText.style.display = 'block';
            authCodeInput.style.display = 'block';
            submitAuthCodeButton.style.display = 'block';
            cancelButton.style.display = 'block';
        });
        submitAuthCodeButton.addEventListener('click', () => {
            client_1.getTokens(authCodeInput.value, this.verifier)
                .then(data => {
                signInButton.style.display = 'block';
                authText.style.display = 'none';
                authCodeInput.style.display = 'none';
                submitAuthCodeButton.style.display = 'none';
                cancelButton.style.display = 'none';
                errorMessage.style.display = 'none';
            })
                .catch(e => {
                errorMessage.style.display = 'block';
            });
        });
        cancelButton.addEventListener('click', () => {
            signInButton.style.display = 'block';
            authText.style.display = 'none';
            authCodeInput.style.display = 'none';
            submitAuthCodeButton.style.display = 'none';
            cancelButton.style.display = 'none';
            errorMessage.style.display = 'none';
        });
        // Add the elements
        this.node.appendChild(logo);
        this.node.appendChild(authText);
        this.node.appendChild(signInButton);
        this.node.appendChild(authCodeInput);
        this.node.appendChild(submitAuthCodeButton);
        this.node.appendChild(cancelButton);
        this.node.appendChild(errorMessage);
    }
    /**
     * Generates the Auth URL and returns it (as a string).
     */
    getAuthUrl() {
        // Define the basic auth URL
        let authUrl = 'https://auth.globus.org/v2/oauth2/authorize?';
        // Generates verifier and challenge to follow 0Auth2 protocol
        this.generateVerifier();
        let challenge = this.generateCodeChallenge(this.verifier);
        // Authorization Request parameters
        let params = {
            'client_id': CLIENT_ID,
            'redirect_uri': REDIRECT_URI,
            'scope': SCOPES,
            'state': '_default',
            'response_type': 'code',
            'code_challenge': challenge,
            'code_challenge_method': 'S256',
            'access_type': 'offline'
        };
        // Encode the Authorization Request parameters and add them to the URL
        authUrl += utils_1.queryParams(params);
        return authUrl;
    }
    generateVerifier() {
        this.verifier = CryptoJS.lib.WordArray.random(32).toString();
    }
    generateCodeChallenge(verifier) {
        return CryptoJS.SHA256(verifier)
            .toString(CryptoJS.enc.Base64)
            .replace(/\+/g, '-')
            .replace(/\//g, '_')
            .replace(/=/g, '');
    }
    /*
    * If there is data stored in the session then we assume that the user is authorized by globus.
    * This is safe because even if they are able to access the extension without an authorization by globus, they'll
    * be unable to use the app because the access tokens would be invalid
    */
    attemptSignIn() {
        let data = sessionStorage.getItem('data');
        if (data) {
            client_1.globusAuthorized.resolve(JSON.parse(data));
        }
    }
}
exports.GlobusLogin = GlobusLogin;


/***/ }),

/***/ "./lib/globus/widget_manager.js":
/*!**************************************!*\
  !*** ./lib/globus/widget_manager.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.GlobusWidgetManager = void 0;
const widgets_1 = __webpack_require__(/*! @lumino/widgets */ "webpack/sharing/consume/default/@lumino/widgets");
const apputils_1 = __webpack_require__(/*! @jupyterlab/apputils */ "webpack/sharing/consume/default/@jupyterlab/apputils");
const client_1 = __webpack_require__(/*! ./api/client */ "./lib/globus/api/client.js");
const home_1 = __webpack_require__(/*! ./home */ "./lib/globus/home.js");
const file_manager_1 = __webpack_require__(/*! ./widgets/file_manager */ "./lib/globus/widgets/file_manager.js");
const activity_1 = __webpack_require__(/*! ./widgets/activity */ "./lib/globus/widgets/activity.js");
const utils_1 = __webpack_require__(/*! ../utils */ "./lib/utils.js");
const search_1 = __webpack_require__(/*! ./widgets/search */ "./lib/globus/widgets/search.js");
/**
 * CSS classes
 */
const GLOBUS_WIDGET_MANAGER = 'jp-Globus-widgetManager';
const GLOBUS_TOOLBAR = 'jp-WidgetManager-toolbar';
const GLOBUS_TOOLBAR_BTN = 'jp-WidgetManager-toolbarBtn';
// const GLOBUS_CONNECT_PERSONAL_BTN = 'jp-WidgetManager-connectPersonalBtn';
const GLOBUS_FILEMANAGER_BTN = 'jp-WidgetManager-fileManagerBtn';
const GLOBUS_ACTIVITY_BTN = 'jp-WidgetManager-activityBtn';
const GLOBUS_SEARCH_BTN = 'jp-WidgetManager-searchBtn';
const GLOBUS_SIGNOUT_BTN = 'jp-WidgetManager-signOutBtn';
const GLOBUS_WIDGET_HEADER = 'jp-WidgetManager-header';
/**
 * Widget for hosting the Globus Home.
 */
class GlobusWidgetManager extends widgets_1.Widget {
    constructor(app, manager, factory) {
        super();
        /**
         * Map containing all widgets. Access a widget by id
         */
        this.widgetMap = {};
        this.id = 'globus-manager';
        this.addClass(GLOBUS_WIDGET_MANAGER);
        this.factory = factory;
        this.manager = manager;
        this.app = app;
        this.layout = new widgets_1.PanelLayout();
    }
    /**
     * Executed when update() is called. Resets the widget manager to its initial state
     */
    onUpdateRequest() {
        this.toolbar = new apputils_1.Toolbar();
        this.toolbar.addClass(GLOBUS_TOOLBAR);
        this.layout.addWidget(this.toolbar);
        this.createWidgets();
        // Logout button
        let signOutButton = new apputils_1.ToolbarButton({
            onClick: () => {
                this.signOut();
            },
            tooltip: `Sign Out`
        });
        signOutButton.addClass(GLOBUS_SIGNOUT_BTN);
        signOutButton.addClass(GLOBUS_TOOLBAR_BTN);
        this.toolbar.addItem(home_1.SIGN_OUT, signOutButton);
        this.header = document.createElement('header');
        this.header.className = `${GLOBUS_WIDGET_HEADER} ${utils_1.GLOBUS_HEADER}`;
        this.node.insertBefore(this.header, this.node.childNodes[1]);
        this.switchToWidget(file_manager_1.FILE_MANAGER);
    }
    createToolbarButton(widget, cssClass = '') {
        let that = this;
        let toolbarButton = new apputils_1.ToolbarButton({
            onClick: () => {
                that.switchToWidget(widget.id);
            },
            tooltip: widget.title.label
        });
        toolbarButton.addClass(cssClass);
        toolbarButton.addClass(GLOBUS_TOOLBAR_BTN);
        this.toolbar.addItem(widget.id, toolbarButton);
    }
    /**
     * Signs out from Globus and switches to the login screen
     */
    signOut() {
        client_1.signOut();
        this.parent.showLoginScreen();
        this.parent = null;
        this.node.removeChild(this.header);
        while (this.layout.widgets.length > 0) {
            this.layout.removeWidget(this.layout.widgets[0]);
        }
        this.currentWidgetId = null;
    }
    /**
     * Switches to specified widget or updates the current one
     * @param {string} id
     */
    switchToWidget(id) {
        if (id != this.currentWidgetId || !this.currentWidgetId) {
            if (!this.currentWidgetId) {
                this.currentWidgetId = id;
            }
            this.widgetMap[this.currentWidgetId].hide();
            this.widgetMap[id].show();
            this.header.textContent = this.widgetMap[id].title.label;
            this.currentWidgetId = id;
        }
        else {
            this.widgetMap[this.currentWidgetId].update();
        }
    }
    getWidgetInstance(id) {
        return this.widgetMap[id];
    }
    getCurrentWidgetInstance() {
        return this.widgetMap[this.currentWidgetId];
    }
    /**
     * Creates all widgets. New widgets should be added here in a similar way as the others
     */
    createWidgets() {
        // let connectPersonalWidget = new GlobusConnectPersonal(this.app, this.manager, this.factory);
        // this.initWidget(connectPersonalWidget);
        // this.createToolbarButton(connectPersonalWidget, GLOBUS_CONNECT_PERSONAL_BTN);
        let fileManagerWidget = new file_manager_1.GlobusFileManager();
        this.initWidget(fileManagerWidget);
        this.createToolbarButton(fileManagerWidget, GLOBUS_FILEMANAGER_BTN);
        let activityWidget = new activity_1.GlobusActivity();
        this.initWidget(activityWidget);
        this.createToolbarButton(activityWidget, GLOBUS_ACTIVITY_BTN);
        let searchWidget = new search_1.GlobusSearch();
        this.initWidget(searchWidget);
        this.createToolbarButton(searchWidget, GLOBUS_SEARCH_BTN);
        /* Add additional widgets here:
        *
        *
        * */
    }
    /**
     * Adds widget to layout. Widgets are displayed by default which is why we hide it, for a cleaner initial state.
     * This way only switchToWidget() takes care of showing and hiding widget
      * @param {Widget} widget
     */
    initWidget(widget) {
        this.widgetMap[widget.id] = widget;
        this.layout.addWidget(widget);
        widget.hide();
    }
}
exports.GlobusWidgetManager = GlobusWidgetManager;


/***/ }),

/***/ "./lib/globus/widgets/activity.js":
/*!****************************************!*\
  !*** ./lib/globus/widgets/activity.js ***!
  \****************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.GlobusActivity = exports.ACTIVITY = void 0;
const widgets_1 = __webpack_require__(/*! @lumino/widgets */ "webpack/sharing/consume/default/@lumino/widgets");
const utils_1 = __webpack_require__(/*! ../../utils */ "./lib/utils.js");
const transfer_1 = __webpack_require__(/*! ../api/transfer */ "./lib/globus/api/transfer.js");
const moment_1 = __importDefault(__webpack_require__(/*! moment */ "./node_modules/moment/moment.js"));
const $ = __importStar(__webpack_require__(/*! jquery */ "webpack/sharing/consume/default/jquery/jquery"));
/**
 * CSS Classes
 */
const GLOBUS_ACTIVITY = 'jp-Globus-activity';
const ACTIVITY_TASK_SUCCEEDED = 'jp-Activity-taskSuccess';
const ACTIVITY_TASK_FAILED = 'jp-Activity-taskFail';
const ACTIVITY_TASK_ACTIVE = 'jp-Activity-taskActive';
const ACTIVITY_TASK_INACTIVE = 'jp-Activity-taskInactive';
const ACTIVITY_TASK_MENU = 'jp-Activity-taskMenu';
const ACTIVITY_TASK_LIST = 'jp-Activity-taskList';
const ACTIVITY_TASK_GROUP = 'jp-Activity-taskGroup';
const ACTIVITY_OVERVIEW_MENU = 'jp-Activity-overviewMenu';
const ACTIVITY_OVERVIEW_LIST = 'jp-Activity-overviewList';
const ACTIVITY_OVERVIEW_GROUP = 'jp-Activity-overviewGroup';
const ACTIVITY_MENU_RECENT = 'jp-Activity-menuRecent';
const ACTIVITY_MENU_HISTORY = 'jp-Activity-menuHistory';
const ACTIVITY_MENU_BACK = 'jp-Activity-menuBack';
const ACTIVITY_MENU_OVERVIEW = 'jp-Activity-menuOverview';
/**
 * Activity Widget id
 */
exports.ACTIVITY = 'globus-activity';
const TASK_STATUS = {
    'SUCCEEDED': ACTIVITY_TASK_SUCCEEDED,
    'FAILED': ACTIVITY_TASK_FAILED,
    'ACTIVE': ACTIVITY_TASK_ACTIVE,
    'INACTIVE': ACTIVITY_TASK_INACTIVE
};
/**
 * Activity widget
 */
class GlobusActivity extends widgets_1.Widget {
    constructor() {
        super();
        this.id = exports.ACTIVITY;
        this.addClass(GLOBUS_ACTIVITY);
        this.title.label = 'Activity';
        this.createHTMLElements();
        this.update();
    }
    /**
     * Executed when update() is called. Refreshes the widget, initializes it with the recent tab open.
     */
    onUpdateRequest() {
        this.onClickMenuButtonHandler({ target: utils_1.getGlobusElement(this.parentGroup, ACTIVITY_MENU_RECENT) });
    }
    /**
     * Makes an API call using taskSearch() and takes care of the response
     * @param {HTMLUListElement} taskList
     * @param {"recent" | "all"} options
     * @returns {Promise<void>}
     */
    fetchTasks(taskList, options) {
        return new Promise((resolve) => {
            transfer_1.taskSearch().then(data => {
                if (data.DATA.length > 0) {
                    this.displayTasks(data, taskList, options);
                }
                else {
                    utils_1.displayError({ customMessage: 'No tasks found' }, taskList);
                }
                resolve();
            });
        });
    }
    /**
     * Displays tasks inside of taskList based on the data.
     * @param {GlobusTaskList} data
     * @param {HTMLUListElement} taskList
     * @param {"recent" | "all"} options
     */
    displayTasks(data, taskList, options) {
        for (let i = 0; i < data.DATA.length; i++) {
            let taskData = data.DATA[i];
            if (options === 'recent' && moment_1.default().diff(moment_1.default(taskData.completion_time), 'days') > 7) {
                break;
            }
            let task = document.createElement('li');
            task.className = `${utils_1.GLOBUS_LIST_ITEM} ${TASK_STATUS[taskData.status]}`;
            task.id = taskData.task_id;
            $.data(task, 'data', taskData);
            let title = document.createElement('div');
            title.className = utils_1.GLOBUS_LIST_ITEM_TITLE;
            switch (taskData.type) {
                case 'TRANSFER':
                    title.textContent = title.title = `${taskData.source_endpoint_display_name} to\n${taskData.destination_endpoint_display_name}`;
                    break;
                case 'DELETE':
                    title.textContent = title.title = `delete from\n${taskData.source_endpoint_display_name}`;
                    break;
            }
            let completionTime = document.createElement('div');
            completionTime.className = utils_1.GLOBUS_LIST_ITEM_SUBTITLE;
            completionTime.textContent = `${taskData.type.toLowerCase()} completed ${moment_1.default(taskData.completion_time).fromNow()}`;
            task.appendChild(title);
            task.appendChild(completionTime);
            task.addEventListener("click", this.taskClicked.bind(this));
            taskList.appendChild(task);
        }
    }
    /**
     * Starts the retrieval of tasks. Clears the current taskList, adds loading icons and calls fetchTasks() for the API call
     * @param {HTMLUListElement} taskList
     * @param {"recent" | "all"} options
     */
    retrieveTasks(taskList, options) {
        taskList.style.display = 'block';
        utils_1.removeChildren(taskList);
        utils_1.LOADING_LABEL.textContent = 'Loading Collections...';
        taskList.appendChild(utils_1.LOADING_ICON);
        taskList.appendChild(utils_1.LOADING_LABEL);
        this.fetchTasks(taskList, options).then(() => {
            taskList.removeChild(utils_1.LOADING_ICON);
            taskList.removeChild(utils_1.LOADING_LABEL);
        });
    }
    // TODO Don't remove and create new description elements everytime. Very inefficient and memory wasting
    /**
     * When task is clicked, display all metadata
     */
    taskClicked(e) {
        let taskData = $.data(e.currentTarget, 'data');
        let overviewList = utils_1.getGlobusElement(this.parentGroup, ACTIVITY_OVERVIEW_LIST);
        utils_1.removeChildren(overviewList);
        let taskGroup = utils_1.getGlobusElement(this.parentGroup, ACTIVITY_TASK_GROUP);
        let taskClone = e.currentTarget.cloneNode(true);
        taskClone.classList.add(utils_1.GLOBUS_OPEN);
        overviewList.appendChild(taskClone);
        overviewList.parentElement.style.display = 'flex';
        taskGroup.style.display = 'none';
        utils_1.createDescriptionElement(overviewList, 'Task ID', taskData.task_id);
        utils_1.createDescriptionElement(overviewList, 'Condition', taskData.status);
        utils_1.createDescriptionElement(overviewList, 'Requested', moment_1.default(taskData.request_time).format('YYYY-MM-DD hh:mm a'));
        utils_1.createDescriptionElement(overviewList, 'Completed', moment_1.default(taskData.completion_time).format('YYYY-MM-DD hh:mm a'));
        utils_1.createDescriptionElement(overviewList, 'Files', taskData.files);
        utils_1.createDescriptionElement(overviewList, 'Directories', taskData.directories);
        utils_1.createDescriptionElement(overviewList, 'Bytes Transferred', `${taskData.bytes_transferred} B`);
        utils_1.createDescriptionElement(overviewList, 'Effective Speed', `${taskData.effective_bytes_per_second} B/s`);
        utils_1.createDescriptionElement(overviewList, 'Pending', taskData.subtasks_pending);
        utils_1.createDescriptionElement(overviewList, 'Succeeded', taskData.subtasks_succeeded);
        utils_1.createDescriptionElement(overviewList, 'Cancelled', taskData.subtasks_canceled);
        utils_1.createDescriptionElement(overviewList, 'Expired', taskData.subtasks_expired);
        utils_1.createDescriptionElement(overviewList, 'Failed', taskData.subtasks_failed);
        utils_1.createDescriptionElement(overviewList, 'Retrying', taskData.subtasks_retrying);
        utils_1.createDescriptionElement(overviewList, 'Skipped', taskData.files_skipped);
    }
    ;
    createHTMLElements() {
        /* ------------- <taskGroup> ------------- */
        let menuRecent = document.createElement('div');
        menuRecent.className = `${utils_1.GLOBUS_MENU_BTN} ${ACTIVITY_MENU_RECENT}`;
        menuRecent.textContent = 'Recent';
        let menuHistory = document.createElement('div');
        menuHistory.className = `${utils_1.GLOBUS_MENU_BTN} ${ACTIVITY_MENU_HISTORY}`;
        menuHistory.textContent = 'History';
        let taskMenu = document.createElement('div');
        taskMenu.className = `${utils_1.GLOBUS_MENU} ${ACTIVITY_TASK_MENU} ${utils_1.GLOBUS_BORDER}`;
        taskMenu.appendChild(menuRecent);
        taskMenu.appendChild(menuHistory);
        let taskList = document.createElement('ul');
        taskList.className = `${utils_1.GLOBUS_LIST} ${ACTIVITY_TASK_LIST} ${utils_1.GLOBUS_BORDER}`;
        // Path Input container for adding extra elements
        let taskGroup = document.createElement('div');
        taskGroup.className = `${utils_1.GLOBUS_DISPLAY_FLEX} ${ACTIVITY_TASK_GROUP}`;
        taskGroup.appendChild(taskMenu);
        taskGroup.appendChild(taskList);
        taskGroup.style.display = 'flex';
        /* ------------- </taskGroup> ------------- */
        /* ------------- <overviewGroup> ------------- */
        let menuBack = document.createElement('div');
        menuBack.className = `${utils_1.GLOBUS_MENU_BTN} ${ACTIVITY_MENU_BACK}`;
        let menuOverview = document.createElement('div');
        menuOverview.className = `${utils_1.GLOBUS_MENU_BTN} ${ACTIVITY_MENU_OVERVIEW}`;
        menuOverview.textContent = 'Overview';
        let overviewMenu = document.createElement('div');
        overviewMenu.className = `${utils_1.GLOBUS_MENU} ${ACTIVITY_OVERVIEW_MENU} ${utils_1.GLOBUS_BORDER}`;
        overviewMenu.appendChild(menuBack);
        overviewMenu.appendChild(menuOverview);
        let overviewList = document.createElement('dl');
        overviewList.className = `${utils_1.GLOBUS_LIST} ${ACTIVITY_OVERVIEW_LIST} ${utils_1.GLOBUS_BORDER}`;
        let overviewGroup = document.createElement('div');
        overviewGroup.className = `${utils_1.GLOBUS_DISPLAY_FLEX} ${ACTIVITY_OVERVIEW_GROUP}`;
        overviewGroup.appendChild(overviewMenu);
        overviewGroup.appendChild(overviewList);
        overviewGroup.style.display = 'none';
        /* ------------- </overviewGroup> ------------- */
        /* ------------- <parentGroup> ------------- */
        this.parentGroup = document.createElement('div');
        this.parentGroup.appendChild(taskGroup);
        this.parentGroup.appendChild(overviewGroup);
        this.parentGroup.className = `${utils_1.GLOBUS_DISPLAY_FLEX} ${utils_1.GLOBUS_PARENT_GROUP}`;
        this.parentGroup.addEventListener('click', this.onClickMenuButtonHandler.bind(this));
        /* -------------</parentGroup>------------- */
        this.node.appendChild(this.parentGroup);
    }
    /**
     * Handles clicks to the Recent, History and Back menu buttons
     */
    onClickMenuButtonHandler(e) {
        if (e.target.matches(`.${utils_1.GLOBUS_MENU_BTN}`)) {
            let buttons = e.target.parentElement.children;
            for (let i = 0; i < buttons.length; i++) {
                if (buttons[i].classList.contains(utils_1.GLOBUS_SELECTED)) {
                    buttons[i].classList.remove(utils_1.GLOBUS_SELECTED);
                }
            }
            e.target.classList.add(utils_1.GLOBUS_SELECTED);
            let taskList = utils_1.getGlobusElement(this.parentGroup, utils_1.GLOBUS_LIST);
            if (e.target.matches(`.${ACTIVITY_MENU_RECENT}`)) {
                this.retrieveTasks(taskList, 'recent');
            }
            else if (e.target.matches(`.${ACTIVITY_MENU_HISTORY}`)) {
                this.retrieveTasks(taskList, 'all');
            }
            else if (e.target.matches(`.${ACTIVITY_MENU_BACK}`)) {
                let overviewGroup = utils_1.getGlobusElement(this.parentGroup, ACTIVITY_OVERVIEW_GROUP);
                let taskGroup = utils_1.getGlobusElement(this.parentGroup, ACTIVITY_TASK_GROUP);
                overviewGroup.style.display = 'none';
                taskGroup.style.display = 'flex';
            }
        }
    }
}
exports.GlobusActivity = GlobusActivity;


/***/ }),

/***/ "./lib/globus/widgets/file_manager.js":
/*!********************************************!*\
  !*** ./lib/globus/widgets/file_manager.js ***!
  \********************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.GlobusFileManager = exports.FILE_MANAGER = void 0;
const widgets_1 = __webpack_require__(/*! @lumino/widgets */ "webpack/sharing/consume/default/@lumino/widgets");
const rxjs_1 = __webpack_require__(/*! rxjs */ "webpack/sharing/consume/default/rxjs/rxjs");
const transfer_1 = __webpack_require__(/*! ../api/transfer */ "./lib/globus/api/transfer.js");
const globus_connect_personal_1 = __webpack_require__(/*! ./globus_connect_personal */ "./lib/globus/widgets/globus_connect_personal.js");
const utils_1 = __webpack_require__(/*! ../../utils */ "./lib/utils.js");
const moment_1 = __importDefault(__webpack_require__(/*! moment */ "./node_modules/moment/moment.js"));
const $ = __importStar(__webpack_require__(/*! jquery */ "webpack/sharing/consume/default/jquery/jquery"));
/**
 * CSS classes
 */
const GLOBUS_FILE_MANAGER = 'jp-Globus-file-manager';
const FILEMANAGER_ENDPOINT_GROUP = 'jp-FileManager-endpointGroup';
const FILEMANAGER_ENDPOINT_INPUT = 'jp-FileManager-endpointInput';
const FILEMANAGER_ENDPOINT_LIST = 'jp-FileManager-endpointList';
const FILEMANAGER_DIR_GROUP = 'jp-FileManager-dirGroup';
const FILEMANAGER_DIR_OPTIONS = 'jp-FileManager-dirOptions';
const FILEMANAGER_DIR_MENU = 'jp-FileManager-dirMenu';
const FILEMANAGER_FILE_PATH_INPUT = 'jp-FileManager-filePathInput';
const FILEMANAGER_FILE_LIST = 'jp-FileManager-fileList';
const FILEMANAGER_MENU_SELECT = 'jp-FileManager-menuSelect';
const FILEMANAGER_MENU_UP_FOLDER = 'jp-FileManager-menuUpFolder';
const FILEMANAGER_MENU_REFRESH = 'jp-FileManager-menuRefresh';
const FILEMANAGER_MENU_SORT = 'jp-FileManager-menuSort';
const FILEMANAGER_MENU_OPTIONS = 'jp-FileManager-menuOptions';
const FILEMANAGER_MENU_OPTION = 'jp-FileManager-menuOption';
const FILEMANAGER_OPTION_SHARE = 'jp-FileManager-optionShare';
const FILEMANAGER_OPTION_TRANSFER = 'jp-FileManager-optionTransfer';
const FILEMANAGER_OPTION_NEWFOLDER = 'jp-FileManager-optionNewFolder';
const FILEMANAGER_OPTION_RENAME = 'jp-FileManager-optionRename';
const FILEMANAGER_OPTION_DELETE = 'jp-FileManager-optionDelete';
const FILEMANAGER_SEARCH_INFO = 'jp-FileManager-searchInfo';
const FILEMANAGER_SEARCH_GROUP = 'jp-FileManager-searchGroup';
const FILEMANAGER_FILE_TYPE = 'jp-FileManager-fileType';
const FILEMANAGER_DIR_TYPE = 'jp-FileManager-dirType';
const FILEMANAGER_TRANSFER_RESULT = 'jp-FileManager-transferResult';
const FILEMANAGER_START_TRANSFER_BTN = 'jp-FileManager-startTransferBtn';
const FILEMANAGER_TRANSFER_OPTIONS_BTN = 'jp-FileManager-transferOptionsBtn';
const FILEMANAGER_TRANSFER_OPTIONS = 'jp-FileManager-transferOptions';
const FILEMANAGER_NEWDIR = 'jp-FileManager-newDir';
const FILEMANAGER_NEWDIR_INPUT = 'jp-FileManager-newDirInput';
const FILEMANAGER_NEWDIR_ACCEPT = 'jp-FileManager-newDirAccept';
const FILEMANAGER_NEWDIR_CANCEL = 'jp-FileManager-newDirCancel';
const FILEMANAGER_SORT_OPTIONS = 'jp-FileManager-sortOptions';
const FILEMANAGER_SORT_BUTTON = 'jp-FileManager-sortButton';
const FILEMANAGER_SORT_GROUP = 'jp-FileManager-sortGroup';
exports.FILE_MANAGER = 'globus-file-manager';
const ITEM_TYPE = {
    'dir': FILEMANAGER_DIR_TYPE,
    'file': FILEMANAGER_FILE_TYPE
};
const FILEMANAGER_CREATE_SHARE_URL = 'https://app.globus.org/file-manager/collections/<host_endpoint_id>/shares/create?back=file-manager&hostPath=<host_path>';
/**
 * Widget for hosting the Globus File Manager.
 */
class GlobusFileManager extends widgets_1.Widget {
    constructor() {
        super();
        this.parentGroup$ = new rxjs_1.BehaviorSubject(null);
        this.timeout = null;
        this.id = exports.FILE_MANAGER;
        this.addClass(GLOBUS_FILE_MANAGER);
        this.title.label = 'File Manager';
        this.update();
    }
    /**
     * Updates the UI of this widget by removing and recreating the HTMLElements.
     */
    onUpdateRequest() {
        utils_1.removeChildren(this.node);
        this.createHTMLElements();
    }
    /**
     * Checks that the given query is a valid endpoint ID and generates a list
     * of all endpoints that match the query.
     * @param {string} query
     * @param {HTMLUListElement} endpointList
     * @returns {Promise}
     */
    fetchEndpoints(query, endpointList) {
        return new Promise((resolve) => {
            if (utils_1.isEndpointId(query)) {
                transfer_1.endpointSearchById(query).then(data => {
                    let dataList = {
                        DATA_TYPE: "endpoint_list",
                        DATA: [data],
                        has_next_page: false,
                        limit: 10,
                        offset: 0
                    };
                    resolve();
                    this.displayEndpoints(dataList, endpointList);
                }).catch(e => {
                    console.log(e);
                    utils_1.displayError({ customMessage: 'No endpoints found' }, endpointList);
                    resolve();
                });
            }
            else {
                transfer_1.endpointSearch(query).then(data => {
                    if (data.DATA.length > 0) {
                        this.displayEndpoints(data, endpointList);
                    }
                    else {
                        utils_1.displayError({ customMessage: 'No endpoints found' }, endpointList);
                    }
                    resolve();
                });
            }
        });
    }
    /**
     * Generates HTML elements for each endpoint in a list (of endpoints) and
     * updates the given HTMLUListElement.
     * @param {GlobusEndpointList} data
     * @param {HTMLUListElement} endpointList
     */
    displayEndpoints(data, endpointList) {
        for (let i = 0; i < data.DATA.length; i++) {
            let endpointData = data.DATA[i];
            let endpoint = document.createElement('li');
            endpoint.className = utils_1.GLOBUS_LIST_ITEM;
            endpoint.id = endpointData.id;
            $.data(endpoint, 'data', endpointData);
            let name = document.createElement('div');
            name.textContent = name.title = endpointData.display_name ? endpointData.display_name : endpointData.canonical_name;
            name.className = utils_1.GLOBUS_LIST_ITEM_TITLE;
            let owner = document.createElement('div');
            owner.className = utils_1.GLOBUS_LIST_ITEM_SUBTITLE;
            owner.textContent = owner.title = endpointData.owner_string;
            endpoint.appendChild(name);
            endpoint.appendChild(owner);
            endpoint.addEventListener("click", this.endpointClicked.bind(this));
            endpointList.appendChild(endpoint);
        }
    }
    /**
     * Gets all of the endpoints in a given list (of endpoints) that match the user
     * input provided.
     * @param {HTMLInputElement} endpointInput
     * @param {HTMLUListElement} endpointList
     * @returns {Promise}
     */
    retrieveEndpoints(endpointInput, endpointList) {
        return new Promise((resolve) => {
            if (endpointInput.value.length > 0) {
                endpointList.style.display = 'block';
                utils_1.removeChildren(endpointList);
                utils_1.LOADING_LABEL.textContent = 'Loading Collections...';
                endpointList.appendChild(utils_1.LOADING_ICON);
                endpointList.appendChild(utils_1.LOADING_LABEL);
                this.fetchEndpoints(endpointInput.value, endpointList).then(() => {
                    if (endpointList.contains(utils_1.LOADING_ICON) && endpointList.contains(utils_1.LOADING_LABEL)) {
                        endpointList.removeChild(utils_1.LOADING_ICON);
                        endpointList.removeChild(utils_1.LOADING_LABEL);
                    }
                    resolve();
                });
            }
            else {
                endpointList.style.display = 'none';
                resolve();
            }
        });
    }
    /**
     * Used as an event listener method that is called every time an endpoint
     * is clicked.
     * @param {any} e
     * @returns {Promise}
     */
    endpointClicked(e) {
        this.currentEndpoint = e.currentTarget;
        let endpoint = e.currentTarget;
        let endpointList = endpoint.parentElement;
        let globusParentGroup = utils_1.getGlobusParentGroup(endpoint);
        let endpointInput = utils_1.getGlobusElement(globusParentGroup, FILEMANAGER_ENDPOINT_INPUT);
        let directoryGroup = utils_1.getGlobusElement(globusParentGroup, FILEMANAGER_DIR_GROUP);
        let fileList = utils_1.getGlobusElement(globusParentGroup, FILEMANAGER_FILE_LIST);
        let filePathInput = utils_1.getGlobusElement(globusParentGroup, FILEMANAGER_FILE_PATH_INPUT);
        endpoint.classList.toggle(utils_1.GLOBUS_OPEN);
        endpointInput.value = endpoint.firstChild.title;
        endpointList.style.display = 'none';
        directoryGroup.style.display = 'flex';
        return this.retrieveDirectoryContents(filePathInput, fileList);
    }
    /**
     * Gets and displays the contents of a directory at a given path.
     * @param {string} dirPath
     * @param {HTMLUListElement} fileList
     * @returns {Promise}
     */
    fetchDirectoryContents(dirPath, fileList) {
        let globusParentGroup = utils_1.getGlobusParentGroup(fileList);
        let endpoint = utils_1.getGlobusElement(globusParentGroup, utils_1.GLOBUS_OPEN);
        // Activate endpoint fetch -> "autoactivate"
        return new Promise((resolve) => {
            transfer_1.activateEndpoint(endpoint.id).then(() => {
                transfer_1.listDirectoryContents(endpoint.id, dirPath)
                    .then(data => {
                    this.displayDirectoryContents(data, fileList);
                }).catch(e => {
                    utils_1.displayError(e, fileList);
                }).then(() => resolve());
            });
        });
    }
    /**
     * Generates HTML elements for item in a list (of files/directories) and
     * updates the given HTMLUListElement.
     * @param {GlobusFileList} data
     * @param {HTMLUListElement} fileList
     */
    displayDirectoryContents(data, fileList) {
        for (let i = 0; i < data.DATA.length; i++) {
            let fileData = data.DATA[i];
            let file = document.createElement('li');
            file.className = `${utils_1.GLOBUS_LIST_ITEM} ${ITEM_TYPE[fileData.type]}`;
            $.data(file, 'data', fileData);
            let name = document.createElement('div');
            name.textContent = name.title = fileData.name;
            name.className = utils_1.GLOBUS_LIST_ITEM_TITLE;
            let date = document.createElement('div');
            date.className = utils_1.GLOBUS_LIST_ITEM_SUBTITLE;
            date.textContent = date.title = `${moment_1.default(fileData.last_modified).format('MM/DD/YYYY hh:mm a')}`;
            let size = document.createElement('div');
            size.className = utils_1.GLOBUS_LIST_ITEM_SUBTITLE;
            size.textContent = size.title = `${utils_1.convertBytes(fileData.size)}`;
            file.appendChild(name);
            file.appendChild(date);
            file.appendChild(size);
            file.addEventListener("click", this.fileClicked.bind(this));
            file.addEventListener("dblclick", this.fileDblClicked.bind(this));
            fileList.appendChild(file);
        }
    }
    /**
     * Gets all of the files/directories in a given list that match the user
     * input provided.
     * @param {HTMLInputElement} filePathInput
     * @param {HTMLUListElement} fileList
     * @returns {Promise}
     */
    retrieveDirectoryContents(filePathInput, fileList) {
        if (filePathInput.value.length === 0) {
            filePathInput.value = '/~/';
        }
        return new Promise((resolve) => {
            utils_1.removeChildren(fileList);
            utils_1.LOADING_LABEL.textContent = 'Retrieving Directories...';
            fileList.appendChild(utils_1.LOADING_ICON);
            fileList.appendChild(utils_1.LOADING_LABEL);
            this.fetchDirectoryContents(filePathInput.value, fileList).then(() => {
                if (fileList.contains(utils_1.LOADING_ICON) && fileList.contains(utils_1.LOADING_LABEL)) {
                    fileList.removeChild(utils_1.LOADING_ICON);
                    fileList.removeChild(utils_1.LOADING_LABEL);
                }
                resolve();
            });
        });
    }
    /**
     * Used as an event listener method that is called every time a file is
     * clicked.
     * @param {any} e
     */
    fileClicked(e) {
        let file = e.currentTarget;
        let itemList = file.parentElement.children;
        if (!e.ctrlKey) {
            for (let i = 0; i < itemList.length; i++) {
                if (itemList[i].classList.contains(utils_1.GLOBUS_SELECTED)) {
                    itemList[i].classList.remove(utils_1.GLOBUS_SELECTED);
                }
            }
        }
        // TODO shiftkey
        file.classList.toggle(utils_1.GLOBUS_SELECTED);
    }
    /**
     * Used as an event listener method that is called every time a file is
     * double-clicked.
     * @param {any} e
     */
    fileDblClicked(e) {
        let file = e.currentTarget;
        let fileData = $.data(file, 'data');
        let fileList = file.parentElement;
        let globusParentGroup = utils_1.getGlobusParentGroup(file);
        let filePathInput = utils_1.getGlobusElement(globusParentGroup, FILEMANAGER_FILE_PATH_INPUT);
        switch (fileData.type) {
            case 'dir': {
                filePathInput.value += `${fileData.name}/`;
                this.retrieveDirectoryContents(filePathInput, fileList);
                break;
            }
            case 'file': {
                file.classList.toggle(utils_1.GLOBUS_SELECTED);
                break;
            }
        }
    }
    /**
     * Used as an event listener method that is called every time the 'up'
     * key is pressed while the cursor is in the endpointInput.
     * @param {any} e
     */
    onKeyUpEndpointInputHandler(e) {
        if (e.target.matches(`.${FILEMANAGER_ENDPOINT_INPUT}`)) {
            let globusParentGroup = utils_1.getGlobusParentGroup(e.target);
            let filePathInput = utils_1.getGlobusElement(globusParentGroup, FILEMANAGER_FILE_PATH_INPUT);
            let directoryGroup = utils_1.getGlobusElement(globusParentGroup, FILEMANAGER_DIR_GROUP);
            let endpointList = utils_1.getGlobusElement(globusParentGroup, FILEMANAGER_ENDPOINT_LIST);
            filePathInput.value = '/~/';
            directoryGroup.style.display = 'none';
            if (this.timeout == null) {
                this.timeout = setTimeout(() => this.retrieveEndpoints(e.target, endpointList), 300);
            }
            else {
                clearTimeout(this.timeout);
                this.timeout = setTimeout(() => this.retrieveEndpoints(e.target, endpointList), 300);
            }
        }
    }
    /**
     * Used as an event listener method that is called every time the input
     * field for the path changes.
     * @param {any} e
     */
    onChangeFilePathInputHandler(e) {
        if (e.target.matches(`.${FILEMANAGER_FILE_PATH_INPUT}`)) {
            let globusParentGroup = utils_1.getGlobusParentGroup(e.target);
            let fileList = utils_1.getGlobusElement(globusParentGroup, FILEMANAGER_FILE_LIST);
            this.retrieveDirectoryContents(e.target, fileList);
        }
    }
    /**
     * Used as an event listener method that is called every time an item on the
     * endpoint menu bar (i.e., sort) is clicked.
     * @param {any} e
     */
    onClickDirMenuButtonHandler(e) {
        if (e.target.matches(`.${utils_1.GLOBUS_MENU_BTN}`)) {
            let globusParentGroup = utils_1.getGlobusParentGroup(e.target);
            let fileList = utils_1.getGlobusElement(globusParentGroup, FILEMANAGER_FILE_LIST);
            let dirOptions = utils_1.getGlobusElement(globusParentGroup, FILEMANAGER_DIR_OPTIONS);
            let filePathInput = utils_1.getGlobusElement(globusParentGroup, FILEMANAGER_FILE_PATH_INPUT);
            if (e.target.matches(`.${FILEMANAGER_MENU_SELECT}`)) {
                let itemList = fileList.children;
                if (e.target.textContent === 'select all') {
                    for (let i = 0; i < itemList.length; i++) {
                        if (!itemList[i].classList.contains(utils_1.GLOBUS_SELECTED)) {
                            itemList[i].classList.add(utils_1.GLOBUS_SELECTED);
                        }
                    }
                    e.target.textContent = 'select none';
                }
                else {
                    for (let i = 0; i < itemList.length; i++) {
                        if (itemList[i].classList.contains(utils_1.GLOBUS_SELECTED)) {
                            itemList[i].classList.remove(utils_1.GLOBUS_SELECTED);
                        }
                    }
                    e.target.textContent = 'select all';
                }
            }
            else if (e.target.matches(`.${FILEMANAGER_MENU_UP_FOLDER}`)) {
                let splits = filePathInput.value.split('/');
                let fileName = splits[splits.length - 2];
                filePathInput.value = filePathInput.value.slice(0, -(fileName.length + 1));
                this.retrieveDirectoryContents(filePathInput, fileList);
            }
            else if (e.target.matches(`.${FILEMANAGER_MENU_REFRESH}`)) {
                this.retrieveDirectoryContents(filePathInput, fileList);
            }
            else if (e.target.matches(`.${FILEMANAGER_MENU_SORT}`)) {
                e.target.classList.toggle(utils_1.GLOBUS_ACTIVE);
                let sortGroup = utils_1.getGlobusElement(globusParentGroup, FILEMANAGER_SORT_GROUP);
                if (e.target.classList.contains(utils_1.GLOBUS_ACTIVE)) {
                    sortGroup.style.display = 'flex';
                }
                else {
                    sortGroup.style.display = 'none';
                }
            }
            else if (e.target.matches(`.${FILEMANAGER_MENU_OPTIONS}`)) {
                dirOptions.hidden = !dirOptions.hidden;
            }
        }
    }
    /**
     * Used as an event listener method that is called every time an option
     * from the endpoint submenu (i.e., Transfer, Share) is clicked.
     * @param {any} e
     */
    onClickMenuOptionHandler(e) {
        let globusParentGroup = utils_1.getGlobusParentGroup(e.target);
        let dirOptions = utils_1.getGlobusElement(globusParentGroup, FILEMANAGER_DIR_OPTIONS);
        if (e.target.matches(`.${FILEMANAGER_MENU_OPTION}`)) {
            let filePathInput = utils_1.getGlobusElement(globusParentGroup, FILEMANAGER_FILE_PATH_INPUT);
            let fileList = utils_1.getGlobusElement(globusParentGroup, FILEMANAGER_FILE_LIST);
            dirOptions.hidden = true;
            if (e.target.matches(`.${FILEMANAGER_OPTION_TRANSFER}`)) {
                this.sourceGroup.appendChild(this.searchGroup);
                this.parentGroup$.next(this.sourceGroup);
                this.sourceGroup.style.display = 'flex';
                this.destinationGroup.style.display = 'flex';
                this.transferGroup.style.display = 'flex';
                this.originalGroup.style.display = 'none';
                this.setGCPDestination();
                this.onClickHeaderHandler({ target: utils_1.getGlobusElement(this.searchGroup.parentElement, utils_1.GLOBUS_HEADER) });
            }
            else if (e.target.matches(`.${FILEMANAGER_OPTION_SHARE}`)) {
                this.openSharedEndpointUrl(filePathInput.value);
            }
            else if (e.target.matches(`.${FILEMANAGER_OPTION_DELETE}`)) {
                this.deleteSelected(globusParentGroup).then(r => { this.retrieveDirectoryContents(filePathInput, fileList); console.log(r); }).catch(e => console.log(e));
            }
            else if (e.target.matches(`.${FILEMANAGER_OPTION_NEWFOLDER}`)) {
                this.createNewDirectory(globusParentGroup);
            }
            else if (e.target.matches(`.${FILEMANAGER_OPTION_RENAME}`)) {
                this.renameFile(globusParentGroup);
            }
        }
        else if (!e.target.matches(`.${FILEMANAGER_MENU_OPTIONS}`)) {
            dirOptions.hidden = true;
        }
    }
    onClickHeaderHandler(e) {
        let globusParentGroup = utils_1.getGlobusParentGroup(e.target);
        let infoDiv = utils_1.getGlobusElement(globusParentGroup, FILEMANAGER_SEARCH_INFO);
        let searchGroup = utils_1.getGlobusElement(globusParentGroup, FILEMANAGER_SEARCH_GROUP);
        if (searchGroup && infoDiv) {
            if (searchGroup.style.display === 'flex') {
                searchGroup.style.display = 'none';
                infoDiv.style.display = 'block';
            }
            else {
                searchGroup.style.display = 'flex';
                infoDiv.style.display = 'none';
            }
        }
        e.target.classList.toggle(utils_1.GLOBUS_ACTIVE);
    }
    onClickGlobusGroupHandler(e) {
        this.parentGroup$.next(e.currentTarget);
    }
    openSharedEndpointUrl(hostPath) {
        let hostEndpointId = this.currentEndpoint.id;
        let createSharedUrl = FILEMANAGER_CREATE_SHARE_URL;
        createSharedUrl = createSharedUrl.replace('<host_endpoint_id>', hostEndpointId);
        hostPath = encodeURIComponent(hostPath);
        createSharedUrl = createSharedUrl.replace('<host_path>', hostPath);
        window.open(createSharedUrl, '_blank');
    }
    startTransfer(e) {
        return __awaiter(this, void 0, void 0, function* () {
            let sourcePathInput = utils_1.getGlobusElement(this.sourceGroup, FILEMANAGER_FILE_PATH_INPUT);
            let sourceEndpoint = utils_1.getGlobusElement(this.sourceGroup, utils_1.GLOBUS_OPEN);
            let destinationPathInput = utils_1.getGlobusElement(this.destinationGroup, FILEMANAGER_FILE_PATH_INPUT);
            let destinationEndpoint = utils_1.getGlobusElement(this.destinationGroup, utils_1.GLOBUS_OPEN);
            let transferResult = utils_1.getGlobusElement(this.transferGroup, FILEMANAGER_TRANSFER_RESULT);
            transferResult.style.display = 'block';
            transferResult.textContent = '';
            transferResult.className = `${FILEMANAGER_TRANSFER_RESULT} ${utils_1.GLOBUS_BORDER}`;
            transferResult.appendChild(utils_1.LOADING_ICON);
            if (!sourceEndpoint || !destinationEndpoint) {
                transferResult.textContent = 'Both endpoints must be selected to start transfer';
                transferResult.classList.add(utils_1.GLOBUS_FAIL);
                return;
            }
            let selectedElements = this.sourceGroup.getElementsByClassName(utils_1.GLOBUS_SELECTED);
            let items = [];
            for (let i = 0; i < selectedElements.length; i++) {
                let file = selectedElements[i];
                let fileData = $.data(file, 'data');
                let transferItem = {
                    'DATA_TYPE': 'transfer_item',
                    'source_path': `${sourcePathInput.value}${fileData.name}`,
                    'destination_path': `${destinationPathInput.value}${fileData.name}`,
                    'recursive': fileData.type === 'dir'
                };
                items.push(transferItem);
            }
            let options = {};
            [].reduce.call(e.target.parentElement.elements, (data, element) => {
                if (element.type === 'checkbox') {
                    data[element.name] = element.checked;
                }
                else if (element.name === 'sync_level') {
                    data[element.name] = parseInt(element.value);
                }
                return data;
            }, options);
            // It's possible for an empty input to create an 'empty' string object.
            // Remove it so it doesn't get propagated as an option to transfer.
            if ("" in options) {
                delete options[""];
            }
            let submissionId = yield transfer_1.requestSubmissionId();
            let taskTransfer = Object.assign({ DATA_TYPE: 'transfer', submission_id: submissionId.value, source_endpoint: sourceEndpoint.id, destination_endpoint: destinationEndpoint.id, DATA: items, notify_on_succeeded: false, notify_on_failed: false }, options);
            transfer_1.submitTask(taskTransfer).then(data => {
                transferResult.textContent = data.message;
                transferResult.classList.add(utils_1.GLOBUS_SUCCESS);
            }).catch(e => {
                console.log(e);
                transferResult.textContent = e.message;
                transferResult.classList.add(utils_1.GLOBUS_FAIL);
            });
        });
    }
    sortFiles(e) {
        let globusParentGroup = utils_1.getGlobusParentGroup(e.target);
        let fileList = utils_1.getGlobusElement(globusParentGroup, FILEMANAGER_FILE_LIST);
        let sortOptions = utils_1.getGlobusElement(globusParentGroup, FILEMANAGER_SORT_OPTIONS);
        let sortButton = utils_1.getGlobusElement(globusParentGroup, FILEMANAGER_SORT_BUTTON);
        if (e.target.matches(`.${FILEMANAGER_SORT_BUTTON}`)) {
            sortButton.classList.toggle(utils_1.GLOBUS_ACTIVE);
        }
        else if (e.target.matches(`.${FILEMANAGER_SORT_OPTIONS}`)) {
            sortButton.classList.remove(utils_1.GLOBUS_ACTIVE);
        }
        utils_1.sortList(fileList, sortOptions.options[sortOptions.selectedIndex].value);
    }
    toggleElementVisibility(element, e) {
        e.target.classList.toggle(utils_1.GLOBUS_ACTIVE);
        if (element.style.display === 'none') {
            element.style.display = 'block';
        }
        else {
            element.style.display = 'none';
        }
    }
    deleteSelected(globusParentGroup) {
        return __awaiter(this, void 0, void 0, function* () {
            let pathInput = utils_1.getGlobusElement(globusParentGroup, FILEMANAGER_FILE_PATH_INPUT);
            let endpoint = utils_1.getGlobusElement(globusParentGroup, utils_1.GLOBUS_OPEN);
            let selectedElements = globusParentGroup.getElementsByClassName(utils_1.GLOBUS_SELECTED);
            let items = [];
            let recursive = false;
            let submissionId = yield transfer_1.requestSubmissionId();
            for (let i = 0; i < selectedElements.length; i++) {
                let file = selectedElements[i];
                let fileData = $.data(file, 'data');
                let deleteItem = {
                    DATA_TYPE: 'delete_item',
                    path: `${pathInput.value}${fileData.name}`,
                };
                if (fileData.type === 'dir') {
                    recursive = true;
                }
                items.push(deleteItem);
            }
            let taskDelete = {
                DATA_TYPE: 'delete',
                endpoint: endpoint.id,
                recursive: recursive,
                DATA: items,
                submission_id: submissionId.value,
                notify_on_succeeded: false,
                notify_on_failed: false
            };
            return transfer_1.submitTask(taskDelete);
        });
    }
    createNewDirectory(globusParentGroup) {
        let fileList = utils_1.getGlobusElement(globusParentGroup, FILEMANAGER_FILE_LIST);
        let filePathInput = utils_1.getGlobusElement(globusParentGroup, FILEMANAGER_FILE_PATH_INPUT);
        let endpoint = utils_1.getGlobusElement(globusParentGroup, utils_1.GLOBUS_OPEN);
        let newDir = utils_1.getGlobusElement(globusParentGroup, FILEMANAGER_NEWDIR);
        if (newDir) {
            return;
        }
        let newDirectory = document.createElement('li');
        newDirectory.className = `${utils_1.GLOBUS_LIST_ITEM} ${FILEMANAGER_DIR_TYPE} ${FILEMANAGER_NEWDIR}`;
        let nameInput = document.createElement('input');
        nameInput.placeholder = 'New Folder';
        nameInput.className = `${utils_1.GLOBUS_INPUT} ${utils_1.GLOBUS_BORDER} ${FILEMANAGER_NEWDIR_INPUT}`;
        nameInput.focus();
        let acceptButton = document.createElement('div');
        acceptButton.className = `${FILEMANAGER_NEWDIR_ACCEPT}`;
        acceptButton.addEventListener('click', () => {
            let operation = {
                DATA_TYPE: 'mkdir',
                path: `${filePathInput.value}${nameInput.value}`
            };
            transfer_1.submitOperation(endpoint.id, operation).then(r => {
                this.retrieveDirectoryContents(filePathInput, fileList);
                console.log(r);
            }).catch(e => console.log(e));
        });
        let cancelButton = document.createElement('div');
        cancelButton.className = `${FILEMANAGER_NEWDIR_CANCEL}`;
        cancelButton.addEventListener('click', () => {
            fileList.removeChild(newDirectory);
        });
        newDirectory.appendChild(nameInput);
        newDirectory.appendChild(acceptButton);
        newDirectory.appendChild(cancelButton);
        fileList.insertBefore(newDirectory, fileList.childNodes[0]);
    }
    renameFile(globusParentGroup) {
        let fileList = utils_1.getGlobusElement(globusParentGroup, FILEMANAGER_FILE_LIST);
        let filePathInput = utils_1.getGlobusElement(globusParentGroup, FILEMANAGER_FILE_PATH_INPUT);
        let selected = utils_1.getGlobusElement(globusParentGroup, utils_1.GLOBUS_SELECTED);
        let endpoint = utils_1.getGlobusElement(globusParentGroup, utils_1.GLOBUS_OPEN);
        let nameElement = selected.firstChild;
        let nameInput = document.createElement('input');
        nameInput.value = nameElement.textContent;
        nameInput.style.color = 'black';
        nameInput.addEventListener('change', () => {
            let operation = {
                DATA_TYPE: 'rename',
                old_path: `${filePathInput.value}${nameElement.textContent}`,
                new_path: `${filePathInput.value}${nameInput.value}`
            };
            transfer_1.submitOperation(endpoint.id, operation).then(r => {
                nameElement.textContent = nameInput.value;
                console.log(r);
            }).catch(e => {
                this.retrieveDirectoryContents(filePathInput, fileList);
            });
            selected.removeChild(nameInput);
            nameElement.style.display = 'block';
        });
        nameInput.focus();
        nameElement.style.display = 'none';
        selected.insertBefore(nameInput, nameElement);
    }
    ;
    setGCPDestination() {
        let endpointInput = utils_1.getGlobusElement(this.destinationGroup, FILEMANAGER_ENDPOINT_INPUT);
        let endpointList = utils_1.getGlobusElement(this.destinationGroup, FILEMANAGER_ENDPOINT_LIST);
        endpointInput.value = 'Your GCP Endpoint';
        endpointList.style.display = 'block';
        endpointList.appendChild(utils_1.LOADING_ICON);
        endpointList.appendChild(utils_1.LOADING_LABEL);
        this.fetchEndpoints(globus_connect_personal_1.GCP_ENDPOINT_ID, endpointList).then(() => {
            endpointList.removeChild(utils_1.LOADING_ICON);
            endpointList.removeChild(utils_1.LOADING_LABEL);
        });
        this.parentGroup$.next(this.destinationGroup);
    }
    createHTMLElements() {
        /* ------------- <endpointSearch> ------------- */
        let endpointInput = document.createElement('input');
        endpointInput.className = `${utils_1.GLOBUS_INPUT} ${FILEMANAGER_ENDPOINT_INPUT} ${utils_1.GLOBUS_BORDER}`;
        endpointInput.placeholder = 'Search collections';
        let endpointList = document.createElement('ul');
        endpointList.className = `${utils_1.GLOBUS_LIST} ${FILEMANAGER_ENDPOINT_LIST} ${utils_1.GLOBUS_BORDER}`;
        endpointList.style.display = 'none';
        let endpointGroup = document.createElement('div');
        endpointGroup.className = `${utils_1.GLOBUS_DISPLAY_FLEX} ${FILEMANAGER_ENDPOINT_GROUP}`;
        endpointGroup.appendChild(endpointInput);
        endpointGroup.appendChild(endpointList);
        endpointGroup.style.display = 'flex';
        /* ------------- </endpointSearch> ------------- */
        /* ------------- <dirSearch> ------------- */
        // DirPath Input. Hidden
        let filePathInput = document.createElement('input');
        filePathInput.className = `${utils_1.GLOBUS_INPUT} ${FILEMANAGER_FILE_PATH_INPUT} ${utils_1.GLOBUS_BORDER}`;
        filePathInput.value = '/~/';
        let menuSelect = document.createElement('div');
        menuSelect.className = `${utils_1.GLOBUS_MENU_BTN} ${FILEMANAGER_MENU_SELECT}`;
        menuSelect.textContent = 'select all';
        let menuUpFolder = document.createElement('div');
        menuUpFolder.className = `${utils_1.GLOBUS_MENU_BTN} ${FILEMANAGER_MENU_UP_FOLDER}`;
        let menuRefresh = document.createElement('div');
        menuRefresh.className = `${utils_1.GLOBUS_MENU_BTN} ${FILEMANAGER_MENU_REFRESH}`;
        let menuSort = document.createElement('div');
        menuSort.className = `${utils_1.GLOBUS_MENU_BTN} ${FILEMANAGER_MENU_SORT}`;
        menuSort.textContent = 'Sort';
        let menuOptions = document.createElement('div');
        menuOptions.className = `${utils_1.GLOBUS_MENU_BTN} ${FILEMANAGER_MENU_OPTIONS}`;
        let dirMenu = document.createElement('div');
        dirMenu.className = `${utils_1.GLOBUS_BORDER} ${utils_1.GLOBUS_MENU} ${FILEMANAGER_DIR_MENU}`;
        dirMenu.appendChild(menuSelect);
        dirMenu.appendChild(menuUpFolder);
        dirMenu.appendChild(menuRefresh);
        dirMenu.appendChild(menuSort);
        dirMenu.appendChild(menuOptions);
        let optionPlaceholder = document.createElement('option');
        optionPlaceholder.textContent = 'Sort By';
        optionPlaceholder.disabled = true;
        optionPlaceholder.selected = true;
        let optionName = document.createElement('option');
        optionName.textContent = 'Name';
        optionName.value = 'name';
        let optionLastModified = document.createElement('option');
        optionLastModified.textContent = 'Last Modified';
        optionLastModified.value = 'date';
        let optionSize = document.createElement('option');
        optionSize.textContent = 'Size';
        optionSize.value = 'size';
        let optionType = document.createElement('option');
        optionType.textContent = 'Type';
        optionType.value = 'type';
        let sortOptions = document.createElement('select');
        sortOptions.className = `${FILEMANAGER_SORT_OPTIONS} ${utils_1.GLOBUS_BORDER}`;
        sortOptions.addEventListener('change', this.sortFiles);
        sortOptions.appendChild(optionPlaceholder);
        sortOptions.appendChild(optionName);
        sortOptions.appendChild(optionLastModified);
        sortOptions.appendChild(optionSize);
        sortOptions.appendChild(optionType);
        let sortButton = document.createElement('div');
        sortButton.className = `${FILEMANAGER_SORT_BUTTON} ${utils_1.GLOBUS_BORDER}`;
        sortButton.addEventListener('click', this.sortFiles);
        let sortGroup = document.createElement('div');
        sortGroup.className = `${FILEMANAGER_SORT_GROUP}`;
        sortGroup.appendChild(sortOptions);
        sortGroup.appendChild(sortButton);
        sortGroup.style.display = 'none';
        let fileList = document.createElement('ul');
        fileList.className = `${utils_1.GLOBUS_LIST} ${FILEMANAGER_FILE_LIST} ${utils_1.GLOBUS_BORDER}`;
        let shareOption = document.createElement('li');
        shareOption.className = `${utils_1.GLOBUS_LIST_ITEM} ${FILEMANAGER_MENU_OPTION} ${FILEMANAGER_OPTION_SHARE}`;
        shareOption.textContent = 'Share';
        let transferOption = document.createElement('li');
        transferOption.className = `${utils_1.GLOBUS_LIST_ITEM} ${FILEMANAGER_MENU_OPTION} ${FILEMANAGER_OPTION_TRANSFER}`;
        transferOption.textContent = 'Transfer';
        let newFolderOption = document.createElement('li');
        newFolderOption.className = `${utils_1.GLOBUS_LIST_ITEM} ${FILEMANAGER_MENU_OPTION} ${FILEMANAGER_OPTION_NEWFOLDER}`;
        newFolderOption.textContent = 'New folder';
        let renameOption = document.createElement('li');
        renameOption.className = `${utils_1.GLOBUS_LIST_ITEM} ${FILEMANAGER_MENU_OPTION} ${FILEMANAGER_OPTION_RENAME}`;
        renameOption.textContent = 'Rename';
        let deleteOption = document.createElement('li');
        deleteOption.className = `${utils_1.GLOBUS_LIST_ITEM} ${FILEMANAGER_MENU_OPTION} ${FILEMANAGER_OPTION_DELETE}`;
        deleteOption.textContent = 'Delete';
        let dirOptions = document.createElement('ul');
        dirOptions.className = `${utils_1.GLOBUS_LIST} ${FILEMANAGER_DIR_OPTIONS} ${utils_1.GLOBUS_BORDER}`;
        dirOptions.appendChild(shareOption);
        dirOptions.appendChild(transferOption);
        dirOptions.appendChild(newFolderOption);
        dirOptions.appendChild(renameOption);
        dirOptions.appendChild(deleteOption);
        dirOptions.hidden = true;
        let directoryGroup = document.createElement('div');
        directoryGroup.className = `${utils_1.GLOBUS_DISPLAY_FLEX} ${FILEMANAGER_DIR_GROUP}`;
        directoryGroup.appendChild(filePathInput);
        directoryGroup.appendChild(dirMenu);
        directoryGroup.appendChild(sortGroup);
        directoryGroup.appendChild(fileList);
        directoryGroup.appendChild(dirOptions);
        directoryGroup.style.display = 'none';
        /* ------------- </dirSearch> ------------- */
        /* ------------- <searchGroup> ------------- */
        this.searchGroup = document.createElement('div');
        this.searchGroup.className = `${utils_1.GLOBUS_DISPLAY_FLEX} ${FILEMANAGER_SEARCH_GROUP}`;
        this.searchGroup.appendChild(endpointGroup);
        this.searchGroup.appendChild(directoryGroup);
        this.searchGroup.addEventListener('keyup', this.onKeyUpEndpointInputHandler.bind(this));
        this.searchGroup.addEventListener('change', this.onChangeFilePathInputHandler.bind(this));
        this.searchGroup.addEventListener('click', this.onClickDirMenuButtonHandler.bind(this));
        this.searchGroup.addEventListener('click', this.onClickMenuOptionHandler.bind(this));
        this.searchGroup.style.display = 'flex';
        /* -------------</searchGroup>------------- */
        /* ------------- <originalGroup> ------------- */
        this.originalGroup = document.createElement('div');
        this.originalGroup.className = utils_1.GLOBUS_PARENT_GROUP;
        this.originalGroup.appendChild(this.searchGroup);
        this.originalGroup.addEventListener('click', this.onClickGlobusGroupHandler.bind(this));
        /* ------------- </originalGroup> ------------- */
        /* ------------- <sourceGroup> ------------- */
        /* Source screen. Hidden */
        let sourceHeader = document.createElement('div');
        sourceHeader.textContent = 'Source';
        sourceHeader.className = `${utils_1.GLOBUS_HEADER} ${utils_1.GLOBUS_BORDER}`;
        sourceHeader.addEventListener('click', this.onClickHeaderHandler);
        let sourceInfo = document.createElement('div');
        sourceInfo.className = `${FILEMANAGER_SEARCH_INFO} ${utils_1.GLOBUS_BORDER}`;
        sourceInfo.style.display = 'none';
        this.sourceGroup = document.createElement('div');
        this.sourceGroup.className = utils_1.GLOBUS_PARENT_GROUP;
        this.sourceGroup.appendChild(sourceHeader);
        this.sourceGroup.appendChild(sourceInfo);
        this.sourceGroup.addEventListener('click', this.onClickGlobusGroupHandler.bind(this));
        this.sourceGroup.style.display = 'none';
        /* ------------- <sourceGroup> ------------- */
        /* ------------- <destinationGroup> ------------- */
        this.destinationGroup = this.sourceGroup.cloneNode(true);
        this.destinationGroup.appendChild(this.searchGroup.cloneNode(true));
        let destinationHeader = utils_1.getGlobusElement(this.destinationGroup, utils_1.GLOBUS_HEADER);
        destinationHeader.textContent = 'Destination';
        destinationHeader.addEventListener('click', this.onClickHeaderHandler);
        let destinationMenuOptions = utils_1.getGlobusElement(this.destinationGroup, FILEMANAGER_MENU_OPTIONS);
        destinationMenuOptions.style.display = 'none';
        this.destinationGroup.addEventListener('keyup', this.onKeyUpEndpointInputHandler.bind(this));
        this.destinationGroup.addEventListener('change', this.onChangeFilePathInputHandler.bind(this));
        this.destinationGroup.addEventListener('click', this.onClickDirMenuButtonHandler.bind(this));
        this.destinationGroup.addEventListener('click', this.onClickMenuOptionHandler.bind(this));
        this.destinationGroup.addEventListener('click', this.onClickGlobusGroupHandler.bind(this));
        this.destinationGroup.style.display = 'none';
        /* ------------- </destinationGroup> ------------- */
        /* ------------- <transferGroup> ------------- */
        let transferResult = document.createElement('div');
        transferResult.className = `${FILEMANAGER_TRANSFER_RESULT} ${utils_1.GLOBUS_BORDER}`;
        transferResult.style.display = 'none';
        transferResult.addEventListener('click', () => transferResult.style.display = 'none');
        let startTransferBtn = document.createElement('div');
        startTransferBtn.textContent = 'Start';
        startTransferBtn.className = `${utils_1.GLOBUS_BUTTON} ${FILEMANAGER_START_TRANSFER_BTN}`;
        startTransferBtn.addEventListener('click', this.startTransfer.bind(this));
        let optionTransferNameInput = document.createElement('input');
        optionTransferNameInput.name = 'label';
        let optionTransferNameLabel = document.createElement('label');
        optionTransferNameLabel.textContent = 'sync - only transfer new or changed files\n';
        optionTransferNameLabel.insertBefore(optionTransferNameInput, optionTransferNameLabel.childNodes[0]);
        let optionSyncSelect1 = document.createElement('option');
        optionSyncSelect1.value = '3';
        optionSyncSelect1.textContent = 'checksum is different';
        let optionSyncSelect2 = document.createElement('option');
        optionSyncSelect2.value = '0';
        optionSyncSelect2.textContent = 'file does not exist on destination';
        let optionSyncSelect3 = document.createElement('option');
        optionSyncSelect3.value = '1';
        optionSyncSelect3.textContent = 'file size is different';
        let optionSyncSelect4 = document.createElement('option');
        optionSyncSelect4.value = '2';
        optionSyncSelect4.textContent = 'modification time is newer';
        let optionSyncInput = document.createElement('select');
        optionSyncInput.name = 'sync_level';
        optionSyncInput.appendChild(optionSyncSelect1);
        optionSyncInput.appendChild(optionSyncSelect2);
        optionSyncInput.appendChild(optionSyncSelect3);
        optionSyncInput.appendChild(optionSyncSelect4);
        optionSyncInput.style.display = 'none';
        let optionSyncCheckbox = document.createElement('input');
        optionSyncCheckbox.type = 'checkbox';
        optionSyncCheckbox.addEventListener('change', this.toggleElementVisibility.bind(this, optionSyncInput));
        let optionSyncLabel = document.createElement('label');
        optionSyncLabel.textContent = 'sync - only transfer new or changed files\n';
        optionSyncLabel.insertBefore(optionSyncCheckbox, optionSyncLabel.childNodes[0]);
        optionSyncLabel.appendChild(optionSyncInput);
        let optionDeleteInput = document.createElement('input');
        optionDeleteInput.type = 'checkbox';
        optionDeleteInput.name = 'delete_destination_extra';
        let optionDeleteLabel = document.createElement('label');
        optionDeleteLabel.textContent = 'delete files on destination that do not exist on source\n';
        optionDeleteLabel.insertBefore(optionDeleteInput, optionDeleteLabel.childNodes[0]);
        let optionPreserveInput = document.createElement('input');
        optionPreserveInput.type = 'checkbox';
        optionPreserveInput.name = 'preserve_timestamp';
        let optionPreserveLabel = document.createElement('label');
        optionPreserveLabel.textContent = 'preserve source file modification times\n';
        optionPreserveLabel.insertBefore(optionPreserveInput, optionPreserveLabel.childNodes[0]);
        let optionVerifyInput = document.createElement('input');
        optionVerifyInput.type = 'checkbox';
        optionVerifyInput.checked = true;
        optionVerifyInput.name = 'verify_checksum';
        let optionVerifyLabel = document.createElement('label');
        optionVerifyLabel.textContent = 'verify file integrity after transfer\n';
        optionVerifyLabel.insertBefore(optionVerifyInput, optionVerifyLabel.childNodes[0]);
        let optionEncryptInput = document.createElement('input');
        optionEncryptInput.type = 'checkbox';
        optionEncryptInput.name = 'encrypt_data';
        let optionEncryptLabel = document.createElement('label');
        optionEncryptLabel.textContent = 'encrypt transfer';
        optionEncryptLabel.insertBefore(optionEncryptInput, optionEncryptLabel.childNodes[0]);
        let transferOptions = document.createElement('div');
        transferOptions.appendChild(optionSyncLabel);
        transferOptions.appendChild(optionDeleteLabel);
        transferOptions.appendChild(optionPreserveLabel);
        transferOptions.appendChild(optionVerifyLabel);
        transferOptions.appendChild(optionEncryptLabel);
        transferOptions.className = `${utils_1.GLOBUS_BORDER} ${FILEMANAGER_TRANSFER_OPTIONS}`;
        transferOptions.style.display = 'none';
        let transferOptionsBtn = document.createElement('div');
        transferOptionsBtn.style.cursor = 'pointer';
        transferOptionsBtn.textContent = 'Transfer & Sync Options';
        transferOptionsBtn.className = `${utils_1.GLOBUS_BUTTON} ${FILEMANAGER_TRANSFER_OPTIONS_BTN}`;
        transferOptionsBtn.addEventListener('click', this.toggleElementVisibility.bind(this, transferOptions));
        this.transferGroup = document.createElement('form');
        this.transferGroup.className = utils_1.GLOBUS_PARENT_GROUP;
        this.transferGroup.appendChild(transferResult);
        this.transferGroup.appendChild(startTransferBtn);
        this.transferGroup.appendChild(transferOptionsBtn);
        this.transferGroup.appendChild(transferOptions);
        this.transferGroup.style.display = 'none';
        /* ------------- </transferGroup> ------------- */
        this.node.appendChild(this.originalGroup);
        this.node.appendChild(this.sourceGroup);
        this.node.appendChild(this.destinationGroup);
        this.node.appendChild(this.transferGroup);
        this.parentGroup$ = new rxjs_1.BehaviorSubject(this.originalGroup);
        this.parentGroup$.asObservable().subscribe(globusParentGroup => {
            let selectedItems = globusParentGroup.getElementsByClassName(utils_1.GLOBUS_SELECTED);
            let menuSelect = utils_1.getGlobusElement(globusParentGroup, FILEMANAGER_MENU_SELECT);
            if (menuSelect) {
                selectedItems.length === 0 ? menuSelect.textContent = 'select all' : menuSelect.textContent = 'select none';
            }
            let infoDiv = utils_1.getGlobusElement(globusParentGroup, FILEMANAGER_SEARCH_INFO);
            if (infoDiv) {
                let groupHeader = utils_1.getGlobusElement(globusParentGroup, utils_1.GLOBUS_HEADER);
                let endpointList = utils_1.getGlobusElement(globusParentGroup, FILEMANAGER_ENDPOINT_LIST);
                let endpointInput = utils_1.getGlobusElement(globusParentGroup, FILEMANAGER_ENDPOINT_INPUT);
                let filePathInput = utils_1.getGlobusElement(globusParentGroup, FILEMANAGER_FILE_PATH_INPUT);
                if (endpointList) {
                    if (endpointList.style.display === 'none') {
                        infoDiv.textContent = `${endpointInput.value}: ${filePathInput.value}`;
                        if (groupHeader.textContent === 'Source') {
                            infoDiv.textContent += `\n${selectedItems.length} file(s) selected`;
                        }
                    }
                }
                else {
                    infoDiv.textContent = 'No endpoint selected';
                }
            }
            let optionShare = utils_1.getGlobusElement(globusParentGroup, FILEMANAGER_OPTION_SHARE);
            if (optionShare) {
                switch (selectedItems.length) {
                    case 0:
                        optionShare.classList.remove(utils_1.GLOBUS_DISABLED);
                        break;
                    default:
                        optionShare.classList.add(utils_1.GLOBUS_DISABLED);
                        break;
                }
            }
            let optionDelete = utils_1.getGlobusElement(globusParentGroup, FILEMANAGER_OPTION_DELETE);
            if (optionDelete) {
                selectedItems.length === 0 ? optionDelete.classList.add(utils_1.GLOBUS_DISABLED) : optionDelete.classList.remove(utils_1.GLOBUS_DISABLED);
            }
            let optionRename = utils_1.getGlobusElement(globusParentGroup, FILEMANAGER_OPTION_RENAME);
            if (optionRename) {
                selectedItems.length !== 1 ? optionRename.classList.add(utils_1.GLOBUS_DISABLED) : optionRename.classList.remove(utils_1.GLOBUS_DISABLED);
            }
            let optionNewFolder = utils_1.getGlobusElement(globusParentGroup, FILEMANAGER_OPTION_NEWFOLDER);
            if (optionNewFolder) {
                let fileList = utils_1.getGlobusElement(globusParentGroup, FILEMANAGER_FILE_LIST);
                fileList.firstChild && fileList.firstChild.classList.contains(utils_1.GLOBUS_FETCH_ERROR) ?
                    optionNewFolder.classList.add(utils_1.GLOBUS_DISABLED) :
                    optionNewFolder.classList.remove(utils_1.GLOBUS_DISABLED);
            }
        }, e => {
            console.log(e);
        }, () => {
            console.log('Completed');
        });
    }
    transferFile(files) {
        utils_1.removeChildren(this.node);
        this.createHTMLElements();
        let endpointInput = utils_1.getGlobusElement(this.originalGroup, FILEMANAGER_ENDPOINT_INPUT);
        let endpointList = utils_1.getGlobusElement(this.originalGroup, FILEMANAGER_ENDPOINT_LIST);
        let filePathInput = utils_1.getGlobusElement(this.originalGroup, FILEMANAGER_FILE_PATH_INPUT);
        let fileList = utils_1.getGlobusElement(this.originalGroup, FILEMANAGER_FILE_LIST);
        let optionTranfer = utils_1.getGlobusElement(this.originalGroup, FILEMANAGER_OPTION_TRANSFER);
        endpointInput.value = files.endpointId;
        filePathInput.value = files.path;
        this.retrieveEndpoints(endpointInput, endpointList).then(() => {
            this.endpointClicked({ currentTarget: endpointList.firstChild }).then(() => {
                this.onClickMenuOptionHandler({ target: optionTranfer });
                this.retrieveDirectoryContents(filePathInput, fileList).then(() => {
                    for (let i = 0; i < fileList.children.length; i++) {
                        if (files.fileNames.indexOf(fileList.children[i].firstChild.title) > -1) {
                            fileList.children[i].classList.add(utils_1.GLOBUS_SELECTED);
                        }
                    }
                    this.parentGroup$.next(this.sourceGroup);
                });
            });
        });
    }
}
exports.GlobusFileManager = GlobusFileManager;


/***/ }),

/***/ "./lib/globus/widgets/globus_connect_personal.js":
/*!*******************************************************!*\
  !*** ./lib/globus/widgets/globus_connect_personal.js ***!
  \*******************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.GlobusConnectPersonal = exports.GCP_ENDPOINT_ID = exports.CONNECT_PERSONAL = void 0;
const widgets_1 = __webpack_require__(/*! @lumino/widgets */ "webpack/sharing/consume/default/@lumino/widgets");
const services_1 = __webpack_require__(/*! @jupyterlab/services */ "webpack/sharing/consume/default/@jupyterlab/services");
const utils_1 = __webpack_require__(/*! ../../utils */ "./lib/utils.js");
// import { node } from "prop-types";
const GLOBUS_CONNECT_PERSONAL = 'jp-Globus-connect-personal';
const GCP_ERROR_SCREEN = 'jp-GlobusConnectPersonal-errorScreen';
// TODO: These constants are Windows only
const LOCAL_APPDATA = 'AppData/Local/';
const GCP_CLIENT_ID = 'Globus Connect/client-id.txt';
const GCP_CLIENT_LOG = 'Globus Connect/log/globus_connect_personal.log';
const SERVICE_DRIVE_URL = 'api/contents/';
const GCP_DRIVE_NAME = 'GCPDrive';
exports.CONNECT_PERSONAL = 'globus-connectPersonal';
exports.GCP_ENDPOINT_ID = '';
// TODO Lots of error handling: GCP not found, etc.
// TODO iOS behaves differently. ProcessEnv, import node
// TODO Transfer with right click
class GlobusConnectPersonal extends widgets_1.Widget {
    constructor(app, manager, factory) {
        super();
        this.id = exports.CONNECT_PERSONAL;
        this.layout = new widgets_1.PanelLayout();
        this.factory = factory;
        this.serverSettings = services_1.ServerConnection.makeSettings();
        this.app = app;
        this.addClass(GLOBUS_CONNECT_PERSONAL);
        this.title.label = 'Globus Connect Personal';
        this.setGCPEndpointId();
        const drive = new services_1.Drive({ name: GCP_DRIVE_NAME });
        manager.services.contents.addDrive(drive);
        this.browser = this.factory.createFileBrowser('globus-connect-personal', {
            driveName: GCP_DRIVE_NAME
        });
        this.update();
    }
    onUpdateRequest() {
        this.navigateToGCPHomeDir();
    }
    navigateToGCPHomeDir() {
        services_1.ServerConnection.makeRequest(`${this.serverSettings.baseUrl}${SERVICE_DRIVE_URL}${LOCAL_APPDATA}${GCP_CLIENT_LOG}`, {}, this.serverSettings)
            .then(response => {
            if (response.status >= 400) {
                throw response.json();
            }
            else {
                return response.json();
            }
        }).then((data) => __awaiter(this, void 0, void 0, function* () {
            let path = this.findGCPHomeDirPath(data.content);
            let gcpEndpoint = this.findGCPEndpoint(path);
            if (gcpEndpoint) {
                yield this.browser.model.cd();
                yield this.browser.model.cd(`/${gcpEndpoint}`);
                this.layout.addWidget(this.browser);
            }
            else {
                let newPath = this.findAlternatePath(path);
                this.createErrorScreen(newPath);
            }
        })).catch(e => {
            console.log(e);
        });
    }
    findGCPHomeDirPath(content) {
        let lines = content.split('\n');
        for (let i = lines.length - 1; i >= 0; i--) {
            if (lines[i].indexOf('homedir') > -1) {
                return lines[i].slice(lines[i].indexOf('homedir') + 9, -2);
            }
            else if (lines[i].indexOf('home_dir') > -1) {
                return lines[i].slice(lines[i].indexOf('home_dir') + 11, -2);
            }
        }
    }
    findGCPEndpoint(localPath) {
        // Find the users local GCP endpoint UUID
        // this.app.info changed since jupyterlab v3 meaning this no longer works.
        // Additionally, I'm not sure why serverRoot would contain the UUID, so this
        // is likely suspect anyway.
        // TODO: Fix and update this code with an explanation or remove it.
        //         if (localPath.indexOf(this.app.info.directories.serverRoot) === 0) {
        //             localPath = localPath.slice(this.app.info.directories.serverRoot.length);
        //             return localPath;
        //         }
        //         else {
        //             return null;
        //         }
        return null;
    }
    setGCPEndpointId() {
        services_1.ServerConnection.makeRequest(`${this.serverSettings.baseUrl}${SERVICE_DRIVE_URL}${LOCAL_APPDATA}${GCP_CLIENT_ID}`, {}, this.serverSettings)
            .then(response => { return response.json(); })
            .then(data => {
            exports.GCP_ENDPOINT_ID = data.content;
        });
    }
    restartJL(newPath) {
        utils_1.LOADING_LABEL.textContent = 'Opening in a new window...';
        this.errorScreen.appendChild(utils_1.LOADING_ICON);
        this.errorScreen.appendChild(utils_1.LOADING_LABEL);
        this.app.serviceManager.terminals.startNew().then(session => {
            session.send({ type: 'stdin', content: [`jupyter lab --NotebookApp.notebook_dir="${newPath}"\r`] });
        });
    }
    createErrorScreen(newPath) {
        let errorText = document.createElement('div');
        errorText.textContent = `Looks like your GCP home directory can\'t be accessed by your current JupyterLab 
                                 startup location. Would you like to restart JupyterLab in "${newPath}" to fix this issue?`;
        errorText.className = utils_1.GLOBUS_BORDER;
        errorText.style.padding = '5px 10px';
        let restartJLButton = document.createElement('button');
        restartJLButton.title = 'Restart JupyterLab';
        restartJLButton.textContent = 'RESTART';
        restartJLButton.className = `jp-mod-styled jp-mod-accept ${utils_1.GLOBUS_BUTTON}`;
        restartJLButton.addEventListener('click', () => this.restartJL(newPath));
        this.errorScreen = document.createElement('div');
        this.errorScreen.className = `${utils_1.GLOBUS_DISPLAY_FLEX} ${GCP_ERROR_SCREEN}`;
        this.errorScreen.appendChild(utils_1.ERROR_IMAGE);
        this.errorScreen.appendChild(errorText);
        this.errorScreen.appendChild(restartJLButton);
        this.node.appendChild(this.errorScreen);
    }
    findAlternatePath(path) {
        //This seems to find an alternate path based no the users notebook, but it
        // isn't clear why or how. It stopped working since Jupyterlab v3 moved the
        // "app.info" object below
        // TODO: Fix and update this code with an explanation or remove it.
        //         let split1 = path.split('/');
        //         let split2 = this.app.info.directories.serverRoot.split('/');
        //
        //         let i = 0;
        //         let newPath = '';
        //         while (i < split1.length && i < split2.length && split1[i] == split2[i]) {
        //             newPath += `${split1[i]}/`;
        //             i += 1;
        //         }
        //
        //         return newPath ? newPath : `${split1[0]}/`;
        return path;
    }
}
exports.GlobusConnectPersonal = GlobusConnectPersonal;


/***/ }),

/***/ "./lib/globus/widgets/search.js":
/*!**************************************!*\
  !*** ./lib/globus/widgets/search.js ***!
  \**************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.GlobusSearch = exports.SEARCH = void 0;
const widgets_1 = __webpack_require__(/*! @lumino/widgets */ "webpack/sharing/consume/default/@lumino/widgets");
const search_1 = __webpack_require__(/*! ../api/search */ "./lib/globus/api/search.js");
const utils_1 = __webpack_require__(/*! ../../utils */ "./lib/utils.js");
const $ = __importStar(__webpack_require__(/*! jquery */ "webpack/sharing/consume/default/jquery/jquery"));
const json_formatter_js_1 = __importDefault(__webpack_require__(/*! json-formatter-js */ "webpack/sharing/consume/default/json-formatter-js/json-formatter-js"));
// TODO Filtering needs to be done better. If a filter is a number like # of atoms, then it should add an input box instead of checkboxes
// TODO Filtering #2. Add numbers right next to the filters. How many elements of this type of filter are available.
// TODO Filtering #3. I'm only filtering the first 10 results. Filter the whole dataset
// TODO Paging for the whole dataset
// TODO Refactor this page beccause it was done in a rush. Badly written.
// TODO Config file
/**
 * CSS Classes
 */
const GLOBUS_SEARCH = 'jp-Globus-search';
const SEARCH_INDEX_GROUP = 'jp-Search-indexGroup';
const SEARCH_INDEX_SELECT = 'jp-Search-indexSelect';
const SEARCH_RESULT_INPUT = 'jp-Search-resultInput';
const SEARCH_RESULT_LIST = 'jp-Search-resultList';
const SEARCH_MENU_FILTER = 'jp-Search-menuFilter';
const SEARCH_FILTER_LIST = 'jp-Search-filterList';
const SEARCH_FILTER = 'jp-Search-filter';
const SEARCH_FILTER_CHECKBOX = 'jp-Search-filterCheckbox';
const SEARCH_MENU = 'jp-Search-menu';
const SEARCH_RESULT_GROUP = 'jp-Search-resultGroup';
const SEARCH_OVERVIEW_MENU = 'jp-Search-overviewMenu';
const SEARCH_OVERVIEW = 'jp-Search-overview';
const SEARCH_OVERVIEW_GROUP = 'jp-Search-overviewGroup';
const SEARCH_MENU_BACK = 'jp-Search-menuBack';
const SEARCH_MENU_OVERVIEW = 'jp-Search-menuOverview';
exports.SEARCH = 'globus-search';
class GlobusSearch extends widgets_1.Widget {
    constructor() {
        super();
        this.id = exports.SEARCH;
        this.addClass(GLOBUS_SEARCH);
        this.title.label = 'Search';
        this.createHTMLElements();
        this.update();
    }
    onUpdateRequest() {
    }
    searchIndex(e) {
        let resultInput = utils_1.getGlobusElement(this.parentGroup, SEARCH_RESULT_INPUT);
        let resultList = utils_1.getGlobusElement(this.parentGroup, SEARCH_RESULT_LIST);
        let resultGroup = utils_1.getGlobusElement(this.parentGroup, SEARCH_RESULT_GROUP);
        let indexSelect = utils_1.getGlobusElement(this.parentGroup, SEARCH_INDEX_SELECT);
        let filterList = utils_1.getGlobusElement(this.parentGroup, SEARCH_FILTER_LIST);
        let overviewGroup = utils_1.getGlobusElement(this.parentGroup, SEARCH_OVERVIEW_GROUP);
        utils_1.removeChildren(filterList);
        let index = $.data(indexSelect.options[indexSelect.selectedIndex], 'value');
        let filterMap = {};
        for (let key in index.filterObject) {
            let filter = document.createElement('div');
            filter.className = SEARCH_FILTER;
            filter.title = key;
            filter.innerHTML = `<h4 style="margin: 10px">${key}</h4>`;
            filterList.appendChild(filter);
            filterMap[key] = filter.firstChild;
        }
        $.data(filterList, 'map', filterMap);
        resultGroup.style.display = 'flex';
        overviewGroup.style.display = 'none';
        if (e.currentTarget.matches(`.${SEARCH_INDEX_SELECT}`)) {
            resultInput.value = '*';
        }
        this.retrieveResults(index, resultInput.value, resultList);
    }
    fetchResults(index, query, resultList) {
        let filterCheckboxes = this.parentGroup.getElementsByClassName(SEARCH_FILTER_CHECKBOX);
        let params = {};
        for (let i = 0; i < filterCheckboxes.length; i++) {
            if (filterCheckboxes[i].firstChild.checked) {
                params[$.data(filterCheckboxes[i], 'key')] = $.data(filterCheckboxes[i], 'value');
            }
        }
        return new Promise((resolve) => {
            index.search(query, params).then(data => {
                if (data.gmeta.length > 0) {
                    this.displayResults(index, data, resultList);
                }
                else {
                    utils_1.displayError({ customMessage: 'No results' }, resultList);
                }
                resolve();
            });
        });
    }
    displayResults(index, data, resultList) {
        let filterList = utils_1.getGlobusElement(this.parentGroup, SEARCH_FILTER_LIST);
        let filterMap = $.data(filterList, 'map');
        for (let key in filterMap) {
            utils_1.hideChildren(filterMap[key]);
        }
        for (let i = 0; i < data.gmeta.length; i++) {
            let resultData = data.gmeta[i];
            let result = document.createElement('li');
            result.className = utils_1.GLOBUS_LIST_ITEM;
            $.data(result, 'data', resultData);
            let previewObject = {};
            for (let key in index.previewObject) {
                let data = resultData.content[0];
                let keys = index.previewObject[key].split('.');
                for (let i = 0; i < keys.length; i++) {
                    if (data) {
                        data = data[keys[i]];
                    }
                    else
                        break;
                }
                previewObject[key] = data;
            }
            let name = document.createElement('div');
            name.textContent = name.title = previewObject.title.split('/').pop();
            delete previewObject.title;
            name.className = utils_1.GLOBUS_LIST_ITEM_TITLE;
            result.appendChild(name);
            for (let key in previewObject) {
                let property = document.createElement('div');
                property.className = utils_1.GLOBUS_LIST_ITEM_SUBTITLE;
                property.innerHTML = `<strong>${key}:</strong> ${previewObject[key]}\n`;
                result.appendChild(property);
            }
            for (let key in index.filterObject) {
                let data = resultData.content[0];
                let keys = index.filterObject[key].split('.');
                for (let i = 0; i < keys.length; i++) {
                    if (data) {
                        data = data[keys[i]];
                    }
                    else
                        break;
                }
                if (data) {
                    let i = 0;
                    for (i = 0; i < filterMap[key].children.length; i++) {
                        if (data.toString() === filterMap[key].children[i].title) {
                            filterMap[key].children[i].style.display = 'block';
                            break;
                        }
                    }
                    if (i === filterMap[key].children.length) {
                        let checkbox = document.createElement('label');
                        checkbox.className = `${SEARCH_FILTER_CHECKBOX}`;
                        checkbox.title = data;
                        checkbox.style.display = 'block';
                        checkbox.innerHTML = `<input type="checkbox"> ${data}`;
                        $.data(checkbox, 'key', index.filterObject[key]);
                        $.data(checkbox, 'value', data);
                        filterMap[key].appendChild(checkbox);
                        checkbox.addEventListener('change', () => {
                            let resultInput = utils_1.getGlobusElement(this.parentGroup, SEARCH_RESULT_INPUT);
                            this.retrieveResults(index, `${resultInput.value}`, resultList);
                        });
                    }
                }
            }
            result.addEventListener("click", this.resultClicked.bind(this, index));
            resultList.appendChild(result);
        }
    }
    retrieveResults(index, query = '*', resultList) {
        utils_1.removeChildren(resultList);
        utils_1.LOADING_LABEL.textContent = 'Loading Results...';
        resultList.appendChild(utils_1.LOADING_ICON);
        resultList.appendChild(utils_1.LOADING_LABEL);
        this.fetchResults(index, query, resultList).then(() => {
            resultList.removeChild(utils_1.LOADING_ICON);
            resultList.removeChild(utils_1.LOADING_LABEL);
        });
    }
    resultClicked(index, e) {
        let resultData = $.data(e.currentTarget, 'data');
        e.currentTarget.classList.toggle(utils_1.GLOBUS_OPEN);
        let overview = utils_1.getGlobusElement(this.parentGroup, SEARCH_OVERVIEW);
        overview.style.padding = '10px';
        utils_1.removeChildren(overview);
        let resultGroup = utils_1.getGlobusElement(this.parentGroup, SEARCH_RESULT_GROUP);
        overview.parentElement.style.display = 'block';
        resultGroup.style.display = 'none';
        let title = resultData.content[0];
        let keys = index.previewObject.title.split('.');
        for (let i = 0; i < keys.length; i++) {
            if (title) {
                title = title[keys[i]];
            }
            else
                break;
        }
        let name = document.createElement('div');
        name.textContent = name.title = title.split('/').pop();
        name.className = utils_1.GLOBUS_LIST_ITEM_TITLE;
        overview.appendChild(name);
        let formatter = new json_formatter_js_1.default(resultData.content[0]);
        formatter.openAtDepth(1);
        let json = formatter.render();
        json.style.fontSize = '12px';
        overview.appendChild(json);
    }
    ;
    filterResults(e) {
        let filterList = utils_1.getGlobusElement(this.parentGroup, SEARCH_FILTER_LIST);
        e.target.classList.toggle(utils_1.GLOBUS_ACTIVE);
        filterList.hidden = !filterList.hidden;
    }
    createHTMLElements() {
        /* ------------- <indexGroup> ------------- */
        let indexDefault = document.createElement('option');
        indexDefault.text = 'Select Index';
        indexDefault.disabled = true;
        indexDefault.selected = true;
        let indexRamses = document.createElement('option');
        indexRamses.text = 'Ramses';
        $.data(indexRamses, 'value', SEARCH_INDEX['RAMSES']);
        let indexMDF = document.createElement('option');
        indexMDF.text = 'MDF';
        $.data(indexMDF, 'value', SEARCH_INDEX['MDF']);
        let indexKasthuri = document.createElement('option');
        indexKasthuri.text = 'Kasthuri';
        $.data(indexKasthuri, 'value', SEARCH_INDEX['KASTHURI']);
        let indexSelect = document.createElement('select');
        indexSelect.className = `${utils_1.GLOBUS_DISPLAY_FLEX} ${SEARCH_INDEX_SELECT} ${utils_1.GLOBUS_BORDER}`;
        indexSelect.appendChild(indexDefault);
        indexSelect.appendChild(indexRamses);
        indexSelect.appendChild(indexMDF);
        indexSelect.appendChild(indexKasthuri);
        indexSelect.addEventListener('change', this.searchIndex.bind(this));
        let indexGroup = document.createElement('div');
        indexGroup.className = `${utils_1.GLOBUS_DISPLAY_FLEX} ${SEARCH_INDEX_GROUP}`;
        indexGroup.appendChild(indexSelect);
        indexGroup.style.display = 'flex';
        /* ------------- </indexGroup> ------------- */
        /* ------------- <resultSearch> ------------- */
        let resultInput = document.createElement('input');
        resultInput.className = `${utils_1.GLOBUS_INPUT} ${utils_1.GLOBUS_BORDER} ${SEARCH_RESULT_INPUT}`;
        resultInput.value = '*';
        resultInput.addEventListener('change', this.searchIndex.bind(this));
        let menuFilter = document.createElement('div');
        menuFilter.className = `${utils_1.GLOBUS_MENU_BTN} ${SEARCH_MENU_FILTER}`;
        menuFilter.textContent = 'Filters';
        menuFilter.addEventListener('click', this.filterResults.bind(this));
        let filterList = document.createElement('div');
        filterList.className = `${utils_1.GLOBUS_LIST} ${utils_1.GLOBUS_BORDER} ${SEARCH_FILTER_LIST}`;
        filterList.hidden = true;
        let resultMenu = document.createElement('div');
        resultMenu.className = `${utils_1.GLOBUS_MENU} ${utils_1.GLOBUS_BORDER} ${SEARCH_MENU}`;
        resultMenu.appendChild(menuFilter);
        let resultList = document.createElement('ul');
        resultList.className = `${utils_1.GLOBUS_LIST} ${utils_1.GLOBUS_BORDER} ${SEARCH_RESULT_LIST}`;
        let resultGroup = document.createElement('div');
        resultGroup.className = `${utils_1.GLOBUS_DISPLAY_FLEX} ${SEARCH_RESULT_GROUP}`;
        resultGroup.appendChild(resultInput);
        resultGroup.appendChild(resultMenu);
        resultGroup.appendChild(filterList);
        resultGroup.appendChild(resultList);
        resultGroup.style.display = 'none';
        /* ------------- </resultSearch> ------------- */
        /* ------------- <overviewGroup> ------------- */
        let menuBack = document.createElement('div');
        menuBack.className = `${utils_1.GLOBUS_MENU_BTN} ${SEARCH_MENU_BACK}`;
        menuBack.addEventListener('click', () => {
            let overviewGroup = utils_1.getGlobusElement(this.parentGroup, SEARCH_OVERVIEW_GROUP);
            let resultGroup = utils_1.getGlobusElement(this.parentGroup, SEARCH_RESULT_GROUP);
            overviewGroup.style.display = 'none';
            resultGroup.style.display = 'flex';
        });
        let menuOverview = document.createElement('div');
        menuOverview.className = `${utils_1.GLOBUS_MENU_BTN} ${SEARCH_MENU_OVERVIEW}`;
        menuOverview.textContent = 'Overview';
        let overviewMenu = document.createElement('div');
        overviewMenu.className = `${utils_1.GLOBUS_MENU} ${SEARCH_OVERVIEW_MENU} ${utils_1.GLOBUS_BORDER}`;
        overviewMenu.appendChild(menuBack);
        overviewMenu.appendChild(menuOverview);
        let overview = document.createElement('ul');
        overview.className = `${utils_1.GLOBUS_LIST} ${SEARCH_OVERVIEW} ${utils_1.GLOBUS_BORDER}`;
        let overviewGroup = document.createElement('div');
        overviewGroup.className = `${utils_1.GLOBUS_DISPLAY_FLEX} ${SEARCH_OVERVIEW_GROUP}`;
        overviewGroup.appendChild(overviewMenu);
        overviewGroup.appendChild(overview);
        overviewGroup.style.display = 'none';
        /* ------------- </overviewGroup> ------------- */
        /* ------------- <parentGroup> ------------- */
        this.parentGroup = document.createElement('div');
        this.parentGroup.className = `${utils_1.GLOBUS_DISPLAY_FLEX} ${utils_1.GLOBUS_PARENT_GROUP}`;
        this.parentGroup.appendChild(indexGroup);
        this.parentGroup.appendChild(resultGroup);
        this.parentGroup.appendChild(overviewGroup);
        /* -------------</parentGroup>------------- */
        this.node.appendChild(this.parentGroup);
    }
}
exports.GlobusSearch = GlobusSearch;
/**
 * MDF Index class
 */
class MDFIndex {
    constructor() {
        this.searchIndex = '1a57bbe5-5272-477f-9d31-343b8258b7a5';
        this.filterObject = {
            'Number of atoms': 'crystal_structure.number_of_atoms',
            'Composition': 'material.composition',
            'DFT Converged': 'dft.converged'
        };
        this.previewObject = {
            'title': 'mdf.source_name',
            'Material': 'material.composition',
            'Elements': 'material.elements',
            'Files': 'files.length',
        };
    }
    retrieveFiles(metaResult) {
        let files = metaResult.content[0].files;
        let regExpResult = utils_1.ENDPOINT_ID_REG_EXP.exec(files[0].globus);
        let endpointId = regExpResult[0];
        let temp = files[0].globus.slice(files[0].globus.indexOf(endpointId) + endpointId.length).split('/');
        temp.pop();
        let path = `${temp.join('/')}/`;
        let fileNames = [];
        for (let i = 0; i < files.length; i++) {
            fileNames.push(files[i].globus.slice(files[i].globus.indexOf(path) + path.length));
        }
        return { endpointId, path, fileNames };
    }
    search(query, params) {
        let searchQuery = 'files.globus:globus AND ';
        if ($.isEmptyObject(params)) {
            searchQuery += query;
        }
        else {
            searchQuery += `${search_1.searchQueryParams(params)} AND ${query}`;
        }
        return search_1.searchIndexAdvanced(this.searchIndex, searchQuery);
    }
}
/**
 * Kasthuri Index class
 */
class KasthuriIndex {
    constructor() {
        this.searchIndex = '7dba248c-f41e-4bed-89f9-0043353da169';
        this.filterObject = {};
        this.previewObject = {
            'title': 'remote_file_manifest.0.filename',
            'Category': 'beamline.category.value',
            'Recon_type': 'beamline.recon_type.value',
            'Sample': 'beamline.sample.value',
            'Experiment': 'beamline.experiment.value'
        };
    }
    retrieveFiles(metaResult) {
        let file = metaResult.content[0].remote_file_manifest[0].url;
        let regExpResult = utils_1.ENDPOINT_ID_REG_EXP.exec(file);
        let endpointId = regExpResult[0];
        let temp = file.slice(file.indexOf(endpointId) + endpointId.length + 1).split('/');
        temp.pop();
        let path = `${temp.join('/')}/`;
        let fileNames = [file.slice(file.indexOf(path) + path.length)];
        return { endpointId, path, fileNames };
    }
    search(query, params) {
        let searchQuery = '';
        if ($.isEmptyObject(params)) {
            searchQuery = query;
        }
        else {
            searchQuery = `${search_1.searchQueryParams(params)} AND ${query}`;
        }
        return search_1.searchIndexAdvanced(this.searchIndex, searchQuery);
    }
}
/**
 * Ramses Index class
 */
class RamsesIndex {
    constructor() {
        this.searchIndex = '5e83718e-add0-4f06-a00d-577dc78359bc';
        this.filterObject = {
            'Contributor': 'perfdata.contributors.0.contributor_name',
            'Category': 'perfdata.category.value',
            'Publication Year': 'perfdata.publication_year.value',
            'Organization': 'perfdata.organization.value',
            'Maximum File Size': 'perfdata.maximum_file_size.value'
        };
        this.previewObject = {
            'title': 'perfdata.titles.0.value',
            'Description': 'perfdata.descriptions.0.value',
            'Organization': 'perfdata.organization.value',
            'Date': 'perfdata.dates.0.value',
            'Contributors': 'perfdata.contributors.0.contributor_name'
        };
    }
    retrieveFiles(metaResult) {
        let file = metaResult.subject;
        let regExpResult = utils_1.ENDPOINT_ID_REG_EXP.exec(file);
        let endpointId = regExpResult[0];
        let temp = file.slice(file.indexOf(endpointId) + endpointId.length + 1).split('/');
        temp.pop();
        let path = `${temp.join('/')}/`;
        let fileNames = [file.slice(file.indexOf(path) + path.length)];
        return { endpointId, path, fileNames };
    }
    search(query, params) {
        let searchQuery = '';
        if ($.isEmptyObject(params)) {
            searchQuery = query;
        }
        else {
            searchQuery = `${search_1.searchQueryParams(params)} AND ${query}`;
        }
        return search_1.searchIndexAdvanced(this.searchIndex, searchQuery);
    }
}
const SEARCH_INDEX = {
    RAMSES: new RamsesIndex(),
    MDF: new MDFIndex(),
    KASTHURI: new KasthuriIndex()
};


/***/ }),

/***/ "./lib/handler.js":
/*!************************!*\
  !*** ./lib/handler.js ***!
  \************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.requestAPI = void 0;
const coreutils_1 = __webpack_require__(/*! @jupyterlab/coreutils */ "webpack/sharing/consume/default/@jupyterlab/coreutils");
const services_1 = __webpack_require__(/*! @jupyterlab/services */ "webpack/sharing/consume/default/@jupyterlab/services");
/**
 * Call the API extension
 *
 * @param endPoint API REST end point for the extension
 * @param init Initial values for the request
 * @returns The response body interpreted as JSON
 */
function requestAPI(endPoint = '', init = {}) {
    return __awaiter(this, void 0, void 0, function* () {
        // Make request to Jupyter API
        const settings = services_1.ServerConnection.makeSettings();
        const requestUrl = coreutils_1.URLExt.join(settings.baseUrl, 'globus-jupyterlab', endPoint);
        let response;
        try {
            console.log('making request to: ' + requestUrl);
            response = yield services_1.ServerConnection.makeRequest(requestUrl, init, settings);
        }
        catch (error) {
            throw new services_1.ServerConnection.NetworkError(error);
        }
        const data = yield response.json();
        if (!response.ok) {
            throw new services_1.ServerConnection.ResponseError(response, data.message);
        }
        return data;
    });
}
exports.requestAPI = requestAPI;


/***/ }),

/***/ "./lib/index.js":
/*!**********************!*\
  !*** ./lib/index.js ***!
  \**********************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.globus = void 0;
const ui_components_1 = __webpack_require__(/*! @jupyterlab/ui-components */ "webpack/sharing/consume/default/@jupyterlab/ui-components");
const application_1 = __webpack_require__(/*! @jupyterlab/application */ "webpack/sharing/consume/default/@jupyterlab/application");
const home_1 = __webpack_require__(/*! ./globus/home */ "./lib/globus/home.js");
const docmanager_1 = __webpack_require__(/*! @jupyterlab/docmanager */ "webpack/sharing/consume/default/@jupyterlab/docmanager");
const filebrowser_1 = __webpack_require__(/*! @jupyterlab/filebrowser */ "webpack/sharing/consume/default/@jupyterlab/filebrowser");
const widget_manager_1 = __webpack_require__(/*! ./globus/widget_manager */ "./lib/globus/widget_manager.js");
const apputils_1 = __webpack_require__(/*! @jupyterlab/apputils */ "webpack/sharing/consume/default/@jupyterlab/apputils");
const coreutils_1 = __webpack_require__(/*! @jupyterlab/coreutils */ "webpack/sharing/consume/default/@jupyterlab/coreutils");
const widget_1 = __webpack_require__(/*! ./widget */ "./lib/widget.js");
const handler_1 = __webpack_require__(/*! ./handler */ "./lib/handler.js");
__webpack_require__(/*! ../style/index.css */ "./style/index.css");
const addJupyterCommands = (app, factory, commands) => {
    for (let command of commands) {
        app.commands.addCommand(command.command, {
            label: command.label,
            caption: command.caption,
            icon: ui_components_1.buildIcon,
            execute: () => __awaiter(void 0, void 0, void 0, function* () {
                var files = factory.tracker.currentWidget.selectedItems();
                var jupyterToken = coreutils_1.PageConfig.getToken();
                var label = 'Globus Jupyterlab Transfer';
                let jupyterItems = [], fileCheck = true;
                while (fileCheck) {
                    let file = files.next();
                    if (file) {
                        jupyterItems.push(file);
                    }
                    else {
                        fileCheck = false;
                    }
                }
                // GET config payload which contains basic auth data
                const config = yield handler_1.requestAPI('config');
                const isAuthenticated = config.is_logged_in;
                // Start creating the widget, but don't attach unless authenticated
                const content = new widget_1.GlobusWidget(config, jupyterToken, jupyterItems);
                const widget = new apputils_1.MainAreaWidget({ content });
                widget.title.label = label;
                widget.title.icon = ui_components_1.reactIcon;
                if (isAuthenticated) {
                    app.shell.add(widget, 'main');
                }
                else {
                    // Poll for successful authentication. 
                    let authInterval = window.setInterval(() => __awaiter(void 0, void 0, void 0, function* () {
                        const config = yield handler_1.requestAPI('config');
                        const isAuthenticated = config.is_logged_in;
                        if (isAuthenticated) {
                            app.shell.add(widget, 'main');
                            clearInterval(authInterval);
                        }
                    }), 500);
                    window.open('/globus-jupyterlab/login', '_blank');
                }
            }),
        });
    }
};
/**
 * Globus plugin
 */
exports.globus = {
    id: '@jupyterlab/globus_jupyterlab',
    autoStart: true,
    requires: [docmanager_1.IDocumentManager, application_1.ILayoutRestorer, filebrowser_1.IFileBrowserFactory],
    activate: activateGlobus
};
function activateGlobus(app, manager, restorer, factory) {
    return __awaiter(this, void 0, void 0, function* () {
        // Writes and executes a command inside of the default terminal in JupyterLab.
        // console.log(app.info);
        // app.serviceManager.terminals.startNew().then(session => {
        //     let request = `http POST ${window.location.href}/static body="$(printenv)" 'Authorization:token ${ServerConnection.defaultSettings.token}'\r`;
        //     session.send({ type: 'stdin', content: [request]});
        // });
        console.log('Globus Jupyterlab Extension Activated!');
        let widgetManager = new widget_manager_1.GlobusWidgetManager(app, manager, factory);
        let home = new home_1.GlobusHome(widgetManager);
        restorer.add(home, 'globus-home');
        app.shell.add(home, 'left');
        console.log('JupyterLab extension server-extension-example is activated!');
        // Ask for permission before starting transfers on startup.
        const i_want_to_start_a_transfer_to_my_local_home_directory = false;
        // GET request
        try {
            const data = yield handler_1.requestAPI('config');
            console.log('Fetching basic data about the notebook server environment:', data);
            const operation_ls = yield handler_1.requestAPI('operation_ls?endpoint=ddb59aef-6d04-11e5-ba46-22000b92c6ec');
            console.log('Info on collection', operation_ls);
            const endpoint_search = yield handler_1.requestAPI('endpoint_search?filter_fulltext=tutorial');
            console.log('Endpoint Search: ', endpoint_search);
            const endpoint_autoactivate = yield handler_1.requestAPI('endpoint_autoactivate', {
                body: JSON.stringify({ 'endpoint_id': 'ddb59aef-6d04-11e5-ba46-22000b92c6ec' }),
                method: 'POST',
            });
            console.log(endpoint_autoactivate);
            const transferRequest = {
                //Globus Tutorial Endpoint 1
                'source_endpoint': 'ddb59aef-6d04-11e5-ba46-22000b92c6ec',
                'destination_endpoint': data.collection_id,
                'transfer_items': [{
                        'source_path': '/share/godata',
                        'destination_path': '~/',
                        'recursive': true,
                    }]
            };
            if (data.is_logged_in && i_want_to_start_a_transfer_to_my_local_home_directory) {
                submitTransfer(transferRequest);
            }
            else if (!data.is_logged_in) {
                console.log('You are not logged in, visit http://localhost:8888/globus-jupyterlab/login to login');
            }
            else if (!i_want_to_start_a_transfer_to_my_local_home_directory) {
                // Consent is important
                console.log('Aborting Transfer to your local home directory! Check index.ts for more info!');
            }
            /*
            Commands to initiate a Globus Transfer.
            */
            let commands = [
                {
                    command: 'globus-jupyterlab-transfer/context-menu:open',
                    label: 'Initiate Globus Transfer',
                    caption: 'Login with Globus to initiate transfers',
                },
            ];
            addJupyterCommands(app, factory, commands);
        }
        catch (reason) {
            console.error(`Error on GET /globus_jupyterlab/config.\n${reason}`);
        }
    });
}
function submitTransfer(transferRequest) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const reply = yield handler_1.requestAPI('submit_transfer', {
                body: JSON.stringify(transferRequest),
                method: 'POST',
            });
            console.log(reply);
        }
        catch (reason) {
            console.error(`Error on POST /jlab-ext-example/hello ${transferRequest}.\n${reason}`);
        }
    });
}
/**
 * Export the plugin as default.
 */
exports["default"] = exports.globus;


/***/ }),

/***/ "./lib/utils.js":
/*!**********************!*\
  !*** ./lib/utils.js ***!
  \**********************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.sortList = exports.convertBytes = exports.isEndpointId = exports.ENDPOINT_ID_REG_EXP = exports.createDescriptionElement = exports.displayError = exports.getGlobusElement = exports.getGlobusParentGroup = exports.queryParams = exports.hideChildren = exports.removeChildren = exports.ERROR_IMAGE = exports.LOADING_LABEL = exports.LOADING_ICON = exports.GLOBUS_ACTIVE = exports.GLOBUS_DISABLED = exports.GLOBUS_SELECTED = exports.GLOBUS_MENU = exports.GLOBUS_MENU_BTN = exports.GLOBUS_DISPLAY_FLEX = exports.GLOBUS_BUTTON = exports.GLOBUS_FAIL = exports.GLOBUS_SUCCESS = exports.GLOBUS_BORDER = exports.GLOBUS_OPEN = exports.GLOBUS_HEADER = exports.GLOBUS_FETCH_ERROR = exports.GLOBUS_LIST_ITEM_SUBTITLE = exports.GLOBUS_LIST_ITEM_TITLE = exports.GLOBUS_LIST_ITEM = exports.GLOBUS_LIST = exports.GLOBUS_DESCRIPTION_DETAILS = exports.GLOBUS_DESCRIPTION_TERM = exports.GLOBUS_INPUT = exports.GLOBUS_PARENT_GROUP = void 0;
const client_1 = __webpack_require__(/*! ./globus/api/client */ "./lib/globus/api/client.js");
const moment_1 = __importDefault(__webpack_require__(/*! moment */ "./node_modules/moment/moment.js"));
const $ = __importStar(__webpack_require__(/*! jquery */ "webpack/sharing/consume/default/jquery/jquery"));
exports.GLOBUS_PARENT_GROUP = 'jp-Globus-group';
exports.GLOBUS_INPUT = 'jp-Globus-input';
exports.GLOBUS_DESCRIPTION_TERM = 'jp-Globus-descriptionTerm';
exports.GLOBUS_DESCRIPTION_DETAILS = 'jp-Globus-descriptionDetails';
exports.GLOBUS_LIST = 'jp-Globus-list';
exports.GLOBUS_LIST_ITEM = 'jp-Globus-listItem';
exports.GLOBUS_LIST_ITEM_TITLE = 'jp-Globus-listItemTitle';
exports.GLOBUS_LIST_ITEM_SUBTITLE = 'jp-Globus-listItemSubtitle';
exports.GLOBUS_FETCH_ERROR = 'jp-Globus-fetchError';
exports.GLOBUS_HEADER = 'jp-Globus-header';
exports.GLOBUS_OPEN = 'jp-Globus-open';
exports.GLOBUS_BORDER = 'jp-Globus-border';
exports.GLOBUS_SUCCESS = 'jp-Globus-success';
exports.GLOBUS_FAIL = 'jp-Globus-fail';
exports.GLOBUS_BUTTON = 'jp-Globus-button';
exports.GLOBUS_DISPLAY_FLEX = 'jp-Globus-displayFlex';
exports.GLOBUS_MENU_BTN = 'jp-Globus-menuBtn';
exports.GLOBUS_MENU = 'jp-Globus-menu';
exports.GLOBUS_SELECTED = 'jp-Globus-selected';
exports.GLOBUS_DISABLED = 'jp-Globus-disabled';
exports.GLOBUS_ACTIVE = 'jp-Globus-active';
exports.LOADING_ICON = document.createElement('div');
exports.LOADING_ICON.className = 'jp-Globus-loader';
exports.LOADING_LABEL = document.createElement('div');
exports.LOADING_LABEL.className = 'jp-Globus-loaderLabel';
exports.ERROR_IMAGE = document.createElement('div');
exports.ERROR_IMAGE.className = 'jp-Globus-errorImage';
/**
 * Removes all children from a node. Not recursive
 * @param {HTMLElement} node
 */
function removeChildren(node) {
    while (node.firstChild) {
        node.removeChild(node.firstChild);
    }
}
exports.removeChildren = removeChildren;
/**
 * Hides all children from a node. Not recursive
 * @param {HTMLElement} node
 */
function hideChildren(node) {
    for (let i = 0; i < node.children.length; i++) {
        node.children[i].style.display = 'none';
    }
}
exports.hideChildren = hideChildren;
/**
 * Takes in an object and encodes it in the form: x-www-form-urlencoded
 * @param params
 * @returns {string}
 */
function queryParams(params) {
    return Object.keys(params)
        .map(k => encodeURIComponent(k) + '=' + encodeURIComponent(params[k]))
        .join('&');
}
exports.queryParams = queryParams;
/**
 * Finds the most immediate Parent Group which is used to organize the HTML elements in subgroups.
 * This Parent Group must contain GLOBUS_PARENT_GROUP in its classlist
 * @param {HTMLElement} element
 * @returns {HTMLElement}
 */
function getGlobusParentGroup(element) {
    if (element.classList.contains(exports.GLOBUS_PARENT_GROUP)) {
        return element;
    }
    else {
        return getGlobusParentGroup(element.parentElement);
    }
}
exports.getGlobusParentGroup = getGlobusParentGroup;
/**
 * Finds an HTML element based on its class name. It's usually paired with getGlobusParentGroup for better organization
 * @param {HTMLElement} group
 * @param {string} className
 * @returns {HTMLElement}
 */
function getGlobusElement(group, className) {
    return group.getElementsByClassName(className)[0];
}
exports.getGlobusElement = getGlobusElement;
/**
 * Displays the passed in error inside of the node
 * @param e
 * @param {HTMLElement} node
 */
function displayError(e, node) {
    console.log(e);
    let errorCode = document.createElement('div');
    errorCode.className = exports.GLOBUS_FETCH_ERROR;
    console.log(e.code);
    let code = client_1.ERROR_CODES[e.code];
    if (code) {
        errorCode.textContent = code;
    }
    else if (e.customMessage) {
        errorCode.textContent = e.customMessage;
    }
    else {
        errorCode.textContent = e.code;
    }
    node.appendChild(errorCode);
}
exports.displayError = displayError;
/**
 * Fills up a <dl> element. This function could be removed with a better refactoring of the code.
 * @param {HTMLDListElement} dList
 * @param {string} term
 * @param details
 */
function createDescriptionElement(dList, term, details) {
    let dt = document.createElement('dt');
    dt.className = `${exports.GLOBUS_DESCRIPTION_TERM}`;
    dt.textContent = term;
    let dd = document.createElement('dd');
    dd.className = `${exports.GLOBUS_DESCRIPTION_DETAILS}`;
    dd.textContent = details;
    dList.appendChild(dt);
    dList.appendChild(dd);
}
exports.createDescriptionElement = createDescriptionElement;
/**
 * Globus Endpoint ID Regex
 * @type {RegExp}
 */
exports.ENDPOINT_ID_REG_EXP = new RegExp('^[a-zA-Z0-9]{8}-[a-zA-Z0-9]{4}-[a-zA-Z0-9]{4}-[a-zA-Z0-9]{4}-[a-zA-Z0-9]{12}');
/**
 * @param {string} query
 * @returns {boolean}
 */
function isEndpointId(query) {
    return exports.ENDPOINT_ID_REG_EXP.test(query);
}
exports.isEndpointId = isEndpointId;
// Adapted from https://math.stackexchange.com/questions/247444/explain-convertion-algorithm-from-bytes-to-kb-mb-gb
/**
 * Returns bytes with the appropriate unit prefix
 * @param {number} size
 * @returns {string}
 */
function convertBytes(size) {
    if (!size) {
        return '0 B';
    }
    let base = Math.log(size) / Math.log(1000);
    let suffix = ['B', 'KB', 'MB', 'GB', 'TB'];
    if (Math.floor(base) > 4) {
        let diff = size.toString().length - 12;
        return `${(Math.pow(1000, base - Math.floor(base)) * Math.pow(10, diff - 1)).toFixed(2)} ${suffix[4]}`;
    }
    return `${Math.round(Math.pow(1000, base - Math.floor(base)) * 100) / 100} ${suffix[Math.floor(base)]}`;
}
exports.convertBytes = convertBytes;
// Adapted from https://www.w3schools.com/howto/howto_js_sort_list.asp
/**
 * Sorts a <ul> based on the parameter sortBy
 * @param {HTMLUListElement} list
 * @param {string | "name" | "date" | "size" | "type"} sortBy
 */
function sortList(list, sortBy) {
    let i, switching, b, shouldSwitch, dir, switchcount = 0;
    switching = true;
    // Set the sorting direction to ascending:
    dir = "asc";
    // Make a loop that will continue until no switching has been done:
    while (switching) {
        // Start by saying: no switching is done:
        switching = false;
        b = list.getElementsByTagName("LI");
        // Loop through all list-items:
        for (i = 0; i < (b.length - 1); i++) {
            // Start by saying there should be no switching:
            shouldSwitch = false;
            /* Check if the next item should switch place with the current item,
            based on the sorting direction (asc or desc): */
            let fileData = $.data(b[i], 'data');
            let fileData2 = $.data(b[i + 1], 'data');
            // If used instead of switch because of the break statements
            if (sortBy === 'name') {
                if (dir === "asc" && fileData.name.toLowerCase() > fileData2.name.toLowerCase()) {
                    /* If next item is alphabetically lower than current item,
                    mark as a switch and break the loop: */
                    shouldSwitch = true;
                    break;
                }
                else if (dir === "desc" && fileData.name.toLowerCase() < fileData2.name.toLowerCase()) {
                    /* If next item is alphabetically higher than current item,
                    mark as a switch and break the loop: */
                    shouldSwitch = true;
                    break;
                }
            }
            else if (sortBy === 'date') {
                if (dir === "asc" && moment_1.default(fileData.last_modified).diff(fileData2.last_modified) < 0) {
                    /* If next item is alphabetically lower than current item,
                    mark as a switch and break the loop: */
                    shouldSwitch = true;
                    break;
                }
                else if (dir === "desc" && moment_1.default(fileData.last_modified).diff(fileData2.last_modified) > 0) {
                    /* If next item is alphabetically higher than current item,
                    mark as a switch and break the loop: */
                    shouldSwitch = true;
                    break;
                }
            }
            else if (sortBy === 'size') {
                if (dir === "asc" && fileData.size > fileData2.size) {
                    /* If next item is alphabetically lower than current item,
                    mark as a switch and break the loop: */
                    shouldSwitch = true;
                    break;
                }
                else if (dir === "desc" && fileData.size < fileData2.size) {
                    /* If next item is alphabetically higher than current item,
                    mark as a switch and break the loop: */
                    shouldSwitch = true;
                    break;
                }
            }
            else if (sortBy === 'type') {
                if (dir === "asc" && fileData.type.toLowerCase() > fileData2.type.toLowerCase()) {
                    /* If next item is alphabetically lower than current item,
                    mark as a switch and break the loop: */
                    shouldSwitch = true;
                    break;
                }
                else if (dir === "desc" && fileData.type.toLowerCase() < fileData2.type.toLowerCase()) {
                    /* If next item is alphabetically higher than current item,
                    mark as a switch and break the loop: */
                    shouldSwitch = true;
                    break;
                }
            }
        }
        if (shouldSwitch) {
            /* If a switch has been marked, make the switch
            and mark that a switch has been done: */
            b[i].parentNode.insertBefore(b[i + 1], b[i]);
            switching = true;
            // Each time a switch is done, increase switchcount by 1:
            switchcount++;
        }
        else {
            /* If no switching has been done AND the direction is "asc",
            set the direction to "desc" and run the while loop again. */
            if (!switchcount && dir === "asc") {
                dir = "desc";
                switching = true;
            }
        }
    }
}
exports.sortList = sortList;


/***/ }),

/***/ "./lib/widget.js":
/*!***********************!*\
  !*** ./lib/widget.js ***!
  \***********************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.GlobusWidget = void 0;
const react_router_dom_1 = __webpack_require__(/*! react-router-dom */ "webpack/sharing/consume/default/react-router-dom/react-router-dom");
const apputils_1 = __webpack_require__(/*! @jupyterlab/apputils */ "webpack/sharing/consume/default/@jupyterlab/apputils");
const react_1 = __importStar(__webpack_require__(/*! react */ "webpack/sharing/consume/default/react"));
const recoil_1 = __webpack_require__(/*! recoil */ "webpack/sharing/consume/default/recoil/recoil");
const EndpointSearch_1 = __importDefault(__webpack_require__(/*! ./components/EndpointSearch */ "./lib/components/EndpointSearch.js"));
const GlobusObjects_1 = __webpack_require__(/*! ./components/GlobusObjects */ "./lib/components/GlobusObjects.js");
__webpack_require__(/*! @fortawesome/fontawesome-free/css/all.min.css */ "./node_modules/@fortawesome/fontawesome-free/css/all.min.css");
__webpack_require__(/*! bootstrap/dist/css/bootstrap.min.css */ "./node_modules/bootstrap/dist/css/bootstrap.min.css");
const App = (props) => {
    // Local state values
    const [selectedJupyterItems, setSelectedJupyterItems] = react_1.useState({ isEmpty: true });
    // Global Recoil state values
    const setConfig = recoil_1.useSetRecoilState(GlobusObjects_1.ConfigAtom);
    react_1.useEffect(() => {
        setConfig(props.config);
    }, [props.config]);
    react_1.useEffect(() => {
        getJupyterItems();
    }, [props.jupyterItems]);
    const getJupyterItems = () => __awaiter(void 0, void 0, void 0, function* () {
        let directories = [];
        let files = [];
        let selectedJupyterItemsTemp = {};
        for (let file of props.jupyterItems) {
            try {
                let response = yield fetch(`/api/contents/${file.path}`, {
                    headers: {
                        Accept: 'application/json',
                        Authorization: `token ${props.jupyterToken}`,
                        'Content-Type': 'application/json',
                    },
                });
                let temp = yield response.json();
                if (temp.type == 'directory') {
                    directories.push(temp);
                }
                else {
                    files.push(temp);
                }
            }
            catch (error) {
                console.log(error);
            }
        }
        selectedJupyterItemsTemp['directories'] = directories;
        selectedJupyterItemsTemp['files'] = files;
        // If we have any file or folder, the payload is not empty
        if (directories.length || files.length) {
            selectedJupyterItemsTemp['isEmpty'] = false;
        }
        // Transfer direction inferred from selected files/folders
        if ((files.length && directories.length) || (files.length && !directories.length)) {
            selectedJupyterItemsTemp['transferDirection'] = 'toEndpoint';
        }
        else {
            selectedJupyterItemsTemp['transferDirection'] = 'toFromEndpoint';
        }
        //@ts-ignore
        setSelectedJupyterItems(selectedJupyterItemsTemp);
    });
    return (react_1.default.createElement("div", { className: 'container pt-5' }, !selectedJupyterItems['isEmpty'] ? (react_1.default.createElement(EndpointSearch_1.default, { selectedJupyterItems: selectedJupyterItems })) : (react_1.default.createElement("p", { className: 'fw-bold text-danger' }, "No files selected"))));
};
class GlobusWidget extends apputils_1.ReactWidget {
    constructor(config = {}, jupyterToken = '', jupyterItems = []) {
        super();
        this.config = config;
        this.jupyterItems = jupyterItems;
        this.jupyterToken = jupyterToken;
        this.addClass('jp-ReactWidget');
    }
    render() {
        return (react_1.default.createElement(react_router_dom_1.HashRouter, null,
            react_1.default.createElement(recoil_1.RecoilRoot, null,
                react_1.default.createElement(react_router_dom_1.Switch, null,
                    react_1.default.createElement(react_router_dom_1.Route, { path: '/', render: (props) => {
                            return (react_1.default.createElement(App, Object.assign({}, props, { config: this.config, jupyterItems: this.jupyterItems, jupyterToken: this.jupyterToken })));
                        } })))));
    }
}
exports.GlobusWidget = GlobusWidget;


/***/ }),

/***/ "./node_modules/moment/locale sync recursive ^\\.\\/.*$":
/*!***************************************************!*\
  !*** ./node_modules/moment/locale/ sync ^\.\/.*$ ***!
  \***************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var map = {
	"./af": "./node_modules/moment/locale/af.js",
	"./af.js": "./node_modules/moment/locale/af.js",
	"./ar": "./node_modules/moment/locale/ar.js",
	"./ar-dz": "./node_modules/moment/locale/ar-dz.js",
	"./ar-dz.js": "./node_modules/moment/locale/ar-dz.js",
	"./ar-kw": "./node_modules/moment/locale/ar-kw.js",
	"./ar-kw.js": "./node_modules/moment/locale/ar-kw.js",
	"./ar-ly": "./node_modules/moment/locale/ar-ly.js",
	"./ar-ly.js": "./node_modules/moment/locale/ar-ly.js",
	"./ar-ma": "./node_modules/moment/locale/ar-ma.js",
	"./ar-ma.js": "./node_modules/moment/locale/ar-ma.js",
	"./ar-sa": "./node_modules/moment/locale/ar-sa.js",
	"./ar-sa.js": "./node_modules/moment/locale/ar-sa.js",
	"./ar-tn": "./node_modules/moment/locale/ar-tn.js",
	"./ar-tn.js": "./node_modules/moment/locale/ar-tn.js",
	"./ar.js": "./node_modules/moment/locale/ar.js",
	"./az": "./node_modules/moment/locale/az.js",
	"./az.js": "./node_modules/moment/locale/az.js",
	"./be": "./node_modules/moment/locale/be.js",
	"./be.js": "./node_modules/moment/locale/be.js",
	"./bg": "./node_modules/moment/locale/bg.js",
	"./bg.js": "./node_modules/moment/locale/bg.js",
	"./bm": "./node_modules/moment/locale/bm.js",
	"./bm.js": "./node_modules/moment/locale/bm.js",
	"./bn": "./node_modules/moment/locale/bn.js",
	"./bn-bd": "./node_modules/moment/locale/bn-bd.js",
	"./bn-bd.js": "./node_modules/moment/locale/bn-bd.js",
	"./bn.js": "./node_modules/moment/locale/bn.js",
	"./bo": "./node_modules/moment/locale/bo.js",
	"./bo.js": "./node_modules/moment/locale/bo.js",
	"./br": "./node_modules/moment/locale/br.js",
	"./br.js": "./node_modules/moment/locale/br.js",
	"./bs": "./node_modules/moment/locale/bs.js",
	"./bs.js": "./node_modules/moment/locale/bs.js",
	"./ca": "./node_modules/moment/locale/ca.js",
	"./ca.js": "./node_modules/moment/locale/ca.js",
	"./cs": "./node_modules/moment/locale/cs.js",
	"./cs.js": "./node_modules/moment/locale/cs.js",
	"./cv": "./node_modules/moment/locale/cv.js",
	"./cv.js": "./node_modules/moment/locale/cv.js",
	"./cy": "./node_modules/moment/locale/cy.js",
	"./cy.js": "./node_modules/moment/locale/cy.js",
	"./da": "./node_modules/moment/locale/da.js",
	"./da.js": "./node_modules/moment/locale/da.js",
	"./de": "./node_modules/moment/locale/de.js",
	"./de-at": "./node_modules/moment/locale/de-at.js",
	"./de-at.js": "./node_modules/moment/locale/de-at.js",
	"./de-ch": "./node_modules/moment/locale/de-ch.js",
	"./de-ch.js": "./node_modules/moment/locale/de-ch.js",
	"./de.js": "./node_modules/moment/locale/de.js",
	"./dv": "./node_modules/moment/locale/dv.js",
	"./dv.js": "./node_modules/moment/locale/dv.js",
	"./el": "./node_modules/moment/locale/el.js",
	"./el.js": "./node_modules/moment/locale/el.js",
	"./en-au": "./node_modules/moment/locale/en-au.js",
	"./en-au.js": "./node_modules/moment/locale/en-au.js",
	"./en-ca": "./node_modules/moment/locale/en-ca.js",
	"./en-ca.js": "./node_modules/moment/locale/en-ca.js",
	"./en-gb": "./node_modules/moment/locale/en-gb.js",
	"./en-gb.js": "./node_modules/moment/locale/en-gb.js",
	"./en-ie": "./node_modules/moment/locale/en-ie.js",
	"./en-ie.js": "./node_modules/moment/locale/en-ie.js",
	"./en-il": "./node_modules/moment/locale/en-il.js",
	"./en-il.js": "./node_modules/moment/locale/en-il.js",
	"./en-in": "./node_modules/moment/locale/en-in.js",
	"./en-in.js": "./node_modules/moment/locale/en-in.js",
	"./en-nz": "./node_modules/moment/locale/en-nz.js",
	"./en-nz.js": "./node_modules/moment/locale/en-nz.js",
	"./en-sg": "./node_modules/moment/locale/en-sg.js",
	"./en-sg.js": "./node_modules/moment/locale/en-sg.js",
	"./eo": "./node_modules/moment/locale/eo.js",
	"./eo.js": "./node_modules/moment/locale/eo.js",
	"./es": "./node_modules/moment/locale/es.js",
	"./es-do": "./node_modules/moment/locale/es-do.js",
	"./es-do.js": "./node_modules/moment/locale/es-do.js",
	"./es-mx": "./node_modules/moment/locale/es-mx.js",
	"./es-mx.js": "./node_modules/moment/locale/es-mx.js",
	"./es-us": "./node_modules/moment/locale/es-us.js",
	"./es-us.js": "./node_modules/moment/locale/es-us.js",
	"./es.js": "./node_modules/moment/locale/es.js",
	"./et": "./node_modules/moment/locale/et.js",
	"./et.js": "./node_modules/moment/locale/et.js",
	"./eu": "./node_modules/moment/locale/eu.js",
	"./eu.js": "./node_modules/moment/locale/eu.js",
	"./fa": "./node_modules/moment/locale/fa.js",
	"./fa.js": "./node_modules/moment/locale/fa.js",
	"./fi": "./node_modules/moment/locale/fi.js",
	"./fi.js": "./node_modules/moment/locale/fi.js",
	"./fil": "./node_modules/moment/locale/fil.js",
	"./fil.js": "./node_modules/moment/locale/fil.js",
	"./fo": "./node_modules/moment/locale/fo.js",
	"./fo.js": "./node_modules/moment/locale/fo.js",
	"./fr": "./node_modules/moment/locale/fr.js",
	"./fr-ca": "./node_modules/moment/locale/fr-ca.js",
	"./fr-ca.js": "./node_modules/moment/locale/fr-ca.js",
	"./fr-ch": "./node_modules/moment/locale/fr-ch.js",
	"./fr-ch.js": "./node_modules/moment/locale/fr-ch.js",
	"./fr.js": "./node_modules/moment/locale/fr.js",
	"./fy": "./node_modules/moment/locale/fy.js",
	"./fy.js": "./node_modules/moment/locale/fy.js",
	"./ga": "./node_modules/moment/locale/ga.js",
	"./ga.js": "./node_modules/moment/locale/ga.js",
	"./gd": "./node_modules/moment/locale/gd.js",
	"./gd.js": "./node_modules/moment/locale/gd.js",
	"./gl": "./node_modules/moment/locale/gl.js",
	"./gl.js": "./node_modules/moment/locale/gl.js",
	"./gom-deva": "./node_modules/moment/locale/gom-deva.js",
	"./gom-deva.js": "./node_modules/moment/locale/gom-deva.js",
	"./gom-latn": "./node_modules/moment/locale/gom-latn.js",
	"./gom-latn.js": "./node_modules/moment/locale/gom-latn.js",
	"./gu": "./node_modules/moment/locale/gu.js",
	"./gu.js": "./node_modules/moment/locale/gu.js",
	"./he": "./node_modules/moment/locale/he.js",
	"./he.js": "./node_modules/moment/locale/he.js",
	"./hi": "./node_modules/moment/locale/hi.js",
	"./hi.js": "./node_modules/moment/locale/hi.js",
	"./hr": "./node_modules/moment/locale/hr.js",
	"./hr.js": "./node_modules/moment/locale/hr.js",
	"./hu": "./node_modules/moment/locale/hu.js",
	"./hu.js": "./node_modules/moment/locale/hu.js",
	"./hy-am": "./node_modules/moment/locale/hy-am.js",
	"./hy-am.js": "./node_modules/moment/locale/hy-am.js",
	"./id": "./node_modules/moment/locale/id.js",
	"./id.js": "./node_modules/moment/locale/id.js",
	"./is": "./node_modules/moment/locale/is.js",
	"./is.js": "./node_modules/moment/locale/is.js",
	"./it": "./node_modules/moment/locale/it.js",
	"./it-ch": "./node_modules/moment/locale/it-ch.js",
	"./it-ch.js": "./node_modules/moment/locale/it-ch.js",
	"./it.js": "./node_modules/moment/locale/it.js",
	"./ja": "./node_modules/moment/locale/ja.js",
	"./ja.js": "./node_modules/moment/locale/ja.js",
	"./jv": "./node_modules/moment/locale/jv.js",
	"./jv.js": "./node_modules/moment/locale/jv.js",
	"./ka": "./node_modules/moment/locale/ka.js",
	"./ka.js": "./node_modules/moment/locale/ka.js",
	"./kk": "./node_modules/moment/locale/kk.js",
	"./kk.js": "./node_modules/moment/locale/kk.js",
	"./km": "./node_modules/moment/locale/km.js",
	"./km.js": "./node_modules/moment/locale/km.js",
	"./kn": "./node_modules/moment/locale/kn.js",
	"./kn.js": "./node_modules/moment/locale/kn.js",
	"./ko": "./node_modules/moment/locale/ko.js",
	"./ko.js": "./node_modules/moment/locale/ko.js",
	"./ku": "./node_modules/moment/locale/ku.js",
	"./ku.js": "./node_modules/moment/locale/ku.js",
	"./ky": "./node_modules/moment/locale/ky.js",
	"./ky.js": "./node_modules/moment/locale/ky.js",
	"./lb": "./node_modules/moment/locale/lb.js",
	"./lb.js": "./node_modules/moment/locale/lb.js",
	"./lo": "./node_modules/moment/locale/lo.js",
	"./lo.js": "./node_modules/moment/locale/lo.js",
	"./lt": "./node_modules/moment/locale/lt.js",
	"./lt.js": "./node_modules/moment/locale/lt.js",
	"./lv": "./node_modules/moment/locale/lv.js",
	"./lv.js": "./node_modules/moment/locale/lv.js",
	"./me": "./node_modules/moment/locale/me.js",
	"./me.js": "./node_modules/moment/locale/me.js",
	"./mi": "./node_modules/moment/locale/mi.js",
	"./mi.js": "./node_modules/moment/locale/mi.js",
	"./mk": "./node_modules/moment/locale/mk.js",
	"./mk.js": "./node_modules/moment/locale/mk.js",
	"./ml": "./node_modules/moment/locale/ml.js",
	"./ml.js": "./node_modules/moment/locale/ml.js",
	"./mn": "./node_modules/moment/locale/mn.js",
	"./mn.js": "./node_modules/moment/locale/mn.js",
	"./mr": "./node_modules/moment/locale/mr.js",
	"./mr.js": "./node_modules/moment/locale/mr.js",
	"./ms": "./node_modules/moment/locale/ms.js",
	"./ms-my": "./node_modules/moment/locale/ms-my.js",
	"./ms-my.js": "./node_modules/moment/locale/ms-my.js",
	"./ms.js": "./node_modules/moment/locale/ms.js",
	"./mt": "./node_modules/moment/locale/mt.js",
	"./mt.js": "./node_modules/moment/locale/mt.js",
	"./my": "./node_modules/moment/locale/my.js",
	"./my.js": "./node_modules/moment/locale/my.js",
	"./nb": "./node_modules/moment/locale/nb.js",
	"./nb.js": "./node_modules/moment/locale/nb.js",
	"./ne": "./node_modules/moment/locale/ne.js",
	"./ne.js": "./node_modules/moment/locale/ne.js",
	"./nl": "./node_modules/moment/locale/nl.js",
	"./nl-be": "./node_modules/moment/locale/nl-be.js",
	"./nl-be.js": "./node_modules/moment/locale/nl-be.js",
	"./nl.js": "./node_modules/moment/locale/nl.js",
	"./nn": "./node_modules/moment/locale/nn.js",
	"./nn.js": "./node_modules/moment/locale/nn.js",
	"./oc-lnc": "./node_modules/moment/locale/oc-lnc.js",
	"./oc-lnc.js": "./node_modules/moment/locale/oc-lnc.js",
	"./pa-in": "./node_modules/moment/locale/pa-in.js",
	"./pa-in.js": "./node_modules/moment/locale/pa-in.js",
	"./pl": "./node_modules/moment/locale/pl.js",
	"./pl.js": "./node_modules/moment/locale/pl.js",
	"./pt": "./node_modules/moment/locale/pt.js",
	"./pt-br": "./node_modules/moment/locale/pt-br.js",
	"./pt-br.js": "./node_modules/moment/locale/pt-br.js",
	"./pt.js": "./node_modules/moment/locale/pt.js",
	"./ro": "./node_modules/moment/locale/ro.js",
	"./ro.js": "./node_modules/moment/locale/ro.js",
	"./ru": "./node_modules/moment/locale/ru.js",
	"./ru.js": "./node_modules/moment/locale/ru.js",
	"./sd": "./node_modules/moment/locale/sd.js",
	"./sd.js": "./node_modules/moment/locale/sd.js",
	"./se": "./node_modules/moment/locale/se.js",
	"./se.js": "./node_modules/moment/locale/se.js",
	"./si": "./node_modules/moment/locale/si.js",
	"./si.js": "./node_modules/moment/locale/si.js",
	"./sk": "./node_modules/moment/locale/sk.js",
	"./sk.js": "./node_modules/moment/locale/sk.js",
	"./sl": "./node_modules/moment/locale/sl.js",
	"./sl.js": "./node_modules/moment/locale/sl.js",
	"./sq": "./node_modules/moment/locale/sq.js",
	"./sq.js": "./node_modules/moment/locale/sq.js",
	"./sr": "./node_modules/moment/locale/sr.js",
	"./sr-cyrl": "./node_modules/moment/locale/sr-cyrl.js",
	"./sr-cyrl.js": "./node_modules/moment/locale/sr-cyrl.js",
	"./sr.js": "./node_modules/moment/locale/sr.js",
	"./ss": "./node_modules/moment/locale/ss.js",
	"./ss.js": "./node_modules/moment/locale/ss.js",
	"./sv": "./node_modules/moment/locale/sv.js",
	"./sv.js": "./node_modules/moment/locale/sv.js",
	"./sw": "./node_modules/moment/locale/sw.js",
	"./sw.js": "./node_modules/moment/locale/sw.js",
	"./ta": "./node_modules/moment/locale/ta.js",
	"./ta.js": "./node_modules/moment/locale/ta.js",
	"./te": "./node_modules/moment/locale/te.js",
	"./te.js": "./node_modules/moment/locale/te.js",
	"./tet": "./node_modules/moment/locale/tet.js",
	"./tet.js": "./node_modules/moment/locale/tet.js",
	"./tg": "./node_modules/moment/locale/tg.js",
	"./tg.js": "./node_modules/moment/locale/tg.js",
	"./th": "./node_modules/moment/locale/th.js",
	"./th.js": "./node_modules/moment/locale/th.js",
	"./tk": "./node_modules/moment/locale/tk.js",
	"./tk.js": "./node_modules/moment/locale/tk.js",
	"./tl-ph": "./node_modules/moment/locale/tl-ph.js",
	"./tl-ph.js": "./node_modules/moment/locale/tl-ph.js",
	"./tlh": "./node_modules/moment/locale/tlh.js",
	"./tlh.js": "./node_modules/moment/locale/tlh.js",
	"./tr": "./node_modules/moment/locale/tr.js",
	"./tr.js": "./node_modules/moment/locale/tr.js",
	"./tzl": "./node_modules/moment/locale/tzl.js",
	"./tzl.js": "./node_modules/moment/locale/tzl.js",
	"./tzm": "./node_modules/moment/locale/tzm.js",
	"./tzm-latn": "./node_modules/moment/locale/tzm-latn.js",
	"./tzm-latn.js": "./node_modules/moment/locale/tzm-latn.js",
	"./tzm.js": "./node_modules/moment/locale/tzm.js",
	"./ug-cn": "./node_modules/moment/locale/ug-cn.js",
	"./ug-cn.js": "./node_modules/moment/locale/ug-cn.js",
	"./uk": "./node_modules/moment/locale/uk.js",
	"./uk.js": "./node_modules/moment/locale/uk.js",
	"./ur": "./node_modules/moment/locale/ur.js",
	"./ur.js": "./node_modules/moment/locale/ur.js",
	"./uz": "./node_modules/moment/locale/uz.js",
	"./uz-latn": "./node_modules/moment/locale/uz-latn.js",
	"./uz-latn.js": "./node_modules/moment/locale/uz-latn.js",
	"./uz.js": "./node_modules/moment/locale/uz.js",
	"./vi": "./node_modules/moment/locale/vi.js",
	"./vi.js": "./node_modules/moment/locale/vi.js",
	"./x-pseudo": "./node_modules/moment/locale/x-pseudo.js",
	"./x-pseudo.js": "./node_modules/moment/locale/x-pseudo.js",
	"./yo": "./node_modules/moment/locale/yo.js",
	"./yo.js": "./node_modules/moment/locale/yo.js",
	"./zh-cn": "./node_modules/moment/locale/zh-cn.js",
	"./zh-cn.js": "./node_modules/moment/locale/zh-cn.js",
	"./zh-hk": "./node_modules/moment/locale/zh-hk.js",
	"./zh-hk.js": "./node_modules/moment/locale/zh-hk.js",
	"./zh-mo": "./node_modules/moment/locale/zh-mo.js",
	"./zh-mo.js": "./node_modules/moment/locale/zh-mo.js",
	"./zh-tw": "./node_modules/moment/locale/zh-tw.js",
	"./zh-tw.js": "./node_modules/moment/locale/zh-tw.js"
};


function webpackContext(req) {
	var id = webpackContextResolve(req);
	return __webpack_require__(id);
}
function webpackContextResolve(req) {
	if(!__webpack_require__.o(map, req)) {
		var e = new Error("Cannot find module '" + req + "'");
		e.code = 'MODULE_NOT_FOUND';
		throw e;
	}
	return map[req];
}
webpackContext.keys = function webpackContextKeys() {
	return Object.keys(map);
};
webpackContext.resolve = webpackContextResolve;
module.exports = webpackContext;
webpackContext.id = "./node_modules/moment/locale sync recursive ^\\.\\/.*$";

/***/ })

}]);
//# sourceMappingURL=lib_index_js-node_modules_moment_locale_sync_recursive_.e4d76fc57a4f6ba5bb3c.js.map