# coding: utf-8

"""
    MONEI API v1

    The MONEI API is organized around [REST](https://en.wikipedia.org/wiki/Representational_State_Transfer). Our API has predictable resource-oriented URLs, accepts JSON-encoded request bodies, returns JSON-encoded responses, and uses standard HTTP response codes, authentication, and verbs.  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from Monei.configuration import Configuration


class RecurringPaymentRequest(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'order_id': 'str',
        'amount': 'int',
        'transaction_type': 'PaymentTransactionType',
        'description': 'str',
        'customer': 'PaymentCustomer',
        'billing_details': 'PaymentBillingDetails',
        'shipping_details': 'PaymentShippingDetails',
        'callback_url': 'str'
    }

    attribute_map = {
        'order_id': 'orderId',
        'amount': 'amount',
        'transaction_type': 'transactionType',
        'description': 'description',
        'customer': 'customer',
        'billing_details': 'billingDetails',
        'shipping_details': 'shippingDetails',
        'callback_url': 'callbackUrl'
    }

    def __init__(self, order_id=None, amount=None, transaction_type=None, description=None, customer=None, billing_details=None, shipping_details=None, callback_url=None, local_vars_configuration=None):  # noqa: E501
        """RecurringPaymentRequest - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._order_id = None
        self._amount = None
        self._transaction_type = None
        self._description = None
        self._customer = None
        self._billing_details = None
        self._shipping_details = None
        self._callback_url = None
        self.discriminator = None

        self.order_id = order_id
        if amount is not None:
            self.amount = amount
        if transaction_type is not None:
            self.transaction_type = transaction_type
        if description is not None:
            self.description = description
        if customer is not None:
            self.customer = customer
        if billing_details is not None:
            self.billing_details = billing_details
        if shipping_details is not None:
            self.shipping_details = shipping_details
        if callback_url is not None:
            self.callback_url = callback_url

    @property
    def order_id(self):
        """Gets the order_id of this RecurringPaymentRequest.  # noqa: E501

        An order ID from your system. A unique identifier that can be used to reconcile the payment with your internal system.  # noqa: E501

        :return: The order_id of this RecurringPaymentRequest.  # noqa: E501
        :rtype: str
        """
        return self._order_id

    @order_id.setter
    def order_id(self, order_id):
        """Sets the order_id of this RecurringPaymentRequest.

        An order ID from your system. A unique identifier that can be used to reconcile the payment with your internal system.  # noqa: E501

        :param order_id: The order_id of this RecurringPaymentRequest.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and order_id is None:  # noqa: E501
            raise ValueError("Invalid value for `order_id`, must not be `None`")  # noqa: E501

        self._order_id = order_id

    @property
    def amount(self):
        """Gets the amount of this RecurringPaymentRequest.  # noqa: E501

        The amount to collected by this subsequent payment. A positive integer representing how much to charge in the smallest currency unit (e.g., 100 cents to charge 1.00 USD).  # noqa: E501

        :return: The amount of this RecurringPaymentRequest.  # noqa: E501
        :rtype: int
        """
        return self._amount

    @amount.setter
    def amount(self, amount):
        """Sets the amount of this RecurringPaymentRequest.

        The amount to collected by this subsequent payment. A positive integer representing how much to charge in the smallest currency unit (e.g., 100 cents to charge 1.00 USD).  # noqa: E501

        :param amount: The amount of this RecurringPaymentRequest.  # noqa: E501
        :type: int
        """

        self._amount = amount

    @property
    def transaction_type(self):
        """Gets the transaction_type of this RecurringPaymentRequest.  # noqa: E501

        Same as the `transactionType` parameter from [create payment](https://docs.monei.net/api/#operation/payments_create). If not sent, it will default in the same transaction type used in the initial payment.  # noqa: E501

        :return: The transaction_type of this RecurringPaymentRequest.  # noqa: E501
        :rtype: PaymentTransactionType
        """
        return self._transaction_type

    @transaction_type.setter
    def transaction_type(self, transaction_type):
        """Sets the transaction_type of this RecurringPaymentRequest.

        Same as the `transactionType` parameter from [create payment](https://docs.monei.net/api/#operation/payments_create). If not sent, it will default in the same transaction type used in the initial payment.  # noqa: E501

        :param transaction_type: The transaction_type of this RecurringPaymentRequest.  # noqa: E501
        :type: PaymentTransactionType
        """

        self._transaction_type = transaction_type

    @property
    def description(self):
        """Gets the description of this RecurringPaymentRequest.  # noqa: E501

        An arbitrary string attached to the payment. Often useful for displaying to users.  # noqa: E501

        :return: The description of this RecurringPaymentRequest.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this RecurringPaymentRequest.

        An arbitrary string attached to the payment. Often useful for displaying to users.  # noqa: E501

        :param description: The description of this RecurringPaymentRequest.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def customer(self):
        """Gets the customer of this RecurringPaymentRequest.  # noqa: E501


        :return: The customer of this RecurringPaymentRequest.  # noqa: E501
        :rtype: PaymentCustomer
        """
        return self._customer

    @customer.setter
    def customer(self, customer):
        """Sets the customer of this RecurringPaymentRequest.


        :param customer: The customer of this RecurringPaymentRequest.  # noqa: E501
        :type: PaymentCustomer
        """

        self._customer = customer

    @property
    def billing_details(self):
        """Gets the billing_details of this RecurringPaymentRequest.  # noqa: E501


        :return: The billing_details of this RecurringPaymentRequest.  # noqa: E501
        :rtype: PaymentBillingDetails
        """
        return self._billing_details

    @billing_details.setter
    def billing_details(self, billing_details):
        """Sets the billing_details of this RecurringPaymentRequest.


        :param billing_details: The billing_details of this RecurringPaymentRequest.  # noqa: E501
        :type: PaymentBillingDetails
        """

        self._billing_details = billing_details

    @property
    def shipping_details(self):
        """Gets the shipping_details of this RecurringPaymentRequest.  # noqa: E501


        :return: The shipping_details of this RecurringPaymentRequest.  # noqa: E501
        :rtype: PaymentShippingDetails
        """
        return self._shipping_details

    @shipping_details.setter
    def shipping_details(self, shipping_details):
        """Sets the shipping_details of this RecurringPaymentRequest.


        :param shipping_details: The shipping_details of this RecurringPaymentRequest.  # noqa: E501
        :type: PaymentShippingDetails
        """

        self._shipping_details = shipping_details

    @property
    def callback_url(self):
        """Gets the callback_url of this RecurringPaymentRequest.  # noqa: E501

        The URL to which a payment result should be sent asynchronously.  # noqa: E501

        :return: The callback_url of this RecurringPaymentRequest.  # noqa: E501
        :rtype: str
        """
        return self._callback_url

    @callback_url.setter
    def callback_url(self, callback_url):
        """Sets the callback_url of this RecurringPaymentRequest.

        The URL to which a payment result should be sent asynchronously.  # noqa: E501

        :param callback_url: The callback_url of this RecurringPaymentRequest.  # noqa: E501
        :type: str
        """

        self._callback_url = callback_url

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RecurringPaymentRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, RecurringPaymentRequest):
            return True

        return self.to_dict() != other.to_dict()
