# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/00_core.ipynb.

# %% auto 0
__all__ = ['AutoFormattedReversedTB', 'reverse_tb_on', 'reverse_tb_off', 'reverse_traceback_ctx', 'reverse_tb']

# %% ../nbs/00_core.ipynb 4
from contextlib import contextmanager
from typing import Optional

from fastcore.all import *
from IPython.core.magic import register_cell_magic
from IPython.core import ultratb

# %% ../nbs/00_core.ipynb 5
class AutoFormattedReversedTB(ultratb.AutoFormattedTB):
    """A Traceback printer that reverse the order of the traceback, so that the most recent call is first."""
    def structured_traceback(self, etype, value, tb, tb_offset=None, context=5):
        tb_list = super().structured_traceback(etype, value, tb, tb_offset, context)
        reversed_tb_list = []
        keep_in_place = ['During handling of the above exception, another exception occurred:',
                         'Traceback (most recent call last)',
                         '----------']
        inds = [tb_list.index(x) for x in tb_list if any([o in x for o in keep_in_place])]
        inds.append(len(tb_list))
        for ind0, ind1 in zip(inds[:-1], inds[1:]):
            reversed_tb_list.append(tb_list[ind0])
            reversed_tb_list.extend(tb_list[ind1-1:ind0:-1])
        reversed_tb_list= [x.replace('most recent call last', 'last call first') for x in reversed_tb_list]
        return reversed_tb_list

# %% ../nbs/00_core.ipynb 7
def reverse_tb_on():
    get_ipython().InteractiveTB = AutoFormattedReversedTB(mode='Verbose', color_scheme='Neutral', tb_offset=1)
def reverse_tb_off(): 
    get_ipython().InteractiveTB = ultratb.AutoFormattedTB(mode='Verbose', color_scheme='Neutral', tb_offset=1)

# %% ../nbs/00_core.ipynb 9
@contextmanager
def reverse_traceback_ctx():
    try:
        reverse_tb_on()
        yield
    finally:
        reverse_tb_off()

# %% ../nbs/00_core.ipynb 10
@register_cell_magic
def reverse_tb(line, cell):
    """A cell magic that reverses only the frames of the traceback of an error."""
    with reverse_traceback_ctx():
        result = get_ipython().run_cell(cell)
