"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TopicRule = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const iot_generated_1 = require("./iot.generated");
/**
 * Defines an AWS IoT Rule in this stack.
 */
class TopicRule extends core_1.Resource {
    constructor(scope, id, props) {
        var _b, _c;
        super(scope, id, {
            physicalName: props.topicRuleName,
        });
        this.actions = [];
        jsiiDeprecationWarnings._aws_cdk_aws_iot_TopicRuleProps(props);
        const sqlConfig = props.sql.bind(this);
        const resource = new iot_generated_1.CfnTopicRule(this, 'Resource', {
            ruleName: this.physicalName,
            topicRulePayload: {
                actions: core_1.Lazy.any({ produce: () => this.actions }),
                awsIotSqlVersion: sqlConfig.awsIotSqlVersion,
                description: props.description,
                errorAction: (_b = props.errorAction) === null || _b === void 0 ? void 0 : _b.bind(this).configuration,
                ruleDisabled: props.enabled === undefined ? undefined : !props.enabled,
                sql: sqlConfig.sql,
            },
        });
        this.topicRuleArn = this.getResourceArnAttribute(resource.attrArn, {
            service: 'iot',
            resource: 'rule',
            resourceName: this.physicalName,
        });
        this.topicRuleName = this.getResourceNameAttribute(resource.ref);
        (_c = props.actions) === null || _c === void 0 ? void 0 : _c.forEach(action => {
            this.addAction(action);
        });
    }
    /**
     * Import an existing AWS IoT Rule provided an ARN
     *
     * @param scope The parent creating construct (usually `this`).
     * @param id The construct's name.
     * @param topicRuleArn AWS IoT Rule ARN (i.e. arn:aws:iot:<region>:<account-id>:rule/MyRule).
     */
    static fromTopicRuleArn(scope, id, topicRuleArn) {
        const parts = core_1.Stack.of(scope).splitArn(topicRuleArn, core_1.ArnFormat.SLASH_RESOURCE_NAME);
        if (!parts.resourceName) {
            throw new Error(`Missing topic rule name in ARN: '${topicRuleArn}'`);
        }
        const resourceName = parts.resourceName;
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.topicRuleArn = topicRuleArn;
                this.topicRuleName = resourceName;
            }
        }
        return new Import(scope, id, {
            environmentFromArn: topicRuleArn,
        });
    }
    /**
     * Add a action to the topic rule.
     *
     * @param action the action to associate with the topic rule.
     */
    addAction(action) {
        jsiiDeprecationWarnings._aws_cdk_aws_iot_IAction(action);
        const { configuration } = action.bind(this);
        const keys = Object.keys(configuration);
        if (keys.length === 0) {
            throw new Error('An action property cannot be an empty object.');
        }
        if (keys.length > 1) {
            throw new Error(`An action property cannot have multiple keys, received: ${keys}`);
        }
        this.actions.push(configuration);
    }
}
exports.TopicRule = TopicRule;
_a = JSII_RTTI_SYMBOL_1;
TopicRule[_a] = { fqn: "@aws-cdk/aws-iot.TopicRule", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,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