from datetime import date
from openpyxl.styles.cell_style import StyleArray
from openpyxl.worksheet._write_only import WriteOnlyWorksheet
from openpyxl.worksheet.worksheet import Worksheet
from typing import (
    Any,
    Optional,
    Union,
)

def WriteOnlyCell(
    ws: Optional[WriteOnlyWorksheet] = ..., value: Optional[Union[str, int]] = ...
) -> Cell: ...
def get_time_format(t: Any) -> Optional[str]: ...
def get_type(t: Any, value: Any) -> Optional[str]: ...

class Cell:
    def __init__(
        self,
        worksheet: Optional[Union[Worksheet, WriteOnlyWorksheet]],
        row: Optional[Union[str, int]] = ...,
        column: Optional[int] = ...,
        value: Optional[Union[date, str, int]] = ...,
        style_array: Optional[StyleArray] = ...,
    ) -> None: ...
    def __repr__(self) -> str: ...
    def _bind_value(self, value: Any) -> None: ...
    def check_string(self, value: Union[str, bytes]) -> str: ...
    @property
    def col_idx(self) -> int: ...
    @property
    def coordinate(self) -> str: ...
    @property
    def encoding(self) -> str: ...
    @property
    def is_date(self) -> bool: ...
    def offset(self, row: int = ..., column: int = ...) -> Cell: ...

class MergedCell:
    def __init__(
        self,
        worksheet: Worksheet,
        row: Optional[int] = ...,
        column: Optional[int] = ...,
    ) -> None: ...
    def __repr__(self) -> str: ...
