"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const index_1 = require("../lib/index");
const core_1 = require("@aws-cdk/core");
const aws_ec2_1 = require("@aws-cdk/aws-ec2");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const mockApp = new core_1.App();
const stack = new core_1.Stack(mockApp, 'testing-stack');
const newvpc = new aws_ec2_1.Vpc(stack, 'VPC', {
    cidr: '10.1.0.0/16',
    maxAzs: 2,
    subnetConfiguration: [{
            cidrMask: 26,
            name: 'RunnerVPC',
            subnetType: aws_ec2_1.SubnetType.PUBLIC,
        }],
    natGateways: 0,
});
const runner = new index_1.GitlabContainerRunner(stack, 'testing', { gitlabtoken: 'GITLAB_TOKEN', ec2type: aws_ec2_1.InstanceType.of(aws_ec2_1.InstanceClass.T3, aws_ec2_1.InstanceSize.SMALL), selfvpc: newvpc });
runner.runnerRole.addManagedPolicy(aws_iam_1.ManagedPolicy.fromAwsManagedPolicyName('AmazonS3ReadOnlyAccess'));
runner.runnerEc2.connections.allowFrom(aws_ec2_1.Peer.ipv4('0.0.0.0/0'), aws_ec2_1.Port.tcp(80));
new core_1.CfnOutput(stack, 'role', { value: runner.runnerRole.roleArn });
new core_1.CfnOutput(stack, 'InstanceID', { value: runner.runnerEc2.instanceId });
//# sourceMappingURL=data:application/json;base64,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