"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("@aws-cdk/core");
const iam = require("@aws-cdk/aws-iam");
const ec2 = require("@aws-cdk/aws-ec2");
class GitlabContainerRunner extends cdk.Construct {
    constructor(scope, id, props) {
        var _a, _b, _c, _d, _e;
        super(scope, id);
        const vpc = (_a = props.selfvpc) !== null && _a !== void 0 ? _a : new ec2.Vpc(this, 'VPC', {
            cidr: '10.0.0.0/16',
            maxAzs: 2,
            subnetConfiguration: [{
                    cidrMask: 26,
                    name: 'RunnerVPC',
                    subnetType: ec2.SubnetType.PUBLIC,
                }],
            natGateways: 0,
        });
        var token = props.gitlabtoken;
        var tag1 = (_b = props.tag1) !== null && _b !== void 0 ? _b : 'gitlab';
        var tag2 = (_c = props.tag2) !== null && _c !== void 0 ? _c : 'awscdk';
        var tag3 = (_d = props.tag3) !== null && _d !== void 0 ? _d : 'runner';
        const shell = ec2.UserData.forLinux();
        shell.addCommands('yum update -y');
        shell.addCommands('yum install docker -y');
        shell.addCommands('service docker start');
        shell.addCommands('usermod -aG docker ec2-user');
        shell.addCommands('chmod +x /var/run/docker.sock');
        shell.addCommands('service docker restart &&  chkconfig docker on');
        shell.addCommands('docker run -d -v /home/ec2-user/.gitlab-runner:/etc/gitlab-runner -v /var/run/docker.sock:/var/run/docker.sock --name gitlab-runner-register gitlab/gitlab-runner:alpine register --non-interactive --url https://gitlab.com/ --registration-token ' + token + ' --docker-pull-policy if-not-present --docker-volumes \"/var/run/docker.sock:/var/run/docker.sock\" --executor docker --docker-image \"alpine:latest\" --description \"Docker Runner\" --tag-list \"' + tag1 + ',' + tag2 + ',' + tag3 + '\" --docker-privileged');
        shell.addCommands('sleep 2 && docker run --restart always -d -v /home/ec2-user/.gitlab-runner:/etc/gitlab-runner -v /var/run/docker.sock:/var/run/docker.sock --name gitlab-runner gitlab/gitlab-runner:alpine');
        shell.addCommands('usermod -aG docker ssm-user');
        const ec2role = this.runnerRole = new iam.Role(this, 'runner-role', {
            assumedBy: new iam.ServicePrincipal('ec2.amazonaws.com'),
            description: 'For Gitlab EC2 Runner Role',
        });
        const runner = this.runnerEc2 = new ec2.Instance(this, 'GitlabRunner', {
            instanceType: (_e = props.ec2type) !== null && _e !== void 0 ? _e : ec2.InstanceType.of(ec2.InstanceClass.T3, ec2.InstanceSize.LARGE),
            instanceName: 'Gitlab-Runner',
            vpc,
            machineImage: new ec2.AmazonLinuxImage,
            role: ec2role,
            userData: shell,
            blockDevices: [({ deviceName: '/dev/xvda', volume: ec2.BlockDeviceVolume.ebs(60) })],
        });
        runner.role.addManagedPolicy(iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonSSMManagedInstanceCore'));
        new cdk.CfnOutput(this, 'Runner-Instance-ID', { value: runner.instanceId });
        new cdk.CfnOutput(this, 'Runner-Role-Arn', { value: runner.role.roleArn });
    }
}
exports.GitlabContainerRunner = GitlabContainerRunner;
//# sourceMappingURL=data:application/json;base64,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