import * as cdk from '@aws-cdk/core';
import * as iam from '@aws-cdk/aws-iam';
import * as ec2 from '@aws-cdk/aws-ec2';
export interface GitlabContainerRunnerProps {
    readonly gitlabtoken: string;
    readonly ec2type?: ec2.InstanceType;
    readonly selfvpc?: ec2.IVpc;
    readonly tag1?: string;
    readonly tag2?: string;
    readonly tag3?: string;
}
export declare class GitlabContainerRunner extends cdk.Construct {
    readonly runnerRole: iam.IRole;
    readonly runnerEc2: ec2.IInstance;
    constructor(scope: cdk.Construct, id: string, props: GitlabContainerRunnerProps);
}
