(self["webpackChunk_datalayer_jupyter_manager"] = self["webpackChunk_datalayer_jupyter_manager"] || []).push([["vendors-node_modules_primer_react_lib-esm_Dialog_ConfirmationDialog_js-node_modules_primer_re-3b6f8e"],{

/***/ "../../../node_modules/@primer/behaviors/dist/esm/focus-trap.js":
/*!**********************************************************************!*\
  !*** ../../../node_modules/@primer/behaviors/dist/esm/focus-trap.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "focusTrap": () => (/* binding */ focusTrap)
/* harmony export */ });
/* harmony import */ var _utils_iterate_focusable_elements_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./utils/iterate-focusable-elements.js */ "../../../node_modules/@primer/behaviors/dist/esm/utils/iterate-focusable-elements.js");
/* harmony import */ var _polyfills_event_listener_signal_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./polyfills/event-listener-signal.js */ "../../../node_modules/@primer/behaviors/dist/esm/polyfills/event-listener-signal.js");


(0,_polyfills_event_listener_signal_js__WEBPACK_IMPORTED_MODULE_0__.polyfill)();
const suspendedTrapStack = [];
let activeTrap = undefined;
function tryReactivate() {
    const trapToReactivate = suspendedTrapStack.pop();
    if (trapToReactivate) {
        focusTrap(trapToReactivate.container, trapToReactivate.initialFocus, trapToReactivate.originalSignal);
    }
}
function followSignal(signal) {
    const controller = new AbortController();
    signal.addEventListener('abort', () => {
        controller.abort();
    });
    return controller;
}
function focusTrap(container, initialFocus, abortSignal) {
    const controller = new AbortController();
    const signal = abortSignal !== null && abortSignal !== void 0 ? abortSignal : controller.signal;
    container.setAttribute('data-focus-trap', 'active');
    const sentinelStart = document.createElement('span');
    sentinelStart.setAttribute('class', 'sentinel');
    sentinelStart.setAttribute('tabindex', '0');
    sentinelStart.setAttribute('aria-hidden', 'true');
    sentinelStart.onfocus = () => {
        const lastFocusableChild = (0,_utils_iterate_focusable_elements_js__WEBPACK_IMPORTED_MODULE_1__.getFocusableChild)(container, true);
        lastFocusableChild === null || lastFocusableChild === void 0 ? void 0 : lastFocusableChild.focus();
    };
    const sentinelEnd = document.createElement('span');
    sentinelEnd.setAttribute('class', 'sentinel');
    sentinelEnd.setAttribute('tabindex', '0');
    sentinelEnd.setAttribute('aria-hidden', 'true');
    sentinelEnd.onfocus = () => {
        const firstFocusableChild = (0,_utils_iterate_focusable_elements_js__WEBPACK_IMPORTED_MODULE_1__.getFocusableChild)(container);
        firstFocusableChild === null || firstFocusableChild === void 0 ? void 0 : firstFocusableChild.focus();
    };
    container.prepend(sentinelStart);
    container.append(sentinelEnd);
    let lastFocusedChild = undefined;
    function ensureTrapZoneHasFocus(focusedElement) {
        if (focusedElement instanceof HTMLElement && document.contains(container)) {
            if (container.contains(focusedElement)) {
                lastFocusedChild = focusedElement;
                return;
            }
            else {
                if (lastFocusedChild && (0,_utils_iterate_focusable_elements_js__WEBPACK_IMPORTED_MODULE_1__.isTabbable)(lastFocusedChild) && container.contains(lastFocusedChild)) {
                    lastFocusedChild.focus();
                    return;
                }
                else if (initialFocus && container.contains(initialFocus)) {
                    initialFocus.focus();
                    return;
                }
                else {
                    const firstFocusableChild = (0,_utils_iterate_focusable_elements_js__WEBPACK_IMPORTED_MODULE_1__.getFocusableChild)(container);
                    firstFocusableChild === null || firstFocusableChild === void 0 ? void 0 : firstFocusableChild.focus();
                    return;
                }
            }
        }
    }
    const wrappingController = followSignal(signal);
    if (activeTrap) {
        const suspendedTrap = activeTrap;
        activeTrap.container.setAttribute('data-focus-trap', 'suspended');
        activeTrap.controller.abort();
        suspendedTrapStack.push(suspendedTrap);
    }
    wrappingController.signal.addEventListener('abort', () => {
        activeTrap = undefined;
    });
    signal.addEventListener('abort', () => {
        container.removeAttribute('data-focus-trap');
        const sentinels = container.getElementsByClassName('sentinel');
        while (sentinels.length > 0)
            sentinels[0].remove();
        const suspendedTrapIndex = suspendedTrapStack.findIndex(t => t.container === container);
        if (suspendedTrapIndex >= 0) {
            suspendedTrapStack.splice(suspendedTrapIndex, 1);
        }
        tryReactivate();
    });
    document.addEventListener('focus', event => {
        ensureTrapZoneHasFocus(event.target);
    }, { signal: wrappingController.signal, capture: true });
    ensureTrapZoneHasFocus(document.activeElement);
    activeTrap = {
        container,
        controller: wrappingController,
        initialFocus,
        originalSignal: signal
    };
    const suspendedTrapIndex = suspendedTrapStack.findIndex(t => t.container === container);
    if (suspendedTrapIndex >= 0) {
        suspendedTrapStack.splice(suspendedTrapIndex, 1);
    }
    if (!abortSignal) {
        return controller;
    }
}


/***/ }),

/***/ "../../../node_modules/@primer/behaviors/dist/esm/focus-zone.js":
/*!**********************************************************************!*\
  !*** ../../../node_modules/@primer/behaviors/dist/esm/focus-zone.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "FocusKeys": () => (/* binding */ FocusKeys),
/* harmony export */   "activeDescendantActivatedDirectly": () => (/* binding */ activeDescendantActivatedDirectly),
/* harmony export */   "activeDescendantActivatedIndirectly": () => (/* binding */ activeDescendantActivatedIndirectly),
/* harmony export */   "focusZone": () => (/* binding */ focusZone),
/* harmony export */   "hasActiveDescendantAttribute": () => (/* binding */ hasActiveDescendantAttribute),
/* harmony export */   "isActiveDescendantAttribute": () => (/* binding */ isActiveDescendantAttribute)
/* harmony export */ });
/* harmony import */ var _polyfills_event_listener_signal_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./polyfills/event-listener-signal.js */ "../../../node_modules/@primer/behaviors/dist/esm/polyfills/event-listener-signal.js");
/* harmony import */ var _utils_user_agent_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./utils/user-agent.js */ "../../../node_modules/@primer/behaviors/dist/esm/utils/user-agent.js");
/* harmony import */ var _utils_iterate_focusable_elements_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./utils/iterate-focusable-elements.js */ "../../../node_modules/@primer/behaviors/dist/esm/utils/iterate-focusable-elements.js");
/* harmony import */ var _utils_unique_id_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./utils/unique-id.js */ "../../../node_modules/@primer/behaviors/dist/esm/utils/unique-id.js");




(0,_polyfills_event_listener_signal_js__WEBPACK_IMPORTED_MODULE_0__.polyfill)();
var FocusKeys;
(function (FocusKeys) {
    FocusKeys[FocusKeys["ArrowHorizontal"] = 1] = "ArrowHorizontal";
    FocusKeys[FocusKeys["ArrowVertical"] = 2] = "ArrowVertical";
    FocusKeys[FocusKeys["JK"] = 4] = "JK";
    FocusKeys[FocusKeys["HL"] = 8] = "HL";
    FocusKeys[FocusKeys["HomeAndEnd"] = 16] = "HomeAndEnd";
    FocusKeys[FocusKeys["PageUpDown"] = 256] = "PageUpDown";
    FocusKeys[FocusKeys["WS"] = 32] = "WS";
    FocusKeys[FocusKeys["AD"] = 64] = "AD";
    FocusKeys[FocusKeys["Tab"] = 128] = "Tab";
    FocusKeys[FocusKeys["Backspace"] = 512] = "Backspace";
    FocusKeys[FocusKeys["ArrowAll"] = 3] = "ArrowAll";
    FocusKeys[FocusKeys["HJKL"] = 12] = "HJKL";
    FocusKeys[FocusKeys["WASD"] = 96] = "WASD";
    FocusKeys[FocusKeys["All"] = 511] = "All";
})(FocusKeys || (FocusKeys = {}));
const KEY_TO_BIT = {
    ArrowLeft: FocusKeys.ArrowHorizontal,
    ArrowDown: FocusKeys.ArrowVertical,
    ArrowUp: FocusKeys.ArrowVertical,
    ArrowRight: FocusKeys.ArrowHorizontal,
    h: FocusKeys.HL,
    j: FocusKeys.JK,
    k: FocusKeys.JK,
    l: FocusKeys.HL,
    a: FocusKeys.AD,
    s: FocusKeys.WS,
    w: FocusKeys.WS,
    d: FocusKeys.AD,
    Tab: FocusKeys.Tab,
    Home: FocusKeys.HomeAndEnd,
    End: FocusKeys.HomeAndEnd,
    PageUp: FocusKeys.PageUpDown,
    PageDown: FocusKeys.PageUpDown,
    Backspace: FocusKeys.Backspace
};
const KEY_TO_DIRECTION = {
    ArrowLeft: 'previous',
    ArrowDown: 'next',
    ArrowUp: 'previous',
    ArrowRight: 'next',
    h: 'previous',
    j: 'next',
    k: 'previous',
    l: 'next',
    a: 'previous',
    s: 'next',
    w: 'previous',
    d: 'next',
    Tab: 'next',
    Home: 'start',
    End: 'end',
    PageUp: 'start',
    PageDown: 'end',
    Backspace: 'previous'
};
function getDirection(keyboardEvent) {
    const direction = KEY_TO_DIRECTION[keyboardEvent.key];
    if (keyboardEvent.key === 'Tab' && keyboardEvent.shiftKey) {
        return 'previous';
    }
    const isMac = (0,_utils_user_agent_js__WEBPACK_IMPORTED_MODULE_1__.isMacOS)();
    if ((isMac && keyboardEvent.metaKey) || (!isMac && keyboardEvent.ctrlKey)) {
        if (keyboardEvent.key === 'ArrowLeft' || keyboardEvent.key === 'ArrowUp') {
            return 'start';
        }
        else if (keyboardEvent.key === 'ArrowRight' || keyboardEvent.key === 'ArrowDown') {
            return 'end';
        }
    }
    return direction;
}
function shouldIgnoreFocusHandling(keyboardEvent, activeElement) {
    const key = keyboardEvent.key;
    const keyLength = [...key].length;
    const isTextInput = (activeElement instanceof HTMLInputElement && activeElement.type === 'text') ||
        activeElement instanceof HTMLTextAreaElement;
    if (isTextInput && (keyLength === 1 || key === 'Home' || key === 'End')) {
        return true;
    }
    if (activeElement instanceof HTMLSelectElement) {
        if (keyLength === 1) {
            return true;
        }
        if (key === 'ArrowDown' && (0,_utils_user_agent_js__WEBPACK_IMPORTED_MODULE_1__.isMacOS)() && !keyboardEvent.metaKey) {
            return true;
        }
        if (key === 'ArrowDown' && !(0,_utils_user_agent_js__WEBPACK_IMPORTED_MODULE_1__.isMacOS)() && keyboardEvent.altKey) {
            return true;
        }
    }
    if (activeElement instanceof HTMLTextAreaElement && (key === 'PageUp' || key === 'PageDown')) {
        return true;
    }
    if (isTextInput) {
        const textInput = activeElement;
        const cursorAtStart = textInput.selectionStart === 0 && textInput.selectionEnd === 0;
        const cursorAtEnd = textInput.selectionStart === textInput.value.length && textInput.selectionEnd === textInput.value.length;
        if (key === 'ArrowLeft' && !cursorAtStart) {
            return true;
        }
        if (key === 'ArrowRight' && !cursorAtEnd) {
            return true;
        }
        if (textInput instanceof HTMLTextAreaElement) {
            if (key === 'ArrowUp' && !cursorAtStart) {
                return true;
            }
            if (key === 'ArrowDown' && !cursorAtEnd) {
                return true;
            }
        }
    }
    return false;
}
const isActiveDescendantAttribute = 'data-is-active-descendant';
const activeDescendantActivatedDirectly = 'activated-directly';
const activeDescendantActivatedIndirectly = 'activated-indirectly';
const hasActiveDescendantAttribute = 'data-has-active-descendant';
function focusZone(container, settings) {
    var _a, _b, _c, _d, _e;
    const focusableElements = [];
    const savedTabIndex = new WeakMap();
    const bindKeys = (_a = settings === null || settings === void 0 ? void 0 : settings.bindKeys) !== null && _a !== void 0 ? _a : ((settings === null || settings === void 0 ? void 0 : settings.getNextFocusable) ? FocusKeys.ArrowAll : FocusKeys.ArrowVertical) | FocusKeys.HomeAndEnd;
    const focusOutBehavior = (_b = settings === null || settings === void 0 ? void 0 : settings.focusOutBehavior) !== null && _b !== void 0 ? _b : 'stop';
    const focusInStrategy = (_c = settings === null || settings === void 0 ? void 0 : settings.focusInStrategy) !== null && _c !== void 0 ? _c : 'previous';
    const activeDescendantControl = settings === null || settings === void 0 ? void 0 : settings.activeDescendantControl;
    const activeDescendantCallback = settings === null || settings === void 0 ? void 0 : settings.onActiveDescendantChanged;
    let currentFocusedElement;
    const preventScroll = (_d = settings === null || settings === void 0 ? void 0 : settings.preventScroll) !== null && _d !== void 0 ? _d : false;
    function getFirstFocusableElement() {
        return focusableElements[0];
    }
    function isActiveDescendantInputFocused() {
        return document.activeElement === activeDescendantControl;
    }
    function updateFocusedElement(to, directlyActivated = false) {
        const from = currentFocusedElement;
        currentFocusedElement = to;
        if (activeDescendantControl) {
            if (to && isActiveDescendantInputFocused()) {
                setActiveDescendant(from, to, directlyActivated);
            }
            else {
                clearActiveDescendant();
            }
            return;
        }
        if (from && from !== to && savedTabIndex.has(from)) {
            from.setAttribute('tabindex', '-1');
        }
        to === null || to === void 0 ? void 0 : to.setAttribute('tabindex', '0');
    }
    function setActiveDescendant(from, to, directlyActivated = false) {
        if (!to.id) {
            to.setAttribute('id', (0,_utils_unique_id_js__WEBPACK_IMPORTED_MODULE_2__.uniqueId)());
        }
        if (from && from !== to) {
            from.removeAttribute(isActiveDescendantAttribute);
        }
        if (!activeDescendantControl ||
            (!directlyActivated && activeDescendantControl.getAttribute('aria-activedescendant') === to.id)) {
            return;
        }
        activeDescendantControl.setAttribute('aria-activedescendant', to.id);
        container.setAttribute(hasActiveDescendantAttribute, to.id);
        to.setAttribute(isActiveDescendantAttribute, directlyActivated ? activeDescendantActivatedDirectly : activeDescendantActivatedIndirectly);
        activeDescendantCallback === null || activeDescendantCallback === void 0 ? void 0 : activeDescendantCallback(to, from, directlyActivated);
    }
    function clearActiveDescendant(previouslyActiveElement = currentFocusedElement) {
        if (focusInStrategy === 'first') {
            currentFocusedElement = undefined;
        }
        activeDescendantControl === null || activeDescendantControl === void 0 ? void 0 : activeDescendantControl.removeAttribute('aria-activedescendant');
        container.removeAttribute(hasActiveDescendantAttribute);
        previouslyActiveElement === null || previouslyActiveElement === void 0 ? void 0 : previouslyActiveElement.removeAttribute(isActiveDescendantAttribute);
        activeDescendantCallback === null || activeDescendantCallback === void 0 ? void 0 : activeDescendantCallback(undefined, previouslyActiveElement, false);
    }
    function beginFocusManagement(...elements) {
        const filteredElements = elements.filter(e => { var _a, _b; return (_b = (_a = settings === null || settings === void 0 ? void 0 : settings.focusableElementFilter) === null || _a === void 0 ? void 0 : _a.call(settings, e)) !== null && _b !== void 0 ? _b : true; });
        if (filteredElements.length === 0) {
            return;
        }
        const insertIndex = focusableElements.findIndex(e => (e.compareDocumentPosition(filteredElements[0]) & Node.DOCUMENT_POSITION_PRECEDING) > 0);
        focusableElements.splice(insertIndex === -1 ? focusableElements.length : insertIndex, 0, ...filteredElements);
        for (const element of filteredElements) {
            if (!savedTabIndex.has(element)) {
                savedTabIndex.set(element, element.getAttribute('tabindex'));
            }
            element.setAttribute('tabindex', '-1');
        }
        if (!currentFocusedElement) {
            updateFocusedElement(getFirstFocusableElement());
        }
    }
    function endFocusManagement(...elements) {
        for (const element of elements) {
            const focusableElementIndex = focusableElements.indexOf(element);
            if (focusableElementIndex >= 0) {
                focusableElements.splice(focusableElementIndex, 1);
            }
            const savedIndex = savedTabIndex.get(element);
            if (savedIndex !== undefined) {
                if (savedIndex === null) {
                    element.removeAttribute('tabindex');
                }
                else {
                    element.setAttribute('tabindex', savedIndex);
                }
                savedTabIndex.delete(element);
            }
            if (element === currentFocusedElement) {
                const nextElementToFocus = getFirstFocusableElement();
                updateFocusedElement(nextElementToFocus);
            }
        }
    }
    beginFocusManagement(...(0,_utils_iterate_focusable_elements_js__WEBPACK_IMPORTED_MODULE_3__.iterateFocusableElements)(container));
    updateFocusedElement(getFirstFocusableElement());
    const observer = new MutationObserver(mutations => {
        for (const mutation of mutations) {
            for (const removedNode of mutation.removedNodes) {
                if (removedNode instanceof HTMLElement) {
                    endFocusManagement(...(0,_utils_iterate_focusable_elements_js__WEBPACK_IMPORTED_MODULE_3__.iterateFocusableElements)(removedNode));
                }
            }
        }
        for (const mutation of mutations) {
            for (const addedNode of mutation.addedNodes) {
                if (addedNode instanceof HTMLElement) {
                    beginFocusManagement(...(0,_utils_iterate_focusable_elements_js__WEBPACK_IMPORTED_MODULE_3__.iterateFocusableElements)(addedNode));
                }
            }
        }
    });
    observer.observe(container, {
        subtree: true,
        childList: true
    });
    const controller = new AbortController();
    const signal = (_e = settings === null || settings === void 0 ? void 0 : settings.abortSignal) !== null && _e !== void 0 ? _e : controller.signal;
    signal.addEventListener('abort', () => {
        endFocusManagement(...focusableElements);
    });
    let elementIndexFocusedByClick = undefined;
    container.addEventListener('mousedown', event => {
        if (event.target instanceof HTMLElement && event.target !== document.activeElement) {
            elementIndexFocusedByClick = focusableElements.indexOf(event.target);
        }
    }, { signal });
    if (activeDescendantControl) {
        container.addEventListener('focusin', event => {
            if (event.target instanceof HTMLElement && focusableElements.includes(event.target)) {
                activeDescendantControl.focus({ preventScroll });
                updateFocusedElement(event.target);
            }
        });
        container.addEventListener('mousemove', ({ target }) => {
            if (!(target instanceof Node)) {
                return;
            }
            const focusableElement = focusableElements.find(element => element.contains(target));
            if (focusableElement) {
                updateFocusedElement(focusableElement);
            }
        }, { signal, capture: true });
        activeDescendantControl.addEventListener('focusin', () => {
            if (!currentFocusedElement) {
                updateFocusedElement(getFirstFocusableElement());
            }
            else {
                setActiveDescendant(undefined, currentFocusedElement);
            }
        });
        activeDescendantControl.addEventListener('focusout', () => {
            clearActiveDescendant();
        });
    }
    else {
        container.addEventListener('focusin', event => {
            if (event.target instanceof HTMLElement) {
                if (elementIndexFocusedByClick !== undefined) {
                    if (elementIndexFocusedByClick >= 0) {
                        if (focusableElements[elementIndexFocusedByClick] !== currentFocusedElement) {
                            updateFocusedElement(focusableElements[elementIndexFocusedByClick]);
                        }
                    }
                    elementIndexFocusedByClick = undefined;
                }
                else {
                    if (focusInStrategy === 'previous') {
                        updateFocusedElement(event.target);
                    }
                    else if (focusInStrategy === 'closest' || focusInStrategy === 'first') {
                        if (event.relatedTarget instanceof Element && !container.contains(event.relatedTarget)) {
                            const targetElementIndex = lastKeyboardFocusDirection === 'previous' ? focusableElements.length - 1 : 0;
                            const targetElement = focusableElements[targetElementIndex];
                            targetElement === null || targetElement === void 0 ? void 0 : targetElement.focus({ preventScroll });
                            return;
                        }
                        else {
                            updateFocusedElement(event.target);
                        }
                    }
                    else if (typeof focusInStrategy === 'function') {
                        if (event.relatedTarget instanceof Element && !container.contains(event.relatedTarget)) {
                            const elementToFocus = focusInStrategy(event.relatedTarget);
                            const requestedFocusElementIndex = elementToFocus ? focusableElements.indexOf(elementToFocus) : -1;
                            if (requestedFocusElementIndex >= 0 && elementToFocus instanceof HTMLElement) {
                                elementToFocus.focus({ preventScroll });
                                return;
                            }
                            else {
                                console.warn('Element requested is not a known focusable element.');
                            }
                        }
                        else {
                            updateFocusedElement(event.target);
                        }
                    }
                }
            }
            lastKeyboardFocusDirection = undefined;
        }, { signal });
    }
    const keyboardEventRecipient = activeDescendantControl !== null && activeDescendantControl !== void 0 ? activeDescendantControl : container;
    let lastKeyboardFocusDirection = undefined;
    if (focusInStrategy === 'closest') {
        document.addEventListener('keydown', event => {
            if (event.key === 'Tab') {
                lastKeyboardFocusDirection = getDirection(event);
            }
        }, { signal, capture: true });
    }
    function getCurrentFocusedIndex() {
        if (!currentFocusedElement) {
            return 0;
        }
        const focusedIndex = focusableElements.indexOf(currentFocusedElement);
        const fallbackIndex = currentFocusedElement === container ? -1 : 0;
        return focusedIndex !== -1 ? focusedIndex : fallbackIndex;
    }
    keyboardEventRecipient.addEventListener('keydown', event => {
        var _a;
        if (event.key in KEY_TO_DIRECTION) {
            const keyBit = KEY_TO_BIT[event.key];
            if (!event.defaultPrevented &&
                (keyBit & bindKeys) > 0 &&
                !shouldIgnoreFocusHandling(event, document.activeElement)) {
                const direction = getDirection(event);
                let nextElementToFocus = undefined;
                if (settings === null || settings === void 0 ? void 0 : settings.getNextFocusable) {
                    nextElementToFocus = settings.getNextFocusable(direction, (_a = document.activeElement) !== null && _a !== void 0 ? _a : undefined, event);
                }
                if (!nextElementToFocus) {
                    const lastFocusedIndex = getCurrentFocusedIndex();
                    let nextFocusedIndex = lastFocusedIndex;
                    if (direction === 'previous') {
                        nextFocusedIndex -= 1;
                    }
                    else if (direction === 'start') {
                        nextFocusedIndex = 0;
                    }
                    else if (direction === 'next') {
                        nextFocusedIndex += 1;
                    }
                    else {
                        nextFocusedIndex = focusableElements.length - 1;
                    }
                    if (nextFocusedIndex < 0) {
                        if (focusOutBehavior === 'wrap' && event.key !== 'Tab') {
                            nextFocusedIndex = focusableElements.length - 1;
                        }
                        else {
                            nextFocusedIndex = 0;
                        }
                    }
                    if (nextFocusedIndex >= focusableElements.length) {
                        if (focusOutBehavior === 'wrap' && event.key !== 'Tab') {
                            nextFocusedIndex = 0;
                        }
                        else {
                            nextFocusedIndex = focusableElements.length - 1;
                        }
                    }
                    if (lastFocusedIndex !== nextFocusedIndex) {
                        nextElementToFocus = focusableElements[nextFocusedIndex];
                    }
                }
                if (activeDescendantControl) {
                    updateFocusedElement(nextElementToFocus || currentFocusedElement, true);
                }
                else if (nextElementToFocus) {
                    lastKeyboardFocusDirection = direction;
                    nextElementToFocus.focus({ preventScroll });
                }
                if (event.key !== 'Tab' || nextElementToFocus) {
                    event.preventDefault();
                }
            }
        }
    }, { signal });
    return controller;
}


/***/ }),

/***/ "../../../node_modules/@primer/behaviors/dist/esm/polyfills/event-listener-signal.js":
/*!*******************************************************************************************!*\
  !*** ../../../node_modules/@primer/behaviors/dist/esm/polyfills/event-listener-signal.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "polyfill": () => (/* binding */ polyfill)
/* harmony export */ });
let signalSupported = false;
function noop() { }
try {
    const options = Object.create({}, {
        signal: {
            get() {
                signalSupported = true;
            }
        }
    });
    window.addEventListener('test', noop, options);
    window.removeEventListener('test', noop, options);
}
catch (e) {
}
function featureSupported() {
    return signalSupported;
}
function monkeyPatch() {
    if (typeof window === 'undefined') {
        return;
    }
    const originalAddEventListener = EventTarget.prototype.addEventListener;
    EventTarget.prototype.addEventListener = function (name, originalCallback, optionsOrCapture) {
        if (typeof optionsOrCapture === 'object' &&
            'signal' in optionsOrCapture &&
            optionsOrCapture.signal instanceof AbortSignal) {
            originalAddEventListener.call(optionsOrCapture.signal, 'abort', () => {
                this.removeEventListener(name, originalCallback, optionsOrCapture);
            });
        }
        return originalAddEventListener.call(this, name, originalCallback, optionsOrCapture);
    };
}
function polyfill() {
    if (!featureSupported()) {
        monkeyPatch();
        signalSupported = true;
    }
}


/***/ }),

/***/ "../../../node_modules/@primer/behaviors/dist/esm/utils/iterate-focusable-elements.js":
/*!********************************************************************************************!*\
  !*** ../../../node_modules/@primer/behaviors/dist/esm/utils/iterate-focusable-elements.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "getFocusableChild": () => (/* binding */ getFocusableChild),
/* harmony export */   "isFocusable": () => (/* binding */ isFocusable),
/* harmony export */   "isTabbable": () => (/* binding */ isTabbable),
/* harmony export */   "iterateFocusableElements": () => (/* binding */ iterateFocusableElements)
/* harmony export */ });
function* iterateFocusableElements(container, options = {}) {
    var _a, _b;
    const strict = (_a = options.strict) !== null && _a !== void 0 ? _a : false;
    const acceptFn = ((_b = options.onlyTabbable) !== null && _b !== void 0 ? _b : false) ? isTabbable : isFocusable;
    const walker = document.createTreeWalker(container, NodeFilter.SHOW_ELEMENT, {
        acceptNode: node => node instanceof HTMLElement && acceptFn(node, strict) ? NodeFilter.FILTER_ACCEPT : NodeFilter.FILTER_SKIP
    });
    let nextNode = null;
    if (!options.reverse && acceptFn(container, strict)) {
        yield container;
    }
    if (options.reverse) {
        let lastChild = walker.lastChild();
        while (lastChild) {
            nextNode = lastChild;
            lastChild = walker.lastChild();
        }
    }
    else {
        nextNode = walker.firstChild();
    }
    while (nextNode instanceof HTMLElement) {
        yield nextNode;
        nextNode = options.reverse ? walker.previousNode() : walker.nextNode();
    }
    if (options.reverse && acceptFn(container, strict)) {
        yield container;
    }
    return undefined;
}
function getFocusableChild(container, lastChild = false) {
    return iterateFocusableElements(container, { reverse: lastChild, strict: true, onlyTabbable: true }).next().value;
}
function isFocusable(elem, strict = false) {
    const disabledAttrInert = ['BUTTON', 'INPUT', 'SELECT', 'TEXTAREA', 'OPTGROUP', 'OPTION', 'FIELDSET'].includes(elem.tagName) &&
        elem.disabled;
    const hiddenInert = elem.hidden;
    const hiddenInputInert = elem instanceof HTMLInputElement && elem.type === 'hidden';
    const sentinelInert = elem.classList.contains('sentinel');
    if (disabledAttrInert || hiddenInert || hiddenInputInert || sentinelInert) {
        return false;
    }
    if (strict) {
        const sizeInert = elem.offsetWidth === 0 || elem.offsetHeight === 0;
        const visibilityInert = ['hidden', 'collapse'].includes(getComputedStyle(elem).visibility);
        const clientRectsInert = elem.getClientRects().length === 0;
        if (sizeInert || visibilityInert || clientRectsInert) {
            return false;
        }
    }
    if (elem.getAttribute('tabindex') != null) {
        return true;
    }
    if (elem instanceof HTMLAnchorElement && elem.getAttribute('href') == null) {
        return false;
    }
    return elem.tabIndex !== -1;
}
function isTabbable(elem, strict = false) {
    return isFocusable(elem, strict) && elem.getAttribute('tabindex') !== '-1';
}


/***/ }),

/***/ "../../../node_modules/@primer/behaviors/dist/esm/utils/unique-id.js":
/*!***************************************************************************!*\
  !*** ../../../node_modules/@primer/behaviors/dist/esm/utils/unique-id.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "uniqueId": () => (/* binding */ uniqueId)
/* harmony export */ });
let idSeed = 10000;
function uniqueId() {
    return `__primer_id_${idSeed++}`;
}


/***/ }),

/***/ "../../../node_modules/@primer/behaviors/dist/esm/utils/user-agent.js":
/*!****************************************************************************!*\
  !*** ../../../node_modules/@primer/behaviors/dist/esm/utils/user-agent.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "isMacOS": () => (/* binding */ isMacOS)
/* harmony export */ });
let isMac = undefined;
function isMacOS() {
    if (isMac === undefined) {
        isMac = /^mac/i.test(window.navigator.platform);
    }
    return isMac;
}


/***/ }),

/***/ "../../../node_modules/@primer/react/lib-esm/ActionList/ActionListContainerContext.js":
/*!********************************************************************************************!*\
  !*** ../../../node_modules/@primer/react/lib-esm/ActionList/ActionListContainerContext.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ActionListContainerContext": () => (/* binding */ ActionListContainerContext)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);


/** This context can be used by components that compose ActionList inside a Menu */
const ActionListContainerContext = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createContext({});




/***/ }),

/***/ "../../../node_modules/@primer/react/lib-esm/ActionList/Description.js":
/*!*****************************************************************************!*\
  !*** ../../../node_modules/@primer/react/lib-esm/ActionList/Description.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Description": () => (/* binding */ Description)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Box_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Box.js */ "../../../node_modules/@primer/react/lib-esm/Box.js");
/* harmony import */ var _Truncate_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Truncate.js */ "../../../node_modules/@primer/react/lib-esm/Truncate.js");
/* harmony import */ var _shared_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./shared.js */ "../../../node_modules/@primer/react/lib-esm/ActionList/shared.js");
/* harmony import */ var deepmerge__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! deepmerge */ "../../../node_modules/deepmerge/dist/cjs.js");
/* harmony import */ var deepmerge__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(deepmerge__WEBPACK_IMPORTED_MODULE_1__);







const Description = ({
  variant = 'inline',
  sx = {},
  ...props
}) => {
  const styles = {
    fontSize: 0,
    lineHeight: '16px',
    flexGrow: 1,
    flexBasis: 0,
    minWidth: 0,
    marginLeft: variant === 'block' ? 0 : 2
  };
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_shared_js__WEBPACK_IMPORTED_MODULE_2__.Slot, {
    name: variant === 'block' ? 'BlockDescription' : 'InlineDescription'
  }, ({
    blockDescriptionId,
    inlineDescriptionId,
    disabled
  }) => variant === 'block' ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_3__["default"], {
    as: "span",
    sx: deepmerge__WEBPACK_IMPORTED_MODULE_1___default()({
      ...styles,
      color: disabled ? 'fg.disabled' : 'fg.muted'
    }, sx),
    id: blockDescriptionId
  }, props.children) : /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Truncate_js__WEBPACK_IMPORTED_MODULE_4__["default"], {
    id: inlineDescriptionId,
    sx: deepmerge__WEBPACK_IMPORTED_MODULE_1___default()({
      ...styles,
      color: disabled ? 'fg.disabled' : 'fg.muted'
    }, sx),
    title: props.children,
    inline: true,
    maxWidth: "100%"
  }, props.children));
};
Description.displayName = "Description";




/***/ }),

/***/ "../../../node_modules/@primer/react/lib-esm/ActionList/Divider.js":
/*!*************************************************************************!*\
  !*** ../../../node_modules/@primer/react/lib-esm/ActionList/Divider.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Divider": () => (/* binding */ Divider)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Box_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Box.js */ "../../../node_modules/@primer/react/lib-esm/Box.js");
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../constants.js */ "../../../node_modules/@primer/react/lib-esm/constants.js");
/* harmony import */ var deepmerge__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! deepmerge */ "../../../node_modules/deepmerge/dist/cjs.js");
/* harmony import */ var deepmerge__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(deepmerge__WEBPACK_IMPORTED_MODULE_1__);






/**
 * Visually separates `Item`s or `Group`s in an `ActionList`.
 */
const Divider = ({
  sx = {}
}) => {
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_2__["default"], {
    as: "li",
    "aria-hidden": "true",
    sx: deepmerge__WEBPACK_IMPORTED_MODULE_1___default()({
      height: 1,
      backgroundColor: 'actionListItem.inlineDivider',
      marginTop: theme => `calc(${(0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('space.2')(theme)} - 1px)`,
      marginBottom: 2,
      listStyle: 'none' // hide the ::marker inserted by browser's stylesheet
    }, sx),
    "data-component": "ActionList.Divider"
  });
};
Divider.displayName = "Divider";




/***/ }),

/***/ "../../../node_modules/@primer/react/lib-esm/ActionList/Group.js":
/*!***********************************************************************!*\
  !*** ../../../node_modules/@primer/react/lib-esm/ActionList/Group.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Group": () => (/* binding */ Group),
/* harmony export */   "GroupContext": () => (/* binding */ GroupContext)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _hooks_useId_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../hooks/useId.js */ "../../../node_modules/@primer/react/lib-esm/hooks/useId.js");
/* harmony import */ var _Box_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Box.js */ "../../../node_modules/@primer/react/lib-esm/Box.js");
/* harmony import */ var _List_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./List.js */ "../../../node_modules/@primer/react/lib-esm/ActionList/List.js");





function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const GroupContext = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createContext({});
const Group = ({
  title,
  variant = 'subtle',
  auxiliaryText,
  selectionVariant,
  role,
  sx = {},
  ...props
}) => {
  const labelId = (0,_hooks_useId_js__WEBPACK_IMPORTED_MODULE_1__.useId)();
  const {
    role: listRole
  } = react__WEBPACK_IMPORTED_MODULE_0___default().useContext(_List_js__WEBPACK_IMPORTED_MODULE_2__.ListContext);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_3__["default"], _extends({
    as: "li",
    role: listRole ? 'none' : undefined,
    sx: {
      '&:not(:first-child)': {
        marginTop: 2
      },
      listStyle: 'none',
      // hide the ::marker inserted by browser's stylesheet
      ...sx
    }
  }, props), title && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(Header, {
    title: title,
    variant: variant,
    auxiliaryText: auxiliaryText,
    labelId: labelId
  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(GroupContext.Provider, {
    value: {
      selectionVariant
    }
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_3__["default"], {
    as: "ul",
    sx: {
      paddingInlineStart: 0
    },
    "aria-labelledby": title ? labelId : undefined,
    role: role || listRole && 'group'
  }, props.children)));
};
Group.displayName = "Group";
/**
 * Displays the name and description of a `Group`.
 *
 * For visual presentation only. It's hidden from screen readers.
 */
const Header = ({
  variant,
  title,
  auxiliaryText,
  labelId,
  ...props
}) => {
  const {
    variant: listVariant
  } = react__WEBPACK_IMPORTED_MODULE_0___default().useContext(_List_js__WEBPACK_IMPORTED_MODULE_2__.ListContext);
  const styles = {
    paddingY: '6px',
    paddingX: listVariant === 'full' ? 2 : 3,
    fontSize: 0,
    fontWeight: 'bold',
    color: 'fg.muted',
    ...(variant === 'filled' && {
      backgroundColor: 'canvas.subtle',
      marginX: 0,
      marginBottom: 2,
      borderTop: '1px solid',
      borderBottom: '1px solid',
      borderColor: 'neutral.muted'
    })
  };
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_3__["default"], _extends({
    sx: styles,
    role: "presentation",
    "aria-hidden": "true"
  }, props), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", {
    id: labelId
  }, title), auxiliaryText && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", null, auxiliaryText));
};
Header.displayName = "Header";




/***/ }),

/***/ "../../../node_modules/@primer/react/lib-esm/ActionList/Item.js":
/*!**********************************************************************!*\
  !*** ../../../node_modules/@primer/react/lib-esm/ActionList/Item.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Item": () => (/* binding */ Item)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Box_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../Box.js */ "../../../node_modules/@primer/react/lib-esm/Box.js");
/* harmony import */ var _sx_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../sx.js */ "../../../node_modules/@primer/react/lib-esm/sx.js");
/* harmony import */ var _ThemeProvider_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../ThemeProvider.js */ "../../../node_modules/@primer/react/lib-esm/ThemeProvider.js");
/* harmony import */ var _hooks_useId_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../hooks/useId.js */ "../../../node_modules/@primer/react/lib-esm/hooks/useId.js");
/* harmony import */ var _ActionListContainerContext_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./ActionListContainerContext.js */ "../../../node_modules/@primer/react/lib-esm/ActionList/ActionListContainerContext.js");
/* harmony import */ var _Group_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./Group.js */ "../../../node_modules/@primer/react/lib-esm/ActionList/Group.js");
/* harmony import */ var _List_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./List.js */ "../../../node_modules/@primer/react/lib-esm/ActionList/List.js");
/* harmony import */ var _Selection_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./Selection.js */ "../../../node_modules/@primer/react/lib-esm/ActionList/Selection.js");
/* harmony import */ var _shared_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./shared.js */ "../../../node_modules/@primer/react/lib-esm/ActionList/shared.js");
/* harmony import */ var _utils_defaultSxProp_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/defaultSxProp.js */ "../../../node_modules/@primer/react/lib-esm/utils/defaultSxProp.js");
/* harmony import */ var deepmerge__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! deepmerge */ "../../../node_modules/deepmerge/dist/cjs.js");
/* harmony import */ var deepmerge__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(deepmerge__WEBPACK_IMPORTED_MODULE_2__);














function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const LiBox = styled_components__WEBPACK_IMPORTED_MODULE_1___default().li.withConfig({
  displayName: "Item__LiBox",
  componentId: "sc-yeql7o-0"
})(_sx_js__WEBPACK_IMPORTED_MODULE_3__["default"]);
const Item = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().forwardRef(({
  variant = 'default',
  disabled = false,
  selected = undefined,
  active = false,
  onSelect,
  sx: sxProp = _utils_defaultSxProp_js__WEBPACK_IMPORTED_MODULE_4__.defaultSxProp,
  id,
  role,
  _PrivateItemWrapper,
  ...props
}, forwardedRef) => {
  const {
    variant: listVariant,
    showDividers,
    selectionVariant: listSelectionVariant
  } = react__WEBPACK_IMPORTED_MODULE_0___default().useContext(_List_js__WEBPACK_IMPORTED_MODULE_5__.ListContext);
  const {
    selectionVariant: groupSelectionVariant
  } = react__WEBPACK_IMPORTED_MODULE_0___default().useContext(_Group_js__WEBPACK_IMPORTED_MODULE_6__.GroupContext);
  const {
    container,
    afterSelect,
    selectionAttribute
  } = react__WEBPACK_IMPORTED_MODULE_0___default().useContext(_ActionListContainerContext_js__WEBPACK_IMPORTED_MODULE_7__.ActionListContainerContext);
  let selectionVariant;
  if (typeof groupSelectionVariant !== 'undefined') selectionVariant = groupSelectionVariant;else selectionVariant = listSelectionVariant;

  /** Infer item role based on the container */
  let itemRole;
  if (container === 'ActionMenu' || container === 'DropdownMenu') {
    if (selectionVariant === 'single') itemRole = 'menuitemradio';else if (selectionVariant === 'multiple') itemRole = 'menuitemcheckbox';else itemRole = 'menuitem';
  }
  const {
    theme
  } = (0,_ThemeProvider_js__WEBPACK_IMPORTED_MODULE_8__.useTheme)();
  const activeStyles = {
    fontWeight: 'bold',
    bg: 'actionListItem.default.selectedBg',
    '&::after': {
      position: 'absolute',
      top: 'calc(50% - 12px)',
      left: -2,
      width: '4px',
      height: '24px',
      content: '""',
      bg: 'accent.fg',
      borderRadius: 2
    }
  };
  const styles = {
    position: 'relative',
    display: 'flex',
    paddingX: 2,
    fontSize: 1,
    paddingY: '6px',
    // custom value off the scale
    lineHeight: _shared_js__WEBPACK_IMPORTED_MODULE_9__.TEXT_ROW_HEIGHT,
    minHeight: 5,
    marginX: listVariant === 'inset' ? 2 : 0,
    borderRadius: listVariant === 'inset' ? 2 : 0,
    transition: 'background 33.333ms linear',
    color: (0,_shared_js__WEBPACK_IMPORTED_MODULE_9__.getVariantStyles)(variant, disabled).color,
    cursor: 'pointer',
    '&[aria-disabled]': {
      cursor: 'not-allowed'
    },
    // Button reset styles (to support as="button")
    appearance: 'none',
    background: 'unset',
    border: 'unset',
    width: 'calc(100% - 16px)',
    fontFamily: 'unset',
    textAlign: 'unset',
    marginY: 'unset',
    '@media (hover: hover) and (pointer: fine)': {
      ':hover:not([aria-disabled])': {
        backgroundColor: `actionListItem.${variant}.hoverBg`,
        color: (0,_shared_js__WEBPACK_IMPORTED_MODULE_9__.getVariantStyles)(variant, disabled).hoverColor
      },
      ':focus:not([data-focus-visible-added]), > a:focus:not([data-focus-visible-added])': {
        backgroundColor: `actionListItem.${variant}.selectedBg`,
        color: (0,_shared_js__WEBPACK_IMPORTED_MODULE_9__.getVariantStyles)(variant, disabled).hoverColor,
        outline: 'none'
      },
      '&[data-focus-visible-added], > a[data-focus-visible-added]': {
        // we don't use :focus-visible because not all browsers (safari) have it yet
        outline: 'none',
        border: `2 solid`,
        boxShadow: `0 0 0 2px ${theme === null || theme === void 0 ? void 0 : theme.colors.accent.emphasis}`
      },
      ':active:not([aria-disabled])': {
        backgroundColor: `actionListItem.${variant}.activeBg`,
        color: (0,_shared_js__WEBPACK_IMPORTED_MODULE_9__.getVariantStyles)(variant, disabled).hoverColor
      }
    },
    '@media (forced-colors: active)': {
      ':focus': {
        // Support for Windows high contrast https://sarahmhigley.com/writing/whcm-quick-tips
        outline: 'solid 1px transparent !important'
      }
    },
    /** Divider styles */
    '[data-component="ActionList.Item--DividerContainer"]': {
      position: 'relative'
    },
    '[data-component="ActionList.Item--DividerContainer"]::before': {
      content: '" "',
      display: 'block',
      position: 'absolute',
      width: '100%',
      top: '-7px',
      border: '0 solid',
      borderTopWidth: showDividers ? `1px` : '0',
      borderColor: 'var(--divider-color, transparent)'
    },
    // show between 2 items
    ':not(:first-of-type)': {
      '--divider-color': theme === null || theme === void 0 ? void 0 : theme.colors.actionListItem.inlineDivider
    },
    // hide divider after dividers & group header, with higher importance!
    '[data-component="ActionList.Divider"] + &': {
      '--divider-color': 'transparent !important'
    },
    // hide border on current and previous item
    '&:hover:not([aria-disabled]), &:focus:not([aria-disabled]), &[data-focus-visible-added]:not([aria-disabled])': {
      '--divider-color': 'transparent'
    },
    '&:hover:not([aria-disabled]) + &, &:focus:not([aria-disabled]) + &, &[data-focus-visible-added] + li': {
      '--divider-color': 'transparent'
    },
    ...(active ? activeStyles : {})
  };
  const clickHandler = react__WEBPACK_IMPORTED_MODULE_0___default().useCallback(event => {
    if (disabled) return;
    if (!event.defaultPrevented) {
      if (typeof onSelect === 'function') onSelect(event);
      // if this Item is inside a Menu, close the Menu
      if (typeof afterSelect === 'function') afterSelect();
    }
  }, [onSelect, disabled, afterSelect]);
  const keyPressHandler = react__WEBPACK_IMPORTED_MODULE_0___default().useCallback(event => {
    if (disabled) return;
    if (!event.defaultPrevented && [' ', 'Enter'].includes(event.key)) {
      if (typeof onSelect === 'function') onSelect(event);
      // if this Item is inside a Menu, close the Menu
      if (typeof afterSelect === 'function') afterSelect();
    }
  }, [onSelect, disabled, afterSelect]);

  // use props.id if provided, otherwise generate one.
  const labelId = (0,_hooks_useId_js__WEBPACK_IMPORTED_MODULE_10__.useId)(id);
  const inlineDescriptionId = (0,_hooks_useId_js__WEBPACK_IMPORTED_MODULE_10__.useId)(id && `${id}--inline-description`);
  const blockDescriptionId = (0,_hooks_useId_js__WEBPACK_IMPORTED_MODULE_10__.useId)(id && `${id}--block-description`);
  const ItemWrapper = _PrivateItemWrapper || (react__WEBPACK_IMPORTED_MODULE_0___default().Fragment);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_shared_js__WEBPACK_IMPORTED_MODULE_9__.Slots, {
    context: {
      variant,
      disabled,
      inlineDescriptionId,
      blockDescriptionId
    }
  }, slots => {
    const menuItemProps = {
      onClick: clickHandler,
      onKeyPress: keyPressHandler,
      'aria-disabled': disabled ? true : undefined,
      tabIndex: disabled ? undefined : 0,
      'aria-labelledby': `${labelId} ${slots.InlineDescription ? inlineDescriptionId : ''}`,
      'aria-describedby': slots.BlockDescription ? blockDescriptionId : undefined,
      ...(selectionAttribute && {
        [selectionAttribute]: selected
      }),
      role: role || itemRole
    };
    const containerProps = _PrivateItemWrapper ? {
      role: role || itemRole ? 'none' : undefined
    } : menuItemProps;
    const wrapperProps = _PrivateItemWrapper ? menuItemProps : {};
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(LiBox, _extends({
      ref: forwardedRef,
      sx: deepmerge__WEBPACK_IMPORTED_MODULE_2___default()(styles, sxProp)
    }, containerProps, props), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(ItemWrapper, wrapperProps, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Selection_js__WEBPACK_IMPORTED_MODULE_11__.Selection, {
      selected: selected
    }), slots.LeadingVisual, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_12__["default"], {
      "data-component": "ActionList.Item--DividerContainer",
      sx: {
        display: 'flex',
        flexDirection: 'column',
        flexGrow: 1,
        minWidth: 0
      }
    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(ConditionalBox, {
      if: Boolean(slots.TrailingVisual),
      sx: {
        display: 'flex',
        flexGrow: 1
      }
    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(ConditionalBox, {
      if: Boolean(slots.InlineDescription),
      sx: {
        display: 'flex',
        flexGrow: 1,
        alignItems: 'baseline',
        minWidth: 0
      }
    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_12__["default"], {
      as: "span",
      id: labelId,
      sx: {
        flexGrow: slots.InlineDescription ? 0 : 1
      }
    }, props.children), slots.InlineDescription), slots.TrailingVisual), slots.BlockDescription)));
  });
});
Item.displayName = 'ActionList.Item';
const ConditionalBox = props => {
  const {
    if: condition,
    ...rest
  } = props;
  if (condition) return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_12__["default"], rest, props.children);else return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, props.children);
};




/***/ }),

/***/ "../../../node_modules/@primer/react/lib-esm/ActionList/LinkItem.js":
/*!**************************************************************************!*\
  !*** ../../../node_modules/@primer/react/lib-esm/ActionList/LinkItem.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "LinkItem": () => (/* binding */ LinkItem)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Link_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Link.js */ "../../../node_modules/@primer/react/lib-esm/Link.js");
/* harmony import */ var _Item_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Item.js */ "../../../node_modules/@primer/react/lib-esm/ActionList/Item.js");
/* harmony import */ var deepmerge__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! deepmerge */ "../../../node_modules/deepmerge/dist/cjs.js");
/* harmony import */ var deepmerge__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(deepmerge__WEBPACK_IMPORTED_MODULE_1__);






function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const LinkItem = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().forwardRef(({
  sx = {},
  active,
  as: Component,
  ...props
}, forwardedRef) => {
  const styles = {
    // occupy full size of Item
    paddingX: 2,
    paddingY: '6px',
    // custom value off the scale
    display: 'flex',
    flexGrow: 1,
    // full width
    borderRadius: 2,
    // inherit Item styles
    color: 'inherit',
    '&:hover': {
      color: 'inherit',
      textDecoration: 'none'
    }
  };
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Item_js__WEBPACK_IMPORTED_MODULE_2__.Item, {
    active: active,
    sx: {
      paddingY: 0,
      paddingX: 0
    },
    _PrivateItemWrapper: ({
      children,
      onClick,
      ...rest
    }) => {
      const clickHandler = event => {
        onClick && onClick(event);
        props.onClick && props.onClick(event);
      };
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Link_js__WEBPACK_IMPORTED_MODULE_3__["default"], _extends({
        as: Component,
        sx: deepmerge__WEBPACK_IMPORTED_MODULE_1___default()(styles, sx)
      }, rest, props, {
        onClick: clickHandler,
        ref: forwardedRef
      }), children);
    }
  }, props.children);
});




/***/ }),

/***/ "../../../node_modules/@primer/react/lib-esm/ActionList/List.js":
/*!**********************************************************************!*\
  !*** ../../../node_modules/@primer/react/lib-esm/ActionList/List.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "List": () => (/* binding */ List),
/* harmony export */   "ListContext": () => (/* binding */ ListContext)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _sx_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../sx.js */ "../../../node_modules/@primer/react/lib-esm/sx.js");
/* harmony import */ var _ActionListContainerContext_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./ActionListContainerContext.js */ "../../../node_modules/@primer/react/lib-esm/ActionList/ActionListContainerContext.js");
/* harmony import */ var _utils_defaultSxProp_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/defaultSxProp.js */ "../../../node_modules/@primer/react/lib-esm/utils/defaultSxProp.js");
/* harmony import */ var deepmerge__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! deepmerge */ "../../../node_modules/deepmerge/dist/cjs.js");
/* harmony import */ var deepmerge__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(deepmerge__WEBPACK_IMPORTED_MODULE_2__);







function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const ListContext = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createContext({});
const ListBox = styled_components__WEBPACK_IMPORTED_MODULE_1___default().ul.withConfig({
  displayName: "List__ListBox",
  componentId: "sc-1x7olzq-0"
})(_sx_js__WEBPACK_IMPORTED_MODULE_3__["default"]);
const List = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().forwardRef(({
  variant = 'inset',
  selectionVariant,
  showDividers = false,
  role,
  sx: sxProp = _utils_defaultSxProp_js__WEBPACK_IMPORTED_MODULE_4__.defaultSxProp,
  ...props
}, forwardedRef) => {
  const styles = {
    margin: 0,
    paddingInlineStart: 0,
    // reset ul styles
    paddingY: variant === 'inset' ? 2 : 0
  };

  /** if list is inside a Menu, it will get a role from the Menu */
  const {
    listRole,
    listLabelledBy,
    selectionVariant: containerSelectionVariant // TODO: Remove after DropdownMenu2 deprecation
  } = react__WEBPACK_IMPORTED_MODULE_0___default().useContext(_ActionListContainerContext_js__WEBPACK_IMPORTED_MODULE_5__.ActionListContainerContext);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(ListBox, _extends({
    sx: deepmerge__WEBPACK_IMPORTED_MODULE_2___default()(styles, sxProp),
    role: role || listRole,
    "aria-labelledby": listLabelledBy
  }, props, {
    ref: forwardedRef
  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(ListContext.Provider, {
    value: {
      variant,
      selectionVariant: selectionVariant || containerSelectionVariant,
      showDividers,
      role: role || listRole
    }
  }, props.children));
});
List.displayName = 'ActionList';




/***/ }),

/***/ "../../../node_modules/@primer/react/lib-esm/ActionList/Selection.js":
/*!***************************************************************************!*\
  !*** ../../../node_modules/@primer/react/lib-esm/ActionList/Selection.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Selection": () => (/* binding */ Selection)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _primer_octicons_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @primer/octicons-react */ "webpack/sharing/consume/default/@primer/octicons-react/@primer/octicons-react?1c16");
/* harmony import */ var _primer_octicons_react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_primer_octicons_react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _List_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./List.js */ "../../../node_modules/@primer/react/lib-esm/ActionList/List.js");
/* harmony import */ var _Group_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Group.js */ "../../../node_modules/@primer/react/lib-esm/ActionList/Group.js");
/* harmony import */ var _Visuals_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Visuals.js */ "../../../node_modules/@primer/react/lib-esm/ActionList/Visuals.js");






const Selection = ({
  selected
}) => {
  const {
    selectionVariant: listSelectionVariant
  } = react__WEBPACK_IMPORTED_MODULE_0___default().useContext(_List_js__WEBPACK_IMPORTED_MODULE_2__.ListContext);
  const {
    selectionVariant: groupSelectionVariant
  } = react__WEBPACK_IMPORTED_MODULE_0___default().useContext(_Group_js__WEBPACK_IMPORTED_MODULE_3__.GroupContext);

  /** selectionVariant in Group can override the selectionVariant in List root */
  /** fallback to selectionVariant from container menu if any (ActionMenu, SelectPanel ) */
  let selectionVariant;
  if (typeof groupSelectionVariant !== 'undefined') selectionVariant = groupSelectionVariant;else selectionVariant = listSelectionVariant;
  if (!selectionVariant) {
    // if selectionVariant is not set on List, but Item is selected
    // fail loudly instead of silently ignoring
    if (selected) {
      throw new Error('For Item to be selected, ActionList or ActionList.Group needs to have a selectionVariant defined');
    } else {
      return null;
    }
  }
  if (selectionVariant === 'single') {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Visuals_js__WEBPACK_IMPORTED_MODULE_4__.LeadingVisualContainer, null, selected && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primer_octicons_react__WEBPACK_IMPORTED_MODULE_1__.CheckIcon, null));
  }

  /**
   * selectionVariant is multiple
   * we use a svg instead of an input because there should not
   * be an interactive element inside an option
   * svg copied from primer/css
   */
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Visuals_js__WEBPACK_IMPORTED_MODULE_4__.LeadingVisualContainer, {
    sx: {
      rect: {
        fill: selected ? 'accent.fg' : 'canvas.default',
        stroke: selected ? 'accent.fg' : 'border.default',
        shapeRendering: 'auto' // this is a workaround to override global style in github/github, see primer/react#1666
      },

      path: {
        fill: 'fg.onEmphasis',
        boxShadow: 'shadow.small',
        opacity: selected ? 1 : 0
      }
    }
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", {
    width: "16",
    height: "16",
    viewBox: "0 0 16 16",
    xmlns: "http://www.w3.org/2000/svg",
    "aria-hidden": "true"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", {
    x: "2",
    y: "2",
    width: "12",
    height: "12",
    rx: "4"
  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
    fillRule: "evenodd",
    strokeWidth: "0",
    d: "M4.03231 8.69862C3.84775 8.20646 4.49385 7.77554 4.95539 7.77554C5.41693 7.77554 6.80154 9.85246 6.80154 9.85246C6.80154 9.85246 10.2631 4.314 10.4938 4.08323C10.7246 3.85246 11.8785 4.08323 11.4169 5.00631C11.0081 5.82388 7.26308 11.4678 7.26308 11.4678C7.26308 11.4678 6.80154 12.1602 6.34 11.4678C5.87846 10.7755 4.21687 9.19077 4.03231 8.69862Z"
  })));
};
Selection.displayName = "Selection";




/***/ }),

/***/ "../../../node_modules/@primer/react/lib-esm/ActionList/Visuals.js":
/*!*************************************************************************!*\
  !*** ../../../node_modules/@primer/react/lib-esm/ActionList/Visuals.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "LeadingVisual": () => (/* binding */ LeadingVisual),
/* harmony export */   "LeadingVisualContainer": () => (/* binding */ LeadingVisualContainer),
/* harmony export */   "TrailingVisual": () => (/* binding */ TrailingVisual)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Box_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Box.js */ "../../../node_modules/@primer/react/lib-esm/Box.js");
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../constants.js */ "../../../node_modules/@primer/react/lib-esm/constants.js");
/* harmony import */ var _shared_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./shared.js */ "../../../node_modules/@primer/react/lib-esm/ActionList/shared.js");
/* harmony import */ var deepmerge__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! deepmerge */ "../../../node_modules/deepmerge/dist/cjs.js");
/* harmony import */ var deepmerge__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(deepmerge__WEBPACK_IMPORTED_MODULE_1__);







function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const LeadingVisualContainer = ({
  sx = {},
  ...props
}) => {
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_2__["default"], _extends({
    as: "span",
    sx: deepmerge__WEBPACK_IMPORTED_MODULE_1___default()({
      height: _shared_js__WEBPACK_IMPORTED_MODULE_3__.TEXT_ROW_HEIGHT,
      // match height of text row
      minWidth: (0,_constants_js__WEBPACK_IMPORTED_MODULE_4__.get)('space.3'),
      maxWidth: _shared_js__WEBPACK_IMPORTED_MODULE_3__.TEXT_ROW_HEIGHT,
      // square (same as height)
      display: 'flex',
      justifyContent: 'center',
      alignItems: 'center',
      flexShrink: 0,
      marginRight: 2
    }, sx)
  }, props));
};
LeadingVisualContainer.displayName = "LeadingVisualContainer";
const LeadingVisual = ({
  sx = {},
  ...props
}) => {
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_shared_js__WEBPACK_IMPORTED_MODULE_3__.Slot, {
    name: "LeadingVisual"
  }, ({
    variant,
    disabled
  }) => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(LeadingVisualContainer, _extends({
    sx: deepmerge__WEBPACK_IMPORTED_MODULE_1___default()({
      color: (0,_shared_js__WEBPACK_IMPORTED_MODULE_3__.getVariantStyles)(variant, disabled).iconColor,
      svg: {
        fontSize: 0
      }
    }, sx)
  }, props), props.children));
};
LeadingVisual.displayName = "LeadingVisual";
const TrailingVisual = ({
  sx = {},
  ...props
}) => {
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_shared_js__WEBPACK_IMPORTED_MODULE_3__.Slot, {
    name: "TrailingVisual"
  }, ({
    variant,
    disabled
  }) => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_2__["default"], _extends({
    as: "span",
    sx: deepmerge__WEBPACK_IMPORTED_MODULE_1___default()({
      height: '20px',
      // match height of text row
      flexShrink: 0,
      color: (0,_shared_js__WEBPACK_IMPORTED_MODULE_3__.getVariantStyles)(variant, disabled).annotationColor,
      marginLeft: 2,
      fontWeight: 'initial'
    }, sx)
  }, props), props.children));
};
TrailingVisual.displayName = "TrailingVisual";




/***/ }),

/***/ "../../../node_modules/@primer/react/lib-esm/ActionList/index.js":
/*!***********************************************************************!*\
  !*** ../../../node_modules/@primer/react/lib-esm/ActionList/index.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ActionList": () => (/* binding */ ActionList)
/* harmony export */ });
/* harmony import */ var _List_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./List.js */ "../../../node_modules/@primer/react/lib-esm/ActionList/List.js");
/* harmony import */ var _Group_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Group.js */ "../../../node_modules/@primer/react/lib-esm/ActionList/Group.js");
/* harmony import */ var _Item_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Item.js */ "../../../node_modules/@primer/react/lib-esm/ActionList/Item.js");
/* harmony import */ var _LinkItem_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./LinkItem.js */ "../../../node_modules/@primer/react/lib-esm/ActionList/LinkItem.js");
/* harmony import */ var _Divider_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Divider.js */ "../../../node_modules/@primer/react/lib-esm/ActionList/Divider.js");
/* harmony import */ var _Description_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./Description.js */ "../../../node_modules/@primer/react/lib-esm/ActionList/Description.js");
/* harmony import */ var _Visuals_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./Visuals.js */ "../../../node_modules/@primer/react/lib-esm/ActionList/Visuals.js");








/**
 * Collection of list-related components.
 */
const ActionList = Object.assign(_List_js__WEBPACK_IMPORTED_MODULE_0__.List, {
  /** Collects related `Items` in an `ActionList`. */
  Group: _Group_js__WEBPACK_IMPORTED_MODULE_1__.Group,
  /** An actionable or selectable `Item` */
  Item: _Item_js__WEBPACK_IMPORTED_MODULE_2__.Item,
  /** A `Item` that renders a full-size anchor inside ListItem */
  LinkItem: _LinkItem_js__WEBPACK_IMPORTED_MODULE_3__.LinkItem,
  /** Visually separates `Item`s or `Group`s in an `ActionList`. */
  Divider: _Divider_js__WEBPACK_IMPORTED_MODULE_4__.Divider,
  /** Secondary text which provides additional information about an `Item`. */
  Description: _Description_js__WEBPACK_IMPORTED_MODULE_5__.Description,
  /** Icon (or similar) positioned before `Item` text. */
  LeadingVisual: _Visuals_js__WEBPACK_IMPORTED_MODULE_6__.LeadingVisual,
  /** Icon (or similar) positioned after `Item` text. */
  TrailingVisual: _Visuals_js__WEBPACK_IMPORTED_MODULE_6__.TrailingVisual
});




/***/ }),

/***/ "../../../node_modules/@primer/react/lib-esm/ActionList/shared.js":
/*!************************************************************************!*\
  !*** ../../../node_modules/@primer/react/lib-esm/ActionList/shared.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Slot": () => (/* binding */ Slot),
/* harmony export */   "Slots": () => (/* binding */ Slots),
/* harmony export */   "TEXT_ROW_HEIGHT": () => (/* binding */ TEXT_ROW_HEIGHT),
/* harmony export */   "getVariantStyles": () => (/* binding */ getVariantStyles)
/* harmony export */ });
/* harmony import */ var _utils_create_slots_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/create-slots.js */ "../../../node_modules/@primer/react/lib-esm/utils/create-slots.js");


const getVariantStyles = (variant, disabled) => {
  if (disabled) {
    return {
      color: 'primer.fg.disabled',
      iconColor: 'primer.fg.disabled',
      annotationColor: 'primer.fg.disabled'
    };
  }
  switch (variant) {
    case 'danger':
      return {
        color: 'danger.fg',
        iconColor: 'danger.fg',
        annotationColor: 'fg.muted',
        hoverColor: 'actionListItem.danger.hoverText'
      };
    default:
      return {
        color: 'fg.default',
        iconColor: 'fg.muted',
        annotationColor: 'fg.muted',
        hoverColor: 'fg.default'
      };
  }
};
const {
  Slots,
  Slot
} = (0,_utils_create_slots_js__WEBPACK_IMPORTED_MODULE_0__["default"])(['LeadingVisual', 'InlineDescription', 'BlockDescription', 'TrailingVisual']);
const TEXT_ROW_HEIGHT = '20px'; // custom value off the scale




/***/ }),

/***/ "../../../node_modules/@primer/react/lib-esm/Box.js":
/*!**********************************************************!*\
  !*** ../../../node_modules/@primer/react/lib-esm/Box.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Box$1)
/* harmony export */ });
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var styled_system__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! styled-system */ "../../../node_modules/styled-system/dist/index.esm.js");
/* harmony import */ var _sx_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./sx.js */ "../../../node_modules/@primer/react/lib-esm/sx.js");




const Box = styled_components__WEBPACK_IMPORTED_MODULE_0___default().div.withConfig({
  displayName: "Box",
  componentId: "sc-1gh2r6s-0"
})(styled_system__WEBPACK_IMPORTED_MODULE_1__.space, styled_system__WEBPACK_IMPORTED_MODULE_1__.color, styled_system__WEBPACK_IMPORTED_MODULE_1__.typography, styled_system__WEBPACK_IMPORTED_MODULE_1__.layout, styled_system__WEBPACK_IMPORTED_MODULE_1__.flexbox, styled_system__WEBPACK_IMPORTED_MODULE_1__.grid, styled_system__WEBPACK_IMPORTED_MODULE_1__.background, styled_system__WEBPACK_IMPORTED_MODULE_1__.border, styled_system__WEBPACK_IMPORTED_MODULE_1__.position, styled_system__WEBPACK_IMPORTED_MODULE_1__.shadow, _sx_js__WEBPACK_IMPORTED_MODULE_2__["default"]);
var Box$1 = Box;




/***/ }),

/***/ "../../../node_modules/@primer/react/lib-esm/Button/Button.js":
/*!********************************************************************!*\
  !*** ../../../node_modules/@primer/react/lib-esm/Button/Button.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ButtonComponent": () => (/* binding */ ButtonComponent)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _ButtonBase_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ButtonBase.js */ "../../../node_modules/@primer/react/lib-esm/Button/ButtonBase.js");



function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const ButtonComponent = /*#__PURE__*/(0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)(({
  children,
  ...props
}, forwardedRef) => {
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_ButtonBase_js__WEBPACK_IMPORTED_MODULE_1__.ButtonBase, _extends({
    ref: forwardedRef,
    as: "button"
  }, props), children);
});
ButtonComponent.displayName = 'Button';




/***/ }),

/***/ "../../../node_modules/@primer/react/lib-esm/Button/ButtonBase.js":
/*!************************************************************************!*\
  !*** ../../../node_modules/@primer/react/lib-esm/Button/ButtonBase.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ButtonBase": () => (/* binding */ ButtonBase)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Box_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../Box.js */ "../../../node_modules/@primer/react/lib-esm/Box.js");
/* harmony import */ var _ThemeProvider_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../ThemeProvider.js */ "../../../node_modules/@primer/react/lib-esm/ThemeProvider.js");
/* harmony import */ var _types_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./types.js */ "../../../node_modules/@primer/react/lib-esm/Button/types.js");
/* harmony import */ var _styles_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./styles.js */ "../../../node_modules/@primer/react/lib-esm/Button/styles.js");
/* harmony import */ var _hooks_useRefObjectAsForwardedRef_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../hooks/useRefObjectAsForwardedRef.js */ "../../../node_modules/@primer/react/lib-esm/hooks/useRefObjectAsForwardedRef.js");
/* harmony import */ var _utils_defaultSxProp_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/defaultSxProp.js */ "../../../node_modules/@primer/react/lib-esm/utils/defaultSxProp.js");
/* harmony import */ var deepmerge__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! deepmerge */ "../../../node_modules/deepmerge/dist/cjs.js");
/* harmony import */ var deepmerge__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(deepmerge__WEBPACK_IMPORTED_MODULE_1__);










function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const iconWrapStyles = {
  display: 'inline-block'
};
const trailingIconStyles = {
  ...iconWrapStyles,
  ml: 2
};
const ButtonBase = /*#__PURE__*/(0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)(({
  children,
  as: Component = 'button',
  sx: sxProp = _utils_defaultSxProp_js__WEBPACK_IMPORTED_MODULE_2__.defaultSxProp,
  ...props
}, forwardedRef) => {
  const {
    leadingIcon: LeadingIcon,
    trailingIcon: TrailingIcon,
    variant = 'default',
    size = 'medium',
    ...rest
  } = props;
  const innerRef = react__WEBPACK_IMPORTED_MODULE_0___default().useRef(null);
  (0,_hooks_useRefObjectAsForwardedRef_js__WEBPACK_IMPORTED_MODULE_3__.useRefObjectAsForwardedRef)(forwardedRef, innerRef);
  const {
    theme
  } = (0,_ThemeProvider_js__WEBPACK_IMPORTED_MODULE_4__.useTheme)();
  const baseStyles = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(() => {
    return deepmerge__WEBPACK_IMPORTED_MODULE_1___default().all([(0,_styles_js__WEBPACK_IMPORTED_MODULE_5__.getButtonStyles)(theme), (0,_styles_js__WEBPACK_IMPORTED_MODULE_5__.getSizeStyles)(size, variant, false), (0,_styles_js__WEBPACK_IMPORTED_MODULE_5__.getVariantStyles)(variant, theme)]);
  }, [theme, size, variant]);
  const sxStyles = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(() => {
    return deepmerge__WEBPACK_IMPORTED_MODULE_1___default()(baseStyles, sxProp);
  }, [baseStyles, sxProp]);
  if (true) {
    /**
     * The Linter yells because it thinks this conditionally calls an effect,
     * but since this is a compile-time flag and not a runtime conditional
     * this is safe, and ensures the entire effect is kept out of prod builds
     * shaving precious bytes from the output, and avoiding mounting a noop effect
     */
    // eslint-disable-next-line react-hooks/rules-of-hooks
    react__WEBPACK_IMPORTED_MODULE_0___default().useEffect(() => {
      if (innerRef.current && !(innerRef.current instanceof HTMLButtonElement) && !(innerRef.current instanceof HTMLAnchorElement)) {
        // eslint-disable-next-line no-console
        console.warn('This component should be an instanceof a semantic button or anchor');
      }
    }, [innerRef]);
  }
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_types_js__WEBPACK_IMPORTED_MODULE_6__.StyledButton, _extends({
    as: Component,
    sx: sxStyles
  }, rest, {
    ref: innerRef
  }), LeadingIcon && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_7__["default"], {
    as: "span",
    "data-component": "leadingIcon",
    sx: iconWrapStyles
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(LeadingIcon, null)), children && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", {
    "data-component": "text"
  }, children), TrailingIcon && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_7__["default"], {
    as: "span",
    "data-component": "trailingIcon",
    sx: trailingIconStyles
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(TrailingIcon, null)));
});




/***/ }),

/***/ "../../../node_modules/@primer/react/lib-esm/Button/ButtonCounter.js":
/*!***************************************************************************!*\
  !*** ../../../node_modules/@primer/react/lib-esm/Button/ButtonCounter.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Counter": () => (/* binding */ Counter)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _CounterLabel_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../CounterLabel.js */ "../../../node_modules/@primer/react/lib-esm/CounterLabel.js");
/* harmony import */ var _utils_defaultSxProp_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/defaultSxProp.js */ "../../../node_modules/@primer/react/lib-esm/utils/defaultSxProp.js");




function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const Counter = ({
  children,
  sx: sxProp = _utils_defaultSxProp_js__WEBPACK_IMPORTED_MODULE_1__.defaultSxProp,
  ...props
}) => {
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_CounterLabel_js__WEBPACK_IMPORTED_MODULE_2__["default"], _extends({
    "data-component": "ButtonCounter",
    sx: {
      ml: 2,
      ...sxProp
    }
  }, props), children);
};
Counter.displayName = "Counter";




/***/ }),

/***/ "../../../node_modules/@primer/react/lib-esm/Button/index.js":
/*!*******************************************************************!*\
  !*** ../../../node_modules/@primer/react/lib-esm/Button/index.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Button": () => (/* binding */ Button)
/* harmony export */ });
/* harmony import */ var _Button_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Button.js */ "../../../node_modules/@primer/react/lib-esm/Button/Button.js");
/* harmony import */ var _ButtonCounter_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ButtonCounter.js */ "../../../node_modules/@primer/react/lib-esm/Button/ButtonCounter.js");



const Button = Object.assign(_Button_js__WEBPACK_IMPORTED_MODULE_0__.ButtonComponent, {
  Counter: _ButtonCounter_js__WEBPACK_IMPORTED_MODULE_1__.Counter
});




/***/ }),

/***/ "../../../node_modules/@primer/react/lib-esm/Button/styles.js":
/*!********************************************************************!*\
  !*** ../../../node_modules/@primer/react/lib-esm/Button/styles.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "TEXT_ROW_HEIGHT": () => (/* binding */ TEXT_ROW_HEIGHT),
/* harmony export */   "getBaseStyles": () => (/* binding */ getBaseStyles),
/* harmony export */   "getButtonStyles": () => (/* binding */ getButtonStyles),
/* harmony export */   "getSizeStyles": () => (/* binding */ getSizeStyles),
/* harmony export */   "getVariantStyles": () => (/* binding */ getVariantStyles)
/* harmony export */ });
const TEXT_ROW_HEIGHT = '20px'; // custom value off the scale

const getVariantStyles = (variant = 'default', theme) => {
  const style = {
    default: {
      color: 'btn.text',
      backgroundColor: 'btn.bg',
      boxShadow: `${theme === null || theme === void 0 ? void 0 : theme.shadows.btn.shadow}, ${theme === null || theme === void 0 ? void 0 : theme.shadows.btn.insetShadow}`,
      '&:hover:not([disabled])': {
        backgroundColor: 'btn.hoverBg'
      },
      '&:active:not([disabled])': {
        backgroundColor: 'btn.activeBg',
        borderColor: 'btn.activeBorder'
      },
      '&:disabled': {
        color: 'primer.fg.disabled',
        '[data-component=ButtonCounter]': {
          color: 'inherit'
        }
      },
      '&[aria-expanded=true]': {
        backgroundColor: 'btn.activeBg',
        borderColor: 'btn.activeBorder'
      }
    },
    primary: {
      color: 'btn.primary.text',
      backgroundColor: 'btn.primary.bg',
      borderColor: 'border.subtle',
      boxShadow: `${theme === null || theme === void 0 ? void 0 : theme.shadows.btn.primary.shadow}`,
      '&:hover:not([disabled])': {
        color: 'btn.primary.hoverText',
        backgroundColor: 'btn.primary.hoverBg'
      },
      '&:focus:not([disabled])': {
        boxShadow: 'inset 0 0 0 3px'
      },
      '&:focus-visible:not([disabled])': {
        boxShadow: 'inset 0 0 0 3px'
      },
      '&:active:not([disabled])': {
        backgroundColor: 'btn.primary.selectedBg',
        boxShadow: `${theme === null || theme === void 0 ? void 0 : theme.shadows.btn.primary.selectedShadow}`
      },
      '&:disabled': {
        color: 'btn.primary.disabledText',
        backgroundColor: 'btn.primary.disabledBg',
        '[data-component=ButtonCounter]': {
          color: 'inherit'
        }
      },
      '[data-component=ButtonCounter]': {
        backgroundColor: 'btn.primary.counterBg',
        color: 'btn.primary.text'
      },
      '&[aria-expanded=true]': {
        backgroundColor: 'btn.primary.selectedBg',
        boxShadow: `${theme === null || theme === void 0 ? void 0 : theme.shadows.btn.primary.selectedShadow}`
      }
    },
    danger: {
      color: 'btn.danger.text',
      backgroundColor: 'btn.bg',
      boxShadow: `${theme === null || theme === void 0 ? void 0 : theme.shadows.btn.shadow}`,
      '&:hover:not([disabled])': {
        color: 'btn.danger.hoverText',
        backgroundColor: 'btn.danger.hoverBg',
        borderColor: 'btn.danger.hoverBorder',
        boxShadow: `${theme === null || theme === void 0 ? void 0 : theme.shadows.btn.danger.hoverShadow}`,
        '[data-component=ButtonCounter]': {
          backgroundColor: 'btn.danger.hoverCounterBg',
          color: 'btn.danger.hoverText'
        }
      },
      '&:active:not([disabled])': {
        color: 'btn.danger.selectedText',
        backgroundColor: 'btn.danger.selectedBg',
        boxShadow: `${theme === null || theme === void 0 ? void 0 : theme.shadows.btn.danger.selectedShadow}`,
        borderColor: 'btn.danger.selectedBorder'
      },
      '&:disabled': {
        color: 'btn.danger.disabledText',
        backgroundColor: 'btn.danger.disabledBg',
        borderColor: 'btn.danger.disabledBorder',
        '[data-component=ButtonCounter]': {
          color: 'inherit',
          backgroundColor: 'btn.danger.disabledCounterBg'
        }
      },
      '[data-component=ButtonCounter]': {
        color: 'btn.danger.text',
        backgroundColor: 'btn.danger.counterBg'
      },
      '&[aria-expanded=true]': {
        color: 'btn.danger.selectedText',
        backgroundColor: 'btn.danger.selectedBg',
        boxShadow: `${theme === null || theme === void 0 ? void 0 : theme.shadows.btn.danger.selectedShadow}`,
        borderColor: 'btn.danger.selectedBorder'
      }
    },
    invisible: {
      color: 'accent.fg',
      backgroundColor: 'transparent',
      border: '0',
      boxShadow: 'none',
      '&:hover:not([disabled])': {
        backgroundColor: 'btn.hoverBg'
      },
      '&:active:not([disabled])': {
        backgroundColor: 'btn.selectedBg'
      },
      '&:disabled': {
        color: 'primer.fg.disabled',
        '[data-component=ButtonCounter]': {
          color: 'inherit'
        }
      },
      '&[aria-expanded=true]': {
        backgroundColor: 'btn.selectedBg'
      }
    },
    outline: {
      color: 'btn.outline.text',
      boxShadow: `${theme === null || theme === void 0 ? void 0 : theme.shadows.btn.shadow}`,
      borderColor: 'btn.border',
      backgroundColor: 'btn.bg',
      '&:hover:not([disabled])': {
        color: 'btn.outline.hoverText',
        backgroundColor: 'btn.outline.hoverBg',
        borderColor: 'btn.outline.hoverBorder',
        boxShadow: `${theme === null || theme === void 0 ? void 0 : theme.shadows.btn.outline.hoverShadow}`,
        '[data-component=ButtonCounter]': {
          backgroundColor: 'btn.outline.hoverCounterBg',
          color: 'inherit'
        }
      },
      '&:active:not([disabled])': {
        color: 'btn.outline.selectedText',
        backgroundColor: 'btn.outline.selectedBg',
        boxShadow: `${theme === null || theme === void 0 ? void 0 : theme.shadows.btn.outline.selectedShadow}`,
        borderColor: 'btn.outline.selectedBorder'
      },
      '&:disabled': {
        color: 'btn.outline.disabledText',
        backgroundColor: 'btn.outline.disabledBg',
        borderColor: 'btn.border',
        '[data-component=ButtonCounter]': {
          backgroundColor: 'btn.outline.disabledCounterBg',
          color: 'inherit'
        }
      },
      '[data-component=ButtonCounter]': {
        backgroundColor: 'btn.outline.counterBg',
        color: 'btn.outline.text'
      },
      '&[aria-expanded=true]': {
        color: 'btn.outline.selectedText',
        backgroundColor: 'btn.outline.selectedBg',
        boxShadow: `${theme === null || theme === void 0 ? void 0 : theme.shadows.btn.outline.selectedShadow}`,
        borderColor: 'btn.outline.selectedBorder'
      }
    }
  };
  return style[variant];
};

/* The button heights have to amount to 
  small - 28
  medium - 32
  large - 34
  In icon these have to be square.
*/
const getSizeStyles = (size = 'medium', variant = 'default', iconOnly) => {
  let paddingY, paddingX, fontSize;
  switch (size) {
    case 'small':
      paddingY = 3;
      paddingX = 12;
      fontSize = 0;
      break;
    case 'large':
      paddingY = 9;
      paddingX = 20;
      fontSize = 2;
      break;
    case 'medium':
    default:
      paddingY = 5;
      paddingX = 16;
      fontSize = 1;
  }
  if (iconOnly) {
    // when `size !== 'medium'`, vertical alignment of the icon is thrown off
    // because changing the font size draws an em-box that does not match the
    // bounding box of the SVG
    fontSize = 1;
    paddingX = paddingY + 3; // to make it a square
  }

  if (variant === 'invisible') {
    paddingY = paddingY + 1; // to make up for absence of border
  }

  return {
    paddingY: `${paddingY}px`,
    paddingX: `${paddingX}px`,
    fontSize,
    '[data-component=ButtonCounter]': {
      fontSize
    }
  };
};
const getBaseStyles = theme => ({
  borderRadius: '2',
  border: '1px solid',
  borderColor: theme === null || theme === void 0 ? void 0 : theme.colors.btn.border,
  fontFamily: 'inherit',
  fontWeight: 'bold',
  lineHeight: TEXT_ROW_HEIGHT,
  whiteSpace: 'nowrap',
  verticalAlign: 'middle',
  cursor: 'pointer',
  appearance: 'none',
  userSelect: 'none',
  textDecoration: 'none',
  textAlign: 'center',
  '&:disabled': {
    cursor: 'default'
  },
  '&:disabled svg': {
    opacity: '0.6'
  },
  '@media (forced-colors: active)': {
    '&:focus': {
      // Support for Windows high contrast https://sarahmhigley.com/writing/whcm-quick-tips
      outline: 'solid 1px transparent'
    }
  }
});
const getButtonStyles = theme => {
  const styles = {
    ...getBaseStyles(theme),
    display: 'grid',
    gridTemplateAreas: '"leadingIcon text trailingIcon"',
    '& > :not(:last-child)': {
      mr: '2'
    },
    '[data-component="leadingIcon"]': {
      gridArea: 'leadingIcon'
    },
    '[data-component="text"]': {
      gridArea: 'text'
    },
    '[data-component="trailingIcon"]': {
      gridArea: 'trailingIcon'
    }
  };
  return styles;
};




/***/ }),

/***/ "../../../node_modules/@primer/react/lib-esm/Button/types.js":
/*!*******************************************************************!*\
  !*** ../../../node_modules/@primer/react/lib-esm/Button/types.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "StyledButton": () => (/* binding */ StyledButton)
/* harmony export */ });
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _sx_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../sx.js */ "../../../node_modules/@primer/react/lib-esm/sx.js");
/* harmony import */ var _getGlobalFocusStyles_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../_getGlobalFocusStyles.js */ "../../../node_modules/@primer/react/lib-esm/_getGlobalFocusStyles.js");




const StyledButton = styled_components__WEBPACK_IMPORTED_MODULE_0___default().button.withConfig({
  displayName: "types__StyledButton",
  componentId: "sc-ws60qy-0"
})(["", ";", ";"], (0,_getGlobalFocusStyles_js__WEBPACK_IMPORTED_MODULE_1__["default"])('-2px'), _sx_js__WEBPACK_IMPORTED_MODULE_2__["default"]);




/***/ }),

/***/ "../../../node_modules/@primer/react/lib-esm/CounterLabel.js":
/*!*******************************************************************!*\
  !*** ../../../node_modules/@primer/react/lib-esm/CounterLabel.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ CounterLabel$1)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Box_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Box.js */ "../../../node_modules/@primer/react/lib-esm/Box.js");
/* harmony import */ var _VisuallyHidden_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./_VisuallyHidden.js */ "../../../node_modules/@primer/react/lib-esm/_VisuallyHidden.js");
/* harmony import */ var deepmerge__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! deepmerge */ "../../../node_modules/deepmerge/dist/cjs.js");
/* harmony import */ var deepmerge__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(deepmerge__WEBPACK_IMPORTED_MODULE_1__);






function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const CounterLabel = ({
  scheme = 'secondary',
  sx = {},
  children,
  ...props
}) => {
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_2__["default"], _extends({
    as: "span",
    "aria-hidden": "true",
    sx: deepmerge__WEBPACK_IMPORTED_MODULE_1___default()({
      display: 'inline-block',
      padding: '2px 5px',
      fontSize: 0,
      fontWeight: 'bold',
      lineHeight: 'condensedUltra',
      borderRadius: '20px',
      backgroundColor: scheme === 'primary' ? 'neutral.emphasis' : 'neutral.muted',
      color: scheme === 'primary' ? 'fg.onEmphasis' : 'fg.default',
      '&:empty': {
        display: 'none'
      }
    }, sx)
  }, props), children), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_VisuallyHidden_js__WEBPACK_IMPORTED_MODULE_3__["default"], null, "\xA0", `(${children})`));
};
CounterLabel.displayName = 'CounterLabel';
var CounterLabel$1 = CounterLabel;




/***/ }),

/***/ "../../../node_modules/@primer/react/lib-esm/Dialog/ConfirmationDialog.js":
/*!********************************************************************************!*\
  !*** ../../../node_modules/@primer/react/lib-esm/Dialog/ConfirmationDialog.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ConfirmationDialog": () => (/* binding */ ConfirmationDialog),
/* harmony export */   "useConfirm": () => (/* binding */ useConfirm)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-dom */ "webpack/sharing/consume/default/react-dom");
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_dom__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _Box_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Box.js */ "../../../node_modules/@primer/react/lib-esm/Box.js");
/* harmony import */ var _ThemeProvider_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../ThemeProvider.js */ "../../../node_modules/@primer/react/lib-esm/ThemeProvider.js");
/* harmony import */ var _primer_behaviors__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @primer/behaviors */ "../../../node_modules/@primer/behaviors/dist/esm/focus-zone.js");
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../constants.js */ "../../../node_modules/@primer/react/lib-esm/constants.js");
/* harmony import */ var _Dialog_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./Dialog.js */ "../../../node_modules/@primer/react/lib-esm/Dialog/Dialog.js");
/* harmony import */ var _hooks_useFocusZone_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../hooks/useFocusZone.js */ "../../../node_modules/@primer/react/lib-esm/hooks/useFocusZone.js");










function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

/**
 * Props to customize the ConfirmationDialog.
 */

const StyledConfirmationHeader = styled_components__WEBPACK_IMPORTED_MODULE_2___default().div.withConfig({
  displayName: "ConfirmationDialog__StyledConfirmationHeader",
  componentId: "sc-vurs1e-0"
})(["padding:", ";display:flex;flex-direction:row;"], (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('space.2'));
const StyledTitle = styled_components__WEBPACK_IMPORTED_MODULE_2___default()(_Box_js__WEBPACK_IMPORTED_MODULE_4__["default"]).attrs({
  as: 'h1'
}).withConfig({
  displayName: "ConfirmationDialog__StyledTitle",
  componentId: "sc-vurs1e-1"
})(["font-size:", ";font-weight:", ";padding:6px ", ";flex-grow:1;margin:0;"], (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('fontSizes.3'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('fontWeights.bold'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('space.2'));
const ConfirmationHeader = ({
  title,
  onClose,
  dialogLabelId
}) => {
  const onCloseClick = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(() => {
    onClose('close-button');
  }, [onClose]);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(StyledConfirmationHeader, null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(StyledTitle, {
    id: dialogLabelId
  }, title), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Dialog_js__WEBPACK_IMPORTED_MODULE_5__.Dialog.CloseButton, {
    onClose: onCloseClick
  }));
};
ConfirmationHeader.displayName = "ConfirmationHeader";
const StyledConfirmationBody = styled_components__WEBPACK_IMPORTED_MODULE_2___default()(_Box_js__WEBPACK_IMPORTED_MODULE_4__["default"]).withConfig({
  displayName: "ConfirmationDialog__StyledConfirmationBody",
  componentId: "sc-vurs1e-2"
})(["font-size:", ";padding:0 ", " ", " ", ";color:", ";flex-grow:1;"], (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('fontSizes.1'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('space.3'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('space.3'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('space.3'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.fg.muted'));
const ConfirmationBody = ({
  children
}) => {
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(StyledConfirmationBody, null, children);
};
ConfirmationBody.displayName = "ConfirmationBody";
const StyledConfirmationFooter = styled_components__WEBPACK_IMPORTED_MODULE_2___default()(_Box_js__WEBPACK_IMPORTED_MODULE_4__["default"]).withConfig({
  displayName: "ConfirmationDialog__StyledConfirmationFooter",
  componentId: "sc-vurs1e-3"
})(["display:grid;grid-auto-flow:column;grid-auto-columns:max-content;grid-gap:", ";align-items:end;justify-content:end;padding:", " ", " ", ";"], (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('space.2'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('space.1'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('space.3'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('space.3'));
const ConfirmationFooter = ({
  footerButtons
}) => {
  const {
    containerRef: footerRef
  } = (0,_hooks_useFocusZone_js__WEBPACK_IMPORTED_MODULE_6__.useFocusZone)({
    bindKeys: _primer_behaviors__WEBPACK_IMPORTED_MODULE_7__.FocusKeys.ArrowHorizontal | _primer_behaviors__WEBPACK_IMPORTED_MODULE_7__.FocusKeys.Tab,
    focusInStrategy: 'closest'
  });
  // Must have exactly 2 buttons!
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(StyledConfirmationFooter, {
    ref: footerRef
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Dialog_js__WEBPACK_IMPORTED_MODULE_5__.Dialog.Buttons, {
    buttons: footerButtons !== null && footerButtons !== void 0 ? footerButtons : []
  }));
};
ConfirmationFooter.displayName = "ConfirmationFooter";
/**
 * A ConfirmationDialog is a special kind of dialog with more rigid behavior. It
 * is used to confirm a user action. ConfirmationDialogs always have exactly
 * two buttons: one to cancel the action and one to confirm it. No custom
 * rendering capabilities are provided for ConfirmationDialog.
 */
const ConfirmationDialog = props => {
  const {
    onClose,
    title,
    cancelButtonContent = 'Cancel',
    confirmButtonContent = 'OK',
    confirmButtonType = 'normal',
    children
  } = props;
  const onCancelButtonClick = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(() => {
    onClose('cancel');
  }, [onClose]);
  const onConfirmButtonClick = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(() => {
    onClose('confirm');
  }, [onClose]);
  const isConfirmationDangerous = confirmButtonType === 'danger';
  const cancelButton = {
    content: cancelButtonContent,
    onClick: onCancelButtonClick,
    autoFocus: isConfirmationDangerous
  };
  const confirmButton = {
    content: confirmButtonContent,
    buttonType: confirmButtonType,
    onClick: onConfirmButtonClick,
    autoFocus: !isConfirmationDangerous
  };
  const footerButtons = [cancelButton, confirmButton];
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Dialog_js__WEBPACK_IMPORTED_MODULE_5__.Dialog, {
    onClose: onClose,
    title: title,
    footerButtons: footerButtons,
    role: "alertdialog",
    width: "medium",
    renderHeader: ConfirmationHeader,
    renderBody: ConfirmationBody,
    renderFooter: ConfirmationFooter
  }, children);
};
ConfirmationDialog.displayName = "ConfirmationDialog";
async function confirm(themeProps, options) {
  const {
    content,
    ...confirmationDialogProps
  } = options;
  return new Promise(resolve => {
    const hostElement = document.createElement('div');
    const onClose = gesture => {
      react_dom__WEBPACK_IMPORTED_MODULE_1___default().unmountComponentAtNode(hostElement);
      if (gesture === 'confirm') {
        resolve(true);
      } else {
        resolve(false);
      }
    };
    react_dom__WEBPACK_IMPORTED_MODULE_1___default().render( /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_ThemeProvider_js__WEBPACK_IMPORTED_MODULE_8__.ThemeProvider, themeProps, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(ConfirmationDialog, _extends({}, confirmationDialogProps, {
      onClose: onClose
    }), content)), hostElement);
  });
}

/**
 * This hook takes no parameters and returns an `async` function, `confirm`. When `confirm`
 * is called, it shows the confirmation dialog. When the dialog is dismissed, a promise is
 * resolved with `true` or `false` depending on whether or not the confirm button was used.
 */
function useConfirm() {
  const {
    theme,
    colorMode,
    dayScheme,
    nightScheme
  } = (0,_ThemeProvider_js__WEBPACK_IMPORTED_MODULE_8__.useTheme)();
  const result = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(options => {
    const themeProps = {
      theme,
      colorMode,
      dayScheme,
      nightScheme
    };
    return confirm(themeProps, options);
  }, [theme, colorMode, dayScheme, nightScheme]);
  return result;
}




/***/ }),

/***/ "../../../node_modules/@primer/react/lib-esm/Dialog/Dialog.js":
/*!********************************************************************!*\
  !*** ../../../node_modules/@primer/react/lib-esm/Dialog/Dialog.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Dialog": () => (/* binding */ Dialog)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Box_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Box.js */ "../../../node_modules/@primer/react/lib-esm/Box.js");
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../constants.js */ "../../../node_modules/@primer/react/lib-esm/constants.js");
/* harmony import */ var _hooks_useFocusTrap_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../hooks/useFocusTrap.js */ "../../../node_modules/@primer/react/lib-esm/hooks/useFocusTrap.js");
/* harmony import */ var _sx_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../sx.js */ "../../../node_modules/@primer/react/lib-esm/sx.js");
/* harmony import */ var _StyledOcticon_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../StyledOcticon.js */ "../../../node_modules/@primer/react/lib-esm/StyledOcticon.js");
/* harmony import */ var _primer_octicons_react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @primer/octicons-react */ "webpack/sharing/consume/default/@primer/octicons-react/@primer/octicons-react?1c16");
/* harmony import */ var _primer_octicons_react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_primer_octicons_react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _hooks_useFocusZone_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../hooks/useFocusZone.js */ "../../../node_modules/@primer/react/lib-esm/hooks/useFocusZone.js");
/* harmony import */ var _primer_behaviors__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @primer/behaviors */ "../../../node_modules/@primer/behaviors/dist/esm/focus-zone.js");
/* harmony import */ var _Portal_index_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../Portal/index.js */ "../../../node_modules/@primer/react/lib-esm/Portal/index.js");
/* harmony import */ var _hooks_useRefObjectAsForwardedRef_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../hooks/useRefObjectAsForwardedRef.js */ "../../../node_modules/@primer/react/lib-esm/hooks/useRefObjectAsForwardedRef.js");
/* harmony import */ var _hooks_useId_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../hooks/useId.js */ "../../../node_modules/@primer/react/lib-esm/hooks/useId.js");
/* harmony import */ var _deprecated_Button_Button_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../deprecated/Button/Button.js */ "../../../node_modules/@primer/react/lib-esm/deprecated/Button/Button.js");
/* harmony import */ var _hooks_useOnEscapePress_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../hooks/useOnEscapePress.js */ "../../../node_modules/@primer/react/lib-esm/hooks/useOnEscapePress.js");
/* harmony import */ var _hooks_useProvidedRefOrCreate_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../hooks/useProvidedRefOrCreate.js */ "../../../node_modules/@primer/react/lib-esm/hooks/useProvidedRefOrCreate.js");
/* harmony import */ var _deprecated_Button_ButtonPrimary_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../deprecated/Button/ButtonPrimary.js */ "../../../node_modules/@primer/react/lib-esm/deprecated/Button/ButtonPrimary.js");
/* harmony import */ var _deprecated_Button_ButtonDanger_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../deprecated/Button/ButtonDanger.js */ "../../../node_modules/@primer/react/lib-esm/deprecated/Button/ButtonDanger.js");



















function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const ANIMATION_DURATION = '200ms';

/**
 * Props that characterize a button to be rendered into the footer of
 * a Dialog.
 */

const Backdrop = styled_components__WEBPACK_IMPORTED_MODULE_1___default()('div').withConfig({
  displayName: "Dialog__Backdrop",
  componentId: "sc-uaxjsn-0"
})(["position:fixed;top:0;left:0;bottom:0;right:0;display:flex;align-items:center;justify-content:center;background-color:rgba(0,0,0,0.4);animation:dialog-backdrop-appear ", " ", ";@keyframes dialog-backdrop-appear{0%{opacity:0;}100%{opacity:1;}}"], ANIMATION_DURATION, (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('animation.easeOutCubic'));
const heightMap = {
  small: '480px',
  large: '640px',
  auto: 'auto'
};
const widthMap = {
  small: '296px',
  medium: '320px',
  large: '480px',
  xlarge: '640px'
};
const StyledDialog = styled_components__WEBPACK_IMPORTED_MODULE_1___default().div.withConfig({
  displayName: "Dialog__StyledDialog",
  componentId: "sc-uaxjsn-1"
})(["display:flex;flex-direction:column;background-color:", ";box-shadow:", ";min-width:296px;max-width:calc(100vw - 64px);max-height:calc(100vh - 64px);width:", ";height:", ";border-radius:12px;opacity:1;animation:overlay--dialog-appear ", " ", ";@keyframes overlay--dialog-appear{0%{opacity:0;transform:scale(0.5);}100%{opacity:1;transform:scale(1);}}", ";"], (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.canvas.overlay'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('shadows.overlay.shadow'), props => {
  var _props$width;
  return widthMap[(_props$width = props.width) !== null && _props$width !== void 0 ? _props$width : 'xlarge'];
}, props => {
  var _props$height;
  return heightMap[(_props$height = props.height) !== null && _props$height !== void 0 ? _props$height : 'auto'];
}, ANIMATION_DURATION, (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('animation.easeOutCubic'), _sx_js__WEBPACK_IMPORTED_MODULE_4__["default"]);
const DefaultHeader = ({
  dialogLabelId,
  title,
  subtitle,
  dialogDescriptionId,
  onClose
}) => {
  const onCloseClick = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(() => {
    onClose('close-button');
  }, [onClose]);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(Dialog.Header, null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_5__["default"], {
    display: "flex"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_5__["default"], {
    display: "flex",
    px: 2,
    py: "6px",
    flexDirection: "column",
    flexGrow: 1
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(Dialog.Title, {
    id: dialogLabelId
  }, title !== null && title !== void 0 ? title : 'Dialog'), subtitle && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(Dialog.Subtitle, {
    id: dialogDescriptionId
  }, subtitle)), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(Dialog.CloseButton, {
    onClose: onCloseClick
  })));
};
DefaultHeader.displayName = "DefaultHeader";
const DefaultBody = ({
  children
}) => {
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(Dialog.Body, null, children);
};
DefaultBody.displayName = "DefaultBody";
const DefaultFooter = ({
  footerButtons
}) => {
  const {
    containerRef: footerRef
  } = (0,_hooks_useFocusZone_js__WEBPACK_IMPORTED_MODULE_6__.useFocusZone)({
    bindKeys: _primer_behaviors__WEBPACK_IMPORTED_MODULE_7__.FocusKeys.ArrowHorizontal | _primer_behaviors__WEBPACK_IMPORTED_MODULE_7__.FocusKeys.Tab,
    focusInStrategy: 'closest'
  });
  return footerButtons ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(Dialog.Footer, {
    ref: footerRef
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(Dialog.Buttons, {
    buttons: footerButtons
  })) : null;
};
const _Dialog = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().forwardRef((props, forwardedRef) => {
  const {
    title = 'Dialog',
    subtitle = '',
    renderHeader,
    renderBody,
    renderFooter,
    onClose,
    role = 'dialog',
    width = 'xlarge',
    height = 'auto',
    footerButtons = [],
    sx
  } = props;
  const dialogLabelId = (0,_hooks_useId_js__WEBPACK_IMPORTED_MODULE_8__.useId)();
  const dialogDescriptionId = (0,_hooks_useId_js__WEBPACK_IMPORTED_MODULE_8__.useId)();
  const autoFocusedFooterButtonRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
  for (const footerButton of footerButtons) {
    if (footerButton.autoFocus) {
      footerButton.ref = autoFocusedFooterButtonRef;
    }
  }
  const defaultedProps = {
    ...props,
    title,
    subtitle,
    role,
    dialogLabelId,
    dialogDescriptionId
  };
  const dialogRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
  (0,_hooks_useRefObjectAsForwardedRef_js__WEBPACK_IMPORTED_MODULE_9__.useRefObjectAsForwardedRef)(forwardedRef, dialogRef);
  const backdropRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
  (0,_hooks_useFocusTrap_js__WEBPACK_IMPORTED_MODULE_10__.useFocusTrap)({
    containerRef: dialogRef,
    restoreFocusOnCleanUp: true,
    initialFocusRef: autoFocusedFooterButtonRef
  });
  (0,_hooks_useOnEscapePress_js__WEBPACK_IMPORTED_MODULE_11__.useOnEscapePress)(event => {
    onClose('escape');
    event.preventDefault();
  }, [onClose]);
  const header = (renderHeader !== null && renderHeader !== void 0 ? renderHeader : DefaultHeader)(defaultedProps);
  const body = (renderBody !== null && renderBody !== void 0 ? renderBody : DefaultBody)(defaultedProps);
  const footer = (renderFooter !== null && renderFooter !== void 0 ? renderFooter : DefaultFooter)(defaultedProps);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Portal_index_js__WEBPACK_IMPORTED_MODULE_12__["default"], null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(Backdrop, {
    ref: backdropRef
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(StyledDialog, {
    width: width,
    height: height,
    ref: dialogRef,
    role: role,
    "aria-labelledby": dialogLabelId,
    "aria-describedby": dialogDescriptionId,
    sx: sx
  }, header, body, footer))));
});
_Dialog.displayName = 'Dialog';
const Header = styled_components__WEBPACK_IMPORTED_MODULE_1___default().div.withConfig({
  displayName: "Dialog__Header",
  componentId: "sc-uaxjsn-2"
})(["box-shadow:0 1px 0 ", ";padding:", ";z-index:1;flex-shrink:0;"], (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.border.default'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('space.2'));
const Title = styled_components__WEBPACK_IMPORTED_MODULE_1___default().h1.withConfig({
  displayName: "Dialog__Title",
  componentId: "sc-uaxjsn-3"
})(["font-size:", ";font-weight:", ";margin:0;", ";"], (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('fontSizes.1'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('fontWeights.bold'), _sx_js__WEBPACK_IMPORTED_MODULE_4__["default"]);
const Subtitle = styled_components__WEBPACK_IMPORTED_MODULE_1___default().h2.withConfig({
  displayName: "Dialog__Subtitle",
  componentId: "sc-uaxjsn-4"
})(["font-size:", ";color:", ";margin:0;margin-top:", ";", ";"], (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('fontSizes.0'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.fg.muted'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('space.1'), _sx_js__WEBPACK_IMPORTED_MODULE_4__["default"]);
const Body = styled_components__WEBPACK_IMPORTED_MODULE_1___default().div.withConfig({
  displayName: "Dialog__Body",
  componentId: "sc-uaxjsn-5"
})(["flex-grow:1;overflow:auto;padding:", ";", ";"], (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('space.3'), _sx_js__WEBPACK_IMPORTED_MODULE_4__["default"]);
const Footer = styled_components__WEBPACK_IMPORTED_MODULE_1___default().div.withConfig({
  displayName: "Dialog__Footer",
  componentId: "sc-uaxjsn-6"
})(["box-shadow:0 -1px 0 ", ";padding:", ";display:flex;flex-flow:wrap;justify-content:flex-end;z-index:1;flex-shrink:0;button{margin-left:", ";&:first-child{margin-left:0;}}", ";"], (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.border.default'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('space.3'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('space.1'), _sx_js__WEBPACK_IMPORTED_MODULE_4__["default"]);
const buttonTypes = {
  normal: _deprecated_Button_Button_js__WEBPACK_IMPORTED_MODULE_13__["default"],
  primary: _deprecated_Button_ButtonPrimary_js__WEBPACK_IMPORTED_MODULE_14__["default"],
  danger: _deprecated_Button_ButtonDanger_js__WEBPACK_IMPORTED_MODULE_15__["default"]
};
const Buttons = ({
  buttons
}) => {
  var _buttons$find;
  const autoFocusRef = (0,_hooks_useProvidedRefOrCreate_js__WEBPACK_IMPORTED_MODULE_16__.useProvidedRefOrCreate)((_buttons$find = buttons.find(button => button.autoFocus)) === null || _buttons$find === void 0 ? void 0 : _buttons$find.ref);
  let autoFocusCount = 0;
  const [hasRendered, setHasRendered] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(0);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    // hack to work around dialogs originating from other focus traps.
    if (hasRendered === 1) {
      var _autoFocusRef$current;
      (_autoFocusRef$current = autoFocusRef.current) === null || _autoFocusRef$current === void 0 ? void 0 : _autoFocusRef$current.focus();
    } else {
      setHasRendered(hasRendered + 1);
    }
  }, [autoFocusRef, hasRendered]);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, buttons.map((dialogButtonProps, index) => {
    const {
      content,
      buttonType = 'normal',
      autoFocus = false,
      ...buttonProps
    } = dialogButtonProps;
    const ButtonElement = buttonTypes[buttonType];
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(ButtonElement, _extends({
      key: index
    }, buttonProps, {
      variant: buttonType,
      ref: autoFocus && autoFocusCount === 0 ? (autoFocusCount++, autoFocusRef) : null
    }), content);
  }));
};
const DialogCloseButton = styled_components__WEBPACK_IMPORTED_MODULE_1___default()(_deprecated_Button_Button_js__WEBPACK_IMPORTED_MODULE_13__["default"]).withConfig({
  displayName: "Dialog__DialogCloseButton",
  componentId: "sc-uaxjsn-7"
})(["border-radius:4px;background:transparent;border:0;vertical-align:middle;color:", ";padding:", ";align-self:flex-start;line-height:normal;box-shadow:none;"], (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('colors.fg.muted'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_3__.get)('space.2'));
const CloseButton = ({
  onClose
}) => {
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(DialogCloseButton, {
    "aria-label": "Close",
    onClick: onClose
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_StyledOcticon_js__WEBPACK_IMPORTED_MODULE_17__["default"], {
    icon: _primer_octicons_react__WEBPACK_IMPORTED_MODULE_2__.XIcon
  }));
};
CloseButton.displayName = "CloseButton";
/**
 * A dialog is a type of overlay that can be used for confirming actions, asking
 * for disambiguation, and presenting small forms. They generally allow the user
 * to focus on a quick task without having to navigate to a different page.
 *
 * Dialogs appear in the page after a direct user interaction. Don't show dialogs
 * on page load or as system alerts.
 *
 * Dialogs appear centered in the page, with a visible backdrop that dims the rest
 * of the window for focus.
 *
 * All dialogs have a title and a close button.
 *
 * Dialogs are modal. Dialogs can be dismissed by clicking on the close button,
 * pressing the escape key, or by interacting with another button in the dialog.
 * To avoid losing information and missing important messages, clicking outside
 * of the dialog will not close it.
 *
 * The sub components provided (e.g. Header, Title, etc.) are available for custom
 * renderers only. They are not intended to be used otherwise.
 */
const Dialog = Object.assign(_Dialog, {
  Header,
  Title,
  Subtitle,
  Body,
  Footer,
  Buttons,
  CloseButton
});




/***/ }),

/***/ "../../../node_modules/@primer/react/lib-esm/Link.js":
/*!***********************************************************!*\
  !*** ../../../node_modules/@primer/react/lib-esm/Link.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Link$1)
/* harmony export */ });
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var styled_system__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! styled-system */ "../../../node_modules/styled-system/dist/index.esm.js");
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./constants.js */ "../../../node_modules/@primer/react/lib-esm/constants.js");
/* harmony import */ var _sx_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./sx.js */ "../../../node_modules/@primer/react/lib-esm/sx.js");





const hoverColor = (0,styled_system__WEBPACK_IMPORTED_MODULE_1__.system)({
  hoverColor: {
    property: 'color',
    scale: 'colors'
  }
});
const Link = styled_components__WEBPACK_IMPORTED_MODULE_0___default().a.withConfig({
  displayName: "Link",
  componentId: "sc-hrxz1n-0"
})(["color:", ";text-decoration:", ";&:hover{text-decoration:", ";", ";}&:is(button){display:inline-block;padding:0;font-size:inherit;white-space:nowrap;cursor:pointer;user-select:none;background-color:transparent;border:0;appearance:none;}", ";"], props => props.muted ? (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('colors.fg.muted')(props) : (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('colors.accent.fg')(props), props => props.underline ? 'underline' : 'none', props => props.muted ? 'none' : 'underline', props => props.hoverColor ? hoverColor : props.muted ? `color: ${(0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('colors.accent.fg')(props)}` : '', _sx_js__WEBPACK_IMPORTED_MODULE_3__["default"]);
var Link$1 = Link;




/***/ }),

/***/ "../../../node_modules/@primer/react/lib-esm/Portal/Portal.js":
/*!********************************************************************!*\
  !*** ../../../node_modules/@primer/react/lib-esm/Portal/Portal.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Portal": () => (/* binding */ Portal),
/* harmony export */   "registerPortalRoot": () => (/* binding */ registerPortalRoot)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-dom */ "webpack/sharing/consume/default/react-dom");
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_dom__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _utils_useIsomorphicLayoutEffect_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/useIsomorphicLayoutEffect.js */ "../../../node_modules/@primer/react/lib-esm/utils/useIsomorphicLayoutEffect.js");




const PRIMER_PORTAL_ROOT_ID = '__primerPortalRoot__';
const DEFAULT_PORTAL_CONTAINER_NAME = '__default__';
const portalRootRegistry = {};

/**
 * Register a container to serve as a portal root.
 * @param root The element that will be the root for portals created in this container
 * @param name The name of the container, to be used with the `containerName` prop on the Portal Component.
 * If name is not specified, registers the default portal root.
 */
function registerPortalRoot(root, name = DEFAULT_PORTAL_CONTAINER_NAME) {
  portalRootRegistry[name] = root;
}

// Ensures that a default portal root exists and is registered. If a DOM element exists
// with id __primerPortalRoot__, allow that element to serve as the default portal root.
// Otherwise, create that element and attach it to the end of document.body.
function ensureDefaultPortal() {
  const existingDefaultPortalContainer = portalRootRegistry[DEFAULT_PORTAL_CONTAINER_NAME];
  if (!existingDefaultPortalContainer || !document.body.contains(existingDefaultPortalContainer)) {
    let defaultPortalContainer = document.getElementById(PRIMER_PORTAL_ROOT_ID);
    if (!(defaultPortalContainer instanceof Element)) {
      defaultPortalContainer = document.createElement('div');
      defaultPortalContainer.setAttribute('id', PRIMER_PORTAL_ROOT_ID);
      defaultPortalContainer.style.position = 'absolute';
      defaultPortalContainer.style.top = '0';
      defaultPortalContainer.style.left = '0';
      const suitablePortalRoot = document.querySelector('[data-portal-root]');
      if (suitablePortalRoot) {
        suitablePortalRoot.appendChild(defaultPortalContainer);
      } else {
        document.body.appendChild(defaultPortalContainer);
      }
    }
    registerPortalRoot(defaultPortalContainer);
  }
}
/**
 * Creates a React Portal, placing all children in a separate physical DOM root node.
 * @see https://reactjs.org/docs/portals.html
 */
const Portal = ({
  children,
  onMount,
  containerName: _containerName
}) => {
  const hostElement = document.createElement('div');

  // Portaled content should get their own stacking context so they don't interfere
  // with each other in unexpected ways. One should never find themselves tempted
  // to change the zIndex to a value other than "1".
  hostElement.style.position = 'relative';
  hostElement.style.zIndex = '1';
  const elementRef = react__WEBPACK_IMPORTED_MODULE_0___default().useRef(hostElement);
  (0,_utils_useIsomorphicLayoutEffect_js__WEBPACK_IMPORTED_MODULE_2__["default"])(() => {
    let containerName = _containerName;
    if (containerName === undefined) {
      containerName = DEFAULT_PORTAL_CONTAINER_NAME;
      ensureDefaultPortal();
    }
    const parentElement = portalRootRegistry[containerName];
    if (!parentElement) {
      throw new Error(`Portal container '${_containerName}' is not yet registered. Container must be registered with registerPortal before use.`);
    }
    const element = elementRef.current;
    parentElement.appendChild(element);
    onMount === null || onMount === void 0 ? void 0 : onMount();
    return () => {
      parentElement.removeChild(element);
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [elementRef]);
  return /*#__PURE__*/(0,react_dom__WEBPACK_IMPORTED_MODULE_1__.createPortal)(children, elementRef.current);
};




/***/ }),

/***/ "../../../node_modules/@primer/react/lib-esm/Portal/index.js":
/*!*******************************************************************!*\
  !*** ../../../node_modules/@primer/react/lib-esm/Portal/index.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Portal),
/* harmony export */   "registerPortalRoot": () => (/* reexport safe */ _Portal_js__WEBPACK_IMPORTED_MODULE_0__.registerPortalRoot)
/* harmony export */ });
/* harmony import */ var _Portal_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Portal.js */ "../../../node_modules/@primer/react/lib-esm/Portal/Portal.js");



var Portal = _Portal_js__WEBPACK_IMPORTED_MODULE_0__.Portal;




/***/ }),

/***/ "../../../node_modules/@primer/react/lib-esm/Spinner.js":
/*!**************************************************************!*\
  !*** ../../../node_modules/@primer/react/lib-esm/Spinner.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Spinner$1)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _sx_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./sx.js */ "../../../node_modules/@primer/react/lib-esm/sx.js");




function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const sizeMap = {
  small: '16px',
  medium: '32px',
  large: '64px'
};
function Spinner({
  size: sizeKey = 'medium',
  ...props
}) {
  const size = sizeMap[sizeKey];
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", _extends({
    height: size,
    width: size,
    viewBox: "0 0 16 16",
    fill: "none"
  }, props), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("circle", {
    cx: "8",
    cy: "8",
    r: "7",
    stroke: "currentColor",
    strokeOpacity: "0.25",
    strokeWidth: "2",
    vectorEffect: "non-scaling-stroke"
  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", {
    d: "M15 8a7.002 7.002 0 00-7-7",
    stroke: "currentColor",
    strokeWidth: "2",
    strokeLinecap: "round",
    vectorEffect: "non-scaling-stroke"
  }));
}
Spinner.displayName = "Spinner";
const StyledSpinner = styled_components__WEBPACK_IMPORTED_MODULE_1___default()(Spinner).withConfig({
  displayName: "Spinner__StyledSpinner",
  componentId: "sc-1dxfx1i-0"
})(["@keyframes rotate-keyframes{100%{transform:rotate(360deg);}}animation:rotate-keyframes 1s linear infinite;", ""], _sx_js__WEBPACK_IMPORTED_MODULE_2__["default"]);
StyledSpinner.displayName = 'Spinner';
var Spinner$1 = StyledSpinner;




/***/ }),

/***/ "../../../node_modules/@primer/react/lib-esm/StyledOcticon.js":
/*!********************************************************************!*\
  !*** ../../../node_modules/@primer/react/lib-esm/StyledOcticon.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ StyledOcticon$1)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _sx_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./sx.js */ "../../../node_modules/@primer/react/lib-esm/sx.js");




function Octicon({
  icon: IconComponent,
  ...rest
}) {
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(IconComponent, rest);
}
Octicon.displayName = "Octicon";
const StyledOcticon = styled_components__WEBPACK_IMPORTED_MODULE_1___default()(Octicon).withConfig({
  displayName: "StyledOcticon",
  componentId: "sc-1lhyyr-0"
})(["", ""], ({
  color,
  sx: sxProp
}) => (0,_sx_js__WEBPACK_IMPORTED_MODULE_2__["default"])({
  sx: {
    color,
    ...sxProp
  }
}));
var StyledOcticon$1 = StyledOcticon;




/***/ }),

/***/ "../../../node_modules/@primer/react/lib-esm/Text.js":
/*!***********************************************************!*\
  !*** ../../../node_modules/@primer/react/lib-esm/Text.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Text$1)
/* harmony export */ });
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constants.js */ "../../../node_modules/@primer/react/lib-esm/constants.js");
/* harmony import */ var _sx_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./sx.js */ "../../../node_modules/@primer/react/lib-esm/sx.js");




const Text = styled_components__WEBPACK_IMPORTED_MODULE_0___default().span.withConfig({
  displayName: "Text",
  componentId: "sc-125xb1i-0"
})(["", ";", ";", ";"], _constants_js__WEBPACK_IMPORTED_MODULE_1__.TYPOGRAPHY, _constants_js__WEBPACK_IMPORTED_MODULE_1__.COMMON, _sx_js__WEBPACK_IMPORTED_MODULE_2__["default"]);
var Text$1 = Text;




/***/ }),

/***/ "../../../node_modules/@primer/react/lib-esm/ThemeProvider.js":
/*!********************************************************************!*\
  !*** ../../../node_modules/@primer/react/lib-esm/ThemeProvider.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ThemeProvider": () => (/* binding */ ThemeProvider),
/* harmony export */   "default": () => (/* binding */ ThemeProvider$1),
/* harmony export */   "useColorSchemeVar": () => (/* binding */ useColorSchemeVar),
/* harmony export */   "useTheme": () => (/* binding */ useTheme)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-dom */ "webpack/sharing/consume/default/react-dom");
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_dom__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _theme_preval_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./theme-preval.js */ "../../../node_modules/@primer/react/lib-esm/theme-preval.js");
/* harmony import */ var deepmerge__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! deepmerge */ "../../../node_modules/deepmerge/dist/cjs.js");
/* harmony import */ var deepmerge__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(deepmerge__WEBPACK_IMPORTED_MODULE_3__);






const defaultColorMode = 'day';
const defaultDayScheme = 'light';
const defaultNightScheme = 'dark';

// eslint-disable-next-line @typescript-eslint/no-explicit-any

const ThemeContext = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createContext({
  setColorMode: () => null,
  setDayScheme: () => null,
  setNightScheme: () => null
});

// inspired from __NEXT_DATA__, we use application/json to avoid CSRF policy with inline scripts
const getServerHandoff = () => {
  try {
    var _document$getElementB;
    const serverData = (_document$getElementB = document.getElementById('__PRIMER_DATA__')) === null || _document$getElementB === void 0 ? void 0 : _document$getElementB.textContent;
    if (serverData) return JSON.parse(serverData);
  } catch (error) {
    // if document/element does not exist or JSON is invalid, supress error
  }
  return {};
};
const ThemeProvider = ({
  children,
  ...props
}) => {
  var _ref, _props$theme, _ref2, _props$colorMode, _ref3, _props$dayScheme, _ref4, _props$nightScheme;
  // Get fallback values from parent ThemeProvider (if exists)
  const {
    theme: fallbackTheme,
    colorMode: fallbackColorMode,
    dayScheme: fallbackDayScheme,
    nightScheme: fallbackNightScheme
  } = useTheme();

  // Initialize state
  const theme$1 = (_ref = (_props$theme = props.theme) !== null && _props$theme !== void 0 ? _props$theme : fallbackTheme) !== null && _ref !== void 0 ? _ref : _theme_preval_js__WEBPACK_IMPORTED_MODULE_4__["default"];
  const {
    resolvedServerColorMode
  } = getServerHandoff();
  const resolvedColorModePassthrough = react__WEBPACK_IMPORTED_MODULE_0___default().useRef(resolvedServerColorMode);
  const [colorMode, setColorMode] = react__WEBPACK_IMPORTED_MODULE_0___default().useState((_ref2 = (_props$colorMode = props.colorMode) !== null && _props$colorMode !== void 0 ? _props$colorMode : fallbackColorMode) !== null && _ref2 !== void 0 ? _ref2 : defaultColorMode);
  const [dayScheme, setDayScheme] = react__WEBPACK_IMPORTED_MODULE_0___default().useState((_ref3 = (_props$dayScheme = props.dayScheme) !== null && _props$dayScheme !== void 0 ? _props$dayScheme : fallbackDayScheme) !== null && _ref3 !== void 0 ? _ref3 : defaultDayScheme);
  const [nightScheme, setNightScheme] = react__WEBPACK_IMPORTED_MODULE_0___default().useState((_ref4 = (_props$nightScheme = props.nightScheme) !== null && _props$nightScheme !== void 0 ? _props$nightScheme : fallbackNightScheme) !== null && _ref4 !== void 0 ? _ref4 : defaultNightScheme);
  const systemColorMode = useSystemColorMode();
  const resolvedColorMode = resolvedColorModePassthrough.current || resolveColorMode(colorMode, systemColorMode);
  const colorScheme = chooseColorScheme(resolvedColorMode, dayScheme, nightScheme);
  const {
    resolvedTheme,
    resolvedColorScheme
  } = react__WEBPACK_IMPORTED_MODULE_0___default().useMemo(() => applyColorScheme(theme$1, colorScheme), [theme$1, colorScheme]);

  // this effect will only run on client
  react__WEBPACK_IMPORTED_MODULE_0___default().useEffect(function updateColorModeAfterServerPassthrough() {
    const resolvedColorModeOnClient = resolveColorMode(colorMode, systemColorMode);
    if (resolvedColorModePassthrough.current) {
      // if the resolved color mode passed on from the server is not the resolved color mode on client, change it!
      if (resolvedColorModePassthrough.current !== resolvedColorModeOnClient) {
        window.setTimeout(() => {
          // use ReactDOM.flushSync to prevent automatic batching of state updates since React 18
          // ref: https://github.com/reactwg/react-18/discussions/21
          react_dom__WEBPACK_IMPORTED_MODULE_1___default().flushSync(() => {
            // override colorMode to whatever is resolved on the client to get a re-render
            setColorMode(resolvedColorModeOnClient);
          });

          // immediately after that, set the colorMode to what the user passed to respond to system color mode changes
          setColorMode(colorMode);
        });
      }
      resolvedColorModePassthrough.current = null;
    }
  }, [colorMode, systemColorMode]);

  // Update state if props change
  react__WEBPACK_IMPORTED_MODULE_0___default().useEffect(() => {
    var _ref5, _props$colorMode2;
    setColorMode((_ref5 = (_props$colorMode2 = props.colorMode) !== null && _props$colorMode2 !== void 0 ? _props$colorMode2 : fallbackColorMode) !== null && _ref5 !== void 0 ? _ref5 : defaultColorMode);
  }, [props.colorMode, fallbackColorMode]);
  react__WEBPACK_IMPORTED_MODULE_0___default().useEffect(() => {
    var _ref6, _props$dayScheme2;
    setDayScheme((_ref6 = (_props$dayScheme2 = props.dayScheme) !== null && _props$dayScheme2 !== void 0 ? _props$dayScheme2 : fallbackDayScheme) !== null && _ref6 !== void 0 ? _ref6 : defaultDayScheme);
  }, [props.dayScheme, fallbackDayScheme]);
  react__WEBPACK_IMPORTED_MODULE_0___default().useEffect(() => {
    var _ref7, _props$nightScheme2;
    setNightScheme((_ref7 = (_props$nightScheme2 = props.nightScheme) !== null && _props$nightScheme2 !== void 0 ? _props$nightScheme2 : fallbackNightScheme) !== null && _ref7 !== void 0 ? _ref7 : defaultNightScheme);
  }, [props.nightScheme, fallbackNightScheme]);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(ThemeContext.Provider, {
    value: {
      theme: resolvedTheme,
      colorScheme,
      colorMode,
      resolvedColorMode,
      resolvedColorScheme,
      dayScheme,
      nightScheme,
      setColorMode,
      setDayScheme,
      setNightScheme
    }
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(styled_components__WEBPACK_IMPORTED_MODULE_2__.ThemeProvider, {
    theme: resolvedTheme
  }, children, props.preventSSRMismatch ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("script", {
    type: "application/json",
    id: "__PRIMER_DATA__",
    dangerouslySetInnerHTML: {
      __html: JSON.stringify({
        resolvedServerColorMode: resolvedColorMode
      })
    }
  }) : null));
};
ThemeProvider.displayName = "ThemeProvider";
function useTheme() {
  return react__WEBPACK_IMPORTED_MODULE_0___default().useContext(ThemeContext);
}
function useColorSchemeVar(values, fallback) {
  var _values$colorScheme;
  const {
    colorScheme = ''
  } = useTheme();
  return (_values$colorScheme = values[colorScheme]) !== null && _values$colorScheme !== void 0 ? _values$colorScheme : fallback;
}
function useSystemColorMode() {
  const [systemColorMode, setSystemColorMode] = react__WEBPACK_IMPORTED_MODULE_0___default().useState(getSystemColorMode);
  react__WEBPACK_IMPORTED_MODULE_0___default().useEffect(() => {
    var _window, _window$matchMedia;
    // eslint-disable-next-line @typescript-eslint/no-unnecessary-condition
    const media = (_window = window) === null || _window === void 0 ? void 0 : (_window$matchMedia = _window.matchMedia) === null || _window$matchMedia === void 0 ? void 0 : _window$matchMedia.call(_window, '(prefers-color-scheme: dark)');
    function handleChange(event) {
      const isNight = event.matches;
      setSystemColorMode(isNight ? 'night' : 'day');
    }

    // eslint-disable-next-line @typescript-eslint/no-unnecessary-condition
    if (media) {
      // eslint-disable-next-line @typescript-eslint/no-unnecessary-condition
      if (media.addEventListener !== undefined) {
        media.addEventListener('change', handleChange);
        return function cleanup() {
          media.removeEventListener('change', handleChange);
        };
      }
      // eslint-disable-next-line @typescript-eslint/no-unnecessary-condition
      else if (media.addListener !== undefined) {
        media.addListener(handleChange);
        return function cleanup() {
          media.removeListener(handleChange);
        };
      }
    }
  }, []);
  return systemColorMode;
}
function getSystemColorMode() {
  var _window$matchMedia2, _window2, _window$matchMedia2$c;
  // eslint-disable-next-line @typescript-eslint/no-unnecessary-condition
  if (typeof window !== 'undefined' && (_window$matchMedia2 = (_window2 = window).matchMedia) !== null && _window$matchMedia2 !== void 0 && (_window$matchMedia2$c = _window$matchMedia2.call(_window2, '(prefers-color-scheme: dark)')) !== null && _window$matchMedia2$c !== void 0 && _window$matchMedia2$c.matches) {
    return 'night';
  }
  return 'day';
}
function resolveColorMode(colorMode, systemColorMode) {
  switch (colorMode) {
    case 'auto':
      return systemColorMode;
    default:
      return colorMode;
  }
}
function chooseColorScheme(colorMode, dayScheme, nightScheme) {
  switch (colorMode) {
    case 'day':
    case 'light':
      return dayScheme;
    case 'dark':
    case 'night':
      return nightScheme;
  }
}
function applyColorScheme(theme, colorScheme) {
  if (!theme.colorSchemes) {
    return {
      resolvedTheme: theme,
      resolvedColorScheme: undefined
    };
  }
  if (!theme.colorSchemes[colorScheme]) {
    // eslint-disable-next-line no-console
    console.error(`\`${colorScheme}\` scheme not defined in \`theme.colorSchemes\``);

    // Apply the first defined color scheme
    const defaultColorScheme = Object.keys(theme.colorSchemes)[0];
    return {
      resolvedTheme: deepmerge__WEBPACK_IMPORTED_MODULE_3___default()(theme, theme.colorSchemes[defaultColorScheme]),
      resolvedColorScheme: defaultColorScheme
    };
  }
  return {
    resolvedTheme: deepmerge__WEBPACK_IMPORTED_MODULE_3___default()(theme, theme.colorSchemes[colorScheme]),
    resolvedColorScheme: colorScheme
  };
}
var ThemeProvider$1 = ThemeProvider;




/***/ }),

/***/ "../../../node_modules/@primer/react/lib-esm/Truncate.js":
/*!***************************************************************!*\
  !*** ../../../node_modules/@primer/react/lib-esm/Truncate.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Truncate$1)
/* harmony export */ });
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var styled_system__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! styled-system */ "../../../node_modules/styled-system/dist/index.esm.js");
/* harmony import */ var _sx_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./sx.js */ "../../../node_modules/@primer/react/lib-esm/sx.js");




const Truncate = styled_components__WEBPACK_IMPORTED_MODULE_0___default().div.withConfig({
  displayName: "Truncate",
  componentId: "sc-1d9305p-0"
})(["display:", ";overflow:hidden;text-overflow:ellipsis;vertical-align:", ";white-space:nowrap;", " ", " ", ";"], props => props.inline ? 'inline-block' : 'inherit', props => props.inline ? 'top' : 'initial', styled_system__WEBPACK_IMPORTED_MODULE_1__.maxWidth, props => props.expandable ? `&:hover { max-width: 10000px; }` : '', _sx_js__WEBPACK_IMPORTED_MODULE_2__["default"]);

// TODO: Remove defaultProps to be compatible with the next major version of React
// Reference: https://github.com/primer/react/issues/2758
Truncate.defaultProps = {
  expandable: false,
  inline: false,
  maxWidth: 125
};
var Truncate$1 = Truncate;




/***/ }),

/***/ "../../../node_modules/@primer/react/lib-esm/UnderlineNav2/LoadingCounter.js":
/*!***********************************************************************************!*\
  !*** ../../../node_modules/@primer/react/lib-esm/UnderlineNav2/LoadingCounter.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "LoadingCounter": () => (/* binding */ LoadingCounter)
/* harmony export */ });
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../constants.js */ "../../../node_modules/@primer/react/lib-esm/constants.js");



const loading = (0,styled_components__WEBPACK_IMPORTED_MODULE_0__.keyframes)(["from{opacity:1;}to{opacity:0.2;}"]);
const LoadingCounter = styled_components__WEBPACK_IMPORTED_MODULE_0___default().span.withConfig({
  displayName: "LoadingCounter",
  componentId: "sc-ouonic-0"
})(["animation:", " 1.2s ease-in-out infinite alternate;background-color:", ";border-color:", ";width:1.5rem;height:1rem;display:inline-block;border-radius:20px;"], loading, (0,_constants_js__WEBPACK_IMPORTED_MODULE_1__.get)('colors.neutral.muted'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_1__.get)('colors.border.default'));




/***/ }),

/***/ "../../../node_modules/@primer/react/lib-esm/UnderlineNav2/UnderlineNav.js":
/*!*********************************************************************************!*\
  !*** ../../../node_modules/@primer/react/lib-esm/UnderlineNav2/UnderlineNav.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "UnderlineNav": () => (/* binding */ UnderlineNav)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Box_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../Box.js */ "../../../node_modules/@primer/react/lib-esm/Box.js");
/* harmony import */ var _sx_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../sx.js */ "../../../node_modules/@primer/react/lib-esm/sx.js");
/* harmony import */ var _UnderlineNavContext_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./UnderlineNavContext.js */ "../../../node_modules/@primer/react/lib-esm/UnderlineNav2/UnderlineNavContext.js");
/* harmony import */ var _hooks_useResizeObserver_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../hooks/useResizeObserver.js */ "../../../node_modules/@primer/react/lib-esm/hooks/useResizeObserver.js");
/* harmony import */ var _CounterLabel_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../CounterLabel.js */ "../../../node_modules/@primer/react/lib-esm/CounterLabel.js");
/* harmony import */ var _ThemeProvider_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../ThemeProvider.js */ "../../../node_modules/@primer/react/lib-esm/ThemeProvider.js");
/* harmony import */ var _VisuallyHidden_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../_VisuallyHidden.js */ "../../../node_modules/@primer/react/lib-esm/_VisuallyHidden.js");
/* harmony import */ var _styles_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./styles.js */ "../../../node_modules/@primer/react/lib-esm/UnderlineNav2/styles.js");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _LoadingCounter_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./LoadingCounter.js */ "../../../node_modules/@primer/react/lib-esm/UnderlineNav2/LoadingCounter.js");
/* harmony import */ var _Button_index_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../Button/index.js */ "../../../node_modules/@primer/react/lib-esm/Button/index.js");
/* harmony import */ var _primer_octicons_react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @primer/octicons-react */ "webpack/sharing/consume/default/@primer/octicons-react/@primer/octicons-react?1c16");
/* harmony import */ var _primer_octicons_react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_primer_octicons_react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _hooks_useOnEscapePress_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../hooks/useOnEscapePress.js */ "../../../node_modules/@primer/react/lib-esm/hooks/useOnEscapePress.js");
/* harmony import */ var _hooks_useOnOutsideClick_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../hooks/useOnOutsideClick.js */ "../../../node_modules/@primer/react/lib-esm/hooks/useOnOutsideClick.js");
/* harmony import */ var _hooks_useId_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../hooks/useId.js */ "../../../node_modules/@primer/react/lib-esm/hooks/useId.js");
/* harmony import */ var _ActionList_index_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../ActionList/index.js */ "../../../node_modules/@primer/react/lib-esm/ActionList/index.js");
/* harmony import */ var _utils_defaultSxProp_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../utils/defaultSxProp.js */ "../../../node_modules/@primer/react/lib-esm/utils/defaultSxProp.js");
/* harmony import */ var deepmerge__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! deepmerge */ "../../../node_modules/deepmerge/dist/cjs.js");
/* harmony import */ var deepmerge__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(deepmerge__WEBPACK_IMPORTED_MODULE_3__);




















function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
// When page is loaded, we don't have ref for the more button as it is not on the DOM yet.
// However, we need to calculate number of possible items when the more button present as well. So using the width of the more button as a constant.
const MORE_BTN_WIDTH = 86;

// Needed this because passing a ref using HTMLULListElement to `Box` causes a type error
const NavigationList = styled_components__WEBPACK_IMPORTED_MODULE_1___default().ul.withConfig({
  displayName: "UnderlineNav__NavigationList",
  componentId: "sc-3wwkh2-0"
})(["", ";"], _sx_js__WEBPACK_IMPORTED_MODULE_4__["default"]);
const MoreMenuListItem = styled_components__WEBPACK_IMPORTED_MODULE_1___default().li.withConfig({
  displayName: "UnderlineNav__MoreMenuListItem",
  componentId: "sc-3wwkh2-1"
})(["display:flex;"]);
const overflowEffect = (navWidth, moreMenuWidth, childArray, childWidthArray, noIconChildWidthArray, updateListAndMenu) => {
  let iconsVisible = true;
  if (childWidthArray.length === 0) {
    updateListAndMenu({
      items: childArray,
      actions: []
    }, iconsVisible);
  }
  const numberOfItemsPossible = calculatePossibleItems(childWidthArray, navWidth);
  const numberOfItemsWithoutIconPossible = calculatePossibleItems(noIconChildWidthArray, navWidth);
  // We need to take more menu width into account when calculating the number of items possible
  const numberOfItemsPossibleWithMoreMenu = calculatePossibleItems(noIconChildWidthArray, navWidth, moreMenuWidth || MORE_BTN_WIDTH);
  const items = [];
  const actions = [];

  // First, we check if we can fit all the items with their icons
  if (childArray.length <= numberOfItemsPossible) {
    items.push(...childArray);
  } else if (childArray.length <= numberOfItemsWithoutIconPossible) {
    // if we can't fit all the items with their icons, we check if we can fit all the items without their icons
    iconsVisible = false;
    items.push(...childArray);
  } else {
    // if we can't fit all the items without their icons, we keep the icons hidden and show the ones that doesn't fit into the list in the overflow menu
    iconsVisible = false;

    /* Below is an accessibiility requirement. Never show only one item in the overflow menu.
     * If there is only one item left to display in the overflow menu according to the calculation,
     * we need to pull another item from the list into the overflow menu.
     */
    const numberOfItemsInMenu = childArray.length - numberOfItemsPossibleWithMoreMenu;
    const numberOfListItems = numberOfItemsInMenu === 1 ? numberOfItemsPossibleWithMoreMenu - 1 : numberOfItemsPossibleWithMoreMenu;
    for (const [index, child] of childArray.entries()) {
      if (index < numberOfListItems) {
        items.push(child);
      } else {
        const ariaCurrent = child.props['aria-current'];
        const isCurrent = Boolean(ariaCurrent) && ariaCurrent !== 'false';
        // We need to make sure to keep the selected item always visible.
        if (isCurrent) {
          // If selected item couldn't make in to the list, we swap it with the last item in the list.
          const indexToReplaceAt = numberOfListItems - 1; // because we are replacing the last item in the list
          // splice method modifies the array by removing 1 item here at the given index and replace it with the "child" element then returns the removed item.
          const propsectiveAction = items.splice(indexToReplaceAt, 1, child)[0];
          actions.push(propsectiveAction);
        } else {
          actions.push(child);
        }
      }
    }
  }
  updateListAndMenu({
    items,
    actions
  }, iconsVisible);
};
const getValidChildren = children => {
  return react__WEBPACK_IMPORTED_MODULE_0___default().Children.toArray(children).filter(child => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().isValidElement(child));
};
const calculatePossibleItems = (childWidthArray, navWidth, moreMenuWidth = 0) => {
  const widthToFit = navWidth - moreMenuWidth;
  let breakpoint = childWidthArray.length - 1;
  let sumsOfChildWidth = 0;
  for (const [index, childWidth] of childWidthArray.entries()) {
    if (sumsOfChildWidth > widthToFit) {
      breakpoint = index - 1;
      break;
    } else {
      // The the gap between items into account when calculating the number of items possible
      sumsOfChildWidth = sumsOfChildWidth + childWidth.width + _styles_js__WEBPACK_IMPORTED_MODULE_5__.GAP;
    }
  }
  return breakpoint;
};
const UnderlineNav = /*#__PURE__*/(0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)(({
  as = 'nav',
  align,
  'aria-label': ariaLabel,
  sx: sxProp = _utils_defaultSxProp_js__WEBPACK_IMPORTED_MODULE_6__.defaultSxProp,
  afterSelect,
  variant = 'default',
  loadingCounters = false,
  children
}, forwardedRef) => {
  const backupRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
  const navRef = forwardedRef !== null && forwardedRef !== void 0 ? forwardedRef : backupRef;
  const listRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
  const moreMenuRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
  const moreMenuBtnRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
  const containerRef = react__WEBPACK_IMPORTED_MODULE_0___default().useRef(null);
  const disclosureWidgetId = (0,_hooks_useId_js__WEBPACK_IMPORTED_MODULE_7__.useId)();
  const {
    theme
  } = (0,_ThemeProvider_js__WEBPACK_IMPORTED_MODULE_8__.useTheme)();
  function getItemsWidth(itemText) {
    var _noIconChildWidthArra;
    return ((_noIconChildWidthArra = noIconChildWidthArray.find(item => item.text === itemText)) === null || _noIconChildWidthArra === void 0 ? void 0 : _noIconChildWidthArra.width) || 0;
  }
  const swapMenuItemWithListItem = (prospectiveListItem, indexOfProspectiveListItem, event, callback) => {
    var _listRef$current;
    // get the selected menu item's width
    const widthToFitIntoList = getItemsWidth(prospectiveListItem.props.children);
    // Check if there is any empty space on the right side of the list
    const availableSpace = navRef.current.getBoundingClientRect().width - (((_listRef$current = listRef.current) === null || _listRef$current === void 0 ? void 0 : _listRef$current.getBoundingClientRect().width) || 0);

    // Calculate how many items need to be pulled in to the menu to make room for the selected menu item
    // I.e. if we need to pull 2 items in (index 0 and index 1), breakpoint (index) will return 1.
    const index = getBreakpointForItemSwapping(widthToFitIntoList, availableSpace);
    const indexToSliceAt = responsiveProps.items.length - 1 - index;
    // Form the new list of items
    const itemsLeftInList = [...responsiveProps.items].slice(0, indexToSliceAt);
    const updatedItemList = [...itemsLeftInList, prospectiveListItem];
    // Form the new menu items
    const itemsToAddToMenu = [...responsiveProps.items].slice(indexToSliceAt);
    const updatedMenuItems = [...actions];
    // Add itemsToAddToMenu array's items to the menu at the index of the prospectiveListItem and remove 1 count of items (prospectiveListItem)
    updatedMenuItems.splice(indexOfProspectiveListItem, 1, ...itemsToAddToMenu);
    setSelectedLinkText(prospectiveListItem.props.children);
    callback({
      items: updatedItemList,
      actions: updatedMenuItems
    }, false);
  };
  // How many items do we need to pull in to the menu to make room for the selected menu item.
  function getBreakpointForItemSwapping(widthToFitIntoList, availableSpace) {
    let widthToSwap = 0;
    let breakpoint = 0;
    for (const [index, item] of [...responsiveProps.items].reverse().entries()) {
      widthToSwap += getItemsWidth(item.props.children);
      if (widthToFitIntoList < widthToSwap + availableSpace) {
        breakpoint = index;
        break;
      }
    }
    return breakpoint;
  }
  const [selectedLink, setSelectedLink] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(undefined);

  // selectedLinkText is needed to be able set the selected menu item as selectedLink.
  // This is needed because setSelectedLink only accepts ref but at the time of setting selected menu item as selectedLink, its ref as a list item is not available
  const [selectedLinkText, setSelectedLinkText] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)('');
  // Capture the mouse/keyboard event when a menu item is selected so that we can use it to fire the onSelect callback after the menu item is swapped with the list item
  const [selectEvent, setSelectEvent] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(null);
  const [iconsVisible, setIconsVisible] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(true);
  const afterSelectHandler = event => {
    if (!event.defaultPrevented) {
      if (typeof afterSelect === 'function') afterSelect(event);
      closeOverlay();
    }
  };
  const [responsiveProps, setResponsiveProps] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)({
    items: getValidChildren(children),
    actions: []
  });

  /*
   * This is needed to make sure responsiveProps.items and ResponsiveProps.actions are updated when children are changed
   * Particually when an item is selected. It adds 'aria-current="page"' attribute to the child and we need to make sure
   * responsiveProps.items and ResponsiveProps.actions are updated with that attribute
   */
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    const childArray = getValidChildren(children);
    const updatedItems = responsiveProps.items.map(item => {
      return childArray.find(child => child.key === item.key) || item;
    });
    const updatedActions = responsiveProps.actions.map(action => {
      return childArray.find(child => child.key === action.key) || action;
    });
    setResponsiveProps({
      items: updatedItems,
      actions: updatedActions
    });
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [children]);
  const updateListAndMenu = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)((props, displayIcons) => {
    setResponsiveProps(props);
    setIconsVisible(displayIcons);
  }, []);
  const actions = responsiveProps.actions;
  const [childWidthArray, setChildWidthArray] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)([]);
  const setChildrenWidth = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(size => {
    setChildWidthArray(arr => {
      const newArr = [...arr, size];
      return newArr;
    });
  }, []);
  const [noIconChildWidthArray, setNoIconChildWidthArray] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)([]);
  const setNoIconChildrenWidth = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(size => {
    setNoIconChildWidthArray(arr => {
      const newArr = [...arr, size];
      return newArr;
    });
  }, []);
  (0,_hooks_useResizeObserver_js__WEBPACK_IMPORTED_MODULE_9__.useResizeObserver)(resizeObserverEntries => {
    var _moreMenuRef$current$, _moreMenuRef$current;
    const childArray = getValidChildren(children);
    const navWidth = resizeObserverEntries[0].contentRect.width;
    const moreMenuWidth = (_moreMenuRef$current$ = (_moreMenuRef$current = moreMenuRef.current) === null || _moreMenuRef$current === void 0 ? void 0 : _moreMenuRef$current.getBoundingClientRect().width) !== null && _moreMenuRef$current$ !== void 0 ? _moreMenuRef$current$ : 0;
    navWidth !== 0 && overflowEffect(navWidth, moreMenuWidth, childArray, childWidthArray, noIconChildWidthArray, updateListAndMenu);
  }, navRef);
  if (!ariaLabel) {
    // eslint-disable-next-line no-console
    console.warn('Use the `aria-label` prop to provide an accessible label for assistive technology');
  }
  const [isWidgetOpen, setIsWidgetOpen] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
  const closeOverlay = react__WEBPACK_IMPORTED_MODULE_0___default().useCallback(() => {
    setIsWidgetOpen(false);
  }, [setIsWidgetOpen]);
  const focusOnMoreMenuBtn = react__WEBPACK_IMPORTED_MODULE_0___default().useCallback(() => {
    var _moreMenuBtnRef$curre;
    (_moreMenuBtnRef$curre = moreMenuBtnRef.current) === null || _moreMenuBtnRef$curre === void 0 ? void 0 : _moreMenuBtnRef$curre.focus();
  }, []);
  (0,_hooks_useOnEscapePress_js__WEBPACK_IMPORTED_MODULE_10__.useOnEscapePress)(event => {
    if (isWidgetOpen) {
      event.preventDefault();
      closeOverlay();
      focusOnMoreMenuBtn();
    }
  }, [isWidgetOpen]);
  (0,_hooks_useOnOutsideClick_js__WEBPACK_IMPORTED_MODULE_11__.useOnOutsideClick)({
    onClickOutside: closeOverlay,
    containerRef,
    ignoreClickRefs: [moreMenuBtnRef]
  });
  const onAnchorClick = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(event => {
    if (event.defaultPrevented || event.button !== 0) {
      return;
    }
    setIsWidgetOpen(isWidgetOpen => !isWidgetOpen);
  }, []);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_UnderlineNavContext_js__WEBPACK_IMPORTED_MODULE_12__.UnderlineNavContext.Provider, {
    value: {
      theme,
      setChildrenWidth,
      setNoIconChildrenWidth,
      selectedLink,
      setSelectedLink,
      selectedLinkText,
      setSelectedLinkText,
      selectEvent,
      afterSelect: afterSelectHandler,
      variant,
      loadingCounters,
      iconsVisible
    }
  }, ariaLabel && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_VisuallyHidden_js__WEBPACK_IMPORTED_MODULE_13__["default"], {
    as: "h2"
  }, `${ariaLabel} navigation`), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_14__["default"], {
    as: as,
    sx: deepmerge__WEBPACK_IMPORTED_MODULE_3___default()((0,_styles_js__WEBPACK_IMPORTED_MODULE_5__.getNavStyles)(theme, {
      align
    }), sxProp),
    "aria-label": ariaLabel,
    ref: navRef
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(NavigationList, {
    sx: _styles_js__WEBPACK_IMPORTED_MODULE_5__.ulStyles,
    ref: listRef,
    role: "list"
  }, responsiveProps.items, actions.length > 0 && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(MoreMenuListItem, {
    ref: moreMenuRef
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_14__["default"], {
    sx: (0,_styles_js__WEBPACK_IMPORTED_MODULE_5__.getDividerStyle)(theme)
  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Button_index_js__WEBPACK_IMPORTED_MODULE_15__.Button, {
    ref: moreMenuBtnRef,
    sx: _styles_js__WEBPACK_IMPORTED_MODULE_5__.moreBtnStyles,
    "aria-controls": disclosureWidgetId,
    "aria-expanded": isWidgetOpen,
    onClick: onAnchorClick,
    trailingIcon: _primer_octicons_react__WEBPACK_IMPORTED_MODULE_2__.TriangleDownIcon
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_14__["default"], {
    as: "span"
  }, "More", /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_VisuallyHidden_js__WEBPACK_IMPORTED_MODULE_13__["default"], {
    as: "span"
  }, "\xA0", `${ariaLabel} items`))), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_ActionList_index_js__WEBPACK_IMPORTED_MODULE_16__.ActionList, {
    selectionVariant: "single",
    ref: containerRef,
    id: disclosureWidgetId,
    sx: _styles_js__WEBPACK_IMPORTED_MODULE_5__.menuStyles,
    style: {
      display: isWidgetOpen ? 'block' : 'none'
    }
  }, actions.map((action, index) => {
    const {
      children: actionElementChildren,
      ...actionElementProps
    } = action.props;
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_14__["default"], {
      key: actionElementChildren,
      as: "li"
    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_ActionList_index_js__WEBPACK_IMPORTED_MODULE_16__.ActionList.Item, _extends({}, actionElementProps, {
      as: action.props.as || 'a',
      sx: _styles_js__WEBPACK_IMPORTED_MODULE_5__.menuItemStyles,
      onSelect: event => {
        swapMenuItemWithListItem(action, index, event, updateListAndMenu);
        setSelectEvent(event);
        closeOverlay();
        focusOnMoreMenuBtn();
      }
    }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_14__["default"], {
      as: "span",
      sx: {
        display: 'flex',
        alignItems: 'center',
        justifyContent: 'space-between'
      }
    }, actionElementChildren, loadingCounters ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_LoadingCounter_js__WEBPACK_IMPORTED_MODULE_17__.LoadingCounter, null) : actionElementProps.counter !== undefined && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_14__["default"], {
      as: "span",
      "data-component": "counter"
    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_CounterLabel_js__WEBPACK_IMPORTED_MODULE_18__["default"], null, actionElementProps.counter)))));
  }))))));
});
UnderlineNav.displayName = 'UnderlineNav';




/***/ }),

/***/ "../../../node_modules/@primer/react/lib-esm/UnderlineNav2/UnderlineNavContext.js":
/*!****************************************************************************************!*\
  !*** ../../../node_modules/@primer/react/lib-esm/UnderlineNav2/UnderlineNavContext.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "UnderlineNavContext": () => (/* binding */ UnderlineNavContext)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);


const UnderlineNavContext = /*#__PURE__*/(0,react__WEBPACK_IMPORTED_MODULE_0__.createContext)({
  theme: {},
  setChildrenWidth: () => null,
  setNoIconChildrenWidth: () => null,
  selectedLink: undefined,
  setSelectedLink: () => null,
  selectedLinkText: '',
  setSelectedLinkText: () => null,
  selectEvent: null,
  variant: 'default',
  loadingCounters: false,
  iconsVisible: true
});




/***/ }),

/***/ "../../../node_modules/@primer/react/lib-esm/UnderlineNav2/UnderlineNavItem.js":
/*!*************************************************************************************!*\
  !*** ../../../node_modules/@primer/react/lib-esm/UnderlineNav2/UnderlineNavItem.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "UnderlineNavItem": () => (/* binding */ UnderlineNavItem)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Box_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Box.js */ "../../../node_modules/@primer/react/lib-esm/Box.js");
/* harmony import */ var _UnderlineNavContext_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./UnderlineNavContext.js */ "../../../node_modules/@primer/react/lib-esm/UnderlineNav2/UnderlineNavContext.js");
/* harmony import */ var _CounterLabel_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../CounterLabel.js */ "../../../node_modules/@primer/react/lib-esm/CounterLabel.js");
/* harmony import */ var _styles_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./styles.js */ "../../../node_modules/@primer/react/lib-esm/UnderlineNav2/styles.js");
/* harmony import */ var _LoadingCounter_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./LoadingCounter.js */ "../../../node_modules/@primer/react/lib-esm/UnderlineNav2/LoadingCounter.js");
/* harmony import */ var _utils_useIsomorphicLayoutEffect_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/useIsomorphicLayoutEffect.js */ "../../../node_modules/@primer/react/lib-esm/utils/useIsomorphicLayoutEffect.js");
/* harmony import */ var _utils_defaultSxProp_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/defaultSxProp.js */ "../../../node_modules/@primer/react/lib-esm/utils/defaultSxProp.js");
/* harmony import */ var deepmerge__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! deepmerge */ "../../../node_modules/deepmerge/dist/cjs.js");
/* harmony import */ var deepmerge__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(deepmerge__WEBPACK_IMPORTED_MODULE_1__);











function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

// adopted from React.AnchorHTMLAttributes

const UnderlineNavItem = /*#__PURE__*/(0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)(({
  sx: sxProp = _utils_defaultSxProp_js__WEBPACK_IMPORTED_MODULE_2__.defaultSxProp,
  as: Component = 'a',
  href = '#',
  children,
  counter,
  onSelect,
  'aria-current': ariaCurrent,
  icon: Icon,
  ...props
}, forwardedRef) => {
  const backupRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
  const ref = forwardedRef !== null && forwardedRef !== void 0 ? forwardedRef : backupRef;
  const {
    theme,
    setChildrenWidth,
    setNoIconChildrenWidth,
    selectedLink,
    setSelectedLink,
    selectedLinkText,
    setSelectedLinkText,
    selectEvent,
    afterSelect,
    variant,
    loadingCounters,
    iconsVisible
  } = (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(_UnderlineNavContext_js__WEBPACK_IMPORTED_MODULE_3__.UnderlineNavContext);
  (0,_utils_useIsomorphicLayoutEffect_js__WEBPACK_IMPORTED_MODULE_4__["default"])(() => {
    if (ref.current) {
      const domRect = ref.current.getBoundingClientRect();
      const icon = Array.from(ref.current.children[0].children).find(child => child.getAttribute('data-component') === 'icon');
      const content = Array.from(ref.current.children[0].children).find(child => child.getAttribute('data-component') === 'text');
      const text = content.textContent;
      const iconWidthWithMargin = icon ? icon.getBoundingClientRect().width + Number(getComputedStyle(icon).marginRight.slice(0, -2)) + Number(getComputedStyle(icon).marginLeft.slice(0, -2)) : 0;
      setChildrenWidth({
        text,
        width: domRect.width
      });
      setNoIconChildrenWidth({
        text,
        width: domRect.width - iconWidthWithMargin
      });
      if (selectedLink === undefined && Boolean(ariaCurrent) && ariaCurrent !== 'false') {
        setSelectedLink(ref);
      }

      // Only runs when a menu item is selected (swapping the menu item with the list item to keep it visible)
      if (selectedLinkText === text) {
        setSelectedLink(ref);
        if (typeof onSelect === 'function' && selectEvent !== null) onSelect(selectEvent);
        setSelectedLinkText('');
      }
    }
  }, [ref, ariaCurrent, selectedLink, selectedLinkText, setSelectedLinkText, setSelectedLink, setChildrenWidth, setNoIconChildrenWidth, onSelect, selectEvent]);
  const keyPressHandler = react__WEBPACK_IMPORTED_MODULE_0___default().useCallback(event => {
    if (event.key === ' ' || event.key === 'Enter') {
      if (!event.defaultPrevented && typeof onSelect === 'function') onSelect(event);
      if (!event.defaultPrevented && typeof afterSelect === 'function') afterSelect(event);
      setSelectedLink(ref);
    }
  }, [onSelect, afterSelect, ref, setSelectedLink]);
  const clickHandler = react__WEBPACK_IMPORTED_MODULE_0___default().useCallback(event => {
    if (!event.defaultPrevented) {
      if (typeof onSelect === 'function') onSelect(event);
      if (typeof afterSelect === 'function') afterSelect(event);
    }
    setSelectedLink(ref);
  }, [onSelect, afterSelect, ref, setSelectedLink]);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_5__["default"], {
    as: "li",
    sx: {
      display: 'flex',
      flexDirection: 'column',
      alignItems: 'center'
    }
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_5__["default"], _extends({
    as: Component,
    href: href,
    onKeyPress: keyPressHandler,
    onClick: clickHandler,
    "aria-current": ariaCurrent,
    sx: deepmerge__WEBPACK_IMPORTED_MODULE_1___default()((0,_styles_js__WEBPACK_IMPORTED_MODULE_6__.getLinkStyles)(theme, {
      variant
    }, selectedLink, ref), sxProp)
  }, props, {
    ref: ref
  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_5__["default"], {
    as: "div",
    "data-component": "wrapper",
    sx: _styles_js__WEBPACK_IMPORTED_MODULE_6__.wrapperStyles
  }, iconsVisible && Icon && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_5__["default"], {
    as: "span",
    "data-component": "icon",
    sx: _styles_js__WEBPACK_IMPORTED_MODULE_6__.iconWrapStyles
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(Icon, null)), children && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_5__["default"], {
    as: "span",
    "data-component": "text",
    "data-content": children,
    sx: selectedLink === ref ? {
      fontWeight: 600
    } : {}
  }, children), loadingCounters ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_5__["default"], {
    as: "span",
    "data-component": "counter",
    sx: _styles_js__WEBPACK_IMPORTED_MODULE_6__.counterStyles
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_LoadingCounter_js__WEBPACK_IMPORTED_MODULE_7__.LoadingCounter, null)) : counter !== undefined && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Box_js__WEBPACK_IMPORTED_MODULE_5__["default"], {
    as: "span",
    "data-component": "counter",
    sx: _styles_js__WEBPACK_IMPORTED_MODULE_6__.counterStyles
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_CounterLabel_js__WEBPACK_IMPORTED_MODULE_8__["default"], null, counter)))));
});
UnderlineNavItem.displayName = 'UnderlineNavItem';




/***/ }),

/***/ "../../../node_modules/@primer/react/lib-esm/UnderlineNav2/index.js":
/*!**************************************************************************!*\
  !*** ../../../node_modules/@primer/react/lib-esm/UnderlineNav2/index.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "UnderlineNav": () => (/* binding */ UnderlineNav)
/* harmony export */ });
/* harmony import */ var _UnderlineNav_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./UnderlineNav.js */ "../../../node_modules/@primer/react/lib-esm/UnderlineNav2/UnderlineNav.js");
/* harmony import */ var _UnderlineNavItem_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./UnderlineNavItem.js */ "../../../node_modules/@primer/react/lib-esm/UnderlineNav2/UnderlineNavItem.js");



const UnderlineNav = Object.assign(_UnderlineNav_js__WEBPACK_IMPORTED_MODULE_0__.UnderlineNav, {
  Item: _UnderlineNavItem_js__WEBPACK_IMPORTED_MODULE_1__.UnderlineNavItem
});




/***/ }),

/***/ "../../../node_modules/@primer/react/lib-esm/UnderlineNav2/styles.js":
/*!***************************************************************************!*\
  !*** ../../../node_modules/@primer/react/lib-esm/UnderlineNav2/styles.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "GAP": () => (/* binding */ GAP),
/* harmony export */   "counterStyles": () => (/* binding */ counterStyles),
/* harmony export */   "getDividerStyle": () => (/* binding */ getDividerStyle),
/* harmony export */   "getLinkStyles": () => (/* binding */ getLinkStyles),
/* harmony export */   "getNavStyles": () => (/* binding */ getNavStyles),
/* harmony export */   "iconWrapStyles": () => (/* binding */ iconWrapStyles),
/* harmony export */   "menuItemStyles": () => (/* binding */ menuItemStyles),
/* harmony export */   "menuStyles": () => (/* binding */ menuStyles),
/* harmony export */   "moreBtnStyles": () => (/* binding */ moreBtnStyles),
/* harmony export */   "ulStyles": () => (/* binding */ ulStyles),
/* harmony export */   "wrapperStyles": () => (/* binding */ wrapperStyles)
/* harmony export */ });
// The gap between the list items. It is a constant because the gap is used to calculate the possible number of items that can fit in the container.
const GAP = 8;
const iconWrapStyles = {
  alignItems: 'center',
  display: 'inline-flex',
  marginRight: 2
};
const wrapperStyles = {
  display: 'inline-flex',
  paddingY: 1,
  paddingX: 2,
  borderRadius: 2
};
const smallVariantLinkStyles = {
  paddingY: 1,
  fontSize: 0
};
const defaultVariantLinkStyles = {
  paddingY: 2,
  fontSize: 1
};
const counterStyles = {
  marginLeft: 2,
  display: 'flex',
  alignItems: 'center'
};
const getNavStyles = (theme, props) => ({
  display: 'flex',
  paddingX: 3,
  justifyContent: (props === null || props === void 0 ? void 0 : props.align) === 'right' ? 'flex-end' : 'flex-start',
  borderBottom: '1px solid',
  borderBottomColor: `${theme === null || theme === void 0 ? void 0 : theme.colors.border.muted}`,
  align: 'row',
  alignItems: 'center'
});
const ulStyles = {
  display: 'flex',
  listStyle: 'none',
  whiteSpace: 'nowrap',
  paddingY: 0,
  paddingX: 0,
  margin: 0,
  marginBottom: '-1px',
  alignItems: 'center',
  gap: `${GAP}px`,
  position: 'relative'
};
const getDividerStyle = theme => ({
  display: 'inline-block',
  borderLeft: '1px solid',
  width: '1px',
  borderLeftColor: `${theme === null || theme === void 0 ? void 0 : theme.colors.border.muted}`,
  marginRight: 1
});
const moreBtnStyles = {
  //set margin 0 here because safari puts extra margin around the button, rest is to reset style to make it look like a list element
  margin: 0,
  border: 0,
  background: 'transparent',
  fontWeight: 'normal',
  boxShadow: 'none',
  paddingY: 1,
  paddingX: 2,
  '& > span[data-component="trailingIcon"]': {
    marginLeft: 0
  }
};
const getLinkStyles = (theme, props, selectedLink, ref) => ({
  position: 'relative',
  display: 'inline-flex',
  color: 'fg.default',
  textAlign: 'center',
  textDecoration: 'none',
  ...((props === null || props === void 0 ? void 0 : props.variant) === 'small' ? smallVariantLinkStyles : defaultVariantLinkStyles),
  '@media (hover:hover)': {
    '&:hover > div[data-component="wrapper"] ': {
      backgroundColor: theme === null || theme === void 0 ? void 0 : theme.colors.neutral.muted,
      transition: 'background .12s ease-out'
    }
  },
  '&:focus': {
    outline: 0,
    '& > div[data-component="wrapper"]': {
      boxShadow: `inset 0 0 0 2px ${theme === null || theme === void 0 ? void 0 : theme.colors.accent.fg}`
    },
    // where focus-visible is supported, remove the focus box-shadow
    '&:not(:focus-visible) > div[data-component="wrapper"]': {
      boxShadow: 'none'
    }
  },
  '&:focus-visible > div[data-component="wrapper"]': {
    boxShadow: `inset 0 0 0 2px ${theme === null || theme === void 0 ? void 0 : theme.colors.accent.fg}`
  },
  // renders a visibly hidden "copy" of the label in bold, reserving box space for when label becomes bold on selected
  '& span[data-content]::before': {
    content: 'attr(data-content)',
    display: 'block',
    height: 0,
    fontWeight: '600',
    visibility: 'hidden',
    whiteSpace: 'nowrap'
  },
  // selected state styles
  '&::after': {
    position: 'absolute',
    right: '50%',
    bottom: 0,
    width: '100%',
    height: 2,
    content: '""',
    bg: selectedLink === ref ? theme === null || theme === void 0 ? void 0 : theme.colors.primer.border.active : 'transparent',
    borderRadius: 0,
    transform: 'translate(50%, -50%)'
  },
  '@media (forced-colors: active)': {
    '::after': {
      // Support for Window Force Color Mode https://learn.microsoft.com/en-us/fluent-ui/web-components/design-system/high-contrast
      bg: selectedLink === ref ? 'LinkText' : 'transparent'
    }
  }
});
const menuItemStyles = {
  // This is needed to hide the selected check icon on the menu item. https://github.com/primer/react/blob/main/src/ActionList/Selection.tsx#L32
  '& > span': {
    display: 'none'
  },
  // To reset the style when the menu items are rendered as react router links
  textDecoration: 'none'
};
const menuStyles = {
  position: 'absolute',
  top: '90%',
  right: '0',
  boxShadow: '0 1px 3px rgba(0, 0, 0, 0.12), 0 1px 2px rgba(0, 0, 0, 0.24)',
  borderRadius: '12px',
  backgroundColor: 'canvas.overlay',
  listStyle: 'none',
  // Values are from ActionMenu
  minWidth: '192px',
  maxWidth: '640px'
};




/***/ }),

/***/ "../../../node_modules/@primer/react/lib-esm/_VisuallyHidden.js":
/*!**********************************************************************!*\
  !*** ../../../node_modules/@primer/react/lib-esm/_VisuallyHidden.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ VisuallyHidden$1)
/* harmony export */ });
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _sx_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./sx.js */ "../../../node_modules/@primer/react/lib-esm/sx.js");



const VisuallyHidden = styled_components__WEBPACK_IMPORTED_MODULE_0___default().span.withConfig({
  displayName: "_VisuallyHidden__VisuallyHidden",
  componentId: "sc-11jhm7a-0"
})(["", ""], ({
  isVisible = false
}) => {
  if (isVisible) {
    return _sx_js__WEBPACK_IMPORTED_MODULE_1__["default"];
  }
  return `
        position: absolute;
        width: 1px;
        height: 1px;
        padding: 0;
        margin: -1px;
        overflow: hidden;
        clip: rect(0, 0, 0, 0);
        white-space: nowrap;
        border-width: 0;
    `;
});
var VisuallyHidden$1 = VisuallyHidden;




/***/ }),

/***/ "../../../node_modules/@primer/react/lib-esm/_getGlobalFocusStyles.js":
/*!****************************************************************************!*\
  !*** ../../../node_modules/@primer/react/lib-esm/_getGlobalFocusStyles.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getGlobalFocusStyles$1)
/* harmony export */ });
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constants.js */ "../../../node_modules/@primer/react/lib-esm/constants.js");



const globalFocusStyle = (0,styled_components__WEBPACK_IMPORTED_MODULE_0__.css)(["box-shadow:none;outline:2px solid ", ";"], (0,_constants_js__WEBPACK_IMPORTED_MODULE_1__.get)('colors.accent.fg'));
const getGlobalFocusStyles = outlineOffset => (0,styled_components__WEBPACK_IMPORTED_MODULE_0__.css)(["&:focus:not(:disabled){", ";outline-offset:", ";&:not(:focus-visible){outline:solid 1px transparent;}}&:focus-visible:not(:disabled){", ";outline-offset:", ";}"], globalFocusStyle, typeof outlineOffset === 'undefined' ? '2px' : outlineOffset, globalFocusStyle, typeof outlineOffset === 'undefined' ? '2px' : outlineOffset);
var getGlobalFocusStyles$1 = getGlobalFocusStyles;




/***/ }),

/***/ "../../../node_modules/@primer/react/lib-esm/constants.js":
/*!****************************************************************!*\
  !*** ../../../node_modules/@primer/react/lib-esm/constants.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BORDER": () => (/* binding */ BORDER),
/* harmony export */   "COMMON": () => (/* binding */ COMMON),
/* harmony export */   "LAYOUT": () => (/* binding */ LAYOUT),
/* harmony export */   "TYPOGRAPHY": () => (/* binding */ TYPOGRAPHY),
/* harmony export */   "get": () => (/* binding */ get)
/* harmony export */ });
/* harmony import */ var _styled_system_theme_get__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @styled-system/theme-get */ "../../../node_modules/@styled-system/theme-get/dist/index.esm.js");
/* harmony import */ var styled_system__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! styled-system */ "../../../node_modules/styled-system/dist/index.esm.js");
/* harmony import */ var _theme_preval_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./theme-preval.js */ "../../../node_modules/@primer/react/lib-esm/theme-preval.js");




const {
  get: getKey,
  compose,
  system
} = styled_system__WEBPACK_IMPORTED_MODULE_1__;
const get = key => (0,_styled_system_theme_get__WEBPACK_IMPORTED_MODULE_0__.themeGet)(key, getKey(_theme_preval_js__WEBPACK_IMPORTED_MODULE_2__["default"], key));

// Common props

const COMMON = compose(styled_system__WEBPACK_IMPORTED_MODULE_1__.space, styled_system__WEBPACK_IMPORTED_MODULE_1__.color, styled_system__WEBPACK_IMPORTED_MODULE_1__.display);
// Typography props

const whiteSpace = system({
  whiteSpace: {
    property: 'whiteSpace'
    // cssProperty: 'whiteSpace',
  }
});

const TYPOGRAPHY = compose(styled_system__WEBPACK_IMPORTED_MODULE_1__.typography, whiteSpace);
// Border props

const BORDER = compose(styled_system__WEBPACK_IMPORTED_MODULE_1__.border, styled_system__WEBPACK_IMPORTED_MODULE_1__.shadow);
// Layout props

const LAYOUT = styled_system__WEBPACK_IMPORTED_MODULE_1__.layout;




/***/ }),

/***/ "../../../node_modules/@primer/react/lib-esm/deprecated/Button/Button.js":
/*!*******************************************************************************!*\
  !*** ../../../node_modules/@primer/react/lib-esm/deprecated/Button/Button.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Button$1)
/* harmony export */ });
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../constants.js */ "../../../node_modules/@primer/react/lib-esm/constants.js");
/* harmony import */ var _sx_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../sx.js */ "../../../node_modules/@primer/react/lib-esm/sx.js");
/* harmony import */ var _ButtonBase_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ButtonBase.js */ "../../../node_modules/@primer/react/lib-esm/deprecated/Button/ButtonBase.js");





/** @deprecated Use the new Label instead. See https://primer.style/react/Button for more details. */
const Button = styled_components__WEBPACK_IMPORTED_MODULE_0___default()(_ButtonBase_js__WEBPACK_IMPORTED_MODULE_1__["default"]).withConfig({
  displayName: "Button",
  componentId: "sc-ybpnzh-0"
})(["color:", ";background-color:", ";border:1px solid ", ";box-shadow:", ",", "};&:hover{background-color:", ";border-color:", ";}&:focus{outline:solid 2px ", ";}&:active{background-color:", ";box-shadow:", ";}&:disabled{color:", ";background-color:", ";border-color:", ";}", ";"], (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('colors.btn.text'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('colors.btn.bg'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('colors.btn.border'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('shadows.btn.shadow'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('shadows.btn.insetShadow'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('colors.btn.hoverBg'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('colors.btn.hoverBorder'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('colors.accent.fg'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('colors.btn.selectedBg'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('shadows.btn.shadowActive'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('colors.primer.fg.disabled'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('colors.btn.bg'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('colors.btn.border'), _sx_js__WEBPACK_IMPORTED_MODULE_3__["default"]);
var Button$1 = Button;




/***/ }),

/***/ "../../../node_modules/@primer/react/lib-esm/deprecated/Button/ButtonBase.js":
/*!***********************************************************************************!*\
  !*** ../../../node_modules/@primer/react/lib-esm/deprecated/Button/ButtonBase.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ButtonBase$1)
/* harmony export */ });
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var styled_system__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! styled-system */ "../../../node_modules/styled-system/dist/index.esm.js");
/* harmony import */ var _ButtonStyles_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./ButtonStyles.js */ "../../../node_modules/@primer/react/lib-esm/deprecated/Button/ButtonStyles.js");




const variants = (0,styled_system__WEBPACK_IMPORTED_MODULE_1__.variant)({
  variants: {
    small: {
      p: '4px 12px',
      fontSize: 0
    },
    medium: {
      fontSize: 1
    },
    large: {
      fontSize: 2,
      p: '10px 20px'
    }
  }
});
const ButtonBase = styled_components__WEBPACK_IMPORTED_MODULE_0___default().button.attrs(({
  disabled,
  onClick
}) => ({
  onClick: disabled ? undefined : onClick
})).withConfig({
  displayName: "ButtonBase",
  componentId: "sc-bqtwic-0"
})(["", " ", ""], _ButtonStyles_js__WEBPACK_IMPORTED_MODULE_2__["default"], variants);
ButtonBase.defaultProps = {
  variant: 'medium'
};
var ButtonBase$1 = ButtonBase;




/***/ }),

/***/ "../../../node_modules/@primer/react/lib-esm/deprecated/Button/ButtonDanger.js":
/*!*************************************************************************************!*\
  !*** ../../../node_modules/@primer/react/lib-esm/deprecated/Button/ButtonDanger.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ButtonDanger$1)
/* harmony export */ });
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../constants.js */ "../../../node_modules/@primer/react/lib-esm/constants.js");
/* harmony import */ var _sx_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../sx.js */ "../../../node_modules/@primer/react/lib-esm/sx.js");
/* harmony import */ var _ButtonBase_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ButtonBase.js */ "../../../node_modules/@primer/react/lib-esm/deprecated/Button/ButtonBase.js");





const ButtonDanger = styled_components__WEBPACK_IMPORTED_MODULE_0___default()(_ButtonBase_js__WEBPACK_IMPORTED_MODULE_1__["default"]).withConfig({
  displayName: "ButtonDanger",
  componentId: "sc-j9bmd7-0"
})(["color:", ";border:1px solid ", ";background-color:", ";box-shadow:", ";&:hover{color:", ";background-color:", ";border-color:", ";box-shadow:", ";}&:focus{border-color:", ";box-shadow:", ";}&:active{color:", ";background-color:", ";box-shadow:", ";border-color:", ";}&:disabled{color:", ";background-color:", ";border-color:", ";}", ";"], (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('colors.btn.danger.text'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('colors.btn.border'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('colors.btn.bg'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('shadows.btn.shadow'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('colors.btn.danger.hoverText'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('colors.btn.danger.hoverBg'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('colors.btn.danger.hoverBorder'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('shadows.btn.danger.hoverShadow'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('colors.btn.danger.focusBorder'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('shadows.btn.danger.focusShadow'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('colors.btn.danger.selectedText'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('colors.btn.danger.selectedBg'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('shadows.btn.danger.selectedShadow'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('colors.btn.danger.selectedBorder'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('colors.btn.danger.disabledText'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('colors.btn.danger.disabledBg'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('colors.btn.danger.disabledBorder'), _sx_js__WEBPACK_IMPORTED_MODULE_3__["default"]);
var ButtonDanger$1 = ButtonDanger;




/***/ }),

/***/ "../../../node_modules/@primer/react/lib-esm/deprecated/Button/ButtonPrimary.js":
/*!**************************************************************************************!*\
  !*** ../../../node_modules/@primer/react/lib-esm/deprecated/Button/ButtonPrimary.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ButtonPrimary": () => (/* binding */ ButtonPrimary),
/* harmony export */   "default": () => (/* binding */ ButtonPrimary$1)
/* harmony export */ });
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../constants.js */ "../../../node_modules/@primer/react/lib-esm/constants.js");
/* harmony import */ var _sx_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../sx.js */ "../../../node_modules/@primer/react/lib-esm/sx.js");
/* harmony import */ var _ButtonBase_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ButtonBase.js */ "../../../node_modules/@primer/react/lib-esm/deprecated/Button/ButtonBase.js");





const ButtonPrimary = styled_components__WEBPACK_IMPORTED_MODULE_0___default()(_ButtonBase_js__WEBPACK_IMPORTED_MODULE_1__["default"]).withConfig({
  displayName: "ButtonPrimary",
  componentId: "sc-1awfvt4-0"
})(["color:", ";border:1px solid ", ";background-color:", ";box-shadow:", ";&:hover{color:", ";background-color:", ";border-color:", ";box-shadow:", ";}&:focus{border-color:", ";box-shadow:", ";}&:active{background-color:", ";box-shadow:", ";}&:disabled{color:", ";background-color:", ";border-color:", ";}", ";"], (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('colors.btn.primary.text'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('colors.btn.primary.border'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('colors.btn.primary.bg'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('shadows.btn.primary.shadow'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('colors.btn.primary.hoverText'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('colors.btn.primary.hoverBg'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('colors.btn.primary.hoverBorder'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('shadows.btn.primary.hoverShadow'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('colors.btn.primary.focusBorder'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('shadows.btn.primary.focusShadow'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('colors.btn.primary.selectedBg'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('shadows.btn.primary.selectedShadow'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('colors.btn.primary.disabledText'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('colors.btn.primary.disabledBg'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_2__.get)('colors.btn.primary.disabledBorder'), _sx_js__WEBPACK_IMPORTED_MODULE_3__["default"]);
var ButtonPrimary$1 = ButtonPrimary;




/***/ }),

/***/ "../../../node_modules/@primer/react/lib-esm/deprecated/Button/ButtonStyles.js":
/*!*************************************************************************************!*\
  !*** ../../../node_modules/@primer/react/lib-esm/deprecated/Button/ButtonStyles.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ buttonBaseStyles)
/* harmony export */ });
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../constants.js */ "../../../node_modules/@primer/react/lib-esm/constants.js");



var buttonBaseStyles = (0,styled_components__WEBPACK_IMPORTED_MODULE_0__.css)(["position:relative;display:inline-block;padding:6px 16px;font-family:inherit;font-weight:", ";line-height:20px;white-space:nowrap;vertical-align:middle;cursor:pointer;user-select:none;border-radius:", ";appearance:none;text-decoration:none;text-align:center;&:hover{text-decoration:none;}&:focus{outline:none;}&:disabled{cursor:default;}&:disabled svg{opacity:0.6;}"], (0,_constants_js__WEBPACK_IMPORTED_MODULE_1__.get)('fontWeights.bold'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_1__.get)('radii.2'));




/***/ }),

/***/ "../../../node_modules/@primer/react/lib-esm/hooks/useFocusTrap.js":
/*!*************************************************************************!*\
  !*** ../../../node_modules/@primer/react/lib-esm/hooks/useFocusTrap.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "useFocusTrap": () => (/* binding */ useFocusTrap)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _primer_behaviors__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @primer/behaviors */ "../../../node_modules/@primer/behaviors/dist/esm/focus-trap.js");
/* harmony import */ var _useProvidedRefOrCreate_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./useProvidedRefOrCreate.js */ "../../../node_modules/@primer/react/lib-esm/hooks/useProvidedRefOrCreate.js");




/**
 * Hook used to trap focus inside a container. Returns a ref that can be added to the container
 * that should trap focus.
 * @param settings {FocusTrapHookSettings}
 */
function useFocusTrap(settings, dependencies = []) {
  const containerRef = (0,_useProvidedRefOrCreate_js__WEBPACK_IMPORTED_MODULE_1__.useProvidedRefOrCreate)(settings === null || settings === void 0 ? void 0 : settings.containerRef);
  const initialFocusRef = (0,_useProvidedRefOrCreate_js__WEBPACK_IMPORTED_MODULE_1__.useProvidedRefOrCreate)(settings === null || settings === void 0 ? void 0 : settings.initialFocusRef);
  const disabled = settings === null || settings === void 0 ? void 0 : settings.disabled;
  const abortController = react__WEBPACK_IMPORTED_MODULE_0___default().useRef();
  const previousFocusedElement = react__WEBPACK_IMPORTED_MODULE_0___default().useRef(null);

  // If we are enabling a focus trap and haven't already stored the previously focused element
  // go ahead an do that so we can restore later when the trap is disabled.
  if (!previousFocusedElement.current && !(settings !== null && settings !== void 0 && settings.disabled)) {
    previousFocusedElement.current = document.activeElement;
  }

  // This function removes the event listeners that enable the focus trap and restores focus
  // to the previously-focused element (if necessary).
  function disableTrap() {
    var _abortController$curr;
    (_abortController$curr = abortController.current) === null || _abortController$curr === void 0 ? void 0 : _abortController$curr.abort();
    if (settings !== null && settings !== void 0 && settings.restoreFocusOnCleanUp && previousFocusedElement.current instanceof HTMLElement) {
      previousFocusedElement.current.focus();
      previousFocusedElement.current = null;
    }
  }
  react__WEBPACK_IMPORTED_MODULE_0___default().useEffect(() => {
    if (containerRef.current instanceof HTMLElement) {
      if (!disabled) {
        var _initialFocusRef$curr;
        abortController.current = (0,_primer_behaviors__WEBPACK_IMPORTED_MODULE_2__.focusTrap)(containerRef.current, (_initialFocusRef$curr = initialFocusRef.current) !== null && _initialFocusRef$curr !== void 0 ? _initialFocusRef$curr : undefined);
        return () => {
          disableTrap();
        };
      } else {
        disableTrap();
      }
    }
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [containerRef, initialFocusRef, disabled, ...dependencies]);
  return {
    containerRef,
    initialFocusRef
  };
}




/***/ }),

/***/ "../../../node_modules/@primer/react/lib-esm/hooks/useFocusZone.js":
/*!*************************************************************************!*\
  !*** ../../../node_modules/@primer/react/lib-esm/hooks/useFocusZone.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "FocusKeys": () => (/* reexport safe */ _primer_behaviors__WEBPACK_IMPORTED_MODULE_1__.FocusKeys),
/* harmony export */   "useFocusZone": () => (/* binding */ useFocusZone)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _primer_behaviors__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @primer/behaviors */ "../../../node_modules/@primer/behaviors/dist/esm/focus-zone.js");
/* harmony import */ var _useProvidedRefOrCreate_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./useProvidedRefOrCreate.js */ "../../../node_modules/@primer/react/lib-esm/hooks/useProvidedRefOrCreate.js");





function useFocusZone(settings = {}, dependencies = []) {
  const containerRef = (0,_useProvidedRefOrCreate_js__WEBPACK_IMPORTED_MODULE_2__.useProvidedRefOrCreate)(settings.containerRef);
  const useActiveDescendant = !!settings.activeDescendantFocus;
  const passedActiveDescendantRef = typeof settings.activeDescendantFocus === 'boolean' || !settings.activeDescendantFocus ? undefined : settings.activeDescendantFocus;
  const activeDescendantControlRef = (0,_useProvidedRefOrCreate_js__WEBPACK_IMPORTED_MODULE_2__.useProvidedRefOrCreate)(passedActiveDescendantRef);
  const disabled = settings.disabled;
  const abortController = react__WEBPACK_IMPORTED_MODULE_0___default().useRef();
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    if (containerRef.current instanceof HTMLElement && (!useActiveDescendant || activeDescendantControlRef.current instanceof HTMLElement)) {
      if (!disabled) {
        var _activeDescendantCont;
        const vanillaSettings = {
          ...settings,
          activeDescendantControl: (_activeDescendantCont = activeDescendantControlRef.current) !== null && _activeDescendantCont !== void 0 ? _activeDescendantCont : undefined
        };
        abortController.current = (0,_primer_behaviors__WEBPACK_IMPORTED_MODULE_1__.focusZone)(containerRef.current, vanillaSettings);
        return () => {
          var _abortController$curr;
          (_abortController$curr = abortController.current) === null || _abortController$curr === void 0 ? void 0 : _abortController$curr.abort();
        };
      } else {
        var _abortController$curr2;
        (_abortController$curr2 = abortController.current) === null || _abortController$curr2 === void 0 ? void 0 : _abortController$curr2.abort();
      }
    }
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [disabled, ...dependencies]);
  return {
    containerRef,
    activeDescendantControlRef
  };
}




/***/ }),

/***/ "../../../node_modules/@primer/react/lib-esm/hooks/useId.js":
/*!******************************************************************!*\
  !*** ../../../node_modules/@primer/react/lib-esm/hooks/useId.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "useId": () => (/* binding */ useId)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _react_aria_ssr__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @react-aria/ssr */ "../../../node_modules/@react-aria/ssr/dist/module.js");



// eslint-disable-next-line import/no-namespace

/**
 * Detect if `React.useId()` is present. This strategy is a workaround for:
 * https://github.com/webpack/webpack/issues/14814
 *
 * This technique is inspired by Material UI:
 * https://github.com/mui/material-ui/blob/7bc478ec00a3b5625427f36c827e00b0a17be3d0/packages/mui-utils/src/useId.ts#L21
 */
// eslint-disable-next-line @typescript-eslint/no-explicit-any, no-useless-concat
const useReactId = react__WEBPACK_IMPORTED_MODULE_0__['useId' + ''];
function useId(id) {
  // Force useSSRSafeId in test environments to maintain snapshot parity between
  // major versions of React
  if (false) {}
  if (useReactId !== undefined) {
    if (id) {
      return id;
    }
    // eslint-disable-next-line react-hooks/rules-of-hooks
    return useReactId();
  }

  // eslint-disable-next-line react-hooks/rules-of-hooks
  return (0,_react_aria_ssr__WEBPACK_IMPORTED_MODULE_1__.useSSRSafeId)(id);
}




/***/ }),

/***/ "../../../node_modules/@primer/react/lib-esm/hooks/useOnEscapePress.js":
/*!*****************************************************************************!*\
  !*** ../../../node_modules/@primer/react/lib-esm/hooks/useOnEscapePress.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "useOnEscapePress": () => (/* binding */ useOnEscapePress)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);


/**
 * Calls all handlers in reverse order
 * @param event The KeyboardEvent generated by the Escape keydown.
 */
function handleEscape(event) {
  if (!event.defaultPrevented) {
    for (const handler of Object.values(registry).reverse()) {
      handler(event);
      // eslint-disable-next-line @typescript-eslint/no-unnecessary-condition
      if (event.defaultPrevented) break;
    }
  }
}
const registry = {};
function register(id, handler) {
  registry[id] = handler;
}
function deregister(id) {
  delete registry[id];
}

// For auto-incrementing unique identifiers for registered handlers.
let handlerId = 0;

/**
 * Sets up a `keydown` listener on `window.document`. If
 * 1) The pressed key is "Escape", and
 * 2) The event has not had `.preventDefault()` called
 * The given callback will be executed.
 *
 * Note: If multiple `useOnEscapePress` hooks are active simultaneously, the
 * callbacks will occur in reverse order. In other words, if a parent component
 * and a child component both call `useOnEscapePress`, when the user presses
 * Escape, the child component's callback will execute, followed by the parent's
 * callback. Each callback has the chance to call `.preventDefault()` on the
 * event to prevent further callbacks.
 *
 * @param callback {(e: KeyboardEvent) => void} The callback that gets executed
 * when the Escape key is pressed. The KeyboardEvent generated by the Escape
 * keypress is passed as the only argument.
 *
 * @param callbackDependencies {React.DependencyList} The dependencies of the given
 * `onEscape` callback for memoization. Omit this param if the callback is already
 * memoized. See `React.useCallback` for more info on memoization.
 */
const useOnEscapePress = (onEscape, callbackDependencies = [onEscape]) => {
  // eslint-disable-next-line react-hooks/exhaustive-deps
  const escapeCallback = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(onEscape, callbackDependencies);
  const handler = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(event => {
    if (event.key === 'Escape') escapeCallback(event);
  }, [escapeCallback]);
  const id = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(() => handlerId++, []);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    if (Object.keys(registry).length === 0) {
      document.addEventListener('keydown', handleEscape);
    }
    register(id, handler);
    return () => {
      deregister(id);
      if (Object.keys(registry).length === 0) {
        document.removeEventListener('keydown', handleEscape);
      }
    };
  }, [id, handler]);
};




/***/ }),

/***/ "../../../node_modules/@primer/react/lib-esm/hooks/useOnOutsideClick.js":
/*!******************************************************************************!*\
  !*** ../../../node_modules/@primer/react/lib-esm/hooks/useOnOutsideClick.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "useOnOutsideClick": () => (/* binding */ useOnOutsideClick)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);


// Because events are handled at the document level, we provide a mechanism for early return.
const stopPropagation = true;

/**
 * Calls all handlers in reverse order
 * @param event The MouseEvent generated by the click event.
 */
function handleClick(event) {
  if (!event.defaultPrevented) {
    for (const handler of Object.values(registry).reverse()) {
      // eslint-disable-next-line @typescript-eslint/no-unnecessary-condition
      if (handler(event) === stopPropagation || event.defaultPrevented) {
        break;
      }
    }
  }
}
const registry = {};
function register(id, handler) {
  registry[id] = handler;
}
function deregister(id) {
  delete registry[id];
}

// For auto-incrementing unique identifiers for registered handlers.
let handlerId = 0;
const useOnOutsideClick = ({
  containerRef,
  ignoreClickRefs,
  onClickOutside
}) => {
  const id = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(() => handlerId++, []);
  const handler = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(event => {
    var _containerRef$current;
    // don't call click handler if the mouse event was triggered by an auxiliary button (right click/wheel button/etc)
    if (event instanceof MouseEvent && event.button > 0) {
      return stopPropagation;
    }

    // don't call handler if the click happened inside of the container
    if ((_containerRef$current = containerRef.current) !== null && _containerRef$current !== void 0 && _containerRef$current.contains(event.target)) {
      return stopPropagation;
    }

    // don't call handler if click happened on an ignored ref
    if (ignoreClickRefs && ignoreClickRefs.some(({
      current
    }) => current === null || current === void 0 ? void 0 : current.contains(event.target))) {
      return stopPropagation;
    }
    onClickOutside(event);
  }, [containerRef, ignoreClickRefs, onClickOutside]);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    if (Object.keys(registry).length === 0) {
      // use capture to ensure we get all events
      document.addEventListener('mousedown', handleClick, {
        capture: true
      });
    }
    register(id, handler);
    return () => {
      deregister(id);
      if (Object.keys(registry).length === 0) {
        document.removeEventListener('mousedown', handleClick, {
          capture: true
        });
      }
    };
  }, [id, handler]);
};




/***/ }),

/***/ "../../../node_modules/@primer/react/lib-esm/hooks/useProvidedRefOrCreate.js":
/*!***********************************************************************************!*\
  !*** ../../../node_modules/@primer/react/lib-esm/hooks/useProvidedRefOrCreate.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "useProvidedRefOrCreate": () => (/* binding */ useProvidedRefOrCreate)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);


/**
 * There are some situations where we only want to create a new ref if one is not provided to a component
 * or hook as a prop. However, due to the `rules-of-hooks`, we cannot conditionally make a call to `React.useRef`
 * only in the situations where the ref is not provided as a prop.
 * This hook aims to encapsulate that logic, so the consumer doesn't need to be concerned with violating `rules-of-hooks`.
 * @param providedRef The ref to use - if undefined, will use the ref from a call to React.useRef
 * @type TRef The type of the RefObject which should be created.
 */
function useProvidedRefOrCreate(providedRef) {
  const createdRef = react__WEBPACK_IMPORTED_MODULE_0___default().useRef(null);
  return providedRef !== null && providedRef !== void 0 ? providedRef : createdRef;
}




/***/ }),

/***/ "../../../node_modules/@primer/react/lib-esm/hooks/useRefObjectAsForwardedRef.js":
/*!***************************************************************************************!*\
  !*** ../../../node_modules/@primer/react/lib-esm/hooks/useRefObjectAsForwardedRef.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "useRefObjectAsForwardedRef": () => (/* binding */ useRefObjectAsForwardedRef)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);


/**
 * Use a ref object as the imperative handle for a forwarded ref. This can be used to
 * synchronize the ref object with the forwarded ref and allow local access the reference
 * instance with `.current`.
 *
 * **NOTE**: The `refObject` should be passed to the underlying element, NOT the `forwardedRef`.
 */
function useRefObjectAsForwardedRef(forwardedRef, refObject) {
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useImperativeHandle)(forwardedRef, () => refObject.current);
}




/***/ }),

/***/ "../../../node_modules/@primer/react/lib-esm/hooks/useResizeObserver.js":
/*!******************************************************************************!*\
  !*** ../../../node_modules/@primer/react/lib-esm/hooks/useResizeObserver.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "useResizeObserver": () => (/* binding */ useResizeObserver)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _utils_useIsomorphicLayoutEffect_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/useIsomorphicLayoutEffect.js */ "../../../node_modules/@primer/react/lib-esm/utils/useIsomorphicLayoutEffect.js");



// https://gist.github.com/strothj/708afcf4f01dd04de8f49c92e88093c3

function useResizeObserver(callback, target) {
  const savedCallback = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(callback);
  (0,_utils_useIsomorphicLayoutEffect_js__WEBPACK_IMPORTED_MODULE_1__["default"])(() => {
    savedCallback.current = callback;
  });
  (0,_utils_useIsomorphicLayoutEffect_js__WEBPACK_IMPORTED_MODULE_1__["default"])(() => {
    const targetEl = target && 'current' in target ? target.current : document.documentElement;
    if (!targetEl) {
      return;
    }
    const observer = new ResizeObserver(entries => {
      savedCallback.current(entries);
    });
    observer.observe(targetEl);
    return () => {
      observer.disconnect();
    };
  }, [target]);
}




/***/ }),

/***/ "../../../node_modules/@primer/react/lib-esm/hooks/useSafeTimeout.js":
/*!***************************************************************************!*\
  !*** ../../../node_modules/@primer/react/lib-esm/hooks/useSafeTimeout.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ useSafeTimeout)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);


/**
 * Safely call `setTimeout` and `clearTimeout` within a component.
 *
 * This hook ensures that all timeouts are cleared when the component unmounts.
 */
function useSafeTimeout() {
  const timers = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(new Set());
  const safeSetTimeout = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)((handler, timeout, ...args) => {
    const id = window.setTimeout(handler, timeout, ...args);
    timers.current.add(id);
    return id;
  }, []);
  const safeClearTimeout = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(id => {
    clearTimeout(id);
    timers.current.delete(id);
  }, []);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    return () => {
      // eslint-disable-next-line react-hooks/exhaustive-deps
      for (const id of timers.current) {
        clearTimeout(id);
      }
    };
  }, []);
  return {
    safeSetTimeout,
    safeClearTimeout
  };
}




/***/ }),

/***/ "../../../node_modules/@primer/react/lib-esm/sx.js":
/*!*********************************************************!*\
  !*** ../../../node_modules/@primer/react/lib-esm/sx.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ sx$1),
/* harmony export */   "merge": () => (/* reexport default from dynamic */ deepmerge__WEBPACK_IMPORTED_MODULE_0___default.a)
/* harmony export */ });
/* harmony import */ var _styled_system_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @styled-system/css */ "../../../node_modules/@styled-system/css/dist/index.esm.js");
/* harmony import */ var deepmerge__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! deepmerge */ "../../../node_modules/deepmerge/dist/cjs.js");
/* harmony import */ var deepmerge__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(deepmerge__WEBPACK_IMPORTED_MODULE_0__);



const sx = props => (0,_styled_system_css__WEBPACK_IMPORTED_MODULE_1__["default"])(props.sx);
var sx$1 = sx;




/***/ }),

/***/ "../../../node_modules/@primer/react/lib-esm/theme-preval.js":
/*!*******************************************************************!*\
  !*** ../../../node_modules/@primer/react/lib-esm/theme-preval.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ theme)
/* harmony export */ });
// this file was prevaled
// This file needs to be a JavaScript file using CommonJS to be compatible with preval
// Cache bust: 2022-10-17 12:00:00 GMT (This file is cached by our deployment tooling, update this timestamp to rebuild this file)
var themePreval = {
  "animation": {
    "easeOutCubic": "cubic-bezier(0.33, 1, 0.68, 1)"
  },
  "borderWidths": [0, "1px"],
  "breakpoints": ["544px", "768px", "1012px", "1280px"],
  "fonts": {
    "normal": "-apple-system, BlinkMacSystemFont, \"Segoe UI\", \"Noto Sans\", Helvetica, Arial, sans-serif, \"Apple Color Emoji\", \"Segoe UI Emoji\"",
    "mono": "SFMono-Regular, Consolas, \"Liberation Mono\", Menlo, Courier, monospace"
  },
  "fontSizes": ["12px", "14px", "16px", "20px", "24px", "32px", "40px", "48px"],
  "fontWeights": {
    "light": 300,
    "normal": 400,
    "semibold": 500,
    "bold": 600
  },
  "lineHeights": {
    "condensedUltra": 1,
    "condensed": 1.25,
    "default": 1.5
  },
  "radii": ["0", "3px", "6px", "100px"],
  "sizes": {
    "small": "544px",
    "medium": "768px",
    "large": "1012px",
    "xlarge": "1280px"
  },
  "space": ["0", "4px", "8px", "16px", "24px", "32px", "40px", "48px", "64px", "80px", "96px", "112px", "128px"],
  "colorSchemes": {
    "light": {
      "colors": {
        "canvasDefaultTransparent": "rgba(255,255,255,0)",
        "pageHeaderBg": "#f6f8fa",
        "marketingIcon": {
          "primary": "#218bff",
          "secondary": "#54aeff"
        },
        "diffBlob": {
          "addition": {
            "numText": "#24292f",
            "fg": "#24292f",
            "numBg": "#ccffd8",
            "lineBg": "#e6ffec",
            "wordBg": "#abf2bc"
          },
          "deletion": {
            "numText": "#24292f",
            "fg": "#24292f",
            "numBg": "#ffd7d5",
            "lineBg": "#ffebe9",
            "wordBg": "rgba(255,129,130,0.4)"
          },
          "hunk": {
            "numBg": "rgba(84,174,255,0.4)"
          },
          "expander": {
            "icon": "#57606a"
          }
        },
        "diffstat": {
          "deletionBorder": "rgba(27,31,36,0.15)",
          "additionBorder": "rgba(27,31,36,0.15)",
          "additionBg": "#2da44e"
        },
        "searchKeyword": {
          "hl": "#fff8c5"
        },
        "prettylights": {
          "syntax": {
            "comment": "#6e7781",
            "constant": "#0550ae",
            "entity": "#8250df",
            "storageModifierImport": "#24292f",
            "entityTag": "#116329",
            "keyword": "#cf222e",
            "string": "#0a3069",
            "variable": "#953800",
            "brackethighlighterUnmatched": "#82071e",
            "invalidIllegalText": "#f6f8fa",
            "invalidIllegalBg": "#82071e",
            "carriageReturnText": "#f6f8fa",
            "carriageReturnBg": "#cf222e",
            "stringRegexp": "#116329",
            "markupList": "#3b2300",
            "markupHeading": "#0550ae",
            "markupItalic": "#24292f",
            "markupBold": "#24292f",
            "markupDeletedText": "#82071e",
            "markupDeletedBg": "#ffebe9",
            "markupInsertedText": "#116329",
            "markupInsertedBg": "#dafbe1",
            "markupChangedText": "#953800",
            "markupChangedBg": "#ffd8b5",
            "markupIgnoredText": "#eaeef2",
            "markupIgnoredBg": "#0550ae",
            "metaDiffRange": "#8250df",
            "brackethighlighterAngle": "#57606a",
            "sublimelinterGutterMark": "#8c959f",
            "constantOtherReferenceLink": "#0a3069"
          }
        },
        "codemirror": {
          "text": "#24292f",
          "bg": "#ffffff",
          "guttersBg": "#ffffff",
          "guttermarkerText": "#ffffff",
          "guttermarkerSubtleText": "#6e7781",
          "linenumberText": "#57606a",
          "cursor": "#24292f",
          "selectionBg": "rgba(84,174,255,0.4)",
          "activelineBg": "rgba(234,238,242,0.5)",
          "matchingbracketText": "#24292f",
          "linesBg": "#ffffff",
          "syntax": {
            "comment": "#24292f",
            "constant": "#0550ae",
            "entity": "#8250df",
            "keyword": "#cf222e",
            "storage": "#cf222e",
            "string": "#0a3069",
            "support": "#0550ae",
            "variable": "#953800"
          }
        },
        "checks": {
          "bg": "#24292f",
          "textPrimary": "#f6f8fa",
          "textSecondary": "#8c959f",
          "textLink": "#54aeff",
          "btnIcon": "#afb8c1",
          "btnHoverIcon": "#f6f8fa",
          "btnHoverBg": "rgba(255,255,255,0.125)",
          "inputText": "#eaeef2",
          "inputPlaceholderText": "#8c959f",
          "inputFocusText": "#8c959f",
          "inputBg": "#32383f",
          "donutError": "#fa4549",
          "donutPending": "#bf8700",
          "donutSuccess": "#2da44e",
          "donutNeutral": "#afb8c1",
          "dropdownText": "#afb8c1",
          "dropdownBg": "#32383f",
          "dropdownBorder": "#424a53",
          "dropdownShadow": "rgba(27,31,36,0.3)",
          "dropdownHoverText": "#f6f8fa",
          "dropdownHoverBg": "#424a53",
          "dropdownBtnHoverText": "#f6f8fa",
          "dropdownBtnHoverBg": "#32383f",
          "scrollbarThumbBg": "#57606a",
          "headerLabelText": "#d0d7de",
          "headerLabelOpenText": "#f6f8fa",
          "headerBorder": "#32383f",
          "headerIcon": "#8c959f",
          "lineText": "#d0d7de",
          "lineNumText": "rgba(140,149,159,0.75)",
          "lineTimestampText": "#8c959f",
          "lineHoverBg": "#32383f",
          "lineSelectedBg": "rgba(33,139,255,0.15)",
          "lineSelectedNumText": "#54aeff",
          "lineDtFmText": "#24292f",
          "lineDtFmBg": "#9a6700",
          "gateBg": "rgba(125,78,0,0.15)",
          "gateText": "#d0d7de",
          "gateWaitingText": "#d4a72c",
          "stepHeaderOpenBg": "#32383f",
          "stepErrorText": "#ff8182",
          "stepWarningText": "#d4a72c",
          "loglineText": "#8c959f",
          "loglineNumText": "rgba(140,149,159,0.75)",
          "loglineDebugText": "#c297ff",
          "loglineErrorText": "#d0d7de",
          "loglineErrorNumText": "#ff8182",
          "loglineErrorBg": "rgba(164,14,38,0.15)",
          "loglineWarningText": "#d0d7de",
          "loglineWarningNumText": "#d4a72c",
          "loglineWarningBg": "rgba(125,78,0,0.15)",
          "loglineCommandText": "#54aeff",
          "loglineSectionText": "#4ac26b",
          "ansi": {
            "black": "#24292f",
            "blackBright": "#32383f",
            "white": "#d0d7de",
            "whiteBright": "#d0d7de",
            "gray": "#8c959f",
            "red": "#ff8182",
            "redBright": "#ffaba8",
            "green": "#4ac26b",
            "greenBright": "#6fdd8b",
            "yellow": "#d4a72c",
            "yellowBright": "#eac54f",
            "blue": "#54aeff",
            "blueBright": "#80ccff",
            "magenta": "#c297ff",
            "magentaBright": "#d8b9ff",
            "cyan": "#76e3ea",
            "cyanBright": "#b3f0ff"
          }
        },
        "project": {
          "headerBg": "#24292f",
          "sidebarBg": "#ffffff",
          "gradientIn": "#ffffff",
          "gradientOut": "rgba(255,255,255,0)"
        },
        "mktg": {
          "btn": {
            "bg": "#1b1f23"
          }
        },
        "avatar": {
          "bg": "#ffffff",
          "border": "rgba(27,31,36,0.15)",
          "stackFade": "#afb8c1",
          "stackFadeMore": "#d0d7de"
        },
        "topicTag": {
          "border": "rgba(0,0,0,0)"
        },
        "counter": {
          "border": "rgba(0,0,0,0)"
        },
        "selectMenu": {
          "backdropBorder": "rgba(0,0,0,0)",
          "tapHighlight": "rgba(175,184,193,0.5)",
          "tapFocusBg": "#b6e3ff"
        },
        "header": {
          "text": "rgba(255,255,255,0.7)",
          "bg": "#24292f",
          "divider": "#57606a",
          "logo": "#ffffff"
        },
        "headerSearch": {
          "bg": "#24292f",
          "border": "#57606a"
        },
        "sidenav": {
          "selectedBg": "#ffffff"
        },
        "menu": {
          "bgActive": "rgba(0,0,0,0)"
        },
        "input": {
          "disabledBg": "rgba(175,184,193,0.2)"
        },
        "timeline": {
          "badgeBg": "#eaeef2"
        },
        "ansi": {
          "black": "#24292f",
          "blackBright": "#57606a",
          "white": "#6e7781",
          "whiteBright": "#8c959f",
          "gray": "#6e7781",
          "red": "#cf222e",
          "redBright": "#a40e26",
          "green": "#116329",
          "greenBright": "#1a7f37",
          "yellow": "#4d2d00",
          "yellowBright": "#633c01",
          "blue": "#0969da",
          "blueBright": "#218bff",
          "magenta": "#8250df",
          "magentaBright": "#a475f9",
          "cyan": "#1b7c83",
          "cyanBright": "#3192aa"
        },
        "btn": {
          "text": "#24292f",
          "bg": "#f6f8fa",
          "border": "rgba(27,31,36,0.15)",
          "hoverBg": "#f3f4f6",
          "hoverBorder": "rgba(27,31,36,0.15)",
          "activeBg": "hsla(220,14%,93%,1)",
          "activeBorder": "rgba(27,31,36,0.15)",
          "selectedBg": "hsla(220,14%,94%,1)",
          "focusBg": "#f6f8fa",
          "focusBorder": "rgba(27,31,36,0.15)",
          "counterBg": "rgba(27,31,36,0.08)",
          "primary": {
            "text": "#ffffff",
            "bg": "#2da44e",
            "border": "rgba(27,31,36,0.15)",
            "hoverBg": "#2c974b",
            "hoverBorder": "rgba(27,31,36,0.15)",
            "selectedBg": "hsla(137,55%,36%,1)",
            "disabledText": "rgba(255,255,255,0.8)",
            "disabledBg": "#94d3a2",
            "disabledBorder": "rgba(27,31,36,0.15)",
            "focusBg": "#2da44e",
            "focusBorder": "rgba(27,31,36,0.15)",
            "icon": "rgba(255,255,255,0.8)",
            "counterBg": "rgba(255,255,255,0.2)"
          },
          "outline": {
            "text": "#0969da",
            "hoverText": "#ffffff",
            "hoverBg": "#0969da",
            "hoverBorder": "rgba(27,31,36,0.15)",
            "hoverCounterBg": "rgba(255,255,255,0.2)",
            "selectedText": "#ffffff",
            "selectedBg": "hsla(212,92%,42%,1)",
            "selectedBorder": "rgba(27,31,36,0.15)",
            "disabledText": "rgba(9,105,218,0.5)",
            "disabledBg": "#f6f8fa",
            "disabledCounterBg": "rgba(9,105,218,0.05)",
            "focusBorder": "rgba(27,31,36,0.15)",
            "counterBg": "rgba(9,105,218,0.1)"
          },
          "danger": {
            "text": "#cf222e",
            "hoverText": "#ffffff",
            "hoverBg": "#a40e26",
            "hoverBorder": "rgba(27,31,36,0.15)",
            "hoverCounterBg": "rgba(255,255,255,0.2)",
            "selectedText": "#ffffff",
            "selectedBg": "hsla(356,72%,44%,1)",
            "selectedBorder": "rgba(27,31,36,0.15)",
            "disabledText": "rgba(207,34,46,0.5)",
            "disabledBg": "#f6f8fa",
            "disabledCounterBg": "rgba(207,34,46,0.05)",
            "focusBorder": "rgba(27,31,36,0.15)",
            "counterBg": "rgba(207,34,46,0.1)",
            "icon": "#cf222e",
            "hoverIcon": "#ffffff"
          }
        },
        "underlinenav": {
          "icon": "#6e7781",
          "borderHover": "rgba(175,184,193,0.2)"
        },
        "actionListItem": {
          "inlineDivider": "rgba(208,215,222,0.48)",
          "default": {
            "hoverBg": "rgba(208,215,222,0.32)",
            "hoverBorder": "rgba(0,0,0,0)",
            "activeBg": "rgba(208,215,222,0.48)",
            "activeBorder": "rgba(0,0,0,0)",
            "selectedBg": "rgba(208,215,222,0.24)"
          },
          "danger": {
            "hoverBg": "rgba(255,235,233,0.64)",
            "activeBg": "#ffebe9",
            "hoverText": "#cf222e"
          }
        },
        "switchTrack": {
          "bg": "#eaeef2",
          "border": "#afb8c1",
          "checked": {
            "bg": "#ddf4ff",
            "hoverBg": "#b6e3ff",
            "activeBg": "#80ccff",
            "border": "#54aeff"
          }
        },
        "switchKnob": {
          "checked": {
            "bg": "#0969da",
            "disabledBg": "#6e7781"
          }
        },
        "segmentedControl": {
          "bg": "#eaeef2",
          "button": {
            "hover": {
              "bg": "rgba(175,184,193,0.2)"
            },
            "active": {
              "bg": "rgba(175,184,193,0.4)"
            },
            "selected": {
              "border": "#6e7781"
            }
          }
        },
        "treeViewItem": {
          "chevron": {
            "hoverBg": "rgba(208,215,222,0.32)"
          },
          "directory": {
            "fill": "#54aeff"
          }
        },
        "fg": {
          "default": "#24292f",
          "muted": "#57606a",
          "subtle": "#6e7781",
          "onEmphasis": "#ffffff"
        },
        "canvas": {
          "default": "#ffffff",
          "overlay": "#ffffff",
          "inset": "#f6f8fa",
          "subtle": "#f6f8fa"
        },
        "border": {
          "default": "#d0d7de",
          "muted": "hsla(210,18%,87%,1)",
          "subtle": "rgba(27,31,36,0.15)"
        },
        "neutral": {
          "emphasisPlus": "#24292f",
          "emphasis": "#6e7781",
          "muted": "rgba(175,184,193,0.2)",
          "subtle": "rgba(234,238,242,0.5)"
        },
        "accent": {
          "fg": "#0969da",
          "emphasis": "#0969da",
          "muted": "rgba(84,174,255,0.4)",
          "subtle": "#ddf4ff"
        },
        "success": {
          "fg": "#1a7f37",
          "emphasis": "#2da44e",
          "muted": "rgba(74,194,107,0.4)",
          "subtle": "#dafbe1"
        },
        "attention": {
          "fg": "#9a6700",
          "emphasis": "#bf8700",
          "muted": "rgba(212,167,44,0.4)",
          "subtle": "#fff8c5"
        },
        "severe": {
          "fg": "#bc4c00",
          "emphasis": "#bc4c00",
          "muted": "rgba(251,143,68,0.4)",
          "subtle": "#fff1e5"
        },
        "danger": {
          "fg": "#cf222e",
          "emphasis": "#cf222e",
          "muted": "rgba(255,129,130,0.4)",
          "subtle": "#ffebe9"
        },
        "open": {
          "fg": "#1a7f37",
          "emphasis": "#2da44e",
          "muted": "rgba(74,194,107,0.4)",
          "subtle": "#dafbe1"
        },
        "closed": {
          "fg": "#cf222e",
          "emphasis": "#cf222e",
          "muted": "rgba(255,129,130,0.4)",
          "subtle": "#ffebe9"
        },
        "done": {
          "fg": "#8250df",
          "emphasis": "#8250df",
          "muted": "rgba(194,151,255,0.4)",
          "subtle": "#fbefff"
        },
        "sponsors": {
          "fg": "#bf3989",
          "emphasis": "#bf3989",
          "muted": "rgba(255,128,200,0.4)",
          "subtle": "#ffeff7"
        },
        "primer": {
          "fg": {
            "disabled": "#8c959f"
          },
          "canvas": {
            "backdrop": "rgba(27,31,36,0.5)",
            "sticky": "rgba(255,255,255,0.95)"
          },
          "border": {
            "active": "#fd8c73",
            "contrast": "rgba(27,31,36,0.1)"
          }
        }
      },
      "shadows": {
        "mktg": {
          "btn": {
            "shadow": {
              "outline": "rgb(0 0 0 / 15%) 0 0 0 1px inset",
              "focus": "rgb(0 0 0 / 15%) 0 0 0 4px",
              "hover": "0 3px 2px rgba(0, 0, 0, 0.07), 0 7px 5px rgba(0, 0, 0, 0.04), 0 12px 10px rgba(0, 0, 0, 0.03), 0 22px 18px rgba(0, 0, 0, 0.03), 0 42px 33px rgba(0, 0, 0, 0.02), 0 100px 80px rgba(0, 0, 0, 0.02)",
              "hoverMuted": "rgb(0 0 0 / 70%) 0 0 0 2px inset"
            }
          }
        },
        "avatar": {
          "childShadow": "-2px -2px 0 rgba(255,255,255,0.8)"
        },
        "overlay": {
          "shadow": "0 1px 3px rgba(27,31,36,0.12), 0 8px 24px rgba(66,74,83,0.12)"
        },
        "btn": {
          "shadow": "0 1px 0 rgba(27,31,36,0.04)",
          "insetShadow": "inset 0 1px 0 rgba(255,255,255,0.25)",
          "focusShadow": "0 0 0 3px rgba(9,105,218,0.3)",
          "shadowActive": "inset 0 0.15em 0.3em rgba(27,31,36,0.15)",
          "shadowInputFocus": "0 0 0 0.2em rgba(9,105,218,0.3)",
          "primary": {
            "shadow": "0 1px 0 rgba(27,31,36,0.1)",
            "insetShadow": "inset 0 1px 0 rgba(255,255,255,0.03)",
            "selectedShadow": "inset 0 1px 0 rgba(0,45,17,0.2)",
            "focusShadow": "0 0 0 3px rgba(45,164,78,0.4)"
          },
          "outline": {
            "hoverShadow": "0 1px 0 rgba(27,31,36,0.1)",
            "hoverInsetShadow": "inset 0 1px 0 rgba(255,255,255,0.03)",
            "selectedShadow": "inset 0 1px 0 rgba(0,33,85,0.2)",
            "focusShadow": "0 0 0 3px rgba(5,80,174,0.4)"
          },
          "danger": {
            "hoverShadow": "0 1px 0 rgba(27,31,36,0.1)",
            "hoverInsetShadow": "inset 0 1px 0 rgba(255,255,255,0.03)",
            "selectedShadow": "inset 0 1px 0 rgba(76,0,20,0.2)",
            "focusShadow": "0 0 0 3px rgba(164,14,38,0.4)"
          }
        },
        "shadow": {
          "small": "0 1px 0 rgba(27,31,36,0.04)",
          "medium": "0 3px 6px rgba(140,149,159,0.15)",
          "large": "0 8px 24px rgba(140,149,159,0.2)",
          "extraLarge": "0 12px 28px rgba(140,149,159,0.3)"
        },
        "primer": {
          "shadow": {
            "highlight": "inset 0 1px 0 rgba(255,255,255,0.25)",
            "inset": "inset 0 1px 0 rgba(208,215,222,0.2)",
            "focus": "0 0 0 3px rgba(9,105,218,0.3)"
          }
        }
      }
    },
    "light_high_contrast": {
      "colors": {
        "canvasDefaultTransparent": "rgba(255,255,255,0)",
        "pageHeaderBg": "#ffffff",
        "marketingIcon": {
          "primary": "#1168e3",
          "secondary": "#368cf9"
        },
        "diffBlob": {
          "addition": {
            "numText": "#0e1116",
            "fg": "#ffffff",
            "numBg": "#ccffd8",
            "lineBg": "#e6ffec",
            "wordBg": "#055d20"
          },
          "deletion": {
            "numText": "#0e1116",
            "fg": "#ffffff",
            "numBg": "#ffd7d5",
            "lineBg": "#fff0ee",
            "wordBg": "#a0111f"
          },
          "hunk": {
            "numBg": "#9cd7ff"
          },
          "expander": {
            "icon": "#0e1116"
          }
        },
        "diffstat": {
          "deletionBorder": "rgba(1,4,9,0.8)",
          "additionBorder": "rgba(1,4,9,0.8)",
          "additionBg": "#117f32"
        },
        "searchKeyword": {
          "hl": "#fcf7be"
        },
        "prettylights": {
          "syntax": {
            "comment": "#66707b",
            "constant": "#023b95",
            "entity": "#622cbc",
            "storageModifierImport": "#0e1116",
            "entityTag": "#024c1a",
            "keyword": "#a0111f",
            "string": "#032563",
            "variable": "#702c00",
            "brackethighlighterUnmatched": "#6e011a",
            "invalidIllegalText": "#ffffff",
            "invalidIllegalBg": "#6e011a",
            "carriageReturnText": "#ffffff",
            "carriageReturnBg": "#a0111f",
            "stringRegexp": "#024c1a",
            "markupList": "#2e1800",
            "markupHeading": "#023b95",
            "markupItalic": "#0e1116",
            "markupBold": "#0e1116",
            "markupDeletedText": "#6e011a",
            "markupDeletedBg": "#fff0ee",
            "markupInsertedText": "#024c1a",
            "markupInsertedBg": "#d2fedb",
            "markupChangedText": "#702c00",
            "markupChangedBg": "#ffc67b",
            "markupIgnoredText": "#e7ecf0",
            "markupIgnoredBg": "#023b95",
            "metaDiffRange": "#622cbc",
            "brackethighlighterAngle": "#4b535d",
            "sublimelinterGutterMark": "#88929d",
            "constantOtherReferenceLink": "#032563"
          }
        },
        "codemirror": {
          "text": "#0e1116",
          "bg": "#ffffff",
          "guttersBg": "#ffffff",
          "guttermarkerText": "#ffffff",
          "guttermarkerSubtleText": "#66707b",
          "linenumberText": "#0e1116",
          "cursor": "#0e1116",
          "selectionBg": "#368cf9",
          "activelineBg": "#e7ecf0",
          "matchingbracketText": "#0e1116",
          "linesBg": "#ffffff",
          "syntax": {
            "comment": "#0e1116",
            "constant": "#023b95",
            "entity": "#622cbc",
            "keyword": "#a0111f",
            "storage": "#a0111f",
            "string": "#032563",
            "support": "#023b95",
            "variable": "#702c00"
          }
        },
        "checks": {
          "bg": "#0e1116",
          "textPrimary": "#ffffff",
          "textSecondary": "#88929d",
          "textLink": "#368cf9",
          "btnIcon": "#acb6c0",
          "btnHoverIcon": "#ffffff",
          "btnHoverBg": "rgba(255,255,255,0.125)",
          "inputText": "#e7ecf0",
          "inputPlaceholderText": "#88929d",
          "inputFocusText": "#88929d",
          "inputBg": "#20252c",
          "donutError": "#d5232c",
          "donutPending": "#956400",
          "donutSuccess": "#117f32",
          "donutNeutral": "#acb6c0",
          "dropdownText": "#acb6c0",
          "dropdownBg": "#20252c",
          "dropdownBorder": "#343b43",
          "dropdownShadow": "rgba(1,4,9,0.3)",
          "dropdownHoverText": "#ffffff",
          "dropdownHoverBg": "#343b43",
          "dropdownBtnHoverText": "#ffffff",
          "dropdownBtnHoverBg": "#20252c",
          "scrollbarThumbBg": "#4b535d",
          "headerLabelText": "#ced5dc",
          "headerLabelOpenText": "#ffffff",
          "headerBorder": "#20252c",
          "headerIcon": "#88929d",
          "lineText": "#ced5dc",
          "lineNumText": "rgba(136,146,157,0.75)",
          "lineTimestampText": "#88929d",
          "lineHoverBg": "#20252c",
          "lineSelectedBg": "rgba(17,104,227,0.15)",
          "lineSelectedNumText": "#368cf9",
          "lineDtFmText": "#0e1116",
          "lineDtFmBg": "#744500",
          "gateBg": "rgba(96,55,0,0.15)",
          "gateText": "#ced5dc",
          "gateWaitingText": "#b58407",
          "stepHeaderOpenBg": "#20252c",
          "stepErrorText": "#ee5a5d",
          "stepWarningText": "#b58407",
          "loglineText": "#88929d",
          "loglineNumText": "rgba(136,146,157,0.75)",
          "loglineDebugText": "#a371f7",
          "loglineErrorText": "#ced5dc",
          "loglineErrorNumText": "#ee5a5d",
          "loglineErrorBg": "rgba(134,6,29,0.15)",
          "loglineWarningText": "#ced5dc",
          "loglineWarningNumText": "#b58407",
          "loglineWarningBg": "rgba(96,55,0,0.15)",
          "loglineCommandText": "#368cf9",
          "loglineSectionText": "#26a148",
          "ansi": {
            "black": "#0e1116",
            "blackBright": "#20252c",
            "white": "#ced5dc",
            "whiteBright": "#ced5dc",
            "gray": "#88929d",
            "red": "#ee5a5d",
            "redBright": "#ff8e8a",
            "green": "#26a148",
            "greenBright": "#43c663",
            "yellow": "#b58407",
            "yellowBright": "#d5a824",
            "blue": "#368cf9",
            "blueBright": "#67b3fd",
            "magenta": "#a371f7",
            "magentaBright": "#c49bff",
            "cyan": "#76e3ea",
            "cyanBright": "#b3f0ff"
          }
        },
        "project": {
          "headerBg": "#0e1116",
          "sidebarBg": "#ffffff",
          "gradientIn": "#ffffff",
          "gradientOut": "rgba(255,255,255,0)"
        },
        "mktg": {
          "btn": {
            "bg": "#1b1f23"
          }
        },
        "avatar": {
          "bg": "#ffffff",
          "border": "rgba(1,4,9,0.8)",
          "stackFade": "#acb6c0",
          "stackFadeMore": "#ced5dc"
        },
        "topicTag": {
          "border": "#0349b4"
        },
        "counter": {
          "border": "#20252c"
        },
        "selectMenu": {
          "backdropBorder": "rgba(0,0,0,0)",
          "tapHighlight": "rgba(172,182,192,0.5)",
          "tapFocusBg": "#9cd7ff"
        },
        "header": {
          "text": "rgba(255,255,255,0.7)",
          "bg": "#0e1116",
          "divider": "#acb6c0",
          "logo": "#ffffff"
        },
        "headerSearch": {
          "bg": "#0e1116",
          "border": "#4b535d"
        },
        "sidenav": {
          "selectedBg": "#ffffff"
        },
        "menu": {
          "bgActive": "rgba(0,0,0,0)"
        },
        "input": {
          "disabledBg": "rgba(172,182,192,0.2)"
        },
        "timeline": {
          "badgeBg": "#e7ecf0"
        },
        "ansi": {
          "black": "#0e1116",
          "blackBright": "#4b535d",
          "white": "#66707b",
          "whiteBright": "#88929d",
          "gray": "#66707b",
          "red": "#a0111f",
          "redBright": "#86061d",
          "green": "#024c1a",
          "greenBright": "#055d20",
          "yellow": "#3f2200",
          "yellowBright": "#4e2c00",
          "blue": "#0349b4",
          "blueBright": "#1168e3",
          "magenta": "#622cbc",
          "magentaBright": "#844ae7",
          "cyan": "#1b7c83",
          "cyanBright": "#3192aa"
        },
        "btn": {
          "text": "#0e1116",
          "bg": "#e7ecf0",
          "border": "rgba(1,4,9,0.8)",
          "hoverBg": "#ced5dc",
          "hoverBorder": "rgba(1,4,9,0.8)",
          "activeBg": "#acb6c0",
          "activeBorder": "rgba(1,4,9,0.8)",
          "selectedBg": "#acb6c0",
          "focusBg": "#ced5dc",
          "focusBorder": "rgba(1,4,9,0.8)",
          "counterBg": "rgba(1,4,9,0.08)",
          "primary": {
            "text": "#ffffff",
            "bg": "#055d20",
            "border": "#013d14",
            "hoverBg": "#024c1a",
            "hoverBorder": "#013d14",
            "selectedBg": "hsla(139,95%,13%,1)",
            "disabledText": "rgba(255,255,255,0.8)",
            "disabledBg": "#94d3a2",
            "disabledBorder": "rgba(1,4,9,0.8)",
            "focusBg": "#013d14",
            "focusBorder": "#013d14",
            "icon": "rgba(255,255,255,0.8)",
            "counterBg": "rgba(255,255,255,0.2)"
          },
          "outline": {
            "text": "#023b95",
            "hoverText": "#ffffff",
            "hoverBg": "#0349b4",
            "hoverBorder": "#022f7a",
            "hoverCounterBg": "rgba(255,255,255,0.2)",
            "selectedText": "#ffffff",
            "selectedBg": "#022f7a",
            "selectedBorder": "#022f7a",
            "disabledText": "rgba(3,73,180,0.5)",
            "disabledBg": "#e7ecf0",
            "disabledCounterBg": "rgba(3,73,180,0.05)",
            "focusBorder": "#022f7a",
            "counterBg": "rgba(3,73,180,0.1)"
          },
          "danger": {
            "text": "#86061d",
            "hoverText": "#ffffff",
            "hoverBg": "#a0111f",
            "hoverBorder": "#6e011a",
            "hoverCounterBg": "rgba(255,255,255,0.2)",
            "selectedText": "#ffffff",
            "selectedBg": "#6e011a",
            "selectedBorder": "#6e011a",
            "disabledText": "rgba(160,17,31,0.5)",
            "disabledBg": "#e7ecf0",
            "disabledCounterBg": "rgba(160,17,31,0.05)",
            "focusBorder": "#6e011a",
            "counterBg": "rgba(160,17,31,0.1)",
            "icon": "#86061d",
            "hoverIcon": "#ffffff"
          }
        },
        "underlinenav": {
          "icon": "#66707b",
          "borderHover": "rgba(172,182,192,0.2)"
        },
        "actionListItem": {
          "inlineDivider": "#88929d",
          "default": {
            "hoverBg": "#e7ecf0",
            "hoverBorder": "#88929d",
            "activeBg": "#ced5dc",
            "activeBorder": "#20252c",
            "selectedBg": "#ced5dc"
          },
          "danger": {
            "hoverBg": "#a0111f",
            "activeBg": "#6e011a",
            "hoverText": "#ffffff"
          }
        },
        "switchTrack": {
          "bg": "#ffffff",
          "border": "#20252c",
          "checked": {
            "bg": "#dff7ff",
            "hoverBg": "#9cd7ff",
            "activeBg": "#67b3fd",
            "border": "#0349b4"
          }
        },
        "switchKnob": {
          "checked": {
            "bg": "#0349b4",
            "disabledBg": "#66707b"
          }
        },
        "segmentedControl": {
          "bg": "#e7ecf0",
          "button": {
            "hover": {
              "bg": "rgba(172,182,192,0.2)"
            },
            "active": {
              "bg": "rgba(172,182,192,0.4)"
            },
            "selected": {
              "border": "#66707b"
            }
          }
        },
        "treeViewItem": {
          "chevron": {
            "hoverBg": "#ced5dc"
          },
          "directory": {
            "fill": "#368cf9"
          }
        },
        "fg": {
          "default": "#0e1116",
          "muted": "#0e1116",
          "subtle": "#66707b",
          "onEmphasis": "#ffffff"
        },
        "canvas": {
          "default": "#ffffff",
          "overlay": "#ffffff",
          "inset": "#ffffff",
          "subtle": "#e7ecf0"
        },
        "border": {
          "default": "#20252c",
          "muted": "#88929d",
          "subtle": "rgba(1,4,9,0.8)"
        },
        "neutral": {
          "emphasisPlus": "#0e1116",
          "emphasis": "#66707b",
          "muted": "rgba(172,182,192,0.2)",
          "subtle": "#e7ecf0"
        },
        "accent": {
          "fg": "#0349b4",
          "emphasis": "#0349b4",
          "muted": "#368cf9",
          "subtle": "#dff7ff"
        },
        "success": {
          "fg": "#055d20",
          "emphasis": "#055d20",
          "muted": "#26a148",
          "subtle": "#d2fedb"
        },
        "attention": {
          "fg": "#744500",
          "emphasis": "#744500",
          "muted": "#b58407",
          "subtle": "#fcf7be"
        },
        "severe": {
          "fg": "#873800",
          "emphasis": "#873800",
          "muted": "#dc6d1a",
          "subtle": "#fff2d5"
        },
        "danger": {
          "fg": "#a0111f",
          "emphasis": "#a0111f",
          "muted": "#ee5a5d",
          "subtle": "#fff0ee"
        },
        "open": {
          "fg": "#055d20",
          "emphasis": "#117f32",
          "muted": "rgba(38,161,72,0.4)",
          "subtle": "#d2fedb"
        },
        "closed": {
          "fg": "#a0111f",
          "emphasis": "#a0111f",
          "muted": "rgba(238,90,93,0.4)",
          "subtle": "#fff0ee"
        },
        "done": {
          "fg": "#622cbc",
          "emphasis": "#622cbc",
          "muted": "#a371f7",
          "subtle": "#faf0fe"
        },
        "sponsors": {
          "fg": "#971368",
          "emphasis": "#971368",
          "muted": "#ed4baf",
          "subtle": "#feeff7"
        },
        "primer": {
          "fg": {
            "disabled": "#88929d"
          },
          "canvas": {
            "backdrop": "rgba(1,4,9,0.5)",
            "sticky": "rgba(255,255,255,0.95)"
          },
          "border": {
            "active": "#ef5b48",
            "contrast": "rgba(1,4,9,0.1)"
          }
        }
      },
      "shadows": {
        "mktg": {
          "btn": {
            "shadow": {
              "outline": "rgb(0 0 0 / 15%) 0 0 0 1px inset",
              "focus": "rgb(0 0 0 / 15%) 0 0 0 4px",
              "hover": "0 3px 2px rgba(0, 0, 0, 0.07), 0 7px 5px rgba(0, 0, 0, 0.04), 0 12px 10px rgba(0, 0, 0, 0.03), 0 22px 18px rgba(0, 0, 0, 0.03), 0 42px 33px rgba(0, 0, 0, 0.02), 0 100px 80px rgba(0, 0, 0, 0.02)",
              "hoverMuted": "rgb(0 0 0 / 70%) 0 0 0 2px inset"
            }
          }
        },
        "avatar": {
          "childShadow": "-2px -2px 0 rgba(255,255,255,0.8)"
        },
        "overlay": {
          "shadow": "0 1px 3px rgba(1,4,9,0.12), 0 8px 24px rgba(52,59,67,0.12)"
        },
        "btn": {
          "shadow": "0 1px 0 rgba(1,4,9,0.04)",
          "insetShadow": "inset 0 1px 0 rgba(255,255,255,0.25)",
          "focusShadow": "0 0 0 3px rgba(3,73,180,0.3)",
          "shadowActive": "inset 0 0.15em 0.3em rgba(1,4,9,0.15)",
          "shadowInputFocus": "0 0 0 0.2em rgba(3,73,180,0.3)",
          "primary": {
            "shadow": "0 1px 0 rgba(1,4,9,0.1)",
            "insetShadow": "inset 0 1px 0 rgba(255,255,255,0.03)",
            "selectedShadow": "inset 0 1px 0 rgba(0,35,11,0.2)",
            "focusShadow": "0 0 0 3px rgba(1,61,20,0.4)"
          },
          "outline": {
            "hoverShadow": "0 1px 0 rgba(1,4,9,0.1)",
            "hoverInsetShadow": "inset 0 1px 0 rgba(255,255,255,0.03)",
            "selectedShadow": "inset 0 1px 0 rgba(2,26,74,0.2)",
            "focusShadow": "0 0 0 3px rgba(2,59,149,0.4)"
          },
          "danger": {
            "hoverShadow": "0 1px 0 rgba(1,4,9,0.1)",
            "hoverInsetShadow": "inset 0 1px 0 rgba(255,255,255,0.03)",
            "selectedShadow": "inset 0 1px 0 rgba(67,0,17,0.2)",
            "focusShadow": "0 0 0 3px rgba(134,6,29,0.4)"
          }
        },
        "shadow": {
          "small": "0 1px 0 rgba(1,4,9,0.04)",
          "medium": "0 3px 6px rgba(136,146,157,0.15)",
          "large": "0 8px 24px rgba(136,146,157,0.2)",
          "extraLarge": "0 12px 28px rgba(136,146,157,0.3)"
        },
        "primer": {
          "shadow": {
            "highlight": "inset 0 1px 0 rgba(255,255,255,0.25)",
            "inset": "inset 0 1px 0 rgba(206,213,220,0.2)",
            "focus": "0 0 0 3px rgba(3,73,180,0.3)"
          }
        }
      }
    },
    "light_colorblind": {
      "colors": {
        "canvasDefaultTransparent": "rgba(255,255,255,0)",
        "pageHeaderBg": "#f6f8fa",
        "marketingIcon": {
          "primary": "#218bff",
          "secondary": "#54aeff"
        },
        "diffBlob": {
          "addition": {
            "numText": "#24292f",
            "fg": "#24292f",
            "numBg": "rgba(84,174,255,0.4)",
            "lineBg": "rgba(221,244,255,0.5)",
            "wordBg": "rgba(84,174,255,0.4)"
          },
          "deletion": {
            "numText": "#24292f",
            "fg": "#24292f",
            "numBg": "rgba(247,153,57,0.4)",
            "lineBg": "rgba(255,245,232,0.5)",
            "wordBg": "rgba(255,188,109,0.5)"
          },
          "hunk": {
            "numBg": "rgba(84,174,255,0.4)"
          },
          "expander": {
            "icon": "#57606a"
          }
        },
        "diffstat": {
          "deletionBorder": "rgba(27,31,36,0.15)",
          "additionBorder": "rgba(27,31,36,0.15)",
          "additionBg": "#218bff"
        },
        "searchKeyword": {
          "hl": "#fff8c5"
        },
        "prettylights": {
          "syntax": {
            "comment": "#6e7781",
            "constant": "#0550ae",
            "entity": "#8250df",
            "storageModifierImport": "#24292f",
            "entityTag": "#0550ae",
            "keyword": "#b35900",
            "string": "#0a3069",
            "variable": "#8a4600",
            "brackethighlighterUnmatched": "#6f3800",
            "invalidIllegalText": "#f6f8fa",
            "invalidIllegalBg": "#6f3800",
            "carriageReturnText": "#f6f8fa",
            "carriageReturnBg": "#b35900",
            "stringRegexp": "#0550ae",
            "markupList": "#3b2300",
            "markupHeading": "#0550ae",
            "markupItalic": "#24292f",
            "markupBold": "#24292f",
            "markupDeletedText": "#6f3800",
            "markupDeletedBg": "#fff5e8",
            "markupInsertedText": "#0550ae",
            "markupInsertedBg": "#ddf4ff",
            "markupChangedText": "#8a4600",
            "markupChangedBg": "#ffddb0",
            "markupIgnoredText": "#eaeef2",
            "markupIgnoredBg": "#0550ae",
            "metaDiffRange": "#8250df",
            "brackethighlighterAngle": "#57606a",
            "sublimelinterGutterMark": "#8c959f",
            "constantOtherReferenceLink": "#0a3069"
          }
        },
        "codemirror": {
          "text": "#24292f",
          "bg": "#ffffff",
          "guttersBg": "#ffffff",
          "guttermarkerText": "#ffffff",
          "guttermarkerSubtleText": "#6e7781",
          "linenumberText": "#57606a",
          "cursor": "#24292f",
          "selectionBg": "rgba(84,174,255,0.4)",
          "activelineBg": "rgba(234,238,242,0.5)",
          "matchingbracketText": "#24292f",
          "linesBg": "#ffffff",
          "syntax": {
            "comment": "#24292f",
            "constant": "#0550ae",
            "entity": "#8250df",
            "keyword": "#b35900",
            "storage": "#b35900",
            "string": "#0a3069",
            "support": "#0550ae",
            "variable": "#8a4600"
          }
        },
        "checks": {
          "bg": "#24292f",
          "textPrimary": "#f6f8fa",
          "textSecondary": "#8c959f",
          "textLink": "#54aeff",
          "btnIcon": "#afb8c1",
          "btnHoverIcon": "#f6f8fa",
          "btnHoverBg": "rgba(255,255,255,0.125)",
          "inputText": "#eaeef2",
          "inputPlaceholderText": "#8c959f",
          "inputFocusText": "#8c959f",
          "inputBg": "#32383f",
          "donutError": "#dd7815",
          "donutPending": "#bf8700",
          "donutSuccess": "#218bff",
          "donutNeutral": "#afb8c1",
          "dropdownText": "#afb8c1",
          "dropdownBg": "#32383f",
          "dropdownBorder": "#424a53",
          "dropdownShadow": "rgba(27,31,36,0.3)",
          "dropdownHoverText": "#f6f8fa",
          "dropdownHoverBg": "#424a53",
          "dropdownBtnHoverText": "#f6f8fa",
          "dropdownBtnHoverBg": "#32383f",
          "scrollbarThumbBg": "#57606a",
          "headerLabelText": "#d0d7de",
          "headerLabelOpenText": "#f6f8fa",
          "headerBorder": "#32383f",
          "headerIcon": "#8c959f",
          "lineText": "#d0d7de",
          "lineNumText": "rgba(140,149,159,0.75)",
          "lineTimestampText": "#8c959f",
          "lineHoverBg": "#32383f",
          "lineSelectedBg": "rgba(33,139,255,0.15)",
          "lineSelectedNumText": "#54aeff",
          "lineDtFmText": "#24292f",
          "lineDtFmBg": "#9a6700",
          "gateBg": "rgba(125,78,0,0.15)",
          "gateText": "#d0d7de",
          "gateWaitingText": "#d4a72c",
          "stepHeaderOpenBg": "#32383f",
          "stepErrorText": "#f79939",
          "stepWarningText": "#d4a72c",
          "loglineText": "#8c959f",
          "loglineNumText": "rgba(140,149,159,0.75)",
          "loglineDebugText": "#c297ff",
          "loglineErrorText": "#d0d7de",
          "loglineErrorNumText": "#f79939",
          "loglineErrorBg": "rgba(138,70,0,0.15)",
          "loglineWarningText": "#d0d7de",
          "loglineWarningNumText": "#d4a72c",
          "loglineWarningBg": "rgba(125,78,0,0.15)",
          "loglineCommandText": "#54aeff",
          "loglineSectionText": "#54aeff",
          "ansi": {
            "black": "#24292f",
            "blackBright": "#32383f",
            "white": "#d0d7de",
            "whiteBright": "#d0d7de",
            "gray": "#8c959f",
            "red": "#f79939",
            "redBright": "#ffbc6d",
            "green": "#54aeff",
            "greenBright": "#80ccff",
            "yellow": "#d4a72c",
            "yellowBright": "#eac54f",
            "blue": "#54aeff",
            "blueBright": "#80ccff",
            "magenta": "#c297ff",
            "magentaBright": "#d8b9ff",
            "cyan": "#76e3ea",
            "cyanBright": "#b3f0ff"
          }
        },
        "project": {
          "headerBg": "#24292f",
          "sidebarBg": "#ffffff",
          "gradientIn": "#ffffff",
          "gradientOut": "rgba(255,255,255,0)"
        },
        "mktg": {
          "btn": {
            "bg": "#1b1f23"
          }
        },
        "avatar": {
          "bg": "#ffffff",
          "border": "rgba(27,31,36,0.15)",
          "stackFade": "#afb8c1",
          "stackFadeMore": "#d0d7de"
        },
        "topicTag": {
          "border": "rgba(0,0,0,0)"
        },
        "counter": {
          "border": "rgba(0,0,0,0)"
        },
        "selectMenu": {
          "backdropBorder": "rgba(0,0,0,0)",
          "tapHighlight": "rgba(175,184,193,0.5)",
          "tapFocusBg": "#b6e3ff"
        },
        "header": {
          "text": "rgba(255,255,255,0.7)",
          "bg": "#24292f",
          "divider": "#57606a",
          "logo": "#ffffff"
        },
        "headerSearch": {
          "bg": "#24292f",
          "border": "#57606a"
        },
        "sidenav": {
          "selectedBg": "#ffffff"
        },
        "menu": {
          "bgActive": "rgba(0,0,0,0)"
        },
        "input": {
          "disabledBg": "rgba(175,184,193,0.2)"
        },
        "timeline": {
          "badgeBg": "#eaeef2"
        },
        "ansi": {
          "black": "#24292f",
          "blackBright": "#57606a",
          "white": "#6e7781",
          "whiteBright": "#8c959f",
          "gray": "#6e7781",
          "red": "#b35900",
          "redBright": "#8a4600",
          "green": "#0550ae",
          "greenBright": "#0969da",
          "yellow": "#4d2d00",
          "yellowBright": "#633c01",
          "blue": "#0969da",
          "blueBright": "#218bff",
          "magenta": "#8250df",
          "magentaBright": "#a475f9",
          "cyan": "#1b7c83",
          "cyanBright": "#3192aa"
        },
        "btn": {
          "text": "#24292f",
          "bg": "#f6f8fa",
          "border": "rgba(27,31,36,0.15)",
          "hoverBg": "#f3f4f6",
          "hoverBorder": "rgba(27,31,36,0.15)",
          "activeBg": "hsla(220,14%,93%,1)",
          "activeBorder": "rgba(27,31,36,0.15)",
          "selectedBg": "hsla(220,14%,94%,1)",
          "focusBg": "#f6f8fa",
          "focusBorder": "rgba(27,31,36,0.15)",
          "counterBg": "rgba(27,31,36,0.08)",
          "primary": {
            "text": "#ffffff",
            "bg": "#218bff",
            "border": "rgba(27,31,36,0.15)",
            "hoverBg": "#0969da",
            "hoverBorder": "rgba(27,31,36,0.15)",
            "selectedBg": "hsla(212,92%,43%,1)",
            "disabledText": "rgba(255,255,255,0.8)",
            "disabledBg": "#80ccff",
            "disabledBorder": "rgba(27,31,36,0.15)",
            "focusBg": "#218bff",
            "focusBorder": "rgba(27,31,36,0.15)",
            "icon": "rgba(255,255,255,0.8)",
            "counterBg": "rgba(255,255,255,0.2)"
          },
          "outline": {
            "text": "#0969da",
            "hoverText": "#ffffff",
            "hoverBg": "#0969da",
            "hoverBorder": "rgba(27,31,36,0.15)",
            "hoverCounterBg": "rgba(255,255,255,0.2)",
            "selectedText": "#ffffff",
            "selectedBg": "hsla(212,92%,42%,1)",
            "selectedBorder": "rgba(27,31,36,0.15)",
            "disabledText": "rgba(9,105,218,0.5)",
            "disabledBg": "#f6f8fa",
            "disabledCounterBg": "rgba(9,105,218,0.05)",
            "focusBorder": "rgba(27,31,36,0.15)",
            "counterBg": "rgba(9,105,218,0.1)"
          },
          "danger": {
            "text": "#b35900",
            "hoverText": "#ffffff",
            "hoverBg": "#8a4600",
            "hoverBorder": "rgba(27,31,36,0.15)",
            "hoverCounterBg": "rgba(255,255,255,0.2)",
            "selectedText": "#ffffff",
            "selectedBg": "hsla(30,100%,32%,1)",
            "selectedBorder": "rgba(27,31,36,0.15)",
            "disabledText": "rgba(179,89,0,0.5)",
            "disabledBg": "#f6f8fa",
            "disabledCounterBg": "rgba(179,89,0,0.05)",
            "focusBorder": "rgba(27,31,36,0.15)",
            "counterBg": "rgba(179,89,0,0.1)",
            "icon": "#b35900",
            "hoverIcon": "#ffffff"
          }
        },
        "underlinenav": {
          "icon": "#6e7781",
          "borderHover": "rgba(175,184,193,0.2)"
        },
        "actionListItem": {
          "inlineDivider": "rgba(208,215,222,0.48)",
          "default": {
            "hoverBg": "rgba(208,215,222,0.32)",
            "hoverBorder": "rgba(0,0,0,0)",
            "activeBg": "rgba(208,215,222,0.48)",
            "activeBorder": "rgba(0,0,0,0)",
            "selectedBg": "rgba(208,215,222,0.24)"
          },
          "danger": {
            "hoverBg": "rgba(255,245,232,0.64)",
            "activeBg": "#fff5e8",
            "hoverText": "#b35900"
          }
        },
        "switchTrack": {
          "bg": "#eaeef2",
          "border": "#afb8c1",
          "checked": {
            "bg": "#ddf4ff",
            "hoverBg": "#b6e3ff",
            "activeBg": "#80ccff",
            "border": "#54aeff"
          }
        },
        "switchKnob": {
          "checked": {
            "bg": "#0969da",
            "disabledBg": "#6e7781"
          }
        },
        "segmentedControl": {
          "bg": "#eaeef2",
          "button": {
            "hover": {
              "bg": "rgba(175,184,193,0.2)"
            },
            "active": {
              "bg": "rgba(175,184,193,0.4)"
            },
            "selected": {
              "border": "#6e7781"
            }
          }
        },
        "treeViewItem": {
          "chevron": {
            "hoverBg": "rgba(208,215,222,0.32)"
          },
          "directory": {
            "fill": "#54aeff"
          }
        },
        "fg": {
          "default": "#24292f",
          "muted": "#57606a",
          "subtle": "#6e7781",
          "onEmphasis": "#ffffff"
        },
        "canvas": {
          "default": "#ffffff",
          "overlay": "#ffffff",
          "inset": "#f6f8fa",
          "subtle": "#f6f8fa"
        },
        "border": {
          "default": "#d0d7de",
          "muted": "hsla(210,18%,87%,1)",
          "subtle": "rgba(27,31,36,0.15)"
        },
        "neutral": {
          "emphasisPlus": "#24292f",
          "emphasis": "#6e7781",
          "muted": "rgba(175,184,193,0.2)",
          "subtle": "rgba(234,238,242,0.5)"
        },
        "accent": {
          "fg": "#0969da",
          "emphasis": "#0969da",
          "muted": "rgba(84,174,255,0.4)",
          "subtle": "#ddf4ff"
        },
        "success": {
          "fg": "#0969da",
          "emphasis": "#218bff",
          "muted": "rgba(84,174,255,0.4)",
          "subtle": "#ddf4ff"
        },
        "attention": {
          "fg": "#9a6700",
          "emphasis": "#bf8700",
          "muted": "rgba(212,167,44,0.4)",
          "subtle": "#fff8c5"
        },
        "severe": {
          "fg": "#b35900",
          "emphasis": "#b35900",
          "muted": "rgba(247,153,57,0.4)",
          "subtle": "#fff5e8"
        },
        "danger": {
          "fg": "#b35900",
          "emphasis": "#b35900",
          "muted": "rgba(247,153,57,0.4)",
          "subtle": "#fff5e8"
        },
        "open": {
          "fg": "#b35900",
          "emphasis": "#dd7815",
          "muted": "rgba(247,153,57,0.4)",
          "subtle": "#fff5e8"
        },
        "closed": {
          "fg": "#6e7781",
          "emphasis": "#6e7781",
          "muted": "rgba(175,184,193,0.4)",
          "subtle": "#f6f8fa"
        },
        "done": {
          "fg": "#8250df",
          "emphasis": "#8250df",
          "muted": "rgba(194,151,255,0.4)",
          "subtle": "#fbefff"
        },
        "sponsors": {
          "fg": "#bf3989",
          "emphasis": "#bf3989",
          "muted": "rgba(255,128,200,0.4)",
          "subtle": "#ffeff7"
        },
        "primer": {
          "fg": {
            "disabled": "#8c959f"
          },
          "canvas": {
            "backdrop": "rgba(27,31,36,0.5)",
            "sticky": "rgba(255,255,255,0.95)"
          },
          "border": {
            "active": "#fd8c73",
            "contrast": "rgba(27,31,36,0.1)"
          }
        }
      },
      "shadows": {
        "mktg": {
          "btn": {
            "shadow": {
              "outline": "rgb(0 0 0 / 15%) 0 0 0 1px inset",
              "focus": "rgb(0 0 0 / 15%) 0 0 0 4px",
              "hover": "0 3px 2px rgba(0, 0, 0, 0.07), 0 7px 5px rgba(0, 0, 0, 0.04), 0 12px 10px rgba(0, 0, 0, 0.03), 0 22px 18px rgba(0, 0, 0, 0.03), 0 42px 33px rgba(0, 0, 0, 0.02), 0 100px 80px rgba(0, 0, 0, 0.02)",
              "hoverMuted": "rgb(0 0 0 / 70%) 0 0 0 2px inset"
            }
          }
        },
        "avatar": {
          "childShadow": "-2px -2px 0 rgba(255,255,255,0.8)"
        },
        "overlay": {
          "shadow": "0 1px 3px rgba(27,31,36,0.12), 0 8px 24px rgba(66,74,83,0.12)"
        },
        "btn": {
          "shadow": "0 1px 0 rgba(27,31,36,0.04)",
          "insetShadow": "inset 0 1px 0 rgba(255,255,255,0.25)",
          "focusShadow": "0 0 0 3px rgba(9,105,218,0.3)",
          "shadowActive": "inset 0 0.15em 0.3em rgba(27,31,36,0.15)",
          "shadowInputFocus": "0 0 0 0.2em rgba(9,105,218,0.3)",
          "primary": {
            "shadow": "0 1px 0 rgba(27,31,36,0.1)",
            "insetShadow": "inset 0 1px 0 rgba(255,255,255,0.03)",
            "selectedShadow": "inset 0 1px 0 rgba(0,33,85,0.2)",
            "focusShadow": "0 0 0 3px rgba(33,139,255,0.4)"
          },
          "outline": {
            "hoverShadow": "0 1px 0 rgba(27,31,36,0.1)",
            "hoverInsetShadow": "inset 0 1px 0 rgba(255,255,255,0.03)",
            "selectedShadow": "inset 0 1px 0 rgba(0,33,85,0.2)",
            "focusShadow": "0 0 0 3px rgba(5,80,174,0.4)"
          },
          "danger": {
            "hoverShadow": "0 1px 0 rgba(27,31,36,0.1)",
            "hoverInsetShadow": "inset 0 1px 0 rgba(255,255,255,0.03)",
            "selectedShadow": "inset 0 1px 0 rgba(65,32,0,0.2)",
            "focusShadow": "0 0 0 3px rgba(138,70,0,0.4)"
          }
        },
        "shadow": {
          "small": "0 1px 0 rgba(27,31,36,0.04)",
          "medium": "0 3px 6px rgba(140,149,159,0.15)",
          "large": "0 8px 24px rgba(140,149,159,0.2)",
          "extraLarge": "0 12px 28px rgba(140,149,159,0.3)"
        },
        "primer": {
          "shadow": {
            "highlight": "inset 0 1px 0 rgba(255,255,255,0.25)",
            "inset": "inset 0 1px 0 rgba(208,215,222,0.2)",
            "focus": "0 0 0 3px rgba(9,105,218,0.3)"
          }
        }
      }
    },
    "light_tritanopia": {
      "colors": {
        "canvasDefaultTransparent": "rgba(255,255,255,0)",
        "pageHeaderBg": "#f6f8fa",
        "marketingIcon": {
          "primary": "#218bff",
          "secondary": "#54aeff"
        },
        "diffBlob": {
          "addition": {
            "numText": "#24292f",
            "fg": "#24292f",
            "numBg": "rgba(84,174,255,0.4)",
            "lineBg": "rgba(221,244,255,0.5)",
            "wordBg": "rgba(84,174,255,0.4)"
          },
          "deletion": {
            "numText": "#24292f",
            "fg": "#24292f",
            "numBg": "rgba(255,129,130,0.4)",
            "lineBg": "rgba(255,235,233,0.5)",
            "wordBg": "rgba(255,171,168,0.5)"
          },
          "hunk": {
            "numBg": "rgba(84,174,255,0.4)"
          },
          "expander": {
            "icon": "#57606a"
          }
        },
        "diffstat": {
          "deletionBorder": "rgba(27,31,36,0.15)",
          "additionBorder": "rgba(27,31,36,0.15)",
          "additionBg": "#218bff"
        },
        "searchKeyword": {
          "hl": "#fff8c5"
        },
        "prettylights": {
          "syntax": {
            "comment": "#6e7781",
            "constant": "#0550ae",
            "entity": "#8250df",
            "storageModifierImport": "#24292f",
            "entityTag": "#0550ae",
            "keyword": "#cf222e",
            "string": "#0a3069",
            "variable": "#a40e26",
            "brackethighlighterUnmatched": "#82071e",
            "invalidIllegalText": "#f6f8fa",
            "invalidIllegalBg": "#82071e",
            "carriageReturnText": "#f6f8fa",
            "carriageReturnBg": "#cf222e",
            "stringRegexp": "#0550ae",
            "markupList": "#3b2300",
            "markupHeading": "#0550ae",
            "markupItalic": "#24292f",
            "markupBold": "#24292f",
            "markupDeletedText": "#82071e",
            "markupDeletedBg": "#ffebe9",
            "markupInsertedText": "#0550ae",
            "markupInsertedBg": "#ddf4ff",
            "markupChangedText": "#a40e26",
            "markupChangedBg": "#ffcecb",
            "markupIgnoredText": "#eaeef2",
            "markupIgnoredBg": "#0550ae",
            "metaDiffRange": "#8250df",
            "brackethighlighterAngle": "#57606a",
            "sublimelinterGutterMark": "#8c959f",
            "constantOtherReferenceLink": "#0a3069"
          }
        },
        "codemirror": {
          "text": "#24292f",
          "bg": "#ffffff",
          "guttersBg": "#ffffff",
          "guttermarkerText": "#ffffff",
          "guttermarkerSubtleText": "#6e7781",
          "linenumberText": "#57606a",
          "cursor": "#24292f",
          "selectionBg": "rgba(84,174,255,0.4)",
          "activelineBg": "rgba(234,238,242,0.5)",
          "matchingbracketText": "#24292f",
          "linesBg": "#ffffff",
          "syntax": {
            "comment": "#24292f",
            "constant": "#0550ae",
            "entity": "#8250df",
            "keyword": "#cf222e",
            "storage": "#cf222e",
            "string": "#0a3069",
            "support": "#0550ae",
            "variable": "#a40e26"
          }
        },
        "checks": {
          "bg": "#24292f",
          "textPrimary": "#f6f8fa",
          "textSecondary": "#8c959f",
          "textLink": "#54aeff",
          "btnIcon": "#afb8c1",
          "btnHoverIcon": "#f6f8fa",
          "btnHoverBg": "rgba(255,255,255,0.125)",
          "inputText": "#eaeef2",
          "inputPlaceholderText": "#8c959f",
          "inputFocusText": "#8c959f",
          "inputBg": "#32383f",
          "donutError": "#fa4549",
          "donutPending": "#bf8700",
          "donutSuccess": "#218bff",
          "donutNeutral": "#afb8c1",
          "dropdownText": "#afb8c1",
          "dropdownBg": "#32383f",
          "dropdownBorder": "#424a53",
          "dropdownShadow": "rgba(27,31,36,0.3)",
          "dropdownHoverText": "#f6f8fa",
          "dropdownHoverBg": "#424a53",
          "dropdownBtnHoverText": "#f6f8fa",
          "dropdownBtnHoverBg": "#32383f",
          "scrollbarThumbBg": "#57606a",
          "headerLabelText": "#d0d7de",
          "headerLabelOpenText": "#f6f8fa",
          "headerBorder": "#32383f",
          "headerIcon": "#8c959f",
          "lineText": "#d0d7de",
          "lineNumText": "rgba(140,149,159,0.75)",
          "lineTimestampText": "#8c959f",
          "lineHoverBg": "#32383f",
          "lineSelectedBg": "rgba(33,139,255,0.15)",
          "lineSelectedNumText": "#54aeff",
          "lineDtFmText": "#24292f",
          "lineDtFmBg": "#9a6700",
          "gateBg": "rgba(125,78,0,0.15)",
          "gateText": "#d0d7de",
          "gateWaitingText": "#d4a72c",
          "stepHeaderOpenBg": "#32383f",
          "stepErrorText": "#ff8182",
          "stepWarningText": "#d4a72c",
          "loglineText": "#8c959f",
          "loglineNumText": "rgba(140,149,159,0.75)",
          "loglineDebugText": "#c297ff",
          "loglineErrorText": "#d0d7de",
          "loglineErrorNumText": "#ff8182",
          "loglineErrorBg": "rgba(164,14,38,0.15)",
          "loglineWarningText": "#d0d7de",
          "loglineWarningNumText": "#d4a72c",
          "loglineWarningBg": "rgba(125,78,0,0.15)",
          "loglineCommandText": "#54aeff",
          "loglineSectionText": "#54aeff",
          "ansi": {
            "black": "#24292f",
            "blackBright": "#32383f",
            "white": "#d0d7de",
            "whiteBright": "#d0d7de",
            "gray": "#8c959f",
            "red": "#ff8182",
            "redBright": "#ffaba8",
            "green": "#54aeff",
            "greenBright": "#80ccff",
            "yellow": "#d4a72c",
            "yellowBright": "#eac54f",
            "blue": "#54aeff",
            "blueBright": "#80ccff",
            "magenta": "#c297ff",
            "magentaBright": "#d8b9ff",
            "cyan": "#76e3ea",
            "cyanBright": "#b3f0ff"
          }
        },
        "project": {
          "headerBg": "#24292f",
          "sidebarBg": "#ffffff",
          "gradientIn": "#ffffff",
          "gradientOut": "rgba(255,255,255,0)"
        },
        "mktg": {
          "btn": {
            "bg": "#1b1f23"
          }
        },
        "avatar": {
          "bg": "#ffffff",
          "border": "rgba(27,31,36,0.15)",
          "stackFade": "#afb8c1",
          "stackFadeMore": "#d0d7de"
        },
        "topicTag": {
          "border": "rgba(0,0,0,0)"
        },
        "counter": {
          "border": "rgba(0,0,0,0)"
        },
        "selectMenu": {
          "backdropBorder": "rgba(0,0,0,0)",
          "tapHighlight": "rgba(175,184,193,0.5)",
          "tapFocusBg": "#b6e3ff"
        },
        "header": {
          "text": "rgba(255,255,255,0.7)",
          "bg": "#24292f",
          "divider": "#57606a",
          "logo": "#ffffff"
        },
        "headerSearch": {
          "bg": "#24292f",
          "border": "#57606a"
        },
        "sidenav": {
          "selectedBg": "#ffffff"
        },
        "menu": {
          "bgActive": "rgba(0,0,0,0)"
        },
        "input": {
          "disabledBg": "rgba(175,184,193,0.2)"
        },
        "timeline": {
          "badgeBg": "#eaeef2"
        },
        "ansi": {
          "black": "#24292f",
          "blackBright": "#57606a",
          "white": "#6e7781",
          "whiteBright": "#8c959f",
          "gray": "#6e7781",
          "red": "#cf222e",
          "redBright": "#a40e26",
          "green": "#0550ae",
          "greenBright": "#0969da",
          "yellow": "#4d2d00",
          "yellowBright": "#633c01",
          "blue": "#0969da",
          "blueBright": "#218bff",
          "magenta": "#8250df",
          "magentaBright": "#a475f9",
          "cyan": "#1b7c83",
          "cyanBright": "#3192aa"
        },
        "btn": {
          "text": "#24292f",
          "bg": "#f6f8fa",
          "border": "rgba(27,31,36,0.15)",
          "hoverBg": "#f3f4f6",
          "hoverBorder": "rgba(27,31,36,0.15)",
          "activeBg": "hsla(220,14%,93%,1)",
          "activeBorder": "rgba(27,31,36,0.15)",
          "selectedBg": "hsla(220,14%,94%,1)",
          "focusBg": "#f6f8fa",
          "focusBorder": "rgba(27,31,36,0.15)",
          "counterBg": "rgba(27,31,36,0.08)",
          "primary": {
            "text": "#ffffff",
            "bg": "#218bff",
            "border": "rgba(27,31,36,0.15)",
            "hoverBg": "#0969da",
            "hoverBorder": "rgba(27,31,36,0.15)",
            "selectedBg": "hsla(212,92%,43%,1)",
            "disabledText": "rgba(255,255,255,0.8)",
            "disabledBg": "#80ccff",
            "disabledBorder": "rgba(27,31,36,0.15)",
            "focusBg": "#218bff",
            "focusBorder": "rgba(27,31,36,0.15)",
            "icon": "rgba(255,255,255,0.8)",
            "counterBg": "rgba(255,255,255,0.2)"
          },
          "outline": {
            "text": "#0969da",
            "hoverText": "#ffffff",
            "hoverBg": "#0969da",
            "hoverBorder": "rgba(27,31,36,0.15)",
            "hoverCounterBg": "rgba(255,255,255,0.2)",
            "selectedText": "#ffffff",
            "selectedBg": "hsla(212,92%,42%,1)",
            "selectedBorder": "rgba(27,31,36,0.15)",
            "disabledText": "rgba(9,105,218,0.5)",
            "disabledBg": "#f6f8fa",
            "disabledCounterBg": "rgba(9,105,218,0.05)",
            "focusBorder": "rgba(27,31,36,0.15)",
            "counterBg": "rgba(9,105,218,0.1)"
          },
          "danger": {
            "text": "#cf222e",
            "hoverText": "#ffffff",
            "hoverBg": "#a40e26",
            "hoverBorder": "rgba(27,31,36,0.15)",
            "hoverCounterBg": "rgba(255,255,255,0.2)",
            "selectedText": "#ffffff",
            "selectedBg": "hsla(356,72%,44%,1)",
            "selectedBorder": "rgba(27,31,36,0.15)",
            "disabledText": "rgba(207,34,46,0.5)",
            "disabledBg": "#f6f8fa",
            "disabledCounterBg": "rgba(207,34,46,0.05)",
            "focusBorder": "rgba(27,31,36,0.15)",
            "counterBg": "rgba(207,34,46,0.1)",
            "icon": "#cf222e",
            "hoverIcon": "#ffffff"
          }
        },
        "underlinenav": {
          "icon": "#6e7781",
          "borderHover": "rgba(175,184,193,0.2)"
        },
        "actionListItem": {
          "inlineDivider": "rgba(208,215,222,0.48)",
          "default": {
            "hoverBg": "rgba(208,215,222,0.32)",
            "hoverBorder": "rgba(0,0,0,0)",
            "activeBg": "rgba(208,215,222,0.48)",
            "activeBorder": "rgba(0,0,0,0)",
            "selectedBg": "rgba(208,215,222,0.24)"
          },
          "danger": {
            "hoverBg": "rgba(255,235,233,0.64)",
            "activeBg": "#ffebe9",
            "hoverText": "#cf222e"
          }
        },
        "switchTrack": {
          "bg": "#eaeef2",
          "border": "#afb8c1",
          "checked": {
            "bg": "#ddf4ff",
            "hoverBg": "#b6e3ff",
            "activeBg": "#80ccff",
            "border": "#54aeff"
          }
        },
        "switchKnob": {
          "checked": {
            "bg": "#0969da",
            "disabledBg": "#6e7781"
          }
        },
        "segmentedControl": {
          "bg": "#eaeef2",
          "button": {
            "hover": {
              "bg": "rgba(175,184,193,0.2)"
            },
            "active": {
              "bg": "rgba(175,184,193,0.4)"
            },
            "selected": {
              "border": "#6e7781"
            }
          }
        },
        "treeViewItem": {
          "chevron": {
            "hoverBg": "rgba(208,215,222,0.32)"
          },
          "directory": {
            "fill": "#54aeff"
          }
        },
        "fg": {
          "default": "#24292f",
          "muted": "#57606a",
          "subtle": "#6e7781",
          "onEmphasis": "#ffffff"
        },
        "canvas": {
          "default": "#ffffff",
          "overlay": "#ffffff",
          "inset": "#f6f8fa",
          "subtle": "#f6f8fa"
        },
        "border": {
          "default": "#d0d7de",
          "muted": "hsla(210,18%,87%,1)",
          "subtle": "rgba(27,31,36,0.15)"
        },
        "neutral": {
          "emphasisPlus": "#24292f",
          "emphasis": "#6e7781",
          "muted": "rgba(175,184,193,0.2)",
          "subtle": "rgba(234,238,242,0.5)"
        },
        "accent": {
          "fg": "#0969da",
          "emphasis": "#0969da",
          "muted": "rgba(84,174,255,0.4)",
          "subtle": "#ddf4ff"
        },
        "success": {
          "fg": "#0969da",
          "emphasis": "#218bff",
          "muted": "rgba(84,174,255,0.4)",
          "subtle": "#ddf4ff"
        },
        "attention": {
          "fg": "#9a6700",
          "emphasis": "#bf8700",
          "muted": "rgba(212,167,44,0.4)",
          "subtle": "#fff8c5"
        },
        "severe": {
          "fg": "#cf222e",
          "emphasis": "#cf222e",
          "muted": "rgba(255,129,130,0.4)",
          "subtle": "#ffebe9"
        },
        "danger": {
          "fg": "#cf222e",
          "emphasis": "#cf222e",
          "muted": "rgba(255,129,130,0.4)",
          "subtle": "#ffebe9"
        },
        "open": {
          "fg": "#cf222e",
          "emphasis": "#fa4549",
          "muted": "rgba(255,129,130,0.4)",
          "subtle": "#ffebe9"
        },
        "closed": {
          "fg": "#6e7781",
          "emphasis": "#6e7781",
          "muted": "rgba(175,184,193,0.4)",
          "subtle": "#f6f8fa"
        },
        "done": {
          "fg": "#8250df",
          "emphasis": "#8250df",
          "muted": "rgba(194,151,255,0.4)",
          "subtle": "#fbefff"
        },
        "sponsors": {
          "fg": "#bf3989",
          "emphasis": "#bf3989",
          "muted": "rgba(255,128,200,0.4)",
          "subtle": "#ffeff7"
        },
        "primer": {
          "fg": {
            "disabled": "#8c959f"
          },
          "canvas": {
            "backdrop": "rgba(27,31,36,0.5)",
            "sticky": "rgba(255,255,255,0.95)"
          },
          "border": {
            "active": "#fd8c73",
            "contrast": "rgba(27,31,36,0.1)"
          }
        }
      },
      "shadows": {
        "mktg": {
          "btn": {
            "shadow": {
              "outline": "rgb(0 0 0 / 15%) 0 0 0 1px inset",
              "focus": "rgb(0 0 0 / 15%) 0 0 0 4px",
              "hover": "0 3px 2px rgba(0, 0, 0, 0.07), 0 7px 5px rgba(0, 0, 0, 0.04), 0 12px 10px rgba(0, 0, 0, 0.03), 0 22px 18px rgba(0, 0, 0, 0.03), 0 42px 33px rgba(0, 0, 0, 0.02), 0 100px 80px rgba(0, 0, 0, 0.02)",
              "hoverMuted": "rgb(0 0 0 / 70%) 0 0 0 2px inset"
            }
          }
        },
        "avatar": {
          "childShadow": "-2px -2px 0 rgba(255,255,255,0.8)"
        },
        "overlay": {
          "shadow": "0 1px 3px rgba(27,31,36,0.12), 0 8px 24px rgba(66,74,83,0.12)"
        },
        "btn": {
          "shadow": "0 1px 0 rgba(27,31,36,0.04)",
          "insetShadow": "inset 0 1px 0 rgba(255,255,255,0.25)",
          "focusShadow": "0 0 0 3px rgba(9,105,218,0.3)",
          "shadowActive": "inset 0 0.15em 0.3em rgba(27,31,36,0.15)",
          "shadowInputFocus": "0 0 0 0.2em rgba(9,105,218,0.3)",
          "primary": {
            "shadow": "0 1px 0 rgba(27,31,36,0.1)",
            "insetShadow": "inset 0 1px 0 rgba(255,255,255,0.03)",
            "selectedShadow": "inset 0 1px 0 rgba(0,33,85,0.2)",
            "focusShadow": "0 0 0 3px rgba(33,139,255,0.4)"
          },
          "outline": {
            "hoverShadow": "0 1px 0 rgba(27,31,36,0.1)",
            "hoverInsetShadow": "inset 0 1px 0 rgba(255,255,255,0.03)",
            "selectedShadow": "inset 0 1px 0 rgba(0,33,85,0.2)",
            "focusShadow": "0 0 0 3px rgba(5,80,174,0.4)"
          },
          "danger": {
            "hoverShadow": "0 1px 0 rgba(27,31,36,0.1)",
            "hoverInsetShadow": "inset 0 1px 0 rgba(255,255,255,0.03)",
            "selectedShadow": "inset 0 1px 0 rgba(76,0,20,0.2)",
            "focusShadow": "0 0 0 3px rgba(164,14,38,0.4)"
          }
        },
        "shadow": {
          "small": "0 1px 0 rgba(27,31,36,0.04)",
          "medium": "0 3px 6px rgba(140,149,159,0.15)",
          "large": "0 8px 24px rgba(140,149,159,0.2)",
          "extraLarge": "0 12px 28px rgba(140,149,159,0.3)"
        },
        "primer": {
          "shadow": {
            "highlight": "inset 0 1px 0 rgba(255,255,255,0.25)",
            "inset": "inset 0 1px 0 rgba(208,215,222,0.2)",
            "focus": "0 0 0 3px rgba(9,105,218,0.3)"
          }
        }
      }
    },
    "dark": {
      "colors": {
        "canvasDefaultTransparent": "rgba(13,17,23,0)",
        "pageHeaderBg": "#0d1117",
        "marketingIcon": {
          "primary": "#79c0ff",
          "secondary": "#1f6feb"
        },
        "diffBlob": {
          "addition": {
            "numText": "#c9d1d9",
            "fg": "#c9d1d9",
            "numBg": "rgba(63,185,80,0.3)",
            "lineBg": "rgba(46,160,67,0.15)",
            "wordBg": "rgba(46,160,67,0.4)"
          },
          "deletion": {
            "numText": "#c9d1d9",
            "fg": "#c9d1d9",
            "numBg": "rgba(248,81,73,0.3)",
            "lineBg": "rgba(248,81,73,0.15)",
            "wordBg": "rgba(248,81,73,0.4)"
          },
          "hunk": {
            "numBg": "rgba(56,139,253,0.4)"
          },
          "expander": {
            "icon": "#8b949e"
          }
        },
        "diffstat": {
          "deletionBorder": "rgba(240,246,252,0.1)",
          "additionBorder": "rgba(240,246,252,0.1)",
          "additionBg": "#3fb950"
        },
        "searchKeyword": {
          "hl": "rgba(210,153,34,0.4)"
        },
        "prettylights": {
          "syntax": {
            "comment": "#8b949e",
            "constant": "#79c0ff",
            "entity": "#d2a8ff",
            "storageModifierImport": "#c9d1d9",
            "entityTag": "#7ee787",
            "keyword": "#ff7b72",
            "string": "#a5d6ff",
            "variable": "#ffa657",
            "brackethighlighterUnmatched": "#f85149",
            "invalidIllegalText": "#f0f6fc",
            "invalidIllegalBg": "#8e1519",
            "carriageReturnText": "#f0f6fc",
            "carriageReturnBg": "#b62324",
            "stringRegexp": "#7ee787",
            "markupList": "#f2cc60",
            "markupHeading": "#1f6feb",
            "markupItalic": "#c9d1d9",
            "markupBold": "#c9d1d9",
            "markupDeletedText": "#ffdcd7",
            "markupDeletedBg": "#67060c",
            "markupInsertedText": "#aff5b4",
            "markupInsertedBg": "#033a16",
            "markupChangedText": "#ffdfb6",
            "markupChangedBg": "#5a1e02",
            "markupIgnoredText": "#c9d1d9",
            "markupIgnoredBg": "#1158c7",
            "metaDiffRange": "#d2a8ff",
            "brackethighlighterAngle": "#8b949e",
            "sublimelinterGutterMark": "#484f58",
            "constantOtherReferenceLink": "#a5d6ff"
          }
        },
        "codemirror": {
          "text": "#c9d1d9",
          "bg": "#0d1117",
          "guttersBg": "#0d1117",
          "guttermarkerText": "#0d1117",
          "guttermarkerSubtleText": "#6e7681",
          "linenumberText": "#8b949e",
          "cursor": "#c9d1d9",
          "selectionBg": "rgba(56,139,253,0.4)",
          "activelineBg": "rgba(110,118,129,0.1)",
          "matchingbracketText": "#c9d1d9",
          "linesBg": "#0d1117",
          "syntax": {
            "comment": "#8b949e",
            "constant": "#79c0ff",
            "entity": "#d2a8ff",
            "keyword": "#ff7b72",
            "storage": "#ff7b72",
            "string": "#a5d6ff",
            "support": "#79c0ff",
            "variable": "#ffa657"
          }
        },
        "checks": {
          "bg": "#010409",
          "textPrimary": "#c9d1d9",
          "textSecondary": "#8b949e",
          "textLink": "#58a6ff",
          "btnIcon": "#8b949e",
          "btnHoverIcon": "#c9d1d9",
          "btnHoverBg": "rgba(110,118,129,0.1)",
          "inputText": "#8b949e",
          "inputPlaceholderText": "#6e7681",
          "inputFocusText": "#c9d1d9",
          "inputBg": "#161b22",
          "donutError": "#f85149",
          "donutPending": "#d29922",
          "donutSuccess": "#2ea043",
          "donutNeutral": "#8b949e",
          "dropdownText": "#c9d1d9",
          "dropdownBg": "#161b22",
          "dropdownBorder": "#30363d",
          "dropdownShadow": "rgba(1,4,9,0.3)",
          "dropdownHoverText": "#c9d1d9",
          "dropdownHoverBg": "rgba(110,118,129,0.1)",
          "dropdownBtnHoverText": "#c9d1d9",
          "dropdownBtnHoverBg": "rgba(110,118,129,0.1)",
          "scrollbarThumbBg": "rgba(110,118,129,0.4)",
          "headerLabelText": "#8b949e",
          "headerLabelOpenText": "#c9d1d9",
          "headerBorder": "#21262d",
          "headerIcon": "#8b949e",
          "lineText": "#8b949e",
          "lineNumText": "#6e7681",
          "lineTimestampText": "#6e7681",
          "lineHoverBg": "rgba(110,118,129,0.1)",
          "lineSelectedBg": "rgba(56,139,253,0.15)",
          "lineSelectedNumText": "#58a6ff",
          "lineDtFmText": "#ffffff",
          "lineDtFmBg": "#9e6a03",
          "gateBg": "rgba(187,128,9,0.15)",
          "gateText": "#8b949e",
          "gateWaitingText": "#d29922",
          "stepHeaderOpenBg": "#161b22",
          "stepErrorText": "#f85149",
          "stepWarningText": "#d29922",
          "loglineText": "#8b949e",
          "loglineNumText": "#6e7681",
          "loglineDebugText": "#a371f7",
          "loglineErrorText": "#8b949e",
          "loglineErrorNumText": "#6e7681",
          "loglineErrorBg": "rgba(248,81,73,0.15)",
          "loglineWarningText": "#8b949e",
          "loglineWarningNumText": "#d29922",
          "loglineWarningBg": "rgba(187,128,9,0.15)",
          "loglineCommandText": "#58a6ff",
          "loglineSectionText": "#3fb950",
          "ansi": {
            "black": "#0d1117",
            "blackBright": "#161b22",
            "white": "#b1bac4",
            "whiteBright": "#b1bac4",
            "gray": "#6e7681",
            "red": "#ff7b72",
            "redBright": "#ffa198",
            "green": "#3fb950",
            "greenBright": "#56d364",
            "yellow": "#d29922",
            "yellowBright": "#e3b341",
            "blue": "#58a6ff",
            "blueBright": "#79c0ff",
            "magenta": "#bc8cff",
            "magentaBright": "#d2a8ff",
            "cyan": "#76e3ea",
            "cyanBright": "#b3f0ff"
          }
        },
        "project": {
          "headerBg": "#0d1117",
          "sidebarBg": "#161b22",
          "gradientIn": "#161b22",
          "gradientOut": "rgba(22,27,34,0)"
        },
        "mktg": {
          "btn": {
            "bg": "#f6f8fa"
          }
        },
        "avatar": {
          "bg": "rgba(255,255,255,0.1)",
          "border": "rgba(240,246,252,0.1)",
          "stackFade": "#30363d",
          "stackFadeMore": "#21262d"
        },
        "topicTag": {
          "border": "rgba(0,0,0,0)"
        },
        "counter": {
          "border": "rgba(0,0,0,0)"
        },
        "selectMenu": {
          "backdropBorder": "#484f58",
          "tapHighlight": "rgba(48,54,61,0.5)",
          "tapFocusBg": "#0c2d6b"
        },
        "header": {
          "text": "rgba(255,255,255,0.7)",
          "bg": "#161b22",
          "divider": "#8b949e",
          "logo": "#f0f6fc"
        },
        "headerSearch": {
          "bg": "#0d1117",
          "border": "#30363d"
        },
        "sidenav": {
          "selectedBg": "#21262d"
        },
        "menu": {
          "bgActive": "#161b22"
        },
        "input": {
          "disabledBg": "rgba(110,118,129,0)"
        },
        "timeline": {
          "badgeBg": "#21262d"
        },
        "ansi": {
          "black": "#484f58",
          "blackBright": "#6e7681",
          "white": "#b1bac4",
          "whiteBright": "#ffffff",
          "gray": "#6e7681",
          "red": "#ff7b72",
          "redBright": "#ffa198",
          "green": "#3fb950",
          "greenBright": "#56d364",
          "yellow": "#d29922",
          "yellowBright": "#e3b341",
          "blue": "#58a6ff",
          "blueBright": "#79c0ff",
          "magenta": "#bc8cff",
          "magentaBright": "#d2a8ff",
          "cyan": "#39c5cf",
          "cyanBright": "#56d4dd"
        },
        "btn": {
          "text": "#c9d1d9",
          "bg": "#21262d",
          "border": "rgba(240,246,252,0.1)",
          "hoverBg": "#30363d",
          "hoverBorder": "#8b949e",
          "activeBg": "hsla(212,12%,18%,1)",
          "activeBorder": "#6e7681",
          "selectedBg": "#161b22",
          "focusBg": "#21262d",
          "focusBorder": "#8b949e",
          "counterBg": "#30363d",
          "primary": {
            "text": "#ffffff",
            "bg": "#238636",
            "border": "rgba(240,246,252,0.1)",
            "hoverBg": "#2ea043",
            "hoverBorder": "rgba(240,246,252,0.1)",
            "selectedBg": "#238636",
            "disabledText": "rgba(255,255,255,0.5)",
            "disabledBg": "rgba(35,134,54,0.6)",
            "disabledBorder": "rgba(240,246,252,0.1)",
            "focusBg": "#238636",
            "focusBorder": "rgba(240,246,252,0.1)",
            "icon": "#ffffff",
            "counterBg": "rgba(255,255,255,0.2)"
          },
          "outline": {
            "text": "#58a6ff",
            "hoverText": "#58a6ff",
            "hoverBg": "#30363d",
            "hoverBorder": "rgba(240,246,252,0.1)",
            "hoverCounterBg": "rgba(255,255,255,0.2)",
            "selectedText": "#ffffff",
            "selectedBg": "#0d419d",
            "selectedBorder": "rgba(240,246,252,0.1)",
            "disabledText": "rgba(88,166,255,0.5)",
            "disabledBg": "#0d1117",
            "disabledCounterBg": "rgba(31,111,235,0.05)",
            "focusBorder": "rgba(240,246,252,0.1)",
            "counterBg": "rgba(31,111,235,0.1)"
          },
          "danger": {
            "text": "#f85149",
            "hoverText": "#ffffff",
            "hoverBg": "#da3633",
            "hoverBorder": "#f85149",
            "hoverIcon": "#ffffff",
            "hoverCounterBg": "rgba(255,255,255,0.2)",
            "selectedText": "#ffffff",
            "selectedBg": "#b62324",
            "selectedBorder": "#ff7b72",
            "disabledText": "rgba(248,81,73,0.5)",
            "disabledBg": "#0d1117",
            "disabledCounterBg": "rgba(218,54,51,0.05)",
            "focusBorder": "#f85149",
            "counterBg": "rgba(218,54,51,0.1)",
            "icon": "#f85149"
          }
        },
        "underlinenav": {
          "icon": "#6e7681",
          "borderHover": "rgba(110,118,129,0.4)"
        },
        "actionListItem": {
          "inlineDivider": "rgba(48,54,61,0.48)",
          "default": {
            "hoverBg": "rgba(177,186,196,0.12)",
            "hoverBorder": "rgba(0,0,0,0)",
            "activeBg": "rgba(177,186,196,0.2)",
            "activeBorder": "rgba(0,0,0,0)",
            "selectedBg": "rgba(177,186,196,0.08)"
          },
          "danger": {
            "hoverBg": "rgba(248,81,73,0.16)",
            "activeBg": "rgba(248,81,73,0.24)",
            "hoverText": "#ff7b72"
          }
        },
        "switchTrack": {
          "bg": "#010409",
          "border": "#6e7681",
          "checked": {
            "bg": "rgba(31,111,235,0.35)",
            "hoverBg": "rgba(31,111,235,0.5)",
            "activeBg": "rgba(31,111,235,0.65)",
            "border": "#58a6ff"
          }
        },
        "switchKnob": {
          "checked": {
            "bg": "#1f6feb",
            "disabledBg": "#484f58"
          }
        },
        "segmentedControl": {
          "bg": "#161b22",
          "button": {
            "hover": {
              "bg": "#30363d"
            },
            "active": {
              "bg": "#21262d"
            },
            "selected": {
              "border": "#6e7681"
            }
          }
        },
        "treeViewItem": {
          "chevron": {
            "hoverBg": "rgba(177,186,196,0.12)"
          },
          "directory": {
            "fill": "#8b949e"
          }
        },
        "fg": {
          "default": "#c9d1d9",
          "muted": "#8b949e",
          "subtle": "#6e7681",
          "onEmphasis": "#ffffff"
        },
        "canvas": {
          "default": "#0d1117",
          "overlay": "#161b22",
          "inset": "#010409",
          "subtle": "#161b22"
        },
        "border": {
          "default": "#30363d",
          "muted": "#21262d",
          "subtle": "rgba(240,246,252,0.1)"
        },
        "neutral": {
          "emphasisPlus": "#6e7681",
          "emphasis": "#6e7681",
          "muted": "rgba(110,118,129,0.4)",
          "subtle": "rgba(110,118,129,0.1)"
        },
        "accent": {
          "fg": "#58a6ff",
          "emphasis": "#1f6feb",
          "muted": "rgba(56,139,253,0.4)",
          "subtle": "rgba(56,139,253,0.15)"
        },
        "success": {
          "fg": "#3fb950",
          "emphasis": "#238636",
          "muted": "rgba(46,160,67,0.4)",
          "subtle": "rgba(46,160,67,0.15)"
        },
        "attention": {
          "fg": "#d29922",
          "emphasis": "#9e6a03",
          "muted": "rgba(187,128,9,0.4)",
          "subtle": "rgba(187,128,9,0.15)"
        },
        "severe": {
          "fg": "#db6d28",
          "emphasis": "#bd561d",
          "muted": "rgba(219,109,40,0.4)",
          "subtle": "rgba(219,109,40,0.15)"
        },
        "danger": {
          "fg": "#f85149",
          "emphasis": "#da3633",
          "muted": "rgba(248,81,73,0.4)",
          "subtle": "rgba(248,81,73,0.15)"
        },
        "open": {
          "fg": "#3fb950",
          "emphasis": "#238636",
          "muted": "rgba(46,160,67,0.4)",
          "subtle": "rgba(46,160,67,0.15)"
        },
        "closed": {
          "fg": "#f85149",
          "emphasis": "#da3633",
          "muted": "rgba(248,81,73,0.4)",
          "subtle": "rgba(248,81,73,0.15)"
        },
        "done": {
          "fg": "#a371f7",
          "emphasis": "#8957e5",
          "muted": "rgba(163,113,247,0.4)",
          "subtle": "rgba(163,113,247,0.15)"
        },
        "sponsors": {
          "fg": "#db61a2",
          "emphasis": "#bf4b8a",
          "muted": "rgba(219,97,162,0.4)",
          "subtle": "rgba(219,97,162,0.15)"
        },
        "primer": {
          "fg": {
            "disabled": "#484f58"
          },
          "canvas": {
            "backdrop": "rgba(1,4,9,0.8)",
            "sticky": "rgba(13,17,23,0.95)"
          },
          "border": {
            "active": "#f78166",
            "contrast": "rgba(255,255,255,0.2)"
          }
        }
      },
      "shadows": {
        "checks": {
          "inputShadow": "0 0 0 1px (obj) => (0, get_1.default)(obj, path)"
        },
        "mktg": {
          "btn": {
            "shadow": {
              "outline": "rgb(255 255 255 / 25%) 0 0 0 1px inset",
              "focus": "rgb(255 255 255 / 25%) 0 0 0 4px",
              "hover": "0 4px 7px rgba(0, 0, 0, 0.15), 0 100px 80px rgba(255, 255, 255, 0.02), 0 42px 33px rgba(255, 255, 255, 0.024), 0 22px 18px rgba(255, 255, 255, 0.028), 0 12px 10px rgba(255, 255, 255, 0.034), 0 7px 5px rgba(255, 255, 255, 0.04), 0 3px 2px rgba(255, 255, 255, 0.07)",
              "hoverMuted": "rgb(255 255 255) 0 0 0 2px inset"
            }
          }
        },
        "avatar": {
          "childShadow": "-2px -2px 0 #0d1117"
        },
        "overlay": {
          "shadow": "0 0 0 1px #30363d, 0 16px 32px rgba(1,4,9,0.85)"
        },
        "btn": {
          "shadow": "0 0 transparent",
          "insetShadow": "0 0 transparent",
          "focusShadow": "0 0 0 3px rgba(139,148,158,0.3)",
          "shadowActive": "inset 0 0.15em 0.3em rgba(1,4,9,0.15)",
          "shadowInputFocus": "0 0 0 0.2em rgba(31,111,235,0.3)",
          "primary": {
            "shadow": "0 0 transparent",
            "insetShadow": "0 0 transparent",
            "selectedShadow": "0 0 transparent",
            "focusShadow": "0 0 0 3px rgba(46,164,79,0.4)"
          },
          "outline": {
            "hoverShadow": "0 1px 0 rgba(1,4,9,0.1)",
            "hoverInsetShadow": "inset 0 1px 0 rgba(255,255,255,0.03)",
            "selectedShadow": "0 0 transparent",
            "focusShadow": "0 0 0 3px rgba(17,88,199,0.4)"
          },
          "danger": {
            "hoverShadow": "0 0 transparent",
            "hoverInsetShadow": "0 0 transparent",
            "selectedShadow": "0 0 transparent",
            "focusShadow": "0 0 0 3px rgba(248,81,73,0.4)"
          }
        },
        "shadow": {
          "small": "0 0 transparent",
          "medium": "0 3px 6px #010409",
          "large": "0 8px 24px #010409",
          "extraLarge": "0 12px 48px #010409"
        },
        "primer": {
          "shadow": {
            "highlight": "0 0 transparent",
            "inset": "0 0 transparent",
            "focus": "0 0 0 3px #0c2d6b"
          }
        }
      }
    },
    "dark_dimmed": {
      "colors": {
        "canvasDefaultTransparent": "rgba(34,39,46,0)",
        "pageHeaderBg": "#22272e",
        "marketingIcon": {
          "primary": "#6cb6ff",
          "secondary": "#316dca"
        },
        "diffBlob": {
          "addition": {
            "numText": "#adbac7",
            "fg": "#adbac7",
            "numBg": "rgba(87,171,90,0.3)",
            "lineBg": "rgba(70,149,74,0.15)",
            "wordBg": "rgba(70,149,74,0.4)"
          },
          "deletion": {
            "numText": "#adbac7",
            "fg": "#adbac7",
            "numBg": "rgba(229,83,75,0.3)",
            "lineBg": "rgba(229,83,75,0.15)",
            "wordBg": "rgba(229,83,75,0.4)"
          },
          "hunk": {
            "numBg": "rgba(65,132,228,0.4)"
          },
          "expander": {
            "icon": "#768390"
          }
        },
        "diffstat": {
          "deletionBorder": "rgba(205,217,229,0.1)",
          "additionBorder": "rgba(205,217,229,0.1)",
          "additionBg": "#57ab5a"
        },
        "searchKeyword": {
          "hl": "rgba(198,144,38,0.4)"
        },
        "prettylights": {
          "syntax": {
            "comment": "#768390",
            "constant": "#6cb6ff",
            "entity": "#dcbdfb",
            "storageModifierImport": "#adbac7",
            "entityTag": "#8ddb8c",
            "keyword": "#f47067",
            "string": "#96d0ff",
            "variable": "#f69d50",
            "brackethighlighterUnmatched": "#e5534b",
            "invalidIllegalText": "#cdd9e5",
            "invalidIllegalBg": "#922323",
            "carriageReturnText": "#cdd9e5",
            "carriageReturnBg": "#ad2e2c",
            "stringRegexp": "#8ddb8c",
            "markupList": "#eac55f",
            "markupHeading": "#316dca",
            "markupItalic": "#adbac7",
            "markupBold": "#adbac7",
            "markupDeletedText": "#ffd8d3",
            "markupDeletedBg": "#78191b",
            "markupInsertedText": "#b4f1b4",
            "markupInsertedBg": "#1b4721",
            "markupChangedText": "#ffddb0",
            "markupChangedBg": "#682d0f",
            "markupIgnoredText": "#adbac7",
            "markupIgnoredBg": "#255ab2",
            "metaDiffRange": "#dcbdfb",
            "brackethighlighterAngle": "#768390",
            "sublimelinterGutterMark": "#545d68",
            "constantOtherReferenceLink": "#96d0ff"
          }
        },
        "codemirror": {
          "text": "#adbac7",
          "bg": "#22272e",
          "guttersBg": "#22272e",
          "guttermarkerText": "#22272e",
          "guttermarkerSubtleText": "#636e7b",
          "linenumberText": "#768390",
          "cursor": "#adbac7",
          "selectionBg": "rgba(65,132,228,0.4)",
          "activelineBg": "rgba(99,110,123,0.1)",
          "matchingbracketText": "#adbac7",
          "linesBg": "#22272e",
          "syntax": {
            "comment": "#768390",
            "constant": "#6cb6ff",
            "entity": "#dcbdfb",
            "keyword": "#f47067",
            "storage": "#f47067",
            "string": "#96d0ff",
            "support": "#6cb6ff",
            "variable": "#f69d50"
          }
        },
        "checks": {
          "bg": "#1c2128",
          "textPrimary": "#adbac7",
          "textSecondary": "#768390",
          "textLink": "#539bf5",
          "btnIcon": "#768390",
          "btnHoverIcon": "#adbac7",
          "btnHoverBg": "rgba(99,110,123,0.1)",
          "inputText": "#768390",
          "inputPlaceholderText": "#636e7b",
          "inputFocusText": "#adbac7",
          "inputBg": "#2d333b",
          "donutError": "#e5534b",
          "donutPending": "#c69026",
          "donutSuccess": "#46954a",
          "donutNeutral": "#768390",
          "dropdownText": "#adbac7",
          "dropdownBg": "#2d333b",
          "dropdownBorder": "#444c56",
          "dropdownShadow": "rgba(28,33,40,0.3)",
          "dropdownHoverText": "#adbac7",
          "dropdownHoverBg": "rgba(99,110,123,0.1)",
          "dropdownBtnHoverText": "#adbac7",
          "dropdownBtnHoverBg": "rgba(99,110,123,0.1)",
          "scrollbarThumbBg": "rgba(99,110,123,0.4)",
          "headerLabelText": "#768390",
          "headerLabelOpenText": "#adbac7",
          "headerBorder": "#373e47",
          "headerIcon": "#768390",
          "lineText": "#768390",
          "lineNumText": "#636e7b",
          "lineTimestampText": "#636e7b",
          "lineHoverBg": "rgba(99,110,123,0.1)",
          "lineSelectedBg": "rgba(65,132,228,0.15)",
          "lineSelectedNumText": "#539bf5",
          "lineDtFmText": "#cdd9e5",
          "lineDtFmBg": "#966600",
          "gateBg": "rgba(174,124,20,0.15)",
          "gateText": "#768390",
          "gateWaitingText": "#c69026",
          "stepHeaderOpenBg": "#2d333b",
          "stepErrorText": "#e5534b",
          "stepWarningText": "#c69026",
          "loglineText": "#768390",
          "loglineNumText": "#636e7b",
          "loglineDebugText": "#986ee2",
          "loglineErrorText": "#768390",
          "loglineErrorNumText": "#636e7b",
          "loglineErrorBg": "rgba(229,83,75,0.15)",
          "loglineWarningText": "#768390",
          "loglineWarningNumText": "#c69026",
          "loglineWarningBg": "rgba(174,124,20,0.15)",
          "loglineCommandText": "#539bf5",
          "loglineSectionText": "#57ab5a",
          "ansi": {
            "black": "#22272e",
            "blackBright": "#2d333b",
            "white": "#909dab",
            "whiteBright": "#909dab",
            "gray": "#636e7b",
            "red": "#f47067",
            "redBright": "#ff938a",
            "green": "#57ab5a",
            "greenBright": "#6bc46d",
            "yellow": "#c69026",
            "yellowBright": "#daaa3f",
            "blue": "#539bf5",
            "blueBright": "#6cb6ff",
            "magenta": "#b083f0",
            "magentaBright": "#dcbdfb",
            "cyan": "#76e3ea",
            "cyanBright": "#b3f0ff"
          }
        },
        "project": {
          "headerBg": "#22272e",
          "sidebarBg": "#2d333b",
          "gradientIn": "#2d333b",
          "gradientOut": "rgba(45,51,59,0)"
        },
        "mktg": {
          "btn": {
            "bg": "#f6f8fa"
          }
        },
        "avatar": {
          "bg": "rgba(205,217,229,0.1)",
          "border": "rgba(205,217,229,0.1)",
          "stackFade": "#444c56",
          "stackFadeMore": "#373e47"
        },
        "topicTag": {
          "border": "rgba(0,0,0,0)"
        },
        "counter": {
          "border": "rgba(0,0,0,0)"
        },
        "selectMenu": {
          "backdropBorder": "#545d68",
          "tapHighlight": "rgba(68,76,86,0.5)",
          "tapFocusBg": "#143d79"
        },
        "header": {
          "text": "rgba(205,217,229,0.7)",
          "bg": "#2d333b",
          "divider": "#768390",
          "logo": "#cdd9e5"
        },
        "headerSearch": {
          "bg": "#22272e",
          "border": "#444c56"
        },
        "sidenav": {
          "selectedBg": "#373e47"
        },
        "menu": {
          "bgActive": "#2d333b"
        },
        "input": {
          "disabledBg": "rgba(99,110,123,0)"
        },
        "timeline": {
          "badgeBg": "#373e47"
        },
        "ansi": {
          "black": "#545d68",
          "blackBright": "#636e7b",
          "white": "#909dab",
          "whiteBright": "#cdd9e5",
          "gray": "#636e7b",
          "red": "#f47067",
          "redBright": "#ff938a",
          "green": "#57ab5a",
          "greenBright": "#6bc46d",
          "yellow": "#c69026",
          "yellowBright": "#daaa3f",
          "blue": "#539bf5",
          "blueBright": "#6cb6ff",
          "magenta": "#b083f0",
          "magentaBright": "#dcbdfb",
          "cyan": "#39c5cf",
          "cyanBright": "#56d4dd"
        },
        "btn": {
          "text": "#adbac7",
          "bg": "#373e47",
          "border": "rgba(205,217,229,0.1)",
          "hoverBg": "#444c56",
          "hoverBorder": "#768390",
          "activeBg": "hsla(213,12%,27%,1)",
          "activeBorder": "#636e7b",
          "selectedBg": "#2d333b",
          "focusBg": "#373e47",
          "focusBorder": "#768390",
          "counterBg": "#444c56",
          "primary": {
            "text": "#ffffff",
            "bg": "#347d39",
            "border": "rgba(205,217,229,0.1)",
            "hoverBg": "#46954a",
            "hoverBorder": "rgba(205,217,229,0.1)",
            "selectedBg": "#347d39",
            "disabledText": "rgba(205,217,229,0.5)",
            "disabledBg": "rgba(52,125,57,0.6)",
            "disabledBorder": "rgba(205,217,229,0.1)",
            "focusBg": "#347d39",
            "focusBorder": "rgba(205,217,229,0.1)",
            "icon": "#cdd9e5",
            "counterBg": "rgba(205,217,229,0.2)"
          },
          "outline": {
            "text": "#539bf5",
            "hoverText": "#539bf5",
            "hoverBg": "#444c56",
            "hoverBorder": "rgba(205,217,229,0.1)",
            "hoverCounterBg": "rgba(205,217,229,0.2)",
            "selectedText": "#cdd9e5",
            "selectedBg": "#1b4b91",
            "selectedBorder": "rgba(205,217,229,0.1)",
            "disabledText": "rgba(83,155,245,0.5)",
            "disabledBg": "#22272e",
            "disabledCounterBg": "rgba(49,109,202,0.05)",
            "focusBorder": "rgba(205,217,229,0.1)",
            "counterBg": "rgba(49,109,202,0.1)"
          },
          "danger": {
            "text": "#e5534b",
            "hoverText": "#cdd9e5",
            "hoverBg": "#c93c37",
            "hoverBorder": "#e5534b",
            "hoverIcon": "#cdd9e5",
            "hoverCounterBg": "rgba(255,255,255,0.2)",
            "selectedText": "#ffffff",
            "selectedBg": "#ad2e2c",
            "selectedBorder": "#f47067",
            "disabledText": "rgba(229,83,75,0.5)",
            "disabledBg": "#22272e",
            "disabledCounterBg": "rgba(201,60,55,0.05)",
            "focusBorder": "#e5534b",
            "counterBg": "rgba(201,60,55,0.1)",
            "icon": "#e5534b"
          }
        },
        "underlinenav": {
          "icon": "#636e7b",
          "borderHover": "rgba(99,110,123,0.4)"
        },
        "actionListItem": {
          "inlineDivider": "rgba(68,76,86,0.48)",
          "default": {
            "hoverBg": "rgba(144,157,171,0.12)",
            "hoverBorder": "rgba(0,0,0,0)",
            "activeBg": "rgba(144,157,171,0.2)",
            "activeBorder": "rgba(0,0,0,0)",
            "selectedBg": "rgba(144,157,171,0.08)"
          },
          "danger": {
            "hoverBg": "rgba(229,83,75,0.16)",
            "activeBg": "rgba(229,83,75,0.24)",
            "hoverText": "#f47067"
          }
        },
        "switchTrack": {
          "bg": "#1c2128",
          "border": "#636e7b",
          "checked": {
            "bg": "rgba(49,109,202,0.35)",
            "hoverBg": "rgba(49,109,202,0.5)",
            "activeBg": "rgba(49,109,202,0.65)",
            "border": "#539bf5"
          }
        },
        "switchKnob": {
          "checked": {
            "bg": "#316dca",
            "disabledBg": "#545d68"
          }
        },
        "segmentedControl": {
          "bg": "#2d333b",
          "button": {
            "hover": {
              "bg": "#444c56"
            },
            "active": {
              "bg": "#373e47"
            },
            "selected": {
              "border": "#636e7b"
            }
          }
        },
        "treeViewItem": {
          "chevron": {
            "hoverBg": "rgba(144,157,171,0.12)"
          },
          "directory": {
            "fill": "#768390"
          }
        },
        "fg": {
          "default": "#adbac7",
          "muted": "#768390",
          "subtle": "#636e7b",
          "onEmphasis": "#cdd9e5"
        },
        "canvas": {
          "default": "#22272e",
          "overlay": "#2d333b",
          "inset": "#1c2128",
          "subtle": "#2d333b"
        },
        "border": {
          "default": "#444c56",
          "muted": "#373e47",
          "subtle": "rgba(205,217,229,0.1)"
        },
        "neutral": {
          "emphasisPlus": "#636e7b",
          "emphasis": "#636e7b",
          "muted": "rgba(99,110,123,0.4)",
          "subtle": "rgba(99,110,123,0.1)"
        },
        "accent": {
          "fg": "#539bf5",
          "emphasis": "#316dca",
          "muted": "rgba(65,132,228,0.4)",
          "subtle": "rgba(65,132,228,0.15)"
        },
        "success": {
          "fg": "#57ab5a",
          "emphasis": "#347d39",
          "muted": "rgba(70,149,74,0.4)",
          "subtle": "rgba(70,149,74,0.15)"
        },
        "attention": {
          "fg": "#c69026",
          "emphasis": "#966600",
          "muted": "rgba(174,124,20,0.4)",
          "subtle": "rgba(174,124,20,0.15)"
        },
        "severe": {
          "fg": "#cc6b2c",
          "emphasis": "#ae5622",
          "muted": "rgba(204,107,44,0.4)",
          "subtle": "rgba(204,107,44,0.15)"
        },
        "danger": {
          "fg": "#e5534b",
          "emphasis": "#c93c37",
          "muted": "rgba(229,83,75,0.4)",
          "subtle": "rgba(229,83,75,0.15)"
        },
        "open": {
          "fg": "#57ab5a",
          "emphasis": "#347d39",
          "muted": "rgba(70,149,74,0.4)",
          "subtle": "rgba(70,149,74,0.15)"
        },
        "closed": {
          "fg": "#e5534b",
          "emphasis": "#c93c37",
          "muted": "rgba(229,83,75,0.4)",
          "subtle": "rgba(229,83,75,0.15)"
        },
        "done": {
          "fg": "#986ee2",
          "emphasis": "#8256d0",
          "muted": "rgba(152,110,226,0.4)",
          "subtle": "rgba(152,110,226,0.15)"
        },
        "sponsors": {
          "fg": "#c96198",
          "emphasis": "#ae4c82",
          "muted": "rgba(201,97,152,0.4)",
          "subtle": "rgba(201,97,152,0.15)"
        },
        "primer": {
          "fg": {
            "disabled": "#545d68"
          },
          "canvas": {
            "backdrop": "rgba(28,33,40,0.8)",
            "sticky": "rgba(34,39,46,0.95)"
          },
          "border": {
            "active": "#ec775c",
            "contrast": "rgba(205,217,229,0.2)"
          }
        }
      },
      "shadows": {
        "checks": {
          "inputShadow": "0 0 0 1px (obj) => (0, get_1.default)(obj, path)"
        },
        "mktg": {
          "btn": {
            "shadow": {
              "outline": "rgb(255 255 255 / 25%) 0 0 0 1px inset",
              "focus": "rgb(255 255 255 / 25%) 0 0 0 4px",
              "hover": "0 4px 7px rgba(0, 0, 0, 0.15), 0 100px 80px rgba(255, 255, 255, 0.02), 0 42px 33px rgba(255, 255, 255, 0.024), 0 22px 18px rgba(255, 255, 255, 0.028), 0 12px 10px rgba(255, 255, 255, 0.034), 0 7px 5px rgba(255, 255, 255, 0.04), 0 3px 2px rgba(255, 255, 255, 0.07)",
              "hoverMuted": "rgb(255 255 255) 0 0 0 2px inset"
            }
          }
        },
        "avatar": {
          "childShadow": "-2px -2px 0 #22272e"
        },
        "overlay": {
          "shadow": "0 0 0 1px #444c56, 0 16px 32px rgba(28,33,40,0.85)"
        },
        "btn": {
          "shadow": "0 0 transparent",
          "insetShadow": "0 0 transparent",
          "focusShadow": "0 0 0 3px rgba(118,131,144,0.3)",
          "shadowActive": "inset 0 0.15em 0.3em rgba(28,33,40,0.15)",
          "shadowInputFocus": "0 0 0 0.2em rgba(49,109,202,0.3)",
          "primary": {
            "shadow": "0 0 transparent",
            "insetShadow": "0 0 transparent",
            "selectedShadow": "0 0 transparent",
            "focusShadow": "0 0 0 3px rgba(46,164,79,0.4)"
          },
          "outline": {
            "hoverShadow": "0 1px 0 rgba(28,33,40,0.1)",
            "hoverInsetShadow": "inset 0 1px 0 rgba(205,217,229,0.03)",
            "selectedShadow": "0 0 transparent",
            "focusShadow": "0 0 0 3px rgba(37,90,178,0.4)"
          },
          "danger": {
            "hoverShadow": "0 0 transparent",
            "hoverInsetShadow": "0 0 transparent",
            "selectedShadow": "0 0 transparent",
            "focusShadow": "0 0 0 3px rgba(229,83,75,0.4)"
          }
        },
        "shadow": {
          "small": "0 0 transparent",
          "medium": "0 3px 6px #1c2128",
          "large": "0 8px 24px #1c2128",
          "extraLarge": "0 12px 48px #1c2128"
        },
        "primer": {
          "shadow": {
            "highlight": "0 0 transparent",
            "inset": "0 0 transparent",
            "focus": "0 0 0 3px #143d79"
          }
        }
      }
    },
    "dark_high_contrast": {
      "colors": {
        "canvasDefaultTransparent": "rgba(10,12,16,0)",
        "pageHeaderBg": "#0a0c10",
        "marketingIcon": {
          "primary": "#91cbff",
          "secondary": "#409eff"
        },
        "diffBlob": {
          "addition": {
            "numText": "#f0f3f6",
            "fg": "#0a0c10",
            "numBg": "rgba(38,205,77,0.3)",
            "lineBg": "rgba(9,180,58,0.15)",
            "wordBg": "#09b43a"
          },
          "deletion": {
            "numText": "#f0f3f6",
            "fg": "#0a0c10",
            "numBg": "rgba(255,106,105,0.3)",
            "lineBg": "rgba(255,106,105,0.15)",
            "wordBg": "#ff6a69"
          },
          "hunk": {
            "numBg": "rgba(64,158,255,0.4)"
          },
          "expander": {
            "icon": "#f0f3f6"
          }
        },
        "diffstat": {
          "deletionBorder": "#ffb1af",
          "additionBorder": "#4ae168",
          "additionBg": "#26cd4d"
        },
        "searchKeyword": {
          "hl": "rgba(240,183,47,0.4)"
        },
        "prettylights": {
          "syntax": {
            "comment": "#bdc4cc",
            "constant": "#91cbff",
            "entity": "#dbb7ff",
            "storageModifierImport": "#f0f3f6",
            "entityTag": "#72f088",
            "keyword": "#ff9492",
            "string": "#addcff",
            "variable": "#ffb757",
            "brackethighlighterUnmatched": "#ff6a69",
            "invalidIllegalText": "#ffffff",
            "invalidIllegalBg": "#e82a2f",
            "carriageReturnText": "#ffffff",
            "carriageReturnBg": "#ff4445",
            "stringRegexp": "#72f088",
            "markupList": "#fbd669",
            "markupHeading": "#409eff",
            "markupItalic": "#f0f3f6",
            "markupBold": "#f0f3f6",
            "markupDeletedText": "#ffdedb",
            "markupDeletedBg": "#cc1421",
            "markupInsertedText": "#acf7b6",
            "markupInsertedBg": "#007728",
            "markupChangedText": "#ffe1b4",
            "markupChangedBg": "#a74c00",
            "markupIgnoredText": "#f0f3f6",
            "markupIgnoredBg": "#318bf8",
            "metaDiffRange": "#dbb7ff",
            "brackethighlighterAngle": "#bdc4cc",
            "sublimelinterGutterMark": "#7a828e",
            "constantOtherReferenceLink": "#addcff"
          }
        },
        "codemirror": {
          "text": "#f0f3f6",
          "bg": "#0a0c10",
          "guttersBg": "#0a0c10",
          "guttermarkerText": "#0a0c10",
          "guttermarkerSubtleText": "#9ea7b3",
          "linenumberText": "#f0f3f6",
          "cursor": "#f0f3f6",
          "selectionBg": "rgba(64,158,255,0.4)",
          "activelineBg": "rgba(158,167,179,0.1)",
          "matchingbracketText": "#f0f3f6",
          "linesBg": "#0a0c10",
          "syntax": {
            "comment": "#bdc4cc",
            "constant": "#91cbff",
            "entity": "#dbb7ff",
            "keyword": "#ff9492",
            "storage": "#ff9492",
            "string": "#addcff",
            "support": "#91cbff",
            "variable": "#ffb757"
          }
        },
        "checks": {
          "bg": "#010409",
          "textPrimary": "#f0f3f6",
          "textSecondary": "#f0f3f6",
          "textLink": "#71b7ff",
          "btnIcon": "#f0f3f6",
          "btnHoverIcon": "#f0f3f6",
          "btnHoverBg": "rgba(158,167,179,0.1)",
          "inputText": "#f0f3f6",
          "inputPlaceholderText": "#9ea7b3",
          "inputFocusText": "#f0f3f6",
          "inputBg": "#272b33",
          "donutError": "#ff6a69",
          "donutPending": "#f0b72f",
          "donutSuccess": "#09b43a",
          "donutNeutral": "#bdc4cc",
          "dropdownText": "#f0f3f6",
          "dropdownBg": "#272b33",
          "dropdownBorder": "#7a828e",
          "dropdownShadow": "rgba(1,4,9,0.3)",
          "dropdownHoverText": "#f0f3f6",
          "dropdownHoverBg": "rgba(158,167,179,0.1)",
          "dropdownBtnHoverText": "#f0f3f6",
          "dropdownBtnHoverBg": "rgba(158,167,179,0.1)",
          "scrollbarThumbBg": "rgba(158,167,179,0.4)",
          "headerLabelText": "#f0f3f6",
          "headerLabelOpenText": "#f0f3f6",
          "headerBorder": "#7a828e",
          "headerIcon": "#f0f3f6",
          "lineText": "#f0f3f6",
          "lineNumText": "#9ea7b3",
          "lineTimestampText": "#9ea7b3",
          "lineHoverBg": "rgba(158,167,179,0.1)",
          "lineSelectedBg": "rgba(64,158,255,0.15)",
          "lineSelectedNumText": "#71b7ff",
          "lineDtFmText": "#0a0c10",
          "lineDtFmBg": "#e09b13",
          "gateBg": "rgba(224,155,19,0.15)",
          "gateText": "#f0f3f6",
          "gateWaitingText": "#f0b72f",
          "stepHeaderOpenBg": "#272b33",
          "stepErrorText": "#ff6a69",
          "stepWarningText": "#f0b72f",
          "loglineText": "#f0f3f6",
          "loglineNumText": "#9ea7b3",
          "loglineDebugText": "#b780ff",
          "loglineErrorText": "#f0f3f6",
          "loglineErrorNumText": "#9ea7b3",
          "loglineErrorBg": "rgba(255,106,105,0.15)",
          "loglineWarningText": "#f0f3f6",
          "loglineWarningNumText": "#f0b72f",
          "loglineWarningBg": "rgba(224,155,19,0.15)",
          "loglineCommandText": "#71b7ff",
          "loglineSectionText": "#26cd4d",
          "ansi": {
            "black": "#0a0c10",
            "blackBright": "#272b33",
            "white": "#d9dee3",
            "whiteBright": "#d9dee3",
            "gray": "#9ea7b3",
            "red": "#ff9492",
            "redBright": "#ffb1af",
            "green": "#26cd4d",
            "greenBright": "#4ae168",
            "yellow": "#f0b72f",
            "yellowBright": "#f7c843",
            "blue": "#71b7ff",
            "blueBright": "#91cbff",
            "magenta": "#cb9eff",
            "magentaBright": "#dbb7ff",
            "cyan": "#76e3ea",
            "cyanBright": "#b3f0ff"
          }
        },
        "project": {
          "headerBg": "#0a0c10",
          "sidebarBg": "#272b33",
          "gradientIn": "#272b33",
          "gradientOut": "rgba(39,43,51,0)"
        },
        "mktg": {
          "btn": {
            "bg": "#f6f8fa"
          }
        },
        "avatar": {
          "bg": "rgba(255,255,255,0.1)",
          "border": "rgba(255,255,255,0.9)",
          "stackFade": "#525964",
          "stackFadeMore": "#272b33"
        },
        "topicTag": {
          "border": "#409eff"
        },
        "counter": {
          "border": "rgba(0,0,0,0)"
        },
        "selectMenu": {
          "backdropBorder": "#7a828e",
          "tapHighlight": "rgba(82,89,100,0.5)",
          "tapFocusBg": "#1e60d5"
        },
        "header": {
          "text": "rgba(255,255,255,0.7)",
          "bg": "#272b33",
          "divider": "#bdc4cc",
          "logo": "#ffffff"
        },
        "headerSearch": {
          "bg": "#0a0c10",
          "border": "#525964"
        },
        "sidenav": {
          "selectedBg": "#272b33"
        },
        "menu": {
          "bgActive": "#272b33"
        },
        "input": {
          "disabledBg": "rgba(158,167,179,0)"
        },
        "timeline": {
          "badgeBg": "#272b33"
        },
        "ansi": {
          "black": "#7a828e",
          "blackBright": "#9ea7b3",
          "white": "#d9dee3",
          "whiteBright": "#ffffff",
          "gray": "#9ea7b3",
          "red": "#ff9492",
          "redBright": "#ffb1af",
          "green": "#26cd4d",
          "greenBright": "#4ae168",
          "yellow": "#f0b72f",
          "yellowBright": "#f7c843",
          "blue": "#71b7ff",
          "blueBright": "#91cbff",
          "magenta": "#cb9eff",
          "magentaBright": "#dbb7ff",
          "cyan": "#39c5cf",
          "cyanBright": "#56d4dd"
        },
        "btn": {
          "text": "#f0f3f6",
          "bg": "#272b33",
          "border": "#7a828e",
          "hoverBg": "#525964",
          "hoverBorder": "#bdc4cc",
          "activeBg": "hsla(217,10%,33%,1)",
          "activeBorder": "#9ea7b3",
          "selectedBg": "rgba(82,89,100,0.9)",
          "focusBg": "#272b33",
          "focusBorder": "#bdc4cc",
          "counterBg": "#525964",
          "primary": {
            "text": "#0a0c10",
            "bg": "#09b43a",
            "border": "#4ae168",
            "hoverBg": "#26cd4d",
            "hoverBorder": "#4ae168",
            "selectedBg": "#09b43a",
            "disabledText": "rgba(10,12,16,0.5)",
            "disabledBg": "rgba(9,180,58,0.6)",
            "disabledBorder": "rgba(74,225,104,0.4)",
            "focusBg": "#09b43a",
            "focusBorder": "#7a828e",
            "icon": "#0a0c10",
            "counterBg": "rgba(1,4,9,0.15)"
          },
          "outline": {
            "text": "#71b7ff",
            "hoverText": "#71b7ff",
            "hoverBg": "#525964",
            "hoverBorder": "#7a828e",
            "hoverCounterBg": "rgba(255,255,255,0.2)",
            "selectedText": "#ffffff",
            "selectedBg": "#2672f3",
            "selectedBorder": "#7a828e",
            "disabledText": "rgba(113,183,255,0.5)",
            "disabledBg": "#0a0c10",
            "disabledCounterBg": "rgba(64,158,255,0.05)",
            "focusBorder": "#7a828e",
            "counterBg": "rgba(64,158,255,0.1)"
          },
          "danger": {
            "text": "#ff6a69",
            "hoverText": "#0a0c10",
            "hoverBg": "#ff6a69",
            "hoverBorder": "#ff6a69",
            "hoverIcon": "#0a0c10",
            "hoverCounterBg": "rgba(1,4,9,0.15)",
            "selectedText": "#ffffff",
            "selectedBg": "#ff4445",
            "selectedBorder": "#ff9492",
            "disabledText": "rgba(255,106,105,0.5)",
            "disabledBg": "#0a0c10",
            "disabledCounterBg": "rgba(255,106,105,0.05)",
            "focusBorder": "#ff6a69",
            "counterBg": "rgba(1,4,9,0.15)",
            "icon": "#ff6a69"
          }
        },
        "underlinenav": {
          "icon": "#f0f3f6",
          "borderHover": "#bdc4cc"
        },
        "actionListItem": {
          "inlineDivider": "#7a828e",
          "default": {
            "hoverBg": "#272b33",
            "hoverBorder": "#7a828e",
            "activeBg": "#525964",
            "activeBorder": "#9ea7b3",
            "selectedBg": "#525964"
          },
          "danger": {
            "hoverBg": "#ff6a69",
            "activeBg": "#ff4445",
            "hoverText": "#0a0c10"
          }
        },
        "switchTrack": {
          "bg": "#010409",
          "border": "#7a828e",
          "checked": {
            "bg": "rgba(64,158,255,0.35)",
            "hoverBg": "rgba(64,158,255,0.5)",
            "activeBg": "rgba(64,158,255,0.65)",
            "border": "#409eff"
          }
        },
        "switchKnob": {
          "checked": {
            "bg": "#409eff",
            "disabledBg": "#7a828e"
          }
        },
        "segmentedControl": {
          "bg": "#272b33",
          "button": {
            "hover": {
              "bg": "#525964"
            },
            "active": {
              "bg": "#272b33"
            },
            "selected": {
              "border": "#9ea7b3"
            }
          }
        },
        "treeViewItem": {
          "chevron": {
            "hoverBg": "#525964"
          },
          "directory": {
            "fill": "#f0f3f6"
          }
        },
        "fg": {
          "default": "#f0f3f6",
          "muted": "#f0f3f6",
          "subtle": "#9ea7b3",
          "onEmphasis": "#0a0c10"
        },
        "canvas": {
          "default": "#0a0c10",
          "overlay": "#272b33",
          "inset": "#010409",
          "subtle": "#272b33"
        },
        "border": {
          "default": "#7a828e",
          "muted": "#7a828e",
          "subtle": "#7a828e"
        },
        "neutral": {
          "emphasisPlus": "#ffffff",
          "emphasis": "#9ea7b3",
          "muted": "rgba(158,167,179,0.4)",
          "subtle": "rgba(158,167,179,0.1)"
        },
        "accent": {
          "fg": "#71b7ff",
          "emphasis": "#409eff",
          "muted": "#409eff",
          "subtle": "rgba(64,158,255,0.15)"
        },
        "success": {
          "fg": "#26cd4d",
          "emphasis": "#09b43a",
          "muted": "#09b43a",
          "subtle": "rgba(9,180,58,0.15)"
        },
        "attention": {
          "fg": "#f0b72f",
          "emphasis": "#e09b13",
          "muted": "#e09b13",
          "subtle": "rgba(224,155,19,0.15)"
        },
        "severe": {
          "fg": "#e7811d",
          "emphasis": "#e7811d",
          "muted": "#e7811d",
          "subtle": "rgba(231,129,29,0.15)"
        },
        "danger": {
          "fg": "#ff6a69",
          "emphasis": "#ff6a69",
          "muted": "#ff6a69",
          "subtle": "rgba(255,106,105,0.15)"
        },
        "open": {
          "fg": "#26cd4d",
          "emphasis": "#09b43a",
          "muted": "rgba(9,180,58,0.4)",
          "subtle": "rgba(9,180,58,0.15)"
        },
        "closed": {
          "fg": "#ff6a69",
          "emphasis": "#ff6a69",
          "muted": "rgba(255,106,105,0.4)",
          "subtle": "rgba(255,106,105,0.15)"
        },
        "done": {
          "fg": "#b780ff",
          "emphasis": "#b87fff",
          "muted": "#b780ff",
          "subtle": "rgba(183,128,255,0.15)"
        },
        "sponsors": {
          "fg": "#ef6eb1",
          "emphasis": "#ef6eb1",
          "muted": "#ef6eb1",
          "subtle": "rgba(239,110,177,0.15)"
        },
        "primer": {
          "fg": {
            "disabled": "#7a828e"
          },
          "canvas": {
            "backdrop": "rgba(1,4,9,0.8)",
            "sticky": "rgba(10,12,16,0.95)"
          },
          "border": {
            "active": "#ff967d",
            "contrast": "rgba(255,255,255,0.2)"
          }
        }
      },
      "shadows": {
        "checks": {
          "inputShadow": "0 0 0 1px (obj) => (0, get_1.default)(obj, path)"
        },
        "mktg": {
          "btn": {
            "shadow": {
              "outline": "rgb(255 255 255 / 25%) 0 0 0 1px inset",
              "focus": "rgb(255 255 255 / 25%) 0 0 0 4px",
              "hover": "0 4px 7px rgba(0, 0, 0, 0.15), 0 100px 80px rgba(255, 255, 255, 0.02), 0 42px 33px rgba(255, 255, 255, 0.024), 0 22px 18px rgba(255, 255, 255, 0.028), 0 12px 10px rgba(255, 255, 255, 0.034), 0 7px 5px rgba(255, 255, 255, 0.04), 0 3px 2px rgba(255, 255, 255, 0.07)",
              "hoverMuted": "rgb(255 255 255) 0 0 0 2px inset"
            }
          }
        },
        "avatar": {
          "childShadow": "-2px -2px 0 #0a0c10"
        },
        "overlay": {
          "shadow": "0 0 0 1px #525964, 0 16px 32px rgba(1,4,9,0.85)"
        },
        "btn": {
          "shadow": "0 0 transparent",
          "insetShadow": "0 0 transparent",
          "focusShadow": "0 0 0 3px rgba(189,196,204,0.3)",
          "shadowActive": "inset 0 0.15em 0.3em rgba(1,4,9,0.15)",
          "shadowInputFocus": "0 0 0 0.2em rgba(64,158,255,0.3)",
          "primary": {
            "shadow": "0 0 transparent",
            "insetShadow": "0 0 transparent",
            "selectedShadow": "0 0 transparent",
            "focusShadow": "0 0 0 3px rgba(46,164,79,0.4)"
          },
          "outline": {
            "hoverShadow": "0 1px 0 rgba(1,4,9,0.1)",
            "hoverInsetShadow": "inset 0 1px 0 rgba(255,255,255,0.03)",
            "selectedShadow": "0 0 transparent",
            "focusShadow": "0 0 0 3px rgba(49,139,248,0.4)"
          },
          "danger": {
            "hoverShadow": "0 0 transparent",
            "hoverInsetShadow": "0 0 transparent",
            "selectedShadow": "0 0 transparent",
            "focusShadow": "0 0 0 3px rgba(255,106,105,0.4)"
          }
        },
        "shadow": {
          "small": "0 0 transparent",
          "medium": "0 3px 6px #010409",
          "large": "0 8px 24px #010409",
          "extraLarge": "0 12px 48px #010409"
        },
        "primer": {
          "shadow": {
            "highlight": "0 0 transparent",
            "inset": "0 0 transparent",
            "focus": "0 0 0 3px #1e60d5"
          }
        }
      }
    },
    "dark_colorblind": {
      "colors": {
        "canvasDefaultTransparent": "rgba(13,17,23,0)",
        "pageHeaderBg": "#0d1117",
        "marketingIcon": {
          "primary": "#79c0ff",
          "secondary": "#1f6feb"
        },
        "diffBlob": {
          "addition": {
            "numText": "#c9d1d9",
            "fg": "#c9d1d9",
            "numBg": "rgba(88,166,255,0.3)",
            "lineBg": "rgba(56,139,253,0.15)",
            "wordBg": "rgba(56,139,253,0.4)"
          },
          "deletion": {
            "numText": "#c9d1d9",
            "fg": "#c9d1d9",
            "numBg": "rgba(212,118,22,0.3)",
            "lineBg": "rgba(212,118,22,0.15)",
            "wordBg": "rgba(212,118,22,0.4)"
          },
          "hunk": {
            "numBg": "rgba(56,139,253,0.4)"
          },
          "expander": {
            "icon": "#8b949e"
          }
        },
        "diffstat": {
          "deletionBorder": "rgba(240,246,252,0.1)",
          "additionBorder": "rgba(240,246,252,0.1)",
          "additionBg": "#58a6ff"
        },
        "searchKeyword": {
          "hl": "rgba(210,153,34,0.4)"
        },
        "prettylights": {
          "syntax": {
            "comment": "#8b949e",
            "constant": "#79c0ff",
            "entity": "#d2a8ff",
            "storageModifierImport": "#c9d1d9",
            "entityTag": "#a5d6ff",
            "keyword": "#ec8e2c",
            "string": "#a5d6ff",
            "variable": "#fdac54",
            "brackethighlighterUnmatched": "#d47616",
            "invalidIllegalText": "#f0f6fc",
            "invalidIllegalBg": "#6c3906",
            "carriageReturnText": "#f0f6fc",
            "carriageReturnBg": "#914d04",
            "stringRegexp": "#a5d6ff",
            "markupList": "#f2cc60",
            "markupHeading": "#1f6feb",
            "markupItalic": "#c9d1d9",
            "markupBold": "#c9d1d9",
            "markupDeletedText": "#ffe2bb",
            "markupDeletedBg": "#4e2906",
            "markupInsertedText": "#cae8ff",
            "markupInsertedBg": "#0c2d6b",
            "markupChangedText": "#ffe2bb",
            "markupChangedBg": "#4e2906",
            "markupIgnoredText": "#c9d1d9",
            "markupIgnoredBg": "#1158c7",
            "metaDiffRange": "#d2a8ff",
            "brackethighlighterAngle": "#8b949e",
            "sublimelinterGutterMark": "#484f58",
            "constantOtherReferenceLink": "#a5d6ff"
          }
        },
        "codemirror": {
          "text": "#c9d1d9",
          "bg": "#0d1117",
          "guttersBg": "#0d1117",
          "guttermarkerText": "#0d1117",
          "guttermarkerSubtleText": "#6e7681",
          "linenumberText": "#8b949e",
          "cursor": "#c9d1d9",
          "selectionBg": "rgba(56,139,253,0.4)",
          "activelineBg": "rgba(110,118,129,0.1)",
          "matchingbracketText": "#c9d1d9",
          "linesBg": "#0d1117",
          "syntax": {
            "comment": "#8b949e",
            "constant": "#79c0ff",
            "entity": "#d2a8ff",
            "keyword": "#ec8e2c",
            "storage": "#ec8e2c",
            "string": "#a5d6ff",
            "support": "#79c0ff",
            "variable": "#fdac54"
          }
        },
        "checks": {
          "bg": "#010409",
          "textPrimary": "#c9d1d9",
          "textSecondary": "#8b949e",
          "textLink": "#58a6ff",
          "btnIcon": "#8b949e",
          "btnHoverIcon": "#c9d1d9",
          "btnHoverBg": "rgba(110,118,129,0.1)",
          "inputText": "#8b949e",
          "inputPlaceholderText": "#6e7681",
          "inputFocusText": "#c9d1d9",
          "inputBg": "#161b22",
          "donutError": "#d47616",
          "donutPending": "#d29922",
          "donutSuccess": "#388bfd",
          "donutNeutral": "#8b949e",
          "dropdownText": "#c9d1d9",
          "dropdownBg": "#161b22",
          "dropdownBorder": "#30363d",
          "dropdownShadow": "rgba(1,4,9,0.3)",
          "dropdownHoverText": "#c9d1d9",
          "dropdownHoverBg": "rgba(110,118,129,0.1)",
          "dropdownBtnHoverText": "#c9d1d9",
          "dropdownBtnHoverBg": "rgba(110,118,129,0.1)",
          "scrollbarThumbBg": "rgba(110,118,129,0.4)",
          "headerLabelText": "#8b949e",
          "headerLabelOpenText": "#c9d1d9",
          "headerBorder": "#21262d",
          "headerIcon": "#8b949e",
          "lineText": "#8b949e",
          "lineNumText": "#6e7681",
          "lineTimestampText": "#6e7681",
          "lineHoverBg": "rgba(110,118,129,0.1)",
          "lineSelectedBg": "rgba(56,139,253,0.15)",
          "lineSelectedNumText": "#58a6ff",
          "lineDtFmText": "#ffffff",
          "lineDtFmBg": "#9e6a03",
          "gateBg": "rgba(187,128,9,0.15)",
          "gateText": "#8b949e",
          "gateWaitingText": "#d29922",
          "stepHeaderOpenBg": "#161b22",
          "stepErrorText": "#d47616",
          "stepWarningText": "#d29922",
          "loglineText": "#8b949e",
          "loglineNumText": "#6e7681",
          "loglineDebugText": "#a371f7",
          "loglineErrorText": "#8b949e",
          "loglineErrorNumText": "#6e7681",
          "loglineErrorBg": "rgba(212,118,22,0.15)",
          "loglineWarningText": "#8b949e",
          "loglineWarningNumText": "#d29922",
          "loglineWarningBg": "rgba(187,128,9,0.15)",
          "loglineCommandText": "#58a6ff",
          "loglineSectionText": "#58a6ff",
          "ansi": {
            "black": "#0d1117",
            "blackBright": "#161b22",
            "white": "#b1bac4",
            "whiteBright": "#b1bac4",
            "gray": "#6e7681",
            "red": "#ec8e2c",
            "redBright": "#fdac54",
            "green": "#58a6ff",
            "greenBright": "#79c0ff",
            "yellow": "#d29922",
            "yellowBright": "#e3b341",
            "blue": "#58a6ff",
            "blueBright": "#79c0ff",
            "magenta": "#bc8cff",
            "magentaBright": "#d2a8ff",
            "cyan": "#76e3ea",
            "cyanBright": "#b3f0ff"
          }
        },
        "project": {
          "headerBg": "#0d1117",
          "sidebarBg": "#161b22",
          "gradientIn": "#161b22",
          "gradientOut": "rgba(22,27,34,0)"
        },
        "mktg": {
          "btn": {
            "bg": "#f6f8fa"
          }
        },
        "avatar": {
          "bg": "rgba(255,255,255,0.1)",
          "border": "rgba(240,246,252,0.1)",
          "stackFade": "#30363d",
          "stackFadeMore": "#21262d"
        },
        "topicTag": {
          "border": "rgba(0,0,0,0)"
        },
        "counter": {
          "border": "rgba(0,0,0,0)"
        },
        "selectMenu": {
          "backdropBorder": "#484f58",
          "tapHighlight": "rgba(48,54,61,0.5)",
          "tapFocusBg": "#0c2d6b"
        },
        "header": {
          "text": "rgba(255,255,255,0.7)",
          "bg": "#161b22",
          "divider": "#8b949e",
          "logo": "#f0f6fc"
        },
        "headerSearch": {
          "bg": "#0d1117",
          "border": "#30363d"
        },
        "sidenav": {
          "selectedBg": "#21262d"
        },
        "menu": {
          "bgActive": "#161b22"
        },
        "input": {
          "disabledBg": "rgba(110,118,129,0)"
        },
        "timeline": {
          "badgeBg": "#21262d"
        },
        "ansi": {
          "black": "#484f58",
          "blackBright": "#6e7681",
          "white": "#b1bac4",
          "whiteBright": "#ffffff",
          "gray": "#6e7681",
          "red": "#ec8e2c",
          "redBright": "#fdac54",
          "green": "#58a6ff",
          "greenBright": "#79c0ff",
          "yellow": "#d29922",
          "yellowBright": "#e3b341",
          "blue": "#58a6ff",
          "blueBright": "#79c0ff",
          "magenta": "#bc8cff",
          "magentaBright": "#d2a8ff",
          "cyan": "#39c5cf",
          "cyanBright": "#56d4dd"
        },
        "btn": {
          "text": "#c9d1d9",
          "bg": "#21262d",
          "border": "rgba(240,246,252,0.1)",
          "hoverBg": "#30363d",
          "hoverBorder": "#8b949e",
          "activeBg": "hsla(212,12%,18%,1)",
          "activeBorder": "#6e7681",
          "selectedBg": "#161b22",
          "focusBg": "#21262d",
          "focusBorder": "#8b949e",
          "counterBg": "#30363d",
          "primary": {
            "text": "#ffffff",
            "bg": "#1f6feb",
            "border": "rgba(240,246,252,0.1)",
            "hoverBg": "#388bfd",
            "hoverBorder": "rgba(240,246,252,0.1)",
            "selectedBg": "#1f6feb",
            "disabledText": "rgba(255,255,255,0.5)",
            "disabledBg": "rgba(31,111,235,0.6)",
            "disabledBorder": "rgba(240,246,252,0.1)",
            "focusBg": "#1f6feb",
            "focusBorder": "rgba(240,246,252,0.1)",
            "icon": "#ffffff",
            "counterBg": "rgba(255,255,255,0.2)"
          },
          "outline": {
            "text": "#58a6ff",
            "hoverText": "#58a6ff",
            "hoverBg": "#30363d",
            "hoverBorder": "rgba(240,246,252,0.1)",
            "hoverCounterBg": "rgba(255,255,255,0.2)",
            "selectedText": "#ffffff",
            "selectedBg": "#0d419d",
            "selectedBorder": "rgba(240,246,252,0.1)",
            "disabledText": "rgba(88,166,255,0.5)",
            "disabledBg": "#0d1117",
            "disabledCounterBg": "rgba(31,111,235,0.05)",
            "focusBorder": "rgba(240,246,252,0.1)",
            "counterBg": "rgba(31,111,235,0.1)"
          },
          "danger": {
            "text": "#d47616",
            "hoverText": "#ffffff",
            "hoverBg": "#b76100",
            "hoverBorder": "#d47616",
            "hoverIcon": "#ffffff",
            "hoverCounterBg": "rgba(255,255,255,0.2)",
            "selectedText": "#ffffff",
            "selectedBg": "#914d04",
            "selectedBorder": "#ec8e2c",
            "disabledText": "rgba(212,118,22,0.5)",
            "disabledBg": "#0d1117",
            "disabledCounterBg": "rgba(183,97,0,0.05)",
            "focusBorder": "#d47616",
            "counterBg": "rgba(183,97,0,0.1)",
            "icon": "#d47616"
          }
        },
        "underlinenav": {
          "icon": "#6e7681",
          "borderHover": "rgba(110,118,129,0.4)"
        },
        "actionListItem": {
          "inlineDivider": "rgba(48,54,61,0.48)",
          "default": {
            "hoverBg": "rgba(177,186,196,0.12)",
            "hoverBorder": "rgba(0,0,0,0)",
            "activeBg": "rgba(177,186,196,0.2)",
            "activeBorder": "rgba(0,0,0,0)",
            "selectedBg": "rgba(177,186,196,0.08)"
          },
          "danger": {
            "hoverBg": "rgba(212,118,22,0.16)",
            "activeBg": "rgba(212,118,22,0.24)",
            "hoverText": "#ec8e2c"
          }
        },
        "switchTrack": {
          "bg": "#010409",
          "border": "#6e7681",
          "checked": {
            "bg": "rgba(31,111,235,0.35)",
            "hoverBg": "rgba(31,111,235,0.5)",
            "activeBg": "rgba(31,111,235,0.65)",
            "border": "#58a6ff"
          }
        },
        "switchKnob": {
          "checked": {
            "bg": "#1f6feb",
            "disabledBg": "#484f58"
          }
        },
        "segmentedControl": {
          "bg": "#161b22",
          "button": {
            "hover": {
              "bg": "#30363d"
            },
            "active": {
              "bg": "#21262d"
            },
            "selected": {
              "border": "#6e7681"
            }
          }
        },
        "treeViewItem": {
          "chevron": {
            "hoverBg": "rgba(177,186,196,0.12)"
          },
          "directory": {
            "fill": "#8b949e"
          }
        },
        "fg": {
          "default": "#c9d1d9",
          "muted": "#8b949e",
          "subtle": "#6e7681",
          "onEmphasis": "#ffffff"
        },
        "canvas": {
          "default": "#0d1117",
          "overlay": "#161b22",
          "inset": "#010409",
          "subtle": "#161b22"
        },
        "border": {
          "default": "#30363d",
          "muted": "#21262d",
          "subtle": "rgba(240,246,252,0.1)"
        },
        "neutral": {
          "emphasisPlus": "#6e7681",
          "emphasis": "#6e7681",
          "muted": "rgba(110,118,129,0.4)",
          "subtle": "rgba(110,118,129,0.1)"
        },
        "accent": {
          "fg": "#58a6ff",
          "emphasis": "#1f6feb",
          "muted": "rgba(56,139,253,0.4)",
          "subtle": "rgba(56,139,253,0.15)"
        },
        "success": {
          "fg": "#58a6ff",
          "emphasis": "#1f6feb",
          "muted": "rgba(56,139,253,0.4)",
          "subtle": "rgba(56,139,253,0.15)"
        },
        "attention": {
          "fg": "#d29922",
          "emphasis": "#9e6a03",
          "muted": "rgba(187,128,9,0.4)",
          "subtle": "rgba(187,128,9,0.15)"
        },
        "severe": {
          "fg": "#d47616",
          "emphasis": "#b76100",
          "muted": "rgba(212,118,22,0.4)",
          "subtle": "rgba(212,118,22,0.15)"
        },
        "danger": {
          "fg": "#d47616",
          "emphasis": "#b76100",
          "muted": "rgba(212,118,22,0.4)",
          "subtle": "rgba(212,118,22,0.15)"
        },
        "open": {
          "fg": "#ec8e2c",
          "emphasis": "#b76100",
          "muted": "rgba(212,118,22,0.4)",
          "subtle": "rgba(212,118,22,0.15)"
        },
        "closed": {
          "fg": "#8b949e",
          "emphasis": "#6e7681",
          "muted": "rgba(110,118,129,0.4)",
          "subtle": "rgba(110,118,129,0.1)"
        },
        "done": {
          "fg": "#a371f7",
          "emphasis": "#8957e5",
          "muted": "rgba(163,113,247,0.4)",
          "subtle": "rgba(163,113,247,0.15)"
        },
        "sponsors": {
          "fg": "#db61a2",
          "emphasis": "#bf4b8a",
          "muted": "rgba(219,97,162,0.4)",
          "subtle": "rgba(219,97,162,0.15)"
        },
        "primer": {
          "fg": {
            "disabled": "#484f58"
          },
          "canvas": {
            "backdrop": "rgba(1,4,9,0.8)",
            "sticky": "rgba(13,17,23,0.95)"
          },
          "border": {
            "active": "#f78166",
            "contrast": "rgba(255,255,255,0.2)"
          }
        }
      },
      "shadows": {
        "checks": {
          "inputShadow": "0 0 0 1px (obj) => (0, get_1.default)(obj, path)"
        },
        "mktg": {
          "btn": {
            "shadow": {
              "outline": "rgb(255 255 255 / 25%) 0 0 0 1px inset",
              "focus": "rgb(255 255 255 / 25%) 0 0 0 4px",
              "hover": "0 4px 7px rgba(0, 0, 0, 0.15), 0 100px 80px rgba(255, 255, 255, 0.02), 0 42px 33px rgba(255, 255, 255, 0.024), 0 22px 18px rgba(255, 255, 255, 0.028), 0 12px 10px rgba(255, 255, 255, 0.034), 0 7px 5px rgba(255, 255, 255, 0.04), 0 3px 2px rgba(255, 255, 255, 0.07)",
              "hoverMuted": "rgb(255 255 255) 0 0 0 2px inset"
            }
          }
        },
        "avatar": {
          "childShadow": "-2px -2px 0 #0d1117"
        },
        "overlay": {
          "shadow": "0 0 0 1px #30363d, 0 16px 32px rgba(1,4,9,0.85)"
        },
        "btn": {
          "shadow": "0 0 transparent",
          "insetShadow": "0 0 transparent",
          "focusShadow": "0 0 0 3px rgba(139,148,158,0.3)",
          "shadowActive": "inset 0 0.15em 0.3em rgba(1,4,9,0.15)",
          "shadowInputFocus": "0 0 0 0.2em rgba(31,111,235,0.3)",
          "primary": {
            "shadow": "0 0 transparent",
            "insetShadow": "0 0 transparent",
            "selectedShadow": "0 0 transparent",
            "focusShadow": "0 0 0 3px rgba(46,164,79,0.4)"
          },
          "outline": {
            "hoverShadow": "0 1px 0 rgba(1,4,9,0.1)",
            "hoverInsetShadow": "inset 0 1px 0 rgba(255,255,255,0.03)",
            "selectedShadow": "0 0 transparent",
            "focusShadow": "0 0 0 3px rgba(17,88,199,0.4)"
          },
          "danger": {
            "hoverShadow": "0 0 transparent",
            "hoverInsetShadow": "0 0 transparent",
            "selectedShadow": "0 0 transparent",
            "focusShadow": "0 0 0 3px rgba(212,118,22,0.4)"
          }
        },
        "shadow": {
          "small": "0 0 transparent",
          "medium": "0 3px 6px #010409",
          "large": "0 8px 24px #010409",
          "extraLarge": "0 12px 48px #010409"
        },
        "primer": {
          "shadow": {
            "highlight": "0 0 transparent",
            "inset": "0 0 transparent",
            "focus": "0 0 0 3px #0c2d6b"
          }
        }
      }
    },
    "dark_tritanopia": {
      "colors": {
        "canvasDefaultTransparent": "rgba(13,17,23,0)",
        "pageHeaderBg": "#0d1117",
        "marketingIcon": {
          "primary": "#79c0ff",
          "secondary": "#1f6feb"
        },
        "diffBlob": {
          "addition": {
            "numText": "#c9d1d9",
            "fg": "#c9d1d9",
            "numBg": "rgba(88,166,255,0.3)",
            "lineBg": "rgba(56,139,253,0.15)",
            "wordBg": "rgba(56,139,253,0.4)"
          },
          "deletion": {
            "numText": "#c9d1d9",
            "fg": "#c9d1d9",
            "numBg": "rgba(248,81,73,0.3)",
            "lineBg": "rgba(248,81,73,0.15)",
            "wordBg": "rgba(248,81,73,0.4)"
          },
          "hunk": {
            "numBg": "rgba(56,139,253,0.4)"
          },
          "expander": {
            "icon": "#8b949e"
          }
        },
        "diffstat": {
          "deletionBorder": "rgba(240,246,252,0.1)",
          "additionBorder": "rgba(240,246,252,0.1)",
          "additionBg": "#58a6ff"
        },
        "searchKeyword": {
          "hl": "rgba(210,153,34,0.4)"
        },
        "prettylights": {
          "syntax": {
            "comment": "#8b949e",
            "constant": "#79c0ff",
            "entity": "#d2a8ff",
            "storageModifierImport": "#c9d1d9",
            "entityTag": "#a5d6ff",
            "keyword": "#ff7b72",
            "string": "#a5d6ff",
            "variable": "#ffa198",
            "brackethighlighterUnmatched": "#f85149",
            "invalidIllegalText": "#f0f6fc",
            "invalidIllegalBg": "#8e1519",
            "carriageReturnText": "#f0f6fc",
            "carriageReturnBg": "#b62324",
            "stringRegexp": "#a5d6ff",
            "markupList": "#f2cc60",
            "markupHeading": "#1f6feb",
            "markupItalic": "#c9d1d9",
            "markupBold": "#c9d1d9",
            "markupDeletedText": "#ffdcd7",
            "markupDeletedBg": "#67060c",
            "markupInsertedText": "#cae8ff",
            "markupInsertedBg": "#0c2d6b",
            "markupChangedText": "#ffdcd7",
            "markupChangedBg": "#67060c",
            "markupIgnoredText": "#c9d1d9",
            "markupIgnoredBg": "#1158c7",
            "metaDiffRange": "#d2a8ff",
            "brackethighlighterAngle": "#8b949e",
            "sublimelinterGutterMark": "#484f58",
            "constantOtherReferenceLink": "#a5d6ff"
          }
        },
        "codemirror": {
          "text": "#c9d1d9",
          "bg": "#0d1117",
          "guttersBg": "#0d1117",
          "guttermarkerText": "#0d1117",
          "guttermarkerSubtleText": "#6e7681",
          "linenumberText": "#8b949e",
          "cursor": "#c9d1d9",
          "selectionBg": "rgba(56,139,253,0.4)",
          "activelineBg": "rgba(110,118,129,0.1)",
          "matchingbracketText": "#c9d1d9",
          "linesBg": "#0d1117",
          "syntax": {
            "comment": "#8b949e",
            "constant": "#79c0ff",
            "entity": "#d2a8ff",
            "keyword": "#ff7b72",
            "storage": "#ff7b72",
            "string": "#a5d6ff",
            "support": "#79c0ff",
            "variable": "#ffa198"
          }
        },
        "checks": {
          "bg": "#010409",
          "textPrimary": "#c9d1d9",
          "textSecondary": "#8b949e",
          "textLink": "#58a6ff",
          "btnIcon": "#8b949e",
          "btnHoverIcon": "#c9d1d9",
          "btnHoverBg": "rgba(110,118,129,0.1)",
          "inputText": "#8b949e",
          "inputPlaceholderText": "#6e7681",
          "inputFocusText": "#c9d1d9",
          "inputBg": "#161b22",
          "donutError": "#f85149",
          "donutPending": "#d29922",
          "donutSuccess": "#388bfd",
          "donutNeutral": "#8b949e",
          "dropdownText": "#c9d1d9",
          "dropdownBg": "#161b22",
          "dropdownBorder": "#30363d",
          "dropdownShadow": "rgba(1,4,9,0.3)",
          "dropdownHoverText": "#c9d1d9",
          "dropdownHoverBg": "rgba(110,118,129,0.1)",
          "dropdownBtnHoverText": "#c9d1d9",
          "dropdownBtnHoverBg": "rgba(110,118,129,0.1)",
          "scrollbarThumbBg": "rgba(110,118,129,0.4)",
          "headerLabelText": "#8b949e",
          "headerLabelOpenText": "#c9d1d9",
          "headerBorder": "#21262d",
          "headerIcon": "#8b949e",
          "lineText": "#8b949e",
          "lineNumText": "#6e7681",
          "lineTimestampText": "#6e7681",
          "lineHoverBg": "rgba(110,118,129,0.1)",
          "lineSelectedBg": "rgba(56,139,253,0.15)",
          "lineSelectedNumText": "#58a6ff",
          "lineDtFmText": "#ffffff",
          "lineDtFmBg": "#9e6a03",
          "gateBg": "rgba(187,128,9,0.15)",
          "gateText": "#8b949e",
          "gateWaitingText": "#d29922",
          "stepHeaderOpenBg": "#161b22",
          "stepErrorText": "#f85149",
          "stepWarningText": "#d29922",
          "loglineText": "#8b949e",
          "loglineNumText": "#6e7681",
          "loglineDebugText": "#a371f7",
          "loglineErrorText": "#8b949e",
          "loglineErrorNumText": "#6e7681",
          "loglineErrorBg": "rgba(248,81,73,0.15)",
          "loglineWarningText": "#8b949e",
          "loglineWarningNumText": "#d29922",
          "loglineWarningBg": "rgba(187,128,9,0.15)",
          "loglineCommandText": "#58a6ff",
          "loglineSectionText": "#58a6ff",
          "ansi": {
            "black": "#0d1117",
            "blackBright": "#161b22",
            "white": "#b1bac4",
            "whiteBright": "#b1bac4",
            "gray": "#6e7681",
            "red": "#ff7b72",
            "redBright": "#ffa198",
            "green": "#58a6ff",
            "greenBright": "#79c0ff",
            "yellow": "#d29922",
            "yellowBright": "#e3b341",
            "blue": "#58a6ff",
            "blueBright": "#79c0ff",
            "magenta": "#bc8cff",
            "magentaBright": "#d2a8ff",
            "cyan": "#76e3ea",
            "cyanBright": "#b3f0ff"
          }
        },
        "project": {
          "headerBg": "#0d1117",
          "sidebarBg": "#161b22",
          "gradientIn": "#161b22",
          "gradientOut": "rgba(22,27,34,0)"
        },
        "mktg": {
          "btn": {
            "bg": "#f6f8fa"
          }
        },
        "avatar": {
          "bg": "rgba(255,255,255,0.1)",
          "border": "rgba(240,246,252,0.1)",
          "stackFade": "#30363d",
          "stackFadeMore": "#21262d"
        },
        "topicTag": {
          "border": "rgba(0,0,0,0)"
        },
        "counter": {
          "border": "rgba(0,0,0,0)"
        },
        "selectMenu": {
          "backdropBorder": "#484f58",
          "tapHighlight": "rgba(48,54,61,0.5)",
          "tapFocusBg": "#0c2d6b"
        },
        "header": {
          "text": "rgba(255,255,255,0.7)",
          "bg": "#161b22",
          "divider": "#8b949e",
          "logo": "#f0f6fc"
        },
        "headerSearch": {
          "bg": "#0d1117",
          "border": "#30363d"
        },
        "sidenav": {
          "selectedBg": "#21262d"
        },
        "menu": {
          "bgActive": "#161b22"
        },
        "input": {
          "disabledBg": "rgba(110,118,129,0)"
        },
        "timeline": {
          "badgeBg": "#21262d"
        },
        "ansi": {
          "black": "#484f58",
          "blackBright": "#6e7681",
          "white": "#b1bac4",
          "whiteBright": "#ffffff",
          "gray": "#6e7681",
          "red": "#ff7b72",
          "redBright": "#ffa198",
          "green": "#58a6ff",
          "greenBright": "#79c0ff",
          "yellow": "#d29922",
          "yellowBright": "#e3b341",
          "blue": "#58a6ff",
          "blueBright": "#79c0ff",
          "magenta": "#bc8cff",
          "magentaBright": "#d2a8ff",
          "cyan": "#39c5cf",
          "cyanBright": "#56d4dd"
        },
        "btn": {
          "text": "#c9d1d9",
          "bg": "#21262d",
          "border": "rgba(240,246,252,0.1)",
          "hoverBg": "#30363d",
          "hoverBorder": "#8b949e",
          "activeBg": "hsla(212,12%,18%,1)",
          "activeBorder": "#6e7681",
          "selectedBg": "#161b22",
          "focusBg": "#21262d",
          "focusBorder": "#8b949e",
          "counterBg": "#30363d",
          "primary": {
            "text": "#ffffff",
            "bg": "#1f6feb",
            "border": "rgba(240,246,252,0.1)",
            "hoverBg": "#388bfd",
            "hoverBorder": "rgba(240,246,252,0.1)",
            "selectedBg": "#1f6feb",
            "disabledText": "rgba(255,255,255,0.5)",
            "disabledBg": "rgba(31,111,235,0.6)",
            "disabledBorder": "rgba(240,246,252,0.1)",
            "focusBg": "#1f6feb",
            "focusBorder": "rgba(240,246,252,0.1)",
            "icon": "#ffffff",
            "counterBg": "rgba(255,255,255,0.2)"
          },
          "outline": {
            "text": "#58a6ff",
            "hoverText": "#58a6ff",
            "hoverBg": "#30363d",
            "hoverBorder": "rgba(240,246,252,0.1)",
            "hoverCounterBg": "rgba(255,255,255,0.2)",
            "selectedText": "#ffffff",
            "selectedBg": "#0d419d",
            "selectedBorder": "rgba(240,246,252,0.1)",
            "disabledText": "rgba(88,166,255,0.5)",
            "disabledBg": "#0d1117",
            "disabledCounterBg": "rgba(31,111,235,0.05)",
            "focusBorder": "rgba(240,246,252,0.1)",
            "counterBg": "rgba(31,111,235,0.1)"
          },
          "danger": {
            "text": "#f85149",
            "hoverText": "#ffffff",
            "hoverBg": "#da3633",
            "hoverBorder": "#f85149",
            "hoverIcon": "#ffffff",
            "hoverCounterBg": "rgba(255,255,255,0.2)",
            "selectedText": "#ffffff",
            "selectedBg": "#b62324",
            "selectedBorder": "#ff7b72",
            "disabledText": "rgba(248,81,73,0.5)",
            "disabledBg": "#0d1117",
            "disabledCounterBg": "rgba(218,54,51,0.05)",
            "focusBorder": "#f85149",
            "counterBg": "rgba(218,54,51,0.1)",
            "icon": "#f85149"
          }
        },
        "underlinenav": {
          "icon": "#6e7681",
          "borderHover": "rgba(110,118,129,0.4)"
        },
        "actionListItem": {
          "inlineDivider": "rgba(48,54,61,0.48)",
          "default": {
            "hoverBg": "rgba(177,186,196,0.12)",
            "hoverBorder": "rgba(0,0,0,0)",
            "activeBg": "rgba(177,186,196,0.2)",
            "activeBorder": "rgba(0,0,0,0)",
            "selectedBg": "rgba(177,186,196,0.08)"
          },
          "danger": {
            "hoverBg": "rgba(248,81,73,0.16)",
            "activeBg": "rgba(248,81,73,0.24)",
            "hoverText": "#ff7b72"
          }
        },
        "switchTrack": {
          "bg": "#010409",
          "border": "#6e7681",
          "checked": {
            "bg": "rgba(31,111,235,0.35)",
            "hoverBg": "rgba(31,111,235,0.5)",
            "activeBg": "rgba(31,111,235,0.65)",
            "border": "#58a6ff"
          }
        },
        "switchKnob": {
          "checked": {
            "bg": "#1f6feb",
            "disabledBg": "#484f58"
          }
        },
        "segmentedControl": {
          "bg": "#161b22",
          "button": {
            "hover": {
              "bg": "#30363d"
            },
            "active": {
              "bg": "#21262d"
            },
            "selected": {
              "border": "#6e7681"
            }
          }
        },
        "treeViewItem": {
          "chevron": {
            "hoverBg": "rgba(177,186,196,0.12)"
          },
          "directory": {
            "fill": "#8b949e"
          }
        },
        "fg": {
          "default": "#c9d1d9",
          "muted": "#8b949e",
          "subtle": "#6e7681",
          "onEmphasis": "#ffffff"
        },
        "canvas": {
          "default": "#0d1117",
          "overlay": "#161b22",
          "inset": "#010409",
          "subtle": "#161b22"
        },
        "border": {
          "default": "#30363d",
          "muted": "#21262d",
          "subtle": "rgba(240,246,252,0.1)"
        },
        "neutral": {
          "emphasisPlus": "#6e7681",
          "emphasis": "#6e7681",
          "muted": "rgba(110,118,129,0.4)",
          "subtle": "rgba(110,118,129,0.1)"
        },
        "accent": {
          "fg": "#58a6ff",
          "emphasis": "#1f6feb",
          "muted": "rgba(56,139,253,0.4)",
          "subtle": "rgba(56,139,253,0.15)"
        },
        "success": {
          "fg": "#58a6ff",
          "emphasis": "#1f6feb",
          "muted": "rgba(56,139,253,0.4)",
          "subtle": "rgba(56,139,253,0.15)"
        },
        "attention": {
          "fg": "#d29922",
          "emphasis": "#9e6a03",
          "muted": "rgba(187,128,9,0.4)",
          "subtle": "rgba(187,128,9,0.15)"
        },
        "severe": {
          "fg": "#f85149",
          "emphasis": "#da3633",
          "muted": "rgba(248,81,73,0.4)",
          "subtle": "rgba(248,81,73,0.15)"
        },
        "danger": {
          "fg": "#f85149",
          "emphasis": "#da3633",
          "muted": "rgba(248,81,73,0.4)",
          "subtle": "rgba(248,81,73,0.15)"
        },
        "open": {
          "fg": "#ff7b72",
          "emphasis": "#da3633",
          "muted": "rgba(248,81,73,0.4)",
          "subtle": "rgba(248,81,73,0.15)"
        },
        "closed": {
          "fg": "#8b949e",
          "emphasis": "#6e7681",
          "muted": "rgba(110,118,129,0.4)",
          "subtle": "rgba(110,118,129,0.1)"
        },
        "done": {
          "fg": "#a371f7",
          "emphasis": "#8957e5",
          "muted": "rgba(163,113,247,0.4)",
          "subtle": "rgba(163,113,247,0.15)"
        },
        "sponsors": {
          "fg": "#db61a2",
          "emphasis": "#bf4b8a",
          "muted": "rgba(219,97,162,0.4)",
          "subtle": "rgba(219,97,162,0.15)"
        },
        "primer": {
          "fg": {
            "disabled": "#484f58"
          },
          "canvas": {
            "backdrop": "rgba(1,4,9,0.8)",
            "sticky": "rgba(13,17,23,0.95)"
          },
          "border": {
            "active": "#f78166",
            "contrast": "rgba(255,255,255,0.2)"
          }
        }
      },
      "shadows": {
        "checks": {
          "inputShadow": "0 0 0 1px (obj) => (0, get_1.default)(obj, path)"
        },
        "mktg": {
          "btn": {
            "shadow": {
              "outline": "rgb(255 255 255 / 25%) 0 0 0 1px inset",
              "focus": "rgb(255 255 255 / 25%) 0 0 0 4px",
              "hover": "0 4px 7px rgba(0, 0, 0, 0.15), 0 100px 80px rgba(255, 255, 255, 0.02), 0 42px 33px rgba(255, 255, 255, 0.024), 0 22px 18px rgba(255, 255, 255, 0.028), 0 12px 10px rgba(255, 255, 255, 0.034), 0 7px 5px rgba(255, 255, 255, 0.04), 0 3px 2px rgba(255, 255, 255, 0.07)",
              "hoverMuted": "rgb(255 255 255) 0 0 0 2px inset"
            }
          }
        },
        "avatar": {
          "childShadow": "-2px -2px 0 #0d1117"
        },
        "overlay": {
          "shadow": "0 0 0 1px #30363d, 0 16px 32px rgba(1,4,9,0.85)"
        },
        "btn": {
          "shadow": "0 0 transparent",
          "insetShadow": "0 0 transparent",
          "focusShadow": "0 0 0 3px rgba(139,148,158,0.3)",
          "shadowActive": "inset 0 0.15em 0.3em rgba(1,4,9,0.15)",
          "shadowInputFocus": "0 0 0 0.2em rgba(31,111,235,0.3)",
          "primary": {
            "shadow": "0 0 transparent",
            "insetShadow": "0 0 transparent",
            "selectedShadow": "0 0 transparent",
            "focusShadow": "0 0 0 3px rgba(46,164,79,0.4)"
          },
          "outline": {
            "hoverShadow": "0 1px 0 rgba(1,4,9,0.1)",
            "hoverInsetShadow": "inset 0 1px 0 rgba(255,255,255,0.03)",
            "selectedShadow": "0 0 transparent",
            "focusShadow": "0 0 0 3px rgba(17,88,199,0.4)"
          },
          "danger": {
            "hoverShadow": "0 0 transparent",
            "hoverInsetShadow": "0 0 transparent",
            "selectedShadow": "0 0 transparent",
            "focusShadow": "0 0 0 3px rgba(248,81,73,0.4)"
          }
        },
        "shadow": {
          "small": "0 0 transparent",
          "medium": "0 3px 6px #010409",
          "large": "0 8px 24px #010409",
          "extraLarge": "0 12px 48px #010409"
        },
        "primer": {
          "shadow": {
            "highlight": "0 0 transparent",
            "inset": "0 0 transparent",
            "focus": "0 0 0 3px #0c2d6b"
          }
        }
      }
    }
  }
};

var theme = themePreval;




/***/ }),

/***/ "../../../node_modules/@primer/react/lib-esm/utils/create-slots.js":
/*!*************************************************************************!*\
  !*** ../../../node_modules/@primer/react/lib-esm/utils/create-slots.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ createSlots)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _use_force_update_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./use-force-update.js */ "../../../node_modules/@primer/react/lib-esm/utils/use-force-update.js");
/* harmony import */ var _useIsomorphicLayoutEffect_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./useIsomorphicLayoutEffect.js */ "../../../node_modules/@primer/react/lib-esm/utils/useIsomorphicLayoutEffect.js");




/** createSlots is a factory that can create a
 *  typesafe Slots + Slot pair to use in a component definition
 *  For example: ActionList.Item uses createSlots to get a Slots wrapper
 *  + Slot component that is used by LeadingVisual, Description
 */
const createSlots = slotNames => {
  const SlotsContext = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createContext({
    registerSlot: () => null,
    unregisterSlot: () => null,
    context: {}
  });

  // maintain a static reference to avoid infinite render loop
  const defaultContext = Object.freeze({});

  /** Slots uses a Double render strategy inspired by [reach-ui/descendants](https://github.com/reach/reach-ui/tree/develop/packages/descendants)
   *  Slot registers themself with the Slots parent.
   *  When all the children have mounted = registered themselves in slot,
   *  we re-render the parent component to render with slots
   */
  const Slots = ({
    context = defaultContext,
    children
  }) => {
    // initialise slots
    const slotsDefinition = {};
    slotNames.map(name => slotsDefinition[name] = null);
    const slotsRef = react__WEBPACK_IMPORTED_MODULE_0___default().useRef(slotsDefinition);
    const rerenderWithSlots = (0,_use_force_update_js__WEBPACK_IMPORTED_MODULE_1__.useForceUpdate)();
    const [isMounted, setIsMounted] = react__WEBPACK_IMPORTED_MODULE_0___default().useState(false);

    // fires after all the effects in children
    (0,_useIsomorphicLayoutEffect_js__WEBPACK_IMPORTED_MODULE_2__["default"])(() => {
      rerenderWithSlots();
      setIsMounted(true);
    }, [rerenderWithSlots]);
    const registerSlot = react__WEBPACK_IMPORTED_MODULE_0___default().useCallback((name, contents) => {
      slotsRef.current[name] = contents;

      // don't render until the component mounts = all slots are registered
      if (isMounted) rerenderWithSlots();
    }, [isMounted, rerenderWithSlots]);

    // Slot can be removed from the tree as well,
    // we need to unregister them from the slot
    const unregisterSlot = react__WEBPACK_IMPORTED_MODULE_0___default().useCallback(name => {
      slotsRef.current[name] = null;
      rerenderWithSlots();
    }, [rerenderWithSlots]);

    /**
     * Slots uses a render prop API so abstract the
     * implementation detail of using a context provider.
     */
    const slots = slotsRef.current;
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(SlotsContext.Provider, {
      value: {
        registerSlot,
        unregisterSlot,
        context
      }
    }, children(slots));
  };
  function Slot(props) {
    const {
      name,
      children
    } = props;
    const {
      registerSlot,
      unregisterSlot,
      context
    } = react__WEBPACK_IMPORTED_MODULE_0___default().useContext(SlotsContext);
    (0,_useIsomorphicLayoutEffect_js__WEBPACK_IMPORTED_MODULE_2__["default"])(() => {
      registerSlot(name, typeof children === 'function' ? children(context) : children);
      return () => unregisterSlot(name);
    }, [name, children, registerSlot, unregisterSlot, context]);
    return null;
  }
  return {
    Slots,
    Slot
  };
};




/***/ }),

/***/ "../../../node_modules/@primer/react/lib-esm/utils/defaultSxProp.js":
/*!**************************************************************************!*\
  !*** ../../../node_modules/@primer/react/lib-esm/utils/defaultSxProp.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "defaultSxProp": () => (/* binding */ defaultSxProp)
/* harmony export */ });
const defaultSxProp =  true ? Object.freeze({}) : 0;




/***/ }),

/***/ "../../../node_modules/@primer/react/lib-esm/utils/scroll.js":
/*!*******************************************************************!*\
  !*** ../../../node_modules/@primer/react/lib-esm/utils/scroll.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "getScrollContainer": () => (/* binding */ getScrollContainer)
/* harmony export */ });
/**
 * Returns the nearest scrollable parent of the element or `null` if the element
 * is not contained in a scrollable element.
 */
function getScrollContainer(element) {
  if (!element || element === document.body) {
    return null;
  }
  return isScrollable(element) ? element : getScrollContainer(element.parentElement);
}

/** Returns `true` if the element is scrollable */
function isScrollable(element) {
  const hasScrollableContent = element.scrollHeight > element.clientHeight;
  return hasScrollableContent && !(window.getComputedStyle(element).overflowY.indexOf('hidden') !== -1);
}




/***/ }),

/***/ "../../../node_modules/@primer/react/lib-esm/utils/use-force-update.js":
/*!*****************************************************************************!*\
  !*** ../../../node_modules/@primer/react/lib-esm/utils/use-force-update.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "useForceUpdate": () => (/* binding */ useForceUpdate)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);


// Inspired from reach-ui: https://github.com/reach/reach-ui/blob/develop/packages/utils/src/use-force-update.ts
const useForceUpdate = () => {
  const [, rerender] = react__WEBPACK_IMPORTED_MODULE_0___default().useState({});
  return react__WEBPACK_IMPORTED_MODULE_0___default().useCallback(() => rerender({}), []);
};




/***/ }),

/***/ "../../../node_modules/@primer/react/lib-esm/utils/useIsomorphicLayoutEffect.js":
/*!**************************************************************************************!*\
  !*** ../../../node_modules/@primer/react/lib-esm/utils/useIsomorphicLayoutEffect.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ useIsomorphicLayoutEffect)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);


const useIsomorphicLayoutEffect = typeof window !== 'undefined' && typeof window.document !== 'undefined' && typeof window.document.createElement !== 'undefined' ? react__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect : react__WEBPACK_IMPORTED_MODULE_0__.useEffect;




/***/ }),

/***/ "../../../node_modules/@react-aria/ssr/dist/module.js":
/*!************************************************************!*\
  !*** ../../../node_modules/@react-aria/ssr/dist/module.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "SSRProvider": () => (/* binding */ $704cf1d3b684cc5c$export$9f8ac96af4b1b2ae),
/* harmony export */   "useIsSSR": () => (/* binding */ $704cf1d3b684cc5c$export$535bd6ca7f90a273),
/* harmony export */   "useSSRSafeId": () => (/* binding */ $704cf1d3b684cc5c$export$619500959fc48b26)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);


/*
 * Copyright 2020 Adobe. All rights reserved.
 * This file is licensed to you under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under
 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR REPRESENTATIONS
 * OF ANY KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */ /*
 * Copyright 2020 Adobe. All rights reserved.
 * This file is licensed to you under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under
 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR REPRESENTATIONS
 * OF ANY KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */ // We must avoid a circular dependency with @react-aria/utils, and this useLayoutEffect is
// guarded by a check that it only runs on the client side.
// eslint-disable-next-line rulesdir/useLayoutEffectRule

// Default context value to use in case there is no SSRProvider. This is fine for
// client-only apps. In order to support multiple copies of React Aria potentially
// being on the page at once, the prefix is set to a random number. SSRProvider
// will reset this to zero for consistency between server and client, so in the
// SSR case multiple copies of React Aria is not supported.
const $704cf1d3b684cc5c$var$defaultContext = {
    prefix: String(Math.round(Math.random() * 10000000000)),
    current: 0
};
const $704cf1d3b684cc5c$var$SSRContext = /*#__PURE__*/ (0, (react__WEBPACK_IMPORTED_MODULE_0___default())).createContext($704cf1d3b684cc5c$var$defaultContext);
function $704cf1d3b684cc5c$export$9f8ac96af4b1b2ae(props) {
    let cur = (0, react__WEBPACK_IMPORTED_MODULE_0__.useContext)($704cf1d3b684cc5c$var$SSRContext);
    let value = (0, react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(()=>({
            // If this is the first SSRProvider, start with an empty string prefix, otherwise
            // append and increment the counter.
            prefix: cur === $704cf1d3b684cc5c$var$defaultContext ? "" : `${cur.prefix}-${++cur.current}`,
            current: 0
        }), [
        cur
    ]);
    return /*#__PURE__*/ (0, (react__WEBPACK_IMPORTED_MODULE_0___default())).createElement($704cf1d3b684cc5c$var$SSRContext.Provider, {
        value: value
    }, props.children);
}
let $704cf1d3b684cc5c$var$canUseDOM = Boolean(typeof window !== "undefined" && window.document && window.document.createElement);
function $704cf1d3b684cc5c$export$619500959fc48b26(defaultId) {
    let ctx = (0, react__WEBPACK_IMPORTED_MODULE_0__.useContext)($704cf1d3b684cc5c$var$SSRContext);
    // If we are rendering in a non-DOM environment, and there's no SSRProvider,
    // provide a warning to hint to the developer to add one.
    if (ctx === $704cf1d3b684cc5c$var$defaultContext && !$704cf1d3b684cc5c$var$canUseDOM) console.warn("When server rendering, you must wrap your application in an <SSRProvider> to ensure consistent ids are generated between the client and server.");
    // eslint-disable-next-line react-hooks/exhaustive-deps
    return (0, react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(()=>defaultId || `react-aria${ctx.prefix}-${++ctx.current}`, [
        defaultId
    ]);
}
function $704cf1d3b684cc5c$export$535bd6ca7f90a273() {
    let cur = (0, react__WEBPACK_IMPORTED_MODULE_0__.useContext)($704cf1d3b684cc5c$var$SSRContext);
    let isInSSRContext = cur !== $704cf1d3b684cc5c$var$defaultContext;
    let [isSSR, setIsSSR] = (0, react__WEBPACK_IMPORTED_MODULE_0__.useState)(isInSSRContext);
    // If on the client, and the component was initially server rendered,
    // then schedule a layout effect to update the component after hydration.
    if (typeof window !== "undefined" && isInSSRContext) // This if statement technically breaks the rules of hooks, but is safe
    // because the condition never changes after mounting.
    // eslint-disable-next-line react-hooks/rules-of-hooks
    (0, react__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect)(()=>{
        setIsSSR(false);
    }, []);
    return isSSR;
}







/***/ }),

/***/ "../../../node_modules/@styled-system/background/dist/index.esm.js":
/*!*************************************************************************!*\
  !*** ../../../node_modules/@styled-system/background/dist/index.esm.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "background": () => (/* binding */ background),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _styled_system_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @styled-system/core */ "../../../node_modules/@styled-system/core/dist/index.esm.js");

var config = {
  background: true,
  backgroundImage: true,
  backgroundSize: true,
  backgroundPosition: true,
  backgroundRepeat: true
};
config.bgImage = config.backgroundImage;
config.bgSize = config.backgroundSize;
config.bgPosition = config.backgroundPosition;
config.bgRepeat = config.backgroundRepeat;
var background = (0,_styled_system_core__WEBPACK_IMPORTED_MODULE_0__.system)(config);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (background);


/***/ }),

/***/ "../../../node_modules/@styled-system/border/dist/index.esm.js":
/*!*********************************************************************!*\
  !*** ../../../node_modules/@styled-system/border/dist/index.esm.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "border": () => (/* binding */ border),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _styled_system_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @styled-system/core */ "../../../node_modules/@styled-system/core/dist/index.esm.js");

var config = {
  border: {
    property: 'border',
    scale: 'borders'
  },
  borderWidth: {
    property: 'borderWidth',
    scale: 'borderWidths'
  },
  borderStyle: {
    property: 'borderStyle',
    scale: 'borderStyles'
  },
  borderColor: {
    property: 'borderColor',
    scale: 'colors'
  },
  borderRadius: {
    property: 'borderRadius',
    scale: 'radii'
  },
  borderTop: {
    property: 'borderTop',
    scale: 'borders'
  },
  borderTopLeftRadius: {
    property: 'borderTopLeftRadius',
    scale: 'radii'
  },
  borderTopRightRadius: {
    property: 'borderTopRightRadius',
    scale: 'radii'
  },
  borderRight: {
    property: 'borderRight',
    scale: 'borders'
  },
  borderBottom: {
    property: 'borderBottom',
    scale: 'borders'
  },
  borderBottomLeftRadius: {
    property: 'borderBottomLeftRadius',
    scale: 'radii'
  },
  borderBottomRightRadius: {
    property: 'borderBottomRightRadius',
    scale: 'radii'
  },
  borderLeft: {
    property: 'borderLeft',
    scale: 'borders'
  },
  borderX: {
    properties: ['borderLeft', 'borderRight'],
    scale: 'borders'
  },
  borderY: {
    properties: ['borderTop', 'borderBottom'],
    scale: 'borders'
  }
};
config.borderTopWidth = {
  property: 'borderTopWidth',
  scale: 'borderWidths'
};
config.borderTopColor = {
  property: 'borderTopColor',
  scale: 'colors'
};
config.borderTopStyle = {
  property: 'borderTopStyle',
  scale: 'borderStyles'
};
config.borderTopLeftRadius = {
  property: 'borderTopLeftRadius',
  scale: 'radii'
};
config.borderTopRightRadius = {
  property: 'borderTopRightRadius',
  scale: 'radii'
};
config.borderBottomWidth = {
  property: 'borderBottomWidth',
  scale: 'borderWidths'
};
config.borderBottomColor = {
  property: 'borderBottomColor',
  scale: 'colors'
};
config.borderBottomStyle = {
  property: 'borderBottomStyle',
  scale: 'borderStyles'
};
config.borderBottomLeftRadius = {
  property: 'borderBottomLeftRadius',
  scale: 'radii'
};
config.borderBottomRightRadius = {
  property: 'borderBottomRightRadius',
  scale: 'radii'
};
config.borderLeftWidth = {
  property: 'borderLeftWidth',
  scale: 'borderWidths'
};
config.borderLeftColor = {
  property: 'borderLeftColor',
  scale: 'colors'
};
config.borderLeftStyle = {
  property: 'borderLeftStyle',
  scale: 'borderStyles'
};
config.borderRightWidth = {
  property: 'borderRightWidth',
  scale: 'borderWidths'
};
config.borderRightColor = {
  property: 'borderRightColor',
  scale: 'colors'
};
config.borderRightStyle = {
  property: 'borderRightStyle',
  scale: 'borderStyles'
};
var border = (0,_styled_system_core__WEBPACK_IMPORTED_MODULE_0__.system)(config);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (border);


/***/ }),

/***/ "../../../node_modules/@styled-system/color/dist/index.esm.js":
/*!********************************************************************!*\
  !*** ../../../node_modules/@styled-system/color/dist/index.esm.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "color": () => (/* binding */ color),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _styled_system_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @styled-system/core */ "../../../node_modules/@styled-system/core/dist/index.esm.js");

var config = {
  color: {
    property: 'color',
    scale: 'colors'
  },
  backgroundColor: {
    property: 'backgroundColor',
    scale: 'colors'
  },
  opacity: true
};
config.bg = config.backgroundColor;
var color = (0,_styled_system_core__WEBPACK_IMPORTED_MODULE_0__.system)(config);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (color);


/***/ }),

/***/ "../../../node_modules/@styled-system/core/dist/index.esm.js":
/*!*******************************************************************!*\
  !*** ../../../node_modules/@styled-system/core/dist/index.esm.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "compose": () => (/* binding */ compose),
/* harmony export */   "createParser": () => (/* binding */ createParser),
/* harmony export */   "createStyleFunction": () => (/* binding */ createStyleFunction),
/* harmony export */   "get": () => (/* binding */ get),
/* harmony export */   "merge": () => (/* binding */ merge),
/* harmony export */   "system": () => (/* binding */ system)
/* harmony export */ });
/* harmony import */ var object_assign__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! object-assign */ "../../../node_modules/object-assign/index.js");
/* harmony import */ var object_assign__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(object_assign__WEBPACK_IMPORTED_MODULE_0__);

var merge = function merge(a, b) {
  var result = object_assign__WEBPACK_IMPORTED_MODULE_0___default()({}, a, b);

  for (var key in a) {
    var _assign;

    if (!a[key] || typeof b[key] !== 'object') continue;
    object_assign__WEBPACK_IMPORTED_MODULE_0___default()(result, (_assign = {}, _assign[key] = object_assign__WEBPACK_IMPORTED_MODULE_0___default()(a[key], b[key]), _assign));
  }

  return result;
}; // sort object-value responsive styles

var sort = function sort(obj) {
  var next = {};
  Object.keys(obj).sort(function (a, b) {
    return a.localeCompare(b, undefined, {
      numeric: true,
      sensitivity: 'base'
    });
  }).forEach(function (key) {
    next[key] = obj[key];
  });
  return next;
};

var defaults = {
  breakpoints: [40, 52, 64].map(function (n) {
    return n + 'em';
  })
};

var createMediaQuery = function createMediaQuery(n) {
  return "@media screen and (min-width: " + n + ")";
};

var getValue = function getValue(n, scale) {
  return get(scale, n, n);
};

var get = function get(obj, key, def, p, undef) {
  key = key && key.split ? key.split('.') : [key];

  for (p = 0; p < key.length; p++) {
    obj = obj ? obj[key[p]] : undef;
  }

  return obj === undef ? def : obj;
};
var createParser = function createParser(config) {
  var cache = {};

  var parse = function parse(props) {
    var styles = {};
    var shouldSort = false;
    var isCacheDisabled = props.theme && props.theme.disableStyledSystemCache;

    for (var key in props) {
      if (!config[key]) continue;
      var sx = config[key];
      var raw = props[key];
      var scale = get(props.theme, sx.scale, sx.defaults);

      if (typeof raw === 'object') {
        cache.breakpoints = !isCacheDisabled && cache.breakpoints || get(props.theme, 'breakpoints', defaults.breakpoints);

        if (Array.isArray(raw)) {
          cache.media = !isCacheDisabled && cache.media || [null].concat(cache.breakpoints.map(createMediaQuery));
          styles = merge(styles, parseResponsiveStyle(cache.media, sx, scale, raw, props));
          continue;
        }

        if (raw !== null) {
          styles = merge(styles, parseResponsiveObject(cache.breakpoints, sx, scale, raw, props));
          shouldSort = true;
        }

        continue;
      }

      object_assign__WEBPACK_IMPORTED_MODULE_0___default()(styles, sx(raw, scale, props));
    } // sort object-based responsive styles


    if (shouldSort) {
      styles = sort(styles);
    }

    return styles;
  };

  parse.config = config;
  parse.propNames = Object.keys(config);
  parse.cache = cache;
  var keys = Object.keys(config).filter(function (k) {
    return k !== 'config';
  });

  if (keys.length > 1) {
    keys.forEach(function (key) {
      var _createParser;

      parse[key] = createParser((_createParser = {}, _createParser[key] = config[key], _createParser));
    });
  }

  return parse;
};

var parseResponsiveStyle = function parseResponsiveStyle(mediaQueries, sx, scale, raw, _props) {
  var styles = {};
  raw.slice(0, mediaQueries.length).forEach(function (value, i) {
    var media = mediaQueries[i];
    var style = sx(value, scale, _props);

    if (!media) {
      object_assign__WEBPACK_IMPORTED_MODULE_0___default()(styles, style);
    } else {
      var _assign2;

      object_assign__WEBPACK_IMPORTED_MODULE_0___default()(styles, (_assign2 = {}, _assign2[media] = object_assign__WEBPACK_IMPORTED_MODULE_0___default()({}, styles[media], style), _assign2));
    }
  });
  return styles;
};

var parseResponsiveObject = function parseResponsiveObject(breakpoints, sx, scale, raw, _props) {
  var styles = {};

  for (var key in raw) {
    var breakpoint = breakpoints[key];
    var value = raw[key];
    var style = sx(value, scale, _props);

    if (!breakpoint) {
      object_assign__WEBPACK_IMPORTED_MODULE_0___default()(styles, style);
    } else {
      var _assign3;

      var media = createMediaQuery(breakpoint);
      object_assign__WEBPACK_IMPORTED_MODULE_0___default()(styles, (_assign3 = {}, _assign3[media] = object_assign__WEBPACK_IMPORTED_MODULE_0___default()({}, styles[media], style), _assign3));
    }
  }

  return styles;
};

var createStyleFunction = function createStyleFunction(_ref) {
  var properties = _ref.properties,
      property = _ref.property,
      scale = _ref.scale,
      _ref$transform = _ref.transform,
      transform = _ref$transform === void 0 ? getValue : _ref$transform,
      defaultScale = _ref.defaultScale;
  properties = properties || [property];

  var sx = function sx(value, scale, _props) {
    var result = {};
    var n = transform(value, scale, _props);
    if (n === null) return;
    properties.forEach(function (prop) {
      result[prop] = n;
    });
    return result;
  };

  sx.scale = scale;
  sx.defaults = defaultScale;
  return sx;
}; // new v5 API

var system = function system(args) {
  if (args === void 0) {
    args = {};
  }

  var config = {};
  Object.keys(args).forEach(function (key) {
    var conf = args[key];

    if (conf === true) {
      // shortcut definition
      config[key] = createStyleFunction({
        property: key,
        scale: key
      });
      return;
    }

    if (typeof conf === 'function') {
      config[key] = conf;
      return;
    }

    config[key] = createStyleFunction(conf);
  });
  var parser = createParser(config);
  return parser;
};
var compose = function compose() {
  var config = {};

  for (var _len = arguments.length, parsers = new Array(_len), _key = 0; _key < _len; _key++) {
    parsers[_key] = arguments[_key];
  }

  parsers.forEach(function (parser) {
    if (!parser || !parser.config) return;
    object_assign__WEBPACK_IMPORTED_MODULE_0___default()(config, parser.config);
  });
  var parser = createParser(config);
  return parser;
};


/***/ }),

/***/ "../../../node_modules/@styled-system/css/dist/index.esm.js":
/*!******************************************************************!*\
  !*** ../../../node_modules/@styled-system/css/dist/index.esm.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "css": () => (/* binding */ css),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "get": () => (/* binding */ get),
/* harmony export */   "responsive": () => (/* binding */ responsive)
/* harmony export */ });
function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

// based on https://github.com/developit/dlv
var get = function get(obj, key, def, p, undef) {
  key = key && key.split ? key.split('.') : [key];

  for (p = 0; p < key.length; p++) {
    obj = obj ? obj[key[p]] : undef;
  }

  return obj === undef ? def : obj;
};
var defaultBreakpoints = [40, 52, 64].map(function (n) {
  return n + 'em';
});
var defaultTheme = {
  space: [0, 4, 8, 16, 32, 64, 128, 256, 512],
  fontSizes: [12, 14, 16, 20, 24, 32, 48, 64, 72]
};
var aliases = {
  bg: 'backgroundColor',
  m: 'margin',
  mt: 'marginTop',
  mr: 'marginRight',
  mb: 'marginBottom',
  ml: 'marginLeft',
  mx: 'marginX',
  my: 'marginY',
  p: 'padding',
  pt: 'paddingTop',
  pr: 'paddingRight',
  pb: 'paddingBottom',
  pl: 'paddingLeft',
  px: 'paddingX',
  py: 'paddingY'
};
var multiples = {
  marginX: ['marginLeft', 'marginRight'],
  marginY: ['marginTop', 'marginBottom'],
  paddingX: ['paddingLeft', 'paddingRight'],
  paddingY: ['paddingTop', 'paddingBottom'],
  size: ['width', 'height']
};
var scales = {
  color: 'colors',
  backgroundColor: 'colors',
  borderColor: 'colors',
  margin: 'space',
  marginTop: 'space',
  marginRight: 'space',
  marginBottom: 'space',
  marginLeft: 'space',
  marginX: 'space',
  marginY: 'space',
  padding: 'space',
  paddingTop: 'space',
  paddingRight: 'space',
  paddingBottom: 'space',
  paddingLeft: 'space',
  paddingX: 'space',
  paddingY: 'space',
  top: 'space',
  right: 'space',
  bottom: 'space',
  left: 'space',
  gridGap: 'space',
  gridColumnGap: 'space',
  gridRowGap: 'space',
  gap: 'space',
  columnGap: 'space',
  rowGap: 'space',
  fontFamily: 'fonts',
  fontSize: 'fontSizes',
  fontWeight: 'fontWeights',
  lineHeight: 'lineHeights',
  letterSpacing: 'letterSpacings',
  border: 'borders',
  borderTop: 'borders',
  borderRight: 'borders',
  borderBottom: 'borders',
  borderLeft: 'borders',
  borderWidth: 'borderWidths',
  borderStyle: 'borderStyles',
  borderRadius: 'radii',
  borderTopRightRadius: 'radii',
  borderTopLeftRadius: 'radii',
  borderBottomRightRadius: 'radii',
  borderBottomLeftRadius: 'radii',
  borderTopWidth: 'borderWidths',
  borderTopColor: 'colors',
  borderTopStyle: 'borderStyles',
  borderBottomWidth: 'borderWidths',
  borderBottomColor: 'colors',
  borderBottomStyle: 'borderStyles',
  borderLeftWidth: 'borderWidths',
  borderLeftColor: 'colors',
  borderLeftStyle: 'borderStyles',
  borderRightWidth: 'borderWidths',
  borderRightColor: 'colors',
  borderRightStyle: 'borderStyles',
  outlineColor: 'colors',
  boxShadow: 'shadows',
  textShadow: 'shadows',
  zIndex: 'zIndices',
  width: 'sizes',
  minWidth: 'sizes',
  maxWidth: 'sizes',
  height: 'sizes',
  minHeight: 'sizes',
  maxHeight: 'sizes',
  flexBasis: 'sizes',
  size: 'sizes',
  // svg
  fill: 'colors',
  stroke: 'colors'
};

var positiveOrNegative = function positiveOrNegative(scale, value) {
  if (typeof value !== 'number' || value >= 0) {
    return get(scale, value, value);
  }

  var absolute = Math.abs(value);
  var n = get(scale, absolute, absolute);
  if (typeof n === 'string') return '-' + n;
  return n * -1;
};

var transforms = ['margin', 'marginTop', 'marginRight', 'marginBottom', 'marginLeft', 'marginX', 'marginY', 'top', 'bottom', 'left', 'right'].reduce(function (acc, curr) {
  var _extends2;

  return _extends({}, acc, (_extends2 = {}, _extends2[curr] = positiveOrNegative, _extends2));
}, {});
var responsive = function responsive(styles) {
  return function (theme) {
    var next = {};
    var breakpoints = get(theme, 'breakpoints', defaultBreakpoints);
    var mediaQueries = [null].concat(breakpoints.map(function (n) {
      return "@media screen and (min-width: " + n + ")";
    }));

    for (var key in styles) {
      var value = typeof styles[key] === 'function' ? styles[key](theme) : styles[key];
      if (value == null) continue;

      if (!Array.isArray(value)) {
        next[key] = value;
        continue;
      }

      for (var i = 0; i < value.slice(0, mediaQueries.length).length; i++) {
        var media = mediaQueries[i];

        if (!media) {
          next[key] = value[i];
          continue;
        }

        next[media] = next[media] || {};
        if (value[i] == null) continue;
        next[media][key] = value[i];
      }
    }

    return next;
  };
};
var css = function css(args) {
  return function (props) {
    if (props === void 0) {
      props = {};
    }

    var theme = _extends({}, defaultTheme, {}, props.theme || props);

    var result = {};
    var obj = typeof args === 'function' ? args(theme) : args;
    var styles = responsive(obj)(theme);

    for (var key in styles) {
      var x = styles[key];
      var val = typeof x === 'function' ? x(theme) : x;

      if (key === 'variant') {
        var variant = css(get(theme, val))(theme);
        result = _extends({}, result, {}, variant);
        continue;
      }

      if (val && typeof val === 'object') {
        result[key] = css(val)(theme);
        continue;
      }

      var prop = get(aliases, key, key);
      var scaleName = get(scales, prop);
      var scale = get(theme, scaleName, get(theme, prop, {}));
      var transform = get(transforms, prop, get);
      var value = transform(scale, val, val);

      if (multiples[prop]) {
        var dirs = multiples[prop];

        for (var i = 0; i < dirs.length; i++) {
          result[dirs[i]] = value;
        }
      } else {
        result[prop] = value;
      }
    }

    return result;
  };
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (css);


/***/ }),

/***/ "../../../node_modules/@styled-system/flexbox/dist/index.esm.js":
/*!**********************************************************************!*\
  !*** ../../../node_modules/@styled-system/flexbox/dist/index.esm.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "flexbox": () => (/* binding */ flexbox)
/* harmony export */ });
/* harmony import */ var _styled_system_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @styled-system/core */ "../../../node_modules/@styled-system/core/dist/index.esm.js");

var config = {
  alignItems: true,
  alignContent: true,
  justifyItems: true,
  justifyContent: true,
  flexWrap: true,
  flexDirection: true,
  // item
  flex: true,
  flexGrow: true,
  flexShrink: true,
  flexBasis: true,
  justifySelf: true,
  alignSelf: true,
  order: true
};
var flexbox = (0,_styled_system_core__WEBPACK_IMPORTED_MODULE_0__.system)(config);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (flexbox);


/***/ }),

/***/ "../../../node_modules/@styled-system/grid/dist/index.esm.js":
/*!*******************************************************************!*\
  !*** ../../../node_modules/@styled-system/grid/dist/index.esm.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "grid": () => (/* binding */ grid)
/* harmony export */ });
/* harmony import */ var _styled_system_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @styled-system/core */ "../../../node_modules/@styled-system/core/dist/index.esm.js");

var defaults = {
  space: [0, 4, 8, 16, 32, 64, 128, 256, 512]
};
var config = {
  gridGap: {
    property: 'gridGap',
    scale: 'space',
    defaultScale: defaults.space
  },
  gridColumnGap: {
    property: 'gridColumnGap',
    scale: 'space',
    defaultScale: defaults.space
  },
  gridRowGap: {
    property: 'gridRowGap',
    scale: 'space',
    defaultScale: defaults.space
  },
  gridColumn: true,
  gridRow: true,
  gridAutoFlow: true,
  gridAutoColumns: true,
  gridAutoRows: true,
  gridTemplateColumns: true,
  gridTemplateRows: true,
  gridTemplateAreas: true,
  gridArea: true
};
var grid = (0,_styled_system_core__WEBPACK_IMPORTED_MODULE_0__.system)(config);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (grid);


/***/ }),

/***/ "../../../node_modules/@styled-system/layout/dist/index.esm.js":
/*!*********************************************************************!*\
  !*** ../../../node_modules/@styled-system/layout/dist/index.esm.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "layout": () => (/* binding */ layout)
/* harmony export */ });
/* harmony import */ var _styled_system_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @styled-system/core */ "../../../node_modules/@styled-system/core/dist/index.esm.js");


var isNumber = function isNumber(n) {
  return typeof n === 'number' && !isNaN(n);
};

var getWidth = function getWidth(n, scale) {
  return (0,_styled_system_core__WEBPACK_IMPORTED_MODULE_0__.get)(scale, n, !isNumber(n) || n > 1 ? n : n * 100 + '%');
};

var config = {
  width: {
    property: 'width',
    scale: 'sizes',
    transform: getWidth
  },
  height: {
    property: 'height',
    scale: 'sizes'
  },
  minWidth: {
    property: 'minWidth',
    scale: 'sizes'
  },
  minHeight: {
    property: 'minHeight',
    scale: 'sizes'
  },
  maxWidth: {
    property: 'maxWidth',
    scale: 'sizes'
  },
  maxHeight: {
    property: 'maxHeight',
    scale: 'sizes'
  },
  size: {
    properties: ['width', 'height'],
    scale: 'sizes'
  },
  overflow: true,
  overflowX: true,
  overflowY: true,
  display: true,
  verticalAlign: true
};
var layout = (0,_styled_system_core__WEBPACK_IMPORTED_MODULE_0__.system)(config);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (layout);


/***/ }),

/***/ "../../../node_modules/@styled-system/position/dist/index.esm.js":
/*!***********************************************************************!*\
  !*** ../../../node_modules/@styled-system/position/dist/index.esm.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "position": () => (/* binding */ position)
/* harmony export */ });
/* harmony import */ var _styled_system_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @styled-system/core */ "../../../node_modules/@styled-system/core/dist/index.esm.js");

var defaults = {
  space: [0, 4, 8, 16, 32, 64, 128, 256, 512]
};
var config = {
  position: true,
  zIndex: {
    property: 'zIndex',
    scale: 'zIndices'
  },
  top: {
    property: 'top',
    scale: 'space',
    defaultScale: defaults.space
  },
  right: {
    property: 'right',
    scale: 'space',
    defaultScale: defaults.space
  },
  bottom: {
    property: 'bottom',
    scale: 'space',
    defaultScale: defaults.space
  },
  left: {
    property: 'left',
    scale: 'space',
    defaultScale: defaults.space
  }
};
var position = (0,_styled_system_core__WEBPACK_IMPORTED_MODULE_0__.system)(config);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (position);


/***/ }),

/***/ "../../../node_modules/@styled-system/shadow/dist/index.esm.js":
/*!*********************************************************************!*\
  !*** ../../../node_modules/@styled-system/shadow/dist/index.esm.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "shadow": () => (/* binding */ shadow)
/* harmony export */ });
/* harmony import */ var _styled_system_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @styled-system/core */ "../../../node_modules/@styled-system/core/dist/index.esm.js");

var shadow = (0,_styled_system_core__WEBPACK_IMPORTED_MODULE_0__.system)({
  boxShadow: {
    property: 'boxShadow',
    scale: 'shadows'
  },
  textShadow: {
    property: 'textShadow',
    scale: 'shadows'
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (shadow);


/***/ }),

/***/ "../../../node_modules/@styled-system/space/dist/index.esm.js":
/*!********************************************************************!*\
  !*** ../../../node_modules/@styled-system/space/dist/index.esm.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "margin": () => (/* binding */ margin),
/* harmony export */   "padding": () => (/* binding */ padding),
/* harmony export */   "space": () => (/* binding */ space)
/* harmony export */ });
/* harmony import */ var _styled_system_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @styled-system/core */ "../../../node_modules/@styled-system/core/dist/index.esm.js");

var defaults = {
  space: [0, 4, 8, 16, 32, 64, 128, 256, 512]
};

var isNumber = function isNumber(n) {
  return typeof n === 'number' && !isNaN(n);
};

var getMargin = function getMargin(n, scale) {
  if (!isNumber(n)) {
    return (0,_styled_system_core__WEBPACK_IMPORTED_MODULE_0__.get)(scale, n, n);
  }

  var isNegative = n < 0;
  var absolute = Math.abs(n);
  var value = (0,_styled_system_core__WEBPACK_IMPORTED_MODULE_0__.get)(scale, absolute, absolute);

  if (!isNumber(value)) {
    return isNegative ? '-' + value : value;
  }

  return value * (isNegative ? -1 : 1);
};

var configs = {};
configs.margin = {
  margin: {
    property: 'margin',
    scale: 'space',
    transform: getMargin,
    defaultScale: defaults.space
  },
  marginTop: {
    property: 'marginTop',
    scale: 'space',
    transform: getMargin,
    defaultScale: defaults.space
  },
  marginRight: {
    property: 'marginRight',
    scale: 'space',
    transform: getMargin,
    defaultScale: defaults.space
  },
  marginBottom: {
    property: 'marginBottom',
    scale: 'space',
    transform: getMargin,
    defaultScale: defaults.space
  },
  marginLeft: {
    property: 'marginLeft',
    scale: 'space',
    transform: getMargin,
    defaultScale: defaults.space
  },
  marginX: {
    properties: ['marginLeft', 'marginRight'],
    scale: 'space',
    transform: getMargin,
    defaultScale: defaults.space
  },
  marginY: {
    properties: ['marginTop', 'marginBottom'],
    scale: 'space',
    transform: getMargin,
    defaultScale: defaults.space
  }
};
configs.margin.m = configs.margin.margin;
configs.margin.mt = configs.margin.marginTop;
configs.margin.mr = configs.margin.marginRight;
configs.margin.mb = configs.margin.marginBottom;
configs.margin.ml = configs.margin.marginLeft;
configs.margin.mx = configs.margin.marginX;
configs.margin.my = configs.margin.marginY;
configs.padding = {
  padding: {
    property: 'padding',
    scale: 'space',
    defaultScale: defaults.space
  },
  paddingTop: {
    property: 'paddingTop',
    scale: 'space',
    defaultScale: defaults.space
  },
  paddingRight: {
    property: 'paddingRight',
    scale: 'space',
    defaultScale: defaults.space
  },
  paddingBottom: {
    property: 'paddingBottom',
    scale: 'space',
    defaultScale: defaults.space
  },
  paddingLeft: {
    property: 'paddingLeft',
    scale: 'space',
    defaultScale: defaults.space
  },
  paddingX: {
    properties: ['paddingLeft', 'paddingRight'],
    scale: 'space',
    defaultScale: defaults.space
  },
  paddingY: {
    properties: ['paddingTop', 'paddingBottom'],
    scale: 'space',
    defaultScale: defaults.space
  }
};
configs.padding.p = configs.padding.padding;
configs.padding.pt = configs.padding.paddingTop;
configs.padding.pr = configs.padding.paddingRight;
configs.padding.pb = configs.padding.paddingBottom;
configs.padding.pl = configs.padding.paddingLeft;
configs.padding.px = configs.padding.paddingX;
configs.padding.py = configs.padding.paddingY;
var margin = (0,_styled_system_core__WEBPACK_IMPORTED_MODULE_0__.system)(configs.margin);
var padding = (0,_styled_system_core__WEBPACK_IMPORTED_MODULE_0__.system)(configs.padding);
var space = (0,_styled_system_core__WEBPACK_IMPORTED_MODULE_0__.compose)(margin, padding);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (space);


/***/ }),

/***/ "../../../node_modules/@styled-system/theme-get/dist/index.esm.js":
/*!************************************************************************!*\
  !*** ../../../node_modules/@styled-system/theme-get/dist/index.esm.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "themeGet": () => (/* binding */ themeGet)
/* harmony export */ });
/* harmony import */ var _styled_system_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @styled-system/core */ "../../../node_modules/@styled-system/core/dist/index.esm.js");

var themeGet = function themeGet(path, fallback) {
  if (fallback === void 0) {
    fallback = null;
  }

  return function (props) {
    return (0,_styled_system_core__WEBPACK_IMPORTED_MODULE_0__.get)(props.theme, path, fallback);
  };
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (themeGet);


/***/ }),

/***/ "../../../node_modules/@styled-system/typography/dist/index.esm.js":
/*!*************************************************************************!*\
  !*** ../../../node_modules/@styled-system/typography/dist/index.esm.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "typography": () => (/* binding */ typography)
/* harmony export */ });
/* harmony import */ var _styled_system_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @styled-system/core */ "../../../node_modules/@styled-system/core/dist/index.esm.js");

var defaults = {
  fontSizes: [12, 14, 16, 20, 24, 32, 48, 64, 72]
};
var config = {
  fontFamily: {
    property: 'fontFamily',
    scale: 'fonts'
  },
  fontSize: {
    property: 'fontSize',
    scale: 'fontSizes',
    defaultScale: defaults.fontSizes
  },
  fontWeight: {
    property: 'fontWeight',
    scale: 'fontWeights'
  },
  lineHeight: {
    property: 'lineHeight',
    scale: 'lineHeights'
  },
  letterSpacing: {
    property: 'letterSpacing',
    scale: 'letterSpacings'
  },
  textAlign: true,
  fontStyle: true
};
var typography = (0,_styled_system_core__WEBPACK_IMPORTED_MODULE_0__.system)(config);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (typography);


/***/ }),

/***/ "../../../node_modules/@styled-system/variant/dist/index.esm.js":
/*!**********************************************************************!*\
  !*** ../../../node_modules/@styled-system/variant/dist/index.esm.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "buttonStyle": () => (/* binding */ buttonStyle),
/* harmony export */   "colorStyle": () => (/* binding */ colorStyle),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "textStyle": () => (/* binding */ textStyle),
/* harmony export */   "variant": () => (/* binding */ variant)
/* harmony export */ });
/* harmony import */ var _styled_system_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @styled-system/core */ "../../../node_modules/@styled-system/core/dist/index.esm.js");
/* harmony import */ var _styled_system_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @styled-system/css */ "../../../node_modules/@styled-system/css/dist/index.esm.js");


var variant = function variant(_ref) {
  var _config;

  var scale = _ref.scale,
      _ref$prop = _ref.prop,
      prop = _ref$prop === void 0 ? 'variant' : _ref$prop,
      _ref$variants = _ref.variants,
      variants = _ref$variants === void 0 ? {} : _ref$variants,
      key = _ref.key;
  var sx;

  if (Object.keys(variants).length) {
    sx = function sx(value, scale, props) {
      return (0,_styled_system_css__WEBPACK_IMPORTED_MODULE_1__["default"])((0,_styled_system_core__WEBPACK_IMPORTED_MODULE_0__.get)(scale, value, null))(props.theme);
    };
  } else {
    sx = function sx(value, scale) {
      return (0,_styled_system_core__WEBPACK_IMPORTED_MODULE_0__.get)(scale, value, null);
    };
  }

  sx.scale = scale || key;
  sx.defaults = variants;
  var config = (_config = {}, _config[prop] = sx, _config);
  var parser = (0,_styled_system_core__WEBPACK_IMPORTED_MODULE_0__.createParser)(config);
  return parser;
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (variant);
var buttonStyle = variant({
  key: 'buttons'
});
var textStyle = variant({
  key: 'textStyles',
  prop: 'textStyle'
});
var colorStyle = variant({
  key: 'colorStyles',
  prop: 'colors'
});


/***/ }),

/***/ "../../../node_modules/classnames/index.js":
/*!*************************************************!*\
  !*** ../../../node_modules/classnames/index.js ***!
  \*************************************************/
/***/ ((module, exports) => {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*!
	Copyright (c) 2018 Jed Watson.
	Licensed under the MIT License (MIT), see
	http://jedwatson.github.io/classnames
*/
/* global define */

(function () {
	'use strict';

	var hasOwn = {}.hasOwnProperty;
	var nativeCodeString = '[native code]';

	function classNames() {
		var classes = [];

		for (var i = 0; i < arguments.length; i++) {
			var arg = arguments[i];
			if (!arg) continue;

			var argType = typeof arg;

			if (argType === 'string' || argType === 'number') {
				classes.push(arg);
			} else if (Array.isArray(arg)) {
				if (arg.length) {
					var inner = classNames.apply(null, arg);
					if (inner) {
						classes.push(inner);
					}
				}
			} else if (argType === 'object') {
				if (arg.toString !== Object.prototype.toString && !arg.toString.toString().includes('[native code]')) {
					classes.push(arg.toString());
					continue;
				}

				for (var key in arg) {
					if (hasOwn.call(arg, key) && arg[key]) {
						classes.push(key);
					}
				}
			}
		}

		return classes.join(' ');
	}

	if ( true && module.exports) {
		classNames.default = classNames;
		module.exports = classNames;
	} else if (true) {
		// register as 'classnames', consistent with npm package name
		!(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_AMD_DEFINE_RESULT__ = (function () {
			return classNames;
		}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
	} else {}
}());


/***/ }),

/***/ "../../../node_modules/deepmerge/dist/cjs.js":
/*!***************************************************!*\
  !*** ../../../node_modules/deepmerge/dist/cjs.js ***!
  \***************************************************/
/***/ ((module) => {

"use strict";


var isMergeableObject = function isMergeableObject(value) {
	return isNonNullObject(value)
		&& !isSpecial(value)
};

function isNonNullObject(value) {
	return !!value && typeof value === 'object'
}

function isSpecial(value) {
	var stringValue = Object.prototype.toString.call(value);

	return stringValue === '[object RegExp]'
		|| stringValue === '[object Date]'
		|| isReactElement(value)
}

// see https://github.com/facebook/react/blob/b5ac963fb791d1298e7f396236383bc955f916c1/src/isomorphic/classic/element/ReactElement.js#L21-L25
var canUseSymbol = typeof Symbol === 'function' && Symbol.for;
var REACT_ELEMENT_TYPE = canUseSymbol ? Symbol.for('react.element') : 0xeac7;

function isReactElement(value) {
	return value.$$typeof === REACT_ELEMENT_TYPE
}

function emptyTarget(val) {
	return Array.isArray(val) ? [] : {}
}

function cloneUnlessOtherwiseSpecified(value, options) {
	return (options.clone !== false && options.isMergeableObject(value))
		? deepmerge(emptyTarget(value), value, options)
		: value
}

function defaultArrayMerge(target, source, options) {
	return target.concat(source).map(function(element) {
		return cloneUnlessOtherwiseSpecified(element, options)
	})
}

function getMergeFunction(key, options) {
	if (!options.customMerge) {
		return deepmerge
	}
	var customMerge = options.customMerge(key);
	return typeof customMerge === 'function' ? customMerge : deepmerge
}

function getEnumerableOwnPropertySymbols(target) {
	return Object.getOwnPropertySymbols
		? Object.getOwnPropertySymbols(target).filter(function(symbol) {
			return Object.propertyIsEnumerable.call(target, symbol)
		})
		: []
}

function getKeys(target) {
	return Object.keys(target).concat(getEnumerableOwnPropertySymbols(target))
}

function propertyIsOnObject(object, property) {
	try {
		return property in object
	} catch(_) {
		return false
	}
}

// Protects from prototype poisoning and unexpected merging up the prototype chain.
function propertyIsUnsafe(target, key) {
	return propertyIsOnObject(target, key) // Properties are safe to merge if they don't exist in the target yet,
		&& !(Object.hasOwnProperty.call(target, key) // unsafe if they exist up the prototype chain,
			&& Object.propertyIsEnumerable.call(target, key)) // and also unsafe if they're nonenumerable.
}

function mergeObject(target, source, options) {
	var destination = {};
	if (options.isMergeableObject(target)) {
		getKeys(target).forEach(function(key) {
			destination[key] = cloneUnlessOtherwiseSpecified(target[key], options);
		});
	}
	getKeys(source).forEach(function(key) {
		if (propertyIsUnsafe(target, key)) {
			return
		}

		if (propertyIsOnObject(target, key) && options.isMergeableObject(source[key])) {
			destination[key] = getMergeFunction(key, options)(target[key], source[key], options);
		} else {
			destination[key] = cloneUnlessOtherwiseSpecified(source[key], options);
		}
	});
	return destination
}

function deepmerge(target, source, options) {
	options = options || {};
	options.arrayMerge = options.arrayMerge || defaultArrayMerge;
	options.isMergeableObject = options.isMergeableObject || isMergeableObject;
	// cloneUnlessOtherwiseSpecified is added to `options` so that custom arrayMerge()
	// implementations can use it. The caller may not replace it.
	options.cloneUnlessOtherwiseSpecified = cloneUnlessOtherwiseSpecified;

	var sourceIsArray = Array.isArray(source);
	var targetIsArray = Array.isArray(target);
	var sourceAndTargetTypesMatch = sourceIsArray === targetIsArray;

	if (!sourceAndTargetTypesMatch) {
		return cloneUnlessOtherwiseSpecified(source, options)
	} else if (sourceIsArray) {
		return options.arrayMerge(target, source, options)
	} else {
		return mergeObject(target, source, options)
	}
}

deepmerge.all = function deepmergeAll(array, options) {
	if (!Array.isArray(array)) {
		throw new Error('first argument should be an array')
	}

	return array.reduce(function(prev, next) {
		return deepmerge(prev, next, options)
	}, {})
};

var deepmerge_1 = deepmerge;

module.exports = deepmerge_1;


/***/ }),

/***/ "../../../node_modules/object-assign/index.js":
/*!****************************************************!*\
  !*** ../../../node_modules/object-assign/index.js ***!
  \****************************************************/
/***/ ((module) => {

"use strict";
/*
object-assign
(c) Sindre Sorhus
@license MIT
*/


/* eslint-disable no-unused-vars */
var getOwnPropertySymbols = Object.getOwnPropertySymbols;
var hasOwnProperty = Object.prototype.hasOwnProperty;
var propIsEnumerable = Object.prototype.propertyIsEnumerable;

function toObject(val) {
	if (val === null || val === undefined) {
		throw new TypeError('Object.assign cannot be called with null or undefined');
	}

	return Object(val);
}

function shouldUseNative() {
	try {
		if (!Object.assign) {
			return false;
		}

		// Detect buggy property enumeration order in older V8 versions.

		// https://bugs.chromium.org/p/v8/issues/detail?id=4118
		var test1 = new String('abc');  // eslint-disable-line no-new-wrappers
		test1[5] = 'de';
		if (Object.getOwnPropertyNames(test1)[0] === '5') {
			return false;
		}

		// https://bugs.chromium.org/p/v8/issues/detail?id=3056
		var test2 = {};
		for (var i = 0; i < 10; i++) {
			test2['_' + String.fromCharCode(i)] = i;
		}
		var order2 = Object.getOwnPropertyNames(test2).map(function (n) {
			return test2[n];
		});
		if (order2.join('') !== '0123456789') {
			return false;
		}

		// https://bugs.chromium.org/p/v8/issues/detail?id=3056
		var test3 = {};
		'abcdefghijklmnopqrst'.split('').forEach(function (letter) {
			test3[letter] = letter;
		});
		if (Object.keys(Object.assign({}, test3)).join('') !==
				'abcdefghijklmnopqrst') {
			return false;
		}

		return true;
	} catch (err) {
		// We don't expect any of the above to throw, but better to be safe.
		return false;
	}
}

module.exports = shouldUseNative() ? Object.assign : function (target, source) {
	var from;
	var to = toObject(target);
	var symbols;

	for (var s = 1; s < arguments.length; s++) {
		from = Object(arguments[s]);

		for (var key in from) {
			if (hasOwnProperty.call(from, key)) {
				to[key] = from[key];
			}
		}

		if (getOwnPropertySymbols) {
			symbols = getOwnPropertySymbols(from);
			for (var i = 0; i < symbols.length; i++) {
				if (propIsEnumerable.call(from, symbols[i])) {
					to[symbols[i]] = from[symbols[i]];
				}
			}
		}
	}

	return to;
};


/***/ }),

/***/ "../../../node_modules/styled-system/dist/index.esm.js":
/*!*************************************************************!*\
  !*** ../../../node_modules/styled-system/dist/index.esm.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "alignContent": () => (/* binding */ alignContent),
/* harmony export */   "alignItems": () => (/* binding */ alignItems),
/* harmony export */   "alignSelf": () => (/* binding */ alignSelf),
/* harmony export */   "background": () => (/* reexport safe */ _styled_system_background__WEBPACK_IMPORTED_MODULE_7__.background),
/* harmony export */   "backgroundImage": () => (/* binding */ backgroundImage),
/* harmony export */   "backgroundPosition": () => (/* binding */ backgroundPosition),
/* harmony export */   "backgroundRepeat": () => (/* binding */ backgroundRepeat),
/* harmony export */   "backgroundSize": () => (/* binding */ backgroundSize),
/* harmony export */   "border": () => (/* reexport safe */ _styled_system_border__WEBPACK_IMPORTED_MODULE_6__.border),
/* harmony export */   "borderBottom": () => (/* binding */ borderBottom),
/* harmony export */   "borderColor": () => (/* binding */ borderColor),
/* harmony export */   "borderLeft": () => (/* binding */ borderLeft),
/* harmony export */   "borderRadius": () => (/* binding */ borderRadius),
/* harmony export */   "borderRight": () => (/* binding */ borderRight),
/* harmony export */   "borderStyle": () => (/* binding */ borderStyle),
/* harmony export */   "borderTop": () => (/* binding */ borderTop),
/* harmony export */   "borderWidth": () => (/* binding */ borderWidth),
/* harmony export */   "borders": () => (/* reexport safe */ _styled_system_border__WEBPACK_IMPORTED_MODULE_6__["default"]),
/* harmony export */   "bottom": () => (/* binding */ bottom),
/* harmony export */   "boxShadow": () => (/* reexport safe */ _styled_system_shadow__WEBPACK_IMPORTED_MODULE_10__["default"]),
/* harmony export */   "buttonStyle": () => (/* reexport safe */ _styled_system_variant__WEBPACK_IMPORTED_MODULE_11__.buttonStyle),
/* harmony export */   "color": () => (/* reexport safe */ _styled_system_color__WEBPACK_IMPORTED_MODULE_2__.color),
/* harmony export */   "colorStyle": () => (/* reexport safe */ _styled_system_variant__WEBPACK_IMPORTED_MODULE_11__.colorStyle),
/* harmony export */   "compose": () => (/* reexport safe */ _styled_system_core__WEBPACK_IMPORTED_MODULE_0__.compose),
/* harmony export */   "createParser": () => (/* reexport safe */ _styled_system_core__WEBPACK_IMPORTED_MODULE_0__.createParser),
/* harmony export */   "createStyleFunction": () => (/* reexport safe */ _styled_system_core__WEBPACK_IMPORTED_MODULE_0__.createStyleFunction),
/* harmony export */   "display": () => (/* binding */ display),
/* harmony export */   "flex": () => (/* binding */ flex),
/* harmony export */   "flexBasis": () => (/* binding */ flexBasis),
/* harmony export */   "flexDirection": () => (/* binding */ flexDirection),
/* harmony export */   "flexGrow": () => (/* binding */ flexGrow),
/* harmony export */   "flexShrink": () => (/* binding */ flexShrink),
/* harmony export */   "flexWrap": () => (/* binding */ flexWrap),
/* harmony export */   "flexbox": () => (/* reexport safe */ _styled_system_flexbox__WEBPACK_IMPORTED_MODULE_4__.flexbox),
/* harmony export */   "fontFamily": () => (/* binding */ fontFamily),
/* harmony export */   "fontSize": () => (/* binding */ fontSize),
/* harmony export */   "fontStyle": () => (/* binding */ fontStyle),
/* harmony export */   "fontWeight": () => (/* binding */ fontWeight),
/* harmony export */   "get": () => (/* reexport safe */ _styled_system_core__WEBPACK_IMPORTED_MODULE_0__.get),
/* harmony export */   "grid": () => (/* reexport safe */ _styled_system_grid__WEBPACK_IMPORTED_MODULE_5__.grid),
/* harmony export */   "gridArea": () => (/* binding */ gridArea),
/* harmony export */   "gridAutoColumns": () => (/* binding */ gridAutoColumns),
/* harmony export */   "gridAutoFlow": () => (/* binding */ gridAutoFlow),
/* harmony export */   "gridAutoRows": () => (/* binding */ gridAutoRows),
/* harmony export */   "gridColumn": () => (/* binding */ gridColumn),
/* harmony export */   "gridColumnGap": () => (/* binding */ gridColumnGap),
/* harmony export */   "gridGap": () => (/* binding */ gridGap),
/* harmony export */   "gridRow": () => (/* binding */ gridRow),
/* harmony export */   "gridRowGap": () => (/* binding */ gridRowGap),
/* harmony export */   "gridTemplateAreas": () => (/* binding */ gridTemplateAreas),
/* harmony export */   "gridTemplateColumns": () => (/* binding */ gridTemplateColumns),
/* harmony export */   "gridTemplateRows": () => (/* binding */ gridTemplateRows),
/* harmony export */   "height": () => (/* binding */ height),
/* harmony export */   "justifyContent": () => (/* binding */ justifyContent),
/* harmony export */   "justifyItems": () => (/* binding */ justifyItems),
/* harmony export */   "justifySelf": () => (/* binding */ justifySelf),
/* harmony export */   "layout": () => (/* reexport safe */ _styled_system_layout__WEBPACK_IMPORTED_MODULE_1__.layout),
/* harmony export */   "left": () => (/* binding */ left),
/* harmony export */   "letterSpacing": () => (/* binding */ letterSpacing),
/* harmony export */   "lineHeight": () => (/* binding */ lineHeight),
/* harmony export */   "margin": () => (/* reexport safe */ _styled_system_space__WEBPACK_IMPORTED_MODULE_9__.margin),
/* harmony export */   "maxHeight": () => (/* binding */ maxHeight),
/* harmony export */   "maxWidth": () => (/* binding */ maxWidth),
/* harmony export */   "minHeight": () => (/* binding */ minHeight),
/* harmony export */   "minWidth": () => (/* binding */ minWidth),
/* harmony export */   "opacity": () => (/* binding */ opacity),
/* harmony export */   "order": () => (/* binding */ order),
/* harmony export */   "overflow": () => (/* binding */ overflow),
/* harmony export */   "overflowX": () => (/* binding */ overflowX),
/* harmony export */   "overflowY": () => (/* binding */ overflowY),
/* harmony export */   "padding": () => (/* reexport safe */ _styled_system_space__WEBPACK_IMPORTED_MODULE_9__.padding),
/* harmony export */   "position": () => (/* reexport safe */ _styled_system_position__WEBPACK_IMPORTED_MODULE_8__.position),
/* harmony export */   "right": () => (/* binding */ right),
/* harmony export */   "shadow": () => (/* reexport safe */ _styled_system_shadow__WEBPACK_IMPORTED_MODULE_10__.shadow),
/* harmony export */   "size": () => (/* binding */ size),
/* harmony export */   "space": () => (/* reexport safe */ _styled_system_space__WEBPACK_IMPORTED_MODULE_9__.space),
/* harmony export */   "style": () => (/* binding */ style),
/* harmony export */   "system": () => (/* reexport safe */ _styled_system_core__WEBPACK_IMPORTED_MODULE_0__.system),
/* harmony export */   "textAlign": () => (/* binding */ textAlign),
/* harmony export */   "textShadow": () => (/* reexport safe */ _styled_system_shadow__WEBPACK_IMPORTED_MODULE_10__["default"]),
/* harmony export */   "textStyle": () => (/* reexport safe */ _styled_system_variant__WEBPACK_IMPORTED_MODULE_11__.textStyle),
/* harmony export */   "top": () => (/* binding */ top),
/* harmony export */   "typography": () => (/* reexport safe */ _styled_system_typography__WEBPACK_IMPORTED_MODULE_3__.typography),
/* harmony export */   "variant": () => (/* reexport safe */ _styled_system_variant__WEBPACK_IMPORTED_MODULE_11__.variant),
/* harmony export */   "verticalAlign": () => (/* binding */ verticalAlign),
/* harmony export */   "width": () => (/* binding */ width),
/* harmony export */   "zIndex": () => (/* binding */ zIndex)
/* harmony export */ });
/* harmony import */ var _styled_system_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @styled-system/core */ "../../../node_modules/@styled-system/core/dist/index.esm.js");
/* harmony import */ var _styled_system_layout__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @styled-system/layout */ "../../../node_modules/@styled-system/layout/dist/index.esm.js");
/* harmony import */ var _styled_system_color__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @styled-system/color */ "../../../node_modules/@styled-system/color/dist/index.esm.js");
/* harmony import */ var _styled_system_typography__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @styled-system/typography */ "../../../node_modules/@styled-system/typography/dist/index.esm.js");
/* harmony import */ var _styled_system_flexbox__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @styled-system/flexbox */ "../../../node_modules/@styled-system/flexbox/dist/index.esm.js");
/* harmony import */ var _styled_system_grid__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @styled-system/grid */ "../../../node_modules/@styled-system/grid/dist/index.esm.js");
/* harmony import */ var _styled_system_border__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @styled-system/border */ "../../../node_modules/@styled-system/border/dist/index.esm.js");
/* harmony import */ var _styled_system_background__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @styled-system/background */ "../../../node_modules/@styled-system/background/dist/index.esm.js");
/* harmony import */ var _styled_system_position__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @styled-system/position */ "../../../node_modules/@styled-system/position/dist/index.esm.js");
/* harmony import */ var _styled_system_space__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @styled-system/space */ "../../../node_modules/@styled-system/space/dist/index.esm.js");
/* harmony import */ var _styled_system_shadow__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @styled-system/shadow */ "../../../node_modules/@styled-system/shadow/dist/index.esm.js");
/* harmony import */ var _styled_system_variant__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @styled-system/variant */ "../../../node_modules/@styled-system/variant/dist/index.esm.js");
 // v4 api shims






















var width = _styled_system_layout__WEBPACK_IMPORTED_MODULE_1__["default"].width,
    height = _styled_system_layout__WEBPACK_IMPORTED_MODULE_1__["default"].height,
    minWidth = _styled_system_layout__WEBPACK_IMPORTED_MODULE_1__["default"].minWidth,
    minHeight = _styled_system_layout__WEBPACK_IMPORTED_MODULE_1__["default"].minHeight,
    maxWidth = _styled_system_layout__WEBPACK_IMPORTED_MODULE_1__["default"].maxWidth,
    maxHeight = _styled_system_layout__WEBPACK_IMPORTED_MODULE_1__["default"].maxHeight,
    size = _styled_system_layout__WEBPACK_IMPORTED_MODULE_1__["default"].size,
    verticalAlign = _styled_system_layout__WEBPACK_IMPORTED_MODULE_1__["default"].verticalAlign,
    display = _styled_system_layout__WEBPACK_IMPORTED_MODULE_1__["default"].display,
    overflow = _styled_system_layout__WEBPACK_IMPORTED_MODULE_1__["default"].overflow,
    overflowX = _styled_system_layout__WEBPACK_IMPORTED_MODULE_1__["default"].overflowX,
    overflowY = _styled_system_layout__WEBPACK_IMPORTED_MODULE_1__["default"].overflowY;
var opacity = _styled_system_color__WEBPACK_IMPORTED_MODULE_2__["default"].opacity;
var fontSize = _styled_system_typography__WEBPACK_IMPORTED_MODULE_3__["default"].fontSize,
    fontFamily = _styled_system_typography__WEBPACK_IMPORTED_MODULE_3__["default"].fontFamily,
    fontWeight = _styled_system_typography__WEBPACK_IMPORTED_MODULE_3__["default"].fontWeight,
    lineHeight = _styled_system_typography__WEBPACK_IMPORTED_MODULE_3__["default"].lineHeight,
    textAlign = _styled_system_typography__WEBPACK_IMPORTED_MODULE_3__["default"].textAlign,
    fontStyle = _styled_system_typography__WEBPACK_IMPORTED_MODULE_3__["default"].fontStyle,
    letterSpacing = _styled_system_typography__WEBPACK_IMPORTED_MODULE_3__["default"].letterSpacing;
var alignItems = _styled_system_flexbox__WEBPACK_IMPORTED_MODULE_4__["default"].alignItems,
    alignContent = _styled_system_flexbox__WEBPACK_IMPORTED_MODULE_4__["default"].alignContent,
    justifyItems = _styled_system_flexbox__WEBPACK_IMPORTED_MODULE_4__["default"].justifyItems,
    justifyContent = _styled_system_flexbox__WEBPACK_IMPORTED_MODULE_4__["default"].justifyContent,
    flexWrap = _styled_system_flexbox__WEBPACK_IMPORTED_MODULE_4__["default"].flexWrap,
    flexDirection = _styled_system_flexbox__WEBPACK_IMPORTED_MODULE_4__["default"].flexDirection,
    flex = _styled_system_flexbox__WEBPACK_IMPORTED_MODULE_4__["default"].flex,
    flexGrow = _styled_system_flexbox__WEBPACK_IMPORTED_MODULE_4__["default"].flexGrow,
    flexShrink = _styled_system_flexbox__WEBPACK_IMPORTED_MODULE_4__["default"].flexShrink,
    flexBasis = _styled_system_flexbox__WEBPACK_IMPORTED_MODULE_4__["default"].flexBasis,
    justifySelf = _styled_system_flexbox__WEBPACK_IMPORTED_MODULE_4__["default"].justifySelf,
    alignSelf = _styled_system_flexbox__WEBPACK_IMPORTED_MODULE_4__["default"].alignSelf,
    order = _styled_system_flexbox__WEBPACK_IMPORTED_MODULE_4__["default"].order;
var gridGap = _styled_system_grid__WEBPACK_IMPORTED_MODULE_5__["default"].gridGap,
    gridColumnGap = _styled_system_grid__WEBPACK_IMPORTED_MODULE_5__["default"].gridColumnGap,
    gridRowGap = _styled_system_grid__WEBPACK_IMPORTED_MODULE_5__["default"].gridRowGap,
    gridColumn = _styled_system_grid__WEBPACK_IMPORTED_MODULE_5__["default"].gridColumn,
    gridRow = _styled_system_grid__WEBPACK_IMPORTED_MODULE_5__["default"].gridRow,
    gridAutoFlow = _styled_system_grid__WEBPACK_IMPORTED_MODULE_5__["default"].gridAutoFlow,
    gridAutoColumns = _styled_system_grid__WEBPACK_IMPORTED_MODULE_5__["default"].gridAutoColumns,
    gridAutoRows = _styled_system_grid__WEBPACK_IMPORTED_MODULE_5__["default"].gridAutoRows,
    gridTemplateColumns = _styled_system_grid__WEBPACK_IMPORTED_MODULE_5__["default"].gridTemplateColumns,
    gridTemplateRows = _styled_system_grid__WEBPACK_IMPORTED_MODULE_5__["default"].gridTemplateRows,
    gridTemplateAreas = _styled_system_grid__WEBPACK_IMPORTED_MODULE_5__["default"].gridTemplateAreas,
    gridArea = _styled_system_grid__WEBPACK_IMPORTED_MODULE_5__["default"].gridArea;
var borderWidth = _styled_system_border__WEBPACK_IMPORTED_MODULE_6__["default"].borderWidth,
    borderStyle = _styled_system_border__WEBPACK_IMPORTED_MODULE_6__["default"].borderStyle,
    borderColor = _styled_system_border__WEBPACK_IMPORTED_MODULE_6__["default"].borderColor,
    borderTop = _styled_system_border__WEBPACK_IMPORTED_MODULE_6__["default"].borderTop,
    borderRight = _styled_system_border__WEBPACK_IMPORTED_MODULE_6__["default"].borderRight,
    borderBottom = _styled_system_border__WEBPACK_IMPORTED_MODULE_6__["default"].borderBottom,
    borderLeft = _styled_system_border__WEBPACK_IMPORTED_MODULE_6__["default"].borderLeft,
    borderRadius = _styled_system_border__WEBPACK_IMPORTED_MODULE_6__["default"].borderRadius;
var backgroundImage = _styled_system_background__WEBPACK_IMPORTED_MODULE_7__["default"].backgroundImage,
    backgroundSize = _styled_system_background__WEBPACK_IMPORTED_MODULE_7__["default"].backgroundSize,
    backgroundPosition = _styled_system_background__WEBPACK_IMPORTED_MODULE_7__["default"].backgroundPosition,
    backgroundRepeat = _styled_system_background__WEBPACK_IMPORTED_MODULE_7__["default"].backgroundRepeat;
var zIndex = _styled_system_position__WEBPACK_IMPORTED_MODULE_8__["default"].zIndex,
    top = _styled_system_position__WEBPACK_IMPORTED_MODULE_8__["default"].top,
    right = _styled_system_position__WEBPACK_IMPORTED_MODULE_8__["default"].right,
    bottom = _styled_system_position__WEBPACK_IMPORTED_MODULE_8__["default"].bottom,
    left = _styled_system_position__WEBPACK_IMPORTED_MODULE_8__["default"].left;

 // v4 style API shim

var style = function style(_ref) {
  var prop = _ref.prop,
      cssProperty = _ref.cssProperty,
      alias = _ref.alias,
      key = _ref.key,
      transformValue = _ref.transformValue,
      scale = _ref.scale,
      properties = _ref.properties;
  var config = {};
  config[prop] = (0,_styled_system_core__WEBPACK_IMPORTED_MODULE_0__.createStyleFunction)({
    properties: properties,
    property: cssProperty || prop,
    scale: key,
    defaultScale: scale,
    transform: transformValue
  });
  if (alias) config[alias] = config[prop];
  var parse = (0,_styled_system_core__WEBPACK_IMPORTED_MODULE_0__.createParser)(config);
  return parse;
};


/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_primer_react_lib-esm_Dialog_ConfirmationDialog_js-node_modules_primer_re-3b6f8e.c45a2c94c6a5220a95b3.js.map