/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.version;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.OptionPrint;
import net.sourceforge.plantuml.PlainStringsDiagram;
import net.sourceforge.plantuml.Run;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizUtils;
import net.sourceforge.plantuml.dedication.PSystemDedication;
import net.sourceforge.plantuml.graphic.GraphicPosition;
import net.sourceforge.plantuml.preproc.Stdlib;
import net.sourceforge.plantuml.preproc2.PreprocessorUtils;
import net.sourceforge.plantuml.security.ImageIO;
import net.sourceforge.plantuml.security.SFile;
import net.sourceforge.plantuml.security.SecurityProfile;
import net.sourceforge.plantuml.security.SecurityUtils;
import net.sourceforge.plantuml.svek.GraphvizCrash;
import net.sourceforge.plantuml.version.License;
import net.sourceforge.plantuml.version.LicenseInfo;
import net.sourceforge.plantuml.version.Version;

public class PSystemVersion
extends PlainStringsDiagram {
    private static BufferedImage transparentIcon;

    PSystemVersion(UmlSource source, boolean withImage, List<String> args) {
        super(source);
        this.strings.addAll(args);
        if (withImage) {
            this.image = PSystemVersion.getPlantumlImage();
            this.imagePosition = GraphicPosition.BACKGROUND_CORNER_BOTTOM_RIGHT;
        }
    }

    private PSystemVersion(UmlSource source, List<String> args, BufferedImage image) {
        super(source);
        this.strings.addAll(args);
        this.image = image;
        this.imagePosition = GraphicPosition.BACKGROUND_CORNER_BOTTOM_RIGHT;
    }

    public static BufferedImage getPlantumlImage() {
        return PSystemVersion.getImage("logo.png");
    }

    public static BufferedImage getCharlieImage() {
        return PSystemVersion.getImage("charlie.png");
    }

    public static BufferedImage getTime01() {
        return PSystemVersion.getImage("time01.png");
    }

    public static BufferedImage getTime15() {
        return PSystemVersion.getImage("time15.png");
    }

    public static BufferedImage getPlantumlSmallIcon() {
        return PSystemVersion.getImage("favicon.png");
    }

    public static BufferedImage getArecibo() {
        return PSystemVersion.getImage("arecibo.png");
    }

    public static BufferedImage getDotc() {
        return PSystemVersion.getImage("dotc.png");
    }

    public static BufferedImage getDotd() {
        return PSystemVersion.getImage("dotd.png");
    }

    public static BufferedImage getApple2Image() {
        return PSystemVersion.getImageWebp("apple2.png");
    }

    private static BufferedImage getImage(String name) {
        try {
            InputStream is = PSystemVersion.class.getResourceAsStream(name);
            BufferedImage image = ImageIO.read(is);
            is.close();
            return image;
        }
        catch (IOException e) {
            e.printStackTrace();
            return new BufferedImage(10, 10, 2);
        }
    }

    private static BufferedImage getImageWebp(String name) {
        BufferedImage bufferedImage;
        block8: {
            InputStream is = PSystemVersion.class.getResourceAsStream(name);
            try {
                bufferedImage = PSystemDedication.getBufferedImage(is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return new BufferedImage(10, 10, 2);
                }
            }
            is.close();
        }
        return bufferedImage;
    }

    public static BufferedImage getPlantumlSmallIcon2() {
        if (transparentIcon != null) {
            return transparentIcon;
        }
        BufferedImage ico = PSystemVersion.getPlantumlSmallIcon();
        if (ico == null) {
            return new BufferedImage(10, 10, 2);
        }
        transparentIcon = new BufferedImage(ico.getWidth(), ico.getHeight(), 3);
        for (int i = 0; i < ico.getWidth(); ++i) {
            for (int j = 0; j < ico.getHeight(); ++j) {
                int col = ico.getRGB(i, j);
                if (col == ico.getRGB(0, 0)) continue;
                transparentIcon.setRGB(i, j, col);
            }
        }
        return transparentIcon;
    }

    public static PSystemVersion createShowVersion2(UmlSource source) {
        ArrayList<String> strings = new ArrayList<String>();
        strings.add("<b>PlantUML version " + Version.versionString() + "</b> (" + Version.compileTimeString() + ")");
        strings.add("(" + (Object)((Object)License.getCurrent()) + " source distribution)");
        GraphvizCrash.checkOldVersionWarning(strings);
        if (OptionFlags.ALLOW_INCLUDE) {
            if (SecurityUtils.getSecurityProfile() == SecurityProfile.UNSECURE) {
                strings.add("Loaded from " + Version.getJarPath());
            }
            if (OptionFlags.getInstance().isWord()) {
                strings.add("Word Mode");
                strings.add("Command Line: " + Run.getCommandLine());
                strings.add("Current Dir: " + new SFile(".").getAbsolutePath());
                strings.add("plantuml.include.path: " + PreprocessorUtils.getenv("plantuml.include.path"));
            }
        }
        strings.add(" ");
        GraphvizUtils.addDotStatus(strings, true);
        strings.add(" ");
        for (String name : OptionPrint.interestingProperties()) {
            strings.add(name);
        }
        for (String v : OptionPrint.interestingValues()) {
            strings.add(v);
        }
        return new PSystemVersion(source, true, strings);
    }

    public static PSystemVersion createStdLib(UmlSource source) {
        ArrayList<String> strings = new ArrayList<String>();
        Stdlib.addInfoVersion(strings, true);
        strings.add(" ");
        return new PSystemVersion(source, true, strings);
    }

    public static PSystemVersion createShowAuthors2(UmlSource source) {
        List<String> strings = PSystemVersion.getAuthorsStrings(true);
        return new PSystemVersion(source, true, strings);
    }

    public static List<String> getAuthorsStrings(boolean withTag) {
        ArrayList<String> strings = new ArrayList<String>();
        PSystemVersion.add(strings, "<b>PlantUML version " + Version.versionString() + "</b> (" + Version.compileTimeString() + ")", withTag);
        PSystemVersion.add(strings, "(" + (Object)((Object)License.getCurrent()) + " source distribution)", withTag);
        PSystemVersion.add(strings, " ", withTag);
        PSystemVersion.add(strings, "<u>Original idea</u>: Arnaud Roques", withTag);
        PSystemVersion.add(strings, "<u>Word Macro</u>: Alain Bertucat & Matthieu Sabatier", withTag);
        PSystemVersion.add(strings, "<u>Word Add-in</u>: Adriaan van den Brand", withTag);
        PSystemVersion.add(strings, "<u>J2V8 & viz.js integration</u>: Andreas Studer", withTag);
        PSystemVersion.add(strings, "<u>Official Eclipse Plugin</u>: Hallvard Tr\u00e6tteberg", withTag);
        PSystemVersion.add(strings, "<u>Original Eclipse Plugin</u>: Claude Durif & Anne Pecoil", withTag);
        PSystemVersion.add(strings, "<u>Servlet & XWiki</u>: Maxime Sinclair", withTag);
        PSystemVersion.add(strings, "<u>Docker</u>: David Ducatel", withTag);
        PSystemVersion.add(strings, "<u>AWS lib</u>: Chris Passarello", withTag);
        PSystemVersion.add(strings, "<u>Stdlib Icons</u>: tupadr3", withTag);
        PSystemVersion.add(strings, "<u>Site design</u>: Raphael Cotisson", withTag);
        PSystemVersion.add(strings, "<u>Logo</u>: Benjamin Croizet", withTag);
        PSystemVersion.add(strings, " ", withTag);
        PSystemVersion.add(strings, "https://plantuml.com", withTag);
        PSystemVersion.add(strings, " ", withTag);
        return strings;
    }

    private static void add(List<String> result, String s, boolean withTag) {
        if (!withTag) {
            s = s.replaceAll("\\</?\\w+\\>", "");
        }
        result.add(s);
    }

    public static PSystemVersion createTestDot(UmlSource source) throws IOException {
        ArrayList<String> strings = new ArrayList<String>();
        strings.add(Version.fullDescription());
        GraphvizUtils.addDotStatus(strings, true);
        return new PSystemVersion(source, false, strings);
    }

    public static PSystemVersion createKeyDistributor(UmlSource source) throws IOException {
        LicenseInfo license = LicenseInfo.retrieveDistributor();
        BufferedImage im = null;
        ArrayList<String> strings = new ArrayList<String>();
        if (license == null) {
            strings.add("No license found");
        } else {
            strings.add(license.getOwner());
            strings.add(license.getContext());
            strings.add(license.getGenerationDate().toString());
            strings.add(license.getExpirationDate().toString());
            im = LicenseInfo.retrieveDistributorImage(license);
        }
        return new PSystemVersion(source, strings, im);
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(Version)");
    }

    public List<String> getLines() {
        return Collections.unmodifiableList(this.strings);
    }
}

