/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.tikz;

import java.awt.font.TextLayout;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.UnusedSpace;
import net.sourceforge.plantuml.tikz.TikzGraphics;
import net.sourceforge.plantuml.ugraphic.UCenteredCharacter;
import net.sourceforge.plantuml.ugraphic.UDriver;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.color.ColorMapper;

public class DriverCenteredCharacterTikz
implements UDriver<TikzGraphics> {
    @Override
    public void draw(UShape ushape, double x, double y, ColorMapper mapper, UParam param, TikzGraphics tikz) {
        UCenteredCharacter centeredCharacter = (UCenteredCharacter)ushape;
        char c = centeredCharacter.getChar();
        UFont font = centeredCharacter.getFont();
        UnusedSpace unusedSpace = UnusedSpace.getUnusedSpace(font, c);
        double xpos = x - unusedSpace.getCenterX() - 0.5;
        double ypos = y - unusedSpace.getCenterY() - 0.5;
        TextLayout t = TextBlockUtils.createTextLayout(font, "" + c);
        tikz.setStrokeColor(mapper.toColor(param.getColor()));
        tikz.drawPathIterator(xpos, ypos, t.getOutline(null).getPathIterator(null));
    }
}

