/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.g2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import net.sourceforge.plantuml.EnsureVisible;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.FontStyle;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.text.StyledString;
import net.sourceforge.plantuml.ugraphic.UDriver;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.UText;
import net.sourceforge.plantuml.ugraphic.color.ColorMapper;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorGradient;
import net.sourceforge.plantuml.ugraphic.color.HColorUtils;
import net.sourceforge.plantuml.ugraphic.g2d.DriverRectangleG2d;

public class DriverTextG2d
implements UDriver<Graphics2D> {
    private final EnsureVisible visible;
    private final StringBounder stringBounder;

    public DriverTextG2d(EnsureVisible visible, StringBounder stringBounder) {
        this.visible = visible;
        this.stringBounder = stringBounder;
    }

    @Override
    public void draw(UShape ushape, double x, double y, ColorMapper mapper, UParam param, Graphics2D g2d) {
        UText shape = (UText)ushape;
        FontConfiguration fontConfiguration = shape.getFontConfiguration();
        if (HColorUtils.isTransparent(fontConfiguration.getColor())) {
            return;
        }
        String text = shape.getText();
        List<StyledString> strings = StyledString.build(text);
        for (StyledString styledString : strings) {
            FontConfiguration fc = styledString.getStyle() == FontStyle.BOLD ? fontConfiguration.bold() : fontConfiguration;
            x += this.printSingleText(g2d, fc, styledString.getText(), x, y, mapper);
        }
    }

    private double printSingleText(Graphics2D g2d, FontConfiguration fontConfiguration, String text, double x, double y, ColorMapper mapper) {
        UFont font = fontConfiguration.getFont();
        HColor extended = fontConfiguration.getExtendedColor();
        Dimension2D dim = this.stringBounder.calculateDimension(font, text);
        double height = Math.max(10.0, dim.getHeight());
        double width = dim.getWidth();
        boolean orientation = false;
        if (fontConfiguration.containsStyle(FontStyle.BACKCOLOR)) {
            Rectangle2D.Double area = new Rectangle2D.Double(x, y - height + 1.5, width, height);
            if (extended instanceof HColorGradient) {
                GradientPaint paint = DriverRectangleG2d.getPaintGradient(x, y, mapper, width, height, extended);
                g2d.setPaint(paint);
                g2d.fill(area);
            } else {
                Color backColor = mapper.toColor(extended);
                if (backColor != null) {
                    g2d.setColor(backColor);
                    g2d.setBackground(backColor);
                    g2d.fill(area);
                }
            }
        }
        this.visible.ensureVisible(x, y - height + 1.5);
        this.visible.ensureVisible(x + width, y + 1.5);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.setFont(font.getUnderlayingFont());
        g2d.setColor(mapper.toColor(fontConfiguration.getColor()));
        g2d.drawString(text, (float)x, (float)y);
        if (fontConfiguration.containsStyle(FontStyle.UNDERLINE)) {
            if (extended != null) {
                g2d.setColor(mapper.toColor(extended));
            }
            int ypos = (int)(y + 2.5);
            g2d.setStroke(new BasicStroke(1.0f));
            g2d.drawLine((int)x, ypos, (int)(x + width), ypos);
            g2d.setStroke(new BasicStroke());
        }
        if (fontConfiguration.containsStyle(FontStyle.WAVE)) {
            int ypos = (int)(y + 2.5) - 1;
            if (extended != null) {
                g2d.setColor(mapper.toColor(extended));
            }
            int i = (int)x;
            while ((double)i < x + width - 5.0) {
                g2d.drawLine(i, ypos - 0, i + 3, ypos + 1);
                g2d.drawLine(i + 3, ypos + 1, i + 6, ypos - 0);
                i += 6;
            }
        }
        if (fontConfiguration.containsStyle(FontStyle.STRIKE)) {
            FontMetrics fm = g2d.getFontMetrics(font.getUnderlayingFont());
            int ypos = (int)(y - (double)fm.getDescent() - 0.5);
            if (extended != null) {
                g2d.setColor(mapper.toColor(extended));
            }
            g2d.setStroke(new BasicStroke(1.5f));
            g2d.drawLine((int)x, ypos, (int)(x + width), ypos);
            g2d.setStroke(new BasicStroke());
        }
        return width;
    }
}

