/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.eps;

import java.awt.Color;
import java.awt.Shape;
import java.awt.font.TextLayout;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.eps.EpsGraphics;
import net.sourceforge.plantuml.eps.EpsGraphicsMacroAndText;
import net.sourceforge.plantuml.eps.EpsStrategy;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.FontStyle;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.ugraphic.ClipContainer;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UClip;
import net.sourceforge.plantuml.ugraphic.UDriver;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.UText;
import net.sourceforge.plantuml.ugraphic.color.ColorMapper;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorUtils;
import net.sourceforge.plantuml.ugraphic.eps.PathIteratorLimited;

public class DriverTextEps
implements UDriver<EpsGraphics> {
    private final ClipContainer clipContainer;
    private final EpsStrategy strategy;

    public DriverTextEps(ClipContainer clipContainer, EpsStrategy strategy) {
        this.clipContainer = clipContainer;
        this.strategy = strategy;
    }

    @Override
    public void draw(UShape ushape, double x, double y, ColorMapper mapper, UParam param, EpsGraphics eps) {
        Object extended;
        UClip clip = this.clipContainer.getClip();
        if (clip != null && !clip.isInside(x, y)) {
            return;
        }
        UText shape = (UText)ushape;
        FontConfiguration fontConfiguration = shape.getFontConfiguration();
        if (HColorUtils.isTransparent(fontConfiguration.getColor())) {
            return;
        }
        if (this.strategy == EpsStrategy.WITH_MACRO_AND_TEXT) {
            this.drawAsText(shape, x, y, param, eps, mapper);
            return;
        }
        TextLayout textLayout = TextBlockUtils.createTextLayout(shape);
        MinMax dim = null;
        if (fontConfiguration.containsStyle(FontStyle.BACKCOLOR) && (extended = mapper.toColor(fontConfiguration.getExtendedColor())) != null) {
            eps.setStrokeColor((Color)extended);
            eps.setFillColor((Color)extended);
            eps.setStrokeWidth(1.0, 0.0, 0.0);
            if (dim == null) {
                dim = DriverTextEps.getMinMax(x, y, this.getOutline(textLayout).getPathIterator(null));
            }
            eps.epsRectangle(dim.getMinX() - 1.0, dim.getMinY() - 1.0, dim.getWidth() + 2.0, dim.getHeight() + 2.0, 0.0, 0.0);
        }
        eps.setStrokeColor(mapper.toColor(fontConfiguration.getColor()));
        DriverTextEps.drawPathIterator(eps, x, y, this.getOutline(textLayout));
        if (fontConfiguration.containsStyle(FontStyle.UNDERLINE)) {
            extended = fontConfiguration.getExtendedColor();
            if (extended != null) {
                eps.setStrokeColor(mapper.toColor((HColor)extended));
            }
            if (dim == null) {
                dim = DriverTextEps.getMinMax(x, y, this.getOutline(textLayout).getPathIterator(null));
            }
            eps.setStrokeWidth(1.1, 0.0, 0.0);
            eps.epsLine(x, y + 1.5, x + dim.getWidth(), y + 1.5);
            eps.setStrokeWidth(1.0, 0.0, 0.0);
        }
        if (fontConfiguration.containsStyle(FontStyle.WAVE)) {
            if (dim == null) {
                dim = DriverTextEps.getMinMax(x, y, this.getOutline(textLayout).getPathIterator(null));
            }
            int ypos = (int)(y + 2.5) - 1;
            HColor extended2 = fontConfiguration.getExtendedColor();
            if (extended2 != null) {
                eps.setStrokeColor(mapper.toColor(extended2));
            }
            eps.setStrokeWidth(1.1, 0.0, 0.0);
            int i = (int)x;
            while ((double)i < x + dim.getWidth() - 5.0) {
                eps.epsLine(i, ypos - 0, i + 3, ypos + 1);
                eps.epsLine(i + 3, ypos + 1, i + 6, ypos - 0);
                i += 6;
            }
            eps.setStrokeWidth(1.0, 0.0, 0.0);
        }
        if (fontConfiguration.containsStyle(FontStyle.STRIKE)) {
            HColor extended3 = fontConfiguration.getExtendedColor();
            if (extended3 != null) {
                eps.setStrokeColor(mapper.toColor(extended3));
            }
            if (dim == null) {
                dim = DriverTextEps.getMinMax(x, y, this.getOutline(textLayout).getPathIterator(null));
            }
            double ypos = (dim.getMinY() + dim.getMaxY() * 2.0) / 3.0;
            eps.setStrokeWidth(1.3, 0.0, 0.0);
            eps.epsLine(x, ypos, x + dim.getWidth(), ypos);
            eps.setStrokeWidth(1.0, 0.0, 0.0);
        }
    }

    private Shape getOutline(TextLayout textLayout) {
        return textLayout.getOutline(null);
    }

    private void drawAsText(UText shape, double x, double y, UParam param, EpsGraphics eps, ColorMapper mapper) {
        FontConfiguration fontConfiguration = shape.getFontConfiguration();
        double ypos = y - 1.0;
        eps.setStrokeColor(mapper.toColor(fontConfiguration.getColor()));
        ((EpsGraphicsMacroAndText)eps).drawText(shape.getText(), fontConfiguration, x, ypos);
    }

    static void drawPathIterator(EpsGraphics eps, double x, double y, Shape shape) {
        List<Integer> breaks = DriverTextEps.analyze(shape);
        if (breaks.size() == 0) {
            PathIterator path = shape.getPathIterator(null);
            DriverTextEps.drawSingle(eps, x, y, path);
            return;
        }
        PathIteratorLimited path = new PathIteratorLimited(shape, 0, breaks.get(0));
        DriverTextEps.drawSingle(eps, x, y, path);
        for (int i = 0; i < breaks.size() - 1; ++i) {
            PathIteratorLimited path2 = new PathIteratorLimited(shape, breaks.get(i) + 1, breaks.get(i + 1));
            DriverTextEps.drawSingle(eps, x, y, path2);
        }
        PathIteratorLimited path3 = new PathIteratorLimited(shape, breaks.get(breaks.size() - 1) + 1, Integer.MAX_VALUE);
        DriverTextEps.drawSingle(eps, x, y, path3);
    }

    private static void drawSingle(EpsGraphics eps, double x, double y, PathIterator path) {
        eps.newpath();
        double[] coord = new double[6];
        while (!path.isDone()) {
            int code = path.currentSegment(coord);
            if (code == 0) {
                eps.moveto(coord[0] + x, coord[1] + y);
            } else if (code == 1) {
                eps.lineto(coord[0] + x, coord[1] + y);
            } else if (code == 4) {
                eps.closepath();
            } else if (code == 3) {
                eps.curveto(coord[0] + x, coord[1] + y, coord[2] + x, coord[3] + y, coord[4] + x, coord[5] + y);
            } else if (code == 2) {
                eps.quadto(coord[0] + x, coord[1] + y, coord[2] + x, coord[3] + y);
            } else {
                throw new UnsupportedOperationException("code=" + code);
            }
            path.next();
        }
        eps.fill(path.getWindingRule());
    }

    private static List<Integer> analyze(Shape shape) {
        int count = PathIteratorLimited.count(shape);
        List<Integer> closings = DriverTextEps.getClosings(shape.getPathIterator(null));
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (Integer cl : closings) {
            if (cl + 2 >= count) break;
            PathIteratorLimited path1 = new PathIteratorLimited(shape, 0, cl);
            PathIteratorLimited path2 = new PathIteratorLimited(shape, cl + 1, Integer.MAX_VALUE);
            double max1 = DriverTextEps.getMinMax(0.0, 0.0, path1).getMaxX();
            double min2 = DriverTextEps.getMinMax(0.0, 0.0, path2).getMinX();
            if (!(min2 > max1)) continue;
            result.add(cl);
        }
        return result;
    }

    private static List<Integer> getClosings(PathIterator path) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        int current = 0;
        double[] coord = new double[6];
        while (!path.isDone()) {
            int code = path.currentSegment(coord);
            if (code == 4) {
                result.add(current);
            }
            ++current;
            path.next();
        }
        return result;
    }

    private static MinMax getMinMax(double x, double y, PathIterator path) {
        MinMax result = MinMax.getEmpty(false);
        double[] coord = new double[6];
        while (!path.isDone()) {
            int code = path.currentSegment(coord);
            if (code == 0) {
                result = result.addPoint(coord[0] + x, coord[1] + y);
            } else if (code == 1) {
                result = result.addPoint(coord[0] + x, coord[1] + y);
            } else if (code != 4) {
                if (code == 3) {
                    result = result.addPoint(coord[0] + x, coord[1] + y);
                    result = result.addPoint(coord[2] + x, coord[3] + y);
                    result = result.addPoint(coord[4] + x, coord[5] + y);
                } else if (code == 2) {
                    result = result.addPoint(coord[0] + x, coord[1] + y);
                    result = result.addPoint(coord[2] + x, coord[3] + y);
                } else {
                    throw new UnsupportedOperationException("code=" + code);
                }
            }
            path.next();
        }
        return result;
    }
}

