/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.MinMaxMutable;
import net.sourceforge.plantuml.ugraphic.UBackground;
import net.sourceforge.plantuml.ugraphic.UChange;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UGraphicNo;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UText;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.utils.ObjectUtils;

public class TextLimitFinder
extends UGraphicNo {
    private final MinMaxMutable minmax;

    @Override
    public UGraphic apply(UChange change) {
        return new TextLimitFinder(this, change);
    }

    public TextLimitFinder(StringBounder stringBounder, boolean initToZero) {
        super(stringBounder);
        this.minmax = MinMaxMutable.getEmpty(initToZero);
    }

    private TextLimitFinder(TextLimitFinder other, UChange change) {
        super(other, change);
        if (!ObjectUtils.instanceOfAny(change, UBackground.class, HColor.class, UStroke.class, UTranslate.class)) {
            throw new UnsupportedOperationException(change.getClass().toString());
        }
        this.minmax = other.minmax;
    }

    @Override
    public void draw(UShape shape) {
        if (shape instanceof UText) {
            double x = this.getTranslate().getDx();
            double y = this.getTranslate().getDy();
            this.drawText(x, y, (UText)shape);
        }
    }

    private void drawText(double x, double y, UText text) {
        Dimension2D dim = this.getStringBounder().calculateDimension(text.getFontConfiguration().getFont(), text.getText());
        this.minmax.addPoint(x, y -= dim.getHeight() - 1.5);
        this.minmax.addPoint(x, y + dim.getHeight());
        this.minmax.addPoint(x + dim.getWidth(), y);
        this.minmax.addPoint(x + dim.getWidth(), y + dim.getHeight());
    }

    public double getMaxX() {
        return this.minmax.getMaxX();
    }

    public double getMaxY() {
        return this.minmax.getMaxY();
    }

    public double getMinX() {
        return this.minmax.getMinX();
    }

    public double getMinY() {
        return this.minmax.getMinY();
    }
}

